/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.MeasurableServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StatisticsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlStepReader;
import org.ovirt.engine.sdk4.services.StatisticsService;
import org.ovirt.engine.sdk4.services.StepService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Step;

public class StepServiceImpl
extends MeasurableServiceImpl
implements StepService {
    public StepServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StepService.EndRequest end() {
        return new EndRequestImpl();
    }

    @Override
    public StepService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public StatisticsService statisticsService() {
        return new StatisticsServiceImpl(this.getConnection(), this.getPath() + "/statistics");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("statistics")) {
            return this.statisticsService();
        }
        if (path.startsWith("statistics/")) {
            return this.statisticsService().service(path.substring(11));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "StepService:" + this.getPath();
    }

    private class GetResponseImpl
    implements StepService.GetResponse {
        private Step step;

        private GetResponseImpl() {
        }

        public void step(Step step) {
            this.step = step;
        }

        @Override
        public Step step() {
            return this.step;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<StepService.GetRequest, StepService.GetResponse>
    implements StepService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public StepService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StepService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StepServiceImpl.this.getConnection().getUrl() + StepServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StepServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.step(XmlStepReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StepServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class EndResponseImpl
    implements StepService.EndResponse {
        private EndResponseImpl() {
        }
    }

    private class EndRequestImpl
    extends BaseRequest<StepService.EndRequest, StepService.EndResponse>
    implements StepService.EndRequest {
        private Boolean async;
        private Boolean force;
        private Boolean succeeded;

        private EndRequestImpl() {
        }

        @Override
        public StepService.EndRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StepService.EndRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public StepService.EndRequest succeeded(Boolean succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        @Override
        public StepService.EndResponse send() {
            HttpPost request = new HttpPost(StepServiceImpl.this.getConnection().getUrl() + StepServiceImpl.this.getPath() + "/end");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.force(this.force);
                action.succeeded(this.succeeded);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = StepServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = StepServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new EndResponseImpl();
        }
    }
}

