/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlSystemOptionReader;
import org.ovirt.engine.sdk4.services.SystemOptionService;
import org.ovirt.engine.sdk4.types.SystemOption;

public class SystemOptionServiceImpl
extends ServiceImpl
implements SystemOptionService {
    public SystemOptionServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public SystemOptionService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "SystemOptionService:" + this.getPath();
    }

    private class GetResponseImpl
    implements SystemOptionService.GetResponse {
        private SystemOption option;

        private GetResponseImpl() {
        }

        public void option(SystemOption option) {
            this.option = option;
        }

        @Override
        public SystemOption option() {
            return this.option;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<SystemOptionService.GetRequest, SystemOptionService.GetResponse>
    implements SystemOptionService.GetRequest {
        private String version;

        private GetRequestImpl() {
        }

        @Override
        public SystemOptionService.GetRequest version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public SystemOptionService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SystemOptionServiceImpl.this.getConnection().getUrl() + SystemOptionServiceImpl.this.getPath());
                if (this.version != null) {
                    uriBuilder.addParameter("version", XmlWriter.renderString(this.version));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SystemOptionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.option(XmlSystemOptionReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SystemOptionServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

