package org.ovirt.engine.core.common.errors;


public enum EngineMessage {
    Unassigned,
    VAR__TYPE__HOST,
    VAR__ENTITIES__HOSTS,
    VAR__ENTITIES__HOST,
    VAR__ENTITIES__CLUSTERS,
    VAR__TYPE__VM,
    VAR__ENTITIES__VMS,
    VAR__ENTITIES__VM,
    VAR__ENTITIES__GLUSTER_BRICKS,
    VAR__ENTITIES__GLUSTER_BRICK,
    VAR__TYPE__QUOTA,
    VAR__TYPE__VM__CLUSTER,
    VAR__TYPE__VM_BACKUP,
    VAR__TYPE__VM_TEMPLATE,
    VAR__ENTITIES__VM_TEMPLATES,
    VAR__ENTITIES__VM_TEMPLATE,
    VAR__ENTITIES__DISKS,
    VAR__TYPE__SNAPSHOT,
    VAR__TYPE__DESKTOP_POOL,
    VAR__TYPE__VM_FROM_VM_POOL,
    VAR__TYPE__COMPUTER_ACCOUNT,
    VAR__TYPE__CLUSTER,
    VAR__TYPE__ROLE,
    VAR__TYPE__INTERFACE,
    VAR__TYPE__NETWORK,
    VAR__TYPE__NETWORKS,
    VAR__TYPE__VNIC_PROFILE,
    VAR__TYPE__LABEL,
    VAR__TYPE__HOST_NIC_VFS_CONFIG,
    VAR__TYPE__HOST_NIC_VFS_CONFIG_NETWORK,
    VAR__TYPE__HOST_NIC_VFS_CONFIG_LABEL,
    VAR__TYPE__PROVIDER,
    VAR__TYPE__PROVIDER_CERTIFICATE,
    VAR__TYPE__DISK,
    VAR__TYPE__LUNS,
    VAR__TYPE__BOOKMARK,
    VAR__TYPE__VM_TICKET,
    VAR__TYPE__PERMISSION,
    VAR__TYPE__HOST_CAPABILITIES,
    VAR__TYPE__HOST_DEVICES,
    VAR__TYPE__NETWORK_QOS,
    VAR__TYPE__QOS,
    VAR__TYPE__SPM,
    VAR__TYPE__CLUSTER_POLICY,
    VAR__TYPE__POLICY_UNIT,
    VAR__TYPE__SUBNET,
    VAR__TYPE__AFFINITY_GROUP,
    VAR__TYPE__ISCSI_BOND,
    VAR__TYPE__DISK__SNAPSHOT,
    VAR__TYPE__DISK_PROFILE,
    VAR__TYPE__CPU_PROFILE,
    VAR__TYPE__USER_PROFILE_PROPERTY,
    VAR__TYPE__AUTHENTICATION_KEY,
    VAR__TYPE__MEMORY_DEVICE,
    VAR__TYPE__NIC_FILTER_PARAMETER,
    VAR_TYPE_FENCE_AGENT,

    // Gluster types
    VAR__TYPE__GLUSTER_VOLUME,
    VAR__TYPE__GLUSTER_VOLUME_OPTION,
    VAR__TYPE__GLUSTER_BRICK,
    VAR__TYPE__GLUSTER_SERVER,
    VAR__TYPE__GLUSTER_HOOK,
    VAR__TYPE__GLUSTER_SERVICE,
    VAR__TYPE__GLUSTER_GEOREP_SESSION,
    VAR__TYPE__GLUSTER_GEOREP_CONFIG,
    VAR__TYPE__GLUSTER_VOLUME_SNAPSHOT,
    VAR__TYPE__GLUSTER_VOLUME_SNAPSHOT_CONFIG,
    VAR__TYPE__STORAGE_DEVICE,
    VAR__TYPE__GEOREP_MOUNT_BROKER,
    VAR__TYPE__STORAGE_DOMAIN_DR,
    VAR__TYPE__GLUSTER_WEBHOOK,

    // External Event
    VAR__TYPE__EXTERNAL_EVENT,

    // External Tasks
    VAR__TYPE__EXTERNAL_JOB,
    VAR__TYPE__EXTERNAL_STEP,

    VAR__ACTION__RUN,
    VAR__ACTION__REMOVE,
    VAR__ACTION__ADD,
    VAR__ACTION__UPDATE,
    VAR__ACTION__UPDATE_OVFS,
    VAR__ACTION__CREATE,
    VAR__ACTION__PAUSE,
    VAR__ACTION__HIBERNATE,
    VAR__ACTION__MIGRATE,
    VAR__ACTION__CANCEL_MIGRATE,
    VAR__ACTION__CANCEL_CONVERSION,
    VAR__ACTION__ATTACH_DESKTOP_TO,
    VAR__ACTION__REVERT_TO,
    VAR__ACTION__PREVIEW,
    VAR__ACTION__STOP,
    VAR__ACTION__START,
    VAR__ACTION__RESUME,
    VAR__ACTION__RESTART,
    VAR__ACTION__SHUTDOWN,
    VAR__ACTION__EXPORT,
    VAR__ACTION__EXTEND,
    VAR__ACTION__IMPORT,
    VAR__ACTION__ATTACH_ACTION_TO,
    VAR__ACTION__DETACH_ACTION_TO,
    VAR__ACTION__MOVE,
    VAR__ACTION__COPY,
    VAR__ACTION__CHANGE_CD,
    VAR__ACTION__EJECT_CD,
    VAR__ACTION__ALLOCATE_AND_RUN,
    VAR__ACTION__SET,
    VAR__ACTION__SETUP,
    VAR__ACTION__RESET,
    VAR__ACTION__HOT_PLUG,
    VAR__ACTION__HOT_UNPLUG,
    VAR__ACTION__LOGON,
    VAR__ACTION__LOGOFF,
    VAR__ACTION__REBALANCE_START,
    VAR__ACTION__REBALANCE_STOP,
    VAR__ACTION__REMOVE_BRICKS_START,
    VAR__ACTION__ASSIGN,
    VAR__ACTION__START_PROFILE,
    VAR__ACTION__STOP_PROFILE,
    VAR__ACTION__ENABLE,
    VAR__ACTION__DISABLE,
    VAR__ACTION__REFRESH,
    VAR__ACTION__END,
    VAR__ACTION__CLEAR,
    VAR__ACTION__FORCE_SELECT,
    VAR__ACTION__SWITCH_MASTER,
    VAR__ACTION__EXTEND_IMAGE_SIZE,
    VAR__ACTION__REMOVE_BRICKS_STOP,
    VAR__ACTION__REMOVE_BRICKS_COMMIT,
    VAR__ACTION__HOT_SET_CPUS,
    VAR__ACTION__UPDATE_SLA_POLICY,
    VAR__ACTION__UPDATE_VM_VERSION,
    VAR__ACTION__VOLUME_SNAPSHOT_CONFIG_UPDATE,
    VAR__ACTION__SYNC,
    VAR__ACTION__WRITE_PUB_KEYS,
    VAR__ACTION__REGISTER,
    VAR__ACTION__UPGRADE,
    VAR__ACTION__UPGRADE__CHECK,
    VAR__ACTION__INSTALL,
    VAR__ACTION__ENROLL_CERTIFICATE,
    VAR__ACTION__HOT_SET_MEMORY,
    VAR__ACTION__FREEZE,
    VAR__ACTION__THAW,
    VAR__ACTION__SPARSIFY,
    VAR__ACTION__AMEND,
    VAR__ACTION__SEAL,
    VAR__ACTION__SCHEDULE,
    VAR__ACTION__TRANSFER,
    VAR__ACTION__BACKUP,
    VAR__ACTION__CHECKPOINT,
    VAR__ACTION__SCRATCH_DISK,
    VAR__ACTION__REPLACE_GLUSTER_BRICK,
    VAR__ACTION__RESET_GLUSTER_BRICK,
    VAR__ACTION__COPY_NETWORKS,

    // Host statuses replacements
    VAR__HOST_STATUS__UP,
    VAR__HOST_STATUS__UP_MAINTENANCE_OR_NON_OPERATIONAL,

    VAR__VM_STATUS__UP,
    VAR__VM_STATUS__UNASSIGNED,
    VAR__VM_STATUS__DOWN,
    VAR__VM_STATUS__POWERING_UP,
    VAR__VM_STATUS__PAUSED,
    VAR__VM_STATUS__MIGRATING,
    VAR__VM_STATUS__UNKNOWN,
    VAR__VM_STATUS__NOT_RESPONDING,
    VAR__VM_STATUS__WAIT_FOR_LAUNCH,
    VAR__VM_STATUS__REBOOT_IN_PROGRESS,
    VAR__VM_STATUS__SAVING_STATE,
    VAR__VM_STATUS__RESTORING_STATE,
    VAR__VM_STATUS__SUSPENDED,
    VAR__VM_STATUS__IMAGE_LOCKED,
    VAR__VM_STATUS__POWERING_DOWN,
    VAR__VM_STATUS__IMAGE_ILLEGAL,

    ACTION_TYPE_FAILED_ATTRIBUTE_PATH(ErrorType.BAD_PARAMETERS),
    POWER_MANAGEMENT_ACTION_ON_ENTITY_ALREADY_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_LIST_CANNOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NAME_ALREADY_USED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IN_PREVIEW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DELETE_VMS_IN_PREVIEW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_DISK_SNAPSHOT_IS_ATTACHED_TO_ANOTHER_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_DISK_SNAPSHOT_IS_PLUGGED_TO_ANOTHER_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_DISK_SNAPSHOT_NOT_ATTACHED_TO_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_PLUGGED_DISK_SNAPSHOT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SHAREABLE_DISKS_NOT_SUPPORTED_ON_GLUSTER_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISKS_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_DISK_INTERFACE_UNSUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INTERFACE_DOES_NOT_SUPPORT_READ_ONLY_ATTR(ErrorType.BAD_PARAMETERS),
    VALIDATION_DISK_INTERFACE_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_DISK_DESCRIPTION_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_DISK_ALIAS_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_DISK_IMAGE_DESCRIPTION_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_DISK_IMAGE_DESCRIPTION_NOT_EMPTY(ErrorType.BAD_PARAMETERS),
    VALIDATION_DISK_IMAGE_DESCRIPTION_MAX(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISKS_ILLEGAL(ErrorType.INTERNAL_ERROR),
    ACTION_TYPE_FAILED_MOVE_DISKS_MIXED_PLUGGED_STATUS(ErrorType.INTERNAL_ERROR),
    ACTION_TYPE_FAILED_IMPORT_DISKS_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DUPLICATED_DISK_OR_IMAGE_IDS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_DURING_EXPORT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IMAGE_IS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_WITH_LOCALDISK_USER_PROPERTY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_CDROM_DISK_FORMAT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_IMAGE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_TYPE_NOT_REGULAR(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_SNAPSHOT_STATUS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CORRUPTED_VM_SNAPSHOT_ID(ErrorType.DATA_CORRUPTION),
    ACTION_TYPE_FAILED_LEASE_DOMAIN_ID_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_HAS_NO_CONFIGURATION(ErrorType.BAD_PARAMETERS),
    VALIDATION_SOURCE_SNAPSHOT_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_HAS_SNAPSHOTS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_IS_RUNNING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_CLONED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_UPDATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_RUNNING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_DOWN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_UPDATE_FLOATING_DISK_QCOW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_DOWN_OR_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_SAVING_RESTORING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_DURING_SNAPSHOT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_NOT_SET_FOR_LATEST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_ALREADY_IN_LATEST_VERSION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_GUID_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_VM_LEASE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_LEASE_IS_NOT_READY_FOR_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_VM_LEASE_STORAGE_DOMAIN_STATUS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_RUNNING_STATELESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_STATELESS_SNAPSHOT_LEFTOVER(ErrorType.DATA_CORRUPTION),
    ACTION_TYPE_FAILED_VM_IN_USE_BY_OTHER_USER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_RUN_ACTION_ON_NON_MANAGED_VM(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CLUSTER_DIFFERENT_ARCHITECTURES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_VMS_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VMS_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VMS_NOT_RUNNING_ON_SINGLE_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DELETE_PROTECTION_ENABLED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_PCI_SLOTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_IDE_SLOTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_SATA_SLOTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_VIRTIO_SCSI_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_SPAPR_VSCSI_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_BOOT_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QCOW_COMPAT_DOES_NOT_MATCH_DC_VERSION(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PASS_DISCARD_NOT_SUPPORTED_BY_DISK_INTERFACE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PASS_DISCARD_NOT_SUPPORTED_FOR_DIRECT_LUN_BY_UNDERLYING_STORAGE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PASS_DISCARD_NOT_SUPPORTED_FOR_DISK_IMAGE_BY_UNDERLYING_STORAGE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PASS_DISCARD_NOT_SUPPORTED_BY_UNDERLYING_STORAGE_WHEN_WAD_IS_ENABLED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PASS_DISCARD_NOT_SUPPORTED_BY_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PASS_DISCARD_NOT_SUPPORTED_BY_DISK_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISK_SPARSIFY_NOT_SUPPORTED_BY_DISK_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISK_SPARSIFY_NOT_SUPPORTED_BY_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISK_SPARSIFY_NOT_SUPPORTED_BY_UNDERLYING_STORAGE_WHEN_WAD_IS_ENABLED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISK_SPARSIFY_NOT_SUPPORTED_FOR_PREALLOCATED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISK_SPARSIFY_NOT_SUPPORTED_FOR_COW(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISCARD_AFTER_DELETE_NOT_SUPPORTED_BY_UNDERLYING_STORAGE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISCARD_AFTER_DELETE_SUPPORTED_ONLY_BY_BLOCK_DOMAINS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DOMAIN_TYPE_DOES_NOT_SUPPORT_BACKUP(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_DISKS_ON_BACKUP_STORAGE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_RUNNING_VM_OR_VM_LEASES_PRESENT_ON_STORAGE_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_RETRIEVE_VMS_FOR_WITH_LEASES(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_DISK_ALREADY_ATTACHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NOT_SHAREABLE_DISK_ALREADY_ATTACHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_ALREADY_DETACHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ILLEGAL_DISK_OPERATION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_ARCHITECTURE_TYPE_INCOMPATIBLE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_VOLUME_TYPE_UNSUPPORTED(ErrorType.CONFLICT),
    VALIDATION_VOLUME_TYPE_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_VOLUME_FORMAT_NOT_NULL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_SPM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SPM_CHANGED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_SPACE_LOW_ON_STORAGE_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DEDICATED_VDS_NOT_IN_SAME_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DEDICATED_VDS_DOES_NOT_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_MAX_SIZE_EXCEEDED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_CONFIGURATION_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_OVF_CONFIGURATION_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NOT_SUPPORTED_DISK_STORAGE_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_LUN_IS_ALREADY_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_LUN_HAS_NO_VALID_TYPE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_LUN_ISCSI_MISSING_CONNECTION_PARAMS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_LUN_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOSTED_ENGINE_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOSTED_ENGINE_STORAGE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_UNMANAGED_HOSTED_ENGINE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOSTED_ENGINE_HOST_IN_ANOTHER_DC(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOSTED_ENGINE_HOST_IN_ANOTHER_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_UNSUPPORTED_DISK_STORAGE_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_SIZE_ZERO(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_UNAVAILABLE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_TYPE_UNSUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MIGRATION_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIGRATION_TO_SAME_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DESTINATION_HOST_NOT_IN_DESTINATION_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROXY_HOST_NOT_IN_VM_DATA_CENTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CLUSTER_UNDEFINED_ARCHITECTURE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_VM_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_CLUSTER_DIFFERENT_ARCHITECTURES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOST_CLUSTER_DIFFERENT_MANAGEMENT_NETWORKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_MEMORY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_VERSION(ErrorType.INCOMPATIBLE_VERSION),
    ACTION_TYPE_FAILED_VDS_VM_SWAP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_CPUS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_CPU_LEVEL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_HA_VDS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_VDS_AVAILABLE_IN_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_IMAGE_TEMPLATE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CPU_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_IS_ON_DIFFERENT_CHAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_CAN_NOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_VERSION_CANNOT_BE_BASE_TEMPLATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_CANNOT_BE_CREATED_WITH_EMPTY_DISK_ALIAS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INSTANCE_TYPE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NUM_OF_IOTHREADS_INCORRECT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_TYPE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_IS_DISABLED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_NOT_EXISTS_IN_CURRENT_DC(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_GUID_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_ID_CANT_BE_CHANGED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ROLE_IS_READ_ONLY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_NOT_MATCH(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_OF_VM_NOT_MATCH(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MISSED_STORAGES_FOR_SOME_DISKS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_IS_WRONG(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANT_DELETE_TEMPLATE_DISK_WITHOUT_SPECIFYING_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANT_AMEND_TEMPLATE_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANT_AMEND_RAW_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_ALREADY_CONTAINS_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_FORMAT_STORAGE_DOMAIN_WITH_ATTACHED_DATA_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_FORMAT_MANAGED_BLOCK_STORAGE_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NOT_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DELETE_PROTECTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_VMS_IN_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NAME_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_IMPORT_STORAGE_DOMAIN_EXTERNAL_LUN_DISK_EXIST(ErrorType.CONFLICT),
    VALIDATION_STORAGE_DOMAIN_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_DOMAIN_DESCRIPTION_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_DOMAIN_DESCRIPTION_MAX(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_DOMAIN_WARNING_LOW_SPACE_INDICATOR_RANGE(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_DOMAIN_CRITICAL_SPACE_ACTION_BLOCKER_RANGE(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_DOMAIN_WARNING_LOW_CONFIRMED_SPACE_INDICATOR_RANGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROBLEM_WITH_CANDIDATE_INFO(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_NAME_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_POOL_NAME(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_POOL_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DESTINATION_STORAGE_DOMAIN_ALREADY_CONTAINS_THE_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SOURCE_STORAGE_DOMAIN_DOES_CONTAINS_THE_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_NOT_FOUND_ON_DESTINATION_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_DISK_STATUS_IS_NOT_VALID(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_NOT_FOUND_ON_EXPORT_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_NOT_FOUND_ON_EXPORT_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMPORTED_TEMPLATE_IS_MISSING(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SPECIFY_DOMAIN_IS_NOT_EXPORT_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DETECTED_ACTIVE_VMS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_WITH_SAME_HOST_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_WITH_INVALID_SSH_PORT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_WITH_INVALID_SSH_USERNAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_WITH_SAME_UUID_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ILLEGAL_NUM_OF_MONITORS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_OS_TYPE_IS_NOT_SUPPORTED_BY_ARCHITECTURE_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_WATCHDOG_MODEL_IS_NOT_SUPPORTED_BY_OS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_VM_DISPLAY_TYPE_IS_NOT_SUPPORTED_BY_OS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_VM_DISPLAY_TYPE_IS_NOT_SUPPORTED_BY_FIRMWARE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_FLOPPY_IS_NOT_SUPPORTED_BY_OS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_OS_TYPE_DOES_NOT_SUPPORT_VIRTIO_SCSI(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SUSPEND_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_DOMAIN_NAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MAX_NUM_CPU(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAX_NUM_SOCKETS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIN_NUM_SOCKETS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAX_CPU_PER_SOCKET(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAX_THREADS_PER_CPU(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIN_CPU_PER_SOCKET(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIN_THREADS_PER_CPU(ErrorType.CONFLICT),
    TOO_MANY_CPU_COMPONENTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PRESTARTED_VMS_CANNOT_EXCEED_VMS_COUNT(ErrorType.CONFLICT),
    TEMPLATE_IMAGE_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_DECREASE_DATA_CENTER_COMPATIBILITY_VERSION(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_CANNOT_DECREASE_CLUSTER_WITH_HOSTS_COMPATIBILITY_VERSION(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_DECREASING_COMPATIBILITY_VERSION_CAUSES_STORAGE_FORMAT_DOWNGRADING(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_CANNOT_DECREASE_COMPATIBILITY_VERSION_UNDER_DC(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_GIVEN_VERSION_NOT_SUPPORTED(ErrorType.INCOMPATIBLE_VERSION),
    CANNOT_MAINTENANCE_VDS_RUN_VMS_NO_OTHER_RUNNING_VDS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NAME_LENGTH_IS_TOO_LONG(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NAME_MAY_NOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_IS_INCOMPATIBLE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_VDS_HOSTNAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NAME_MAY_NOT_CONTAIN_SPECIAL_CHARS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_EMULATED_MACHINE_MAY_NOT_CONTAIN_SPECIAL_CHARS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CPU_NAME_MAY_NOT_CONTAIN_SPECIAL_CHARS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOSTNAME_CANNOT_CHANGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_NOT_IN_PREVIEW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_IMAGE_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SHAREABLE_DISK_NOT_SUPPORTED(ErrorType.CONFLICT),
    FAILED_TO_RUN_LDAP_QUERY(ErrorType.INTERNAL_ERROR),
    ACTION_TYPE_FAILED_INVALID_TIMEZONE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_SERIAL_NUMBER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QEMU_UNSUPPORTED_OPERATION(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_USER_PROFILE_MULTIPLE_SSH_KEYS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_USER_PROFILE_PROPERTY_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_USER_PROFILE_PROPERTY_ALREADY_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_USER_PROFILE_PROPERTY_ALREADY_EXIST_WITH_DIFFERENT_NAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_USER_PROFILE_PROPERTY_ALREADY_EXIST_WITH_DIFFERENT_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CUSTOM_COMPATIBILITY_VERSION_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MEMORY_TOO_OLD(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_CREATION_DATE(ErrorType.BAD_PARAMETERS),

    VDS_CANNOT_REMOVE_DEFAULT_CLUSTER(ErrorType.CONFLICT),
    VDS_CANNOT_REMOVE_VDS_DETECTED_RUNNING_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DETECTED_PINNED_VMS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DETECTED_ASSIGNED_HOST_DEVICES(ErrorType.CONFLICT),
    VDS_CANNOT_REMOVE_VDS_STATUS_ILLEGAL(ErrorType.CONFLICT),
    CANNOT_ENROLL_CERTIFICATE_HOST_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIGRATE_BETWEEN_TWO_CLUSTERS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_INTERMITENT_CONNECTIVITY(ErrorType.CONFLICT),
    VDS_CANNOT_REMOVE_CLUSTER_VDS_DETECTED(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_NOT_OPERATIONAL(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_NOT_RESPONDING_WITH_VMS(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_NOT_RESPONDING_AND_IS_SPM(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_SPM_WITH_RUNNING_TASKS(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_HOST_WITH_RUNNING_OPERATIONS(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_SPM_CONTENDING(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_IN_MAINTENANCE(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_HAS_AFFINITY_VMS(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_HOST_WITH_RUNNING_IMAGE_TRANSFERS(ErrorType.CONFLICT),
    VDS_NO_UUID(ErrorType.CONFLICT),
    VDS_ALREADY_UP(ErrorType.CONFLICT),
    VDS_NON_RESPONSIVE(ErrorType.CONFLICT),
    VDS_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VDS_STATUS_NOT_VALID_FOR_STOP(ErrorType.CONFLICT),
    VDS_STATUS_NOT_VALID_FOR_START(ErrorType.CONFLICT),
    VDS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VALIDATION_VDS_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_VDS_HOSTNAME_HOSTNAME_OR_IP(ErrorType.BAD_PARAMETERS),
    VALIDATION_VDS_CONSOLEADDRESSS_HOSTNAME_OR_IP(ErrorType.BAD_PARAMETERS),
    VALIDATION_VDS_POWER_MGMT_ADDRESS_HOSTNAME_OR_IP(ErrorType.BAD_PARAMETERS),
    VALIDATION_VDS_PORT_RANGE(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_NUM_OF_MONITORS_EXCEEDED(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_INVALID_KEYBOARD_LAYOUT(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_MIGRATION_DOWNTIME_RANGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DESCRIPTION_MAY_NOT_CONTAIN_SPECIAL_CHARS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_LINUX_BOOT_PARAMS_MAY_NOT_CONTAIN_TRIMMING_WHITESPACES(ErrorType.BAD_PARAMETERS),
    CANNOT_FORCE_SELECT_SPM_VDS_NOT_UP(ErrorType.CONFLICT),
    CANNOT_FORCE_SELECT_SPM_VDS_ALREADY_SPM(ErrorType.CONFLICT),
    CANNOT_FORCE_SELECT_SPM_VDS_MARKED_AS_NEVER_SPM(ErrorType.CONSTRAINT_VIOLATION),
    CANNOT_FORCE_SELECT_SPM_STORAGE_POOL_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    CANNOT_FORCE_SELECT_SPM_VDS_NOT_IN_POOL(ErrorType.CONFLICT),
    CANNOT_FORCE_SELECT_SPM_HOST_DOES_NOT_SUPPORT_VIRT_SERVICES(ErrorType.NOT_SUPPORTED),
    VDS_NO_VDS_PROXY_FOUND(ErrorType.CONFLICT),
    VDS_FAILED_FENCE_VIA_PROXY_CONNECTION(ErrorType.CONFLICT),
    VDS_FENCE_DISABLED_AT_SYSTEM_STARTUP_INTERVAL(ErrorType.CONFLICT),
    VDS_FENCE_DISABLED_AT_QUIET_TIME(ErrorType.CONFLICT),
    VDS_FENCE_DISABLED_BY_CLUSTER_POLICY(ErrorType.CONFLICT),
    VDS_STATUS_NOT_VALID_FOR_UPDATE(ErrorType.CONFLICT),
    VDS_EMPTY_NAME_OR_ID(ErrorType.BAD_PARAMETERS),
    VDS_TRY_CREATE_SECURE_CERTIFICATE_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VDS_PROVIDER_PROVISION_MISSING_HOSTGROUP(ErrorType.BAD_PARAMETERS),
    VDS_PROVIDER_PROVISION_MISSING_COMPUTERESOURCE(ErrorType.BAD_PARAMETERS),
    VDS_CANNOT_INSTALL_EMPTY_PASSWORD(ErrorType.BAD_PARAMETERS),
    VDS_PORT_CHANGE_REQUIRE_INSTALL(ErrorType.BAD_PARAMETERS),
    VDS_INVALID_SERVER_ID(ErrorType.BAD_PARAMETERS),
    VDS_ADD_STORAGE_SERVER_STATUS_MUST_BE_UP(ErrorType.CONFLICT),
    VDS_CANNOT_CLEAR_VMS_WRONG_STATUS(ErrorType.CONFLICT),
    VDS_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    VDS_CLUSTER_ON_DIFFERENT_STORAGE_POOL(ErrorType.BAD_PARAMETERS),
    VDS_FENCE_DISABLED(ErrorType.CONFLICT),
    VDS_CANNOT_INSTALL_STATUS_ILLEGAL(ErrorType.CONFLICT),
    VDS_CANNOT_UPGRADE_BETWEEN_MAJOR_VERSION(ErrorType.CONSTRAINT_VIOLATION),
    VDS_CANNOT_CONNECT_TO_SERVER(ErrorType.CONFLICT),
    VDS_CANNOT_AUTHENTICATE_TO_SERVER(ErrorType.CONFLICT),
    VDS_SECURITY_CONNECTION_ERROR(ErrorType.CONFLICT),
    VDS_REMOVE_FENCE_AGENT_ID_REQUIRED(ErrorType.BAD_PARAMETERS),
    VDS_REMOVE_LAST_FENCE_AGENT_PM_ENABLED(ErrorType.CONSTRAINT_VIOLATION),
    VDS_REMOVE_FENCE_AGENTS_VDS_ID_REQUIRED(ErrorType.BAD_PARAMETERS),
    VDS_ADD_FENCE_AGENT_MANDATORY_PARAMETERS_MISSING(ErrorType.BAD_PARAMETERS),
    VDS_ILLEGAL_PM_AGENT_PORT_VALUE(ErrorType.BAD_PARAMETERS),
    NO_AVAILABLE_UPDATES_FOR_HOST(ErrorType.CONFLICT),
    CANNOT_UPGRADE_HOST_WITHOUT_OS(ErrorType.BAD_PARAMETERS),
    CANNOT_UPGRADE_HOST_STATUS_ILLEGAL(ErrorType.CONFLICT),
    CANNOT_CHECK_FOR_HOST_UPGRADE_STATUS_ILLEGAL(ErrorType.CONFLICT),
    CANNOT_UPGRADE_HOST_CLUSTER_CPU_AFFECTED_BY_TSX_REMOVAL(ErrorType.CONFLICT),
    VAR__ACTION__MANUAL_FENCE,
    VAR__ACTION__MAINTENANCE,
    ACTION_TYPE_FAILED_PM_ENABLED_WITHOUT_AGENT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PM_ENABLED_WITHOUT_AGENT_CREDENTIALS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_AGENT_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_VM_ARCHITECTURE_NOT_SUPPORTED_BY_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_TEMPLATE_ARCHITECTURE_NOT_SUPPORTED_BY_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_VM_WITH_NOT_SUPPORTED_ARCHITECTURE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_TEMPLATE_WITH_NOT_SUPPORTED_ARCHITECTURE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_MIN_MEMORY_CANNOT_EXCEED_MEMORY_SIZE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MIN_MEMORY_CANNOT_BE_NEGATIVE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MAX_MEMORY_CANNOT_BE_SMALLER_THAN_MEMORY_SIZE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PHYSICAL_MEMORY_CANNOT_BE_SMALLER_THAN_MEMORY_SIZE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAX_MEMORY_CANNOT_EXCEED_PLATFORM_LIMIT(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_MEMORY_EXCEEDS_SUPPORTED_LIMIT(ErrorType.NOT_SUPPORTED),
    VDS_CANNOT_CHECK_VERSION_HOST_NON_RESPONSIVE(ErrorType.CONFLICT),
    STORAGE_DOMAIN_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    CANNOT_FETCH_STORAGE_DEVICES_HOST_DOESNT_EXIST_ANYMORE(ErrorType.BAD_PARAMETERS),
    // VDS_CANNOT_RUN_VM_FAILED_TO_RUN, // EINAV: not in use
    // internal const string VDS_CANNOT_REMOVE_VDS_DETECTED_RUNNING_VM =
    /**
     * "Cannot delete the server, there are desktop(s) running on the server.";
     */
    HOST_ID_IS_NULL(ErrorType.BAD_PARAMETERS),
    NIC_ID_IS_NULL(ErrorType.BAD_PARAMETERS),
    NIC_ID_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    DNS_RESOLVER_CONFIGURATION_ID_IS_NULL(ErrorType.BAD_PARAMETERS),
    INTERFACE_TYPE_NOT_SUPPORT_LLDP(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_CANCEL_MIGRATION_WHEN_VM_IS_NOT_MIGRATING(ErrorType.CONFLICT),
    VM_CANNOT_CANCEL_CONVERSION_WHEN_VM_IS_NOT_BEING_CONVERTED(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_CLUSTER_VMS_DETECTED(ErrorType.CONFLICT),
    VM_TEMPLATE_IS_LOCKED(ErrorType.CONFLICT),
    VM_TEMPLATE_CANNOT_SEAL_WINDOWS(ErrorType.NOT_SUPPORTED),
    VM_TEMPLATE_WITH_CLUSTER_WITHOUT_BIOS_TYPE(ErrorType.BAD_PARAMETERS),
    VM_TEMPLATE_WITHOUT_CLUSTER_WITH_BIOS_TYPE(ErrorType.BAD_PARAMETERS),
    VM_TEMPLATE_IMAGE_IS_LOCKED(ErrorType.CONFLICT),
    VM_TEMPLATE_IMAGE_IS_ILLEGAL(ErrorType.CONFLICT),
    VM_TEMPLATE_IMAGE_LAST_DOMAIN(ErrorType.CONFLICT),
    VALIDATION_VM_TEMPLATE_NAME_MAX(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_UPDATE_ILLEGAL_FIELD(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_UPDATE_HOSTED_ENGINE_FIELD(ErrorType.BAD_PARAMETERS),
    MAC_POOL_NOT_ENOUGH_MAC_ADDRESSES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_DEFAULT_MAC_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_STILL_USED_MAC_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAC_POOL_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CHANGING_DEFAULT_MAC_POOL_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_SETTING_DEFAULT_MAC_POOL_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_MAC_POOL_MUST_HAVE_RANGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MAC_POOL_CONTAINS_DUPLICATES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAC_POOL_CONTAINS_OVERLAPPING_RANGES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAC_POOL_OVERLAPS_WITH_OTHER_POOLS(ErrorType.CONFLICT),
    VM_CANNOT_MOVE_TO_CLUSTER_IN_OTHER_STORAGE_POOL(ErrorType.CONFLICT),
    VM_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_REMOVE_VM_WHEN_STATUS_IS_NOT_DOWN(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_WITH_DETACH_DISKS_SNAPSHOTS_EXIST(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_WITH_DETACH_DISKS_BASED_ON_TEMPLATE(ErrorType.CONFLICT),
    VM_CANNOT_EXPORT_RAW_FORMAT(ErrorType.CONFLICT),
    VM_TEMPLATE_TPM_DATA_EXPORT_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    VM_PINNING_FORMAT_INVALID(ErrorType.BAD_PARAMETERS),
    VM_PINNING_VCPU_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VM_PINNING_PCPU_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VM_PINNING_DUPLICATE_DEFINITION(ErrorType.BAD_PARAMETERS),
    VM_PINNING_PINNED_TO_NO_CPU(ErrorType.BAD_PARAMETERS),
    VM_NUMA_PINNED_VDS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VM_NUMA_PINNED_VDS_NODE_EMPTY(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_PINNED_INDEX_ERROR(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_HOST_NODE_INVALID_INDEX(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_MEMORY_ERROR(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_TOTAL_MEMORY_ERROR(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_NOT_MULTIPLE_OF_HUGEPAGE(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_PREFERRED_NOT_PINNED_TO_SINGLE_NODE(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_MORE_NODES_THAN_CPUS(ErrorType.BAD_PARAMETERS),
    HOST_NUMA_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_INDEX_DUPLICATE(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_NON_CONTINUOUS_INDEX(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_DUPLICATE_CPU_IDS(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_INVALID_CPU_ID(ErrorType.BAD_PARAMETERS),
    VM_NVDIMM_NUMA_UNAVAILABLE(ErrorType.BAD_PARAMETERS),
    CANNOT_PREVIEW_ACTIVE_SNAPSHOT(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_SUSPENDE_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_NETWORK_WITHOUT_NETWORK(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_CD_WITHOUT_ACTIVE_STORAGE_DOMAIN_ISO(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_DISK_WITHOUT_DISK(ErrorType.CONFLICT),
    VM_CANNOT_RUN_STATELESS_WHILE_IN_PREVIEW(ErrorType.CONFLICT),
    VM_CANNOT_RUN_STATELESS_HA(ErrorType.CONFLICT),
    VM_CANNOT_IMPORT_VM_EXISTS(ErrorType.CONFLICT),
    VM_CANNOT_IMPORT_VM_NAME_EXISTS(ErrorType.CONFLICT),
    VM_CANNOT_SUSPEND_STATELESS_VM(ErrorType.CONFLICT),
    VM_CANNOT_SUSPEND_VM_FROM_POOL(ErrorType.CONFLICT),
    VM_AT_LEAST_ONE_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_SUITABLE_DOMAIN_FOUND(ErrorType.CONFLICT),
    VMT_CANNOT_REMOVE_DETECTED_DERIVED_VM(ErrorType.CONFLICT),
    VMT_CANNOT_REMOVE_BASE_WITH_VERSIONS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DETECTED_DERIVED_DISKS(ErrorType.CONFLICT),
    VMT_CANNOT_CREATE_TEMPLATE_FROM_DOWN_VM(ErrorType.CONFLICT),
    VMT_CANNOT_REMOVE_BLANK_TEMPLATE(ErrorType.CONFLICT),
    VMT_CANNOT_EXPORT_BLANK_TEMPLATE(ErrorType.CONFLICT),
    VMT_CANNOT_UPDATE_ILLEGAL_FIELD(ErrorType.BAD_PARAMETERS),
    VMT_CANNOT_UPDATE_VERSION_NAME(ErrorType.BAD_PARAMETERS),
    VMT_CANNOT_REMOVE_CLUSTER_VMTS_DETECTED(ErrorType.CONFLICT),
    VMT_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    VMT_CANNOT_IMPORT_TEMPLATE_EXISTS(ErrorType.CONFLICT),
    VMT_CANNOT_IMPORT_TEMPLATE_VERSION_MISSING_BASE(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_IMPORT_TEMPLATE_NAME_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_INTERFACE_MAC_INVALID(ErrorType.BAD_PARAMETERS),
    USER_CANNOT_REMOVE_HIMSELF(ErrorType.CONFLICT),
    USER_FAILED_TO_AUTHENTICATE(ErrorType.NO_AUTHENTICATION),
    USER_FAILED_TO_AUTHENTICATE_KERBEROS_ERROR(ErrorType.NO_AUTHENTICATION),
    USER_FAILED_TO_AUTHENTICATE_SERVER_IS_NOT_AVAILABLE(ErrorType.NO_AUTHENTICATION),
    USER_FAILED_TO_AUTHENTICATE_TIMED_OUT(ErrorType.NO_AUTHENTICATION),
    USER_PASSWORD_EXPIRED(ErrorType.NO_AUTHENTICATION),
    USER_PASSWORD_EXPIRED_CHANGE_URL_PROVIDED(ErrorType.NO_AUTHENTICATION),
    USER_PASSWORD_EXPIRED_CHANGE_MSG_PROVIDED(ErrorType.NO_AUTHENTICATION),
    USER_ACCOUNT_DISABLED(ErrorType.NO_AUTHENTICATION),
    USER_ACCOUNT_EXPIRED(ErrorType.NO_AUTHENTICATION),
    USER_PERMISSION_DENIED(ErrorType.NO_AUTHENTICATION),
    USER_MUST_EXIST_IN_DB(ErrorType.NO_AUTHENTICATION),
    USER_MUST_EXIST_IN_DIRECTORY(ErrorType.NO_AUTHENTICATION),
    USER_IS_ALREADY_LOGGED_IN(ErrorType.CONFLICT),
    USER_IS_NOT_LOGGED_IN(ErrorType.NO_AUTHENTICATION),
    USER_DOES_NOT_HAVE_A_VALID_EMAIL(ErrorType.CONFLICT),
    USER_CANNOT_RUN_QUERY_NOT_PUBLIC(ErrorType.NO_AUTHENTICATION),
    USER_CANNOT_RUN_ACTION_INTERNAL_COMMAND(ErrorType.NO_AUTHENTICATION),
    USER_CANNOT_LOGIN_DOMAIN_NOT_SUPPORTED(ErrorType.NO_AUTHENTICATION),
    USER_CANNOT_LOGIN_SESSION_MISSING(ErrorType.NO_AUTHENTICATION),
    USER_CANNOT_REMOVE_ADMIN_USER(ErrorType.NO_PERMISSION),
    VM_POOL_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_REMOVE_RUNNING_VM_FROM_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_RUNNING_VM_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_VM_WITH_USERS_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_VM_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_DETACH_VM_NOT_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_VM_DIFFERENT_CLUSTER(ErrorType.CONFLICT),
    VM_POOL_CANNOT_CREATE_WITH_NO_VMS(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_NO_AVAILABLE_POOL_VMS(ErrorType.CONFLICT),
    VM_POOL_CANNOT_CREATE_FROM_BLANK_TEMPLATE(ErrorType.CONFLICT),
    VM_POOL_CANNOT_UPDATE_POOL_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_DECREASE_VMS_FROM_POOL(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_ATTACH_TO_MORE_VMS_FROM_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_CHANGE_POOL_TYPE(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_CHANGE_TEMPLATE_WHEN_DELETE_PROTECTED(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_CHANGE_POOL_STATEFUL_OPTION(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_CHANGE_POOL_NAME(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_CHANGE_AUTO_STORAGE_SELECT(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_POOLS_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_POOLS_SPICE_PROXY_HOSTNAME_OR_IP(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_POOLS_NUMBER_OF_MAX_ASSIGNED_VMS_OUT_OF_RANGE(ErrorType.BAD_PARAMETERS),
    USER_NOT_AUTHORIZED_TO_PERFORM_ACTION(ErrorType.NO_PERMISSION),
    NON_ADMIN_USER_NOT_AUTHORIZED_TO_PERFORM_ACTION_ON_HE(ErrorType.NO_PERMISSION),
    ERROR_CANNOT_REMOVE_LAST_SUPER_USER_ROLE(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_ROLE_ATTACHED_TO_PERMISSION(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_ROLE_INVALID_ROLE_ID(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_UPDATE_ROLE_ID(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_UPDATE_ROLE_TYPE(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_ATTACH_ACTION_GROUP_TO_ROLE_ATTACHED(ErrorType.CONFLICT),
    ERROR_CANNOT_DETACH_ACTION_GROUP_TO_ROLE_NOT_ATTACHED(ErrorType.BAD_PARAMETERS),
    VDS_APPROVE_VDS_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VDS_APPROVE_VDS_IN_WRONG_STATUS(ErrorType.CONFLICT),
    VDS_SHUTDOWN_VDS_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    CLUSTER_CANNOT_UPDATE_CPU_ILLEGAL(ErrorType.CONFLICT),
    CLUSTER_CANNOT_UPDATE_CPU_ARCHITECTURE_ILLEGAL(ErrorType.CONFLICT),
    CLUSTER_CANNOT_DO_ACTION_NAME_IN_USE(ErrorType.CONFLICT),
    CLUSTER_CANNOT_CHANGE_STORAGE_POOL(ErrorType.CONFLICT),
    CLUSTER_CANNOT_UPDATE_CPU_WITH_HOSTS_MISSING_FLAGS(ErrorType.CONFLICT),
    CLUSTER_CANNOT_UPDATE_COMPATIBILITY_VERSION_WITH_LOWER_HOSTS(ErrorType.INCOMPATIBLE_VERSION),
    CLUSTER_CANNOT_UPDATE_COMPATIBILITY_VERSION_WITH_INCOMPATIBLE_EMULATED_MACHINE(ErrorType.INCOMPATIBLE_VERSION),
    CLUSTER_CANNOT_UPDATE_SUPPORTED_FEATURES_WITH_LOWER_HOSTS(ErrorType.INCOMPATIBLE_VERSION),
    CLUSTER_CANNOT_UPDATE_VERSION_WHEN_NO_HOST_SUPPORTS_THE_VERSION(ErrorType.INCOMPATIBLE_VERSION),
    CLUSTER_CANNOT_SET_CPU_AUTODETECTION(ErrorType.CONFLICT),
    CLUSTER_CANNOT_UPDATE_VDS_UP(ErrorType.CONFLICT),
    CLUSTER_CANNOT_UPDATE_FIPS_VDS_MAINTENANCE(ErrorType.CONFLICT),
    CLUSTER_CANNOT_ADD_COMPATIBILITY_VERSION_WITH_LOWER_STORAGE_POOL(ErrorType.INCOMPATIBLE_VERSION),
    CLUSTER_CANNOT_REMOVE_HAS_VM_POOLS(ErrorType.CONFLICT),
    CLUSTER_CANNOT_SET_TRUSTED_ATTESTATION_SERVER_NOT_CONFIGURED(ErrorType.ATTESTATION_SERVER_ERROR),
    VALIDATION_CLUSTER_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_CLUSTER_NAME_MAX(ErrorType.BAD_PARAMETERS),
    VALIDATION_CLUSTER_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_CLUSTER_MIGRATE_ON_ERROR_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_CLUSTER_SPICE_PROXY_HOSTNAME_OR_IP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SETUP_NETWORKS_OR_REFRESH_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_NAME_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_IN_ONE_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_IN_MANY_USES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_ALREADY_LABELED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_FROM_DIFFERENT_DC(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DEFAULT_MANAGEMENT_NETWORK_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MANAGEMENT_NETWORK_CANNOT_BE_CHANGED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TARGET_CLUSTER_WITH_DIFF_MANAGEMENT_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MANAGEMENT_NETWORK_CANNOT_BE_EXTERNAL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DEFAULT_ROUTE_NETWORK_CANNOT_BE_EXTERNAL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DUPLICATE_NETWORK_CLUSTER_INPUT(ErrorType.BAD_PARAMETERS),
    NETWORK_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_HAVING_ID_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_HAVING_NAME_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_IS_NOT_EXTERNAL(ErrorType.BAD_PARAMETERS),
    VALIDATION_NETWORK_ID_OR_NETWORK_NAME_MUST_BE_SET(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENTS_ID_MUST_BE_SET_FOR_UPDATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_OF_GIVEN_NAME_NOT_EXISTS_IN_CLUSTER(ErrorType.BAD_PARAMETERS),
    MODIFIED_NETWORK_ATTACHMENT_DOES_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NULL_PASSED_AS_NETWORK_ATTACHMENT(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_NETWORK_ID_OR_NAME_IS_NOT_SET(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENTS_TO_BE_REMOVED_DOES_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_NOT_SPECIFIED(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_WHEN_UPDATING_YOU_HAVE_TO_PROVIDE_ID(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_CANNOT_BE_CREATED_WITH_SPECIFIC_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_ATTACHMENTS_REFERENCES_SAME_NETWORK_DUPLICATELY(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_IN_BOTH_LISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_REFERENCES_NICS_INCOHERENTLY(ErrorType.BAD_PARAMETERS),
    NIC_LABEL_REFERENCES_NICS_INCOHERENTLY(ErrorType.BAD_PARAMETERS),
    NIC_LABEL_VALIDATION_NIC_ID_OR_NIC_NAME_MUST_BE_SET(ErrorType.BAD_PARAMETERS),
    LABEL_ON_NETWORK_LABEL_CANNOT_BE_NULL(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_REFERENCES_NETWORK_INCOHERENTLY(ErrorType.BAD_PARAMETERS),
    BOND_REFERENCES_NICS_INCOHERENTLY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_ATTACHMENT_CONTAINS_DUPLICATES(ErrorType.BAD_PARAMETERS),
    NETWORK_ALREADY_ATTACHED_TO_HOST(ErrorType.CONFLICT),
    NETWORK_ALREADY_ATTACHED_TO_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_LABEL_RENAMING_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    NETWORK_VLAN_IN_USE(ErrorType.CONFLICT),
    NETWORK_VLAN_OUT_OF_RANGE(ErrorType.BAD_PARAMETERS),
    NETWORK_ADDR_MANDATORY_IN_STATIC_IP(ErrorType.BAD_PARAMETERS),
    NETWORK_ADDR_MANDATORY_FOR_ROLE_NETWORK(ErrorType.CONSTRAINT_VIOLATION),
    IPV4_ADDR_BAD_FORMAT(ErrorType.BAD_PARAMETERS),
    BAD_IPV4_OR_IPV6_ADDRESS_FORMAT(ErrorType.BAD_PARAMETERS),
    BAD_IPV6_ADDRESS_FORMAT(ErrorType.BAD_PARAMETERS),
    IPV4_ADDR_GATEWAY_BAD_FORMAT(ErrorType.BAD_PARAMETERS),
    NETWORK_ADDR_IN_SUBNET_BAD_FORMAT(ErrorType.BAD_PARAMETERS),
    NETWORK_MAC_ADDRESS_IN_USE(ErrorType.CONFLICT),
    NETWORK_MAC_ADDRESS_IN_USE_DETAILED(ErrorType.CONFLICT),
    NETWORK_OUT_OF_RANGE_MACS(ErrorType.BAD_PARAMETERS),
    HOST_NETWORK_INTERFACE_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    HOST_NETWORK_INTERFACE_HAVING_ID_OR_NAME_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    HOST_NETWORK_INTERFACE_HAVING_NAME_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    HOST_NETWORK_INTERFACE_HAVING_ID_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    HOST_NETWORK_INTERFACE_DOES_NOT_HAVE_NAME_SET(ErrorType.BAD_PARAMETERS),
    HOSTS_NOT_IN_SAME_CLUSTER(ErrorType.BAD_PARAMETERS),
    INTERFACE_COUNT_DOES_NOT_MATCH(ErrorType.BAD_PARAMETERS),
    BOND_DOES_NOT_HAVE_NEITHER_ID_NOR_NAME_SPECIFIED(ErrorType.BAD_PARAMETERS),
    BONDS_UPDATED_AND_REMOVED_SIMULTANEOUSLY(ErrorType.BAD_PARAMETERS),
    INTERFACE_ON_NIC_LABEL_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    LABEL_NOT_EXIST_IN_HOST(ErrorType.BAD_PARAMETERS),
    PARAMS_CONTAIN_DUPLICATE_LABELS(ErrorType.BAD_PARAMETERS),
    LABEL_ATTACH_TO_IMPROPER_INTERFACE(ErrorType.BAD_PARAMETERS),
    IMPROPER_INTERFACE_IS_LABELED(ErrorType.BAD_PARAMETERS),
    NIC_NOT_EXISTS_ON_HOST(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_NAME_ALREADY_IN_USE(ErrorType.CONFLICT),
    NETWORK_CLUSTER_NETWORK_IN_USE(ErrorType.CONFLICT),
    NETWORK_INTERFACE_TEMPLATE_CANNOT_BE_SET(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_VM_CANNOT_BE_SET(ErrorType.BAD_PARAMETERS),
    NETWORK_CANNOT_REMOVE_MANAGEMENT_NETWORK(ErrorType.CONSTRAINT_VIOLATION),
    NETWORK_CANNOT_REMOVE_ISCSI_BOND_NETWORK(ErrorType.CONSTRAINT_VIOLATION),
    VALIDATION_CONNECTIVITY_TIMEOUT_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_REPETITIVE_IP_IN_VDS(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_ALREADY_IN_BOND(ErrorType.CONFLICT),
    NETWORK_BOND_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_BOND_RECORDS_DOES_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_BOND_HAVE_ATTACHED_VLANS(ErrorType.CONFLICT),
    NETWORK_BOND_NAME_BAD_FORMAT(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_IS_NOT_BOND(ErrorType.CONFLICT),
    NETWORK_INTERFACE_IN_USE_BY_VM(ErrorType.CONFLICT),
    NETWORK_CANNOT_ADD_INTERFACE_WHEN_VM_STATUS_NOT_UP_DOWN_LOCKED(ErrorType.CONFLICT),
    NETWORK_CLUSTER_HAVE_NOT_EXISTING_DATA_CENTER_NETWORK(ErrorType.CONFLICT),
    NETWORK_NOT_EXISTS_IN_CURRENT_CLUSTER(ErrorType.CONFLICT),
    NETWORK_NOT_IN_SYNC(ErrorType.CONFLICT),
    MTU,
    BRIDGED,
    VLAN,
    IPV4_BOOT_PROTOCOL,
    IPV4_ADDRESS,
    IPV4_NETMASK,
    IPV4_GATEWAY,
    IPV6_BOOT_PROTOCOL,
    IPV6_ADDRESS,
    IPV6_PREFIX,
    IPV6_GATEWAY,
    OUT_AVERAGE_LINK_SHARE,
    OUT_AVERAGE_UPPER_LIMIT,
    OUT_AVERAGE_REAL_TIME,
    SWITCH_TYPE,
    DNS_CONFIGURATION,
    DEFAULT_ROUTE,
    HOST_OUT_OF_SYNC,
    DC_OUT_OF_SYNC,
    NETWORK_INTERFACES_ALREADY_SPECIFIED(ErrorType.CONFLICT),
    NETWORKS_ALREADY_ATTACHED_TO_IFACES(ErrorType.CONFLICT),
    NETWORK_INTERFACES_DONT_EXIST(ErrorType.BAD_PARAMETERS),
    NETWORKS_DONT_EXIST_IN_CLUSTER(ErrorType.CONFLICT),
    NETWORKS_DONT_EXIST_IN_DATA_CENTER(ErrorType.CONFLICT),
    NETWORK_BONDS_INVALID_SLAVE_COUNT(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_BOND_OR_VLAN_CANNOT_BE_SLAVE(ErrorType.CONFLICT),
    CANNOT_ADD_NETWORK_ATTACHMENT_ON_SLAVE_OR_VLAN(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_ATTACHED_TO_NETWORK_CANNOT_BE_SLAVE(ErrorType.CONFLICT),
    NETWORK_INTERFACE_ADDED_TO_BOND_AND_NETWORK_IS_ATTACHED_TO_IT_AT_THE_SAME_TIME(ErrorType.CONFLICT),
    NETWORK_INTERFACE_REFERENCED_AS_A_SLAVE_MULTIPLE_TIMES(ErrorType.CONFLICT),
    SLAVE_INTERFACE_IS_MISCONFIGURED(ErrorType.CONFLICT),
    BOND_USED_BY_NETWORK_ATTACHMENTS(ErrorType.CONFLICT),
    NETWORK_INTERFACES_NOT_EXCLUSIVELY_USED_BY_UNTAGGED_NETWORK(ErrorType.CONFLICT),
    NETWORK_CANNOT_DETACH_NETWORK_USED_BY_VMS(ErrorType.CONFLICT),
    NETWORK_CANNOT_DETACH_PHYSICAL_NETWORK_LINKED_TO_EXTERNAL_USED_BY_VM(ErrorType.CONFLICT),
    BAD_CIDR_FORMAT(ErrorType.BAD_PARAMETERS),
    CIDR_NOT_NETWORK_ADDRESS(ErrorType.BAD_PARAMETERS),
    UPDATE_NETWORK_ADDR_IN_SUBNET_BAD_FORMAT(ErrorType.BAD_PARAMETERS),
    UPDATE_NETWORK_ADDR_IN_SUBNET_BAD_VALUE(ErrorType.BAD_PARAMETERS),
    NON_VM_NETWORK_CANNOT_SUPPORT_STP(ErrorType.CONFLICT),
    NON_VM_NETWORK_CANNOT_SUPPORT_PORT_ISOLATION(ErrorType.CONFLICT),
    EXTERNAL_NETWORK_CANNOT_SUPPORT_PORT_ISOLATION(ErrorType.CONFLICT),
    VALIDATION_VM_NETWORK_MAC_ADDRESS_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_NETWORK_MAC_ADDRESS_MULTICAST(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_NETWORK_MAC_ADDRESS_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_VM_NETWORK_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    NETWORK_MTU_DIFFERENCES(ErrorType.CONFLICT),
    EXTERNAL_NETWORK_HAVING_NAME_CANNOT_BE_PROVISIONED(ErrorType.NOT_SUPPORTED),
    NETWORK_LABEL_FORMAT_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_LABELED_NETWORK_FROM_NIC(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_MOVE_LABELED_NETWORK_TO_ANOTHER_NIC(ErrorType.CONFLICT),
    NETWORK_SHOULD_BE_ATTACHED_VIA_LABEL_TO_ANOTHER_NIC(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_NETWORK_FROM_BRICK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ROLE_NETWORK_HAS_NO_BOOT_PROTOCOL(ErrorType.CONFLICT),
    IMPROPER_BOND_IS_LABELED(ErrorType.BAD_PARAMETERS),
    INTERFACE_ALREADY_LABELED(ErrorType.CONFLICT),
    INTERFACE_NOT_LABELED(ErrorType.CONFLICT),
    LABELED_NETWORK_ATTACHED_TO_WRONG_INTERFACE(ErrorType.CONFLICT),
    OTHER_INTERFACE_ALREADY_LABELED(ErrorType.CONFLICT),
    CANNOT_CHANGE_ATTACHED_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VNIC_PROFILE_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VNIC_PROFILE_NAME_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VNIC_PROFILE_IN_ONE_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VNIC_PROFILE_IN_MANY_USES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_FIND_VNIC_PROFILE_FOR_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_CHANGE_VNIC_PROFILE_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_ADD_VNIC_PROFILE_TO_NON_VM_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PASSTHROUGH_PROFILE_NOT_SUPPORTS_PORT_ISOLATION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_DOESNT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_CHANGE_PROVIDER_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_MANAGEMENT_NETWORK_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MANAGEMENT_NETWORK_UNSET(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_NETWORK_INUSE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_ADDRESS_BRICK_IN_USE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_DETAILS_CANNOT_BE_EDITED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_MUST_BE_VM_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NOT_SUPPORTED_FOR_EXTERNAL_NETWORK(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_PHYSICAL_NETWORK_LINKED_TO_EXTERNAL_NETWORK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_PHYSICAL_NETWORK_DOES_NOT_EXIST_ON_DC(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_LABEL_AND_VLAN_CANNOT_BE_SET_WITH_PROVIDER_PHYSICAL_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DATA_CENTER_ID_CANNOT_BE_CHANGED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NETWORK_PORT_ISOLATION_CANNOT_BE_CHANGED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_DISPLAY(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_REQUIRED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_WITH_VLAN_MUST_BE_CUSTOM(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ISCSI_BOND_NETWORK_CANNOT_BE_REQUIRED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PROVIDER_NOT_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_PROVIDER_TYPE_MISMATCH(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_NETWORKS_USED_ONCE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_NETWORKS_USED_MULTIPLE_TIMES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_USED_IN_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_PORT_MIRRORED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_INVALID_VNIC_PROFILE_NETWORK_ID_CONFIGURATION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_VNIC_PROFILE_NETWORK_FILTER_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_FAILOVER_VNIC_PROFILE_ID_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_FAILOVER_VNIC_PROFILE_ID_CANNOT_POINT_TO_SELF(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_FAILOVER_VNIC_PROFILE_NOT_SUPPORTED_WITH_EXTERNAL_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_FAILOVER_IS_SUPPORTED_ONLY_FOR_MIGRATABLE_PASSTROUGH(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_UPDATE_OF_FAILOVER_PROFILE_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NIC_FILTER_PARAMETER_ID_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_NIC_FILTER_PARAMETER_INTERFACE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_NIC_FILTER_PARAMETER_INTERFACE_VM(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_NIC_FILTER_PARAMETER_NAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_NIC_FILTER_PARAMETER_VALUE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PASSTHROUGH_PROFILE_CONTAINS_NOT_SUPPORTED_PROPERTIES(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_REWIRED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORKS_CANNOT_BE_PROVISIONED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NIC_IS_NOT_SRIOV_ENABLED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NUM_OF_VFS_CANNOT_BE_CHANGED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NUM_OF_VFS_NOT_IN_VALID_RANGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_SET_SPECIFIC_NETWORKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_ALREADY_IN_VFS_CONFIG(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_NOT_IN_VFS_CONFIG(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PORT_ISOLATION_UNSUPPORTED_CLUSTER_LEVEL(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PORT_ISOLATION_INCOMPATIBLE_SWITCH_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_LABEL_ALREADY_IN_VFS_CONFIG(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_LABEL_NOT_IN_VFS_CONFIG(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_LUNS_NOT_PART_OF_STORAGE_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NOT_IN_STORAGE_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_LUNS_ALREADY_PART_OF_STORAGE_DOMAINS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_LUNS_ALREADY_USED_BY_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_SYNC_LUNS_OF_NON_BLOCK_DOMAINS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_LUN_BREAKS_STORAGE_DOMAIN_PASS_DISCARD_SUPPORT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_LUN_BREAKS_STORAGE_DOMAIN_DISCARD_AFTER_DELETE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DUPLICATE_DEVICE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_ALL_LUNS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DEVICE_NOT_IN_STORAGE_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_OPERATION_ON_METADATA_DEVICES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_DEVICES_PROVIDED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_POOL_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_CANNOT_BE_PROXY_FOR_IMPORT_VM(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROXY_HOST_MUST_BE_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_USERNAME_MUST_BE_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_USER_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PASSWORD_MUST_BE_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_HOST_CAN_BE_PROXY_FOR_IMPORT_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_AND_CLUSTER_IN_DIFFERENT_POOL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_NOT_IN_DEST_STORAGE_POOL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_UNSUPPORTED_ACTION_FOR_MANAGED_BLOCK_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_FOR_DOMAIN_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_FOR_DOMAIN_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_FOR_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_UNSUPPORTED_ACTION_DOMAIN_MUST_BE_IN_MAINTENANCE_OR_UNATTACHED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_FOR_RUNNING_VMS_AND_DOMAINS_STATUS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_NOT_SAME_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_FOR_RUNNING_VMS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_BELONGS_TO_SEVERAL_STORAGE_DOMAINS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_BELONGS_TO_SEVERAL_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_BELONGS_TO_SEVERAL_STORAGE_DOMAINS_AND_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_CHANGE_STORAGE_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTIONS_CANNOT_BE_ADDED_TO_ISCSI_BOND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_EXTENSION_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_EXTENSION_DOES_NOT_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_STATUS_ILLEGAL2(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TAG_ID_REQUIRED(ErrorType.BAD_PARAMETERS),
    STORAGE_POOL_REINITIALIZE_WITH_MORE_THAN_ONE_DATA_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_BELONGS_TO_DIFFERENT_STORAGE_POOL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_VDS_IN_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_TYPE_ILLEGAL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_VERSION_UNSUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_IS_BEING_REDUCED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DOMAIN_TYPE_CAN_BE_CREATED_ONLY_ON_SPECIFIC_STORAGE_DOMAINS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_FORMAT_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_FORMAT_ILLEGAL_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MASTER_STORAGE_DOMAIN_NOT_ACTIVE(ErrorType.CONFLICT),
    STORAGE_DOMAIN_NOT_ATTACHED_TO_STORAGE_POOL(ErrorType.CONFLICT),
    ERROR_CANNOT_ATTACH_MORE_THAN_ONE_ISO_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_ATTACH_MORE_THAN_ONE_EXPORT_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_DETACH_LAST_STORAGE_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_DESTROY_LAST_STORAGE_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_DESTROY_LAST_STORAGE_DOMAIN_HOST_NOT_ACTIVE(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_MASTER_WITH_NON_DATA_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_MASTER_WITH_LOCKED_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_DOMAIN_WITH_TASKS(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_STORAGE_DOMAIN_WITH_ISO_ATTACHED(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_STORAGE_DOMAIN_DURING_UPLOAD_OR_DOWNLOAD(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_ISO_DISK_ATTACHED_TO_VMS(ErrorType.CONFLICT),
    ERROR_ISO_DISK_ATTACHED_TO_RUNNING_VMS(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_MASTER_DOMAIN_WITH_TASKS_ON_POOL(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_DOMAIN_WITH_RUNNING_VMS_WITH_LEASES(ErrorType.CONFLICT),
    ERROR_CANNOT_ADD_STORAGE_POOL_WITHOUT_DATA_AND_ISO_DOMAINS(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_ADD_STORAGE_POOL_WITHOUT_DATA_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_ADD_STORAGE_DOMAIN_WITH_ATTACHED_DATA_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_ADD_STORAGE_POOL_WITH_DIFFERENT_STORAGE_FORMAT(ErrorType.CONFLICT),
    ERROR_CANNOT_CREATE_STORAGE_DOMAIN_WITHOUT_VG_LV(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_REMOVE_POOL_WITH_NETWORKS(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_POOL_WITH_ACTIVE_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_ATTACH_STORAGE_DOMAIN_STORAGE_TYPE_NOT_MATCH(ErrorType.CONFLICT),
    ERROR_CANNOT_ATTACH_STORAGE_DOMAIN_STORAGE_4K_UNSUPPORTED(ErrorType.CONFLICT),
    ERROR_CANNOT_CHANGE_STORAGE_POOL_TYPE_WITH_LOCAL(ErrorType.CONFLICT),
    ERROR_CANNOT_EXTEND_CONNECTION_FAILED(ErrorType.CONFLICT),
    ERROR_CANNOT_CHANGE_STORAGE_DOMAIN_FIELDS(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_REMOVE_STORAGE_POOL_WITH_NONMASTER_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_FORCE_REMOVE_STORAGE_POOL_WITH_VDS_NOT_IN_MAINTENANCE(ErrorType.CONFLICT),
    ERROR_CANNOT_UPDATE_STORAGE_POOL_COMPATIBILITY_VERSION_BIGGER_THAN_CLUSTERS(ErrorType.INCOMPATIBLE_VERSION),
    ERROR_CANNOT_UPDATE_STORAGE_POOL_SUSPENDED_VM_COMPATIBILITY_VERSION_NOT_SUPPORTED(ErrorType.CONFLICT),
    ERROR_CANNOT_ADD_EXISTING_STORAGE_DOMAIN_CONNECTION_DATA_ILLEGAL(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_MANAGE_STORAGE_DOMAIN(ErrorType.NOT_SUPPORTED),
    ERROR_CANNOT_FIND_ISO_IMAGE_PATH(ErrorType.BAD_PARAMETERS),
    ERROR_ISO_IMAGE_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ERROR_CANNOT_FIND_FLOPPY_IMAGE_PATH(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_REMOVE_SNAPSHOT_ILLEGAL_IMAGE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_PERFORMANCE_O_DIRECT_DISABLE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_SHARDING_DISABLE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_REMOTE_DIO_ON(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_GLUSTER_OPTIONS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_ALREADY_MASTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_MUST_BE_ACTIVE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SWITCH_MASTER_STORAGE_DOMAIN_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MASTER_ROLE_IS_BEING_SWITCHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    SWITCH_MASTER_STORAGE_DOMAIN_IS_NOT_SUPPORTED_FOR_GLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_GLUSTER_STORAGE_CONNECTION_UNSUPPORTED_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),

    VAR__TYPE__FINISHED_TASKS,
    VAR__TYPE__STORAGE__POOL,
    VAR__TYPE__MAC__POOL,
    VAR__TYPE__STORAGE__DOMAIN,
    VAR__TYPE__STORAGE__DOMAIN__SWITCH_MASTER,
    VAR__TYPE__STORAGE__CONNECTION,
    VAR__TYPE__STORAGE__CONNECTION__EXTENSION,
    VAR__ACTION__ATTACH,
    VAR__ACTION__SCAN,
    VAR__ACTION__DETACH,
    VAR__ACTION__ACTIVATE,
    VAR__ACTION__DEACTIVATE,
    VAR__ACTION__RESTORE,
    VAR__ACTION__RECONSTRUCT_MASTER,
    VAR__ACTION__RECOVER_POOL,
    VAR__ACTION__DESTROY_DOMAIN,
    VAR__TYPE__USER_FROM_VM,
    VAR__TYPE__USER,
    EN_UNKNOWN_NOTIFICATION_METHOD(ErrorType.BAD_PARAMETERS),
    EN_UNSUPPORTED_NOTIFICATION_EVENT(ErrorType.BAD_PARAMETERS),
    EN_ALREADY_SUBSCRIBED(ErrorType.CONFLICT),
    EN_NOT_SUBSCRIBED(ErrorType.CONFLICT),
    EN_UNKNOWN_TAG_NAME(ErrorType.BAD_PARAMETERS),
    VALIDATION_EVENTS_EMAIL_FORMAT(ErrorType.BAD_PARAMETERS),
    TAGS_CANNOT_EDIT_READONLY_TAG(ErrorType.CONFLICT),
    TAGS_SPECIFY_TAG_IS_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    TAGS_SPECIFY_TAG_IS_IN_USE(ErrorType.CONFLICT),
    TAGS_SPECIFIED_TAG_CANNOT_BE_THE_PARENT_OF_ITSELF(ErrorType.CONFLICT),
    AUDIT_LOG_CANNOT_REMOVE_AUDIT_LOG_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    TAGS_CANNOT_REMOVE_TAG_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VALIDATION_TAGS_INVALID_TAG_NAME(ErrorType.BAD_PARAMETERS),
    NETWORK_CANNOT_CONTAIN_BOND_NAME(ErrorType.BAD_PARAMETERS),
    VMPAYLOAD_INVALID_PAYLOAD_TYPE(ErrorType.CONFLICT),
    VMPAYLOAD_SIZE_EXCEEDED(ErrorType.CONSTRAINT_VIOLATION),
    VMPAYLOAD_FLOPPY_EXCEEDED(ErrorType.CONFLICT),
    VMPAYLOAD_FLOPPY_WITH_SYSPREP(ErrorType.CONFLICT),
    VMPAYLOAD_CDROM_WITH_CLOUD_INIT(ErrorType.CONFLICT),
    VMPAYLOAD_CDROM_OR_CLOUD_INIT_MAXIMUM_DEVICES(ErrorType.CONFLICT),
    VALIDATION_CLOUD_INIT_START_ON_BOOT_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_CLOUD_INIT_IPV6_AUTOCONF_UNSUPPORTED(ErrorType.BAD_PARAMETERS),
    VALIDATION_CLOUD_INIT_STATIC_IPV4_ADDRESS_MISSING(ErrorType.BAD_PARAMETERS),
    VALIDATION_CLOUD_INIT_STATIC_IPV6_ADDRESS_MISSING(ErrorType.BAD_PARAMETERS),
    CANNOT_MOVE_DISK_SNAPSHOTS(ErrorType.CONFLICT),
    CANNOT_MOVE_DISK_TEMPLATE(ErrorType.CONFLICT),

    ACTION_TYPE_FAILED_BOOKMARK_INVALID_ID(ErrorType.BAD_PARAMETERS),
    VDS_FENCE_OPERATION_FAILED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GENERATOR_NOT_SUPPORTED_BY_CLUSTER(ErrorType.CONFLICT),
    CAN_DO_ACTION_GENERAL_FAILURE(ErrorType.INTERNAL_ERROR),
    CAN_DO_ACTION_DATABASE_CONNECTION_FAILURE(ErrorType.INTERNAL_ERROR),
    /** @deprecated as it is too general error message */
    @Deprecated
    ACTION_TYPE_FAILED_OBJECT_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_IS_USED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_POOL_IS_USED_FOR_CREATE_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_USED_FOR_CREATE_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SNAPSHOT_IS_BEING_TAKEN_FOR_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_HIBERNATING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_USED_FOR_CREATE_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_BEING_REMOVED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_OVF_DISK_IS_BEING_USED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_UNSUPPORTED_OVF(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DOMAIN_OVF_ON_UPDATE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_FIND_DISK_IMAGE_IN_ACTIVE_DOMAINS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_BEING_MIGRATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IMAGE_CANNOT_BE_MEASURED_WHILE_USED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_NAME_IS_USED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_BEING_CREATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_BEING_CREATED_FROM_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_VERSION_IS_BEING_CREATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_EXPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_BEING_EXPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_VALID_DOMAINS_STATUS_FOR_TEMPLATE_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_MIGRATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_IMPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_BEING_REMOVED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_REMOVED_FROM_EXPORT_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_BEING_EXPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_OVA_DESTINATION_FOLDER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_POOL_IS_BEING_REMOVED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_POOL_IS_BEING_UPDATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_POOL_IS_BEING_REMOVED_WITH_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_POOL_IS_BEING_CREATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_CREATED_AND_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_REMOVED_FROM_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_COMPATIBILITY_VERSION_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_USB_UNMANAGED_DEV_EXCEEDED_LIMIT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_SMARTCARD_NOT_SUPPORTED_WITHOUT_USB(ErrorType.BAD_PARAMETERS),
    VM_OR_TEMPLATE_ILLEGAL_PRIORITY_VALUE(ErrorType.BAD_PARAMETERS),

    USER_FAILED_TO_AUTHENTICATION_WRONG_AUTHENTICATION_METHOD(ErrorType.NO_AUTHENTICATION),
    ACTION_TYPE_FAILED_VM_IS_PINNED_TO_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PINNED_VM_NOT_RUNNING_ON_DEDICATED_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_USES_SCSI_RESERVATION(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SGIO_IS_FILTERED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NON_MIGRTABLE_AND_IS_NOT_FORCED_BY_USER_TO_MIGRATE(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_IT_INCLUDES_NON_MIGRATABLE_VM(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_GLUSTER_QUORUM_CANNOT_BE_MET(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_UNSYNCED_ENTRIES_PRESENT_IN_GLUSTER_BRICKS(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VM_HAS_PLUGGED_DISK_SNAPSHOT(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_NO_ALTERNATE_HOST_FOR_HOSTED_ENGINE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_CONTENT_TYPE_NOT_SUPPORTED_FOR_OPERATION(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MEMORY_DISK_SNAPSHOT_IN_PREVIEW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_A_HOSTED_ENGINE_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_HIBERNATION_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_OVF_DISK_NOT_IN_APPLICABLE_STATUS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISKS_SNAPSHOTS_DONT_BELONG_TO_SAME_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_HAS_UNPLUGGED_OR_UNATTACHED_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_BE_HIGHLY_AVAILABLE_AND_PINNED_TO_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_BE_HIGHLY_AVAILABLE_AND_HOSTED_ENGINE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_BE_HIGH_PERFORMANCE_AND_HOSTED_ENGINE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_BE_PINNED_TO_CPU_WITH_UNDEFINED_HOST(ErrorType.BAD_PARAMETERS),
    VM_PINNED_TO_HOST_CANNOT_RUN_ON_THE_DEFAULT_VDS(ErrorType.CONFLICT),
    HOST_NAME_NOT_AVAILABLE(ErrorType.BAD_PARAMETERS),
    VM_HOSTCPU_MUST_BE_PINNED_TO_HOST(ErrorType.CONFLICT),
    MIGRATION_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    MIGRATION_ON_ERROR_IS_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_RANDOM_RNG_SOURCE_CANT_BE_ADDED_TO_CLUSTER_ADDITIONAL_RNG_SOURCES(ErrorType.BAD_PARAMETERS),
    VM_MIGRATION_IS_NOT_SUPPORTED(ErrorType.CONFLICT),
    VM_ID_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MIGRATION_OF_NON_MIGRATABLE_PASSTHROUGH_VNICS_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    CANNOT_LIVE_MIGRATE_VM_SHOULD_BE_IN_PAUSED_OR_UP_STATUS(ErrorType.CONFLICT),

    ACTION_TYPE_FAILED_VM_LEASES_ARE_NOT_SUPPORTED_WITH_HA_OFF(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOT_SWAPPING_VM_LEASES_NOT_SUPPORTED(ErrorType.CONFLICT),


    ACTION_TYPE_FAILED_CANNOT_MIGRATE_MACS_DUE_TO_DUPLICATES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_ADD_IFACE_DUE_TO_MAC_DUPLICATES(ErrorType.CONFLICT),

    ACTION_TYPE_FAILED_STORAGE_POOL_IS_NOT_LOCAL(ErrorType.BAD_PARAMETERS),
    RHEVH_LOCALFS_WRONG_PATH_LOCATION(ErrorType.BAD_PARAMETERS),

    VDS_CANNOT_ADD_MORE_THEN_ONE_HOST_TO_LOCAL_STORAGE(ErrorType.CONSTRAINT_VIOLATION),
    VDS_CANNOT_REMOVE_HOST_WITH_LOCAL_STORAGE(ErrorType.CONFLICT),

    CLUSTER_CANNOT_ADD_MORE_THEN_ONE_HOST_TO_LOCAL_STORAGE(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_SELECTION_ALGORITHM_MUST_BE_SET_TO_NONE_ON_LOCAL_STORAGE(ErrorType.BAD_PARAMETERS),
    CLUSTER_CANNOT_DETACH_DATA_DOMAIN_FROM_LOCAL_STORAGE(ErrorType.CONFLICT),
    VALIDATION_DATA_CENTER_DESCRIPTION_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_DATA_CENTER_NAME_INVALID(ErrorType.BAD_PARAMETERS),

    CLUSTER_CPU_UTILIZATION_MUST_BE_IN_VALID_RANGE(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_CPU_LOW_UTILIZATION_PERCENTAGE_MUST_BE_LOWER_THAN_HIGH_PERCENTAGE(ErrorType.BAD_PARAMETERS),
    CLUSTER_CPU_HIGH_UTILIZATION_PERCENTAGE_MUST_BE_DEFINED_WHEN_USING_EVENLY_DISTRIBUTED(ErrorType.BAD_PARAMETERS),
    CLUSTER_BOTH_LOW_AND_HIGH_CPU_UTILIZATION_PERCENTAGE_MUST_BE_DEFINED_WHEN_USING_POWER_SAVING(
            ErrorType.BAD_PARAMETERS),
    CLUSTER_HOSTS_MUST_BE_DOWN(ErrorType.CONFLICT),
    CLUSTER_AT_LEAST_ONE_SERVICE_MUST_BE_ENABLED(ErrorType.BAD_PARAMETERS),
    CLUSTER_ENABLING_BOTH_VIRT_AND_GLUSTER_SERVICES_NOT_ALLOWED(ErrorType.CONFLICT),
    CLUSTER_CANNOT_DISABLE_VIRT_WHEN_CLUSTER_CONTAINS_VMS(ErrorType.CONFLICT),
    CLUSTER_CANNOT_DISABLE_GLUSTER_WHEN_CLUSTER_CONTAINS_VOLUMES(ErrorType.CONFLICT),
    CLUSTER_TO_ALLOW_MEMORY_OPTIMIZATION_YOU_MUST_ALLOW_KSM_OR_BALLOONING(ErrorType.CONFLICT),
    CLUSTER_IMPLICIT_AFFINITY_GROUP_IS_NOT_SUPPORTED(ErrorType.CONFLICT),
    VDS_CANNOT_UPDATE_CLUSTER(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_UPDATE_CLUSTER(ErrorType.BAD_PARAMETERS),
    VM_STATUS_NOT_VALID_FOR_UPDATE(ErrorType.CONFLICT),
    PERMISSION_ADD_FAILED_PERMISSION_NOT_SENT(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_INVALID_ROLE_ID(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_INVALID_OBJECT_ID(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_USER_ID_MISMATCH(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_ONLY_SYSTEM_SUPER_USER_CAN_GIVE_ADMIN_ROLES(ErrorType.NO_PERMISSION),
    PERMISSION_ADD_FAILED_VM_IN_POOL(ErrorType.CONFLICT),
    PERMISSION_REMOVE_FAILED_ONLY_SYSTEM_SUPER_USER_CAN_REMOVE_ADMIN_ROLES(ErrorType.NO_PERMISSION),
    INHERITED_PERMISSION_CANT_BE_REMOVED(ErrorType.CONFLICT),
    SYSTEM_PERMISSIONS_CANT_BE_REMOVED_FROM_EVERYONE(ErrorType.CONFLICT),
    CANNOT_ADD_ACTION_GROUPS_TO_ROLE_TYPE(ErrorType.CONFLICT),
    ROLE_TYPE_CANNOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    VALIDATION_ROLES_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_ROLES_NAME_MAX(ErrorType.BAD_PARAMETERS),
    VALIDATION_ROLES_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_INVALID_SYNTAX(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_INVALID_KEYS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_INVALID_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_DUPLICATE_KEYS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CUSTOM_PROPERTIES_NOT_SUPPORTED_IN_VERSION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_DEVICE_TYPE_FOR_CUSTOM_PROPERTIES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_CUSTOM_PROPERTIES_BAD_INPUT(ErrorType.BAD_PARAMETERS),
    ATTACHMENT_REFERENCE_VLAN_DEVICE(ErrorType.BAD_PARAMETERS),
    ATTACHMENT_IS_NOT_REUSED(ErrorType.BAD_PARAMETERS),

    ACTION_TYPE_FAILED_INVALID_PUBLIC_SSH_KEY(ErrorType.BAD_PARAMETERS),

    NETWORK_ILEGAL_NETWORK_NAME(ErrorType.BAD_PARAMETERS),
    NETWORK_NAME_USED_AS_VDSM_NETWORK_NAME(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACH_ILLEGAL_GATEWAY(ErrorType.BAD_PARAMETERS),
    MISSING_DIRECTORY_ELEMENT_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_NOT_MATCH_VALID_STATUS(ErrorType.CONFLICT),
    CANNOT_REMOVE_STORAGE_DOMAIN_INVALID_HOST_ID(ErrorType.BAD_PARAMETERS),
    CANNOT_REMOVE_STORAGE_DOMAIN_HOST_NOT_UP(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_ACTIVE_STORAGE_POOL(ErrorType.CONFLICT),
    USER_FAILED_TO_AUTHENTICATE_WRONG_USERNAME_OR_PASSWORD(ErrorType.NO_AUTHENTICATION),
    CLUSTER_CANNOT_UPDATE_CPU_WITH_SUSPENDED_VMS(ErrorType.CONFLICT),
    CLUSTER_CPU_IS_NOT_UPDATABLE(ErrorType.CONFLICT),
    CPU_TYPE_UNSUPPORTED_IN_THIS_CLUSTER_VERSION(ErrorType.CONFLICT),
    USER_FAILED_TO_AUTHENTICATE_ACCOUNT_IS_LOCKED_OR_DISABLED(ErrorType.NO_AUTHENTICATION),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_BUILTIN_GROUP_EVERYONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_IMPORT_DATA_DOMAIN_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_RESET_VM_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    VM_CANNOT_RUN_ONCE_WITH_ILLEGAL_SYSPREP_PARAM(ErrorType.BAD_PARAMETERS),
    MOVE_VM_CLUSTER_MISSING_NETWORK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_WITH_DEFAULT_CLUSTER_CANNOT_BE_LOCALFS(ErrorType.CONFLICT),
    DEFAULT_CLUSTER_CANNOT_BE_ON_LOCALFS(ErrorType.CONFLICT),
    HOT_PLUG_CPU_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_PLUG_CPU_IS_NOT_SUPPORTED_FOR_GUEST_OS(ErrorType.NOT_SUPPORTED),
    HOT_UNPLUG_CPU_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_UNPLUG_CPU_IS_NOT_SUPPORTED_FOR_GUEST_OS(ErrorType.NOT_SUPPORTED),
    HOT_PLUG_MEMORY_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_UNPLUG_MEMORY_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NO_MORE_MEMORY_SLOTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MEMORY_MUST_BE_MULTIPLICATION(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_UNLINKING_OF_PASSTHROUGH_VNIC_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_PLUG_IDE_DISK_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_PLUG_SPAPR_VSCSI_DISK_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NETWORK_QOS_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    PLUGGED_UNLINKED_VM_INTERFACE_WITH_EXTERNAL_NETWORK_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_INTERFACE_TYPE_IS_NOT_SUPPORTED_BY_OS(ErrorType.INCOMPATIBLE_VERSION),
    ACTION_TYPE_FAILED_VM_INTERFACE_TYPE_NOT_MATCH_PROFILE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ONLY_EXTERNAL_NETWORK_IS_SUPPORTED_IN_OVS_SWITCH_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_INTERFACE_WITH_FAILOVER_IS_SUPPORTED_ONLY_IN_CLUSTER_4_6_AND_ABOVE(ErrorType.NOT_SUPPORTED),
    CANNOT_PERFORM_HOT_UPDATE(ErrorType.CONFLICT),
    CANNOT_PERFORM_HOT_UPDATE_WITH_PORT_MIRRORING(ErrorType.CONFLICT),
    PORT_MIRRORING_REQUIRES_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GUEST_OS_VERSION_IS_NOT_SUPPORTED(ErrorType.CONFLICT),
    HOT_PLUG_DISK_IS_NOT_VIRTIO(ErrorType.CONFLICT),
    HOT_PLUG_DISK_IS_NOT_UNPLUGGED(ErrorType.CONFLICT),
    HOT_UNPLUG_DISK_IS_NOT_PLUGGED(ErrorType.CONFLICT),
    CANNOT_ADD_FLOATING_DISK_WITH_PLUG_VM_SET(ErrorType.CONFLICT),
    ACTIVATE_DEACTIVATE_NETWORK_NOT_IN_VDS(ErrorType.CONFLICT),
    PHYSICAL_NETWORK_LINKED_TO_EXTERNAL_NOT_IN_VDS(ErrorType.CONFLICT),
    DEACTIVATE_MANAGEMENT_NETWORK_FOR_HOSTED_ENGINE(ErrorType.CONFLICT),
    HOSTED_ENGINE_VM_CANNOT_HAVE_NIC_WITH_EMPTY_PROFILE(ErrorType.NOT_SUPPORTED),
    SHAREABLE_DISK_IS_NOT_SUPPORTED_FOR_DISK(ErrorType.CONFLICT),
    SHAREABLE_DISK_IS_NOT_SUPPORTED_BY_VOLUME_FORMAT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_THIN_TEMPLATE_DISKS_SHOULD_ONLY_BE_COW(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_DETACH_DISK_WITH_SNAPSHOT(ErrorType.CONFLICT),
    DISK_IS_ALREADY_SHARED_BETWEEN_VMS(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_DISK_WITHOUT_PLUGGED_DISK(ErrorType.CONFLICT),
    SCSI_GENERIC_IO_IS_NOT_SUPPORTED_FOR_IMAGE_DISK(ErrorType.NOT_SUPPORTED),
    SCSI_PASSTHROUGH_IS_NOT_SUPPORTED_FOR_READ_ONLY_DISK(ErrorType.NOT_SUPPORTED),
    CANNOT_PERFORM_ACTION_VIRTIO_SCSI_IS_DISABLED(ErrorType.CONFLICT),
    CANNOT_DISABLE_VIRTIO_SCSI_PLUGGED_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_NULL_NOT_ALLOWED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QUOTA_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QUOTA_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QUOTA_DEFAULT_CANNOT_BE_CHANGED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QUOTA_NOT_DEFINED_FOR_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QUOTA_NOT_DEFINED_FOR_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_QUOTA_SET_FOR_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_IS_NO_LONGER_AVAILABLE_IN_SYSTEM(ErrorType.DATA_CORRUPTION),
    ACTION_TYPE_FAILED_QUOTA_LIMIT_IS_SPECIFIC_AND_GENERAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_IN_USE_BY_VM_OR_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_STORAGE_LIMIT_EXCEEDED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_CLUSTER_LIMIT_EXCEEDED(ErrorType.CONFLICT),
    USER_NOT_AUTHORIZED_TO_CONSUME_QUOTA(ErrorType.NO_PERMISSION),
    VALIDATION_QUOTA_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NOT_A_VM_NETWORK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_NOT_IN_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_NOT_VM_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_NOT_ATTACHED_TO_VM(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_DETACH_DISK_IS_NOT_ATTACHED_TO_VM(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISKS_NOT_ATTACHED_TO_VM(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_PLUGGED_TO_NON_DOWN_VMS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_VM_DATA_MISSING(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISKS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_SNAPSHOTS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_SNAPSHOTS_ACTIVE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_SNAPSHOT_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DAMAGED_IMAGE_SNAPSHOT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_DISKS_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_DISKS_IMAGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANT_MOVE_SHAREABLE_DISK_TO_GLUSTERFS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANT_MOVE_OR_COPY_SHAREABLE_THIN_DISK_TO_BLOCK_DOMAIN(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_SOURCE_AND_TARGET_SAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_REQUESTED_DISK_SIZE_IS_TOO_SMALL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_RESIZE_READ_ONLY_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_RESIZE_DISK_SNAPSHOT(ErrorType.CONFLICT),
    NON_VM_NETWORK_NOT_SUPPORTED_FOR_POOL_LEVEL(ErrorType.NOT_SUPPORTED),
    VM_SLA_POLICY_UNCHANGED(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_INVALID_PORT(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_EMPTY_VFSTYPE(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_MOUNT_OPTIONS_CONTAINS_MANAGED_PROPERTY(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_EMPTY_IQN(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_EMPTY_CONNECTION(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_NFS_RETRANS(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_NFS_TIMEO(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_INVALID_GLUSTER_VOLUME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ACTION_IS_SUPPORTED_ONLY_FOR_ISCSI_DOMAINS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ACTION_IS_SUPPORTED_ONLY_FOR_DATA_DOMAINS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_ID_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_ID_NOT_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_BASE_TEMPLATE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_HA_NOT_CONFIGURED(ErrorType.BAD_PARAMETERS),

    ACTION_TYPE_FAILED_HOST_NETWORK_LABEL_ON_UNMANAGED_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_ATTACHEMENT_ON_UNMANAGED_NETWORK(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_WITH_UNMANAGED_NETWORK_CANNOT_BE_SLAVE(ErrorType.BAD_PARAMETERS),
    REMOVED_UNMANAGED_NETWORK_IS_A_CLUSTER_NETWORK(ErrorType.BAD_PARAMETERS),
    REMOVED_UNMANAGED_NETWORK_DOES_NOT_EXISIT_ON_HOST(ErrorType.BAD_PARAMETERS),

    // Reduce Image
    ACTION_TYPE_FAILED_REDUCE_IMAGE_NOT_SUPPORTED_FOR_FILE_DOMAINS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_REDUCE_IMAGE_NOT_SUPPORTED_FOR_ACTIVE_IMAGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_REDUCE_IMAGE_NOT_SUPPORTED_FOR_SHAREABLE_DISK(ErrorType.CONFLICT),

    // Scheduling Policy messages
    ACTION_TYPE_FAILED_CLUSTER_POLICY_PARAMETERS_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_DUPLICATE_POLICY_UNIT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_NAME_INUSE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_LOCKED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_INUSE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_UNKNOWN_POLICY_UNIT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_FILTER_NOT_IMPLEMENTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_FUNCTION_NOT_IMPLEMENTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_BALANCE_NOT_IMPLEMENTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_SELECTOR_NOT_IMPLEMENTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_ONLY_ONE_FILTER_CAN_BE_FIRST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_ONLY_ONE_FILTER_CAN_BE_LAST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_FUNCTION_FACTOR_NEGATIVE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_POLICY_UNIT_ATTACHED_TO_CLUSTER_POLICY(ErrorType.CONFLICT),
    // Gluster Messages
    ACTION_TYPE_FAILED_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_DOES_NOT_SUPPORT_GLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_NAME_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_BRICKS_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_BRICK_ID_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ONE_OR_MORE_BRICKS_ARE_DOWN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_BRICK_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_ARBITER_VOLUME_SHOULD_BE_REPLICA_3_VOLUME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_REPLICA_COUNT_MIN_2(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_DISTRIBUTED_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_STRIPED_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_DISTRIBUTED_STRIPED_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STRIPE_COUNT_MIN_4(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_STRIPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_DISTRIBUTED_STRIPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_SERVER_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_ALREADY_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_ALREADY_STOPPED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_IS_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_HAS_SNAPSHOTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SHOULD_BE_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_NOT_DISTRIBUTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_DISTRIBUTED_AND_HAS_SINGLE_BRICK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REBALANCE_NOT_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_CANNOT_STOP_REBALANCE_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_CANNOT_STOP_REMOVE_BRICK_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_IS_DOWN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_IS_NOT_THINLY_PROVISIONED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_CONFIG_PARAMS_IS_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_CONFIG_PARAM_VALUE_IS_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_START_DATE_BEFORE_CURRENT_DATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_END_BY_DATE_BEFORE_CURRENT_DATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_END_BY_DATE_BEFORE_START_DATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NOT_A_GLUSTER_VOLUME_BRICK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REMOVE_BRICKS_NOT_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REMOVE_BRICKS_NOT_FINISHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REMOVE_BRICKS_PARAMS_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_INVALID_TASK_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CAN_NOT_REMOVE_ALL_BRICKS_FROM_VOLUME(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_REPLICA_COUNT_MORE_THAN_ONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_REPLICA_COUNT_WITH_DATA_MIGRATION(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_INCREASE_REPLICA_COUNT_MORE_THAN_ONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_INCREASE_STRIPE_COUNT_MORE_THAN_ONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_REPLICA_COUNT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_INCREASE_REPLICA_COUNT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_STRIPE_COUNT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_BRICK_ALREADY_EXISTS_IN_VOLUME(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DUPLICATE_BRICKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_REPLICASET_SAME_SERVER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ADD_BRICK_TO_DISPERSE_VOLUME_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_ADD_BRICK_TO_DISTRIBUTED_DISPERSE_VOLUME_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_REMOVE_BRICK_FROM_DISPERSE_VOLUME_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_REMOVE_BRICK_FROM_DISTRIBUTED_DISPERSE_VOLUME_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_CREATION_OF_DISPERSE_VOLUME_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NO_UP_SERVER_FOUND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_HOOK_ID_IS_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_HOOK_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VDS_CANNOT_REMOVE_HOST_HAVING_GLUSTER_VOLUME(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_GLUSTER_HOST_TO_PEER_PROBE(ErrorType.CONFLICT),
    MIGRATE_PAUSED_EIO_VM_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_SERVER_NAME_REQUIRED(ErrorType.BAD_PARAMETERS),
    SERVER_ALREADY_EXISTS_IN_ANOTHER_CLUSTER(ErrorType.CONFLICT),
    SERVER_ALREADY_PART_OF_ANOTHER_CLUSTER(ErrorType.CONFLICT),
    CLUSTER_ALL_SERVERS_NOT_UP(ErrorType.CONFLICT),
    SSH_AUTHENTICATION_FAILED(ErrorType.NO_AUTHENTICATION),
    GLUSTER_VOLUME_ID_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SERVER_PART_OF_ANOTHER_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_HOOK_NO_CONFLICT_SERVERS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SERVER_STATUS_NOT_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_ACTION_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTERID_AND_SERVERID_BOTH_NULL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_SERVERS_FOR_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VOLUME_OPERATION_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_OPERATION_INPROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GEOREP_SESSION_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ONE_OR_MORE_REMOTE_HOSTS_ARE_NOT_ACCESSIBLE(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_GLUSTER_GEOREP_SESSION_ALREADY_CREATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GEOREP_SESSION_ALREADY_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GEOREP_SESSION_ALREADY_PAUSED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GEOREP_SESSION_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_REMOTE_CLUSTER_NOT_MAINTAINED_BY_ENGINE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VOLUME_SNAPSHOT_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GEOREP_SESSION_STOPPED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GEOREP_SESSION_ALREADY_RESUMED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_GEOREP_CONFIG_SET(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_GEOREP_CONFIG_DEFAULT_SET(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_NAME_IS_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_DOES_NOT_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_NO_SNAPSHOTS_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_ALREADY_ACTIVATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_ALREADY_DEACTIVATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_PROVISIONING_NOT_SUPPORTED_BY_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_GLUSTER_SERVICE_MAINTENANCE_NOT_SUPPORTED_FOR_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_SNAPSHOT_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_ALREADY_SCHEDULED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SNAPSHOT_NOT_SCHEDULED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DEVICE_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DEVICE_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DIFFERENT_STORAGE_DEVICE_TYPES_SELECTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DEVICE_IS_ALREADY_IN_USE(ErrorType.BAD_PARAMETERS),
    GLUSTER_NETWORK_NOT_SUPPORTED_FOR_POOL_LEVEL(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_GLUSTER_NO_PUB_KEYS_PASSED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VOLUME_ASYNC_OPERATION_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_CLI_SCHEDULING_ENABLED(ErrorType.CONFLICT),
    VALIDATION_GLUSTER_VOLUME_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_CLUSTER_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_TYPE_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_REPLICA_COUNT_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_STRIPE_COUNT_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_BRICKS_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_OPTION_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_OPTION_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_OPTION_KEY_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_OPTION_VALUE_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_BRICK_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_BRICK_SERVER_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_VOLUME_BRICK_BRICK_DIR_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_GLUSTER_GLUSTER_HOOK_ID_NOT_NULL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAIL_VDS_CANNOT_CONNECT_TO_GLUSTERFS(ErrorType.CONFLICT),
    ACTION_TYPE_NOT_SUPPORTED_FOR_VOLUME_TYPE(ErrorType.CONFLICT),
    ERROR_STORAGE_DOMAIN_SYNC_EXISTS(ErrorType.CONFLICT),
    VALIDATION_INVALID_SCHEDULE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GEOREP_SESSION_USED_IN_STORAGE_SYNC(ErrorType.CONFLICT),
    SCHEDULE_MINS_OUT_OF_RANGE(ErrorType.BAD_PARAMETERS),
    SCHEDULE_HOUR_OUT_OF_RANGE(ErrorType.BAD_PARAMETERS),
    STORAGE_DOMAIN_SYNC_SCHEDULING_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_GLUSTER_VOLUME_PRESENT_IN_STORAGE_DOMAIN(ErrorType.CONFLICT),
    // OpenStack Glance
    ACTION_TYPE_FAILED_IMAGE_DOWNLOAD_ERROR(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_FIND_SPECIFIED_IMAGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_IMPORT_IMAGE_FROM_REPOSITORY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_IMAGE_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_UNRECOGNIZED(ErrorType.BAD_PARAMETERS),

    VM_INTERFACE_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_ACTIVE_DEVICE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_IMPORT_CLONE_NOT_COLLAPSED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMPORT_UNREGISTERED_NOT_COLLAPSED(ErrorType.BAD_PARAMETERS),

    /* VDSM Error that propagates up to the client. See EngineError */
    ERROR_GET_STORAGE_DOMAIN_LIST(ErrorType.INTERNAL_ERROR), // EngineError.GetStorageDomainListError

    ERROR_GET_IMAGE_LIST(ErrorType.INTERNAL_ERROR),

    USER_CANNOT_FORCE_RECONNECT_TO_VM(ErrorType.CONFLICT),
    // Engine maintenance mode
    ENGINE_IS_RUNNING_IN_MAINTENANCE_MODE(ErrorType.CONFLICT),
    // Engine prepare mode
    ENGINE_IS_RUNNING_IN_PREPARE_MODE(ErrorType.CONFLICT),

    // External Events
    ACTION_TYPE_FAILED_EXTERNAL_EVENT_ILLEGAL_ORIGIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_EXTERNAL_EVENT_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_EXTERNAL_EVENT_DUPLICATE_CUSTOM_ID(ErrorType.BAD_PARAMETERS),

    // External Tasks
    ACTION_TYPE_EMPTY_DESCRIPTION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NOT_EXTERNAL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NO_PARENT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NO_JOB(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NO_STEP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NON_MONITORED(ErrorType.NOT_SUPPORTED),

    // Internal Job
    ACTION_TYPE_EMPTY_ACTION_TYPE(ErrorType.BAD_PARAMETERS),

    // watchdog
    WATCHDOG_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    WATCHDOG_ALREADY_EXISTS(ErrorType.CONFLICT),
    WATCHDOG_ACTION_REQUIRED(ErrorType.BAD_PARAMETERS),
    WATCHDOG_MODEL_REQUIRED(ErrorType.BAD_PARAMETERS),

    // rng device
    ACTION_TYPE_FAILED_RNG_NOT_FOUND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_RNG_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_RNG_SOURCE_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_RNG_MUST_BE_SPECIFIED(ErrorType.BAD_PARAMETERS),

    // QoS
    ACTION_TYPE_FAILED_QOS_OUT_OF_RANGE_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_STORAGE_POOL_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_STORAGE_POOL_NOT_CONSISTENT(ErrorType.BAD_PARAMETERS),
    QOS_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    QOS_NAME_TOO_LONG(ErrorType.BAD_PARAMETERS),
    QOS_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_QOS_ILLEGAL_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_MISSING_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_NEGATIVE_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_NAME_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_NOT_FOUND(ErrorType.BAD_PARAMETERS),

    // network QoS
    ACTION_TYPE_FAILED_NETWORK_QOS_MISSING_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NEGATIVE_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NAME_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_MISSING_DATA(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_INVALID_DC_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_PEAK_LOWER_THAN_AVERAGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_MISSING_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_SETUP_NETWORKS_MISSING_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_INCONSISTENT_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_SETUP_NETWORKS_INCONSISTENT_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_INTERFACES_WITHOUT_QOS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_INVALID_INTERFACE_SPEED(ErrorType.CONFLICT),

    // scheduling
    VAR__FILTERTYPE__INTERNAL,
    VAR__FILTERTYPE__EXTERNAL,
    VAR__DETAIL__NETWORK_MISSING,
    VAR__DETAIL__DISPLAY_NETWORK_MISSING,
    VAR__DETAIL__DISPLAY_NETWORK_HAS_NO_BOOT_PROTOCOL,
    VAR__DETAIL__NO_SUITABLE_VF,
    CANNOT_PLUG_PASSTHROUGH_VNIC_NO_SUITABLE_VF,
    VAR__DETAIL__AFFINITY_FAILED_POSITIVE,
    VAR__DETAIL__AFFINITY_FAILED_NEGATIVE,
    VAR__DETAIL__LOW_CPU_LEVEL,
    VAR__DETAIL__CPU_FLAGS_NOT_IDENTICAL,
    VAR__DETAIL__CPU_OVERLOADED,
    VAR__DETAIL__UNSUPPORTED_EMULATED_MACHINE,
    VAR__DETAIL__SWAP_VALUE_ILLEGAL,
    VAR__DETAIL__NOT_ENOUGH_MEMORY,
    VAR__DETAIL__NOT_ENOUGH_HUGE_PAGES,
    VAR__DETAIL__NUMA_NOT_SUPPORTED,
    VAR__DETAIL__NOT_MEMORY_PINNED_NUMA,
    VAR__DETAIL__NOT_ENOUGH_CORES,
    VAR__DETAIL__VM_PINNING_PCPU_DOES_NOT_EXIST,
    VAR__DETAIL__NUMA_PINNING_FAILED,
    VAR__DETAIL__NOT_HE_HOST,
    VAR__DETAIL__HE_HOST_NOT_POSITIVE_SCORE,
    VAR__DETAIL__HE_HOST_LOW_SCORE,
    VAR__DETAIL__NOT_ENOUGH_HE_SPARES,
    VAR__DETAIL__SAME_HOST,
    VAR__DETAIL__TSC_FREQ_MISMATCH,
    VAR__DETAIL__HOSTDEV_DISABLED,
    VAR__DETAIL__HOST_DEVICE_UNAVAILABLE,
    VAR__DETAIL__HOST_MDEV_DEVICE_MISSING,
    VAR__DETAIL__HOST_MDEV_DEVICE_UNAVAILABLE,
    VAR__DETAIL__WRONG_HOST_FOR_REQUESTED_HOST_DEVICES,
    VAR__DETAIL__UNSUPPORTED_COMPATIBILITY_VERSION,
    VAR__DETAIL__INVALID_OS,
    VAR__DETAIL__WRONG_OS,
    VAR__DETAIL__OLD_OS,
    VAR__DETAIL__CLUSTER_IN_MAINTENANCE,
    VAR__DETAIL__NOT_PINNED_TO_HOST,
    SCHEDULING_NO_HOSTS,
    SCHEDULING_HOST_FILTERED_REASON,
    SCHEDULING_HOST_FILTERED_REASON_WITH_DETAIL,
    SCHEDULING_ALL_HOSTS_FILTERED_OUT(ErrorType.CONFLICT),

    // CPU QoS features
    QOS_CPU_SHARES_OUT_OF_RANGE(ErrorType.BAD_PARAMETERS),

    // profiles
    ACTION_TYPE_FAILED_PROFILE_MISSING(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROFILE_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROFILE_NAME_IN_USE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_CHANGE_PROFILE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROFILE_IN_USE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_DISK_PROFILE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_PROFILE_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_DISK_PROFILE_STORAGE_DOMAIN_NOT_PROVIDED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_DISK_PROFILE_NOT_MATCH_STORAGE_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_DISK_PROFILE_NOT_FOUND_FOR_STORAGE_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CPU_PROFILE_CLUSTER_NOT_PROVIDED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CPU_PROFILE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CPU_PROFILE_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CPU_PROFILE_NOT_MATCH_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CANNOT_REMOVE_LAST_CPU_PROFILE_IN_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_CANNOT_REMOVE_LAST_DISK_PROFILE_IN_STORAGE_DOMAIN(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_NO_PERMISSION_TO_ASSIGN_CPU_PROFILE(ErrorType.NO_PERMISSION),
    USER_NOT_AUTHORIZED_TO_ATTACH_DISK_PROFILE(ErrorType.NO_PERMISSION),

    // Affinity Groups
    AFFINITY_GROUP_NAME_TOO_LONG(ErrorType.BAD_PARAMETERS),
    AFFINITY_GROUP_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    AFFINITY_GROUP_DESCRIPTION_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_AFFINITY_GROUP_INVALID_CLUSTER_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CLUSTER_FOR_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_ENTITY_FOR_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_LABEL_FOR_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ENTITY_NOT_IN_AFFINITY_GROUP_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DUPLICATE_ENTITY_IN_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DUPLICATE_LABEL_IN_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_AFFINITY_GROUP_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_CHANGE_CLUSTER_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_AFFINITY_GROUP_NAME_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_AFFINITY_GROUPS_NOT_FROM_SELECTED_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_POSITIVE_AFFINITY_GROUP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NEGATIVE_AFFINITY_GROUP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIX_POSITIVE_NEGATIVE_AFFINITY_GROUP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_AFFINITY_RULES_COLLISION(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_AFFINITY_HOSTS_RULES_COLLISION(ErrorType.CONFLICT),
    AFFINITY_GROUPS_LIST,
    HOSTS_LIST,
    VMS_LIST,

    // Affinity labels
    AFFINITY_LABEL_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    AFFINITY_LABEL_BAD_NAME(ErrorType.BAD_PARAMETERS),
    AFFINITY_LABEL_NAME_SIZE_INVALID(ErrorType.BAD_PARAMETERS),
    AFFINITY_LABEL_NOT_FROM_SELECTED_CLUSTER(ErrorType.BAD_PARAMETERS),
    AFFINITY_LABEL_NOT_EMPTY(ErrorType.CONFLICT),
    AFFINITY_LABEL_ID_ALREADY_EXISTS(ErrorType.CONFLICT),
    AFFINITY_LABEL_NAME_ALREADY_EXISTS(ErrorType.CONFLICT),
    AFFINITY_LABEL_READ_ONLY(ErrorType.CONFLICT),

    // Iscsi bonds
    ISCSI_BOND_WITH_SAME_NAME_EXIST_IN_DATA_CENTER(ErrorType.CONFLICT),
    ISCSI_BOND_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VALIDATION_ISCSI_BOND_NAME_MAX(ErrorType.BAD_PARAMETERS),
    VALIDATION_ISCSI_BOND_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_ISCSI_BOND_DESCRIPTION_MAX(ErrorType.BAD_PARAMETERS),
    VALIDATION_ISCSI_BOND_NAME_INVALID_CHARACTER(ErrorType.BAD_PARAMETERS),

    // Kdump detection
    KDUMP_DETECTION_NOT_ENABLED_FOR_VDS(ErrorType.BAD_PARAMETERS),
    KDUMP_DETECTION_NOT_CONFIGURED_ON_VDS(ErrorType.BAD_PARAMETERS),

    // soundcard on ppc
    SOUND_DEVICE_REQUESTED_ON_NOT_SUPPORTED_ARCH(ErrorType.NOT_SUPPORTED),

    TPM_DEVICE_REQUESTED_ON_NOT_SUPPORTED_PLATFORM(ErrorType.NOT_SUPPORTED),

    // use host CPU passthrough on ppc
    USE_HOST_CPU_REQUESTED_ON_UNSUPPORTED_ARCH(ErrorType.NOT_SUPPORTED),

    CPU_TYPE_UNSUPPORTED_FOR_THE_GUEST_OS(ErrorType.BAD_PARAMETERS),
    CPU_TYPE_UNKNOWN(ErrorType.BAD_PARAMETERS),
    CPU_HOTPLUG_TOPOLOGY_INVALID(ErrorType.BAD_PARAMETERS),

    MEMORY_SIZE_NOT_MULTIPLE_OF_256_ON_PPC(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_NOT_PLUGGED_MEMORY_ON_ARCH_MUST_BE_DIVIDABLE_BY(ErrorType.CONSTRAINT_VIOLATION),

    ACTION_TYPE_FAILED_DEVICE_MUST_BE_SPECIFIED,
    ACTION_TYPE_FAILED_GRAPHIC_TYPE_MUST_BE_SPECIFIED,
    ACTION_TYPE_REMOVE_GRAPHICS_DEV_INVALID_PARAMS,
    ACTION_TYPE_FAILED_ONLY_ONE_DEVICE_WITH_THIS_GRAPHICS_ALLOWED,

    // Cinder
    ACTION_TYPE_FAILED_PROVIDER_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_CINDER_ALREADY_EXISTS(ErrorType.INTERNAL_ERROR),
    ACTION_TYPE_FAILED_CINDER(ErrorType.INTERNAL_ERROR),
    CANNOT_ADD_CINDER_DISK_VOLUME_LIMIT_EXCEEDED(ErrorType.CONFLICT),
    CANNOT_ADD_CINDER_DISK_SNAPSHOT_LIMIT_EXCEEDED(ErrorType.CONFLICT),
    CINDER_DISK_ALREADY_REGISTERED(ErrorType.CONFLICT),
    CINDER_VOLUME_TYPE_NOT_EXISTS(ErrorType.CONFLICT),
    ERROR_CANNOT_DETACH_CINDER_PROVIDER_WITH_IMAGES(ErrorType.CONFLICT),
    LIBVIRT_SECRET_UUID_CANNOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    LIBVIRT_SECRET_VALUE_CANNOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    LIBVIRT_SECRET_VALUE_ILLEGAL_FORMAT(ErrorType.BAD_PARAMETERS),
    LIBVIRT_SECRET_UUID_ALREADY_EXISTS(ErrorType.CONFLICT),
    LIBVIRT_SECRET_UUID_NOT_EXISTS(ErrorType.CONFLICT),

    NO_FOREMAN_PROVIDER_FOR_ENGINE(ErrorType.NOT_SUPPORTED),
    NO_FOREMAN_PROVIDER_FOR_VM(ErrorType.NOT_SUPPORTED),
    NO_FOREMAN_PROVIDER_FOR_HOST(ErrorType.NOT_SUPPORTED),

    VALIDATION_ID_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_NAME_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_NAME_INVALID_WITH_DOT(ErrorType.BAD_PARAMETERS),
    VALIDATION_URL_NULL(ErrorType.BAD_PARAMETERS),
    VALIDATION_URL_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_PROVIDER_TYPE_NULL(ErrorType.BAD_PARAMETERS),

    VALIDATION_INVALID_CORRELATION_ID(ErrorType.BAD_PARAMETERS),

    ACTION_TYPE_FAILED_VM_NOT_PINNED_TO_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_NOT_PINNED_TO_AT_LEAST_ONE_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOST_DEVICE_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_DEVICE_NOT_AVAILABLE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOST_DEVICE_ALREADY_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_PINNED_TO_MULTIPLE_HOSTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_ATTACHED_PCI_HOST_DEVICES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_ATTACHED_SCSI_HOST_DEVICES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_ATTACHED_NVDIMM_DEVICES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_TPM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_USES_MDEV_TYPE_HOOK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MISSING_HOST_BLOCK_DEVICE_PATH(ErrorType.CONFLICT),

    ACTION_TYPE_FAILED_VM_MEMORY_DEVICE_DOESNT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_REQUIRED_SPEC_PARAM_IS_MISSING(ErrorType.DATA_CORRUPTION),
    ACTION_TYPE_FAILED_MEMORY_DEVICE_IS_BEING_HOT_UNPLUGGED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MEMORY_HOT_UNPLUG_NOT_SUPPORTED_FOR_COMPAT_VERSION_AND_ARCH(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MEMORY_HOT_SET_NOT_SUPPORTED_FOR_HUGE_PAGES(ErrorType.CONFLICT),

    CLUSTER_BIOS_TYPE_NOT_SET(ErrorType.CONFLICT),
    NON_DEFAULT_BIOS_TYPE_FOR_X86_ONLY(ErrorType.CONFLICT),
    Q35_NOT_SUPPORTED_BY_GUEST_OS(ErrorType.CONFLICT),
    SECURE_BOOT_NOT_SUPPORTED_BY_GUEST_OS(ErrorType.CONFLICT),

    ACTION_TYPE_CANNOT_CHANGE_INITIAL_RUN_DATA(ErrorType.CONFLICT),

    ACTION_TYPE_CANNOT_PIN_WITHOUT_HOST(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_CANNOT_RESIZE_AND_PIN_SINGLE_CORE(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_AUTO_PIN_EXISTING_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),

    // vm icons
    VM_ICON_DATAURL_MALFORMED,
    PROVIDED_VM_ICON_OF_UNKNOWN_TYPE,
    PROVIDED_VM_ICONS_OF_UNSUPPORTED_TYPE,
    PROVIDED_VM_ICON_CANT_BE_READ,
    VM_ICON_MIME_TYPE_DOESNT_MATCH_IMAGE_DATA,
    PROVIDED_VM_ICON_HAS_INVALID_DIMENSIONS,
    DATA_SIZE_OF_PROVIDED_VM_ICON_TOO_LARGE,
    VM_ICON_BASE64_PART_MALFORMED,
    ICON_OF_PROVIDED_ID_DOES_NOT_EXIST,

    BLANK_TEMPLATE_CANT_HAVE_SUBTEMPLATES,

    // cluster edit warnings
    CLUSTER_WARN_HOST_DUE_TO_UNSUPPORTED_HWRNG_SOURCE,
    CLUSTER_WARN_HOST_DUE_TO_UNSUPPORTED_MACHINE_TYPE,
    CLUSTER_WARN_VM_DUE_TO_DECREASED_CLUSTER_CPU_LEVEL,

    INVALID_BOND_MODE_FOR_BOND_WITH_VM_NETWORK(ErrorType.BAD_PARAMETERS),
    INVALID_BOND_MODE_FOR_BOND_WITH_LABELED_VM_NETWORK(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_MISSING_IP_CONFIGURATION(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_IP_CONFIGURATION_MISSING_BOOT_PROTOCOL(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_IP_CONFIGURATION_INCOMPATIBLE_BOOT_PROTOCOL_AND_IP_ADDRESS_DETAILS(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_IP_CONFIGURATION_STATIC_BOOT_PROTOCOL_MISSING_IP_ADDRESS_DETAILS(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_IP_CONFIGURATION_STATIC_BOOT_PROTOCOL_IPV6_GATEWAY_ON_NON_DEFAULT_ROUTE_ROLE(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACHMENT_IP_CONFIGURATION_INCOMPATIBLE_BOOT_PROTOCOL_AND_HOST_OS_VERSION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_IS_BEING_SET_AS_BASE_TEMPLATE,
    SETTING_VM_TICKET_FAILED,
    ACTION_TYPE_FAILED_SUBVERSION_BEING_CONCURRENTLY_REMOVED,

    ACTION_TYPE_FAILED_EDITING_HOSTED_ENGINE_IS_DISABLED(ErrorType.CONSTRAINT_VIOLATION),

    // cluster upgrade errors
    CLUSTER_UPGRADE_NOT_FINISHED(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_CAN_NOT_BE_STARTED(ErrorType.CONSTRAINT_VIOLATION),
    MIXED_HOST_VERSIONS_NOT_ALLOWED(ErrorType.CONSTRAINT_VIOLATION),
    VM_CANNOT_SUSPEND_CLUSTER_UPGRADING(ErrorType.CONSTRAINT_VIOLATION),
    BOUND_TO_HOST_WHILE_UPGRADING_CLUSTER(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_DETAIL_HOST_INVALID_OS(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_DETAIL_HOST_RUNS_TOO_OLD_OS(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_DETAIL_VM_NOT_MIGRATABLE(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_DETAIL_VM_CPUS_PINNED(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_DETAIL_VM_NUMA_PINNED(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_DETAIL_VM_NEEDS_PASSTHROUGH(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_UPGRADE_DETAIL_VM_SUSPENDED(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_VERSION_CHANGE_VM_PREVIEW(ErrorType.CONSTRAINT_VIOLATION),
    CLUSTER_CANNOT_UPDATE_CLUSTER_FAILED_TO_UPDATE_VMS(ErrorType.INTERNAL_ERROR),

    ACTION_TYPE_FAILED_EXTERNAL_PROVIDER_IS_READ_ONLY(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_CLUSTER_IS_BEING_UPDATED,

    ACTION_TYPE_FAILED_PROVIDER_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_NO_PLUGIN_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_NO_USER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_NO_PASSWORD(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_PASSWORD_TOO_LONG(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_NO_AUTH_URL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_INVALID_AUTH_URL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_INVALID_PROMETHEUS_URL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_NO_TENANT_OR_USER_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_URL_TENANT_COMBINATION_NOT_UNIQUE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROVIDER_FAILED_FETCH_TEMPLATES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_FAILED_FETCH_VERSIONS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_TEMPLATES_NOT_FOUND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_KUBEVIRT_NOT_FOUND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_URL_PROJECT_NAME_AND_DOMAIN_NAME_COMBINATION_NOT_UNIQUE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_NOT_SPECIFIED_FOR_DOWNLOAD(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_TRANSFER_IMAGE_STATUS_MISSING_PARAM(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_RESUME_IMAGE_TRANSFER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_PAUSE_IMAGE_DOWNLOAD(ErrorType.NOT_SUPPORTED),

    // Managed block storage
    ACTION_TYPE_FAILED_CANNOT_ACTIVATE_MANAGED_BLOCK_STORAGE_DOMAIN(ErrorType.NOT_SUPPORTED),
    FAILED_TO_CONNECT_MANAGED_BLOCK_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CINDERLIB_DATA_BASE_REQUIRED(ErrorType.NOT_SUPPORTED),

    // Incremental backup
    CANNOT_START_BACKUP_VM_SHOULD_BE_IN_UP_OR_DOWN_STATUS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INCREMENTAL_BACKUP_DISABLED_FOR_DISKS(ErrorType.CONFLICT),
    CANNOT_START_BACKUP_NOT_SUPPORTED_BY_VDS(ErrorType.CONFLICT),
    CANNOT_START_BACKUP_USING_OUTDATED_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_BACKUP_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_BACKUP_NOT_READY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_FORMAT_NOT_APPLICABLE_FOR_BACKUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_IS_DURING_BACKUP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INCREMENTAL_BACKUP_NOT_SUPPORTED_FOR_RAW_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INCREMENTAL_BACKUP_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MIXED_INCREMENTAL_AND_FULL_BACKUP_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CHECKPOINT_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CHECKPOINT_INVALID(ErrorType.BAD_PARAMETERS),
    CANNOT_DELETE_CHECKPOINT_VM_SHOULD_BE_IN_UP_STATUS(ErrorType.CONFLICT),
    ACTION_TYPE_BITMAPS_OPERATION_ARE_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISKS_ARE_NOT_ACTIVE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_DURING_A_BACKUP_CHECKPOINT_REMOVAL(ErrorType.CONFLICT);

    private ErrorType messageType;

    EngineMessage() {
        this.messageType = null;
    }

    EngineMessage(ErrorType messageType) {
        this.messageType = messageType;
    }

    public ErrorType getErrorType() {
        return messageType;
    }

    public static ErrorType getErrorType(String error) {
        try {
            return valueOf(error).getErrorType();
        } catch (Exception e) {
            return null;
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    public static EngineMessage forValue(int value) {
        return values()[value];
    }

    public static boolean contains(String str) {
        try {
            valueOf(str);
        } catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}
