/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kubevirt.io.V1Affinity;
import kubevirt.io.V1DomainSpec;
import kubevirt.io.V1Network;
import kubevirt.io.V1PodDNSConfig;
import kubevirt.io.V1Probe;
import kubevirt.io.V1Toleration;
import kubevirt.io.V1Volume;

/**
 * VirtualMachineInstanceSpec is a description of a VirtualMachineInstance.
 */
@ApiModel(description = "VirtualMachineInstanceSpec is a description of a VirtualMachineInstance.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1VirtualMachineInstanceSpec {
  @SerializedName("affinity")
  private V1Affinity affinity = null;

  @SerializedName("dnsConfig")
  private V1PodDNSConfig dnsConfig = null;

  @SerializedName("dnsPolicy")
  private String dnsPolicy = null;

  @SerializedName("domain")
  private V1DomainSpec domain = null;

  @SerializedName("evictionStrategy")
  private String evictionStrategy = null;

  @SerializedName("hostname")
  private String hostname = null;

  @SerializedName("livenessProbe")
  private V1Probe livenessProbe = null;

  @SerializedName("networks")
  private List<V1Network> networks = null;

  @SerializedName("nodeSelector")
  private Object nodeSelector = null;

  @SerializedName("readinessProbe")
  private V1Probe readinessProbe = null;

  @SerializedName("subdomain")
  private String subdomain = null;

  @SerializedName("terminationGracePeriodSeconds")
  private Long terminationGracePeriodSeconds = null;

  @SerializedName("tolerations")
  private List<V1Toleration> tolerations = null;

  @SerializedName("volumes")
  private List<V1Volume> volumes = null;

  public V1VirtualMachineInstanceSpec affinity(V1Affinity affinity) {
    this.affinity = affinity;
    return this;
  }

   /**
   * If affinity is specifies, obey all the affinity rules
   * @return affinity
  **/
  @ApiModelProperty(value = "If affinity is specifies, obey all the affinity rules")
  public V1Affinity getAffinity() {
    return affinity;
  }

  public void setAffinity(V1Affinity affinity) {
    this.affinity = affinity;
  }

  public V1VirtualMachineInstanceSpec dnsConfig(V1PodDNSConfig dnsConfig) {
    this.dnsConfig = dnsConfig;
    return this;
  }

   /**
   * Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy. +optional
   * @return dnsConfig
  **/
  @ApiModelProperty(value = "Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy. +optional")
  public V1PodDNSConfig getDnsConfig() {
    return dnsConfig;
  }

  public void setDnsConfig(V1PodDNSConfig dnsConfig) {
    this.dnsConfig = dnsConfig;
  }

  public V1VirtualMachineInstanceSpec dnsPolicy(String dnsPolicy) {
    this.dnsPolicy = dnsPolicy;
    return this;
  }

   /**
   * Set DNS policy for the pod. Defaults to \&quot;ClusterFirst\&quot;. Valid values are &#39;ClusterFirstWithHostNet&#39;, &#39;ClusterFirst&#39;, &#39;Default&#39; or &#39;None&#39;. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to &#39;ClusterFirstWithHostNet&#39;. +optional
   * @return dnsPolicy
  **/
  @ApiModelProperty(value = "Set DNS policy for the pod. Defaults to \"ClusterFirst\". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'. +optional")
  public String getDnsPolicy() {
    return dnsPolicy;
  }

  public void setDnsPolicy(String dnsPolicy) {
    this.dnsPolicy = dnsPolicy;
  }

  public V1VirtualMachineInstanceSpec domain(V1DomainSpec domain) {
    this.domain = domain;
    return this;
  }

   /**
   * Specification of the desired behavior of the VirtualMachineInstance on the host.
   * @return domain
  **/
  @ApiModelProperty(required = true, value = "Specification of the desired behavior of the VirtualMachineInstance on the host.")
  public V1DomainSpec getDomain() {
    return domain;
  }

  public void setDomain(V1DomainSpec domain) {
    this.domain = domain;
  }

  public V1VirtualMachineInstanceSpec evictionStrategy(String evictionStrategy) {
    this.evictionStrategy = evictionStrategy;
    return this;
  }

   /**
   * EvictionStrategy can be set to \&quot;LiveMigrate\&quot; if the VirtualMachineInstance should be migrated instead of shut-off in case of a node drain.
   * @return evictionStrategy
  **/
  @ApiModelProperty(value = "EvictionStrategy can be set to \"LiveMigrate\" if the VirtualMachineInstance should be migrated instead of shut-off in case of a node drain.")
  public String getEvictionStrategy() {
    return evictionStrategy;
  }

  public void setEvictionStrategy(String evictionStrategy) {
    this.evictionStrategy = evictionStrategy;
  }

  public V1VirtualMachineInstanceSpec hostname(String hostname) {
    this.hostname = hostname;
    return this;
  }

   /**
   * Specifies the hostname of the vmi If not specified, the hostname will be set to the name of the vmi, if dhcp or cloud-init is configured properly. +optional
   * @return hostname
  **/
  @ApiModelProperty(value = "Specifies the hostname of the vmi If not specified, the hostname will be set to the name of the vmi, if dhcp or cloud-init is configured properly. +optional")
  public String getHostname() {
    return hostname;
  }

  public void setHostname(String hostname) {
    this.hostname = hostname;
  }

  public V1VirtualMachineInstanceSpec livenessProbe(V1Probe livenessProbe) {
    this.livenessProbe = livenessProbe;
    return this;
  }

   /**
   * Periodic probe of VirtualMachineInstance liveness. VirtualmachineInstances will be stopped if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
   * @return livenessProbe
  **/
  @ApiModelProperty(value = "Periodic probe of VirtualMachineInstance liveness. VirtualmachineInstances will be stopped if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional")
  public V1Probe getLivenessProbe() {
    return livenessProbe;
  }

  public void setLivenessProbe(V1Probe livenessProbe) {
    this.livenessProbe = livenessProbe;
  }

  public V1VirtualMachineInstanceSpec networks(List<V1Network> networks) {
    this.networks = networks;
    return this;
  }

  public V1VirtualMachineInstanceSpec addNetworksItem(V1Network networksItem) {
    if (this.networks == null) {
      this.networks = new ArrayList<>();
    }
    this.networks.add(networksItem);
    return this;
  }

   /**
   * List of networks that can be attached to a vm&#39;s virtual interface.
   * @return networks
  **/
  @ApiModelProperty(value = "List of networks that can be attached to a vm's virtual interface.")
  public List<V1Network> getNetworks() {
    return networks;
  }

  public void setNetworks(List<V1Network> networks) {
    this.networks = networks;
  }

  public V1VirtualMachineInstanceSpec nodeSelector(Object nodeSelector) {
    this.nodeSelector = nodeSelector;
    return this;
  }

   /**
   * NodeSelector is a selector which must be true for the vmi to fit on a node. Selector which must match a node&#39;s labels for the vmi to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/ +optional
   * @return nodeSelector
  **/
  @ApiModelProperty(value = "NodeSelector is a selector which must be true for the vmi to fit on a node. Selector which must match a node's labels for the vmi to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/ +optional")
  public Object getNodeSelector() {
    return nodeSelector;
  }

  public void setNodeSelector(Object nodeSelector) {
    this.nodeSelector = nodeSelector;
  }

  public V1VirtualMachineInstanceSpec readinessProbe(V1Probe readinessProbe) {
    this.readinessProbe = readinessProbe;
    return this;
  }

   /**
   * Periodic probe of VirtualMachineInstance service readiness. VirtualmachineInstances will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
   * @return readinessProbe
  **/
  @ApiModelProperty(value = "Periodic probe of VirtualMachineInstance service readiness. VirtualmachineInstances will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional")
  public V1Probe getReadinessProbe() {
    return readinessProbe;
  }

  public void setReadinessProbe(V1Probe readinessProbe) {
    this.readinessProbe = readinessProbe;
  }

  public V1VirtualMachineInstanceSpec subdomain(String subdomain) {
    this.subdomain = subdomain;
    return this;
  }

   /**
   * If specified, the fully qualified vmi hostname will be \&quot;&lt;hostname&gt;.&lt;subdomain&gt;.&lt;pod namespace&gt;.svc.&lt;cluster domain&gt;\&quot;. If not specified, the vmi will not have a domainname at all. The DNS entry will resolve to the vmi, no matter if the vmi itself can pick up a hostname. +optional
   * @return subdomain
  **/
  @ApiModelProperty(value = "If specified, the fully qualified vmi hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\". If not specified, the vmi will not have a domainname at all. The DNS entry will resolve to the vmi, no matter if the vmi itself can pick up a hostname. +optional")
  public String getSubdomain() {
    return subdomain;
  }

  public void setSubdomain(String subdomain) {
    this.subdomain = subdomain;
  }

  public V1VirtualMachineInstanceSpec terminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    return this;
  }

   /**
   * Grace period observed after signalling a VirtualMachineInstance to stop after which the VirtualMachineInstance is force terminated.
   * @return terminationGracePeriodSeconds
  **/
  @ApiModelProperty(value = "Grace period observed after signalling a VirtualMachineInstance to stop after which the VirtualMachineInstance is force terminated.")
  public Long getTerminationGracePeriodSeconds() {
    return terminationGracePeriodSeconds;
  }

  public void setTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
  }

  public V1VirtualMachineInstanceSpec tolerations(List<V1Toleration> tolerations) {
    this.tolerations = tolerations;
    return this;
  }

  public V1VirtualMachineInstanceSpec addTolerationsItem(V1Toleration tolerationsItem) {
    if (this.tolerations == null) {
      this.tolerations = new ArrayList<>();
    }
    this.tolerations.add(tolerationsItem);
    return this;
  }

   /**
   * If toleration is specified, obey all the toleration rules.
   * @return tolerations
  **/
  @ApiModelProperty(value = "If toleration is specified, obey all the toleration rules.")
  public List<V1Toleration> getTolerations() {
    return tolerations;
  }

  public void setTolerations(List<V1Toleration> tolerations) {
    this.tolerations = tolerations;
  }

  public V1VirtualMachineInstanceSpec volumes(List<V1Volume> volumes) {
    this.volumes = volumes;
    return this;
  }

  public V1VirtualMachineInstanceSpec addVolumesItem(V1Volume volumesItem) {
    if (this.volumes == null) {
      this.volumes = new ArrayList<>();
    }
    this.volumes.add(volumesItem);
    return this;
  }

   /**
   * List of volumes that can be mounted by disks belonging to the vmi.
   * @return volumes
  **/
  @ApiModelProperty(value = "List of volumes that can be mounted by disks belonging to the vmi.")
  public List<V1Volume> getVolumes() {
    return volumes;
  }

  public void setVolumes(List<V1Volume> volumes) {
    this.volumes = volumes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1VirtualMachineInstanceSpec v1VirtualMachineInstanceSpec = (V1VirtualMachineInstanceSpec) o;
    return Objects.equals(this.affinity, v1VirtualMachineInstanceSpec.affinity) &&
        Objects.equals(this.dnsConfig, v1VirtualMachineInstanceSpec.dnsConfig) &&
        Objects.equals(this.dnsPolicy, v1VirtualMachineInstanceSpec.dnsPolicy) &&
        Objects.equals(this.domain, v1VirtualMachineInstanceSpec.domain) &&
        Objects.equals(this.evictionStrategy, v1VirtualMachineInstanceSpec.evictionStrategy) &&
        Objects.equals(this.hostname, v1VirtualMachineInstanceSpec.hostname) &&
        Objects.equals(this.livenessProbe, v1VirtualMachineInstanceSpec.livenessProbe) &&
        Objects.equals(this.networks, v1VirtualMachineInstanceSpec.networks) &&
        Objects.equals(this.nodeSelector, v1VirtualMachineInstanceSpec.nodeSelector) &&
        Objects.equals(this.readinessProbe, v1VirtualMachineInstanceSpec.readinessProbe) &&
        Objects.equals(this.subdomain, v1VirtualMachineInstanceSpec.subdomain) &&
        Objects.equals(this.terminationGracePeriodSeconds, v1VirtualMachineInstanceSpec.terminationGracePeriodSeconds) &&
        Objects.equals(this.tolerations, v1VirtualMachineInstanceSpec.tolerations) &&
        Objects.equals(this.volumes, v1VirtualMachineInstanceSpec.volumes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(affinity, dnsConfig, dnsPolicy, domain, evictionStrategy, hostname, livenessProbe, networks, nodeSelector, readinessProbe, subdomain, terminationGracePeriodSeconds, tolerations, volumes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1VirtualMachineInstanceSpec {\n");
    
    sb.append("    affinity: ").append(toIndentedString(affinity)).append("\n");
    sb.append("    dnsConfig: ").append(toIndentedString(dnsConfig)).append("\n");
    sb.append("    dnsPolicy: ").append(toIndentedString(dnsPolicy)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    evictionStrategy: ").append(toIndentedString(evictionStrategy)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    livenessProbe: ").append(toIndentedString(livenessProbe)).append("\n");
    sb.append("    networks: ").append(toIndentedString(networks)).append("\n");
    sb.append("    nodeSelector: ").append(toIndentedString(nodeSelector)).append("\n");
    sb.append("    readinessProbe: ").append(toIndentedString(readinessProbe)).append("\n");
    sb.append("    subdomain: ").append(toIndentedString(subdomain)).append("\n");
    sb.append("    terminationGracePeriodSeconds: ").append(toIndentedString(terminationGracePeriodSeconds)).append("\n");
    sb.append("    tolerations: ").append(toIndentedString(tolerations)).append("\n");
    sb.append("    volumes: ").append(toIndentedString(volumes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

