// --- ping-content -------------------------------
import $ from 'jquery'

import {debugMsg, spawnVdsm} from './helpers'

import { gettext as _ } from './i18n'

export function renderPing () {
  var vdsmPingResponse = ''
  spawnVdsm('ping', null,
    function (data) { vdsmPingResponse += data },
    function () { pingSuccessful(vdsmPingResponse) },
    pingFailed)
  vdsmPingResponse = ''
}

function pingSuccessful (vdsmPingResponse) {
  var json = vdsmPingResponse
  var resp = $.parseJSON(json)
  if (resp.hasOwnProperty('status') && resp.status.hasOwnProperty('code') && resp.status.hasOwnProperty('message')) {
    if (resp.status.code === 0) {
      printPingContent(_('Ping succeeded.<br/>The cockpit-ovirt plugin is installed and VDSM connection can be established.'), json)// still might be an error, but well-formatted response with its description
    } else { // well-formatted error-response with description
      printPingContent(_('Ping failed: {0}').format(resp.status.message), json)
    }
    return
  }

  // wrong format
  pingFailed(null, _('Ping failed with malformed error message returned: {0}').format(json))
}

function pingFailed (stderr, detail) {
  if (!detail) {
    detail = _('Ping execution failed.')
  }

  detail = stderr + '\n' + detail
  printPingContent(detail, '{"status": {"message": "' + detail + '", "code": 1}}')
}

function printPingContent (humanText, parserText) {
  var content = "<div id='ping-content-human'>" + humanText + '</div>'
  content += "<div id='ping-content-parser' hidden>" + parserText + '</div>'

  var pingContent = $('#ping-content')
  pingContent.html(content)

  debugMsg('Ping content: ' + content)
}
