# Note: this spec is used for RHEL, CentOS and Fedora. Plese do not use Fedora
# only macros. If you want to suggest changes please do this upstream:
# https://gerrit.ovirt.org/#/admin/projects/ioprocess

%global _configure ../configure


%if 0%{?rhel}
%if 0%{?rhel} < 8
%global with_python2 1
%global with_python3 0
%global python python
%else
%global with_python2 0
%global with_python3 1
%endif
%endif

%if 0%{?fedora}
%global with_python3 1
%if 0%{?fedora} < 30
%global with_python2 1
%global python python2
%else
%global with_python2 0
%endif
%endif

Name:		ioprocess
Version:	1.3.1
Release:	1%{?release_suffix}%{?dist}
Summary:	Slave process to perform risky IO

Group:		System Environment/Base
License:	GPLv2+
URL:		https://github.com/oVirt/ioprocess

# Note: the url fragment satisfies the build system, assuming that the source
# url ends with name-version.tar.gz. This part is ignored by the server.
# See https://fedoraproject.org/wiki/Packaging:SourceURL?rd=Packaging/SourceURL#Git_Tags
Source:		https://github.com/oVirt/ioprocess/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz


BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	glib2-devel
BuildRequires:	yajl-devel
Requires:	yajl

%if %with_python2
BuildRequires:	python2-devel
%endif

%if %with_python3
BuildRequires:	python3-devel
%endif


%description
Slave process to perform risky IO.


%prep
%setup -q %{name}-%{version}
mkdir py2 py3


%build
%if %with_python2
pushd py2
%configure PYTHON="%{__python2}"
make %{?_smp_mflags}
popd
%endif

%if %with_python3
pushd py3
%configure PYTHON="%{__python3}"
make %{?_smp_mflags}
popd
%endif


%install
%if 0%{?with_python2}
make -C py2 %{?_smp_mflags} install DESTDIR="%{buildroot}"
%endif # with_python2

%if 0%{?with_python3}
make -C py3 %{?_smp_mflags} install DESTDIR="%{buildroot}"
%endif # with_python3

%files
%{!?_licensedir:%global license %doc}
%{_libexecdir}/ioprocess
%doc README.md AUTHORS
%license COPYING

%if %with_python2
%package -n python2-ioprocess
Summary:	Python bindings for ioprocess
BuildRequires:	%{python}
BuildRequires:	%{python}-six
BuildRequires:	python-subprocess32
BuildRequires:	util-linux
Requires:	%{python}
Requires:	%{python}-six
Requires:	python-subprocess32
Requires:	%{name} = %{version}

# This package replaces python-ioprocess
Provides: python-ioprocess = %{version}
Obsoletes: python-ioprocess < %{version}

%description -n python2-ioprocess
Python bindings for ioprocess

%files -n python2-ioprocess
%{!?_licensedir:%global license %doc}
%{python2_sitelib}/ioprocess-*.egg-info
%{python2_sitelib}/ioprocess/
%doc README.md AUTHORS
%license COPYING
%endif

%if %with_python3
%package -n python3-ioprocess
Summary:	Python bindings for ioprocess
BuildRequires:	python3
BuildRequires:	python3-six
BuildRequires:	util-linux
Requires:	python3
Requires:	python3-six
Requires:	%{name} = %{version}

%description -n python3-ioprocess
Python bindings for ioprocess

%files -n python3-ioprocess
%{python3_sitelib}/ioprocess-*.egg-info
%{python3_sitelib}/ioprocess/
%doc README.md AUTHORS
%license COPYING
%endif


%changelog

* Wed Dec 18 2019 Nir Soffer <nsoffer@redhat.com> 1.3.1-1
- ioprocess: Fix compatibility with Gluster shard #BZ1780290

* Sat Sep 21 2019 Nir Soffer <nsoffer@redhat.com> 1.3.0-1
- ioprocess: Add probe_block_size() #BZ1753901
- ioprocess: Fix access() #BZ1744624

* Wed Jul 10 2019 Nir Soffer <nsoffer@redhat.com> 1.2.1-1
- Fix writefile() to support 4k storage #BZ1592916
- Fix readfile() with direct I/O #BZ1726834

* Wed Apr 11 2018 Nir Soffer <nsoffer@redhat.com> 1.1.1-1
- python: Log client name in all messages #BZ1550106
- ioprocess: Add lstat() #BZ1564515
- binding: Do not read from stdout

* Sat Feb 03 2018 Nir Soffer <nsoffer@redhat.com> 1.0.2-1
- spec: Remove Fedora only macro #BZ1541389

* Tue Jan 30 2018 Nir Soffer <nsoffer@redhat.com> 1.0.0-1
- ioprocess: Fix fsyncPath #BZ1536261
- ioprocess: Wait until writefile completes #BZ1535429
- spec: Rename python binding to python2-ioprocess
- spec: Remove leftovers from RHEL 6
- python: Close unneeded fds before executing child
- python: Add a test for closing unrelated fds
- automation: Add missing repositories
- python: Replace cpopen with subprocess32
- python: Wait for child process on close
- python: Increase the start timeout #BZ1414604
- python: Rename threads to match vdsm thread names #BZ1392214
- python: Set system thread names if possible #BZ1392214
- python: Log unhandled errors in threads #BZ1392214
- python: Require ioprocess of same version

* Thu Jun 16 2016 Nir Soffer <nsoffer@redhat.com> 0.16.1-1
- ioprocess: Fix logging of file descriptor path
- ioprocess: Fix logger initialization
- binding: Fix race between _run and close
- binding: Add optional ioprocess name
- ioprocess: Fix fd leak in truncate and touch (Resolves BZ#1339777)
- python3: Initial port
- build: Switch to pytest and tox
- bindings: Use only daemon threads
- use LDADD instead of LDFLAGS to fix failure to build with ld
  --as-needed (Logan Rosen)

* Fri Dec 11 2015 Sandro Bonazzola <sbonazzo@redhat.com> 0.15.1-1
- Resolves: BZ#1287946
- Fixed URL and Source0
- Use license for license files

* Sun Nov 29 2015 Yeela Kaplan <ykaplan@redhat.com> - 0.15.0-4
- Fix string formatting for 32bit architecture
* Thu Nov 26 2015 Yaniv Bronhaim <ybronhei@redhat.com> - 0.15.0-3
- Rebuild for ovirt 3.6.1
- Add debug logging
- Fix memory and cpu leak
- Set cpu affinity to run ioprocess on any cpu
* Sun Apr 5 2015 Yaniv Bronhaim <ybronhei@redhat.com> - 0.15.0-2
- Rebuild for ppc64le arch
* Tue Feb 17 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 0.15.0-1
- Fix rpmlint E: explicit-lib-dependency
- Fix rpmlint W: no-documentation
* Mon Oct 20 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.14.0-1
- Fix poll timeout
- Add support for zombiereaper where available
- Fix IOProcesses being referenced by commincation thread
- build: update INSTALL
- specfile: Add missing dependency to glib2
* Wed Sep 3 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.12.0-1
- Fixed memory leak due to forgetting to clear the pending requests queue in
  the python bindings
* Mon Aug 4 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.10.0-1
- Fixed unsefe strerror usage
- Fixed cases logging lines get mangled
* Tue Jul 29 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.8.1-1
- Fixed unsafe use of strerror
- Fixed races in queue limiting
* Sun Jul 20 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.6.1-1
- Reduced logging even for debug level
- Added support for block sizes other than 512
- Added the --max-queued-requests argument
* Sun Jun 15 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.5.0-1
- Fixed missing error check in readfile()
- Added flags arg to fetch()
- Added st_blocks to stat()
* Thu Jun 05 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.4.1-1
- Fixed missing dependcy for python bindings
* Mon Jun 02 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.4-1
- Added touch command
- Changed truncate to include setting file mode and creating a file only when
  one doesn't exist
* Sun Jan 05 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.3-1
Inital RPM release
