/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ExternalHostProviderBuilder;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;

public interface ExternalHostProvidersService extends Service {
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest provider(ExternalHostProvider provider);
        AddRequest provider(ExternalHostProviderBuilder provider);
    }
    
    public interface AddResponse extends Response {
        ExternalHostProvider provider();
    }
    
    AddRequest add();
    
    /**
     * Returns the list of external host providers.
     * 
     * The order of the returned list of host providers isn't guaranteed.
     */
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Sets the maximum number of providers to return. If not specified all the providers are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of providers to return. If not specified all the providers are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of providers to return. If not specified all the providers are returned.
         */
        ListRequest max(BigInteger max);
    }
    
    /**
     * Returns the list of external host providers.
     * 
     * The order of the returned list of host providers isn't guaranteed.
     */
    public interface ListResponse extends Response {
        List<ExternalHostProvider> providers();
    }
    
    /**
     * Returns the list of external host providers.
     * 
     * The order of the returned list of host providers isn't guaranteed.
     */
    ListRequest list();
    
    ExternalHostProviderService providerService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

