/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.Date;

/**
 * Type representing an event.
 */
public interface Event extends Identified {
    BigInteger code();
    Byte codeAsByte();
    Short codeAsShort();
    Integer codeAsInteger();
    Long codeAsLong();
    
    boolean codePresent();
    
    String correlationId();
    
    boolean correlationIdPresent();
    
    String customData();
    
    boolean customDataPresent();
    
    BigInteger customId();
    Byte customIdAsByte();
    Short customIdAsShort();
    Integer customIdAsInteger();
    Long customIdAsLong();
    
    boolean customIdPresent();
    
    BigInteger floodRate();
    Byte floodRateAsByte();
    Short floodRateAsShort();
    Integer floodRateAsInteger();
    Long floodRateAsLong();
    
    boolean floodRatePresent();
    
    BigInteger index();
    Byte indexAsByte();
    Short indexAsShort();
    Integer indexAsInteger();
    Long indexAsLong();
    
    boolean indexPresent();
    
    String origin();
    
    boolean originPresent();
    
    LogSeverity severity();
    
    boolean severityPresent();
    
    Date time();
    
    boolean timePresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    DataCenter dataCenter();
    
    boolean dataCenterPresent();
    
    Host host();
    
    boolean hostPresent();
    
    StorageDomain storageDomain();
    
    boolean storageDomainPresent();
    
    Template template();
    
    boolean templatePresent();
    
    User user();
    
    boolean userPresent();
    
    Vm vm();
    
    boolean vmPresent();
    
}
