/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.util.List;
import org.ovirt.engine.sdk4.types.MacPool;
import org.ovirt.engine.sdk4.types.Range;

public class MacPoolContainer extends IdentifiedContainer implements MacPool {
    private Boolean allowDuplicates;
    private Boolean defaultPool;
    private List<Range> ranges;
    
    public boolean allowDuplicates() {
        return allowDuplicates;
    }
    
    public void allowDuplicates(boolean newAllowDuplicates) {
        allowDuplicates = Boolean.valueOf(newAllowDuplicates);
    }
    
    public void allowDuplicates(Boolean newAllowDuplicates) {
        allowDuplicates = newAllowDuplicates;
    }
    
    public boolean allowDuplicatesPresent() {
        return allowDuplicates != null;
    }
    
    public boolean defaultPool() {
        return defaultPool;
    }
    
    public void defaultPool(boolean newDefaultPool) {
        defaultPool = Boolean.valueOf(newDefaultPool);
    }
    
    public void defaultPool(Boolean newDefaultPool) {
        defaultPool = newDefaultPool;
    }
    
    public boolean defaultPoolPresent() {
        return defaultPool != null;
    }
    
    public List<Range> ranges() {
        return makeUnmodifiableList(ranges);
    }
    
    public void ranges(List<Range> newRanges) {
        ranges = makeArrayList(newRanges);
    }
    
    public boolean rangesPresent() {
        return ranges != null && !ranges.isEmpty();
    }
    
}
