/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VmType {
    DESKTOP("desktop"),
    HIGH_PERFORMANCE("high_performance"),
    SERVER("server");

    private static final Logger log;
    private String image;

    private VmType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static VmType fromValue(String value) {
        try {
            return VmType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'VmType' enumerated type. Valid values are 'desktop', 'high_performance' and 'server'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(VmType.class);
    }
}

