/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.QuotaClusterLimitBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.QuotaClusterLimitServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaClusterLimitReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaClusterLimitWriter;
import org.ovirt.engine.sdk4.services.QuotaClusterLimitService;
import org.ovirt.engine.sdk4.services.QuotaClusterLimitsService;
import org.ovirt.engine.sdk4.types.QuotaClusterLimit;

public class QuotaClusterLimitsServiceImpl
extends ServiceImpl
implements QuotaClusterLimitsService {
    public QuotaClusterLimitsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public QuotaClusterLimitsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public QuotaClusterLimitsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public QuotaClusterLimitService limitService(String id) {
        return new QuotaClusterLimitServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.limitService(path);
        }
        return this.limitService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "QuotaClusterLimitsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements QuotaClusterLimitsService.ListResponse {
        private List<QuotaClusterLimit> limits;

        private ListResponseImpl() {
        }

        public void limits(List<QuotaClusterLimit> limits) {
            this.limits = limits;
        }

        @Override
        public List<QuotaClusterLimit> limits() {
            return this.limits;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<QuotaClusterLimitsService.ListRequest, QuotaClusterLimitsService.ListResponse>
    implements QuotaClusterLimitsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public QuotaClusterLimitsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public QuotaClusterLimitsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public QuotaClusterLimitsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public QuotaClusterLimitsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public QuotaClusterLimitsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QuotaClusterLimitsServiceImpl.this.getConnection().getUrl() + QuotaClusterLimitsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QuotaClusterLimitsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.limits(XmlQuotaClusterLimitReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QuotaClusterLimitsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements QuotaClusterLimitsService.AddResponse {
        private QuotaClusterLimit limit;

        private AddResponseImpl() {
        }

        public void limit(QuotaClusterLimit limit) {
            this.limit = limit;
        }

        @Override
        public QuotaClusterLimit limit() {
            return this.limit;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<QuotaClusterLimitsService.AddRequest, QuotaClusterLimitsService.AddResponse>
    implements QuotaClusterLimitsService.AddRequest {
        private QuotaClusterLimit limit;

        private AddRequestImpl() {
        }

        @Override
        public QuotaClusterLimitsService.AddRequest limit(QuotaClusterLimit limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public QuotaClusterLimitsService.AddRequest limit(QuotaClusterLimitBuilder limit) {
            this.limit = limit.build();
            return this;
        }

        @Override
        public QuotaClusterLimitsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QuotaClusterLimitsServiceImpl.this.getConnection().getUrl() + QuotaClusterLimitsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlQuotaClusterLimitWriter.writeOne(this.limit, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QuotaClusterLimitsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.limit(XmlQuotaClusterLimitReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QuotaClusterLimitsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

