/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.CdromBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmCdromServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlCdromReader;
import org.ovirt.engine.sdk4.internal.xml.XmlCdromWriter;
import org.ovirt.engine.sdk4.services.VmCdromService;
import org.ovirt.engine.sdk4.services.VmCdromsService;
import org.ovirt.engine.sdk4.types.Cdrom;

public class VmCdromsServiceImpl
extends ServiceImpl
implements VmCdromsService {
    public VmCdromsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmCdromsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmCdromsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmCdromService cdromService(String id) {
        return new VmCdromServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.cdromService(path);
        }
        return this.cdromService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmCdromsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmCdromsService.ListResponse {
        private List<Cdrom> cdroms;

        private ListResponseImpl() {
        }

        public void cdroms(List<Cdrom> cdroms) {
            this.cdroms = cdroms;
        }

        @Override
        public List<Cdrom> cdroms() {
            return this.cdroms;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmCdromsService.ListRequest, VmCdromsService.ListResponse>
    implements VmCdromsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public VmCdromsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmCdromsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmCdromsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmCdromsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmCdromsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmCdromsServiceImpl.this.getConnection().getUrl() + VmCdromsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmCdromsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.cdroms(XmlCdromReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmCdromsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmCdromsService.AddResponse {
        private Cdrom cdrom;

        private AddResponseImpl() {
        }

        public void cdrom(Cdrom cdrom) {
            this.cdrom = cdrom;
        }

        @Override
        public Cdrom cdrom() {
            return this.cdrom;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmCdromsService.AddRequest, VmCdromsService.AddResponse>
    implements VmCdromsService.AddRequest {
        private Cdrom cdrom;

        private AddRequestImpl() {
        }

        @Override
        public VmCdromsService.AddRequest cdrom(Cdrom cdrom) {
            this.cdrom = cdrom;
            return this;
        }

        @Override
        public VmCdromsService.AddRequest cdrom(CdromBuilder cdrom) {
            this.cdrom = cdrom.build();
            return this;
        }

        @Override
        public VmCdromsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmCdromsServiceImpl.this.getConnection().getUrl() + VmCdromsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlCdromWriter.writeOne(this.cdrom, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmCdromsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.cdrom(XmlCdromReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmCdromsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

