/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.WeightBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.WeightServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlWeightReader;
import org.ovirt.engine.sdk4.internal.xml.XmlWeightWriter;
import org.ovirt.engine.sdk4.services.WeightService;
import org.ovirt.engine.sdk4.services.WeightsService;
import org.ovirt.engine.sdk4.types.Weight;

public class WeightsServiceImpl
extends ServiceImpl
implements WeightsService {
    public WeightsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public WeightsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public WeightsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public WeightService weightService(String id) {
        return new WeightServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.weightService(path);
        }
        return this.weightService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "WeightsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements WeightsService.ListResponse {
        private List<Weight> weights;

        private ListResponseImpl() {
        }

        public void weights(List<Weight> weights) {
            this.weights = weights;
        }

        @Override
        public List<Weight> weights() {
            return this.weights;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<WeightsService.ListRequest, WeightsService.ListResponse>
    implements WeightsService.ListRequest {
        private Boolean filter;
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public WeightsService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public WeightsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public WeightsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public WeightsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public WeightsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public WeightsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(WeightsServiceImpl.this.getConnection().getUrl() + WeightsServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = WeightsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.weights(XmlWeightReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            WeightsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements WeightsService.AddResponse {
        private Weight weight;

        private AddResponseImpl() {
        }

        public void weight(Weight weight) {
            this.weight = weight;
        }

        @Override
        public Weight weight() {
            return this.weight;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<WeightsService.AddRequest, WeightsService.AddResponse>
    implements WeightsService.AddRequest {
        private Weight weight;

        private AddRequestImpl() {
        }

        @Override
        public WeightsService.AddRequest weight(Weight weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public WeightsService.AddRequest weight(WeightBuilder weight) {
            this.weight = weight.build();
            return this;
        }

        @Override
        public WeightsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(WeightsServiceImpl.this.getConnection().getUrl() + WeightsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlWeightWriter.writeOne(this.weight, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = WeightsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.weight(XmlWeightReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            WeightsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

