/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalHostGroupServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostGroupReader;
import org.ovirt.engine.sdk4.services.ExternalHostGroupService;
import org.ovirt.engine.sdk4.services.ExternalHostGroupsService;
import org.ovirt.engine.sdk4.types.ExternalHostGroup;

public class ExternalHostGroupsServiceImpl
extends ServiceImpl
implements ExternalHostGroupsService {
    public ExternalHostGroupsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalHostGroupsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ExternalHostGroupService groupService(String id) {
        return new ExternalHostGroupServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.groupService(path);
        }
        return this.groupService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ExternalHostGroupsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ExternalHostGroupsService.ListResponse {
        private List<ExternalHostGroup> groups;

        private ListResponseImpl() {
        }

        public void groups(List<ExternalHostGroup> groups) {
            this.groups = groups;
        }

        @Override
        public List<ExternalHostGroup> groups() {
            return this.groups;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ExternalHostGroupsService.ListRequest, ExternalHostGroupsService.ListResponse>
    implements ExternalHostGroupsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public ExternalHostGroupsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalHostGroupsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public ExternalHostGroupsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public ExternalHostGroupsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public ExternalHostGroupsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostGroupsServiceImpl.this.getConnection().getUrl() + ExternalHostGroupsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostGroupsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.groups(XmlExternalHostGroupReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostGroupsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

