/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NicBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNicReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNicWriter;
import org.ovirt.engine.sdk4.services.InstanceTypeNicService;
import org.ovirt.engine.sdk4.types.Nic;

public class InstanceTypeNicServiceImpl
extends ServiceImpl
implements InstanceTypeNicService {
    public InstanceTypeNicServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public InstanceTypeNicService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public InstanceTypeNicService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public InstanceTypeNicService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "InstanceTypeNicService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements InstanceTypeNicService.UpdateResponse {
        private Nic nic;

        private UpdateResponseImpl() {
        }

        public void nic(Nic nic) {
            this.nic = nic;
        }

        @Override
        public Nic nic() {
            return this.nic;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<InstanceTypeNicService.UpdateRequest, InstanceTypeNicService.UpdateResponse>
    implements InstanceTypeNicService.UpdateRequest {
        private Boolean async;
        private Nic nic;

        private UpdateRequestImpl() {
        }

        @Override
        public InstanceTypeNicService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public InstanceTypeNicService.UpdateRequest nic(Nic nic) {
            this.nic = nic;
            return this;
        }

        @Override
        public InstanceTypeNicService.UpdateRequest nic(NicBuilder nic) {
            this.nic = nic.build();
            return this;
        }

        @Override
        public InstanceTypeNicService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypeNicServiceImpl.this.getConnection().getUrl() + InstanceTypeNicServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNicWriter.writeOne(this.nic, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypeNicServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.nic(XmlNicReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            InstanceTypeNicServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements InstanceTypeNicService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<InstanceTypeNicService.RemoveRequest, InstanceTypeNicService.RemoveResponse>
    implements InstanceTypeNicService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public InstanceTypeNicService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public InstanceTypeNicService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypeNicServiceImpl.this.getConnection().getUrl() + InstanceTypeNicServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypeNicServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            InstanceTypeNicServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements InstanceTypeNicService.GetResponse {
        private Nic nic;

        private GetResponseImpl() {
        }

        public void nic(Nic nic) {
            this.nic = nic;
        }

        @Override
        public Nic nic() {
            return this.nic;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<InstanceTypeNicService.GetRequest, InstanceTypeNicService.GetResponse>
    implements InstanceTypeNicService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public InstanceTypeNicService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public InstanceTypeNicService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(InstanceTypeNicServiceImpl.this.getConnection().getUrl() + InstanceTypeNicServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = InstanceTypeNicServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.nic(XmlNicReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            InstanceTypeNicServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

