/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateWriter;
import org.ovirt.engine.sdk4.services.TemplateService;
import org.ovirt.engine.sdk4.services.TemplatesService;
import org.ovirt.engine.sdk4.types.Template;

public class TemplatesServiceImpl
extends ServiceImpl
implements TemplatesService {
    public TemplatesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public TemplatesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public TemplatesService.AddFromConfigurationRequest addFromConfiguration() {
        return new AddFromConfigurationRequestImpl();
    }

    @Override
    public TemplatesService.AddFromVmRequest addFromVm() {
        return new AddFromVmRequestImpl();
    }

    @Override
    public TemplatesService.AddFromVmSnapshotRequest addFromVmSnapshot() {
        return new AddFromVmSnapshotRequestImpl();
    }

    @Override
    public TemplatesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public TemplateService templateService(String id) {
        return new TemplateServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.templateService(path);
        }
        return this.templateService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "TemplatesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements TemplatesService.ListResponse {
        private List<Template> templates;

        private ListResponseImpl() {
        }

        public void templates(List<Template> templates) {
            this.templates = templates;
        }

        @Override
        public List<Template> templates() {
            return this.templates;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<TemplatesService.ListRequest, TemplatesService.ListResponse>
    implements TemplatesService.ListRequest {
        private Boolean caseSensitive;
        private Boolean filter;
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public TemplatesService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public TemplatesService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public TemplatesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public TemplatesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public TemplatesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public TemplatesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public TemplatesService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public TemplatesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplatesServiceImpl.this.getConnection().getUrl() + TemplatesServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplatesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.templates(XmlTemplateReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplatesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddFromVmSnapshotResponseImpl
    implements TemplatesService.AddFromVmSnapshotResponse {
        private Template template;

        private AddFromVmSnapshotResponseImpl() {
        }

        public void template(Template template) {
            this.template = template;
        }

        @Override
        public Template template() {
            return this.template;
        }
    }

    private class AddFromVmSnapshotRequestImpl
    extends BaseRequest<TemplatesService.AddFromVmSnapshotRequest, TemplatesService.AddFromVmSnapshotResponse>
    implements TemplatesService.AddFromVmSnapshotRequest {
        private Boolean clonePermissions;
        private Boolean seal;
        private Template template;

        private AddFromVmSnapshotRequestImpl() {
        }

        @Override
        public TemplatesService.AddFromVmSnapshotRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public TemplatesService.AddFromVmSnapshotRequest seal(Boolean seal) {
            this.seal = seal;
            return this;
        }

        @Override
        public TemplatesService.AddFromVmSnapshotRequest template(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplatesService.AddFromVmSnapshotRequest template(TemplateBuilder template) {
            this.template = template.build();
            return this;
        }

        @Override
        public TemplatesService.AddFromVmSnapshotResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplatesServiceImpl.this.getConnection().getUrl() + TemplatesServiceImpl.this.getPath());
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.seal != null) {
                    uriBuilder.addParameter("seal", XmlWriter.renderBoolean(this.seal));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlTemplateWriter.writeOne(this.template, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplatesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddFromVmSnapshotResponseImpl actionResponse = new AddFromVmSnapshotResponseImpl();
                        actionResponse.template(XmlTemplateReader.readOne(reader));
                        AddFromVmSnapshotResponseImpl addFromVmSnapshotResponseImpl = actionResponse;
                        reader.close();
                        return addFromVmSnapshotResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplatesServiceImpl.this.checkFault(response);
            return new AddFromVmSnapshotResponseImpl();
        }
    }

    private class AddFromVmResponseImpl
    implements TemplatesService.AddFromVmResponse {
        private Template template;

        private AddFromVmResponseImpl() {
        }

        public void template(Template template) {
            this.template = template;
        }

        @Override
        public Template template() {
            return this.template;
        }
    }

    private class AddFromVmRequestImpl
    extends BaseRequest<TemplatesService.AddFromVmRequest, TemplatesService.AddFromVmResponse>
    implements TemplatesService.AddFromVmRequest {
        private Boolean clonePermissions;
        private Boolean seal;
        private Template template;

        private AddFromVmRequestImpl() {
        }

        @Override
        public TemplatesService.AddFromVmRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public TemplatesService.AddFromVmRequest seal(Boolean seal) {
            this.seal = seal;
            return this;
        }

        @Override
        public TemplatesService.AddFromVmRequest template(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplatesService.AddFromVmRequest template(TemplateBuilder template) {
            this.template = template.build();
            return this;
        }

        @Override
        public TemplatesService.AddFromVmResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplatesServiceImpl.this.getConnection().getUrl() + TemplatesServiceImpl.this.getPath());
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.seal != null) {
                    uriBuilder.addParameter("seal", XmlWriter.renderBoolean(this.seal));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlTemplateWriter.writeOne(this.template, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplatesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddFromVmResponseImpl actionResponse = new AddFromVmResponseImpl();
                        actionResponse.template(XmlTemplateReader.readOne(reader));
                        AddFromVmResponseImpl addFromVmResponseImpl = actionResponse;
                        reader.close();
                        return addFromVmResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplatesServiceImpl.this.checkFault(response);
            return new AddFromVmResponseImpl();
        }
    }

    private class AddFromConfigurationResponseImpl
    implements TemplatesService.AddFromConfigurationResponse {
        private Template template;

        private AddFromConfigurationResponseImpl() {
        }

        public void template(Template template) {
            this.template = template;
        }

        @Override
        public Template template() {
            return this.template;
        }
    }

    private class AddFromConfigurationRequestImpl
    extends BaseRequest<TemplatesService.AddFromConfigurationRequest, TemplatesService.AddFromConfigurationResponse>
    implements TemplatesService.AddFromConfigurationRequest {
        private Boolean clonePermissions;
        private Boolean seal;
        private Template template;

        private AddFromConfigurationRequestImpl() {
        }

        @Override
        public TemplatesService.AddFromConfigurationRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public TemplatesService.AddFromConfigurationRequest seal(Boolean seal) {
            this.seal = seal;
            return this;
        }

        @Override
        public TemplatesService.AddFromConfigurationRequest template(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplatesService.AddFromConfigurationRequest template(TemplateBuilder template) {
            this.template = template.build();
            return this;
        }

        @Override
        public TemplatesService.AddFromConfigurationResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplatesServiceImpl.this.getConnection().getUrl() + TemplatesServiceImpl.this.getPath());
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.seal != null) {
                    uriBuilder.addParameter("seal", XmlWriter.renderBoolean(this.seal));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlTemplateWriter.writeOne(this.template, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplatesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddFromConfigurationResponseImpl actionResponse = new AddFromConfigurationResponseImpl();
                        actionResponse.template(XmlTemplateReader.readOne(reader));
                        AddFromConfigurationResponseImpl addFromConfigurationResponseImpl = actionResponse;
                        reader.close();
                        return addFromConfigurationResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplatesServiceImpl.this.checkFault(response);
            return new AddFromConfigurationResponseImpl();
        }
    }

    private class AddResponseImpl
    implements TemplatesService.AddResponse {
        private Template template;

        private AddResponseImpl() {
        }

        public void template(Template template) {
            this.template = template;
        }

        @Override
        public Template template() {
            return this.template;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<TemplatesService.AddRequest, TemplatesService.AddResponse>
    implements TemplatesService.AddRequest {
        private Boolean clonePermissions;
        private Boolean seal;
        private Template template;

        private AddRequestImpl() {
        }

        @Override
        public TemplatesService.AddRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public TemplatesService.AddRequest seal(Boolean seal) {
            this.seal = seal;
            return this;
        }

        @Override
        public TemplatesService.AddRequest template(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplatesService.AddRequest template(TemplateBuilder template) {
            this.template = template.build();
            return this;
        }

        @Override
        public TemplatesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplatesServiceImpl.this.getConnection().getUrl() + TemplatesServiceImpl.this.getPath());
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.seal != null) {
                    uriBuilder.addParameter("seal", XmlWriter.renderBoolean(this.seal));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlTemplateWriter.writeOne(this.template, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplatesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.template(XmlTemplateReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplatesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

