/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmWriter;
import org.ovirt.engine.sdk4.services.VmService;
import org.ovirt.engine.sdk4.services.VmsService;
import org.ovirt.engine.sdk4.types.AutoPinningPolicy;
import org.ovirt.engine.sdk4.types.Vm;

public class VmsServiceImpl
extends ServiceImpl
implements VmsService {
    public VmsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmsService.AddFromConfigurationRequest addFromConfiguration() {
        return new AddFromConfigurationRequestImpl();
    }

    @Override
    public VmsService.AddFromScratchRequest addFromScratch() {
        return new AddFromScratchRequestImpl();
    }

    @Override
    public VmsService.AddFromSnapshotRequest addFromSnapshot() {
        return new AddFromSnapshotRequestImpl();
    }

    @Override
    public VmsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmService vmService(String id) {
        return new VmServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.vmService(path);
        }
        return this.vmService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmsService.ListResponse {
        private List<Vm> vms;

        private ListResponseImpl() {
        }

        public void vms(List<Vm> vms) {
            this.vms = vms;
        }

        @Override
        public List<Vm> vms() {
            return this.vms;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmsService.ListRequest, VmsService.ListResponse>
    implements VmsService.ListRequest {
        private Boolean allContent;
        private Boolean caseSensitive;
        private Boolean filter;
        private String follow;
        private BigInteger max;
        private Boolean ovfAsOva;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public VmsService.ListRequest allContent(Boolean allContent) {
            this.allContent = allContent;
            return this;
        }

        @Override
        public VmsService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public VmsService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmsService.ListRequest ovfAsOva(Boolean ovfAsOva) {
            this.ovfAsOva = ovfAsOva;
            return this;
        }

        @Override
        public VmsService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public VmsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmsServiceImpl.this.getConnection().getUrl() + VmsServiceImpl.this.getPath());
                if (this.allContent != null) {
                    uriBuilder.addParameter("all_content", XmlWriter.renderBoolean(this.allContent));
                }
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.ovfAsOva != null) {
                    uriBuilder.addParameter("ovf_as_ova", XmlWriter.renderBoolean(this.ovfAsOva));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.vms(XmlVmReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddFromSnapshotResponseImpl
    implements VmsService.AddFromSnapshotResponse {
        private Vm vm;

        private AddFromSnapshotResponseImpl() {
        }

        public void vm(Vm vm) {
            this.vm = vm;
        }

        @Override
        public Vm vm() {
            return this.vm;
        }
    }

    private class AddFromSnapshotRequestImpl
    extends BaseRequest<VmsService.AddFromSnapshotRequest, VmsService.AddFromSnapshotResponse>
    implements VmsService.AddFromSnapshotRequest {
        private AutoPinningPolicy autoPinningPolicy;
        private Boolean clone_;
        private Boolean clonePermissions;
        private Boolean filter;
        private Vm vm;

        private AddFromSnapshotRequestImpl() {
        }

        public VmsService.AddFromSnapshotRequest autoPinningPolicy(AutoPinningPolicy autoPinningPolicy) {
            this.autoPinningPolicy = autoPinningPolicy;
            return this;
        }

        @Override
        public VmsService.AddFromSnapshotRequest clone_(Boolean clone_) {
            this.clone_ = clone_;
            return this;
        }

        @Override
        public VmsService.AddFromSnapshotRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public VmsService.AddFromSnapshotRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmsService.AddFromSnapshotRequest vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        @Override
        public VmsService.AddFromSnapshotRequest vm(VmBuilder vm) {
            this.vm = vm.build();
            return this;
        }

        @Override
        public VmsService.AddFromSnapshotResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmsServiceImpl.this.getConnection().getUrl() + VmsServiceImpl.this.getPath());
                if (this.autoPinningPolicy != null) {
                    uriBuilder.addParameter("auto_pinning_policy", XmlWriter.renderOther((Object)this.autoPinningPolicy));
                }
                if (this.clone_ != null) {
                    uriBuilder.addParameter("clone", XmlWriter.renderBoolean(this.clone_));
                }
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVmWriter.writeOne(this.vm, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddFromSnapshotResponseImpl actionResponse = new AddFromSnapshotResponseImpl();
                        actionResponse.vm(XmlVmReader.readOne(reader));
                        AddFromSnapshotResponseImpl addFromSnapshotResponseImpl = actionResponse;
                        reader.close();
                        return addFromSnapshotResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmsServiceImpl.this.checkFault(response);
            return new AddFromSnapshotResponseImpl();
        }
    }

    private class AddFromScratchResponseImpl
    implements VmsService.AddFromScratchResponse {
        private Vm vm;

        private AddFromScratchResponseImpl() {
        }

        public void vm(Vm vm) {
            this.vm = vm;
        }

        @Override
        public Vm vm() {
            return this.vm;
        }
    }

    private class AddFromScratchRequestImpl
    extends BaseRequest<VmsService.AddFromScratchRequest, VmsService.AddFromScratchResponse>
    implements VmsService.AddFromScratchRequest {
        private AutoPinningPolicy autoPinningPolicy;
        private Boolean clone_;
        private Boolean clonePermissions;
        private Boolean filter;
        private Vm vm;

        private AddFromScratchRequestImpl() {
        }

        public VmsService.AddFromScratchRequest autoPinningPolicy(AutoPinningPolicy autoPinningPolicy) {
            this.autoPinningPolicy = autoPinningPolicy;
            return this;
        }

        @Override
        public VmsService.AddFromScratchRequest clone_(Boolean clone_) {
            this.clone_ = clone_;
            return this;
        }

        @Override
        public VmsService.AddFromScratchRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public VmsService.AddFromScratchRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmsService.AddFromScratchRequest vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        @Override
        public VmsService.AddFromScratchRequest vm(VmBuilder vm) {
            this.vm = vm.build();
            return this;
        }

        @Override
        public VmsService.AddFromScratchResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmsServiceImpl.this.getConnection().getUrl() + VmsServiceImpl.this.getPath());
                if (this.autoPinningPolicy != null) {
                    uriBuilder.addParameter("auto_pinning_policy", XmlWriter.renderOther((Object)this.autoPinningPolicy));
                }
                if (this.clone_ != null) {
                    uriBuilder.addParameter("clone", XmlWriter.renderBoolean(this.clone_));
                }
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVmWriter.writeOne(this.vm, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddFromScratchResponseImpl actionResponse = new AddFromScratchResponseImpl();
                        actionResponse.vm(XmlVmReader.readOne(reader));
                        AddFromScratchResponseImpl addFromScratchResponseImpl = actionResponse;
                        reader.close();
                        return addFromScratchResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmsServiceImpl.this.checkFault(response);
            return new AddFromScratchResponseImpl();
        }
    }

    private class AddFromConfigurationResponseImpl
    implements VmsService.AddFromConfigurationResponse {
        private Vm vm;

        private AddFromConfigurationResponseImpl() {
        }

        public void vm(Vm vm) {
            this.vm = vm;
        }

        @Override
        public Vm vm() {
            return this.vm;
        }
    }

    private class AddFromConfigurationRequestImpl
    extends BaseRequest<VmsService.AddFromConfigurationRequest, VmsService.AddFromConfigurationResponse>
    implements VmsService.AddFromConfigurationRequest {
        private AutoPinningPolicy autoPinningPolicy;
        private Boolean clone_;
        private Boolean clonePermissions;
        private Boolean filter;
        private Vm vm;

        private AddFromConfigurationRequestImpl() {
        }

        public VmsService.AddFromConfigurationRequest autoPinningPolicy(AutoPinningPolicy autoPinningPolicy) {
            this.autoPinningPolicy = autoPinningPolicy;
            return this;
        }

        @Override
        public VmsService.AddFromConfigurationRequest clone_(Boolean clone_) {
            this.clone_ = clone_;
            return this;
        }

        @Override
        public VmsService.AddFromConfigurationRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public VmsService.AddFromConfigurationRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmsService.AddFromConfigurationRequest vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        @Override
        public VmsService.AddFromConfigurationRequest vm(VmBuilder vm) {
            this.vm = vm.build();
            return this;
        }

        @Override
        public VmsService.AddFromConfigurationResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmsServiceImpl.this.getConnection().getUrl() + VmsServiceImpl.this.getPath());
                if (this.autoPinningPolicy != null) {
                    uriBuilder.addParameter("auto_pinning_policy", XmlWriter.renderOther((Object)this.autoPinningPolicy));
                }
                if (this.clone_ != null) {
                    uriBuilder.addParameter("clone", XmlWriter.renderBoolean(this.clone_));
                }
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVmWriter.writeOne(this.vm, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddFromConfigurationResponseImpl actionResponse = new AddFromConfigurationResponseImpl();
                        actionResponse.vm(XmlVmReader.readOne(reader));
                        AddFromConfigurationResponseImpl addFromConfigurationResponseImpl = actionResponse;
                        reader.close();
                        return addFromConfigurationResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmsServiceImpl.this.checkFault(response);
            return new AddFromConfigurationResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmsService.AddResponse {
        private Vm vm;

        private AddResponseImpl() {
        }

        public void vm(Vm vm) {
            this.vm = vm;
        }

        @Override
        public Vm vm() {
            return this.vm;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmsService.AddRequest, VmsService.AddResponse>
    implements VmsService.AddRequest {
        private AutoPinningPolicy autoPinningPolicy;
        private Boolean clone_;
        private Boolean clonePermissions;
        private Boolean filter;
        private Vm vm;

        private AddRequestImpl() {
        }

        public VmsService.AddRequest autoPinningPolicy(AutoPinningPolicy autoPinningPolicy) {
            this.autoPinningPolicy = autoPinningPolicy;
            return this;
        }

        @Override
        public VmsService.AddRequest clone_(Boolean clone_) {
            this.clone_ = clone_;
            return this;
        }

        @Override
        public VmsService.AddRequest clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        @Override
        public VmsService.AddRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmsService.AddRequest vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        @Override
        public VmsService.AddRequest vm(VmBuilder vm) {
            this.vm = vm.build();
            return this;
        }

        @Override
        public VmsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmsServiceImpl.this.getConnection().getUrl() + VmsServiceImpl.this.getPath());
                if (this.autoPinningPolicy != null) {
                    uriBuilder.addParameter("auto_pinning_policy", XmlWriter.renderOther((Object)this.autoPinningPolicy));
                }
                if (this.clone_ != null) {
                    uriBuilder.addParameter("clone", XmlWriter.renderBoolean(this.clone_));
                }
                if (this.clonePermissions != null) {
                    uriBuilder.addParameter("clone_permissions", XmlWriter.renderBoolean(this.clonePermissions));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVmWriter.writeOne(this.vm, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.vm(XmlVmReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

