/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkFilterParameterBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.NicNetworkFilterParameterServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkFilterParameterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkFilterParameterWriter;
import org.ovirt.engine.sdk4.services.NicNetworkFilterParameterService;
import org.ovirt.engine.sdk4.services.NicNetworkFilterParametersService;
import org.ovirt.engine.sdk4.types.NetworkFilterParameter;

public class NicNetworkFilterParametersServiceImpl
extends ServiceImpl
implements NicNetworkFilterParametersService {
    public NicNetworkFilterParametersServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public NicNetworkFilterParametersService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public NicNetworkFilterParametersService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public NicNetworkFilterParameterService parameterService(String id) {
        return new NicNetworkFilterParameterServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.parameterService(path);
        }
        return this.parameterService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "NicNetworkFilterParametersService:" + this.getPath();
    }

    private class ListResponseImpl
    implements NicNetworkFilterParametersService.ListResponse {
        private List<NetworkFilterParameter> parameters;

        private ListResponseImpl() {
        }

        public void parameters(List<NetworkFilterParameter> parameters) {
            this.parameters = parameters;
        }

        @Override
        public List<NetworkFilterParameter> parameters() {
            return this.parameters;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<NicNetworkFilterParametersService.ListRequest, NicNetworkFilterParametersService.ListResponse>
    implements NicNetworkFilterParametersService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public NicNetworkFilterParametersService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public NicNetworkFilterParametersService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NicNetworkFilterParametersServiceImpl.this.getConnection().getUrl() + NicNetworkFilterParametersServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NicNetworkFilterParametersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.parameters(XmlNetworkFilterParameterReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NicNetworkFilterParametersServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements NicNetworkFilterParametersService.AddResponse {
        private NetworkFilterParameter parameter;

        private AddResponseImpl() {
        }

        public void parameter(NetworkFilterParameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public NetworkFilterParameter parameter() {
            return this.parameter;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<NicNetworkFilterParametersService.AddRequest, NicNetworkFilterParametersService.AddResponse>
    implements NicNetworkFilterParametersService.AddRequest {
        private NetworkFilterParameter parameter;

        private AddRequestImpl() {
        }

        @Override
        public NicNetworkFilterParametersService.AddRequest parameter(NetworkFilterParameter parameter) {
            this.parameter = parameter;
            return this;
        }

        @Override
        public NicNetworkFilterParametersService.AddRequest parameter(NetworkFilterParameterBuilder parameter) {
            this.parameter = parameter.build();
            return this;
        }

        @Override
        public NicNetworkFilterParametersService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NicNetworkFilterParametersServiceImpl.this.getConnection().getUrl() + NicNetworkFilterParametersServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNetworkFilterParameterWriter.writeOne(this.parameter, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NicNetworkFilterParametersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.parameter(XmlNetworkFilterParameterReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NicNetworkFilterParametersServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

