/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageConnectionExtensionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionExtensionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionExtensionWriter;
import org.ovirt.engine.sdk4.services.StorageServerConnectionExtensionService;
import org.ovirt.engine.sdk4.types.StorageConnectionExtension;

public class StorageServerConnectionExtensionServiceImpl
extends ServiceImpl
implements StorageServerConnectionExtensionService {
    public StorageServerConnectionExtensionServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageServerConnectionExtensionService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public StorageServerConnectionExtensionService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public StorageServerConnectionExtensionService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "StorageServerConnectionExtensionService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements StorageServerConnectionExtensionService.UpdateResponse {
        private StorageConnectionExtension extension;

        private UpdateResponseImpl() {
        }

        public void extension(StorageConnectionExtension extension) {
            this.extension = extension;
        }

        @Override
        public StorageConnectionExtension extension() {
            return this.extension;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<StorageServerConnectionExtensionService.UpdateRequest, StorageServerConnectionExtensionService.UpdateResponse>
    implements StorageServerConnectionExtensionService.UpdateRequest {
        private Boolean async;
        private StorageConnectionExtension extension;

        private UpdateRequestImpl() {
        }

        @Override
        public StorageServerConnectionExtensionService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionExtensionService.UpdateRequest extension(StorageConnectionExtension extension) {
            this.extension = extension;
            return this;
        }

        @Override
        public StorageServerConnectionExtensionService.UpdateRequest extension(StorageConnectionExtensionBuilder extension) {
            this.extension = extension.build();
            return this;
        }

        @Override
        public StorageServerConnectionExtensionService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionExtensionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionExtensionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionExtensionWriter.writeOne(this.extension, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionExtensionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.extension(XmlStorageConnectionExtensionReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionExtensionServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements StorageServerConnectionExtensionService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<StorageServerConnectionExtensionService.RemoveRequest, StorageServerConnectionExtensionService.RemoveResponse>
    implements StorageServerConnectionExtensionService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public StorageServerConnectionExtensionService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionExtensionService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionExtensionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionExtensionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionExtensionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            StorageServerConnectionExtensionServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements StorageServerConnectionExtensionService.GetResponse {
        private StorageConnectionExtension extension;

        private GetResponseImpl() {
        }

        public void extension(StorageConnectionExtension extension) {
            this.extension = extension;
        }

        @Override
        public StorageConnectionExtension extension() {
            return this.extension;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<StorageServerConnectionExtensionService.GetRequest, StorageServerConnectionExtensionService.GetResponse>
    implements StorageServerConnectionExtensionService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public StorageServerConnectionExtensionService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageServerConnectionExtensionService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionExtensionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionExtensionServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionExtensionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.extension(XmlStorageConnectionExtensionReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionExtensionServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

