/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;

/**
 * Describes the parameters for the template import operation from an external system.
 * Currently supports OVA only.
 */
public interface ExternalTemplateImport {
    boolean clone_();
    
    boolean clone_Present();
    
    String url();
    
    boolean urlPresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    CpuProfile cpuProfile();
    
    boolean cpuProfilePresent();
    
    Host host();
    
    boolean hostPresent();
    
    Quota quota();
    
    boolean quotaPresent();
    
    StorageDomain storageDomain();
    
    boolean storageDomainPresent();
    
    Template template();
    
    boolean templatePresent();
    
}
