#
# otopi -- plugable installer
#

%global		package_version 1.6.1
%global		package_maven_version 1.6.0

%global _use_maven 1
%global _use_repolib 0
%global maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy

Summary:	oVirt Task Oriented Pluggable Installer/Implementation (%{name})
Name:		otopi
Version:	1.6.1
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildArch:	noarch

Requires:	python
BuildRequires:	apache-commons-logging
BuildRequires:	java-devel
BuildRequires:	junit
BuildRequires:	gettext >= 0.18.2
BuildRequires:	python2-devel
BuildRequires:	javapackages-tools

%if %{_use_maven}
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-source-plugin
BuildRequires:	maven-surefire-provider-junit
BuildRequires:	maven-local
BuildRequires:	sonatype-oss-parent
%endif

%description
Standalone plugin based installation framework to be used to setup
system components. The plugin nature provides simplicity to
add new installation functionality without the complexity of the state
and transaction management.

%package java
Summary:	%{name} java support
Requires:	%{name} = %{version}-%{release}
Requires:	java
Requires:	apache-commons-logging

%description java
java libraries.

%if %{_use_maven}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.
%endif

%package devtools
Summary:	%{name} development tools
Requires:	%{name} = %{version}-%{release}

%description devtools
Development tools for %{name}.

%package debug-plugins
Summary:	%{name} debug plugins
Requires:	%{name} = %{version}-%{release}

%description debug-plugins
Debug plugins for %{name}.

%if 0%{?_use_repolib:1}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if %{_use_maven}
%global conf --disable-java-sdk-compile
%else
%global conf COMMONS_LOGGING_JAR=$(build-classpath commons-logging) JUNIT_JAR=$((build-classpath junit4 || build-classpath junit) | sed '/^$/d')
%endif
%configure \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	--enable-java-sdk \
	--with-local-version="%{name}-%{version}-%{release}" \
	%{?conf}
make %{?_smp_mflags}

%if %{_use_maven}
cd src/java
%mvn_build
cd ../..
%endif

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if %{_use_maven}
cd src/java
%mvn_install
cd ../..
%else
install -d "%{buildroot}%{_javadir}/%{name}"
install -m 644 target/%{name}-%{package_maven_version}.jar "%{buildroot}%{_javadir}/%{name}"
ln -s %{name}-%{package_maven_version}.jar "%{buildroot}%{_javadir}/%{name}/%{name}.jar"
cat > src/java/.mfiles << __EOF__
%{_javadir}/%{name}/
__EOF__

install -d "%{buildroot}%{maven2brewrepodir}"
cp "%{buildroot}%{_javadir}/%{name}/%{name}.jar" "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.jar"
cp src/java/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.pom"
%endif

install -d -m 755 "%{buildroot}%{_sysconfdir}/%{name}.conf.d"
%find_lang %{name}

%files -f %{name}.lang
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/plugins
%dir %{_sysconfdir}/%{name}.conf.d
%doc AUTHORS
%license COPYING
%doc README
%doc README.API
%doc README.dialog
%doc README.environment
%exclude %{python_sitelib}/%{name}/codegen/
%{_datadir}/%{name}/plugins/%{name}/
%exclude %{_datadir}/%{name}/plugins/%{name}/debug/
%{_sbindir}/%{name}
%{_bindir}/%{name}-config-query
%{python_sitelib}/%{name}/

%files java -f src/java/.mfiles

%if %{_use_maven}
%files javadoc -f src/java/.mfiles-javadoc
%endif

%files devtools
%{_datadir}/%{name}/%{name}-bundle
%{python_sitelib}/%{name}/codegen/

%files debug-plugins
%{_datadir}/%{name}/plugins/%{name}/debug/

%if %{_use_repolib}
%files repolib
%{maven2brewrepodir}/
%endif

%changelog
* Sun Mar 5 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.1-1
- Release.

* Thu Jan 12 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.0-1
- Release.

* Mon May 30 2016 Yedidyah Bar David <didi@redhat.com> - 1.5.0-1
- Release.

* Tue Feb 9 2016 Yedidyah Bar David <didi@redhat.com> - 1.4.1-1
- Release.

* Thu Oct 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.4.0-1
- Release.

* Thu Jan 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.3.1-1
- Release.

* Mon Oct 6 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.3.0-1
- Release.

* Fri May 2 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.1-1
- Release.

* Tue Mar 18 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-1
- Release.

* Wed Mar 12 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.11.rc4
- Release candidate.

* Tue Mar 11 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.9.rc3
- Release candidate.

* Thu Feb 27 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.7.rc2
- Release candidate.

* Thu Feb 27 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.5.rc
- Release candidate.

* Mon Feb 17 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.3.beta2
- Beta.

* Mon Jan 20 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.1.beta
- Beta.

* Mon Aug 26 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.0-1
- Release.

* Thu Feb 14 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-1
- Release.

* Sat Oct 13 2012 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-0.1_beta
- Initial add.
