// ============================================================================
//
// Copyright (c) 2006-2015, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.aggregationtodaily_4_2;

import routines.Numeric;
import routines.DataOperation;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.TalendString;
import routines.StringHandling;
import routines.Relational;
import routines.TalendDate;
import routines.Mathematical;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: AggregationToDaily Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 6.1.1.20151214_1327
 * @status 
 */
public class AggregationToDaily implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

			if (lastDayAggr != null) {

				String pattern_lastDayAggr = "yyyy-MM-dd HH:mm:ss";
				String value_lastDayAggr = "yyyy-MM-dd HH:mm:ss;2000-01-01 00:00:00";
				String[] parts_lastDayAggr = value_lastDayAggr.split(";");
				if (parts_lastDayAggr.length > 1) {
					pattern_lastDayAggr = parts_lastDayAggr[0];
					this.setProperty(
							"lastDayAggr",
							pattern_lastDayAggr
									+ ";"
									+ FormatterUtils.format_Date(lastDayAggr,
											pattern_lastDayAggr));
				} else {
					this.setProperty("lastDayAggr", FormatterUtils.format_Date(
							lastDayAggr, pattern_lastDayAggr));
				}

			}

		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}

		public java.util.Date lastDayAggr;

		public java.util.Date getLastDayAggr() {
			return this.lastDayAggr;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "4.2";
	private final String jobName = "AggregationToDaily";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());

	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private Exception exception;

	public Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					AggregationToDaily.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(AggregationToDaily.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (TalendException e) {
					// do nothing

				} catch (Exception e) {
					this.e.printStackTrace();
				}
			}
		}
	}

	public void tJDBCInput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_11_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_11_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_11_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_13_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_13_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_13_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPrejob_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPrejob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPostjob_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPostjob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_6_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_9_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_9_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_9_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_10_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_10_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_12_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_10_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_2_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_2_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_2_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_3_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_3_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_3_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_4_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_4_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_4_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_5_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_5_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_5_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_6_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_6_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_6_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_7_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_7_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_7_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_9_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_9_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_9_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAggregateRow_8_AGGOUT_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		tAggregateRow_8_AGGIN_error(exception, errorComponent, globalMap);

	}

	public void tAggregateRow_8_AGGIN_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		talendLogs_CONSOLE_error(exception, errorComponent, globalMap);

	}

	public void talendLogs_CONSOLE_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_3_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_4_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_11_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_13_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPrejob_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPostjob_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_9_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_10_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public static class row7Struct implements
			routines.system.IPersistableRow<row7Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public short host_status;

		public short getHost_status() {
			return this.host_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short max_memory_usage;

		public Short getMax_memory_usage() {
			return this.max_memory_usage;
		}

		public Long ksm_shared_memory_mb;

		public Long getKsm_shared_memory_mb() {
			return this.ksm_shared_memory_mb;
		}

		public Long max_ksm_shared_memory_mb;

		public Long getMax_ksm_shared_memory_mb() {
			return this.max_ksm_shared_memory_mb;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short max_cpu_usage;

		public Short getMax_cpu_usage() {
			return this.max_cpu_usage;
		}

		public Short ksm_cpu_percent;

		public Short getKsm_cpu_percent() {
			return this.ksm_cpu_percent;
		}

		public Short max_ksm_cpu_percent;

		public Short getMax_ksm_cpu_percent() {
			return this.max_ksm_cpu_percent;
		}

		public Short active_vms;

		public Short getActive_vms() {
			return this.active_vms;
		}

		public Short max_active_vms;

		public Short getMax_active_vms() {
			return this.max_active_vms;
		}

		public Short total_vms;

		public Short getTotal_vms() {
			return this.total_vms;
		}

		public Short max_total_vms;

		public Short getMax_total_vms() {
			return this.max_total_vms;
		}

		public Integer total_vms_vcpus;

		public Integer getTotal_vms_vcpus() {
			return this.total_vms_vcpus;
		}

		public Integer max_total_vms_vcpus;

		public Integer getMax_total_vms_vcpus() {
			return this.max_total_vms_vcpus;
		}

		public Integer cpu_load;

		public Integer getCpu_load() {
			return this.cpu_load;
		}

		public Integer max_cpu_load;

		public Integer getMax_cpu_load() {
			return this.max_cpu_load;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short max_system_cpu_usage_percent;

		public Short getMax_system_cpu_usage_percent() {
			return this.max_system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short max_user_cpu_usage_percent;

		public Short getMax_user_cpu_usage_percent() {
			return this.max_user_cpu_usage_percent;
		}

		public Integer swap_used_mb;

		public Integer getSwap_used_mb() {
			return this.swap_used_mb;
		}

		public Integer max_swap_used_mb;

		public Integer getMax_swap_used_mb() {
			return this.max_swap_used_mb;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_id = (Object) dis.readObject();

					this.host_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_usage = null;
					} else {
						this.max_memory_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_shared_memory_mb = null;
					} else {
						this.ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_ksm_shared_memory_mb = null;
					} else {
						this.max_ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_cpu_usage = null;
					} else {
						this.max_cpu_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_cpu_percent = null;
					} else {
						this.ksm_cpu_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_ksm_cpu_percent = null;
					} else {
						this.max_ksm_cpu_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.active_vms = null;
					} else {
						this.active_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_active_vms = null;
					} else {
						this.max_active_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.total_vms = null;
					} else {
						this.total_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_total_vms = null;
					} else {
						this.max_total_vms = dis.readShort();
					}

					this.total_vms_vcpus = readInteger(dis);

					this.max_total_vms_vcpus = readInteger(dis);

					this.cpu_load = readInteger(dis);

					this.max_cpu_load = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_system_cpu_usage_percent = null;
					} else {
						this.max_system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_user_cpu_usage_percent = null;
					} else {
						this.max_user_cpu_usage_percent = dis.readShort();
					}

					this.swap_used_mb = readInteger(dis);

					this.max_swap_used_mb = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_id);

				// short

				dos.writeShort(this.host_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.max_memory_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_memory_usage);
				}

				// Long

				if (this.ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.ksm_shared_memory_mb);
				}

				// Long

				if (this.max_ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_ksm_shared_memory_mb);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.max_cpu_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_cpu_usage);
				}

				// Short

				if (this.ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.ksm_cpu_percent);
				}

				// Short

				if (this.max_ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_ksm_cpu_percent);
				}

				// Short

				if (this.active_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.active_vms);
				}

				// Short

				if (this.max_active_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_active_vms);
				}

				// Short

				if (this.total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.total_vms);
				}

				// Short

				if (this.max_total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_total_vms);
				}

				// Integer

				writeInteger(this.total_vms_vcpus, dos);

				// Integer

				writeInteger(this.max_total_vms_vcpus, dos);

				// Integer

				writeInteger(this.cpu_load, dos);

				// Integer

				writeInteger(this.max_cpu_load, dos);

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.max_system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.max_user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_user_cpu_usage_percent);
				}

				// Integer

				writeInteger(this.swap_used_mb, dos);

				// Integer

				writeInteger(this.max_swap_used_mb, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_status=" + String.valueOf(host_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",max_memory_usage=" + String.valueOf(max_memory_usage));
			sb.append(",ksm_shared_memory_mb="
					+ String.valueOf(ksm_shared_memory_mb));
			sb.append(",max_ksm_shared_memory_mb="
					+ String.valueOf(max_ksm_shared_memory_mb));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",max_cpu_usage=" + String.valueOf(max_cpu_usage));
			sb.append(",ksm_cpu_percent=" + String.valueOf(ksm_cpu_percent));
			sb.append(",max_ksm_cpu_percent="
					+ String.valueOf(max_ksm_cpu_percent));
			sb.append(",active_vms=" + String.valueOf(active_vms));
			sb.append(",max_active_vms=" + String.valueOf(max_active_vms));
			sb.append(",total_vms=" + String.valueOf(total_vms));
			sb.append(",max_total_vms=" + String.valueOf(max_total_vms));
			sb.append(",total_vms_vcpus=" + String.valueOf(total_vms_vcpus));
			sb.append(",max_total_vms_vcpus="
					+ String.valueOf(max_total_vms_vcpus));
			sb.append(",cpu_load=" + String.valueOf(cpu_load));
			sb.append(",max_cpu_load=" + String.valueOf(max_cpu_load));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",max_system_cpu_usage_percent="
					+ String.valueOf(max_system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",max_user_cpu_usage_percent="
					+ String.valueOf(max_user_cpu_usage_percent));
			sb.append(",swap_used_mb=" + String.valueOf(swap_used_mb));
			sb.append(",max_swap_used_mb=" + String.valueOf(max_swap_used_mb));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row7Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_2 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_2> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public short host_status;

		public short getHost_status() {
			return this.host_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short max_memory_usage;

		public Short getMax_memory_usage() {
			return this.max_memory_usage;
		}

		public Long ksm_shared_memory_mb;

		public Long getKsm_shared_memory_mb() {
			return this.ksm_shared_memory_mb;
		}

		public Long max_ksm_shared_memory_mb;

		public Long getMax_ksm_shared_memory_mb() {
			return this.max_ksm_shared_memory_mb;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short max_cpu_usage;

		public Short getMax_cpu_usage() {
			return this.max_cpu_usage;
		}

		public Short ksm_cpu_percent;

		public Short getKsm_cpu_percent() {
			return this.ksm_cpu_percent;
		}

		public Short max_ksm_cpu_percent;

		public Short getMax_ksm_cpu_percent() {
			return this.max_ksm_cpu_percent;
		}

		public Short active_vms;

		public Short getActive_vms() {
			return this.active_vms;
		}

		public Short max_active_vms;

		public Short getMax_active_vms() {
			return this.max_active_vms;
		}

		public Short total_vms;

		public Short getTotal_vms() {
			return this.total_vms;
		}

		public Short max_total_vms;

		public Short getMax_total_vms() {
			return this.max_total_vms;
		}

		public Integer total_vms_vcpus;

		public Integer getTotal_vms_vcpus() {
			return this.total_vms_vcpus;
		}

		public Integer max_total_vms_vcpus;

		public Integer getMax_total_vms_vcpus() {
			return this.max_total_vms_vcpus;
		}

		public Integer cpu_load;

		public Integer getCpu_load() {
			return this.cpu_load;
		}

		public Integer max_cpu_load;

		public Integer getMax_cpu_load() {
			return this.max_cpu_load;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short max_system_cpu_usage_percent;

		public Short getMax_system_cpu_usage_percent() {
			return this.max_system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short max_user_cpu_usage_percent;

		public Short getMax_user_cpu_usage_percent() {
			return this.max_user_cpu_usage_percent;
		}

		public Integer swap_used_mb;

		public Integer getSwap_used_mb() {
			return this.swap_used_mb;
		}

		public Integer max_swap_used_mb;

		public Integer getMax_swap_used_mb() {
			return this.max_swap_used_mb;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_id = (Object) dis.readObject();

					this.host_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_usage = null;
					} else {
						this.max_memory_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_shared_memory_mb = null;
					} else {
						this.ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_ksm_shared_memory_mb = null;
					} else {
						this.max_ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_cpu_usage = null;
					} else {
						this.max_cpu_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_cpu_percent = null;
					} else {
						this.ksm_cpu_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_ksm_cpu_percent = null;
					} else {
						this.max_ksm_cpu_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.active_vms = null;
					} else {
						this.active_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_active_vms = null;
					} else {
						this.max_active_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.total_vms = null;
					} else {
						this.total_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_total_vms = null;
					} else {
						this.max_total_vms = dis.readShort();
					}

					this.total_vms_vcpus = readInteger(dis);

					this.max_total_vms_vcpus = readInteger(dis);

					this.cpu_load = readInteger(dis);

					this.max_cpu_load = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_system_cpu_usage_percent = null;
					} else {
						this.max_system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_user_cpu_usage_percent = null;
					} else {
						this.max_user_cpu_usage_percent = dis.readShort();
					}

					this.swap_used_mb = readInteger(dis);

					this.max_swap_used_mb = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_id);

				// short

				dos.writeShort(this.host_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.max_memory_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_memory_usage);
				}

				// Long

				if (this.ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.ksm_shared_memory_mb);
				}

				// Long

				if (this.max_ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_ksm_shared_memory_mb);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.max_cpu_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_cpu_usage);
				}

				// Short

				if (this.ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.ksm_cpu_percent);
				}

				// Short

				if (this.max_ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_ksm_cpu_percent);
				}

				// Short

				if (this.active_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.active_vms);
				}

				// Short

				if (this.max_active_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_active_vms);
				}

				// Short

				if (this.total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.total_vms);
				}

				// Short

				if (this.max_total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_total_vms);
				}

				// Integer

				writeInteger(this.total_vms_vcpus, dos);

				// Integer

				writeInteger(this.max_total_vms_vcpus, dos);

				// Integer

				writeInteger(this.cpu_load, dos);

				// Integer

				writeInteger(this.max_cpu_load, dos);

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.max_system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.max_user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_user_cpu_usage_percent);
				}

				// Integer

				writeInteger(this.swap_used_mb, dos);

				// Integer

				writeInteger(this.max_swap_used_mb, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_status=" + String.valueOf(host_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",max_memory_usage=" + String.valueOf(max_memory_usage));
			sb.append(",ksm_shared_memory_mb="
					+ String.valueOf(ksm_shared_memory_mb));
			sb.append(",max_ksm_shared_memory_mb="
					+ String.valueOf(max_ksm_shared_memory_mb));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",max_cpu_usage=" + String.valueOf(max_cpu_usage));
			sb.append(",ksm_cpu_percent=" + String.valueOf(ksm_cpu_percent));
			sb.append(",max_ksm_cpu_percent="
					+ String.valueOf(max_ksm_cpu_percent));
			sb.append(",active_vms=" + String.valueOf(active_vms));
			sb.append(",max_active_vms=" + String.valueOf(max_active_vms));
			sb.append(",total_vms=" + String.valueOf(total_vms));
			sb.append(",max_total_vms=" + String.valueOf(max_total_vms));
			sb.append(",total_vms_vcpus=" + String.valueOf(total_vms_vcpus));
			sb.append(",max_total_vms_vcpus="
					+ String.valueOf(max_total_vms_vcpus));
			sb.append(",cpu_load=" + String.valueOf(cpu_load));
			sb.append(",max_cpu_load=" + String.valueOf(max_cpu_load));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",max_system_cpu_usage_percent="
					+ String.valueOf(max_system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",max_user_cpu_usage_percent="
					+ String.valueOf(max_user_cpu_usage_percent));
			sb.append(",swap_used_mb=" + String.valueOf(swap_used_mb));
			sb.append(",max_swap_used_mb=" + String.valueOf(max_swap_used_mb));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_2 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class host_aggregationStruct implements
			routines.system.IPersistableRow<host_aggregationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public short host_status;

		public short getHost_status() {
			return this.host_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Long ksm_shared_memory_mb;

		public Long getKsm_shared_memory_mb() {
			return this.ksm_shared_memory_mb;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short ksm_cpu_percent;

		public Short getKsm_cpu_percent() {
			return this.ksm_cpu_percent;
		}

		public Short active_vms;

		public Short getActive_vms() {
			return this.active_vms;
		}

		public Short total_vms;

		public Short getTotal_vms() {
			return this.total_vms;
		}

		public Integer total_vms_vcpus;

		public Integer getTotal_vms_vcpus() {
			return this.total_vms_vcpus;
		}

		public Integer cpu_load;

		public Integer getCpu_load() {
			return this.cpu_load;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Integer swap_used_mb;

		public Integer getSwap_used_mb() {
			return this.swap_used_mb;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_id = (Object) dis.readObject();

					this.host_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_shared_memory_mb = null;
					} else {
						this.ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_cpu_percent = null;
					} else {
						this.ksm_cpu_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.active_vms = null;
					} else {
						this.active_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.total_vms = null;
					} else {
						this.total_vms = dis.readShort();
					}

					this.total_vms_vcpus = readInteger(dis);

					this.cpu_load = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					this.swap_used_mb = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_id);

				// short

				dos.writeShort(this.host_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Long

				if (this.ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.ksm_shared_memory_mb);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.ksm_cpu_percent);
				}

				// Short

				if (this.active_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.active_vms);
				}

				// Short

				if (this.total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.total_vms);
				}

				// Integer

				writeInteger(this.total_vms_vcpus, dos);

				// Integer

				writeInteger(this.cpu_load, dos);

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Integer

				writeInteger(this.swap_used_mb, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_status=" + String.valueOf(host_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",ksm_shared_memory_mb="
					+ String.valueOf(ksm_shared_memory_mb));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",ksm_cpu_percent=" + String.valueOf(ksm_cpu_percent));
			sb.append(",active_vms=" + String.valueOf(active_vms));
			sb.append(",total_vms=" + String.valueOf(total_vms));
			sb.append(",total_vms_vcpus=" + String.valueOf(total_vms_vcpus));
			sb.append(",cpu_load=" + String.valueOf(cpu_load));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",swap_used_mb=" + String.valueOf(swap_used_mb));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(host_aggregationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public short host_status;

		public short getHost_status() {
			return this.host_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Long ksm_shared_memory_mb;

		public Long getKsm_shared_memory_mb() {
			return this.ksm_shared_memory_mb;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short ksm_cpu_percent;

		public Short getKsm_cpu_percent() {
			return this.ksm_cpu_percent;
		}

		public Short active_vms;

		public Short getActive_vms() {
			return this.active_vms;
		}

		public Short total_vms;

		public Short getTotal_vms() {
			return this.total_vms;
		}

		public Integer total_vms_vcpus;

		public Integer getTotal_vms_vcpus() {
			return this.total_vms_vcpus;
		}

		public Integer cpu_load;

		public Integer getCpu_load() {
			return this.cpu_load;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Integer swap_used_mb;

		public Integer getSwap_used_mb() {
			return this.swap_used_mb;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

					this.history_datetime = readDate(dis);

					this.host_id = (Object) dis.readObject();

					this.host_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_shared_memory_mb = null;
					} else {
						this.ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_cpu_percent = null;
					} else {
						this.ksm_cpu_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.active_vms = null;
					} else {
						this.active_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.total_vms = null;
					} else {
						this.total_vms = dis.readShort();
					}

					this.total_vms_vcpus = readInteger(dis);

					this.cpu_load = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					this.swap_used_mb = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_id);

				// short

				dos.writeShort(this.host_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Long

				if (this.ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.ksm_shared_memory_mb);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.ksm_cpu_percent);
				}

				// Short

				if (this.active_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.active_vms);
				}

				// Short

				if (this.total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.total_vms);
				}

				// Integer

				writeInteger(this.total_vms_vcpus, dos);

				// Integer

				writeInteger(this.cpu_load, dos);

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Integer

				writeInteger(this.swap_used_mb, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_status=" + String.valueOf(host_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",ksm_shared_memory_mb="
					+ String.valueOf(ksm_shared_memory_mb));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",ksm_cpu_percent=" + String.valueOf(ksm_cpu_percent));
			sb.append(",active_vms=" + String.valueOf(active_vms));
			sb.append(",total_vms=" + String.valueOf(total_vms));
			sb.append(",total_vms_vcpus=" + String.valueOf(total_vms_vcpus));
			sb.append(",cpu_load=" + String.valueOf(cpu_load));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",swap_used_mb=" + String.valueOf(swap_used_mb));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row2Struct row2 = new row2Struct();
				host_aggregationStruct host_aggregation = new host_aggregationStruct();
				row7Struct row7 = new row7Struct();

				/**
				 * [tAggregateRow_2_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_2_AGGOUT", false);
				start_Hash.put("tAggregateRow_2_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_2";

				currentComponent = "tAggregateRow_2_AGGOUT";

				int tos_count_tAggregateRow_2_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_2 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_2 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_2 utilClass_tAggregateRow_2 = new UtilClass_tAggregateRow_2();

				class AggOperationStruct_tAggregateRow_2 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object host_id;
					short host_status;
					BigDecimal minutes_in_status_sum;

					Double memory_usage_percent_sum;
					int memory_usage_percent_count = 0;

					Short max_memory_usage_max;
					Double cpu_usage_percent_sum;
					int cpu_usage_percent_count = 0;

					Short max_cpu_usage_max;
					Double ksm_cpu_percent_sum;
					int ksm_cpu_percent_count = 0;

					Short max_ksm_cpu_percent_max;
					Double active_vms_sum;
					int active_vms_count = 0;

					Short max_active_vms_max;
					Double total_vms_sum;
					int total_vms_count = 0;

					Short max_total_vms_max;
					Double total_vms_vcpus_sum;
					int total_vms_vcpus_count = 0;

					Integer max_total_vms_vcpus_max;
					Double cpu_load_sum;
					int cpu_load_count = 0;

					Integer max_cpu_load_max;
					Double system_cpu_usage_percent_sum;
					int system_cpu_usage_percent_count = 0;

					Short max_system_cpu_usage_percent_max;
					Double user_cpu_usage_percent_sum;
					int user_cpu_usage_percent_count = 0;

					Short max_user_cpu_usage_percent_max;
					Double swap_used_mb_sum;
					int swap_used_mb_count = 0;

					Integer max_swap_used_mb_max;
					Integer host_configuration_version_last;
					BigDecimal ksm_shared_memory_mb_sum;
					int ksm_shared_memory_mb_count = 0;

					Long max_ksm_shared_memory_mb_max;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.host_id == null) ? 0
											: this.host_id.hashCode());

							result = prime * result + (int) this.host_status;

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_2 other = (AggOperationStruct_tAggregateRow_2) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.host_id == null) {
							if (other.host_id != null)
								return false;
						} else if (!this.host_id.equals(other.host_id))
							return false;

						if (this.host_status != other.host_status)
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_2 operation_result_tAggregateRow_2 = null;
				AggOperationStruct_tAggregateRow_2 operation_finder_tAggregateRow_2 = new AggOperationStruct_tAggregateRow_2();
				java.util.Map<AggOperationStruct_tAggregateRow_2, AggOperationStruct_tAggregateRow_2> hash_tAggregateRow_2 = new java.util.HashMap<AggOperationStruct_tAggregateRow_2, AggOperationStruct_tAggregateRow_2>();

				/**
				 * [tAggregateRow_2_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_2 begin ] start
				 */

				ok_Hash.put("tMap_2", false);
				start_Hash.put("tMap_2", System.currentTimeMillis());

				currentComponent = "tMap_2";

				int tos_count_tMap_2 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_2__Struct {
				}
				Var__tMap_2__Struct Var__tMap_2 = new Var__tMap_2__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				host_aggregationStruct host_aggregation_tmp = new host_aggregationStruct();
				// ###############################

				/**
				 * [tMap_2 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT \n  history_id, \n  history_datetime, \n  host_id, \n  host_status, \n  minutes_in_status, \n  memory_usage_percent, \n  ksm_shared_memory_mb,\n  cpu_usage_percent, \n  ksm_cpu_percent,  \n  active_vms,  \n  total_vms, \n  total_vms_vcpus, \n  cpu_load, \n  system_cpu_usage_percent,  \n  user_cpu_usage_percent, \n  swap_used_mb,  \n  host_configuration_version\nFROM host_hourly_history\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\nAND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY history_datetime,\n		 host_id,\n      	 host_status";

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);

				java.sql.ResultSet rs_tJDBCInput_2 = null;
				try {
					rs_tJDBCInput_2 = stmt_tJDBCInput_2
							.executeQuery(dbquery_tJDBCInput_2);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
							.getMetaData();
					int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
							.getColumnCount();

					String tmpContent_tJDBCInput_2 = null;

					while (rs_tJDBCInput_2.next()) {
						nb_line_tJDBCInput_2++;

						if (colQtyInRs_tJDBCInput_2 < 1) {
							row2.history_id = 0;
						} else {

							if (rs_tJDBCInput_2.getObject(1) != null) {
								row2.history_id = rs_tJDBCInput_2.getLong(1);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 2) {
							row2.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_2 = null;
							try {
								date_tJDBCInput_2 = rs_tJDBCInput_2
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_2 = rs_tJDBCInput_2.getDate(2);
							}
							row2.history_datetime = date_tJDBCInput_2;
						}
						if (colQtyInRs_tJDBCInput_2 < 3) {
							row2.host_id = null;
						} else {

							if (rs_tJDBCInput_2.getObject(3) != null) {
								row2.host_id = rs_tJDBCInput_2.getObject(3);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 4) {
							row2.host_status = 0;
						} else {

							if (rs_tJDBCInput_2.getObject(4) != null) {
								row2.host_status = rs_tJDBCInput_2.getShort(4);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 5) {
							row2.minutes_in_status = 0;
						} else {

							if (rs_tJDBCInput_2.getObject(5) != null) {
								row2.minutes_in_status = rs_tJDBCInput_2
										.getDouble(5);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 6) {
							row2.memory_usage_percent = null;
						} else {

							if (rs_tJDBCInput_2.getObject(6) != null) {
								row2.memory_usage_percent = rs_tJDBCInput_2
										.getShort(6);
							} else {
								row2.memory_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 7) {
							row2.ksm_shared_memory_mb = null;
						} else {

							if (rs_tJDBCInput_2.getObject(7) != null) {
								row2.ksm_shared_memory_mb = rs_tJDBCInput_2
										.getLong(7);
							} else {
								row2.ksm_shared_memory_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 8) {
							row2.cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_2.getObject(8) != null) {
								row2.cpu_usage_percent = rs_tJDBCInput_2
										.getShort(8);
							} else {
								row2.cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 9) {
							row2.ksm_cpu_percent = null;
						} else {

							if (rs_tJDBCInput_2.getObject(9) != null) {
								row2.ksm_cpu_percent = rs_tJDBCInput_2
										.getShort(9);
							} else {
								row2.ksm_cpu_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 10) {
							row2.active_vms = null;
						} else {

							if (rs_tJDBCInput_2.getObject(10) != null) {
								row2.active_vms = rs_tJDBCInput_2.getShort(10);
							} else {
								row2.active_vms = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 11) {
							row2.total_vms = null;
						} else {

							if (rs_tJDBCInput_2.getObject(11) != null) {
								row2.total_vms = rs_tJDBCInput_2.getShort(11);
							} else {
								row2.total_vms = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 12) {
							row2.total_vms_vcpus = null;
						} else {

							if (rs_tJDBCInput_2.getObject(12) != null) {
								row2.total_vms_vcpus = rs_tJDBCInput_2
										.getInt(12);
							} else {
								row2.total_vms_vcpus = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 13) {
							row2.cpu_load = null;
						} else {

							if (rs_tJDBCInput_2.getObject(13) != null) {
								row2.cpu_load = rs_tJDBCInput_2.getInt(13);
							} else {
								row2.cpu_load = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 14) {
							row2.system_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_2.getObject(14) != null) {
								row2.system_cpu_usage_percent = rs_tJDBCInput_2
										.getShort(14);
							} else {
								row2.system_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 15) {
							row2.user_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_2.getObject(15) != null) {
								row2.user_cpu_usage_percent = rs_tJDBCInput_2
										.getShort(15);
							} else {
								row2.user_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 16) {
							row2.swap_used_mb = null;
						} else {

							if (rs_tJDBCInput_2.getObject(16) != null) {
								row2.swap_used_mb = rs_tJDBCInput_2.getInt(16);
							} else {
								row2.swap_used_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 17) {
							row2.host_configuration_version = null;
						} else {

							if (rs_tJDBCInput_2.getObject(17) != null) {
								row2.host_configuration_version = rs_tJDBCInput_2
										.getInt(17);
							} else {
								row2.host_configuration_version = null;
							}
						}

						/**
						 * [tJDBCInput_2 begin ] stop
						 */

						/**
						 * [tJDBCInput_2 main ] start
						 */

						currentComponent = "tJDBCInput_2";

						tos_count_tJDBCInput_2++;

						/**
						 * [tJDBCInput_2 main ] stop
						 */

						/**
						 * [tMap_2 main ] start
						 */

						currentComponent = "tMap_2";

						boolean hasCasePrimitiveKeyWithNull_tMap_2 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_2 = false;
						boolean mainRowRejected_tMap_2 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_2__Struct Var = Var__tMap_2;// ###############################
							// ###############################
							// # Output tables

							host_aggregation = null;

							// # Output table : 'host_aggregation'
							host_aggregation_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row2.history_datetime);
							host_aggregation_tmp.host_id = row2.host_id;
							host_aggregation_tmp.host_status = row2.host_status;
							host_aggregation_tmp.minutes_in_status = row2.minutes_in_status;
							host_aggregation_tmp.memory_usage_percent = row2.memory_usage_percent;
							host_aggregation_tmp.ksm_shared_memory_mb = row2.ksm_shared_memory_mb;
							host_aggregation_tmp.cpu_usage_percent = row2.cpu_usage_percent;
							host_aggregation_tmp.ksm_cpu_percent = row2.ksm_cpu_percent;
							host_aggregation_tmp.active_vms = row2.active_vms;
							host_aggregation_tmp.total_vms = row2.total_vms;
							host_aggregation_tmp.total_vms_vcpus = row2.total_vms_vcpus;
							host_aggregation_tmp.cpu_load = row2.cpu_load;
							host_aggregation_tmp.system_cpu_usage_percent = row2.system_cpu_usage_percent;
							host_aggregation_tmp.user_cpu_usage_percent = row2.user_cpu_usage_percent;
							host_aggregation_tmp.swap_used_mb = row2.swap_used_mb;
							host_aggregation_tmp.host_configuration_version = row2.host_configuration_version;
							host_aggregation = host_aggregation_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_2 = false;

						tos_count_tMap_2++;

						/**
						 * [tMap_2 main ] stop
						 */
						// Start of branch "host_aggregation"
						if (host_aggregation != null) {

							/**
							 * [tAggregateRow_2_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_2";

							currentComponent = "tAggregateRow_2_AGGOUT";

							operation_finder_tAggregateRow_2.history_datetime = host_aggregation.history_datetime;
							operation_finder_tAggregateRow_2.host_id = host_aggregation.host_id;
							operation_finder_tAggregateRow_2.host_status = host_aggregation.host_status;

							operation_finder_tAggregateRow_2.hashCodeDirty = true;

							operation_result_tAggregateRow_2 = hash_tAggregateRow_2
									.get(operation_finder_tAggregateRow_2);

							boolean isFirstAdd_tAggregateRow_2 = false;

							if (operation_result_tAggregateRow_2 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_2 = new AggOperationStruct_tAggregateRow_2();

								operation_result_tAggregateRow_2.history_datetime = operation_finder_tAggregateRow_2.history_datetime;
								operation_result_tAggregateRow_2.host_id = operation_finder_tAggregateRow_2.host_id;
								operation_result_tAggregateRow_2.host_status = operation_finder_tAggregateRow_2.host_status;

								isFirstAdd_tAggregateRow_2 = true;

								hash_tAggregateRow_2.put(
										operation_result_tAggregateRow_2,
										operation_result_tAggregateRow_2);

							} // G_OutMain_AggR_001

							if (operation_result_tAggregateRow_2.minutes_in_status_sum == null) {
								operation_result_tAggregateRow_2.minutes_in_status_sum = new BigDecimal(
										0).setScale(0);
							}
							operation_result_tAggregateRow_2.minutes_in_status_sum = operation_result_tAggregateRow_2.minutes_in_status_sum
									.add(new BigDecimal(
											String.valueOf(host_aggregation.minutes_in_status)));

							if (host_aggregation.memory_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.memory_usage_percent_count++;

								if (operation_result_tAggregateRow_2.memory_usage_percent_sum == null) {
									operation_result_tAggregateRow_2.memory_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_2.memory_usage_percent_sum = (double) (operation_result_tAggregateRow_2.memory_usage_percent_sum
										.doubleValue() + host_aggregation.memory_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (host_aggregation.memory_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_memory_usage_max == null
										|| host_aggregation.memory_usage_percent > operation_result_tAggregateRow_2.max_memory_usage_max

								) {
									operation_result_tAggregateRow_2.max_memory_usage_max = host_aggregation.memory_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_2.cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_2.cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_2.cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_2.cpu_usage_percent_sum
										.doubleValue() + host_aggregation.cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (host_aggregation.cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_cpu_usage_max == null
										|| host_aggregation.cpu_usage_percent > operation_result_tAggregateRow_2.max_cpu_usage_max

								) {
									operation_result_tAggregateRow_2.max_cpu_usage_max = host_aggregation.cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.ksm_cpu_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.ksm_cpu_percent_count++;

								if (operation_result_tAggregateRow_2.ksm_cpu_percent_sum == null) {
									operation_result_tAggregateRow_2.ksm_cpu_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_2.ksm_cpu_percent_sum = (double) (operation_result_tAggregateRow_2.ksm_cpu_percent_sum
										.doubleValue() + host_aggregation.ksm_cpu_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (host_aggregation.ksm_cpu_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_ksm_cpu_percent_max == null
										|| host_aggregation.ksm_cpu_percent > operation_result_tAggregateRow_2.max_ksm_cpu_percent_max

								) {
									operation_result_tAggregateRow_2.max_ksm_cpu_percent_max = host_aggregation.ksm_cpu_percent;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.active_vms != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.active_vms_count++;

								if (operation_result_tAggregateRow_2.active_vms_sum == null) {
									operation_result_tAggregateRow_2.active_vms_sum = (double) 0;
								}
								operation_result_tAggregateRow_2.active_vms_sum = (double) (operation_result_tAggregateRow_2.active_vms_sum
										.doubleValue() + host_aggregation.active_vms
										.shortValue());

							} // G_OutMain_AggR_546

							if (host_aggregation.active_vms != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_active_vms_max == null
										|| host_aggregation.active_vms > operation_result_tAggregateRow_2.max_active_vms_max

								) {
									operation_result_tAggregateRow_2.max_active_vms_max = host_aggregation.active_vms;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.total_vms != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.total_vms_count++;

								if (operation_result_tAggregateRow_2.total_vms_sum == null) {
									operation_result_tAggregateRow_2.total_vms_sum = (double) 0;
								}
								operation_result_tAggregateRow_2.total_vms_sum = (double) (operation_result_tAggregateRow_2.total_vms_sum
										.doubleValue() + host_aggregation.total_vms
										.shortValue());

							} // G_OutMain_AggR_546

							if (host_aggregation.total_vms != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_total_vms_max == null
										|| host_aggregation.total_vms > operation_result_tAggregateRow_2.max_total_vms_max

								) {
									operation_result_tAggregateRow_2.max_total_vms_max = host_aggregation.total_vms;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.total_vms_vcpus != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.total_vms_vcpus_count++;

								if (operation_result_tAggregateRow_2.total_vms_vcpus_sum == null) {
									operation_result_tAggregateRow_2.total_vms_vcpus_sum = (double) 0;
								}

								if (host_aggregation.total_vms_vcpus != null)
									operation_result_tAggregateRow_2.total_vms_vcpus_sum += host_aggregation.total_vms_vcpus;
							} // G_OutMain_AggR_546

							if (host_aggregation.total_vms_vcpus != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_total_vms_vcpus_max == null
										|| host_aggregation.total_vms_vcpus > operation_result_tAggregateRow_2.max_total_vms_vcpus_max

								) {
									operation_result_tAggregateRow_2.max_total_vms_vcpus_max = host_aggregation.total_vms_vcpus;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.cpu_load != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.cpu_load_count++;

								if (operation_result_tAggregateRow_2.cpu_load_sum == null) {
									operation_result_tAggregateRow_2.cpu_load_sum = (double) 0;
								}

								if (host_aggregation.cpu_load != null)
									operation_result_tAggregateRow_2.cpu_load_sum += host_aggregation.cpu_load;
							} // G_OutMain_AggR_546

							if (host_aggregation.cpu_load != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_cpu_load_max == null
										|| host_aggregation.cpu_load > operation_result_tAggregateRow_2.max_cpu_load_max

								) {
									operation_result_tAggregateRow_2.max_cpu_load_max = host_aggregation.cpu_load;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.system_cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.system_cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_2.system_cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_2.system_cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_2.system_cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_2.system_cpu_usage_percent_sum
										.doubleValue() + host_aggregation.system_cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (host_aggregation.system_cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_system_cpu_usage_percent_max == null
										|| host_aggregation.system_cpu_usage_percent > operation_result_tAggregateRow_2.max_system_cpu_usage_percent_max

								) {
									operation_result_tAggregateRow_2.max_system_cpu_usage_percent_max = host_aggregation.system_cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.user_cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.user_cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_2.user_cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_2.user_cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_2.user_cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_2.user_cpu_usage_percent_sum
										.doubleValue() + host_aggregation.user_cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (host_aggregation.user_cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_user_cpu_usage_percent_max == null
										|| host_aggregation.user_cpu_usage_percent > operation_result_tAggregateRow_2.max_user_cpu_usage_percent_max

								) {
									operation_result_tAggregateRow_2.max_user_cpu_usage_percent_max = host_aggregation.user_cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.swap_used_mb != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.swap_used_mb_count++;

								if (operation_result_tAggregateRow_2.swap_used_mb_sum == null) {
									operation_result_tAggregateRow_2.swap_used_mb_sum = (double) 0;
								}

								if (host_aggregation.swap_used_mb != null)
									operation_result_tAggregateRow_2.swap_used_mb_sum += host_aggregation.swap_used_mb;
							} // G_OutMain_AggR_546

							if (host_aggregation.swap_used_mb != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_swap_used_mb_max == null
										|| host_aggregation.swap_used_mb > operation_result_tAggregateRow_2.max_swap_used_mb_max

								) {
									operation_result_tAggregateRow_2.max_swap_used_mb_max = host_aggregation.swap_used_mb;
								}

							} // G_OutMain_AggR_546

							if (host_aggregation.host_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.host_configuration_version_last = host_aggregation.host_configuration_version;

							} // G_OutMain_AggR_546

							if (host_aggregation.ksm_shared_memory_mb != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_2.ksm_shared_memory_mb_count++;

								if (operation_result_tAggregateRow_2.ksm_shared_memory_mb_sum == null) {
									operation_result_tAggregateRow_2.ksm_shared_memory_mb_sum = new BigDecimal(
											0).setScale(0);
								}
								operation_result_tAggregateRow_2.ksm_shared_memory_mb_sum = operation_result_tAggregateRow_2.ksm_shared_memory_mb_sum
										.add(new BigDecimal(
												String.valueOf(host_aggregation.ksm_shared_memory_mb)));

							} // G_OutMain_AggR_546

							if (host_aggregation.ksm_shared_memory_mb != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_2.max_ksm_shared_memory_mb_max == null
										|| host_aggregation.ksm_shared_memory_mb > operation_result_tAggregateRow_2.max_ksm_shared_memory_mb_max

								) {
									operation_result_tAggregateRow_2.max_ksm_shared_memory_mb_max = host_aggregation.ksm_shared_memory_mb;
								}

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_2_AGGOUT++;

							/**
							 * [tAggregateRow_2_AGGOUT main ] stop
							 */

						} // End of branch "host_aggregation"

						/**
						 * [tJDBCInput_2 end ] start
						 */

						currentComponent = "tJDBCInput_2";

					}
				} finally {
					if (rs_tJDBCInput_2 != null) {
						rs_tJDBCInput_2.close();
					}
					stmt_tJDBCInput_2.close();

				}
				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tMap_2 end ] start
				 */

				currentComponent = "tMap_2";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_2", true);
				end_Hash.put("tMap_2", System.currentTimeMillis());

				/**
				 * [tMap_2 end ] stop
				 */

				/**
				 * [tAggregateRow_2_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_2";

				currentComponent = "tAggregateRow_2_AGGOUT";

				ok_Hash.put("tAggregateRow_2_AGGOUT", true);
				end_Hash.put("tAggregateRow_2_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_2_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_2 = "INSERT INTO "
						+ "host_daily_history"
						+ " (history_datetime,host_id,host_status,minutes_in_status,memory_usage_percent,max_memory_usage,ksm_shared_memory_mb,max_ksm_shared_memory_mb,cpu_usage_percent,max_cpu_usage,ksm_cpu_percent,max_ksm_cpu_percent,active_vms,max_active_vms,total_vms,max_total_vms,total_vms_vcpus,max_total_vms_vcpus,cpu_load,max_cpu_load,system_cpu_usage_percent,max_system_cpu_usage_percent,user_cpu_usage_percent,max_user_cpu_usage_percent,swap_used_mb,max_swap_used_mb,host_configuration_version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(insert_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tAggregateRow_2_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_2_AGGIN", false);
				start_Hash.put("tAggregateRow_2_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_2";

				currentComponent = "tAggregateRow_2_AGGIN";

				int tos_count_tAggregateRow_2_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_2> values_tAggregateRow_2 = hash_tAggregateRow_2
						.values();

				globalMap.put("tAggregateRow_2_NB_LINE",
						values_tAggregateRow_2.size());

				for (AggOperationStruct_tAggregateRow_2 aggregated_row_tAggregateRow_2 : values_tAggregateRow_2) { // G_AggR_600

					/**
					 * [tAggregateRow_2_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_2_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_2";

					currentComponent = "tAggregateRow_2_AGGIN";

					row7.history_datetime = aggregated_row_tAggregateRow_2.history_datetime;

					row7.host_id = aggregated_row_tAggregateRow_2.host_id;

					row7.host_status = aggregated_row_tAggregateRow_2.host_status;

					if (aggregated_row_tAggregateRow_2.minutes_in_status_sum != null) {
						row7.minutes_in_status = aggregated_row_tAggregateRow_2.minutes_in_status_sum
								.doubleValue();

					} else {

						row7.minutes_in_status = 0;

					}

					if (aggregated_row_tAggregateRow_2.memory_usage_percent_count > 0) {

						double row7_memory_usage_percent_temp = (double) aggregated_row_tAggregateRow_2.memory_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_2.memory_usage_percent_count;

						row7.memory_usage_percent = (short) row7_memory_usage_percent_temp;

					} else {
						String count = "0";

						row7.memory_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row7.max_memory_usage = aggregated_row_tAggregateRow_2.max_memory_usage_max;
					if (aggregated_row_tAggregateRow_2.ksm_shared_memory_mb_count > 0) {

						row7.ksm_shared_memory_mb = aggregated_row_tAggregateRow_2.ksm_shared_memory_mb_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_2.ksm_shared_memory_mb_count)),
										10, BigDecimal.ROUND_HALF_UP)

								.longValue()

						;

					} else {
						String count = "0";

						row7.ksm_shared_memory_mb = ParserUtils
								.parseTo_Long(count);

					}
					row7.max_ksm_shared_memory_mb = aggregated_row_tAggregateRow_2.max_ksm_shared_memory_mb_max;
					if (aggregated_row_tAggregateRow_2.cpu_usage_percent_count > 0) {

						double row7_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_2.cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_2.cpu_usage_percent_count;

						row7.cpu_usage_percent = (short) row7_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row7.cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row7.max_cpu_usage = aggregated_row_tAggregateRow_2.max_cpu_usage_max;
					if (aggregated_row_tAggregateRow_2.ksm_cpu_percent_count > 0) {

						double row7_ksm_cpu_percent_temp = (double) aggregated_row_tAggregateRow_2.ksm_cpu_percent_sum
								/ (double) aggregated_row_tAggregateRow_2.ksm_cpu_percent_count;

						row7.ksm_cpu_percent = (short) row7_ksm_cpu_percent_temp;

					} else {
						String count = "0";

						row7.ksm_cpu_percent = ParserUtils.parseTo_Short(count);

					}
					row7.max_ksm_cpu_percent = aggregated_row_tAggregateRow_2.max_ksm_cpu_percent_max;
					if (aggregated_row_tAggregateRow_2.active_vms_count > 0) {

						double row7_active_vms_temp = (double) aggregated_row_tAggregateRow_2.active_vms_sum
								/ (double) aggregated_row_tAggregateRow_2.active_vms_count;

						row7.active_vms = (short) row7_active_vms_temp;

					} else {
						String count = "0";

						row7.active_vms = ParserUtils.parseTo_Short(count);

					}
					row7.max_active_vms = aggregated_row_tAggregateRow_2.max_active_vms_max;
					if (aggregated_row_tAggregateRow_2.total_vms_count > 0) {

						double row7_total_vms_temp = (double) aggregated_row_tAggregateRow_2.total_vms_sum
								/ (double) aggregated_row_tAggregateRow_2.total_vms_count;

						row7.total_vms = (short) row7_total_vms_temp;

					} else {
						String count = "0";

						row7.total_vms = ParserUtils.parseTo_Short(count);

					}
					row7.max_total_vms = aggregated_row_tAggregateRow_2.max_total_vms_max;
					if (aggregated_row_tAggregateRow_2.total_vms_vcpus_count > 0) {

						double row7_total_vms_vcpus_temp = (double) aggregated_row_tAggregateRow_2.total_vms_vcpus_sum
								/ (double) aggregated_row_tAggregateRow_2.total_vms_vcpus_count;

						row7.total_vms_vcpus = (int) row7_total_vms_vcpus_temp;

					} else {
						String count = "0";

						row7.total_vms_vcpus = ParserUtils
								.parseTo_Integer(count);

					}
					row7.max_total_vms_vcpus = aggregated_row_tAggregateRow_2.max_total_vms_vcpus_max;
					if (aggregated_row_tAggregateRow_2.cpu_load_count > 0) {

						double row7_cpu_load_temp = (double) aggregated_row_tAggregateRow_2.cpu_load_sum
								/ (double) aggregated_row_tAggregateRow_2.cpu_load_count;

						row7.cpu_load = (int) row7_cpu_load_temp;

					} else {
						String count = "0";

						row7.cpu_load = ParserUtils.parseTo_Integer(count);

					}
					row7.max_cpu_load = aggregated_row_tAggregateRow_2.max_cpu_load_max;
					if (aggregated_row_tAggregateRow_2.system_cpu_usage_percent_count > 0) {

						double row7_system_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_2.system_cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_2.system_cpu_usage_percent_count;

						row7.system_cpu_usage_percent = (short) row7_system_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row7.system_cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row7.max_system_cpu_usage_percent = aggregated_row_tAggregateRow_2.max_system_cpu_usage_percent_max;
					if (aggregated_row_tAggregateRow_2.user_cpu_usage_percent_count > 0) {

						double row7_user_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_2.user_cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_2.user_cpu_usage_percent_count;

						row7.user_cpu_usage_percent = (short) row7_user_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row7.user_cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row7.max_user_cpu_usage_percent = aggregated_row_tAggregateRow_2.max_user_cpu_usage_percent_max;
					if (aggregated_row_tAggregateRow_2.swap_used_mb_count > 0) {

						double row7_swap_used_mb_temp = (double) aggregated_row_tAggregateRow_2.swap_used_mb_sum
								/ (double) aggregated_row_tAggregateRow_2.swap_used_mb_count;

						row7.swap_used_mb = (int) row7_swap_used_mb_temp;

					} else {
						String count = "0";

						row7.swap_used_mb = ParserUtils.parseTo_Integer(count);

					}
					row7.max_swap_used_mb = aggregated_row_tAggregateRow_2.max_swap_used_mb_max;
					row7.host_configuration_version = aggregated_row_tAggregateRow_2.host_configuration_version_last;

					tos_count_tAggregateRow_2_AGGIN++;

					/**
					 * [tAggregateRow_2_AGGIN main ] stop
					 */

					/**
					 * [tJDBCOutput_2 main ] start
					 */

					currentComponent = "tJDBCOutput_2";

					whetherReject_tJDBCOutput_2 = false;
					if (row7.history_datetime != null) {
						pstmt_tJDBCOutput_2.setTimestamp(
								1,
								new java.sql.Timestamp(row7.history_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_2.setNull(1, java.sql.Types.DATE);
					}

					if (row7.host_id == null) {
						pstmt_tJDBCOutput_2.setNull(2, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_2.setObject(2, row7.host_id);
					}

					pstmt_tJDBCOutput_2.setShort(3, row7.host_status);

					pstmt_tJDBCOutput_2.setDouble(4, row7.minutes_in_status);

					if (row7.memory_usage_percent == null) {
						pstmt_tJDBCOutput_2.setNull(5, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(5,
								row7.memory_usage_percent);
					}

					if (row7.max_memory_usage == null) {
						pstmt_tJDBCOutput_2.setNull(6, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(6, row7.max_memory_usage);
					}

					if (row7.ksm_shared_memory_mb == null) {
						pstmt_tJDBCOutput_2.setNull(7, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setLong(7,
								row7.ksm_shared_memory_mb);
					}

					if (row7.max_ksm_shared_memory_mb == null) {
						pstmt_tJDBCOutput_2.setNull(8, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setLong(8,
								row7.max_ksm_shared_memory_mb);
					}

					if (row7.cpu_usage_percent == null) {
						pstmt_tJDBCOutput_2.setNull(9, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(9, row7.cpu_usage_percent);
					}

					if (row7.max_cpu_usage == null) {
						pstmt_tJDBCOutput_2.setNull(10, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(10, row7.max_cpu_usage);
					}

					if (row7.ksm_cpu_percent == null) {
						pstmt_tJDBCOutput_2.setNull(11, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(11, row7.ksm_cpu_percent);
					}

					if (row7.max_ksm_cpu_percent == null) {
						pstmt_tJDBCOutput_2.setNull(12, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(12,
								row7.max_ksm_cpu_percent);
					}

					if (row7.active_vms == null) {
						pstmt_tJDBCOutput_2.setNull(13, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(13, row7.active_vms);
					}

					if (row7.max_active_vms == null) {
						pstmt_tJDBCOutput_2.setNull(14, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(14, row7.max_active_vms);
					}

					if (row7.total_vms == null) {
						pstmt_tJDBCOutput_2.setNull(15, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(15, row7.total_vms);
					}

					if (row7.max_total_vms == null) {
						pstmt_tJDBCOutput_2.setNull(16, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(16, row7.max_total_vms);
					}

					if (row7.total_vms_vcpus == null) {
						pstmt_tJDBCOutput_2.setNull(17, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setInt(17, row7.total_vms_vcpus);
					}

					if (row7.max_total_vms_vcpus == null) {
						pstmt_tJDBCOutput_2.setNull(18, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2
								.setInt(18, row7.max_total_vms_vcpus);
					}

					if (row7.cpu_load == null) {
						pstmt_tJDBCOutput_2.setNull(19, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setInt(19, row7.cpu_load);
					}

					if (row7.max_cpu_load == null) {
						pstmt_tJDBCOutput_2.setNull(20, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setInt(20, row7.max_cpu_load);
					}

					if (row7.system_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_2.setNull(21, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(21,
								row7.system_cpu_usage_percent);
					}

					if (row7.max_system_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_2.setNull(22, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(22,
								row7.max_system_cpu_usage_percent);
					}

					if (row7.user_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_2.setNull(23, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(23,
								row7.user_cpu_usage_percent);
					}

					if (row7.max_user_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_2.setNull(24, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setShort(24,
								row7.max_user_cpu_usage_percent);
					}

					if (row7.swap_used_mb == null) {
						pstmt_tJDBCOutput_2.setNull(25, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setInt(25, row7.swap_used_mb);
					}

					if (row7.max_swap_used_mb == null) {
						pstmt_tJDBCOutput_2.setNull(26, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setInt(26, row7.max_swap_used_mb);
					}

					if (row7.host_configuration_version == null) {
						pstmt_tJDBCOutput_2.setNull(27, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_2.setInt(27,
								row7.host_configuration_version);
					}

					try {
						insertedCount_tJDBCOutput_2 = insertedCount_tJDBCOutput_2
								+ pstmt_tJDBCOutput_2.executeUpdate();
						nb_line_tJDBCOutput_2++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_2 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_2++;

					/**
					 * [tJDBCOutput_2 main ] stop
					 */

					/**
					 * [tAggregateRow_2_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_2";

					currentComponent = "tAggregateRow_2_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_2_AGGIN", true);
				end_Hash.put("tAggregateRow_2_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_2_AGGIN end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_2_AGGIN"
			globalMap.remove("tAggregateRow_2");

			try {

				/**
				 * [tJDBCInput_2 finally ] start
				 */

				currentComponent = "tJDBCInput_2";

				/**
				 * [tJDBCInput_2 finally ] stop
				 */

				/**
				 * [tMap_2 finally ] start
				 */

				currentComponent = "tMap_2";

				/**
				 * [tMap_2 finally ] stop
				 */

				/**
				 * [tAggregateRow_2_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_2";

				currentComponent = "tAggregateRow_2_AGGOUT";

				/**
				 * [tAggregateRow_2_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_2_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_2";

				currentComponent = "tAggregateRow_2_AGGIN";

				/**
				 * [tAggregateRow_2_AGGIN finally ] stop
				 */

				/**
				 * [tJDBCOutput_2 finally ] start
				 */

				currentComponent = "tJDBCOutput_2";

				/**
				 * [tJDBCOutput_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public static class row8Struct implements
			routines.system.IPersistableRow<row8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double max_receive_rate_percent;

		public Double getMax_receive_rate_percent() {
			return this.max_receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Double max_transmit_rate_percent;

		public Double getMax_transmit_rate_percent() {
			return this.max_transmit_rate_percent;
		}

		public Integer host_interface_configuration_version;

		public Integer getHost_interface_configuration_version() {
			return this.host_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_receive_rate_percent = null;
					} else {
						this.max_receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_transmit_rate_percent = null;
					} else {
						this.max_transmit_rate_percent = dis.readDouble();
					}

					this.host_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.max_receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Double

				if (this.max_transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_transmit_rate_percent);
				}

				// Integer

				writeInteger(this.host_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",max_receive_rate_percent="
					+ String.valueOf(max_receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",max_transmit_rate_percent="
					+ String.valueOf(max_transmit_rate_percent));
			sb.append(",host_interface_configuration_version="
					+ String.valueOf(host_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row8Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_3 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_3> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double max_receive_rate_percent;

		public Double getMax_receive_rate_percent() {
			return this.max_receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Double max_transmit_rate_percent;

		public Double getMax_transmit_rate_percent() {
			return this.max_transmit_rate_percent;
		}

		public Integer host_interface_configuration_version;

		public Integer getHost_interface_configuration_version() {
			return this.host_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_receive_rate_percent = null;
					} else {
						this.max_receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_transmit_rate_percent = null;
					} else {
						this.max_transmit_rate_percent = dis.readDouble();
					}

					this.host_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.max_receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Double

				if (this.max_transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_transmit_rate_percent);
				}

				// Integer

				writeInteger(this.host_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",max_receive_rate_percent="
					+ String.valueOf(max_receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",max_transmit_rate_percent="
					+ String.valueOf(max_transmit_rate_percent));
			sb.append(",host_interface_configuration_version="
					+ String.valueOf(host_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_3 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class host_history_history_aggregateStruct
			implements
			routines.system.IPersistableRow<host_history_history_aggregateStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Integer host_interface_configuration_version;

		public Integer getHost_interface_configuration_version() {
			return this.host_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					this.host_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Integer

				writeInteger(this.host_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",host_interface_configuration_version="
					+ String.valueOf(host_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(host_history_history_aggregateStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Integer host_interface_configuration_version;

		public Integer getHost_interface_configuration_version() {
			return this.host_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

					this.history_datetime = readDate(dis);

					this.host_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					this.host_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Integer

				writeInteger(this.host_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",host_interface_configuration_version="
					+ String.valueOf(host_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();
				host_history_history_aggregateStruct host_history_history_aggregate = new host_history_history_aggregateStruct();
				row8Struct row8 = new row8Struct();

				/**
				 * [tAggregateRow_3_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_3_AGGOUT", false);
				start_Hash.put("tAggregateRow_3_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_3";

				currentComponent = "tAggregateRow_3_AGGOUT";

				int tos_count_tAggregateRow_3_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_3 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_3 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_3 utilClass_tAggregateRow_3 = new UtilClass_tAggregateRow_3();

				class AggOperationStruct_tAggregateRow_3 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object host_interface_id;
					BigDecimal receive_rate_percent_sum;
					int receive_rate_percent_count = 0;

					Double max_receive_rate_percent_max;
					BigDecimal transmit_rate_percent_sum;
					int transmit_rate_percent_count = 0;

					Double max_transmit_rate_percent_max;
					Integer host_interface_configuration_version_last;
					Long received_total_byte_last;
					Long transmitted_total_byte_last;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.host_interface_id == null) ? 0
											: this.host_interface_id.hashCode());

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_3 other = (AggOperationStruct_tAggregateRow_3) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.host_interface_id == null) {
							if (other.host_interface_id != null)
								return false;
						} else if (!this.host_interface_id
								.equals(other.host_interface_id))
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_3 operation_result_tAggregateRow_3 = null;
				AggOperationStruct_tAggregateRow_3 operation_finder_tAggregateRow_3 = new AggOperationStruct_tAggregateRow_3();
				java.util.Map<AggOperationStruct_tAggregateRow_3, AggOperationStruct_tAggregateRow_3> hash_tAggregateRow_3 = new java.util.HashMap<AggOperationStruct_tAggregateRow_3, AggOperationStruct_tAggregateRow_3>();

				/**
				 * [tAggregateRow_3_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_3 begin ] start
				 */

				ok_Hash.put("tMap_3", false);
				start_Hash.put("tMap_3", System.currentTimeMillis());

				currentComponent = "tMap_3";

				int tos_count_tMap_3 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_3__Struct {
				}
				Var__tMap_3__Struct Var__tMap_3 = new Var__tMap_3__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				host_history_history_aggregateStruct host_history_history_aggregate_tmp = new host_history_history_aggregateStruct();
				// ###############################

				/**
				 * [tMap_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_3 begin ] start
				 */

				ok_Hash.put("tJDBCInput_3", false);
				start_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				currentComponent = "tJDBCInput_3";

				int tos_count_tJDBCInput_3 = 0;

				int nb_line_tJDBCInput_3 = 0;
				java.sql.Connection conn_tJDBCInput_3 = null;
				conn_tJDBCInput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_3 = conn_tJDBCInput_3
						.createStatement();

				String dbquery_tJDBCInput_3 = "SELECT\n history_id,\n history_datetime,\n host_interface_id,\n receive_rate_percent,\n transmit_rate_percent,\n host_interface_configuration_version,\n received_total_byte,\n transmitted_total_byte\nFROM host_interface_hourly_history\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\nAND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY history_datetime,\n      	 host_interface_id";

				globalMap.put("tJDBCInput_3_QUERY", dbquery_tJDBCInput_3);

				java.sql.ResultSet rs_tJDBCInput_3 = null;
				try {
					rs_tJDBCInput_3 = stmt_tJDBCInput_3
							.executeQuery(dbquery_tJDBCInput_3);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_3 = rs_tJDBCInput_3
							.getMetaData();
					int colQtyInRs_tJDBCInput_3 = rsmd_tJDBCInput_3
							.getColumnCount();

					String tmpContent_tJDBCInput_3 = null;

					while (rs_tJDBCInput_3.next()) {
						nb_line_tJDBCInput_3++;

						if (colQtyInRs_tJDBCInput_3 < 1) {
							row3.history_id = 0;
						} else {

							if (rs_tJDBCInput_3.getObject(1) != null) {
								row3.history_id = rs_tJDBCInput_3.getLong(1);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 2) {
							row3.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_3 = null;
							try {
								date_tJDBCInput_3 = rs_tJDBCInput_3
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_3 = rs_tJDBCInput_3.getDate(2);
							}
							row3.history_datetime = date_tJDBCInput_3;
						}
						if (colQtyInRs_tJDBCInput_3 < 3) {
							row3.host_interface_id = null;
						} else {

							if (rs_tJDBCInput_3.getObject(3) != null) {
								row3.host_interface_id = rs_tJDBCInput_3
										.getObject(3);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 4) {
							row3.receive_rate_percent = null;
						} else {

							if (rs_tJDBCInput_3.getObject(4) != null) {
								row3.receive_rate_percent = rs_tJDBCInput_3
										.getDouble(4);
							} else {
								row3.receive_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 5) {
							row3.transmit_rate_percent = null;
						} else {

							if (rs_tJDBCInput_3.getObject(5) != null) {
								row3.transmit_rate_percent = rs_tJDBCInput_3
										.getDouble(5);
							} else {
								row3.transmit_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 6) {
							row3.host_interface_configuration_version = null;
						} else {

							if (rs_tJDBCInput_3.getObject(6) != null) {
								row3.host_interface_configuration_version = rs_tJDBCInput_3
										.getInt(6);
							} else {
								row3.host_interface_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 7) {
							row3.received_total_byte = null;
						} else {

							if (rs_tJDBCInput_3.getObject(7) != null) {
								row3.received_total_byte = rs_tJDBCInput_3
										.getLong(7);
							} else {
								row3.received_total_byte = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 8) {
							row3.transmitted_total_byte = null;
						} else {

							if (rs_tJDBCInput_3.getObject(8) != null) {
								row3.transmitted_total_byte = rs_tJDBCInput_3
										.getLong(8);
							} else {
								row3.transmitted_total_byte = null;
							}
						}

						/**
						 * [tJDBCInput_3 begin ] stop
						 */

						/**
						 * [tJDBCInput_3 main ] start
						 */

						currentComponent = "tJDBCInput_3";

						tos_count_tJDBCInput_3++;

						/**
						 * [tJDBCInput_3 main ] stop
						 */

						/**
						 * [tMap_3 main ] start
						 */

						currentComponent = "tMap_3";

						boolean hasCasePrimitiveKeyWithNull_tMap_3 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_3 = false;
						boolean mainRowRejected_tMap_3 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_3__Struct Var = Var__tMap_3;// ###############################
							// ###############################
							// # Output tables

							host_history_history_aggregate = null;

							// # Output table : 'host_history_history_aggregate'
							host_history_history_aggregate_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row3.history_datetime);
							host_history_history_aggregate_tmp.host_interface_id = row3.host_interface_id;
							host_history_history_aggregate_tmp.receive_rate_percent = row3.receive_rate_percent;
							host_history_history_aggregate_tmp.transmit_rate_percent = row3.transmit_rate_percent;
							host_history_history_aggregate_tmp.host_interface_configuration_version = row3.host_interface_configuration_version;
							host_history_history_aggregate_tmp.received_total_byte = row3.received_total_byte;
							host_history_history_aggregate_tmp.transmitted_total_byte = row3.transmitted_total_byte;
							host_history_history_aggregate = host_history_history_aggregate_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_3 = false;

						tos_count_tMap_3++;

						/**
						 * [tMap_3 main ] stop
						 */
						// Start of branch "host_history_history_aggregate"
						if (host_history_history_aggregate != null) {

							/**
							 * [tAggregateRow_3_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_3";

							currentComponent = "tAggregateRow_3_AGGOUT";

							operation_finder_tAggregateRow_3.history_datetime = host_history_history_aggregate.history_datetime;
							operation_finder_tAggregateRow_3.host_interface_id = host_history_history_aggregate.host_interface_id;

							operation_finder_tAggregateRow_3.hashCodeDirty = true;

							operation_result_tAggregateRow_3 = hash_tAggregateRow_3
									.get(operation_finder_tAggregateRow_3);

							boolean isFirstAdd_tAggregateRow_3 = false;

							if (operation_result_tAggregateRow_3 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_3 = new AggOperationStruct_tAggregateRow_3();

								operation_result_tAggregateRow_3.history_datetime = operation_finder_tAggregateRow_3.history_datetime;
								operation_result_tAggregateRow_3.host_interface_id = operation_finder_tAggregateRow_3.host_interface_id;

								isFirstAdd_tAggregateRow_3 = true;

								hash_tAggregateRow_3.put(
										operation_result_tAggregateRow_3,
										operation_result_tAggregateRow_3);

							} // G_OutMain_AggR_001

							if (host_history_history_aggregate.receive_rate_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_3.receive_rate_percent_count++;

								if (operation_result_tAggregateRow_3.receive_rate_percent_sum == null) {
									operation_result_tAggregateRow_3.receive_rate_percent_sum = new BigDecimal(
											0).setScale(4);
								}
								operation_result_tAggregateRow_3.receive_rate_percent_sum = operation_result_tAggregateRow_3.receive_rate_percent_sum
										.add(new BigDecimal(
												String.valueOf(host_history_history_aggregate.receive_rate_percent)));

							} // G_OutMain_AggR_546

							if (host_history_history_aggregate.receive_rate_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_3.max_receive_rate_percent_max == null
										|| host_history_history_aggregate.receive_rate_percent > operation_result_tAggregateRow_3.max_receive_rate_percent_max

								) {
									operation_result_tAggregateRow_3.max_receive_rate_percent_max = host_history_history_aggregate.receive_rate_percent;
								}

							} // G_OutMain_AggR_546

							if (host_history_history_aggregate.transmit_rate_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_3.transmit_rate_percent_count++;

								if (operation_result_tAggregateRow_3.transmit_rate_percent_sum == null) {
									operation_result_tAggregateRow_3.transmit_rate_percent_sum = new BigDecimal(
											0).setScale(4);
								}
								operation_result_tAggregateRow_3.transmit_rate_percent_sum = operation_result_tAggregateRow_3.transmit_rate_percent_sum
										.add(new BigDecimal(
												String.valueOf(host_history_history_aggregate.transmit_rate_percent)));

							} // G_OutMain_AggR_546

							if (host_history_history_aggregate.transmit_rate_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_3.max_transmit_rate_percent_max == null
										|| host_history_history_aggregate.transmit_rate_percent > operation_result_tAggregateRow_3.max_transmit_rate_percent_max

								) {
									operation_result_tAggregateRow_3.max_transmit_rate_percent_max = host_history_history_aggregate.transmit_rate_percent;
								}

							} // G_OutMain_AggR_546

							if (host_history_history_aggregate.host_interface_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_3.host_interface_configuration_version_last = host_history_history_aggregate.host_interface_configuration_version;

							} // G_OutMain_AggR_546

							if (host_history_history_aggregate.received_total_byte != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_3.received_total_byte_last = host_history_history_aggregate.received_total_byte;

							} // G_OutMain_AggR_546

							if (host_history_history_aggregate.transmitted_total_byte != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_3.transmitted_total_byte_last = host_history_history_aggregate.transmitted_total_byte;

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_3_AGGOUT++;

							/**
							 * [tAggregateRow_3_AGGOUT main ] stop
							 */

						} // End of branch "host_history_history_aggregate"

						/**
						 * [tJDBCInput_3 end ] start
						 */

						currentComponent = "tJDBCInput_3";

					}
				} finally {
					if (rs_tJDBCInput_3 != null) {
						rs_tJDBCInput_3.close();
					}
					stmt_tJDBCInput_3.close();

				}
				globalMap.put("tJDBCInput_3_NB_LINE", nb_line_tJDBCInput_3);

				ok_Hash.put("tJDBCInput_3", true);
				end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				/**
				 * [tJDBCInput_3 end ] stop
				 */

				/**
				 * [tMap_3 end ] start
				 */

				currentComponent = "tMap_3";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_3", true);
				end_Hash.put("tMap_3", System.currentTimeMillis());

				/**
				 * [tMap_3 end ] stop
				 */

				/**
				 * [tAggregateRow_3_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_3";

				currentComponent = "tAggregateRow_3_AGGOUT";

				ok_Hash.put("tAggregateRow_3_AGGOUT", true);
				end_Hash.put("tAggregateRow_3_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_3_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_3 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_3", false);
				start_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_3";

				int tos_count_tJDBCOutput_3 = 0;

				int nb_line_tJDBCOutput_3 = 0;
				int nb_line_update_tJDBCOutput_3 = 0;
				int nb_line_inserted_tJDBCOutput_3 = 0;
				int nb_line_deleted_tJDBCOutput_3 = 0;
				int nb_line_rejected_tJDBCOutput_3 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_3 = 0;

				int deletedCount_tJDBCOutput_3 = 0;
				int updatedCount_tJDBCOutput_3 = 0;
				int insertedCount_tJDBCOutput_3 = 0;
				int rejectedCount_tJDBCOutput_3 = 0;

				boolean whetherReject_tJDBCOutput_3 = false;

				java.sql.Connection connection_tJDBCOutput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_3 = "INSERT INTO "
						+ "host_interface_daily_history"
						+ " (history_datetime,host_interface_id,receive_rate_percent,max_receive_rate_percent,transmit_rate_percent,max_transmit_rate_percent,host_interface_configuration_version,received_total_byte,transmitted_total_byte) VALUES (?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_3 = connection_tJDBCOutput_3
						.prepareStatement(insert_tJDBCOutput_3);

				/**
				 * [tJDBCOutput_3 begin ] stop
				 */

				/**
				 * [tAggregateRow_3_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_3_AGGIN", false);
				start_Hash.put("tAggregateRow_3_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_3";

				currentComponent = "tAggregateRow_3_AGGIN";

				int tos_count_tAggregateRow_3_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_3> values_tAggregateRow_3 = hash_tAggregateRow_3
						.values();

				globalMap.put("tAggregateRow_3_NB_LINE",
						values_tAggregateRow_3.size());

				for (AggOperationStruct_tAggregateRow_3 aggregated_row_tAggregateRow_3 : values_tAggregateRow_3) { // G_AggR_600

					/**
					 * [tAggregateRow_3_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_3_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_3";

					currentComponent = "tAggregateRow_3_AGGIN";

					row8.history_datetime = aggregated_row_tAggregateRow_3.history_datetime;

					row8.host_interface_id = aggregated_row_tAggregateRow_3.host_interface_id;

					if (aggregated_row_tAggregateRow_3.receive_rate_percent_count > 0) {

						row8.receive_rate_percent = aggregated_row_tAggregateRow_3.receive_rate_percent_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_3.receive_rate_percent_count)),
										4, BigDecimal.ROUND_HALF_UP)

								.doubleValue()

						;

					} else {
						String count = "0";

						row8.receive_rate_percent = ParserUtils
								.parseTo_Double(count);

					}
					row8.max_receive_rate_percent = aggregated_row_tAggregateRow_3.max_receive_rate_percent_max;
					if (aggregated_row_tAggregateRow_3.transmit_rate_percent_count > 0) {

						row8.transmit_rate_percent = aggregated_row_tAggregateRow_3.transmit_rate_percent_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_3.transmit_rate_percent_count)),
										4, BigDecimal.ROUND_HALF_UP)

								.doubleValue()

						;

					} else {
						String count = "0";

						row8.transmit_rate_percent = ParserUtils
								.parseTo_Double(count);

					}
					row8.max_transmit_rate_percent = aggregated_row_tAggregateRow_3.max_transmit_rate_percent_max;
					row8.host_interface_configuration_version = aggregated_row_tAggregateRow_3.host_interface_configuration_version_last;
					row8.received_total_byte = aggregated_row_tAggregateRow_3.received_total_byte_last;
					row8.transmitted_total_byte = aggregated_row_tAggregateRow_3.transmitted_total_byte_last;

					tos_count_tAggregateRow_3_AGGIN++;

					/**
					 * [tAggregateRow_3_AGGIN main ] stop
					 */

					/**
					 * [tJDBCOutput_3 main ] start
					 */

					currentComponent = "tJDBCOutput_3";

					whetherReject_tJDBCOutput_3 = false;
					if (row8.history_datetime != null) {
						pstmt_tJDBCOutput_3.setTimestamp(
								1,
								new java.sql.Timestamp(row8.history_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_3.setNull(1, java.sql.Types.DATE);
					}

					if (row8.host_interface_id == null) {
						pstmt_tJDBCOutput_3.setNull(2, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_3
								.setObject(2, row8.host_interface_id);
					}

					if (row8.receive_rate_percent == null) {
						pstmt_tJDBCOutput_3.setNull(3, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_3.setDouble(3,
								row8.receive_rate_percent);
					}

					if (row8.max_receive_rate_percent == null) {
						pstmt_tJDBCOutput_3.setNull(4, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_3.setDouble(4,
								row8.max_receive_rate_percent);
					}

					if (row8.transmit_rate_percent == null) {
						pstmt_tJDBCOutput_3.setNull(5, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_3.setDouble(5,
								row8.transmit_rate_percent);
					}

					if (row8.max_transmit_rate_percent == null) {
						pstmt_tJDBCOutput_3.setNull(6, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_3.setDouble(6,
								row8.max_transmit_rate_percent);
					}

					if (row8.host_interface_configuration_version == null) {
						pstmt_tJDBCOutput_3.setNull(7, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_3.setInt(7,
								row8.host_interface_configuration_version);
					}

					if (row8.received_total_byte == null) {
						pstmt_tJDBCOutput_3.setNull(8, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_3
								.setLong(8, row8.received_total_byte);
					}

					if (row8.transmitted_total_byte == null) {
						pstmt_tJDBCOutput_3.setNull(9, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_3.setLong(9,
								row8.transmitted_total_byte);
					}

					try {
						insertedCount_tJDBCOutput_3 = insertedCount_tJDBCOutput_3
								+ pstmt_tJDBCOutput_3.executeUpdate();
						nb_line_tJDBCOutput_3++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_3 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_3++;

					/**
					 * [tJDBCOutput_3 main ] stop
					 */

					/**
					 * [tAggregateRow_3_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_3";

					currentComponent = "tAggregateRow_3_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_3_AGGIN", true);
				end_Hash.put("tAggregateRow_3_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_3_AGGIN end ] stop
				 */

				/**
				 * [tJDBCOutput_3 end ] start
				 */

				currentComponent = "tJDBCOutput_3";

				if (pstmt_tJDBCOutput_3 != null) {

					pstmt_tJDBCOutput_3.close();

				}

				nb_line_deleted_tJDBCOutput_3 = nb_line_deleted_tJDBCOutput_3
						+ deletedCount_tJDBCOutput_3;
				nb_line_update_tJDBCOutput_3 = nb_line_update_tJDBCOutput_3
						+ updatedCount_tJDBCOutput_3;
				nb_line_inserted_tJDBCOutput_3 = nb_line_inserted_tJDBCOutput_3
						+ insertedCount_tJDBCOutput_3;
				nb_line_rejected_tJDBCOutput_3 = nb_line_rejected_tJDBCOutput_3
						+ rejectedCount_tJDBCOutput_3;

				globalMap.put("tJDBCOutput_3_NB_LINE", nb_line_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_3);

				ok_Hash.put("tJDBCOutput_3", true);
				end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_3 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_3_AGGIN"
			globalMap.remove("tAggregateRow_3");

			try {

				/**
				 * [tJDBCInput_3 finally ] start
				 */

				currentComponent = "tJDBCInput_3";

				/**
				 * [tJDBCInput_3 finally ] stop
				 */

				/**
				 * [tMap_3 finally ] start
				 */

				currentComponent = "tMap_3";

				/**
				 * [tMap_3 finally ] stop
				 */

				/**
				 * [tAggregateRow_3_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_3";

				currentComponent = "tAggregateRow_3_AGGOUT";

				/**
				 * [tAggregateRow_3_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_3_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_3";

				currentComponent = "tAggregateRow_3_AGGIN";

				/**
				 * [tAggregateRow_3_AGGIN finally ] stop
				 */

				/**
				 * [tJDBCOutput_3 finally ] start
				 */

				currentComponent = "tJDBCOutput_3";

				/**
				 * [tJDBCOutput_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 1);
	}

	public static class row9Struct implements
			routines.system.IPersistableRow<row9Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public short vm_status;

		public short getVm_status() {
			return this.vm_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short max_cpu_usage;

		public Short getMax_cpu_usage() {
			return this.max_cpu_usage;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short max_memory_usage;

		public Short getMax_memory_usage() {
			return this.max_memory_usage;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short max_user_cpu_usage_percent;

		public Short getMax_user_cpu_usage_percent() {
			return this.max_user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short max_system_cpu_usage_percent;

		public Short getMax_system_cpu_usage_percent() {
			return this.max_system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public Object current_user_id;

		public Object getCurrent_user_id() {
			return this.current_user_id;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		public Long memory_buffered_kb;

		public Long getMemory_buffered_kb() {
			return this.memory_buffered_kb;
		}

		public Long max_memory_buffered_kb;

		public Long getMax_memory_buffered_kb() {
			return this.max_memory_buffered_kb;
		}

		public Long memory_cached_kb;

		public Long getMemory_cached_kb() {
			return this.memory_cached_kb;
		}

		public Long max_memory_cached_kb;

		public Long getMax_memory_cached_kb() {
			return this.max_memory_cached_kb;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_cpu_usage = null;
					} else {
						this.max_cpu_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_usage = null;
					} else {
						this.max_memory_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_user_cpu_usage_percent = null;
					} else {
						this.max_user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_system_cpu_usage_percent = null;
					} else {
						this.max_system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.current_user_id = (Object) dis.readObject();

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.memory_buffered_kb = null;
					} else {
						this.memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_buffered_kb = null;
					} else {
						this.max_memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_cached_kb = null;
					} else {
						this.memory_cached_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_cached_kb = null;
					} else {
						this.max_memory_cached_kb = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// short

				dos.writeShort(this.vm_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.max_cpu_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_cpu_usage);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.max_memory_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_memory_usage);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.max_user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.max_system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// Object

				dos.writeObject(this.current_user_id);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

				// Long

				if (this.memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_buffered_kb);
				}

				// Long

				if (this.max_memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_memory_buffered_kb);
				}

				// Long

				if (this.memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_cached_kb);
				}

				// Long

				if (this.max_memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_memory_cached_kb);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_status=" + String.valueOf(vm_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",max_cpu_usage=" + String.valueOf(max_cpu_usage));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",max_memory_usage=" + String.valueOf(max_memory_usage));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",max_user_cpu_usage_percent="
					+ String.valueOf(max_user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",max_system_cpu_usage_percent="
					+ String.valueOf(max_system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",current_user_id=" + String.valueOf(current_user_id));
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append(",memory_buffered_kb="
					+ String.valueOf(memory_buffered_kb));
			sb.append(",max_memory_buffered_kb="
					+ String.valueOf(max_memory_buffered_kb));
			sb.append(",memory_cached_kb=" + String.valueOf(memory_cached_kb));
			sb.append(",max_memory_cached_kb="
					+ String.valueOf(max_memory_cached_kb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row9Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_4 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_4> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public short vm_status;

		public short getVm_status() {
			return this.vm_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short max_cpu_usage;

		public Short getMax_cpu_usage() {
			return this.max_cpu_usage;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short max_memory_usage;

		public Short getMax_memory_usage() {
			return this.max_memory_usage;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short max_user_cpu_usage_percent;

		public Short getMax_user_cpu_usage_percent() {
			return this.max_user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short max_system_cpu_usage_percent;

		public Short getMax_system_cpu_usage_percent() {
			return this.max_system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public Object current_user_id;

		public Object getCurrent_user_id() {
			return this.current_user_id;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		public Long memory_buffered_kb;

		public Long getMemory_buffered_kb() {
			return this.memory_buffered_kb;
		}

		public Long max_memory_buffered_kb;

		public Long getMax_memory_buffered_kb() {
			return this.max_memory_buffered_kb;
		}

		public Long memory_cached_kb;

		public Long getMemory_cached_kb() {
			return this.memory_cached_kb;
		}

		public Long max_memory_cached_kb;

		public Long getMax_memory_cached_kb() {
			return this.max_memory_cached_kb;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_cpu_usage = null;
					} else {
						this.max_cpu_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_usage = null;
					} else {
						this.max_memory_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_user_cpu_usage_percent = null;
					} else {
						this.max_user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_system_cpu_usage_percent = null;
					} else {
						this.max_system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.current_user_id = (Object) dis.readObject();

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.memory_buffered_kb = null;
					} else {
						this.memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_buffered_kb = null;
					} else {
						this.max_memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_cached_kb = null;
					} else {
						this.memory_cached_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_cached_kb = null;
					} else {
						this.max_memory_cached_kb = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// short

				dos.writeShort(this.vm_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.max_cpu_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_cpu_usage);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.max_memory_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_memory_usage);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.max_user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.max_system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// Object

				dos.writeObject(this.current_user_id);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

				// Long

				if (this.memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_buffered_kb);
				}

				// Long

				if (this.max_memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_memory_buffered_kb);
				}

				// Long

				if (this.memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_cached_kb);
				}

				// Long

				if (this.max_memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_memory_cached_kb);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_status=" + String.valueOf(vm_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",max_cpu_usage=" + String.valueOf(max_cpu_usage));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",max_memory_usage=" + String.valueOf(max_memory_usage));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",max_user_cpu_usage_percent="
					+ String.valueOf(max_user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",max_system_cpu_usage_percent="
					+ String.valueOf(max_system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",current_user_id=" + String.valueOf(current_user_id));
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append(",memory_buffered_kb="
					+ String.valueOf(memory_buffered_kb));
			sb.append(",max_memory_buffered_kb="
					+ String.valueOf(max_memory_buffered_kb));
			sb.append(",memory_cached_kb=" + String.valueOf(memory_cached_kb));
			sb.append(",max_memory_cached_kb="
					+ String.valueOf(max_memory_cached_kb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_4 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class vm_aggregate_historyStruct implements
			routines.system.IPersistableRow<vm_aggregate_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public short vm_status;

		public short getVm_status() {
			return this.vm_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public Object current_user_id;

		public Object getCurrent_user_id() {
			return this.current_user_id;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		public Long memory_buffered_kb;

		public Long getMemory_buffered_kb() {
			return this.memory_buffered_kb;
		}

		public Long memory_cached_kb;

		public Long getMemory_cached_kb() {
			return this.memory_cached_kb;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.current_user_id = (Object) dis.readObject();

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.memory_buffered_kb = null;
					} else {
						this.memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_cached_kb = null;
					} else {
						this.memory_cached_kb = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// short

				dos.writeShort(this.vm_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// Object

				dos.writeObject(this.current_user_id);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

				// Long

				if (this.memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_buffered_kb);
				}

				// Long

				if (this.memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_cached_kb);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_status=" + String.valueOf(vm_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",current_user_id=" + String.valueOf(current_user_id));
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append(",memory_buffered_kb="
					+ String.valueOf(memory_buffered_kb));
			sb.append(",memory_cached_kb=" + String.valueOf(memory_cached_kb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_aggregate_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row4Struct implements
			routines.system.IPersistableRow<row4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public short vm_status;

		public short getVm_status() {
			return this.vm_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public Object current_user_id;

		public Object getCurrent_user_id() {
			return this.current_user_id;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		public Long memory_buffered_kb;

		public Long getMemory_buffered_kb() {
			return this.memory_buffered_kb;
		}

		public Long memory_cached_kb;

		public Long getMemory_cached_kb() {
			return this.memory_cached_kb;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.current_user_id = (Object) dis.readObject();

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.memory_buffered_kb = null;
					} else {
						this.memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_cached_kb = null;
					} else {
						this.memory_cached_kb = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// short

				dos.writeShort(this.vm_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// Object

				dos.writeObject(this.current_user_id);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

				// Long

				if (this.memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_buffered_kb);
				}

				// Long

				if (this.memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_cached_kb);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_status=" + String.valueOf(vm_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",current_user_id=" + String.valueOf(current_user_id));
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append(",memory_buffered_kb="
					+ String.valueOf(memory_buffered_kb));
			sb.append(",memory_cached_kb=" + String.valueOf(memory_cached_kb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row4Struct row4 = new row4Struct();
				vm_aggregate_historyStruct vm_aggregate_history = new vm_aggregate_historyStruct();
				row9Struct row9 = new row9Struct();

				/**
				 * [tAggregateRow_4_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_4_AGGOUT", false);
				start_Hash.put("tAggregateRow_4_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_4";

				currentComponent = "tAggregateRow_4_AGGOUT";

				int tos_count_tAggregateRow_4_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_4 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_4 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_4 utilClass_tAggregateRow_4 = new UtilClass_tAggregateRow_4();

				class AggOperationStruct_tAggregateRow_4 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object vm_id;
					short vm_status;
					BigDecimal minutes_in_status_sum;

					Double cpu_usage_percent_sum;
					int cpu_usage_percent_count = 0;

					Short max_cpu_usage_max;
					Double memory_usage_percent_sum;
					int memory_usage_percent_count = 0;

					Short max_memory_usage_max;
					Double user_cpu_usage_percent_sum;
					int user_cpu_usage_percent_count = 0;

					Short max_user_cpu_usage_percent_max;
					Double system_cpu_usage_percent_sum;
					int system_cpu_usage_percent_count = 0;

					Short max_system_cpu_usage_percent_max;
					String vm_ip_last;
					Object current_user_id_last;
					Object currently_running_on_host_last;
					Integer vm_configuration_version_last;
					Integer current_host_configuration_version_last;
					BigDecimal memory_buffered_kb_sum;
					int memory_buffered_kb_count = 0;

					Long max_memory_buffered_kb_max;
					BigDecimal memory_cached_kb_sum;
					int memory_cached_kb_count = 0;

					Long max_memory_cached_kb_max;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.vm_id == null) ? 0 : this.vm_id
											.hashCode());

							result = prime * result + (int) this.vm_status;

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_4 other = (AggOperationStruct_tAggregateRow_4) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.vm_id == null) {
							if (other.vm_id != null)
								return false;
						} else if (!this.vm_id.equals(other.vm_id))
							return false;

						if (this.vm_status != other.vm_status)
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_4 operation_result_tAggregateRow_4 = null;
				AggOperationStruct_tAggregateRow_4 operation_finder_tAggregateRow_4 = new AggOperationStruct_tAggregateRow_4();
				java.util.Map<AggOperationStruct_tAggregateRow_4, AggOperationStruct_tAggregateRow_4> hash_tAggregateRow_4 = new java.util.HashMap<AggOperationStruct_tAggregateRow_4, AggOperationStruct_tAggregateRow_4>();

				/**
				 * [tAggregateRow_4_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_4 begin ] start
				 */

				ok_Hash.put("tMap_4", false);
				start_Hash.put("tMap_4", System.currentTimeMillis());

				currentComponent = "tMap_4";

				int tos_count_tMap_4 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_4__Struct {
				}
				Var__tMap_4__Struct Var__tMap_4 = new Var__tMap_4__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_aggregate_historyStruct vm_aggregate_history_tmp = new vm_aggregate_historyStruct();
				// ###############################

				/**
				 * [tMap_4 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT \n  history_id, \n  history_datetime, \n  vm_id, \n  vm_status, \n  minutes_in_status, \n  cpu_usage_percent,  \n  memory_usage_percent, \n  user_cpu_usage_percent, \n  system_cpu_usage_percent,\n  vm_ip, \n  current_user_id,\n  currently_running_on_host, \n  vm_configuration_version, \n  current_host_configuration_version,\n  memory_buffered_kb,\n  memory_cached_kb\nFROM vm_hourly_history\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\nAND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY history_datetime,\n      	 vm_id,\n		 vm_status";

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);

				java.sql.ResultSet rs_tJDBCInput_4 = null;
				try {
					rs_tJDBCInput_4 = stmt_tJDBCInput_4
							.executeQuery(dbquery_tJDBCInput_4);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
							.getMetaData();
					int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
							.getColumnCount();

					String tmpContent_tJDBCInput_4 = null;

					while (rs_tJDBCInput_4.next()) {
						nb_line_tJDBCInput_4++;

						if (colQtyInRs_tJDBCInput_4 < 1) {
							row4.history_id = 0;
						} else {

							if (rs_tJDBCInput_4.getObject(1) != null) {
								row4.history_id = rs_tJDBCInput_4.getLong(1);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 2) {
							row4.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_4 = null;
							try {
								date_tJDBCInput_4 = rs_tJDBCInput_4
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_4 = rs_tJDBCInput_4.getDate(2);
							}
							row4.history_datetime = date_tJDBCInput_4;
						}
						if (colQtyInRs_tJDBCInput_4 < 3) {
							row4.vm_id = null;
						} else {

							if (rs_tJDBCInput_4.getObject(3) != null) {
								row4.vm_id = rs_tJDBCInput_4.getObject(3);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 4) {
							row4.vm_status = 0;
						} else {

							if (rs_tJDBCInput_4.getObject(4) != null) {
								row4.vm_status = rs_tJDBCInput_4.getShort(4);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 5) {
							row4.minutes_in_status = 0;
						} else {

							if (rs_tJDBCInput_4.getObject(5) != null) {
								row4.minutes_in_status = rs_tJDBCInput_4
										.getDouble(5);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 6) {
							row4.cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_4.getObject(6) != null) {
								row4.cpu_usage_percent = rs_tJDBCInput_4
										.getShort(6);
							} else {
								row4.cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 7) {
							row4.memory_usage_percent = null;
						} else {

							if (rs_tJDBCInput_4.getObject(7) != null) {
								row4.memory_usage_percent = rs_tJDBCInput_4
										.getShort(7);
							} else {
								row4.memory_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 8) {
							row4.user_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_4.getObject(8) != null) {
								row4.user_cpu_usage_percent = rs_tJDBCInput_4
										.getShort(8);
							} else {
								row4.user_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 9) {
							row4.system_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_4.getObject(9) != null) {
								row4.system_cpu_usage_percent = rs_tJDBCInput_4
										.getShort(9);
							} else {
								row4.system_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 10) {
							row4.vm_ip = null;
						} else {

							row4.vm_ip = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_4, 10, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 11) {
							row4.current_user_id = null;
						} else {

							if (rs_tJDBCInput_4.getObject(11) != null) {
								row4.current_user_id = rs_tJDBCInput_4
										.getObject(11);
							} else {
								row4.current_user_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 12) {
							row4.currently_running_on_host = null;
						} else {

							if (rs_tJDBCInput_4.getObject(12) != null) {
								row4.currently_running_on_host = rs_tJDBCInput_4
										.getObject(12);
							} else {
								row4.currently_running_on_host = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 13) {
							row4.vm_configuration_version = null;
						} else {

							if (rs_tJDBCInput_4.getObject(13) != null) {
								row4.vm_configuration_version = rs_tJDBCInput_4
										.getInt(13);
							} else {
								row4.vm_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 14) {
							row4.current_host_configuration_version = null;
						} else {

							if (rs_tJDBCInput_4.getObject(14) != null) {
								row4.current_host_configuration_version = rs_tJDBCInput_4
										.getInt(14);
							} else {
								row4.current_host_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 15) {
							row4.memory_buffered_kb = null;
						} else {

							if (rs_tJDBCInput_4.getObject(15) != null) {
								row4.memory_buffered_kb = rs_tJDBCInput_4
										.getLong(15);
							} else {
								row4.memory_buffered_kb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 16) {
							row4.memory_cached_kb = null;
						} else {

							if (rs_tJDBCInput_4.getObject(16) != null) {
								row4.memory_cached_kb = rs_tJDBCInput_4
										.getLong(16);
							} else {
								row4.memory_cached_kb = null;
							}
						}

						/**
						 * [tJDBCInput_4 begin ] stop
						 */

						/**
						 * [tJDBCInput_4 main ] start
						 */

						currentComponent = "tJDBCInput_4";

						tos_count_tJDBCInput_4++;

						/**
						 * [tJDBCInput_4 main ] stop
						 */

						/**
						 * [tMap_4 main ] start
						 */

						currentComponent = "tMap_4";

						boolean hasCasePrimitiveKeyWithNull_tMap_4 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_4 = false;
						boolean mainRowRejected_tMap_4 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_4__Struct Var = Var__tMap_4;// ###############################
							// ###############################
							// # Output tables

							vm_aggregate_history = null;

							// # Output table : 'vm_aggregate_history'
							vm_aggregate_history_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row4.history_datetime);
							vm_aggregate_history_tmp.vm_id = row4.vm_id;
							vm_aggregate_history_tmp.vm_status = row4.vm_status;
							vm_aggregate_history_tmp.minutes_in_status = row4.minutes_in_status;
							vm_aggregate_history_tmp.cpu_usage_percent = row4.cpu_usage_percent;
							vm_aggregate_history_tmp.memory_usage_percent = row4.memory_usage_percent;
							vm_aggregate_history_tmp.user_cpu_usage_percent = row4.user_cpu_usage_percent;
							vm_aggregate_history_tmp.system_cpu_usage_percent = row4.system_cpu_usage_percent;
							vm_aggregate_history_tmp.vm_ip = row4.vm_ip;
							vm_aggregate_history_tmp.current_user_id = row4.current_user_id;
							vm_aggregate_history_tmp.currently_running_on_host = row4.currently_running_on_host;
							vm_aggregate_history_tmp.vm_configuration_version = row4.vm_configuration_version;
							vm_aggregate_history_tmp.current_host_configuration_version = row4.current_host_configuration_version;
							vm_aggregate_history_tmp.memory_buffered_kb = row4.memory_buffered_kb;
							vm_aggregate_history_tmp.memory_cached_kb = row4.memory_cached_kb;
							vm_aggregate_history = vm_aggregate_history_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_4 = false;

						tos_count_tMap_4++;

						/**
						 * [tMap_4 main ] stop
						 */
						// Start of branch "vm_aggregate_history"
						if (vm_aggregate_history != null) {

							/**
							 * [tAggregateRow_4_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_4";

							currentComponent = "tAggregateRow_4_AGGOUT";

							operation_finder_tAggregateRow_4.history_datetime = vm_aggregate_history.history_datetime;
							operation_finder_tAggregateRow_4.vm_id = vm_aggregate_history.vm_id;
							operation_finder_tAggregateRow_4.vm_status = vm_aggregate_history.vm_status;

							operation_finder_tAggregateRow_4.hashCodeDirty = true;

							operation_result_tAggregateRow_4 = hash_tAggregateRow_4
									.get(operation_finder_tAggregateRow_4);

							boolean isFirstAdd_tAggregateRow_4 = false;

							if (operation_result_tAggregateRow_4 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_4 = new AggOperationStruct_tAggregateRow_4();

								operation_result_tAggregateRow_4.history_datetime = operation_finder_tAggregateRow_4.history_datetime;
								operation_result_tAggregateRow_4.vm_id = operation_finder_tAggregateRow_4.vm_id;
								operation_result_tAggregateRow_4.vm_status = operation_finder_tAggregateRow_4.vm_status;

								isFirstAdd_tAggregateRow_4 = true;

								hash_tAggregateRow_4.put(
										operation_result_tAggregateRow_4,
										operation_result_tAggregateRow_4);

							} // G_OutMain_AggR_001

							if (operation_result_tAggregateRow_4.minutes_in_status_sum == null) {
								operation_result_tAggregateRow_4.minutes_in_status_sum = new BigDecimal(
										0).setScale(0);
							}
							operation_result_tAggregateRow_4.minutes_in_status_sum = operation_result_tAggregateRow_4.minutes_in_status_sum
									.add(new BigDecimal(
											String.valueOf(vm_aggregate_history.minutes_in_status)));

							if (vm_aggregate_history.cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_4.cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_4.cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_4.cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_4.cpu_usage_percent_sum
										.doubleValue() + vm_aggregate_history.cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_4.max_cpu_usage_max == null
										|| vm_aggregate_history.cpu_usage_percent > operation_result_tAggregateRow_4.max_cpu_usage_max

								) {
									operation_result_tAggregateRow_4.max_cpu_usage_max = vm_aggregate_history.cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.memory_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.memory_usage_percent_count++;

								if (operation_result_tAggregateRow_4.memory_usage_percent_sum == null) {
									operation_result_tAggregateRow_4.memory_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_4.memory_usage_percent_sum = (double) (operation_result_tAggregateRow_4.memory_usage_percent_sum
										.doubleValue() + vm_aggregate_history.memory_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.memory_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_4.max_memory_usage_max == null
										|| vm_aggregate_history.memory_usage_percent > operation_result_tAggregateRow_4.max_memory_usage_max

								) {
									operation_result_tAggregateRow_4.max_memory_usage_max = vm_aggregate_history.memory_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.user_cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.user_cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_4.user_cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_4.user_cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_4.user_cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_4.user_cpu_usage_percent_sum
										.doubleValue() + vm_aggregate_history.user_cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.user_cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_4.max_user_cpu_usage_percent_max == null
										|| vm_aggregate_history.user_cpu_usage_percent > operation_result_tAggregateRow_4.max_user_cpu_usage_percent_max

								) {
									operation_result_tAggregateRow_4.max_user_cpu_usage_percent_max = vm_aggregate_history.user_cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.system_cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.system_cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_4.system_cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_4.system_cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_4.system_cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_4.system_cpu_usage_percent_sum
										.doubleValue() + vm_aggregate_history.system_cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.system_cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_4.max_system_cpu_usage_percent_max == null
										|| vm_aggregate_history.system_cpu_usage_percent > operation_result_tAggregateRow_4.max_system_cpu_usage_percent_max

								) {
									operation_result_tAggregateRow_4.max_system_cpu_usage_percent_max = vm_aggregate_history.system_cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.vm_ip != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.vm_ip_last = vm_aggregate_history.vm_ip;

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.current_user_id != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.current_user_id_last = vm_aggregate_history.current_user_id;

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.currently_running_on_host != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.currently_running_on_host_last = vm_aggregate_history.currently_running_on_host;

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.vm_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.vm_configuration_version_last = vm_aggregate_history.vm_configuration_version;

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.current_host_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.current_host_configuration_version_last = vm_aggregate_history.current_host_configuration_version;

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.memory_buffered_kb != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.memory_buffered_kb_count++;

								if (operation_result_tAggregateRow_4.memory_buffered_kb_sum == null) {
									operation_result_tAggregateRow_4.memory_buffered_kb_sum = new BigDecimal(
											0);
								}
								operation_result_tAggregateRow_4.memory_buffered_kb_sum = operation_result_tAggregateRow_4.memory_buffered_kb_sum
										.add(new BigDecimal(
												String.valueOf(vm_aggregate_history.memory_buffered_kb)));

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.memory_buffered_kb != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_4.max_memory_buffered_kb_max == null
										|| vm_aggregate_history.memory_buffered_kb > operation_result_tAggregateRow_4.max_memory_buffered_kb_max

								) {
									operation_result_tAggregateRow_4.max_memory_buffered_kb_max = vm_aggregate_history.memory_buffered_kb;
								}

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.memory_cached_kb != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_4.memory_cached_kb_count++;

								if (operation_result_tAggregateRow_4.memory_cached_kb_sum == null) {
									operation_result_tAggregateRow_4.memory_cached_kb_sum = new BigDecimal(
											0);
								}
								operation_result_tAggregateRow_4.memory_cached_kb_sum = operation_result_tAggregateRow_4.memory_cached_kb_sum
										.add(new BigDecimal(
												String.valueOf(vm_aggregate_history.memory_cached_kb)));

							} // G_OutMain_AggR_546

							if (vm_aggregate_history.memory_cached_kb != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_4.max_memory_cached_kb_max == null
										|| vm_aggregate_history.memory_cached_kb > operation_result_tAggregateRow_4.max_memory_cached_kb_max

								) {
									operation_result_tAggregateRow_4.max_memory_cached_kb_max = vm_aggregate_history.memory_cached_kb;
								}

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_4_AGGOUT++;

							/**
							 * [tAggregateRow_4_AGGOUT main ] stop
							 */

						} // End of branch "vm_aggregate_history"

						/**
						 * [tJDBCInput_4 end ] start
						 */

						currentComponent = "tJDBCInput_4";

					}
				} finally {
					if (rs_tJDBCInput_4 != null) {
						rs_tJDBCInput_4.close();
					}
					stmt_tJDBCInput_4.close();

				}
				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tMap_4 end ] start
				 */

				currentComponent = "tMap_4";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_4", true);
				end_Hash.put("tMap_4", System.currentTimeMillis());

				/**
				 * [tMap_4 end ] stop
				 */

				/**
				 * [tAggregateRow_4_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_4";

				currentComponent = "tAggregateRow_4_AGGOUT";

				ok_Hash.put("tAggregateRow_4_AGGOUT", true);
				end_Hash.put("tAggregateRow_4_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_4_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_4 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_4", false);
				start_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_4";

				int tos_count_tJDBCOutput_4 = 0;

				int nb_line_tJDBCOutput_4 = 0;
				int nb_line_update_tJDBCOutput_4 = 0;
				int nb_line_inserted_tJDBCOutput_4 = 0;
				int nb_line_deleted_tJDBCOutput_4 = 0;
				int nb_line_rejected_tJDBCOutput_4 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_4 = 0;

				int deletedCount_tJDBCOutput_4 = 0;
				int updatedCount_tJDBCOutput_4 = 0;
				int insertedCount_tJDBCOutput_4 = 0;
				int rejectedCount_tJDBCOutput_4 = 0;

				boolean whetherReject_tJDBCOutput_4 = false;

				java.sql.Connection connection_tJDBCOutput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_4 = "INSERT INTO "
						+ "vm_daily_history"
						+ " (history_datetime,vm_id,vm_status,minutes_in_status,cpu_usage_percent,max_cpu_usage,memory_usage_percent,max_memory_usage,user_cpu_usage_percent,max_user_cpu_usage_percent,system_cpu_usage_percent,max_system_cpu_usage_percent,vm_ip,current_user_id,currently_running_on_host,vm_configuration_version,current_host_configuration_version,memory_buffered_kb,max_memory_buffered_kb,memory_cached_kb,max_memory_cached_kb) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_4 = connection_tJDBCOutput_4
						.prepareStatement(insert_tJDBCOutput_4);

				/**
				 * [tJDBCOutput_4 begin ] stop
				 */

				/**
				 * [tAggregateRow_4_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_4_AGGIN", false);
				start_Hash.put("tAggregateRow_4_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_4";

				currentComponent = "tAggregateRow_4_AGGIN";

				int tos_count_tAggregateRow_4_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_4> values_tAggregateRow_4 = hash_tAggregateRow_4
						.values();

				globalMap.put("tAggregateRow_4_NB_LINE",
						values_tAggregateRow_4.size());

				for (AggOperationStruct_tAggregateRow_4 aggregated_row_tAggregateRow_4 : values_tAggregateRow_4) { // G_AggR_600

					/**
					 * [tAggregateRow_4_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_4_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_4";

					currentComponent = "tAggregateRow_4_AGGIN";

					row9.history_datetime = aggregated_row_tAggregateRow_4.history_datetime;

					row9.vm_id = aggregated_row_tAggregateRow_4.vm_id;

					row9.vm_status = aggregated_row_tAggregateRow_4.vm_status;

					if (aggregated_row_tAggregateRow_4.minutes_in_status_sum != null) {
						row9.minutes_in_status = aggregated_row_tAggregateRow_4.minutes_in_status_sum
								.doubleValue();

					} else {

						row9.minutes_in_status = 0;

					}

					if (aggregated_row_tAggregateRow_4.cpu_usage_percent_count > 0) {

						double row9_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_4.cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_4.cpu_usage_percent_count;

						row9.cpu_usage_percent = (short) row9_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row9.cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row9.max_cpu_usage = aggregated_row_tAggregateRow_4.max_cpu_usage_max;
					if (aggregated_row_tAggregateRow_4.memory_usage_percent_count > 0) {

						double row9_memory_usage_percent_temp = (double) aggregated_row_tAggregateRow_4.memory_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_4.memory_usage_percent_count;

						row9.memory_usage_percent = (short) row9_memory_usage_percent_temp;

					} else {
						String count = "0";

						row9.memory_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row9.max_memory_usage = aggregated_row_tAggregateRow_4.max_memory_usage_max;
					if (aggregated_row_tAggregateRow_4.user_cpu_usage_percent_count > 0) {

						double row9_user_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_4.user_cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_4.user_cpu_usage_percent_count;

						row9.user_cpu_usage_percent = (short) row9_user_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row9.user_cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row9.max_user_cpu_usage_percent = aggregated_row_tAggregateRow_4.max_user_cpu_usage_percent_max;
					if (aggregated_row_tAggregateRow_4.system_cpu_usage_percent_count > 0) {

						double row9_system_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_4.system_cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_4.system_cpu_usage_percent_count;

						row9.system_cpu_usage_percent = (short) row9_system_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row9.system_cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row9.max_system_cpu_usage_percent = aggregated_row_tAggregateRow_4.max_system_cpu_usage_percent_max;
					row9.vm_ip = aggregated_row_tAggregateRow_4.vm_ip_last;
					row9.current_user_id = aggregated_row_tAggregateRow_4.current_user_id_last;
					row9.currently_running_on_host = aggregated_row_tAggregateRow_4.currently_running_on_host_last;
					row9.vm_configuration_version = aggregated_row_tAggregateRow_4.vm_configuration_version_last;
					row9.current_host_configuration_version = aggregated_row_tAggregateRow_4.current_host_configuration_version_last;
					if (aggregated_row_tAggregateRow_4.memory_buffered_kb_count > 0) {

						row9.memory_buffered_kb = aggregated_row_tAggregateRow_4.memory_buffered_kb_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_4.memory_buffered_kb_count)),
										10, BigDecimal.ROUND_HALF_UP)

								.longValue()

						;

					} else {
						String count = "0";

						row9.memory_buffered_kb = ParserUtils
								.parseTo_Long(count);

					}
					row9.max_memory_buffered_kb = aggregated_row_tAggregateRow_4.max_memory_buffered_kb_max;
					if (aggregated_row_tAggregateRow_4.memory_cached_kb_count > 0) {

						row9.memory_cached_kb = aggregated_row_tAggregateRow_4.memory_cached_kb_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_4.memory_cached_kb_count)),
										10, BigDecimal.ROUND_HALF_UP)

								.longValue()

						;

					} else {
						String count = "0";

						row9.memory_cached_kb = ParserUtils.parseTo_Long(count);

					}
					row9.max_memory_cached_kb = aggregated_row_tAggregateRow_4.max_memory_cached_kb_max;

					tos_count_tAggregateRow_4_AGGIN++;

					/**
					 * [tAggregateRow_4_AGGIN main ] stop
					 */

					/**
					 * [tJDBCOutput_4 main ] start
					 */

					currentComponent = "tJDBCOutput_4";

					whetherReject_tJDBCOutput_4 = false;
					if (row9.history_datetime != null) {
						pstmt_tJDBCOutput_4.setTimestamp(
								1,
								new java.sql.Timestamp(row9.history_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_4.setNull(1, java.sql.Types.DATE);
					}

					if (row9.vm_id == null) {
						pstmt_tJDBCOutput_4.setNull(2, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_4.setObject(2, row9.vm_id);
					}

					pstmt_tJDBCOutput_4.setShort(3, row9.vm_status);

					pstmt_tJDBCOutput_4.setDouble(4, row9.minutes_in_status);

					if (row9.cpu_usage_percent == null) {
						pstmt_tJDBCOutput_4.setNull(5, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(5, row9.cpu_usage_percent);
					}

					if (row9.max_cpu_usage == null) {
						pstmt_tJDBCOutput_4.setNull(6, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(6, row9.max_cpu_usage);
					}

					if (row9.memory_usage_percent == null) {
						pstmt_tJDBCOutput_4.setNull(7, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(7,
								row9.memory_usage_percent);
					}

					if (row9.max_memory_usage == null) {
						pstmt_tJDBCOutput_4.setNull(8, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(8, row9.max_memory_usage);
					}

					if (row9.user_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_4.setNull(9, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(9,
								row9.user_cpu_usage_percent);
					}

					if (row9.max_user_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_4.setNull(10, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(10,
								row9.max_user_cpu_usage_percent);
					}

					if (row9.system_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_4.setNull(11, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(11,
								row9.system_cpu_usage_percent);
					}

					if (row9.max_system_cpu_usage_percent == null) {
						pstmt_tJDBCOutput_4.setNull(12, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setShort(12,
								row9.max_system_cpu_usage_percent);
					}

					if (row9.vm_ip == null) {
						pstmt_tJDBCOutput_4.setNull(13, java.sql.Types.VARCHAR);
					} else {
						pstmt_tJDBCOutput_4.setString(13, row9.vm_ip);
					}

					if (row9.current_user_id == null) {
						pstmt_tJDBCOutput_4.setNull(14, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_4.setObject(14, row9.current_user_id);
					}

					if (row9.currently_running_on_host == null) {
						pstmt_tJDBCOutput_4.setNull(15, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_4.setObject(15,
								row9.currently_running_on_host);
					}

					if (row9.vm_configuration_version == null) {
						pstmt_tJDBCOutput_4.setNull(16, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setInt(16,
								row9.vm_configuration_version);
					}

					if (row9.current_host_configuration_version == null) {
						pstmt_tJDBCOutput_4.setNull(17, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setInt(17,
								row9.current_host_configuration_version);
					}

					if (row9.memory_buffered_kb == null) {
						pstmt_tJDBCOutput_4.setNull(18, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4
								.setLong(18, row9.memory_buffered_kb);
					}

					if (row9.max_memory_buffered_kb == null) {
						pstmt_tJDBCOutput_4.setNull(19, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setLong(19,
								row9.max_memory_buffered_kb);
					}

					if (row9.memory_cached_kb == null) {
						pstmt_tJDBCOutput_4.setNull(20, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setLong(20, row9.memory_cached_kb);
					}

					if (row9.max_memory_cached_kb == null) {
						pstmt_tJDBCOutput_4.setNull(21, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_4.setLong(21,
								row9.max_memory_cached_kb);
					}

					try {
						insertedCount_tJDBCOutput_4 = insertedCount_tJDBCOutput_4
								+ pstmt_tJDBCOutput_4.executeUpdate();
						nb_line_tJDBCOutput_4++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_4 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_4++;

					/**
					 * [tJDBCOutput_4 main ] stop
					 */

					/**
					 * [tAggregateRow_4_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_4";

					currentComponent = "tAggregateRow_4_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_4_AGGIN", true);
				end_Hash.put("tAggregateRow_4_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_4_AGGIN end ] stop
				 */

				/**
				 * [tJDBCOutput_4 end ] start
				 */

				currentComponent = "tJDBCOutput_4";

				if (pstmt_tJDBCOutput_4 != null) {

					pstmt_tJDBCOutput_4.close();

				}

				nb_line_deleted_tJDBCOutput_4 = nb_line_deleted_tJDBCOutput_4
						+ deletedCount_tJDBCOutput_4;
				nb_line_update_tJDBCOutput_4 = nb_line_update_tJDBCOutput_4
						+ updatedCount_tJDBCOutput_4;
				nb_line_inserted_tJDBCOutput_4 = nb_line_inserted_tJDBCOutput_4
						+ insertedCount_tJDBCOutput_4;
				nb_line_rejected_tJDBCOutput_4 = nb_line_rejected_tJDBCOutput_4
						+ rejectedCount_tJDBCOutput_4;

				globalMap.put("tJDBCOutput_4_NB_LINE", nb_line_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_4);

				ok_Hash.put("tJDBCOutput_4", true);
				end_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_4 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_4_AGGIN"
			globalMap.remove("tAggregateRow_4");

			try {

				/**
				 * [tJDBCInput_4 finally ] start
				 */

				currentComponent = "tJDBCInput_4";

				/**
				 * [tJDBCInput_4 finally ] stop
				 */

				/**
				 * [tMap_4 finally ] start
				 */

				currentComponent = "tMap_4";

				/**
				 * [tMap_4 finally ] stop
				 */

				/**
				 * [tAggregateRow_4_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_4";

				currentComponent = "tAggregateRow_4_AGGOUT";

				/**
				 * [tAggregateRow_4_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_4_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_4";

				currentComponent = "tAggregateRow_4_AGGIN";

				/**
				 * [tAggregateRow_4_AGGIN finally ] stop
				 */

				/**
				 * [tJDBCOutput_4 finally ] start
				 */

				currentComponent = "tJDBCOutput_4";

				/**
				 * [tJDBCOutput_4 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class row10Struct implements
			routines.system.IPersistableRow<row10Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public Short receive_rate_percent;

		public Short getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Short max_receive_rate_percent;

		public Short getMax_receive_rate_percent() {
			return this.max_receive_rate_percent;
		}

		public Short transmit_rate_percent;

		public Short getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Short max_transmit_rate_percent;

		public Short getMax_transmit_rate_percent() {
			return this.max_transmit_rate_percent;
		}

		public Integer vm_interface_configuration_version;

		public Integer getVm_interface_configuration_version() {
			return this.vm_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_receive_rate_percent = null;
					} else {
						this.max_receive_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_transmit_rate_percent = null;
					} else {
						this.max_transmit_rate_percent = dis.readShort();
					}

					this.vm_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// Short

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.receive_rate_percent);
				}

				// Short

				if (this.max_receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_receive_rate_percent);
				}

				// Short

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.transmit_rate_percent);
				}

				// Short

				if (this.max_transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_transmit_rate_percent);
				}

				// Integer

				writeInteger(this.vm_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",max_receive_rate_percent="
					+ String.valueOf(max_receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",max_transmit_rate_percent="
					+ String.valueOf(max_transmit_rate_percent));
			sb.append(",vm_interface_configuration_version="
					+ String.valueOf(vm_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row10Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_5 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_5> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public Short receive_rate_percent;

		public Short getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Short max_receive_rate_percent;

		public Short getMax_receive_rate_percent() {
			return this.max_receive_rate_percent;
		}

		public Short transmit_rate_percent;

		public Short getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Short max_transmit_rate_percent;

		public Short getMax_transmit_rate_percent() {
			return this.max_transmit_rate_percent;
		}

		public Integer vm_interface_configuration_version;

		public Integer getVm_interface_configuration_version() {
			return this.vm_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_receive_rate_percent = null;
					} else {
						this.max_receive_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_transmit_rate_percent = null;
					} else {
						this.max_transmit_rate_percent = dis.readShort();
					}

					this.vm_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// Short

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.receive_rate_percent);
				}

				// Short

				if (this.max_receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_receive_rate_percent);
				}

				// Short

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.transmit_rate_percent);
				}

				// Short

				if (this.max_transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_transmit_rate_percent);
				}

				// Integer

				writeInteger(this.vm_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",max_receive_rate_percent="
					+ String.valueOf(max_receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",max_transmit_rate_percent="
					+ String.valueOf(max_transmit_rate_percent));
			sb.append(",vm_interface_configuration_version="
					+ String.valueOf(vm_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_5 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class vm_interface_aggregateStruct implements
			routines.system.IPersistableRow<vm_interface_aggregateStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public Short receive_rate_percent;

		public Short getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Short transmit_rate_percent;

		public Short getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Integer vm_interface_configuration_version;

		public Integer getVm_interface_configuration_version() {
			return this.vm_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readShort();
					}

					this.vm_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// Short

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.receive_rate_percent);
				}

				// Short

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.transmit_rate_percent);
				}

				// Integer

				writeInteger(this.vm_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",vm_interface_configuration_version="
					+ String.valueOf(vm_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_interface_aggregateStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row5Struct implements
			routines.system.IPersistableRow<row5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public Short receive_rate_percent;

		public Short getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Short transmit_rate_percent;

		public Short getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Integer vm_interface_configuration_version;

		public Integer getVm_interface_configuration_version() {
			return this.vm_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

					this.history_datetime = readDate(dis);

					this.vm_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readShort();
					}

					this.vm_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// Short

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.receive_rate_percent);
				}

				// Short

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.transmit_rate_percent);
				}

				// Integer

				writeInteger(this.vm_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",vm_interface_configuration_version="
					+ String.valueOf(vm_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row5Struct row5 = new row5Struct();
				vm_interface_aggregateStruct vm_interface_aggregate = new vm_interface_aggregateStruct();
				row10Struct row10 = new row10Struct();

				/**
				 * [tAggregateRow_5_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_5_AGGOUT", false);
				start_Hash.put("tAggregateRow_5_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_5";

				currentComponent = "tAggregateRow_5_AGGOUT";

				int tos_count_tAggregateRow_5_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_5 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_5 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_5 utilClass_tAggregateRow_5 = new UtilClass_tAggregateRow_5();

				class AggOperationStruct_tAggregateRow_5 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object vm_interface_id;
					Double receive_rate_percent_sum;
					int receive_rate_percent_count = 0;

					Short max_receive_rate_percent_max;
					Double transmit_rate_percent_sum;
					int transmit_rate_percent_count = 0;

					Short max_transmit_rate_percent_max;
					Integer vm_interface_configuration_version_last;
					Long received_total_byte_last;
					Long transmitted_total_byte_last;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.vm_interface_id == null) ? 0
											: this.vm_interface_id.hashCode());

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_5 other = (AggOperationStruct_tAggregateRow_5) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.vm_interface_id == null) {
							if (other.vm_interface_id != null)
								return false;
						} else if (!this.vm_interface_id
								.equals(other.vm_interface_id))
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_5 operation_result_tAggregateRow_5 = null;
				AggOperationStruct_tAggregateRow_5 operation_finder_tAggregateRow_5 = new AggOperationStruct_tAggregateRow_5();
				java.util.Map<AggOperationStruct_tAggregateRow_5, AggOperationStruct_tAggregateRow_5> hash_tAggregateRow_5 = new java.util.HashMap<AggOperationStruct_tAggregateRow_5, AggOperationStruct_tAggregateRow_5>();

				/**
				 * [tAggregateRow_5_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_5 begin ] start
				 */

				ok_Hash.put("tMap_5", false);
				start_Hash.put("tMap_5", System.currentTimeMillis());

				currentComponent = "tMap_5";

				int tos_count_tMap_5 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_5__Struct {
				}
				Var__tMap_5__Struct Var__tMap_5 = new Var__tMap_5__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_interface_aggregateStruct vm_interface_aggregate_tmp = new vm_interface_aggregateStruct();
				// ###############################

				/**
				 * [tMap_5 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT\n  history_id,\n  history_datetime,\n  vm_interface_id,\n  receive_rate_percent,\n  transmit_rate_percent,\n  vm_interface_configuration_version,\n  received_total_byte,\n  transmitted_total_byte\nFROM vm_interface_hourly_history\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\nAND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY history_datetime,\n		 vm_interface_id";

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);

				java.sql.ResultSet rs_tJDBCInput_5 = null;
				try {
					rs_tJDBCInput_5 = stmt_tJDBCInput_5
							.executeQuery(dbquery_tJDBCInput_5);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
							.getMetaData();
					int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
							.getColumnCount();

					String tmpContent_tJDBCInput_5 = null;

					while (rs_tJDBCInput_5.next()) {
						nb_line_tJDBCInput_5++;

						if (colQtyInRs_tJDBCInput_5 < 1) {
							row5.history_id = 0;
						} else {

							if (rs_tJDBCInput_5.getObject(1) != null) {
								row5.history_id = rs_tJDBCInput_5.getLong(1);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 2) {
							row5.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_5 = null;
							try {
								date_tJDBCInput_5 = rs_tJDBCInput_5
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_5 = rs_tJDBCInput_5.getDate(2);
							}
							row5.history_datetime = date_tJDBCInput_5;
						}
						if (colQtyInRs_tJDBCInput_5 < 3) {
							row5.vm_interface_id = null;
						} else {

							if (rs_tJDBCInput_5.getObject(3) != null) {
								row5.vm_interface_id = rs_tJDBCInput_5
										.getObject(3);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 4) {
							row5.receive_rate_percent = null;
						} else {

							if (rs_tJDBCInput_5.getObject(4) != null) {
								row5.receive_rate_percent = rs_tJDBCInput_5
										.getShort(4);
							} else {
								row5.receive_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 5) {
							row5.transmit_rate_percent = null;
						} else {

							if (rs_tJDBCInput_5.getObject(5) != null) {
								row5.transmit_rate_percent = rs_tJDBCInput_5
										.getShort(5);
							} else {
								row5.transmit_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 6) {
							row5.vm_interface_configuration_version = null;
						} else {

							if (rs_tJDBCInput_5.getObject(6) != null) {
								row5.vm_interface_configuration_version = rs_tJDBCInput_5
										.getInt(6);
							} else {
								row5.vm_interface_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 7) {
							row5.received_total_byte = null;
						} else {

							if (rs_tJDBCInput_5.getObject(7) != null) {
								row5.received_total_byte = rs_tJDBCInput_5
										.getLong(7);
							} else {
								row5.received_total_byte = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 8) {
							row5.transmitted_total_byte = null;
						} else {

							if (rs_tJDBCInput_5.getObject(8) != null) {
								row5.transmitted_total_byte = rs_tJDBCInput_5
										.getLong(8);
							} else {
								row5.transmitted_total_byte = null;
							}
						}

						/**
						 * [tJDBCInput_5 begin ] stop
						 */

						/**
						 * [tJDBCInput_5 main ] start
						 */

						currentComponent = "tJDBCInput_5";

						tos_count_tJDBCInput_5++;

						/**
						 * [tJDBCInput_5 main ] stop
						 */

						/**
						 * [tMap_5 main ] start
						 */

						currentComponent = "tMap_5";

						boolean hasCasePrimitiveKeyWithNull_tMap_5 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_5 = false;
						boolean mainRowRejected_tMap_5 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_5__Struct Var = Var__tMap_5;// ###############################
							// ###############################
							// # Output tables

							vm_interface_aggregate = null;

							// # Output table : 'vm_interface_aggregate'
							vm_interface_aggregate_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row5.history_datetime);
							vm_interface_aggregate_tmp.vm_interface_id = row5.vm_interface_id;
							vm_interface_aggregate_tmp.receive_rate_percent = row5.receive_rate_percent;
							vm_interface_aggregate_tmp.transmit_rate_percent = row5.transmit_rate_percent;
							vm_interface_aggregate_tmp.vm_interface_configuration_version = row5.vm_interface_configuration_version;
							vm_interface_aggregate_tmp.received_total_byte = row5.received_total_byte;
							vm_interface_aggregate_tmp.transmitted_total_byte = row5.transmitted_total_byte;
							vm_interface_aggregate = vm_interface_aggregate_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_5 = false;

						tos_count_tMap_5++;

						/**
						 * [tMap_5 main ] stop
						 */
						// Start of branch "vm_interface_aggregate"
						if (vm_interface_aggregate != null) {

							/**
							 * [tAggregateRow_5_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_5";

							currentComponent = "tAggregateRow_5_AGGOUT";

							operation_finder_tAggregateRow_5.history_datetime = vm_interface_aggregate.history_datetime;
							operation_finder_tAggregateRow_5.vm_interface_id = vm_interface_aggregate.vm_interface_id;

							operation_finder_tAggregateRow_5.hashCodeDirty = true;

							operation_result_tAggregateRow_5 = hash_tAggregateRow_5
									.get(operation_finder_tAggregateRow_5);

							boolean isFirstAdd_tAggregateRow_5 = false;

							if (operation_result_tAggregateRow_5 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_5 = new AggOperationStruct_tAggregateRow_5();

								operation_result_tAggregateRow_5.history_datetime = operation_finder_tAggregateRow_5.history_datetime;
								operation_result_tAggregateRow_5.vm_interface_id = operation_finder_tAggregateRow_5.vm_interface_id;

								isFirstAdd_tAggregateRow_5 = true;

								hash_tAggregateRow_5.put(
										operation_result_tAggregateRow_5,
										operation_result_tAggregateRow_5);

							} // G_OutMain_AggR_001

							if (vm_interface_aggregate.receive_rate_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_5.receive_rate_percent_count++;

								if (operation_result_tAggregateRow_5.receive_rate_percent_sum == null) {
									operation_result_tAggregateRow_5.receive_rate_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_5.receive_rate_percent_sum = (double) (operation_result_tAggregateRow_5.receive_rate_percent_sum
										.doubleValue() + vm_interface_aggregate.receive_rate_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (vm_interface_aggregate.receive_rate_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_5.max_receive_rate_percent_max == null
										|| vm_interface_aggregate.receive_rate_percent > operation_result_tAggregateRow_5.max_receive_rate_percent_max

								) {
									operation_result_tAggregateRow_5.max_receive_rate_percent_max = vm_interface_aggregate.receive_rate_percent;
								}

							} // G_OutMain_AggR_546

							if (vm_interface_aggregate.transmit_rate_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_5.transmit_rate_percent_count++;

								if (operation_result_tAggregateRow_5.transmit_rate_percent_sum == null) {
									operation_result_tAggregateRow_5.transmit_rate_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_5.transmit_rate_percent_sum = (double) (operation_result_tAggregateRow_5.transmit_rate_percent_sum
										.doubleValue() + vm_interface_aggregate.transmit_rate_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (vm_interface_aggregate.transmit_rate_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_5.max_transmit_rate_percent_max == null
										|| vm_interface_aggregate.transmit_rate_percent > operation_result_tAggregateRow_5.max_transmit_rate_percent_max

								) {
									operation_result_tAggregateRow_5.max_transmit_rate_percent_max = vm_interface_aggregate.transmit_rate_percent;
								}

							} // G_OutMain_AggR_546

							if (vm_interface_aggregate.vm_interface_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_5.vm_interface_configuration_version_last = vm_interface_aggregate.vm_interface_configuration_version;

							} // G_OutMain_AggR_546

							if (vm_interface_aggregate.received_total_byte != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_5.received_total_byte_last = vm_interface_aggregate.received_total_byte;

							} // G_OutMain_AggR_546

							if (vm_interface_aggregate.transmitted_total_byte != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_5.transmitted_total_byte_last = vm_interface_aggregate.transmitted_total_byte;

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_5_AGGOUT++;

							/**
							 * [tAggregateRow_5_AGGOUT main ] stop
							 */

						} // End of branch "vm_interface_aggregate"

						/**
						 * [tJDBCInput_5 end ] start
						 */

						currentComponent = "tJDBCInput_5";

					}
				} finally {
					if (rs_tJDBCInput_5 != null) {
						rs_tJDBCInput_5.close();
					}
					stmt_tJDBCInput_5.close();

				}
				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tMap_5 end ] start
				 */

				currentComponent = "tMap_5";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_5", true);
				end_Hash.put("tMap_5", System.currentTimeMillis());

				/**
				 * [tMap_5 end ] stop
				 */

				/**
				 * [tAggregateRow_5_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_5";

				currentComponent = "tAggregateRow_5_AGGOUT";

				ok_Hash.put("tAggregateRow_5_AGGOUT", true);
				end_Hash.put("tAggregateRow_5_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_5_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_5 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_5", false);
				start_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_5";

				int tos_count_tJDBCOutput_5 = 0;

				int nb_line_tJDBCOutput_5 = 0;
				int nb_line_update_tJDBCOutput_5 = 0;
				int nb_line_inserted_tJDBCOutput_5 = 0;
				int nb_line_deleted_tJDBCOutput_5 = 0;
				int nb_line_rejected_tJDBCOutput_5 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_5 = 0;

				int deletedCount_tJDBCOutput_5 = 0;
				int updatedCount_tJDBCOutput_5 = 0;
				int insertedCount_tJDBCOutput_5 = 0;
				int rejectedCount_tJDBCOutput_5 = 0;

				boolean whetherReject_tJDBCOutput_5 = false;

				java.sql.Connection connection_tJDBCOutput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_5 = "INSERT INTO "
						+ "vm_interface_daily_history"
						+ " (history_datetime,vm_interface_id,receive_rate_percent,max_receive_rate_percent,transmit_rate_percent,max_transmit_rate_percent,vm_interface_configuration_version,received_total_byte,transmitted_total_byte) VALUES (?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_5 = connection_tJDBCOutput_5
						.prepareStatement(insert_tJDBCOutput_5);

				/**
				 * [tJDBCOutput_5 begin ] stop
				 */

				/**
				 * [tAggregateRow_5_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_5_AGGIN", false);
				start_Hash.put("tAggregateRow_5_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_5";

				currentComponent = "tAggregateRow_5_AGGIN";

				int tos_count_tAggregateRow_5_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_5> values_tAggregateRow_5 = hash_tAggregateRow_5
						.values();

				globalMap.put("tAggregateRow_5_NB_LINE",
						values_tAggregateRow_5.size());

				for (AggOperationStruct_tAggregateRow_5 aggregated_row_tAggregateRow_5 : values_tAggregateRow_5) { // G_AggR_600

					/**
					 * [tAggregateRow_5_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_5_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_5";

					currentComponent = "tAggregateRow_5_AGGIN";

					row10.history_datetime = aggregated_row_tAggregateRow_5.history_datetime;

					row10.vm_interface_id = aggregated_row_tAggregateRow_5.vm_interface_id;

					if (aggregated_row_tAggregateRow_5.receive_rate_percent_count > 0) {

						double row10_receive_rate_percent_temp = (double) aggregated_row_tAggregateRow_5.receive_rate_percent_sum
								/ (double) aggregated_row_tAggregateRow_5.receive_rate_percent_count;

						row10.receive_rate_percent = (short) row10_receive_rate_percent_temp;

					} else {
						String count = "0";

						row10.receive_rate_percent = ParserUtils
								.parseTo_Short(count);

					}
					row10.max_receive_rate_percent = aggregated_row_tAggregateRow_5.max_receive_rate_percent_max;
					if (aggregated_row_tAggregateRow_5.transmit_rate_percent_count > 0) {

						double row10_transmit_rate_percent_temp = (double) aggregated_row_tAggregateRow_5.transmit_rate_percent_sum
								/ (double) aggregated_row_tAggregateRow_5.transmit_rate_percent_count;

						row10.transmit_rate_percent = (short) row10_transmit_rate_percent_temp;

					} else {
						String count = "0";

						row10.transmit_rate_percent = ParserUtils
								.parseTo_Short(count);

					}
					row10.max_transmit_rate_percent = aggregated_row_tAggregateRow_5.max_transmit_rate_percent_max;
					row10.vm_interface_configuration_version = aggregated_row_tAggregateRow_5.vm_interface_configuration_version_last;
					row10.received_total_byte = aggregated_row_tAggregateRow_5.received_total_byte_last;
					row10.transmitted_total_byte = aggregated_row_tAggregateRow_5.transmitted_total_byte_last;

					tos_count_tAggregateRow_5_AGGIN++;

					/**
					 * [tAggregateRow_5_AGGIN main ] stop
					 */

					/**
					 * [tJDBCOutput_5 main ] start
					 */

					currentComponent = "tJDBCOutput_5";

					whetherReject_tJDBCOutput_5 = false;
					if (row10.history_datetime != null) {
						pstmt_tJDBCOutput_5.setTimestamp(
								1,
								new java.sql.Timestamp(row10.history_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_5.setNull(1, java.sql.Types.DATE);
					}

					if (row10.vm_interface_id == null) {
						pstmt_tJDBCOutput_5.setNull(2, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_5.setObject(2, row10.vm_interface_id);
					}

					if (row10.receive_rate_percent == null) {
						pstmt_tJDBCOutput_5.setNull(3, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_5.setShort(3,
								row10.receive_rate_percent);
					}

					if (row10.max_receive_rate_percent == null) {
						pstmt_tJDBCOutput_5.setNull(4, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_5.setShort(4,
								row10.max_receive_rate_percent);
					}

					if (row10.transmit_rate_percent == null) {
						pstmt_tJDBCOutput_5.setNull(5, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_5.setShort(5,
								row10.transmit_rate_percent);
					}

					if (row10.max_transmit_rate_percent == null) {
						pstmt_tJDBCOutput_5.setNull(6, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_5.setShort(6,
								row10.max_transmit_rate_percent);
					}

					if (row10.vm_interface_configuration_version == null) {
						pstmt_tJDBCOutput_5.setNull(7, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_5.setInt(7,
								row10.vm_interface_configuration_version);
					}

					if (row10.received_total_byte == null) {
						pstmt_tJDBCOutput_5.setNull(8, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_5.setLong(8,
								row10.received_total_byte);
					}

					if (row10.transmitted_total_byte == null) {
						pstmt_tJDBCOutput_5.setNull(9, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_5.setLong(9,
								row10.transmitted_total_byte);
					}

					try {
						insertedCount_tJDBCOutput_5 = insertedCount_tJDBCOutput_5
								+ pstmt_tJDBCOutput_5.executeUpdate();
						nb_line_tJDBCOutput_5++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_5 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_5++;

					/**
					 * [tJDBCOutput_5 main ] stop
					 */

					/**
					 * [tAggregateRow_5_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_5";

					currentComponent = "tAggregateRow_5_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_5_AGGIN", true);
				end_Hash.put("tAggregateRow_5_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_5_AGGIN end ] stop
				 */

				/**
				 * [tJDBCOutput_5 end ] start
				 */

				currentComponent = "tJDBCOutput_5";

				if (pstmt_tJDBCOutput_5 != null) {

					pstmt_tJDBCOutput_5.close();

				}

				nb_line_deleted_tJDBCOutput_5 = nb_line_deleted_tJDBCOutput_5
						+ deletedCount_tJDBCOutput_5;
				nb_line_update_tJDBCOutput_5 = nb_line_update_tJDBCOutput_5
						+ updatedCount_tJDBCOutput_5;
				nb_line_inserted_tJDBCOutput_5 = nb_line_inserted_tJDBCOutput_5
						+ insertedCount_tJDBCOutput_5;
				nb_line_rejected_tJDBCOutput_5 = nb_line_rejected_tJDBCOutput_5
						+ rejectedCount_tJDBCOutput_5;

				globalMap.put("tJDBCOutput_5_NB_LINE", nb_line_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_5);

				ok_Hash.put("tJDBCOutput_5", true);
				end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_5 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_5_AGGIN"
			globalMap.remove("tAggregateRow_5");

			try {

				/**
				 * [tJDBCInput_5 finally ] start
				 */

				currentComponent = "tJDBCInput_5";

				/**
				 * [tJDBCInput_5 finally ] stop
				 */

				/**
				 * [tMap_5 finally ] start
				 */

				currentComponent = "tMap_5";

				/**
				 * [tMap_5 finally ] stop
				 */

				/**
				 * [tAggregateRow_5_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_5";

				currentComponent = "tAggregateRow_5_AGGOUT";

				/**
				 * [tAggregateRow_5_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_5_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_5";

				currentComponent = "tAggregateRow_5_AGGIN";

				/**
				 * [tAggregateRow_5_AGGIN finally ] stop
				 */

				/**
				 * [tJDBCOutput_5 finally ] start
				 */

				currentComponent = "tJDBCOutput_5";

				/**
				 * [tJDBCOutput_5 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class row17Struct implements
			routines.system.IPersistableRow<row17Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public short storage_domain_status;

		public short getStorage_domain_status() {
			return this.storage_domain_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Integer available_disk_size_gb;

		public Integer getAvailable_disk_size_gb() {
			return this.available_disk_size_gb;
		}

		public Integer used_disk_size_gb;

		public Integer getUsed_disk_size_gb() {
			return this.used_disk_size_gb;
		}

		public Integer storage_configuration_version;

		public Integer getStorage_configuration_version() {
			return this.storage_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					this.available_disk_size_gb = readInteger(dis);

					this.used_disk_size_gb = readInteger(dis);

					this.storage_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// short

				dos.writeShort(this.storage_domain_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Integer

				writeInteger(this.available_disk_size_gb, dos);

				// Integer

				writeInteger(this.used_disk_size_gb, dos);

				// Integer

				writeInteger(this.storage_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_status="
					+ String.valueOf(storage_domain_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",available_disk_size_gb="
					+ String.valueOf(available_disk_size_gb));
			sb.append(",used_disk_size_gb=" + String.valueOf(used_disk_size_gb));
			sb.append(",storage_configuration_version="
					+ String.valueOf(storage_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row17Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_6 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_6> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public short storage_domain_status;

		public short getStorage_domain_status() {
			return this.storage_domain_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Integer available_disk_size_gb;

		public Integer getAvailable_disk_size_gb() {
			return this.available_disk_size_gb;
		}

		public Integer used_disk_size_gb;

		public Integer getUsed_disk_size_gb() {
			return this.used_disk_size_gb;
		}

		public Integer storage_configuration_version;

		public Integer getStorage_configuration_version() {
			return this.storage_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					this.available_disk_size_gb = readInteger(dis);

					this.used_disk_size_gb = readInteger(dis);

					this.storage_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// short

				dos.writeShort(this.storage_domain_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Integer

				writeInteger(this.available_disk_size_gb, dos);

				// Integer

				writeInteger(this.used_disk_size_gb, dos);

				// Integer

				writeInteger(this.storage_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_status="
					+ String.valueOf(storage_domain_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",available_disk_size_gb="
					+ String.valueOf(available_disk_size_gb));
			sb.append(",used_disk_size_gb=" + String.valueOf(used_disk_size_gb));
			sb.append(",storage_configuration_version="
					+ String.valueOf(storage_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_6 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class storage_aggregateStruct implements
			routines.system.IPersistableRow<storage_aggregateStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public short storage_domain_status;

		public short getStorage_domain_status() {
			return this.storage_domain_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Integer available_disk_size_gb;

		public Integer getAvailable_disk_size_gb() {
			return this.available_disk_size_gb;
		}

		public Integer used_disk_size_gb;

		public Integer getUsed_disk_size_gb() {
			return this.used_disk_size_gb;
		}

		public Integer storage_configuration_version;

		public Integer getStorage_configuration_version() {
			return this.storage_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					this.available_disk_size_gb = readInteger(dis);

					this.used_disk_size_gb = readInteger(dis);

					this.storage_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// short

				dos.writeShort(this.storage_domain_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Integer

				writeInteger(this.available_disk_size_gb, dos);

				// Integer

				writeInteger(this.used_disk_size_gb, dos);

				// Integer

				writeInteger(this.storage_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_status="
					+ String.valueOf(storage_domain_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",available_disk_size_gb="
					+ String.valueOf(available_disk_size_gb));
			sb.append(",used_disk_size_gb=" + String.valueOf(used_disk_size_gb));
			sb.append(",storage_configuration_version="
					+ String.valueOf(storage_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(storage_aggregateStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row16Struct implements
			routines.system.IPersistableRow<row16Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public short storage_domain_status;

		public short getStorage_domain_status() {
			return this.storage_domain_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public Integer available_disk_size_gb;

		public Integer getAvailable_disk_size_gb() {
			return this.available_disk_size_gb;
		}

		public Integer used_disk_size_gb;

		public Integer getUsed_disk_size_gb() {
			return this.used_disk_size_gb;
		}

		public Integer storage_configuration_version;

		public Integer getStorage_configuration_version() {
			return this.storage_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

					this.history_datetime = readDate(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_status = dis.readShort();

					this.minutes_in_status = dis.readDouble();

					this.available_disk_size_gb = readInteger(dis);

					this.used_disk_size_gb = readInteger(dis);

					this.storage_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// short

				dos.writeShort(this.storage_domain_status);

				// double

				dos.writeDouble(this.minutes_in_status);

				// Integer

				writeInteger(this.available_disk_size_gb, dos);

				// Integer

				writeInteger(this.used_disk_size_gb, dos);

				// Integer

				writeInteger(this.storage_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",history_datetime=" + String.valueOf(history_datetime));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_status="
					+ String.valueOf(storage_domain_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",available_disk_size_gb="
					+ String.valueOf(available_disk_size_gb));
			sb.append(",used_disk_size_gb=" + String.valueOf(used_disk_size_gb));
			sb.append(",storage_configuration_version="
					+ String.valueOf(storage_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row16Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_11Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row16Struct row16 = new row16Struct();
				storage_aggregateStruct storage_aggregate = new storage_aggregateStruct();
				row17Struct row17 = new row17Struct();

				/**
				 * [tAggregateRow_6_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_6_AGGOUT", false);
				start_Hash.put("tAggregateRow_6_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_6";

				currentComponent = "tAggregateRow_6_AGGOUT";

				int tos_count_tAggregateRow_6_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_6 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_6 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_6 utilClass_tAggregateRow_6 = new UtilClass_tAggregateRow_6();

				class AggOperationStruct_tAggregateRow_6 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object storage_domain_id;
					short storage_domain_status;
					BigDecimal minutes_in_status_sum;

					Integer available_disk_size_gb_max;
					Integer used_disk_size_gb_max;
					Integer storage_configuration_version_last;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.storage_domain_id == null) ? 0
											: this.storage_domain_id.hashCode());

							result = prime * result
									+ (int) this.storage_domain_status;

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_6 other = (AggOperationStruct_tAggregateRow_6) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.storage_domain_id == null) {
							if (other.storage_domain_id != null)
								return false;
						} else if (!this.storage_domain_id
								.equals(other.storage_domain_id))
							return false;

						if (this.storage_domain_status != other.storage_domain_status)
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_6 operation_result_tAggregateRow_6 = null;
				AggOperationStruct_tAggregateRow_6 operation_finder_tAggregateRow_6 = new AggOperationStruct_tAggregateRow_6();
				java.util.Map<AggOperationStruct_tAggregateRow_6, AggOperationStruct_tAggregateRow_6> hash_tAggregateRow_6 = new java.util.HashMap<AggOperationStruct_tAggregateRow_6, AggOperationStruct_tAggregateRow_6>();

				/**
				 * [tAggregateRow_6_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_11 begin ] start
				 */

				ok_Hash.put("tMap_11", false);
				start_Hash.put("tMap_11", System.currentTimeMillis());

				currentComponent = "tMap_11";

				int tos_count_tMap_11 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_11__Struct {
				}
				Var__tMap_11__Struct Var__tMap_11 = new Var__tMap_11__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				storage_aggregateStruct storage_aggregate_tmp = new storage_aggregateStruct();
				// ###############################

				/**
				 * [tMap_11 begin ] stop
				 */

				/**
				 * [tJDBCInput_11 begin ] start
				 */

				ok_Hash.put("tJDBCInput_11", false);
				start_Hash.put("tJDBCInput_11", System.currentTimeMillis());

				currentComponent = "tJDBCInput_11";

				int tos_count_tJDBCInput_11 = 0;

				int nb_line_tJDBCInput_11 = 0;
				java.sql.Connection conn_tJDBCInput_11 = null;
				conn_tJDBCInput_11 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_11 = conn_tJDBCInput_11
						.createStatement();

				String dbquery_tJDBCInput_11 = "SELECT \n  history_id, \n  history_datetime, \n  storage_domain_id, \n  storage_domain_status,\n  minutes_in_status,\n  available_disk_size_gb, \n  used_disk_size_gb, \n  storage_configuration_version\nFROM storage_domain_hourly_history\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\nAND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY history_datetime,\n      	 storage_domain_id";

				globalMap.put("tJDBCInput_11_QUERY", dbquery_tJDBCInput_11);

				java.sql.ResultSet rs_tJDBCInput_11 = null;
				try {
					rs_tJDBCInput_11 = stmt_tJDBCInput_11
							.executeQuery(dbquery_tJDBCInput_11);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_11 = rs_tJDBCInput_11
							.getMetaData();
					int colQtyInRs_tJDBCInput_11 = rsmd_tJDBCInput_11
							.getColumnCount();

					String tmpContent_tJDBCInput_11 = null;

					while (rs_tJDBCInput_11.next()) {
						nb_line_tJDBCInput_11++;

						if (colQtyInRs_tJDBCInput_11 < 1) {
							row16.history_id = 0;
						} else {

							if (rs_tJDBCInput_11.getObject(1) != null) {
								row16.history_id = rs_tJDBCInput_11.getLong(1);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 2) {
							row16.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_11 = null;
							try {
								date_tJDBCInput_11 = rs_tJDBCInput_11
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_11 = rs_tJDBCInput_11
										.getDate(2);
							}
							row16.history_datetime = date_tJDBCInput_11;
						}
						if (colQtyInRs_tJDBCInput_11 < 3) {
							row16.storage_domain_id = null;
						} else {

							if (rs_tJDBCInput_11.getObject(3) != null) {
								row16.storage_domain_id = rs_tJDBCInput_11
										.getObject(3);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 4) {
							row16.storage_domain_status = 0;
						} else {

							if (rs_tJDBCInput_11.getObject(4) != null) {
								row16.storage_domain_status = rs_tJDBCInput_11
										.getShort(4);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 5) {
							row16.minutes_in_status = 0;
						} else {

							if (rs_tJDBCInput_11.getObject(5) != null) {
								row16.minutes_in_status = rs_tJDBCInput_11
										.getDouble(5);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 6) {
							row16.available_disk_size_gb = null;
						} else {

							if (rs_tJDBCInput_11.getObject(6) != null) {
								row16.available_disk_size_gb = rs_tJDBCInput_11
										.getInt(6);
							} else {
								row16.available_disk_size_gb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 7) {
							row16.used_disk_size_gb = null;
						} else {

							if (rs_tJDBCInput_11.getObject(7) != null) {
								row16.used_disk_size_gb = rs_tJDBCInput_11
										.getInt(7);
							} else {
								row16.used_disk_size_gb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 8) {
							row16.storage_configuration_version = null;
						} else {

							if (rs_tJDBCInput_11.getObject(8) != null) {
								row16.storage_configuration_version = rs_tJDBCInput_11
										.getInt(8);
							} else {
								row16.storage_configuration_version = null;
							}
						}

						/**
						 * [tJDBCInput_11 begin ] stop
						 */

						/**
						 * [tJDBCInput_11 main ] start
						 */

						currentComponent = "tJDBCInput_11";

						tos_count_tJDBCInput_11++;

						/**
						 * [tJDBCInput_11 main ] stop
						 */

						/**
						 * [tMap_11 main ] start
						 */

						currentComponent = "tMap_11";

						boolean hasCasePrimitiveKeyWithNull_tMap_11 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_11 = false;
						boolean mainRowRejected_tMap_11 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_11__Struct Var = Var__tMap_11;// ###############################
							// ###############################
							// # Output tables

							storage_aggregate = null;

							// # Output table : 'storage_aggregate'
							storage_aggregate_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row16.history_datetime);
							storage_aggregate_tmp.storage_domain_id = row16.storage_domain_id;
							storage_aggregate_tmp.storage_domain_status = row16.storage_domain_status;
							storage_aggregate_tmp.minutes_in_status = row16.minutes_in_status;
							storage_aggregate_tmp.available_disk_size_gb = row16.available_disk_size_gb;
							storage_aggregate_tmp.used_disk_size_gb = row16.used_disk_size_gb;
							storage_aggregate_tmp.storage_configuration_version = row16.storage_configuration_version;
							storage_aggregate = storage_aggregate_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_11 = false;

						tos_count_tMap_11++;

						/**
						 * [tMap_11 main ] stop
						 */
						// Start of branch "storage_aggregate"
						if (storage_aggregate != null) {

							/**
							 * [tAggregateRow_6_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_6";

							currentComponent = "tAggregateRow_6_AGGOUT";

							operation_finder_tAggregateRow_6.history_datetime = storage_aggregate.history_datetime;
							operation_finder_tAggregateRow_6.storage_domain_id = storage_aggregate.storage_domain_id;
							operation_finder_tAggregateRow_6.storage_domain_status = storage_aggregate.storage_domain_status;

							operation_finder_tAggregateRow_6.hashCodeDirty = true;

							operation_result_tAggregateRow_6 = hash_tAggregateRow_6
									.get(operation_finder_tAggregateRow_6);

							boolean isFirstAdd_tAggregateRow_6 = false;

							if (operation_result_tAggregateRow_6 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_6 = new AggOperationStruct_tAggregateRow_6();

								operation_result_tAggregateRow_6.history_datetime = operation_finder_tAggregateRow_6.history_datetime;
								operation_result_tAggregateRow_6.storage_domain_id = operation_finder_tAggregateRow_6.storage_domain_id;
								operation_result_tAggregateRow_6.storage_domain_status = operation_finder_tAggregateRow_6.storage_domain_status;

								isFirstAdd_tAggregateRow_6 = true;

								hash_tAggregateRow_6.put(
										operation_result_tAggregateRow_6,
										operation_result_tAggregateRow_6);

							} // G_OutMain_AggR_001

							if (operation_result_tAggregateRow_6.minutes_in_status_sum == null) {
								operation_result_tAggregateRow_6.minutes_in_status_sum = new BigDecimal(
										0).setScale(0);
							}
							operation_result_tAggregateRow_6.minutes_in_status_sum = operation_result_tAggregateRow_6.minutes_in_status_sum
									.add(new BigDecimal(
											String.valueOf(storage_aggregate.minutes_in_status)));

							if (storage_aggregate.available_disk_size_gb != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_6.available_disk_size_gb_max == null
										|| storage_aggregate.available_disk_size_gb > operation_result_tAggregateRow_6.available_disk_size_gb_max

								) {
									operation_result_tAggregateRow_6.available_disk_size_gb_max = storage_aggregate.available_disk_size_gb;
								}

							} // G_OutMain_AggR_546

							if (storage_aggregate.used_disk_size_gb != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_6.used_disk_size_gb_max == null
										|| storage_aggregate.used_disk_size_gb > operation_result_tAggregateRow_6.used_disk_size_gb_max

								) {
									operation_result_tAggregateRow_6.used_disk_size_gb_max = storage_aggregate.used_disk_size_gb;
								}

							} // G_OutMain_AggR_546

							if (storage_aggregate.storage_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_6.storage_configuration_version_last = storage_aggregate.storage_configuration_version;

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_6_AGGOUT++;

							/**
							 * [tAggregateRow_6_AGGOUT main ] stop
							 */

						} // End of branch "storage_aggregate"

						/**
						 * [tJDBCInput_11 end ] start
						 */

						currentComponent = "tJDBCInput_11";

					}
				} finally {
					if (rs_tJDBCInput_11 != null) {
						rs_tJDBCInput_11.close();
					}
					stmt_tJDBCInput_11.close();

				}
				globalMap.put("tJDBCInput_11_NB_LINE", nb_line_tJDBCInput_11);

				ok_Hash.put("tJDBCInput_11", true);
				end_Hash.put("tJDBCInput_11", System.currentTimeMillis());

				/**
				 * [tJDBCInput_11 end ] stop
				 */

				/**
				 * [tMap_11 end ] start
				 */

				currentComponent = "tMap_11";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_11", true);
				end_Hash.put("tMap_11", System.currentTimeMillis());

				/**
				 * [tMap_11 end ] stop
				 */

				/**
				 * [tAggregateRow_6_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_6";

				currentComponent = "tAggregateRow_6_AGGOUT";

				ok_Hash.put("tAggregateRow_6_AGGOUT", true);
				end_Hash.put("tAggregateRow_6_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_6_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_11 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_11", false);
				start_Hash.put("tJDBCOutput_11", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_11";

				int tos_count_tJDBCOutput_11 = 0;

				int nb_line_tJDBCOutput_11 = 0;
				int nb_line_update_tJDBCOutput_11 = 0;
				int nb_line_inserted_tJDBCOutput_11 = 0;
				int nb_line_deleted_tJDBCOutput_11 = 0;
				int nb_line_rejected_tJDBCOutput_11 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_11 = 0;

				int deletedCount_tJDBCOutput_11 = 0;
				int updatedCount_tJDBCOutput_11 = 0;
				int insertedCount_tJDBCOutput_11 = 0;
				int rejectedCount_tJDBCOutput_11 = 0;

				boolean whetherReject_tJDBCOutput_11 = false;

				java.sql.Connection connection_tJDBCOutput_11 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_11 = "INSERT INTO "
						+ "storage_domain_daily_history"
						+ " (history_datetime,storage_domain_id,storage_domain_status,minutes_in_status,available_disk_size_gb,used_disk_size_gb,storage_configuration_version) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_11 = connection_tJDBCOutput_11
						.prepareStatement(insert_tJDBCOutput_11);

				/**
				 * [tJDBCOutput_11 begin ] stop
				 */

				/**
				 * [tAggregateRow_6_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_6_AGGIN", false);
				start_Hash.put("tAggregateRow_6_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_6";

				currentComponent = "tAggregateRow_6_AGGIN";

				int tos_count_tAggregateRow_6_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_6> values_tAggregateRow_6 = hash_tAggregateRow_6
						.values();

				globalMap.put("tAggregateRow_6_NB_LINE",
						values_tAggregateRow_6.size());

				for (AggOperationStruct_tAggregateRow_6 aggregated_row_tAggregateRow_6 : values_tAggregateRow_6) { // G_AggR_600

					/**
					 * [tAggregateRow_6_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_6_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_6";

					currentComponent = "tAggregateRow_6_AGGIN";

					row17.history_datetime = aggregated_row_tAggregateRow_6.history_datetime;

					row17.storage_domain_id = aggregated_row_tAggregateRow_6.storage_domain_id;

					row17.storage_domain_status = aggregated_row_tAggregateRow_6.storage_domain_status;

					if (aggregated_row_tAggregateRow_6.minutes_in_status_sum != null) {
						row17.minutes_in_status = aggregated_row_tAggregateRow_6.minutes_in_status_sum
								.doubleValue();

					} else {

						row17.minutes_in_status = 0;

					}

					row17.available_disk_size_gb = aggregated_row_tAggregateRow_6.available_disk_size_gb_max;
					row17.used_disk_size_gb = aggregated_row_tAggregateRow_6.used_disk_size_gb_max;
					row17.storage_configuration_version = aggregated_row_tAggregateRow_6.storage_configuration_version_last;

					tos_count_tAggregateRow_6_AGGIN++;

					/**
					 * [tAggregateRow_6_AGGIN main ] stop
					 */

					/**
					 * [tJDBCOutput_11 main ] start
					 */

					currentComponent = "tJDBCOutput_11";

					whetherReject_tJDBCOutput_11 = false;
					if (row17.history_datetime != null) {
						pstmt_tJDBCOutput_11.setTimestamp(
								1,
								new java.sql.Timestamp(row17.history_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_11.setNull(1, java.sql.Types.DATE);
					}

					if (row17.storage_domain_id == null) {
						pstmt_tJDBCOutput_11.setNull(2, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_11.setObject(2,
								row17.storage_domain_id);
					}

					pstmt_tJDBCOutput_11.setShort(3,
							row17.storage_domain_status);

					pstmt_tJDBCOutput_11.setDouble(4, row17.minutes_in_status);

					if (row17.available_disk_size_gb == null) {
						pstmt_tJDBCOutput_11.setNull(5, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_11.setInt(5,
								row17.available_disk_size_gb);
					}

					if (row17.used_disk_size_gb == null) {
						pstmt_tJDBCOutput_11.setNull(6, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_11.setInt(6, row17.used_disk_size_gb);
					}

					if (row17.storage_configuration_version == null) {
						pstmt_tJDBCOutput_11.setNull(7, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_11.setInt(7,
								row17.storage_configuration_version);
					}

					try {
						insertedCount_tJDBCOutput_11 = insertedCount_tJDBCOutput_11
								+ pstmt_tJDBCOutput_11.executeUpdate();
						nb_line_tJDBCOutput_11++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_11 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_11++;

					/**
					 * [tJDBCOutput_11 main ] stop
					 */

					/**
					 * [tAggregateRow_6_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_6";

					currentComponent = "tAggregateRow_6_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_6_AGGIN", true);
				end_Hash.put("tAggregateRow_6_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_6_AGGIN end ] stop
				 */

				/**
				 * [tJDBCOutput_11 end ] start
				 */

				currentComponent = "tJDBCOutput_11";

				if (pstmt_tJDBCOutput_11 != null) {

					pstmt_tJDBCOutput_11.close();

				}

				nb_line_deleted_tJDBCOutput_11 = nb_line_deleted_tJDBCOutput_11
						+ deletedCount_tJDBCOutput_11;
				nb_line_update_tJDBCOutput_11 = nb_line_update_tJDBCOutput_11
						+ updatedCount_tJDBCOutput_11;
				nb_line_inserted_tJDBCOutput_11 = nb_line_inserted_tJDBCOutput_11
						+ insertedCount_tJDBCOutput_11;
				nb_line_rejected_tJDBCOutput_11 = nb_line_rejected_tJDBCOutput_11
						+ rejectedCount_tJDBCOutput_11;

				globalMap.put("tJDBCOutput_11_NB_LINE", nb_line_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_11);

				ok_Hash.put("tJDBCOutput_11", true);
				end_Hash.put("tJDBCOutput_11", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_11 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_6_AGGIN"
			globalMap.remove("tAggregateRow_6");

			try {

				/**
				 * [tJDBCInput_11 finally ] start
				 */

				currentComponent = "tJDBCInput_11";

				/**
				 * [tJDBCInput_11 finally ] stop
				 */

				/**
				 * [tMap_11 finally ] start
				 */

				currentComponent = "tMap_11";

				/**
				 * [tMap_11 finally ] stop
				 */

				/**
				 * [tAggregateRow_6_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_6";

				currentComponent = "tAggregateRow_6_AGGOUT";

				/**
				 * [tAggregateRow_6_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_6_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_6";

				currentComponent = "tAggregateRow_6_AGGIN";

				/**
				 * [tAggregateRow_6_AGGIN finally ] stop
				 */

				/**
				 * [tJDBCOutput_11 finally ] start
				 */

				currentComponent = "tJDBCOutput_11";

				/**
				 * [tJDBCOutput_11 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", 1);
	}

	public static class row20Struct implements
			routines.system.IPersistableRow<row20Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Short vm_disk_status;

		public Short getVm_disk_status() {
			return this.vm_disk_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public int vm_disk_actual_size_mb;

		public int getVm_disk_actual_size_mb() {
			return this.vm_disk_actual_size_mb;
		}

		public Long read_rate_bytes_per_second;

		public Long getRead_rate_bytes_per_second() {
			return this.read_rate_bytes_per_second;
		}

		public Long max_read_rate_bytes_per_second;

		public Long getMax_read_rate_bytes_per_second() {
			return this.max_read_rate_bytes_per_second;
		}

		public Double read_latency_seconds;

		public Double getRead_latency_seconds() {
			return this.read_latency_seconds;
		}

		public Double max_read_latency_seconds;

		public Double getMax_read_latency_seconds() {
			return this.max_read_latency_seconds;
		}

		public Long write_rate_bytes_per_second;

		public Long getWrite_rate_bytes_per_second() {
			return this.write_rate_bytes_per_second;
		}

		public Long max_write_rate_bytes_per_second;

		public Long getMax_write_rate_bytes_per_second() {
			return this.max_write_rate_bytes_per_second;
		}

		public Double write_latency_seconds;

		public Double getWrite_latency_seconds() {
			return this.write_latency_seconds;
		}

		public Double max_write_latency_seconds;

		public Double getMax_write_latency_seconds() {
			return this.max_write_latency_seconds;
		}

		public Double flush_latency_seconds;

		public Double getFlush_latency_seconds() {
			return this.flush_latency_seconds;
		}

		public Double max_flush_latency_seconds;

		public Double getMax_flush_latency_seconds() {
			return this.max_flush_latency_seconds;
		}

		public Integer vm_disk_configuration_version;

		public Integer getVm_disk_configuration_version() {
			return this.vm_disk_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.image_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_status = null;
					} else {
						this.vm_disk_status = dis.readShort();
					}

					this.minutes_in_status = dis.readDouble();

					this.vm_disk_actual_size_mb = dis.readInt();

					length = dis.readByte();
					if (length == -1) {
						this.read_rate_bytes_per_second = null;
					} else {
						this.read_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_read_rate_bytes_per_second = null;
					} else {
						this.max_read_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.read_latency_seconds = null;
					} else {
						this.read_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_read_latency_seconds = null;
					} else {
						this.max_read_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_rate_bytes_per_second = null;
					} else {
						this.write_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_write_rate_bytes_per_second = null;
					} else {
						this.max_write_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_latency_seconds = null;
					} else {
						this.write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_write_latency_seconds = null;
					} else {
						this.max_write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.flush_latency_seconds = null;
					} else {
						this.flush_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_flush_latency_seconds = null;
					} else {
						this.max_flush_latency_seconds = dis.readDouble();
					}

					this.vm_disk_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// Object

				dos.writeObject(this.image_id);

				// Short

				if (this.vm_disk_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_status);
				}

				// double

				dos.writeDouble(this.minutes_in_status);

				// int

				dos.writeInt(this.vm_disk_actual_size_mb);

				// Long

				if (this.read_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.read_rate_bytes_per_second);
				}

				// Long

				if (this.max_read_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_read_rate_bytes_per_second);
				}

				// Double

				if (this.read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.read_latency_seconds);
				}

				// Double

				if (this.max_read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_read_latency_seconds);
				}

				// Long

				if (this.write_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.write_rate_bytes_per_second);
				}

				// Long

				if (this.max_write_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_write_rate_bytes_per_second);
				}

				// Double

				if (this.write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.write_latency_seconds);
				}

				// Double

				if (this.max_write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_write_latency_seconds);
				}

				// Double

				if (this.flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.flush_latency_seconds);
				}

				// Double

				if (this.max_flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_flush_latency_seconds);
				}

				// Integer

				writeInteger(this.vm_disk_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",vm_disk_status=" + String.valueOf(vm_disk_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",vm_disk_actual_size_mb="
					+ String.valueOf(vm_disk_actual_size_mb));
			sb.append(",read_rate_bytes_per_second="
					+ String.valueOf(read_rate_bytes_per_second));
			sb.append(",max_read_rate_bytes_per_second="
					+ String.valueOf(max_read_rate_bytes_per_second));
			sb.append(",read_latency_seconds="
					+ String.valueOf(read_latency_seconds));
			sb.append(",max_read_latency_seconds="
					+ String.valueOf(max_read_latency_seconds));
			sb.append(",write_rate_bytes_per_second="
					+ String.valueOf(write_rate_bytes_per_second));
			sb.append(",max_write_rate_bytes_per_second="
					+ String.valueOf(max_write_rate_bytes_per_second));
			sb.append(",write_latency_seconds="
					+ String.valueOf(write_latency_seconds));
			sb.append(",max_write_latency_seconds="
					+ String.valueOf(max_write_latency_seconds));
			sb.append(",flush_latency_seconds="
					+ String.valueOf(flush_latency_seconds));
			sb.append(",max_flush_latency_seconds="
					+ String.valueOf(max_flush_latency_seconds));
			sb.append(",vm_disk_configuration_version="
					+ String.valueOf(vm_disk_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row20Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_7 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_7> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Short vm_disk_status;

		public Short getVm_disk_status() {
			return this.vm_disk_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public int vm_disk_actual_size_mb;

		public int getVm_disk_actual_size_mb() {
			return this.vm_disk_actual_size_mb;
		}

		public Long read_rate_bytes_per_second;

		public Long getRead_rate_bytes_per_second() {
			return this.read_rate_bytes_per_second;
		}

		public Long max_read_rate_bytes_per_second;

		public Long getMax_read_rate_bytes_per_second() {
			return this.max_read_rate_bytes_per_second;
		}

		public Double read_latency_seconds;

		public Double getRead_latency_seconds() {
			return this.read_latency_seconds;
		}

		public Double max_read_latency_seconds;

		public Double getMax_read_latency_seconds() {
			return this.max_read_latency_seconds;
		}

		public Long write_rate_bytes_per_second;

		public Long getWrite_rate_bytes_per_second() {
			return this.write_rate_bytes_per_second;
		}

		public Long max_write_rate_bytes_per_second;

		public Long getMax_write_rate_bytes_per_second() {
			return this.max_write_rate_bytes_per_second;
		}

		public Double write_latency_seconds;

		public Double getWrite_latency_seconds() {
			return this.write_latency_seconds;
		}

		public Double max_write_latency_seconds;

		public Double getMax_write_latency_seconds() {
			return this.max_write_latency_seconds;
		}

		public Double flush_latency_seconds;

		public Double getFlush_latency_seconds() {
			return this.flush_latency_seconds;
		}

		public Double max_flush_latency_seconds;

		public Double getMax_flush_latency_seconds() {
			return this.max_flush_latency_seconds;
		}

		public Integer vm_disk_configuration_version;

		public Integer getVm_disk_configuration_version() {
			return this.vm_disk_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.image_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_status = null;
					} else {
						this.vm_disk_status = dis.readShort();
					}

					this.minutes_in_status = dis.readDouble();

					this.vm_disk_actual_size_mb = dis.readInt();

					length = dis.readByte();
					if (length == -1) {
						this.read_rate_bytes_per_second = null;
					} else {
						this.read_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_read_rate_bytes_per_second = null;
					} else {
						this.max_read_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.read_latency_seconds = null;
					} else {
						this.read_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_read_latency_seconds = null;
					} else {
						this.max_read_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_rate_bytes_per_second = null;
					} else {
						this.write_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_write_rate_bytes_per_second = null;
					} else {
						this.max_write_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_latency_seconds = null;
					} else {
						this.write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_write_latency_seconds = null;
					} else {
						this.max_write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.flush_latency_seconds = null;
					} else {
						this.flush_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_flush_latency_seconds = null;
					} else {
						this.max_flush_latency_seconds = dis.readDouble();
					}

					this.vm_disk_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// Object

				dos.writeObject(this.image_id);

				// Short

				if (this.vm_disk_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_status);
				}

				// double

				dos.writeDouble(this.minutes_in_status);

				// int

				dos.writeInt(this.vm_disk_actual_size_mb);

				// Long

				if (this.read_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.read_rate_bytes_per_second);
				}

				// Long

				if (this.max_read_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_read_rate_bytes_per_second);
				}

				// Double

				if (this.read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.read_latency_seconds);
				}

				// Double

				if (this.max_read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_read_latency_seconds);
				}

				// Long

				if (this.write_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.write_rate_bytes_per_second);
				}

				// Long

				if (this.max_write_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.max_write_rate_bytes_per_second);
				}

				// Double

				if (this.write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.write_latency_seconds);
				}

				// Double

				if (this.max_write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_write_latency_seconds);
				}

				// Double

				if (this.flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.flush_latency_seconds);
				}

				// Double

				if (this.max_flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.max_flush_latency_seconds);
				}

				// Integer

				writeInteger(this.vm_disk_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",vm_disk_status=" + String.valueOf(vm_disk_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",vm_disk_actual_size_mb="
					+ String.valueOf(vm_disk_actual_size_mb));
			sb.append(",read_rate_bytes_per_second="
					+ String.valueOf(read_rate_bytes_per_second));
			sb.append(",max_read_rate_bytes_per_second="
					+ String.valueOf(max_read_rate_bytes_per_second));
			sb.append(",read_latency_seconds="
					+ String.valueOf(read_latency_seconds));
			sb.append(",max_read_latency_seconds="
					+ String.valueOf(max_read_latency_seconds));
			sb.append(",write_rate_bytes_per_second="
					+ String.valueOf(write_rate_bytes_per_second));
			sb.append(",max_write_rate_bytes_per_second="
					+ String.valueOf(max_write_rate_bytes_per_second));
			sb.append(",write_latency_seconds="
					+ String.valueOf(write_latency_seconds));
			sb.append(",max_write_latency_seconds="
					+ String.valueOf(max_write_latency_seconds));
			sb.append(",flush_latency_seconds="
					+ String.valueOf(flush_latency_seconds));
			sb.append(",max_flush_latency_seconds="
					+ String.valueOf(max_flush_latency_seconds));
			sb.append(",vm_disk_configuration_version="
					+ String.valueOf(vm_disk_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_7 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class vm_disk_aggregateStruct implements
			routines.system.IPersistableRow<vm_disk_aggregateStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Short vm_disk_status;

		public Short getVm_disk_status() {
			return this.vm_disk_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public int vm_disk_actual_size_mb;

		public int getVm_disk_actual_size_mb() {
			return this.vm_disk_actual_size_mb;
		}

		public Long read_rate_bytes_per_second;

		public Long getRead_rate_bytes_per_second() {
			return this.read_rate_bytes_per_second;
		}

		public Double read_latency_seconds;

		public Double getRead_latency_seconds() {
			return this.read_latency_seconds;
		}

		public Long write_rate_bytes_per_second;

		public Long getWrite_rate_bytes_per_second() {
			return this.write_rate_bytes_per_second;
		}

		public Double write_latency_seconds;

		public Double getWrite_latency_seconds() {
			return this.write_latency_seconds;
		}

		public Double flush_latency_seconds;

		public Double getFlush_latency_seconds() {
			return this.flush_latency_seconds;
		}

		public Integer vm_disk_configuration_version;

		public Integer getVm_disk_configuration_version() {
			return this.vm_disk_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.image_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_status = null;
					} else {
						this.vm_disk_status = dis.readShort();
					}

					this.minutes_in_status = dis.readDouble();

					this.vm_disk_actual_size_mb = dis.readInt();

					length = dis.readByte();
					if (length == -1) {
						this.read_rate_bytes_per_second = null;
					} else {
						this.read_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.read_latency_seconds = null;
					} else {
						this.read_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_rate_bytes_per_second = null;
					} else {
						this.write_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_latency_seconds = null;
					} else {
						this.write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.flush_latency_seconds = null;
					} else {
						this.flush_latency_seconds = dis.readDouble();
					}

					this.vm_disk_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// Object

				dos.writeObject(this.image_id);

				// Short

				if (this.vm_disk_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_status);
				}

				// double

				dos.writeDouble(this.minutes_in_status);

				// int

				dos.writeInt(this.vm_disk_actual_size_mb);

				// Long

				if (this.read_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.read_rate_bytes_per_second);
				}

				// Double

				if (this.read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.read_latency_seconds);
				}

				// Long

				if (this.write_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.write_rate_bytes_per_second);
				}

				// Double

				if (this.write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.write_latency_seconds);
				}

				// Double

				if (this.flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.flush_latency_seconds);
				}

				// Integer

				writeInteger(this.vm_disk_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",vm_disk_status=" + String.valueOf(vm_disk_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",vm_disk_actual_size_mb="
					+ String.valueOf(vm_disk_actual_size_mb));
			sb.append(",read_rate_bytes_per_second="
					+ String.valueOf(read_rate_bytes_per_second));
			sb.append(",read_latency_seconds="
					+ String.valueOf(read_latency_seconds));
			sb.append(",write_rate_bytes_per_second="
					+ String.valueOf(write_rate_bytes_per_second));
			sb.append(",write_latency_seconds="
					+ String.valueOf(write_latency_seconds));
			sb.append(",flush_latency_seconds="
					+ String.valueOf(flush_latency_seconds));
			sb.append(",vm_disk_configuration_version="
					+ String.valueOf(vm_disk_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_disk_aggregateStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row19Struct implements
			routines.system.IPersistableRow<row19Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Short vm_disk_status;

		public Short getVm_disk_status() {
			return this.vm_disk_status;
		}

		public double minutes_in_status;

		public double getMinutes_in_status() {
			return this.minutes_in_status;
		}

		public int vm_disk_actual_size_mb;

		public int getVm_disk_actual_size_mb() {
			return this.vm_disk_actual_size_mb;
		}

		public Long read_rate_bytes_per_second;

		public Long getRead_rate_bytes_per_second() {
			return this.read_rate_bytes_per_second;
		}

		public Double read_latency_seconds;

		public Double getRead_latency_seconds() {
			return this.read_latency_seconds;
		}

		public Long write_rate_bytes_per_second;

		public Long getWrite_rate_bytes_per_second() {
			return this.write_rate_bytes_per_second;
		}

		public Double write_latency_seconds;

		public Double getWrite_latency_seconds() {
			return this.write_latency_seconds;
		}

		public Double flush_latency_seconds;

		public Double getFlush_latency_seconds() {
			return this.flush_latency_seconds;
		}

		public Integer vm_disk_configuration_version;

		public Integer getVm_disk_configuration_version() {
			return this.vm_disk_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.image_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_status = null;
					} else {
						this.vm_disk_status = dis.readShort();
					}

					this.minutes_in_status = dis.readDouble();

					this.vm_disk_actual_size_mb = dis.readInt();

					length = dis.readByte();
					if (length == -1) {
						this.read_rate_bytes_per_second = null;
					} else {
						this.read_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.read_latency_seconds = null;
					} else {
						this.read_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_rate_bytes_per_second = null;
					} else {
						this.write_rate_bytes_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_latency_seconds = null;
					} else {
						this.write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.flush_latency_seconds = null;
					} else {
						this.flush_latency_seconds = dis.readDouble();
					}

					this.vm_disk_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// Object

				dos.writeObject(this.image_id);

				// Short

				if (this.vm_disk_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_status);
				}

				// double

				dos.writeDouble(this.minutes_in_status);

				// int

				dos.writeInt(this.vm_disk_actual_size_mb);

				// Long

				if (this.read_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.read_rate_bytes_per_second);
				}

				// Double

				if (this.read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.read_latency_seconds);
				}

				// Long

				if (this.write_rate_bytes_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.write_rate_bytes_per_second);
				}

				// Double

				if (this.write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.write_latency_seconds);
				}

				// Double

				if (this.flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.flush_latency_seconds);
				}

				// Integer

				writeInteger(this.vm_disk_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",vm_disk_status=" + String.valueOf(vm_disk_status));
			sb.append(",minutes_in_status=" + String.valueOf(minutes_in_status));
			sb.append(",vm_disk_actual_size_mb="
					+ String.valueOf(vm_disk_actual_size_mb));
			sb.append(",read_rate_bytes_per_second="
					+ String.valueOf(read_rate_bytes_per_second));
			sb.append(",read_latency_seconds="
					+ String.valueOf(read_latency_seconds));
			sb.append(",write_rate_bytes_per_second="
					+ String.valueOf(write_rate_bytes_per_second));
			sb.append(",write_latency_seconds="
					+ String.valueOf(write_latency_seconds));
			sb.append(",flush_latency_seconds="
					+ String.valueOf(flush_latency_seconds));
			sb.append(",vm_disk_configuration_version="
					+ String.valueOf(vm_disk_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row19Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_13Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row19Struct row19 = new row19Struct();
				vm_disk_aggregateStruct vm_disk_aggregate = new vm_disk_aggregateStruct();
				row20Struct row20 = new row20Struct();

				/**
				 * [tAggregateRow_7_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_7_AGGOUT", false);
				start_Hash.put("tAggregateRow_7_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_7";

				currentComponent = "tAggregateRow_7_AGGOUT";

				int tos_count_tAggregateRow_7_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_7 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_7 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_7 utilClass_tAggregateRow_7 = new UtilClass_tAggregateRow_7();

				class AggOperationStruct_tAggregateRow_7 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object vm_disk_id;
					Short vm_disk_status;
					BigDecimal minutes_in_status_sum;

					double vm_disk_actual_size_mb_sum;
					int vm_disk_actual_size_mb_count = 0;
					BigDecimal read_rate_bytes_per_second_sum;
					int read_rate_bytes_per_second_count = 0;

					Long max_read_rate_bytes_per_second_max;
					BigDecimal read_latency_seconds_sum;
					int read_latency_seconds_count = 0;

					Double max_read_latency_seconds_max;
					BigDecimal write_rate_bytes_per_second_sum;
					int write_rate_bytes_per_second_count = 0;

					Long max_write_rate_bytes_per_second_max;
					BigDecimal write_latency_seconds_sum;
					int write_latency_seconds_count = 0;

					Double max_write_latency_seconds_max;
					BigDecimal flush_latency_seconds_sum;
					int flush_latency_seconds_count = 0;

					Double max_flush_latency_seconds_max;
					Integer vm_disk_configuration_version_last;
					Object image_id_last;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.vm_disk_id == null) ? 0
											: this.vm_disk_id.hashCode());

							result = prime
									* result
									+ ((this.vm_disk_status == null) ? 0
											: this.vm_disk_status.hashCode());

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_7 other = (AggOperationStruct_tAggregateRow_7) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.vm_disk_id == null) {
							if (other.vm_disk_id != null)
								return false;
						} else if (!this.vm_disk_id.equals(other.vm_disk_id))
							return false;

						if (this.vm_disk_status == null) {
							if (other.vm_disk_status != null)
								return false;
						} else if (!this.vm_disk_status
								.equals(other.vm_disk_status))
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_7 operation_result_tAggregateRow_7 = null;
				AggOperationStruct_tAggregateRow_7 operation_finder_tAggregateRow_7 = new AggOperationStruct_tAggregateRow_7();
				java.util.Map<AggOperationStruct_tAggregateRow_7, AggOperationStruct_tAggregateRow_7> hash_tAggregateRow_7 = new java.util.HashMap<AggOperationStruct_tAggregateRow_7, AggOperationStruct_tAggregateRow_7>();

				/**
				 * [tAggregateRow_7_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_13 begin ] start
				 */

				ok_Hash.put("tMap_13", false);
				start_Hash.put("tMap_13", System.currentTimeMillis());

				currentComponent = "tMap_13";

				int tos_count_tMap_13 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_13__Struct {
				}
				Var__tMap_13__Struct Var__tMap_13 = new Var__tMap_13__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_disk_aggregateStruct vm_disk_aggregate_tmp = new vm_disk_aggregateStruct();
				// ###############################

				/**
				 * [tMap_13 begin ] stop
				 */

				/**
				 * [tJDBCInput_13 begin ] start
				 */

				ok_Hash.put("tJDBCInput_13", false);
				start_Hash.put("tJDBCInput_13", System.currentTimeMillis());

				currentComponent = "tJDBCInput_13";

				int tos_count_tJDBCInput_13 = 0;

				int nb_line_tJDBCInput_13 = 0;
				java.sql.Connection conn_tJDBCInput_13 = null;
				conn_tJDBCInput_13 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_13 = conn_tJDBCInput_13
						.createStatement();

				String dbquery_tJDBCInput_13 = "SELECT history_datetime,\n		vm_disk_id,\n        image_id,\n		vm_disk_status, \n		minutes_in_status,\n		vm_disk_actual_size_mb,\n		read_rate_bytes_per_second,\n		read_latency_seconds,\n		write_rate_bytes_per_second,\n		write_latency_seconds,\n		flush_latency_seconds,\n		vm_disk_configuration_version \nFROM vm_disk_hourly_history\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\nAND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY history_datetime,\n		 vm_disk_id, \n  		 vm_disk_status";

				globalMap.put("tJDBCInput_13_QUERY", dbquery_tJDBCInput_13);

				java.sql.ResultSet rs_tJDBCInput_13 = null;
				try {
					rs_tJDBCInput_13 = stmt_tJDBCInput_13
							.executeQuery(dbquery_tJDBCInput_13);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_13 = rs_tJDBCInput_13
							.getMetaData();
					int colQtyInRs_tJDBCInput_13 = rsmd_tJDBCInput_13
							.getColumnCount();

					String tmpContent_tJDBCInput_13 = null;

					while (rs_tJDBCInput_13.next()) {
						nb_line_tJDBCInput_13++;

						if (colQtyInRs_tJDBCInput_13 < 1) {
							row19.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_13 = null;
							try {
								date_tJDBCInput_13 = rs_tJDBCInput_13
										.getTimestamp(1);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_13 = rs_tJDBCInput_13
										.getDate(1);
							}
							row19.history_datetime = date_tJDBCInput_13;
						}
						if (colQtyInRs_tJDBCInput_13 < 2) {
							row19.vm_disk_id = null;
						} else {

							if (rs_tJDBCInput_13.getObject(2) != null) {
								row19.vm_disk_id = rs_tJDBCInput_13
										.getObject(2);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 3) {
							row19.image_id = null;
						} else {

							if (rs_tJDBCInput_13.getObject(3) != null) {
								row19.image_id = rs_tJDBCInput_13.getObject(3);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 4) {
							row19.vm_disk_status = null;
						} else {

							if (rs_tJDBCInput_13.getObject(4) != null) {
								row19.vm_disk_status = rs_tJDBCInput_13
										.getShort(4);
							} else {
								row19.vm_disk_status = null;
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 5) {
							row19.minutes_in_status = 0;
						} else {

							if (rs_tJDBCInput_13.getObject(5) != null) {
								row19.minutes_in_status = rs_tJDBCInput_13
										.getDouble(5);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 6) {
							row19.vm_disk_actual_size_mb = 0;
						} else {

							if (rs_tJDBCInput_13.getObject(6) != null) {
								row19.vm_disk_actual_size_mb = rs_tJDBCInput_13
										.getInt(6);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 7) {
							row19.read_rate_bytes_per_second = null;
						} else {

							if (rs_tJDBCInput_13.getObject(7) != null) {
								row19.read_rate_bytes_per_second = rs_tJDBCInput_13
										.getLong(7);
							} else {
								row19.read_rate_bytes_per_second = null;
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 8) {
							row19.read_latency_seconds = null;
						} else {

							if (rs_tJDBCInput_13.getObject(8) != null) {
								row19.read_latency_seconds = rs_tJDBCInput_13
										.getDouble(8);
							} else {
								row19.read_latency_seconds = null;
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 9) {
							row19.write_rate_bytes_per_second = null;
						} else {

							if (rs_tJDBCInput_13.getObject(9) != null) {
								row19.write_rate_bytes_per_second = rs_tJDBCInput_13
										.getLong(9);
							} else {
								row19.write_rate_bytes_per_second = null;
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 10) {
							row19.write_latency_seconds = null;
						} else {

							if (rs_tJDBCInput_13.getObject(10) != null) {
								row19.write_latency_seconds = rs_tJDBCInput_13
										.getDouble(10);
							} else {
								row19.write_latency_seconds = null;
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 11) {
							row19.flush_latency_seconds = null;
						} else {

							if (rs_tJDBCInput_13.getObject(11) != null) {
								row19.flush_latency_seconds = rs_tJDBCInput_13
										.getDouble(11);
							} else {
								row19.flush_latency_seconds = null;
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 12) {
							row19.vm_disk_configuration_version = null;
						} else {

							if (rs_tJDBCInput_13.getObject(12) != null) {
								row19.vm_disk_configuration_version = rs_tJDBCInput_13
										.getInt(12);
							} else {
								row19.vm_disk_configuration_version = null;
							}
						}

						/**
						 * [tJDBCInput_13 begin ] stop
						 */

						/**
						 * [tJDBCInput_13 main ] start
						 */

						currentComponent = "tJDBCInput_13";

						tos_count_tJDBCInput_13++;

						/**
						 * [tJDBCInput_13 main ] stop
						 */

						/**
						 * [tMap_13 main ] start
						 */

						currentComponent = "tMap_13";

						boolean hasCasePrimitiveKeyWithNull_tMap_13 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_13 = false;
						boolean mainRowRejected_tMap_13 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_13__Struct Var = Var__tMap_13;// ###############################
							// ###############################
							// # Output tables

							vm_disk_aggregate = null;

							// # Output table : 'vm_disk_aggregate'
							vm_disk_aggregate_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row19.history_datetime);
							vm_disk_aggregate_tmp.vm_disk_id = row19.vm_disk_id;
							vm_disk_aggregate_tmp.image_id = row19.image_id;
							vm_disk_aggregate_tmp.vm_disk_status = row19.vm_disk_status;
							vm_disk_aggregate_tmp.minutes_in_status = row19.minutes_in_status;
							vm_disk_aggregate_tmp.vm_disk_actual_size_mb = row19.vm_disk_actual_size_mb;
							vm_disk_aggregate_tmp.read_rate_bytes_per_second = row19.read_rate_bytes_per_second;
							vm_disk_aggregate_tmp.read_latency_seconds = row19.read_latency_seconds;
							vm_disk_aggregate_tmp.write_rate_bytes_per_second = row19.write_rate_bytes_per_second;
							vm_disk_aggregate_tmp.write_latency_seconds = row19.write_latency_seconds;
							vm_disk_aggregate_tmp.flush_latency_seconds = row19.flush_latency_seconds;
							vm_disk_aggregate_tmp.vm_disk_configuration_version = row19.vm_disk_configuration_version;
							vm_disk_aggregate = vm_disk_aggregate_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_13 = false;

						tos_count_tMap_13++;

						/**
						 * [tMap_13 main ] stop
						 */
						// Start of branch "vm_disk_aggregate"
						if (vm_disk_aggregate != null) {

							/**
							 * [tAggregateRow_7_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_7";

							currentComponent = "tAggregateRow_7_AGGOUT";

							operation_finder_tAggregateRow_7.history_datetime = vm_disk_aggregate.history_datetime;
							operation_finder_tAggregateRow_7.vm_disk_id = vm_disk_aggregate.vm_disk_id;
							operation_finder_tAggregateRow_7.vm_disk_status = vm_disk_aggregate.vm_disk_status;

							operation_finder_tAggregateRow_7.hashCodeDirty = true;

							operation_result_tAggregateRow_7 = hash_tAggregateRow_7
									.get(operation_finder_tAggregateRow_7);

							boolean isFirstAdd_tAggregateRow_7 = false;

							if (operation_result_tAggregateRow_7 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_7 = new AggOperationStruct_tAggregateRow_7();

								operation_result_tAggregateRow_7.history_datetime = operation_finder_tAggregateRow_7.history_datetime;
								operation_result_tAggregateRow_7.vm_disk_id = operation_finder_tAggregateRow_7.vm_disk_id;
								operation_result_tAggregateRow_7.vm_disk_status = operation_finder_tAggregateRow_7.vm_disk_status;

								isFirstAdd_tAggregateRow_7 = true;

								hash_tAggregateRow_7.put(
										operation_result_tAggregateRow_7,
										operation_result_tAggregateRow_7);

							} // G_OutMain_AggR_001

							if (operation_result_tAggregateRow_7.minutes_in_status_sum == null) {
								operation_result_tAggregateRow_7.minutes_in_status_sum = new BigDecimal(
										0).setScale(2);
							}
							operation_result_tAggregateRow_7.minutes_in_status_sum = operation_result_tAggregateRow_7.minutes_in_status_sum
									.add(new BigDecimal(
											String.valueOf(vm_disk_aggregate.minutes_in_status)));

							operation_result_tAggregateRow_7.vm_disk_actual_size_mb_count++;

							operation_result_tAggregateRow_7.vm_disk_actual_size_mb_sum += vm_disk_aggregate.vm_disk_actual_size_mb;

							if (vm_disk_aggregate.read_rate_bytes_per_second != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_7.read_rate_bytes_per_second_count++;

								if (operation_result_tAggregateRow_7.read_rate_bytes_per_second_sum == null) {
									operation_result_tAggregateRow_7.read_rate_bytes_per_second_sum = new BigDecimal(
											0).setScale(0);
								}
								operation_result_tAggregateRow_7.read_rate_bytes_per_second_sum = operation_result_tAggregateRow_7.read_rate_bytes_per_second_sum
										.add(new BigDecimal(
												String.valueOf(vm_disk_aggregate.read_rate_bytes_per_second)));

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.read_rate_bytes_per_second != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_7.max_read_rate_bytes_per_second_max == null
										|| vm_disk_aggregate.read_rate_bytes_per_second > operation_result_tAggregateRow_7.max_read_rate_bytes_per_second_max

								) {
									operation_result_tAggregateRow_7.max_read_rate_bytes_per_second_max = vm_disk_aggregate.read_rate_bytes_per_second;
								}

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.read_latency_seconds != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_7.read_latency_seconds_count++;

								if (operation_result_tAggregateRow_7.read_latency_seconds_sum == null) {
									operation_result_tAggregateRow_7.read_latency_seconds_sum = new BigDecimal(
											0).setScale(9);
								}
								operation_result_tAggregateRow_7.read_latency_seconds_sum = operation_result_tAggregateRow_7.read_latency_seconds_sum
										.add(new BigDecimal(
												String.valueOf(vm_disk_aggregate.read_latency_seconds)));

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.read_latency_seconds != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_7.max_read_latency_seconds_max == null
										|| vm_disk_aggregate.read_latency_seconds > operation_result_tAggregateRow_7.max_read_latency_seconds_max

								) {
									operation_result_tAggregateRow_7.max_read_latency_seconds_max = vm_disk_aggregate.read_latency_seconds;
								}

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.write_rate_bytes_per_second != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_7.write_rate_bytes_per_second_count++;

								if (operation_result_tAggregateRow_7.write_rate_bytes_per_second_sum == null) {
									operation_result_tAggregateRow_7.write_rate_bytes_per_second_sum = new BigDecimal(
											0).setScale(0);
								}
								operation_result_tAggregateRow_7.write_rate_bytes_per_second_sum = operation_result_tAggregateRow_7.write_rate_bytes_per_second_sum
										.add(new BigDecimal(
												String.valueOf(vm_disk_aggregate.write_rate_bytes_per_second)));

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.write_rate_bytes_per_second != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_7.max_write_rate_bytes_per_second_max == null
										|| vm_disk_aggregate.write_rate_bytes_per_second > operation_result_tAggregateRow_7.max_write_rate_bytes_per_second_max

								) {
									operation_result_tAggregateRow_7.max_write_rate_bytes_per_second_max = vm_disk_aggregate.write_rate_bytes_per_second;
								}

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.write_latency_seconds != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_7.write_latency_seconds_count++;

								if (operation_result_tAggregateRow_7.write_latency_seconds_sum == null) {
									operation_result_tAggregateRow_7.write_latency_seconds_sum = new BigDecimal(
											0).setScale(9);
								}
								operation_result_tAggregateRow_7.write_latency_seconds_sum = operation_result_tAggregateRow_7.write_latency_seconds_sum
										.add(new BigDecimal(
												String.valueOf(vm_disk_aggregate.write_latency_seconds)));

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.write_latency_seconds != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_7.max_write_latency_seconds_max == null
										|| vm_disk_aggregate.write_latency_seconds > operation_result_tAggregateRow_7.max_write_latency_seconds_max

								) {
									operation_result_tAggregateRow_7.max_write_latency_seconds_max = vm_disk_aggregate.write_latency_seconds;
								}

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.flush_latency_seconds != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_7.flush_latency_seconds_count++;

								if (operation_result_tAggregateRow_7.flush_latency_seconds_sum == null) {
									operation_result_tAggregateRow_7.flush_latency_seconds_sum = new BigDecimal(
											0).setScale(9);
								}
								operation_result_tAggregateRow_7.flush_latency_seconds_sum = operation_result_tAggregateRow_7.flush_latency_seconds_sum
										.add(new BigDecimal(
												String.valueOf(vm_disk_aggregate.flush_latency_seconds)));

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.flush_latency_seconds != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_7.max_flush_latency_seconds_max == null
										|| vm_disk_aggregate.flush_latency_seconds > operation_result_tAggregateRow_7.max_flush_latency_seconds_max

								) {
									operation_result_tAggregateRow_7.max_flush_latency_seconds_max = vm_disk_aggregate.flush_latency_seconds;
								}

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.vm_disk_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_7.vm_disk_configuration_version_last = vm_disk_aggregate.vm_disk_configuration_version;

							} // G_OutMain_AggR_546

							if (vm_disk_aggregate.image_id != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_7.image_id_last = vm_disk_aggregate.image_id;

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_7_AGGOUT++;

							/**
							 * [tAggregateRow_7_AGGOUT main ] stop
							 */

						} // End of branch "vm_disk_aggregate"

						/**
						 * [tJDBCInput_13 end ] start
						 */

						currentComponent = "tJDBCInput_13";

					}
				} finally {
					if (rs_tJDBCInput_13 != null) {
						rs_tJDBCInput_13.close();
					}
					stmt_tJDBCInput_13.close();

				}
				globalMap.put("tJDBCInput_13_NB_LINE", nb_line_tJDBCInput_13);

				ok_Hash.put("tJDBCInput_13", true);
				end_Hash.put("tJDBCInput_13", System.currentTimeMillis());

				/**
				 * [tJDBCInput_13 end ] stop
				 */

				/**
				 * [tMap_13 end ] start
				 */

				currentComponent = "tMap_13";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_13", true);
				end_Hash.put("tMap_13", System.currentTimeMillis());

				/**
				 * [tMap_13 end ] stop
				 */

				/**
				 * [tAggregateRow_7_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_7";

				currentComponent = "tAggregateRow_7_AGGOUT";

				ok_Hash.put("tAggregateRow_7_AGGOUT", true);
				end_Hash.put("tAggregateRow_7_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_7_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_13 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_13", false);
				start_Hash.put("tJDBCOutput_13", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_13";

				int tos_count_tJDBCOutput_13 = 0;

				int nb_line_tJDBCOutput_13 = 0;
				int nb_line_update_tJDBCOutput_13 = 0;
				int nb_line_inserted_tJDBCOutput_13 = 0;
				int nb_line_deleted_tJDBCOutput_13 = 0;
				int nb_line_rejected_tJDBCOutput_13 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_13 = 0;

				int deletedCount_tJDBCOutput_13 = 0;
				int updatedCount_tJDBCOutput_13 = 0;
				int insertedCount_tJDBCOutput_13 = 0;
				int rejectedCount_tJDBCOutput_13 = 0;

				boolean whetherReject_tJDBCOutput_13 = false;

				java.sql.Connection connection_tJDBCOutput_13 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_13 = "INSERT INTO "
						+ "vm_disk_daily_history"
						+ " (history_datetime,vm_disk_id,image_id,vm_disk_status,minutes_in_status,vm_disk_actual_size_mb,read_rate_bytes_per_second,max_read_rate_bytes_per_second,read_latency_seconds,max_read_latency_seconds,write_rate_bytes_per_second,max_write_rate_bytes_per_second,write_latency_seconds,max_write_latency_seconds,flush_latency_seconds,max_flush_latency_seconds,vm_disk_configuration_version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_13 = connection_tJDBCOutput_13
						.prepareStatement(insert_tJDBCOutput_13);

				/**
				 * [tJDBCOutput_13 begin ] stop
				 */

				/**
				 * [tAggregateRow_7_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_7_AGGIN", false);
				start_Hash.put("tAggregateRow_7_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_7";

				currentComponent = "tAggregateRow_7_AGGIN";

				int tos_count_tAggregateRow_7_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_7> values_tAggregateRow_7 = hash_tAggregateRow_7
						.values();

				globalMap.put("tAggregateRow_7_NB_LINE",
						values_tAggregateRow_7.size());

				for (AggOperationStruct_tAggregateRow_7 aggregated_row_tAggregateRow_7 : values_tAggregateRow_7) { // G_AggR_600

					/**
					 * [tAggregateRow_7_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_7_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_7";

					currentComponent = "tAggregateRow_7_AGGIN";

					row20.history_datetime = aggregated_row_tAggregateRow_7.history_datetime;

					row20.vm_disk_id = aggregated_row_tAggregateRow_7.vm_disk_id;

					row20.image_id = aggregated_row_tAggregateRow_7.image_id_last;
					row20.vm_disk_status = aggregated_row_tAggregateRow_7.vm_disk_status;

					if (aggregated_row_tAggregateRow_7.minutes_in_status_sum != null) {
						row20.minutes_in_status = aggregated_row_tAggregateRow_7.minutes_in_status_sum
								.doubleValue();

					} else {

						row20.minutes_in_status = 0;

					}

					if (aggregated_row_tAggregateRow_7.vm_disk_actual_size_mb_count > 0) {

						double row20_vm_disk_actual_size_mb_temp = (double) aggregated_row_tAggregateRow_7.vm_disk_actual_size_mb_sum
								/ (double) aggregated_row_tAggregateRow_7.vm_disk_actual_size_mb_count;

						row20.vm_disk_actual_size_mb = (int) row20_vm_disk_actual_size_mb_temp;

					} else {
						String count = "0";

						row20.vm_disk_actual_size_mb = ParserUtils
								.parseTo_int(count);

					}
					if (aggregated_row_tAggregateRow_7.read_rate_bytes_per_second_count > 0) {

						row20.read_rate_bytes_per_second = aggregated_row_tAggregateRow_7.read_rate_bytes_per_second_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_7.read_rate_bytes_per_second_count)),
										10, BigDecimal.ROUND_HALF_UP)

								.longValue()

						;

					} else {
						String count = "0";

						row20.read_rate_bytes_per_second = ParserUtils
								.parseTo_Long(count);

					}
					row20.max_read_rate_bytes_per_second = aggregated_row_tAggregateRow_7.max_read_rate_bytes_per_second_max;
					if (aggregated_row_tAggregateRow_7.read_latency_seconds_count > 0) {

						row20.read_latency_seconds = aggregated_row_tAggregateRow_7.read_latency_seconds_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_7.read_latency_seconds_count)),
										9, BigDecimal.ROUND_HALF_UP)

								.doubleValue()

						;

					} else {
						String count = "0";

						row20.read_latency_seconds = ParserUtils
								.parseTo_Double(count);

					}
					row20.max_read_latency_seconds = aggregated_row_tAggregateRow_7.max_read_latency_seconds_max;
					if (aggregated_row_tAggregateRow_7.write_rate_bytes_per_second_count > 0) {

						row20.write_rate_bytes_per_second = aggregated_row_tAggregateRow_7.write_rate_bytes_per_second_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_7.write_rate_bytes_per_second_count)),
										10, BigDecimal.ROUND_HALF_UP)

								.longValue()

						;

					} else {
						String count = "0";

						row20.write_rate_bytes_per_second = ParserUtils
								.parseTo_Long(count);

					}
					row20.max_write_rate_bytes_per_second = aggregated_row_tAggregateRow_7.max_write_rate_bytes_per_second_max;
					if (aggregated_row_tAggregateRow_7.write_latency_seconds_count > 0) {

						row20.write_latency_seconds = aggregated_row_tAggregateRow_7.write_latency_seconds_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_7.write_latency_seconds_count)),
										9, BigDecimal.ROUND_HALF_UP)

								.doubleValue()

						;

					} else {
						String count = "0";

						row20.write_latency_seconds = ParserUtils
								.parseTo_Double(count);

					}
					row20.max_write_latency_seconds = aggregated_row_tAggregateRow_7.max_write_latency_seconds_max;
					if (aggregated_row_tAggregateRow_7.flush_latency_seconds_count > 0) {

						row20.flush_latency_seconds = aggregated_row_tAggregateRow_7.flush_latency_seconds_sum
								.divide(new BigDecimal(
										String.valueOf(aggregated_row_tAggregateRow_7.flush_latency_seconds_count)),
										9, BigDecimal.ROUND_HALF_UP)

								.doubleValue()

						;

					} else {
						String count = "0";

						row20.flush_latency_seconds = ParserUtils
								.parseTo_Double(count);

					}
					row20.max_flush_latency_seconds = aggregated_row_tAggregateRow_7.max_flush_latency_seconds_max;
					row20.vm_disk_configuration_version = aggregated_row_tAggregateRow_7.vm_disk_configuration_version_last;

					tos_count_tAggregateRow_7_AGGIN++;

					/**
					 * [tAggregateRow_7_AGGIN main ] stop
					 */

					/**
					 * [tJDBCOutput_13 main ] start
					 */

					currentComponent = "tJDBCOutput_13";

					whetherReject_tJDBCOutput_13 = false;
					if (row20.history_datetime != null) {
						pstmt_tJDBCOutput_13.setTimestamp(
								1,
								new java.sql.Timestamp(row20.history_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_13.setNull(1, java.sql.Types.DATE);
					}

					if (row20.vm_disk_id == null) {
						pstmt_tJDBCOutput_13.setNull(2, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_13.setObject(2, row20.vm_disk_id);
					}

					if (row20.image_id == null) {
						pstmt_tJDBCOutput_13.setNull(3, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_13.setObject(3, row20.image_id);
					}

					if (row20.vm_disk_status == null) {
						pstmt_tJDBCOutput_13.setNull(4, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_13.setShort(4, row20.vm_disk_status);
					}

					pstmt_tJDBCOutput_13.setDouble(5, row20.minutes_in_status);

					pstmt_tJDBCOutput_13
							.setInt(6, row20.vm_disk_actual_size_mb);

					if (row20.read_rate_bytes_per_second == null) {
						pstmt_tJDBCOutput_13.setNull(7, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_13.setLong(7,
								row20.read_rate_bytes_per_second);
					}

					if (row20.max_read_rate_bytes_per_second == null) {
						pstmt_tJDBCOutput_13.setNull(8, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_13.setLong(8,
								row20.max_read_rate_bytes_per_second);
					}

					if (row20.read_latency_seconds == null) {
						pstmt_tJDBCOutput_13.setNull(9, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_13.setDouble(9,
								row20.read_latency_seconds);
					}

					if (row20.max_read_latency_seconds == null) {
						pstmt_tJDBCOutput_13.setNull(10, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_13.setDouble(10,
								row20.max_read_latency_seconds);
					}

					if (row20.write_rate_bytes_per_second == null) {
						pstmt_tJDBCOutput_13
								.setNull(11, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_13.setLong(11,
								row20.write_rate_bytes_per_second);
					}

					if (row20.max_write_rate_bytes_per_second == null) {
						pstmt_tJDBCOutput_13
								.setNull(12, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_13.setLong(12,
								row20.max_write_rate_bytes_per_second);
					}

					if (row20.write_latency_seconds == null) {
						pstmt_tJDBCOutput_13.setNull(13, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_13.setDouble(13,
								row20.write_latency_seconds);
					}

					if (row20.max_write_latency_seconds == null) {
						pstmt_tJDBCOutput_13.setNull(14, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_13.setDouble(14,
								row20.max_write_latency_seconds);
					}

					if (row20.flush_latency_seconds == null) {
						pstmt_tJDBCOutput_13.setNull(15, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_13.setDouble(15,
								row20.flush_latency_seconds);
					}

					if (row20.max_flush_latency_seconds == null) {
						pstmt_tJDBCOutput_13.setNull(16, java.sql.Types.DOUBLE);
					} else {
						pstmt_tJDBCOutput_13.setDouble(16,
								row20.max_flush_latency_seconds);
					}

					if (row20.vm_disk_configuration_version == null) {
						pstmt_tJDBCOutput_13
								.setNull(17, java.sql.Types.INTEGER);
					} else {
						pstmt_tJDBCOutput_13.setInt(17,
								row20.vm_disk_configuration_version);
					}

					try {
						insertedCount_tJDBCOutput_13 = insertedCount_tJDBCOutput_13
								+ pstmt_tJDBCOutput_13.executeUpdate();
						nb_line_tJDBCOutput_13++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_13 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_13++;

					/**
					 * [tJDBCOutput_13 main ] stop
					 */

					/**
					 * [tAggregateRow_7_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_7";

					currentComponent = "tAggregateRow_7_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_7_AGGIN", true);
				end_Hash.put("tAggregateRow_7_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_7_AGGIN end ] stop
				 */

				/**
				 * [tJDBCOutput_13 end ] start
				 */

				currentComponent = "tJDBCOutput_13";

				if (pstmt_tJDBCOutput_13 != null) {

					pstmt_tJDBCOutput_13.close();

				}

				nb_line_deleted_tJDBCOutput_13 = nb_line_deleted_tJDBCOutput_13
						+ deletedCount_tJDBCOutput_13;
				nb_line_update_tJDBCOutput_13 = nb_line_update_tJDBCOutput_13
						+ updatedCount_tJDBCOutput_13;
				nb_line_inserted_tJDBCOutput_13 = nb_line_inserted_tJDBCOutput_13
						+ insertedCount_tJDBCOutput_13;
				nb_line_rejected_tJDBCOutput_13 = nb_line_rejected_tJDBCOutput_13
						+ rejectedCount_tJDBCOutput_13;

				globalMap.put("tJDBCOutput_13_NB_LINE", nb_line_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_13);

				ok_Hash.put("tJDBCOutput_13", true);
				end_Hash.put("tJDBCOutput_13", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_13 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_7_AGGIN"
			globalMap.remove("tAggregateRow_7");

			try {

				/**
				 * [tJDBCInput_13 finally ] start
				 */

				currentComponent = "tJDBCInput_13";

				/**
				 * [tJDBCInput_13 finally ] stop
				 */

				/**
				 * [tMap_13 finally ] start
				 */

				currentComponent = "tMap_13";

				/**
				 * [tMap_13 finally ] stop
				 */

				/**
				 * [tAggregateRow_7_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_7";

				currentComponent = "tAggregateRow_7_AGGOUT";

				/**
				 * [tAggregateRow_7_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_7_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_7";

				currentComponent = "tAggregateRow_7_AGGIN";

				/**
				 * [tAggregateRow_7_AGGIN finally ] stop
				 */

				/**
				 * [tJDBCOutput_13 finally ] start
				 */

				currentComponent = "tJDBCOutput_13";

				/**
				 * [tJDBCOutput_13 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", 1);
	}

	public void tPrejob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPrejob_1 begin ] start
				 */

				ok_Hash.put("tPrejob_1", false);
				start_Hash.put("tPrejob_1", System.currentTimeMillis());

				currentComponent = "tPrejob_1";

				int tos_count_tPrejob_1 = 0;

				/**
				 * [tPrejob_1 begin ] stop
				 */

				/**
				 * [tPrejob_1 main ] start
				 */

				currentComponent = "tPrejob_1";

				tos_count_tPrejob_1++;

				/**
				 * [tPrejob_1 main ] stop
				 */

				/**
				 * [tPrejob_1 end ] start
				 */

				currentComponent = "tPrejob_1";

				ok_Hash.put("tPrejob_1", true);
				end_Hash.put("tPrejob_1", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tPrejob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPrejob_1 finally ] start
				 */

				currentComponent = "tPrejob_1";

				/**
				 * [tPrejob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_1 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_1 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_1 = decryptedPassword_tJDBCConnection_1;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "daily_ovirt_engine_history";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_1, dbUser_tJDBCConnection_1,
						dbPwd_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// dbUser_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// dbPwd_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */

				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */

				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public void tPostjob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPostjob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPostjob_1 begin ] start
				 */

				ok_Hash.put("tPostjob_1", false);
				start_Hash.put("tPostjob_1", System.currentTimeMillis());

				currentComponent = "tPostjob_1";

				int tos_count_tPostjob_1 = 0;

				/**
				 * [tPostjob_1 begin ] stop
				 */

				/**
				 * [tPostjob_1 main ] start
				 */

				currentComponent = "tPostjob_1";

				tos_count_tPostjob_1++;

				/**
				 * [tPostjob_1 main ] stop
				 */

				/**
				 * [tPostjob_1 end ] start
				 */

				currentComponent = "tPostjob_1";

				ok_Hash.put("tPostjob_1", true);
				end_Hash.put("tPostjob_1", System.currentTimeMillis());

				tRowGenerator_1Process(globalMap);

				/**
				 * [tPostjob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPostjob_1 finally ] start
				 */

				currentComponent = "tPostjob_1";

				/**
				 * [tPostjob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPostjob_1_SUBPROCESS_STATE", 1);
	}

	public static class row11Struct implements
			routines.system.IPersistableRow<row11Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String var_name;

		public String getVar_name() {
			return this.var_name;
		}

		public java.util.Date var_datetime;

		public java.util.Date getVar_datetime() {
			return this.var_datetime;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.var_name == null) ? 0 : this.var_name
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row11Struct other = (row11Struct) obj;

			if (this.var_name == null) {
				if (other.var_name != null)
					return false;

			} else if (!this.var_name.equals(other.var_name))

				return false;

			return true;
		}

		public void copyDataTo(row11Struct other) {

			other.var_name = this.var_name;
			other.var_datetime = this.var_datetime;

		}

		public void copyKeysDataTo(row11Struct other) {

			other.var_name = this.var_name;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.var_name = readString(dis);

					this.var_datetime = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.var_name, dos);

				// java.util.Date

				writeDate(this.var_datetime, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("var_name=" + var_name);
			sb.append(",var_datetime=" + String.valueOf(var_datetime));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row11Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.var_name, other.var_name);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row11Struct row11 = new row11Struct();

				/**
				 * [tJDBCOutput_6 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_6", false);
				start_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_6";

				int tos_count_tJDBCOutput_6 = 0;

				int updateKeyCount_tJDBCOutput_6 = 1;
				if (updateKeyCount_tJDBCOutput_6 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_6 = 0;
				int nb_line_update_tJDBCOutput_6 = 0;
				int nb_line_inserted_tJDBCOutput_6 = 0;
				int nb_line_deleted_tJDBCOutput_6 = 0;
				int nb_line_rejected_tJDBCOutput_6 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_6 = 0;

				int deletedCount_tJDBCOutput_6 = 0;
				int updatedCount_tJDBCOutput_6 = 0;
				int insertedCount_tJDBCOutput_6 = 0;
				int rejectedCount_tJDBCOutput_6 = 0;

				boolean whetherReject_tJDBCOutput_6 = false;

				java.sql.Connection connection_tJDBCOutput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String update_tJDBCOutput_6 = "UPDATE "
						+ "history_configuration"
						+ " SET var_datetime = ? WHERE var_name = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_6 = connection_tJDBCOutput_6
						.prepareStatement(update_tJDBCOutput_6);

				/**
				 * [tJDBCOutput_6 begin ] stop
				 */

				/**
				 * [tRowGenerator_1 begin ] start
				 */

				ok_Hash.put("tRowGenerator_1", false);
				start_Hash.put("tRowGenerator_1", System.currentTimeMillis());

				currentComponent = "tRowGenerator_1";

				int tos_count_tRowGenerator_1 = 0;

				int nb_line_tRowGenerator_1 = 0;
				int nb_max_row_tRowGenerator_1 = 1;

				class tRowGenerator_1Randomizer {
					public String getRandomvar_name() {

						return "lastDayAggr";

					}

					public java.util.Date getRandomvar_datetime() {

						return TalendDate.addDate(context.lastDayAggr, 1, "dd");

					}
				}
				tRowGenerator_1Randomizer randtRowGenerator_1 = new tRowGenerator_1Randomizer();

				for (int itRowGenerator_1 = 0; itRowGenerator_1 < nb_max_row_tRowGenerator_1; itRowGenerator_1++) {
					row11.var_name = randtRowGenerator_1.getRandomvar_name();
					row11.var_datetime = randtRowGenerator_1
							.getRandomvar_datetime();
					nb_line_tRowGenerator_1++;

					/**
					 * [tRowGenerator_1 begin ] stop
					 */

					/**
					 * [tRowGenerator_1 main ] start
					 */

					currentComponent = "tRowGenerator_1";

					tos_count_tRowGenerator_1++;

					/**
					 * [tRowGenerator_1 main ] stop
					 */

					/**
					 * [tJDBCOutput_6 main ] start
					 */

					currentComponent = "tJDBCOutput_6";

					whetherReject_tJDBCOutput_6 = false;
					if (row11.var_datetime != null) {
						pstmt_tJDBCOutput_6.setTimestamp(
								1,
								new java.sql.Timestamp(row11.var_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_6.setNull(1, java.sql.Types.DATE);
					}

					if (row11.var_name == null) {
						pstmt_tJDBCOutput_6.setNull(2, java.sql.Types.VARCHAR);
					} else {
						pstmt_tJDBCOutput_6.setString(2, row11.var_name);
					}

					try {
						updatedCount_tJDBCOutput_6 = updatedCount_tJDBCOutput_6
								+ pstmt_tJDBCOutput_6.executeUpdate();
						nb_line_tJDBCOutput_6++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_6 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_6++;

					/**
					 * [tJDBCOutput_6 main ] stop
					 */

					/**
					 * [tRowGenerator_1 end ] start
					 */

					currentComponent = "tRowGenerator_1";

				}
				globalMap.put("tRowGenerator_1_NB_LINE",
						nb_line_tRowGenerator_1);

				ok_Hash.put("tRowGenerator_1", true);
				end_Hash.put("tRowGenerator_1", System.currentTimeMillis());

				/**
				 * [tRowGenerator_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_6 end ] start
				 */

				currentComponent = "tJDBCOutput_6";

				if (pstmt_tJDBCOutput_6 != null) {

					pstmt_tJDBCOutput_6.close();

				}

				nb_line_deleted_tJDBCOutput_6 = nb_line_deleted_tJDBCOutput_6
						+ deletedCount_tJDBCOutput_6;
				nb_line_update_tJDBCOutput_6 = nb_line_update_tJDBCOutput_6
						+ updatedCount_tJDBCOutput_6;
				nb_line_inserted_tJDBCOutput_6 = nb_line_inserted_tJDBCOutput_6
						+ insertedCount_tJDBCOutput_6;
				nb_line_rejected_tJDBCOutput_6 = nb_line_rejected_tJDBCOutput_6
						+ rejectedCount_tJDBCOutput_6;

				globalMap.put("tJDBCOutput_6_NB_LINE", nb_line_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_6);

				ok_Hash.put("tJDBCOutput_6", true);
				end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_6 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_1 finally ] start
				 */

				currentComponent = "tRowGenerator_1";

				/**
				 * [tRowGenerator_1 finally ] stop
				 */

				/**
				 * [tJDBCOutput_6 finally ] start
				 */

				currentComponent = "tJDBCOutput_6";

				/**
				 * [tJDBCOutput_6 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_1_SUBPROCESS_STATE", 1);
	}

	public static class row15Struct implements
			routines.system.IPersistableRow<row15Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String disks_usage;

		public String getDisks_usage() {
			return this.disks_usage;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.disks_usage = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.disks_usage, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",disks_usage=" + disks_usage);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row15Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_9 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_9> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String disks_usage;

		public String getDisks_usage() {
			return this.disks_usage;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.disks_usage = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.disks_usage, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",disks_usage=" + disks_usage);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_9 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class disks_usage_aggregateStruct implements
			routines.system.IPersistableRow<disks_usage_aggregateStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String disks_usage;

		public String getDisks_usage() {
			return this.disks_usage;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.disks_usage = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.disks_usage, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",disks_usage=" + disks_usage);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(disks_usage_aggregateStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row12Struct implements
			routines.system.IPersistableRow<row12Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String disks_usage;

		public String getDisks_usage() {
			return this.disks_usage;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.disks_usage = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.disks_usage, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",disks_usage=" + disks_usage);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row12Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_9Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row12Struct row12 = new row12Struct();
				disks_usage_aggregateStruct disks_usage_aggregate = new disks_usage_aggregateStruct();
				row15Struct row15 = new row15Struct();

				/**
				 * [tAggregateRow_9_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_9_AGGOUT", false);
				start_Hash.put("tAggregateRow_9_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_9";

				currentComponent = "tAggregateRow_9_AGGOUT";

				int tos_count_tAggregateRow_9_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_9 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_9 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_9 utilClass_tAggregateRow_9 = new UtilClass_tAggregateRow_9();

				class AggOperationStruct_tAggregateRow_9 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object vm_id;
					String disks_usage_first;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.vm_id == null) ? 0 : this.vm_id
											.hashCode());

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_9 other = (AggOperationStruct_tAggregateRow_9) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.vm_id == null) {
							if (other.vm_id != null)
								return false;
						} else if (!this.vm_id.equals(other.vm_id))
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_9 operation_result_tAggregateRow_9 = null;
				AggOperationStruct_tAggregateRow_9 operation_finder_tAggregateRow_9 = new AggOperationStruct_tAggregateRow_9();
				java.util.Map<AggOperationStruct_tAggregateRow_9, AggOperationStruct_tAggregateRow_9> hash_tAggregateRow_9 = new java.util.HashMap<AggOperationStruct_tAggregateRow_9, AggOperationStruct_tAggregateRow_9>();

				/**
				 * [tAggregateRow_9_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_9 begin ] start
				 */

				ok_Hash.put("tMap_9", false);
				start_Hash.put("tMap_9", System.currentTimeMillis());

				currentComponent = "tMap_9";

				int tos_count_tMap_9 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_9__Struct {
				}
				Var__tMap_9__Struct Var__tMap_9 = new Var__tMap_9__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				disks_usage_aggregateStruct disks_usage_aggregate_tmp = new disks_usage_aggregateStruct();
				// ###############################

				/**
				 * [tMap_9 begin ] stop
				 */

				/**
				 * [tJDBCInput_9 begin ] start
				 */

				ok_Hash.put("tJDBCInput_9", false);
				start_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				currentComponent = "tJDBCInput_9";

				int tos_count_tJDBCInput_9 = 0;

				int nb_line_tJDBCInput_9 = 0;
				java.sql.Connection conn_tJDBCInput_9 = null;
				conn_tJDBCInput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_9 = conn_tJDBCInput_9
						.createStatement();

				String dbquery_tJDBCInput_9 = "SELECT\n  history_datetime,\n  vm_id,\n  disks_usage\nFROM vm_disks_usage_hourly_history\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\nAND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY history_id DESC,\n         vm_id";

				globalMap.put("tJDBCInput_9_QUERY", dbquery_tJDBCInput_9);

				java.sql.ResultSet rs_tJDBCInput_9 = null;
				try {
					rs_tJDBCInput_9 = stmt_tJDBCInput_9
							.executeQuery(dbquery_tJDBCInput_9);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_9 = rs_tJDBCInput_9
							.getMetaData();
					int colQtyInRs_tJDBCInput_9 = rsmd_tJDBCInput_9
							.getColumnCount();

					String tmpContent_tJDBCInput_9 = null;

					while (rs_tJDBCInput_9.next()) {
						nb_line_tJDBCInput_9++;

						if (colQtyInRs_tJDBCInput_9 < 1) {
							row12.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_9 = null;
							try {
								date_tJDBCInput_9 = rs_tJDBCInput_9
										.getTimestamp(1);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_9 = rs_tJDBCInput_9.getDate(1);
							}
							row12.history_datetime = date_tJDBCInput_9;
						}
						if (colQtyInRs_tJDBCInput_9 < 2) {
							row12.vm_id = null;
						} else {

							if (rs_tJDBCInput_9.getObject(2) != null) {
								row12.vm_id = rs_tJDBCInput_9.getObject(2);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_9 < 3) {
							row12.disks_usage = null;
						} else {

							row12.disks_usage = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 3, false);
						}

						/**
						 * [tJDBCInput_9 begin ] stop
						 */

						/**
						 * [tJDBCInput_9 main ] start
						 */

						currentComponent = "tJDBCInput_9";

						tos_count_tJDBCInput_9++;

						/**
						 * [tJDBCInput_9 main ] stop
						 */

						/**
						 * [tMap_9 main ] start
						 */

						currentComponent = "tMap_9";

						boolean hasCasePrimitiveKeyWithNull_tMap_9 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_9 = false;
						boolean mainRowRejected_tMap_9 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_9__Struct Var = Var__tMap_9;// ###############################
							// ###############################
							// # Output tables

							disks_usage_aggregate = null;

							// # Output table : 'disks_usage_aggregate'
							disks_usage_aggregate_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row12.history_datetime);
							disks_usage_aggregate_tmp.vm_id = row12.vm_id;
							disks_usage_aggregate_tmp.disks_usage = row12.disks_usage;
							disks_usage_aggregate = disks_usage_aggregate_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_9 = false;

						tos_count_tMap_9++;

						/**
						 * [tMap_9 main ] stop
						 */
						// Start of branch "disks_usage_aggregate"
						if (disks_usage_aggregate != null) {

							/**
							 * [tAggregateRow_9_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_9";

							currentComponent = "tAggregateRow_9_AGGOUT";

							operation_finder_tAggregateRow_9.history_datetime = disks_usage_aggregate.history_datetime;
							operation_finder_tAggregateRow_9.vm_id = disks_usage_aggregate.vm_id;

							operation_finder_tAggregateRow_9.hashCodeDirty = true;

							operation_result_tAggregateRow_9 = hash_tAggregateRow_9
									.get(operation_finder_tAggregateRow_9);

							boolean isFirstAdd_tAggregateRow_9 = false;

							if (operation_result_tAggregateRow_9 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_9 = new AggOperationStruct_tAggregateRow_9();

								operation_result_tAggregateRow_9.history_datetime = operation_finder_tAggregateRow_9.history_datetime;
								operation_result_tAggregateRow_9.vm_id = operation_finder_tAggregateRow_9.vm_id;

								isFirstAdd_tAggregateRow_9 = true;

								hash_tAggregateRow_9.put(
										operation_result_tAggregateRow_9,
										operation_result_tAggregateRow_9);

							} // G_OutMain_AggR_001

							if (disks_usage_aggregate.disks_usage != null) { // G_OutMain_AggR_546

								if (isFirstAdd_tAggregateRow_9
										|| operation_result_tAggregateRow_9.disks_usage_first == null) {
									operation_result_tAggregateRow_9.disks_usage_first = disks_usage_aggregate.disks_usage;
								}

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_9_AGGOUT++;

							/**
							 * [tAggregateRow_9_AGGOUT main ] stop
							 */

						} // End of branch "disks_usage_aggregate"

						/**
						 * [tJDBCInput_9 end ] start
						 */

						currentComponent = "tJDBCInput_9";

					}
				} finally {
					if (rs_tJDBCInput_9 != null) {
						rs_tJDBCInput_9.close();
					}
					stmt_tJDBCInput_9.close();

				}
				globalMap.put("tJDBCInput_9_NB_LINE", nb_line_tJDBCInput_9);

				ok_Hash.put("tJDBCInput_9", true);
				end_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				/**
				 * [tJDBCInput_9 end ] stop
				 */

				/**
				 * [tMap_9 end ] start
				 */

				currentComponent = "tMap_9";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_9", true);
				end_Hash.put("tMap_9", System.currentTimeMillis());

				/**
				 * [tMap_9 end ] stop
				 */

				/**
				 * [tAggregateRow_9_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_9";

				currentComponent = "tAggregateRow_9_AGGOUT";

				ok_Hash.put("tAggregateRow_9_AGGOUT", true);
				end_Hash.put("tAggregateRow_9_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_9_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_9 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_9", false);
				start_Hash.put("tJDBCOutput_9", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_9";

				int tos_count_tJDBCOutput_9 = 0;

				int nb_line_tJDBCOutput_9 = 0;
				int nb_line_update_tJDBCOutput_9 = 0;
				int nb_line_inserted_tJDBCOutput_9 = 0;
				int nb_line_deleted_tJDBCOutput_9 = 0;
				int nb_line_rejected_tJDBCOutput_9 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_9 = 0;

				int deletedCount_tJDBCOutput_9 = 0;
				int updatedCount_tJDBCOutput_9 = 0;
				int insertedCount_tJDBCOutput_9 = 0;
				int rejectedCount_tJDBCOutput_9 = 0;

				boolean whetherReject_tJDBCOutput_9 = false;

				java.sql.Connection connection_tJDBCOutput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_9 = "INSERT INTO "
						+ "vm_disks_usage_daily_history"
						+ " (history_datetime,vm_id,disks_usage) VALUES (?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_9 = connection_tJDBCOutput_9
						.prepareStatement(insert_tJDBCOutput_9);

				/**
				 * [tJDBCOutput_9 begin ] stop
				 */

				/**
				 * [tAggregateRow_9_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_9_AGGIN", false);
				start_Hash.put("tAggregateRow_9_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_9";

				currentComponent = "tAggregateRow_9_AGGIN";

				int tos_count_tAggregateRow_9_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_9> values_tAggregateRow_9 = hash_tAggregateRow_9
						.values();

				globalMap.put("tAggregateRow_9_NB_LINE",
						values_tAggregateRow_9.size());

				for (AggOperationStruct_tAggregateRow_9 aggregated_row_tAggregateRow_9 : values_tAggregateRow_9) { // G_AggR_600

					/**
					 * [tAggregateRow_9_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_9_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_9";

					currentComponent = "tAggregateRow_9_AGGIN";

					row15.history_datetime = aggregated_row_tAggregateRow_9.history_datetime;

					row15.vm_id = aggregated_row_tAggregateRow_9.vm_id;

					row15.disks_usage = aggregated_row_tAggregateRow_9.disks_usage_first;

					tos_count_tAggregateRow_9_AGGIN++;

					/**
					 * [tAggregateRow_9_AGGIN main ] stop
					 */

					/**
					 * [tJDBCOutput_9 main ] start
					 */

					currentComponent = "tJDBCOutput_9";

					whetherReject_tJDBCOutput_9 = false;
					if (row15.history_datetime != null) {
						pstmt_tJDBCOutput_9.setTimestamp(
								1,
								new java.sql.Timestamp(row15.history_datetime
										.getTime()));
					} else {
						pstmt_tJDBCOutput_9.setNull(1, java.sql.Types.DATE);
					}

					if (row15.vm_id == null) {
						pstmt_tJDBCOutput_9.setNull(2, java.sql.Types.OTHER);
					} else {
						pstmt_tJDBCOutput_9.setObject(2, row15.vm_id);
					}

					if (row15.disks_usage == null) {
						pstmt_tJDBCOutput_9.setNull(3, java.sql.Types.VARCHAR);
					} else {
						pstmt_tJDBCOutput_9.setString(3, row15.disks_usage);
					}

					try {
						insertedCount_tJDBCOutput_9 = insertedCount_tJDBCOutput_9
								+ pstmt_tJDBCOutput_9.executeUpdate();
						nb_line_tJDBCOutput_9++;
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_9 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_9++;

					/**
					 * [tJDBCOutput_9 main ] stop
					 */

					/**
					 * [tAggregateRow_9_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_9";

					currentComponent = "tAggregateRow_9_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_9_AGGIN", true);
				end_Hash.put("tAggregateRow_9_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_9_AGGIN end ] stop
				 */

				/**
				 * [tJDBCOutput_9 end ] start
				 */

				currentComponent = "tJDBCOutput_9";

				if (pstmt_tJDBCOutput_9 != null) {

					pstmt_tJDBCOutput_9.close();

				}

				nb_line_deleted_tJDBCOutput_9 = nb_line_deleted_tJDBCOutput_9
						+ deletedCount_tJDBCOutput_9;
				nb_line_update_tJDBCOutput_9 = nb_line_update_tJDBCOutput_9
						+ updatedCount_tJDBCOutput_9;
				nb_line_inserted_tJDBCOutput_9 = nb_line_inserted_tJDBCOutput_9
						+ insertedCount_tJDBCOutput_9;
				nb_line_rejected_tJDBCOutput_9 = nb_line_rejected_tJDBCOutput_9
						+ rejectedCount_tJDBCOutput_9;

				globalMap.put("tJDBCOutput_9_NB_LINE", nb_line_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_9);

				ok_Hash.put("tJDBCOutput_9", true);
				end_Hash.put("tJDBCOutput_9", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_9 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_9_AGGIN"
			globalMap.remove("tAggregateRow_9");

			try {

				/**
				 * [tJDBCInput_9 finally ] start
				 */

				currentComponent = "tJDBCInput_9";

				/**
				 * [tJDBCInput_9 finally ] stop
				 */

				/**
				 * [tMap_9 finally ] start
				 */

				currentComponent = "tMap_9";

				/**
				 * [tMap_9 finally ] stop
				 */

				/**
				 * [tAggregateRow_9_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_9";

				currentComponent = "tAggregateRow_9_AGGOUT";

				/**
				 * [tAggregateRow_9_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_9_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_9";

				currentComponent = "tAggregateRow_9_AGGIN";

				/**
				 * [tAggregateRow_9_AGGIN finally ] stop
				 */

				/**
				 * [tJDBCOutput_9 finally ] start
				 */

				currentComponent = "tJDBCOutput_9";

				/**
				 * [tJDBCOutput_9 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 1);
	}

	public static class complete_aggregate_usersStruct implements
			routines.system.IPersistableRow<complete_aggregate_usersStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String user_name;

		public String getUser_name() {
			return this.user_name;
		}

		public Boolean user_logged_in_to_guest;

		public Boolean getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public double session_time_in_minutes;

		public double getSession_time_in_minutes() {
			return this.session_time_in_minutes;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short max_cpu_usage;

		public Short getMax_cpu_usage() {
			return this.max_cpu_usage;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short max_memory_usage;

		public Short getMax_memory_usage() {
			return this.max_memory_usage;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short max_user_cpu_usage_percent;

		public Short getMax_user_cpu_usage_percent() {
			return this.max_user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short max_system_cpu_usage_percent;

		public Short getMax_system_cpu_usage_percent() {
			return this.max_system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.user_id = (Object) dis.readObject();

					this.user_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readBoolean();
					}

					this.vm_id = (Object) dis.readObject();

					this.session_time_in_minutes = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_cpu_usage = null;
					} else {
						this.max_cpu_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_usage = null;
					} else {
						this.max_memory_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_user_cpu_usage_percent = null;
					} else {
						this.max_user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_system_cpu_usage_percent = null;
					} else {
						this.max_system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.user_name, dos);

				// Boolean

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.vm_id);

				// double

				dos.writeDouble(this.session_time_in_minutes);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.max_cpu_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_cpu_usage);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.max_memory_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_memory_usage);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.max_user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.max_system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",user_id=" + String.valueOf(user_id));
			sb.append(",user_name=" + user_name);
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",session_time_in_minutes="
					+ String.valueOf(session_time_in_minutes));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",max_cpu_usage=" + String.valueOf(max_cpu_usage));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",max_memory_usage=" + String.valueOf(max_memory_usage));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",max_user_cpu_usage_percent="
					+ String.valueOf(max_user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",max_system_cpu_usage_percent="
					+ String.valueOf(max_system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(complete_aggregate_usersStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row14Struct implements
			routines.system.IPersistableRow<row14Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String user_name;

		public String getUser_name() {
			return this.user_name;
		}

		public Short user_logged_in_to_guest;

		public Short getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public double session_time_in_minutes;

		public double getSession_time_in_minutes() {
			return this.session_time_in_minutes;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short max_cpu_usage;

		public Short getMax_cpu_usage() {
			return this.max_cpu_usage;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short max_memory_usage;

		public Short getMax_memory_usage() {
			return this.max_memory_usage;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short max_user_cpu_usage_percent;

		public Short getMax_user_cpu_usage_percent() {
			return this.max_user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short max_system_cpu_usage_percent;

		public Short getMax_system_cpu_usage_percent() {
			return this.max_system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.user_id = (Object) dis.readObject();

					this.user_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readShort();
					}

					this.vm_id = (Object) dis.readObject();

					this.session_time_in_minutes = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_cpu_usage = null;
					} else {
						this.max_cpu_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_usage = null;
					} else {
						this.max_memory_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_user_cpu_usage_percent = null;
					} else {
						this.max_user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_system_cpu_usage_percent = null;
					} else {
						this.max_system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.user_name, dos);

				// Short

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.vm_id);

				// double

				dos.writeDouble(this.session_time_in_minutes);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.max_cpu_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_cpu_usage);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.max_memory_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_memory_usage);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.max_user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.max_system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",user_id=" + String.valueOf(user_id));
			sb.append(",user_name=" + user_name);
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",session_time_in_minutes="
					+ String.valueOf(session_time_in_minutes));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",max_cpu_usage=" + String.valueOf(max_cpu_usage));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",max_memory_usage=" + String.valueOf(max_memory_usage));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",max_user_cpu_usage_percent="
					+ String.valueOf(max_user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",max_system_cpu_usage_percent="
					+ String.valueOf(max_system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row14Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class OnRowsEndStructtAggregateRow_8 implements
			routines.system.IPersistableRow<OnRowsEndStructtAggregateRow_8> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String user_name;

		public String getUser_name() {
			return this.user_name;
		}

		public Short user_logged_in_to_guest;

		public Short getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public double session_time_in_minutes;

		public double getSession_time_in_minutes() {
			return this.session_time_in_minutes;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short max_cpu_usage;

		public Short getMax_cpu_usage() {
			return this.max_cpu_usage;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short max_memory_usage;

		public Short getMax_memory_usage() {
			return this.max_memory_usage;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short max_user_cpu_usage_percent;

		public Short getMax_user_cpu_usage_percent() {
			return this.max_user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short max_system_cpu_usage_percent;

		public Short getMax_system_cpu_usage_percent() {
			return this.max_system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.user_id = (Object) dis.readObject();

					this.user_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readShort();
					}

					this.vm_id = (Object) dis.readObject();

					this.session_time_in_minutes = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_cpu_usage = null;
					} else {
						this.max_cpu_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_memory_usage = null;
					} else {
						this.max_memory_usage = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_user_cpu_usage_percent = null;
					} else {
						this.max_user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.max_system_cpu_usage_percent = null;
					} else {
						this.max_system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.user_name, dos);

				// Short

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.vm_id);

				// double

				dos.writeDouble(this.session_time_in_minutes);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.max_cpu_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_cpu_usage);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.max_memory_usage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_memory_usage);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.max_user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.max_system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.max_system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",user_id=" + String.valueOf(user_id));
			sb.append(",user_name=" + user_name);
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",session_time_in_minutes="
					+ String.valueOf(session_time_in_minutes));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",max_cpu_usage=" + String.valueOf(max_cpu_usage));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",max_memory_usage=" + String.valueOf(max_memory_usage));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",max_user_cpu_usage_percent="
					+ String.valueOf(max_user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",max_system_cpu_usage_percent="
					+ String.valueOf(max_system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(OnRowsEndStructtAggregateRow_8 other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class copyOfvm_aggregate_historyStruct implements
			routines.system.IPersistableRow<copyOfvm_aggregate_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String user_name;

		public String getUser_name() {
			return this.user_name;
		}

		public Short user_logged_in_to_guest;

		public Short getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public double session_time_in_minutes;

		public double getSession_time_in_minutes() {
			return this.session_time_in_minutes;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.user_id = (Object) dis.readObject();

					this.user_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readShort();
					}

					this.vm_id = (Object) dis.readObject();

					this.session_time_in_minutes = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.user_name, dos);

				// Short

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.vm_id);

				// double

				dos.writeDouble(this.session_time_in_minutes);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",user_id=" + String.valueOf(user_id));
			sb.append(",user_name=" + user_name);
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",session_time_in_minutes="
					+ String.valueOf(session_time_in_minutes));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(copyOfvm_aggregate_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row13Struct implements
			routines.system.IPersistableRow<row13Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String user_name;

		public String getUser_name() {
			return this.user_name;
		}

		public Short user_logged_in_to_guest;

		public Short getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public double session_time_in_minutes;

		public double getSession_time_in_minutes() {
			return this.session_time_in_minutes;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

					this.history_datetime = readDate(dis);

					this.user_id = (Object) dis.readObject();

					this.user_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readShort();
					}

					this.vm_id = (Object) dis.readObject();

					this.session_time_in_minutes = dis.readDouble();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.user_name, dos);

				// Short

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.vm_id);

				// double

				dos.writeDouble(this.session_time_in_minutes);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",history_datetime=" + String.valueOf(history_datetime));
			sb.append(",user_id=" + String.valueOf(user_id));
			sb.append(",user_name=" + user_name);
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",session_time_in_minutes="
					+ String.valueOf(session_time_in_minutes));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row13Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_10Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row13Struct row13 = new row13Struct();
				copyOfvm_aggregate_historyStruct copyOfvm_aggregate_history = new copyOfvm_aggregate_historyStruct();
				row14Struct row14 = new row14Struct();
				complete_aggregate_usersStruct complete_aggregate_users = new complete_aggregate_usersStruct();

				/**
				 * [tAggregateRow_8_AGGOUT begin ] start
				 */

				ok_Hash.put("tAggregateRow_8_AGGOUT", false);
				start_Hash.put("tAggregateRow_8_AGGOUT",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_8";

				currentComponent = "tAggregateRow_8_AGGOUT";

				int tos_count_tAggregateRow_8_AGGOUT = 0;

				// ------------

				java.util.Map hashAggreg_tAggregateRow_8 = new java.util.HashMap();

				// ------------

				class UtilClass_tAggregateRow_8 { // G_OutBegin_AggR_144

					public double sd(Double[] data) {
						final int n = data.length;
						if (n < 2) {
							return Double.NaN;
						}
						double d1 = 0d;
						double d2 = 0d;

						for (int i = 0; i < data.length; i++) {
							d1 += (data[i] * data[i]);
							d2 += data[i];
						}

						return Math.sqrt((n * d1 - d2 * d2) / n / (n - 1));
					}

					public void checkedIADD(byte a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						byte r = (byte) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'short/Short'", "'int/Integer'"));
						}
					}

					public void checkedIADD(short a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						short r = (short) (a + b);
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'int/Integer'", "'short/Short'"));
						}
					}

					public void checkedIADD(int a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						int r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'long/Long'", "'int/Integer'"));
						}
					}

					public void checkedIADD(long a, long b,
							boolean checkTypeOverFlow, boolean checkUlp) {
						long r = a + b;
						if (checkTypeOverFlow && ((a ^ r) & (b ^ r)) < 0) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'long/Long'"));
						}
					}

					public void checkedIADD(float a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							float minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(b),
												"'double' or 'BigDecimal'",
												"'float/Float'"));
							}
						}

						if (checkTypeOverFlow
								&& ((double) a + (double) b > (double) Float.MAX_VALUE)
								|| ((double) a + (double) b < (double) -Float.MAX_VALUE)) {
							throw new RuntimeException(
									buildOverflowMessage(String.valueOf(a),
											String.valueOf(b),
											"'double' or 'BigDecimal'",
											"'float/Float'"));
						}
					}

					public void checkedIADD(double a, double b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, byte b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, short b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, int b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					public void checkedIADD(double a, float b,
							boolean checkTypeOverFlow, boolean checkUlp) {

						if (checkUlp) {
							double minAddedValue = Math.ulp(a);
							if (minAddedValue > Math.abs(b)) {
								throw new RuntimeException(
										buildPrecisionMessage(
												String.valueOf(a),
												String.valueOf(a),
												"'BigDecimal'",
												"'double/Double'"));
							}
						}

						if (checkTypeOverFlow
								&& (a + b > (double) Double.MAX_VALUE)
								|| (a + b < -Double.MAX_VALUE)) {
							throw new RuntimeException(buildOverflowMessage(
									String.valueOf(a), String.valueOf(b),
									"'BigDecimal'", "'double/Double'"));
						}
					}

					private String buildOverflowMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "Type overflow when adding "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes + " type in place of "
								+ originalType + ".";
					}

					private String buildPrecisionMessage(String a, String b,
							String advicedTypes, String originalType) {
						return "The double precision is unsufficient to add the value "
								+ b
								+ " to "
								+ a
								+ ", to resolve this problem, increase the precision by using "
								+ advicedTypes
								+ " type in place of "
								+ originalType + ".";
					}

				} // G_OutBegin_AggR_144

				UtilClass_tAggregateRow_8 utilClass_tAggregateRow_8 = new UtilClass_tAggregateRow_8();

				class AggOperationStruct_tAggregateRow_8 { // G_OutBegin_AggR_100

					private static final int DEFAULT_HASHCODE = 1;
					private static final int PRIME = 31;
					private int hashCode = DEFAULT_HASHCODE;
					public boolean hashCodeDirty = true;

					java.util.Date history_datetime;
					Object user_id;
					String user_name;
					Object vm_id;
					BigDecimal session_time_in_minutes_sum;

					Double cpu_usage_percent_sum;
					int cpu_usage_percent_count = 0;

					Short max_cpu_usage_max;
					Double memory_usage_percent_sum;
					int memory_usage_percent_count = 0;

					Short max_memory_usage_max;
					Double user_cpu_usage_percent_sum;
					int user_cpu_usage_percent_count = 0;

					Short max_user_cpu_usage_percent_max;
					Double system_cpu_usage_percent_sum;
					int system_cpu_usage_percent_count = 0;

					Short max_system_cpu_usage_percent_max;
					String vm_ip_last;
					String vm_client_ip_last;
					Object currently_running_on_host_last;
					Integer vm_configuration_version_last;
					Integer current_host_configuration_version_last;
					Short user_logged_in_to_guest_last;

					@Override
					public int hashCode() {
						if (this.hashCodeDirty) {
							final int prime = PRIME;
							int result = DEFAULT_HASHCODE;

							result = prime
									* result
									+ ((this.history_datetime == null) ? 0
											: this.history_datetime.hashCode());

							result = prime
									* result
									+ ((this.user_id == null) ? 0
											: this.user_id.hashCode());

							result = prime
									* result
									+ ((this.user_name == null) ? 0
											: this.user_name.hashCode());

							result = prime
									* result
									+ ((this.vm_id == null) ? 0 : this.vm_id
											.hashCode());

							this.hashCode = result;
							this.hashCodeDirty = false;
						}
						return this.hashCode;
					}

					@Override
					public boolean equals(Object obj) {
						if (this == obj)
							return true;
						if (obj == null)
							return false;
						if (getClass() != obj.getClass())
							return false;
						final AggOperationStruct_tAggregateRow_8 other = (AggOperationStruct_tAggregateRow_8) obj;

						if (this.history_datetime == null) {
							if (other.history_datetime != null)
								return false;
						} else if (!this.history_datetime
								.equals(other.history_datetime))
							return false;

						if (this.user_id == null) {
							if (other.user_id != null)
								return false;
						} else if (!this.user_id.equals(other.user_id))
							return false;

						if (this.user_name == null) {
							if (other.user_name != null)
								return false;
						} else if (!this.user_name.equals(other.user_name))
							return false;

						if (this.vm_id == null) {
							if (other.vm_id != null)
								return false;
						} else if (!this.vm_id.equals(other.vm_id))
							return false;

						return true;
					}

				} // G_OutBegin_AggR_100

				AggOperationStruct_tAggregateRow_8 operation_result_tAggregateRow_8 = null;
				AggOperationStruct_tAggregateRow_8 operation_finder_tAggregateRow_8 = new AggOperationStruct_tAggregateRow_8();
				java.util.Map<AggOperationStruct_tAggregateRow_8, AggOperationStruct_tAggregateRow_8> hash_tAggregateRow_8 = new java.util.HashMap<AggOperationStruct_tAggregateRow_8, AggOperationStruct_tAggregateRow_8>();

				/**
				 * [tAggregateRow_8_AGGOUT begin ] stop
				 */

				/**
				 * [tMap_10 begin ] start
				 */

				ok_Hash.put("tMap_10", false);
				start_Hash.put("tMap_10", System.currentTimeMillis());

				currentComponent = "tMap_10";

				int tos_count_tMap_10 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_10__Struct {
				}
				Var__tMap_10__Struct Var__tMap_10 = new Var__tMap_10__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				copyOfvm_aggregate_historyStruct copyOfvm_aggregate_history_tmp = new copyOfvm_aggregate_historyStruct();
				// ###############################

				/**
				 * [tMap_10 begin ] stop
				 */

				/**
				 * [tJDBCInput_10 begin ] start
				 */

				ok_Hash.put("tJDBCInput_10", false);
				start_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				currentComponent = "tJDBCInput_10";

				int tos_count_tJDBCInput_10 = 0;

				int nb_line_tJDBCInput_10 = 0;
				java.sql.Connection conn_tJDBCInput_10 = null;
				conn_tJDBCInput_10 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_10 = conn_tJDBCInput_10
						.createStatement();

				String dbquery_tJDBCInput_10 = "SELECT\n  history_id,\n  history_datetime,\n  user_id,\n  user_name,\n  cast(user_logged_in_to_guest as int),\n  vm_id,\n  session_time_in_minutes,\n  cpu_usage_percent,\n  memory_usage_percent,\n  user_cpu_usage_percent,\n  system_cpu_usage_percent,\n  vm_ip,\n  vm_client_ip,\n  currently_running_on_host,\n  vm_configuration_version,\n  current_host_configuration_version\nFROM statistics_vms_users_usage_hourly\nWHERE history_datetime >= '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(context.lastDayAggr)
						+ "'\n	AND history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.lastDayAggr,
										1, "dd"))
						+ "'\nORDER BY\n    history_datetime,\n    user_name,\n    vm_id";

				globalMap.put("tJDBCInput_10_QUERY", dbquery_tJDBCInput_10);

				java.sql.ResultSet rs_tJDBCInput_10 = null;
				try {
					rs_tJDBCInput_10 = stmt_tJDBCInput_10
							.executeQuery(dbquery_tJDBCInput_10);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_10 = rs_tJDBCInput_10
							.getMetaData();
					int colQtyInRs_tJDBCInput_10 = rsmd_tJDBCInput_10
							.getColumnCount();

					String tmpContent_tJDBCInput_10 = null;

					while (rs_tJDBCInput_10.next()) {
						nb_line_tJDBCInput_10++;

						if (colQtyInRs_tJDBCInput_10 < 1) {
							row13.history_id = 0;
						} else {

							if (rs_tJDBCInput_10.getObject(1) != null) {
								row13.history_id = rs_tJDBCInput_10.getLong(1);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 2) {
							row13.history_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_10 = null;
							try {
								date_tJDBCInput_10 = rs_tJDBCInput_10
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_10 = rs_tJDBCInput_10
										.getDate(2);
							}
							row13.history_datetime = date_tJDBCInput_10;
						}
						if (colQtyInRs_tJDBCInput_10 < 3) {
							row13.user_id = null;
						} else {

							if (rs_tJDBCInput_10.getObject(3) != null) {
								row13.user_id = rs_tJDBCInput_10.getObject(3);
							} else {
								row13.user_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 4) {
							row13.user_name = null;
						} else {

							row13.user_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_10, 4, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 5) {
							row13.user_logged_in_to_guest = null;
						} else {

							if (rs_tJDBCInput_10.getObject(5) != null) {
								row13.user_logged_in_to_guest = rs_tJDBCInput_10
										.getShort(5);
							} else {
								row13.user_logged_in_to_guest = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 6) {
							row13.vm_id = null;
						} else {

							if (rs_tJDBCInput_10.getObject(6) != null) {
								row13.vm_id = rs_tJDBCInput_10.getObject(6);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 7) {
							row13.session_time_in_minutes = 0;
						} else {

							if (rs_tJDBCInput_10.getObject(7) != null) {
								row13.session_time_in_minutes = rs_tJDBCInput_10
										.getDouble(7);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 8) {
							row13.cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(8) != null) {
								row13.cpu_usage_percent = rs_tJDBCInput_10
										.getShort(8);
							} else {
								row13.cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 9) {
							row13.memory_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(9) != null) {
								row13.memory_usage_percent = rs_tJDBCInput_10
										.getShort(9);
							} else {
								row13.memory_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 10) {
							row13.user_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(10) != null) {
								row13.user_cpu_usage_percent = rs_tJDBCInput_10
										.getShort(10);
							} else {
								row13.user_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 11) {
							row13.system_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(11) != null) {
								row13.system_cpu_usage_percent = rs_tJDBCInput_10
										.getShort(11);
							} else {
								row13.system_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 12) {
							row13.vm_ip = null;
						} else {

							row13.vm_ip = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_10, 12, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 13) {
							row13.vm_client_ip = null;
						} else {

							row13.vm_client_ip = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_10, 13, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 14) {
							row13.currently_running_on_host = null;
						} else {

							if (rs_tJDBCInput_10.getObject(14) != null) {
								row13.currently_running_on_host = rs_tJDBCInput_10
										.getObject(14);
							} else {
								row13.currently_running_on_host = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 15) {
							row13.vm_configuration_version = null;
						} else {

							if (rs_tJDBCInput_10.getObject(15) != null) {
								row13.vm_configuration_version = rs_tJDBCInput_10
										.getInt(15);
							} else {
								row13.vm_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 16) {
							row13.current_host_configuration_version = null;
						} else {

							if (rs_tJDBCInput_10.getObject(16) != null) {
								row13.current_host_configuration_version = rs_tJDBCInput_10
										.getInt(16);
							} else {
								row13.current_host_configuration_version = null;
							}
						}

						/**
						 * [tJDBCInput_10 begin ] stop
						 */

						/**
						 * [tJDBCInput_10 main ] start
						 */

						currentComponent = "tJDBCInput_10";

						tos_count_tJDBCInput_10++;

						/**
						 * [tJDBCInput_10 main ] stop
						 */

						/**
						 * [tMap_10 main ] start
						 */

						currentComponent = "tMap_10";

						boolean hasCasePrimitiveKeyWithNull_tMap_10 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_10 = false;
						boolean mainRowRejected_tMap_10 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_10__Struct Var = Var__tMap_10;// ###############################
							// ###############################
							// # Output tables

							copyOfvm_aggregate_history = null;

							// # Output table : 'copyOfvm_aggregate_history'
							copyOfvm_aggregate_history_tmp.history_datetime = RoutineHistoryETL
									.startOfDay(row13.history_datetime);
							copyOfvm_aggregate_history_tmp.user_id = row13.user_id;
							copyOfvm_aggregate_history_tmp.user_name = row13.user_name;
							copyOfvm_aggregate_history_tmp.user_logged_in_to_guest = row13.user_logged_in_to_guest;
							copyOfvm_aggregate_history_tmp.vm_id = row13.vm_id;
							copyOfvm_aggregate_history_tmp.session_time_in_minutes = row13.session_time_in_minutes;
							copyOfvm_aggregate_history_tmp.cpu_usage_percent = row13.cpu_usage_percent;
							copyOfvm_aggregate_history_tmp.memory_usage_percent = row13.memory_usage_percent;
							copyOfvm_aggregate_history_tmp.user_cpu_usage_percent = row13.user_cpu_usage_percent;
							copyOfvm_aggregate_history_tmp.system_cpu_usage_percent = row13.system_cpu_usage_percent;
							copyOfvm_aggregate_history_tmp.vm_ip = row13.vm_ip;
							copyOfvm_aggregate_history_tmp.vm_client_ip = row13.vm_client_ip;
							copyOfvm_aggregate_history_tmp.currently_running_on_host = row13.currently_running_on_host;
							copyOfvm_aggregate_history_tmp.vm_configuration_version = row13.vm_configuration_version;
							copyOfvm_aggregate_history_tmp.current_host_configuration_version = row13.current_host_configuration_version;
							copyOfvm_aggregate_history = copyOfvm_aggregate_history_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_10 = false;

						tos_count_tMap_10++;

						/**
						 * [tMap_10 main ] stop
						 */
						// Start of branch "copyOfvm_aggregate_history"
						if (copyOfvm_aggregate_history != null) {

							/**
							 * [tAggregateRow_8_AGGOUT main ] start
							 */

							currentVirtualComponent = "tAggregateRow_8";

							currentComponent = "tAggregateRow_8_AGGOUT";

							operation_finder_tAggregateRow_8.history_datetime = copyOfvm_aggregate_history.history_datetime;
							operation_finder_tAggregateRow_8.user_id = copyOfvm_aggregate_history.user_id;
							operation_finder_tAggregateRow_8.user_name = copyOfvm_aggregate_history.user_name;
							operation_finder_tAggregateRow_8.vm_id = copyOfvm_aggregate_history.vm_id;

							operation_finder_tAggregateRow_8.hashCodeDirty = true;

							operation_result_tAggregateRow_8 = hash_tAggregateRow_8
									.get(operation_finder_tAggregateRow_8);

							boolean isFirstAdd_tAggregateRow_8 = false;

							if (operation_result_tAggregateRow_8 == null) { // G_OutMain_AggR_001

								operation_result_tAggregateRow_8 = new AggOperationStruct_tAggregateRow_8();

								operation_result_tAggregateRow_8.history_datetime = operation_finder_tAggregateRow_8.history_datetime;
								operation_result_tAggregateRow_8.user_id = operation_finder_tAggregateRow_8.user_id;
								operation_result_tAggregateRow_8.user_name = operation_finder_tAggregateRow_8.user_name;
								operation_result_tAggregateRow_8.vm_id = operation_finder_tAggregateRow_8.vm_id;

								isFirstAdd_tAggregateRow_8 = true;

								hash_tAggregateRow_8.put(
										operation_result_tAggregateRow_8,
										operation_result_tAggregateRow_8);

							} // G_OutMain_AggR_001

							if (operation_result_tAggregateRow_8.session_time_in_minutes_sum == null) {
								operation_result_tAggregateRow_8.session_time_in_minutes_sum = new BigDecimal(
										0).setScale(0);
							}
							operation_result_tAggregateRow_8.session_time_in_minutes_sum = operation_result_tAggregateRow_8.session_time_in_minutes_sum
									.add(new BigDecimal(
											String.valueOf(copyOfvm_aggregate_history.session_time_in_minutes)));

							if (copyOfvm_aggregate_history.cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_8.cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_8.cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_8.cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_8.cpu_usage_percent_sum
										.doubleValue() + copyOfvm_aggregate_history.cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_8.max_cpu_usage_max == null
										|| copyOfvm_aggregate_history.cpu_usage_percent > operation_result_tAggregateRow_8.max_cpu_usage_max

								) {
									operation_result_tAggregateRow_8.max_cpu_usage_max = copyOfvm_aggregate_history.cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.memory_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.memory_usage_percent_count++;

								if (operation_result_tAggregateRow_8.memory_usage_percent_sum == null) {
									operation_result_tAggregateRow_8.memory_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_8.memory_usage_percent_sum = (double) (operation_result_tAggregateRow_8.memory_usage_percent_sum
										.doubleValue() + copyOfvm_aggregate_history.memory_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.memory_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_8.max_memory_usage_max == null
										|| copyOfvm_aggregate_history.memory_usage_percent > operation_result_tAggregateRow_8.max_memory_usage_max

								) {
									operation_result_tAggregateRow_8.max_memory_usage_max = copyOfvm_aggregate_history.memory_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.user_cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.user_cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_8.user_cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_8.user_cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_8.user_cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_8.user_cpu_usage_percent_sum
										.doubleValue() + copyOfvm_aggregate_history.user_cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.user_cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_8.max_user_cpu_usage_percent_max == null
										|| copyOfvm_aggregate_history.user_cpu_usage_percent > operation_result_tAggregateRow_8.max_user_cpu_usage_percent_max

								) {
									operation_result_tAggregateRow_8.max_user_cpu_usage_percent_max = copyOfvm_aggregate_history.user_cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.system_cpu_usage_percent != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.system_cpu_usage_percent_count++;

								if (operation_result_tAggregateRow_8.system_cpu_usage_percent_sum == null) {
									operation_result_tAggregateRow_8.system_cpu_usage_percent_sum = (double) 0;
								}
								operation_result_tAggregateRow_8.system_cpu_usage_percent_sum = (double) (operation_result_tAggregateRow_8.system_cpu_usage_percent_sum
										.doubleValue() + copyOfvm_aggregate_history.system_cpu_usage_percent
										.shortValue());

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.system_cpu_usage_percent != null) { // G_OutMain_AggR_546

								if (operation_result_tAggregateRow_8.max_system_cpu_usage_percent_max == null
										|| copyOfvm_aggregate_history.system_cpu_usage_percent > operation_result_tAggregateRow_8.max_system_cpu_usage_percent_max

								) {
									operation_result_tAggregateRow_8.max_system_cpu_usage_percent_max = copyOfvm_aggregate_history.system_cpu_usage_percent;
								}

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.vm_ip != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.vm_ip_last = copyOfvm_aggregate_history.vm_ip;

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.vm_client_ip != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.vm_client_ip_last = copyOfvm_aggregate_history.vm_client_ip;

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.currently_running_on_host != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.currently_running_on_host_last = copyOfvm_aggregate_history.currently_running_on_host;

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.vm_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.vm_configuration_version_last = copyOfvm_aggregate_history.vm_configuration_version;

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.current_host_configuration_version != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.current_host_configuration_version_last = copyOfvm_aggregate_history.current_host_configuration_version;

							} // G_OutMain_AggR_546

							if (copyOfvm_aggregate_history.user_logged_in_to_guest != null) { // G_OutMain_AggR_546

								operation_result_tAggregateRow_8.user_logged_in_to_guest_last = copyOfvm_aggregate_history.user_logged_in_to_guest;

							} // G_OutMain_AggR_546

							tos_count_tAggregateRow_8_AGGOUT++;

							/**
							 * [tAggregateRow_8_AGGOUT main ] stop
							 */

						} // End of branch "copyOfvm_aggregate_history"

						/**
						 * [tJDBCInput_10 end ] start
						 */

						currentComponent = "tJDBCInput_10";

					}
				} finally {
					if (rs_tJDBCInput_10 != null) {
						rs_tJDBCInput_10.close();
					}
					stmt_tJDBCInput_10.close();

				}
				globalMap.put("tJDBCInput_10_NB_LINE", nb_line_tJDBCInput_10);

				ok_Hash.put("tJDBCInput_10", true);
				end_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				/**
				 * [tJDBCInput_10 end ] stop
				 */

				/**
				 * [tMap_10 end ] start
				 */

				currentComponent = "tMap_10";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_10", true);
				end_Hash.put("tMap_10", System.currentTimeMillis());

				/**
				 * [tMap_10 end ] stop
				 */

				/**
				 * [tAggregateRow_8_AGGOUT end ] start
				 */

				currentVirtualComponent = "tAggregateRow_8";

				currentComponent = "tAggregateRow_8_AGGOUT";

				ok_Hash.put("tAggregateRow_8_AGGOUT", true);
				end_Hash.put("tAggregateRow_8_AGGOUT",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_8_AGGOUT end ] stop
				 */

				/**
				 * [tJDBCOutput_10 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_10", false);
				start_Hash.put("tJDBCOutput_10", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_10";

				int tos_count_tJDBCOutput_10 = 0;

				int nb_line_tJDBCOutput_10 = 0;
				int nb_line_update_tJDBCOutput_10 = 0;
				int nb_line_inserted_tJDBCOutput_10 = 0;
				int nb_line_deleted_tJDBCOutput_10 = 0;
				int nb_line_rejected_tJDBCOutput_10 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_10 = 0;

				int deletedCount_tJDBCOutput_10 = 0;
				int updatedCount_tJDBCOutput_10 = 0;
				int insertedCount_tJDBCOutput_10 = 0;
				int rejectedCount_tJDBCOutput_10 = 0;

				boolean whetherReject_tJDBCOutput_10 = false;

				java.sql.Connection connection_tJDBCOutput_10 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_10 = "INSERT INTO "
						+ "statistics_vms_users_usage_daily"
						+ " (history_datetime,user_id,user_name,user_logged_in_to_guest,vm_id,session_time_in_minutes,cpu_usage_percent,max_cpu_usage,memory_usage_percent,max_memory_usage,user_cpu_usage_percent,max_user_cpu_usage_percent,system_cpu_usage_percent,max_system_cpu_usage_percent,vm_ip,vm_client_ip,currently_running_on_host,vm_configuration_version,current_host_configuration_version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_10 = connection_tJDBCOutput_10
						.prepareStatement(insert_tJDBCOutput_10);

				/**
				 * [tJDBCOutput_10 begin ] stop
				 */

				/**
				 * [tMap_12 begin ] start
				 */

				ok_Hash.put("tMap_12", false);
				start_Hash.put("tMap_12", System.currentTimeMillis());

				currentComponent = "tMap_12";

				int tos_count_tMap_12 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_12__Struct {
				}
				Var__tMap_12__Struct Var__tMap_12 = new Var__tMap_12__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				complete_aggregate_usersStruct complete_aggregate_users_tmp = new complete_aggregate_usersStruct();
				// ###############################

				/**
				 * [tMap_12 begin ] stop
				 */

				/**
				 * [tAggregateRow_8_AGGIN begin ] start
				 */

				ok_Hash.put("tAggregateRow_8_AGGIN", false);
				start_Hash.put("tAggregateRow_8_AGGIN",
						System.currentTimeMillis());

				currentVirtualComponent = "tAggregateRow_8";

				currentComponent = "tAggregateRow_8_AGGIN";

				int tos_count_tAggregateRow_8_AGGIN = 0;

				java.util.Collection<AggOperationStruct_tAggregateRow_8> values_tAggregateRow_8 = hash_tAggregateRow_8
						.values();

				globalMap.put("tAggregateRow_8_NB_LINE",
						values_tAggregateRow_8.size());

				for (AggOperationStruct_tAggregateRow_8 aggregated_row_tAggregateRow_8 : values_tAggregateRow_8) { // G_AggR_600

					/**
					 * [tAggregateRow_8_AGGIN begin ] stop
					 */

					/**
					 * [tAggregateRow_8_AGGIN main ] start
					 */

					currentVirtualComponent = "tAggregateRow_8";

					currentComponent = "tAggregateRow_8_AGGIN";

					row14.history_datetime = aggregated_row_tAggregateRow_8.history_datetime;

					row14.user_id = aggregated_row_tAggregateRow_8.user_id;

					row14.user_name = aggregated_row_tAggregateRow_8.user_name;

					row14.user_logged_in_to_guest = aggregated_row_tAggregateRow_8.user_logged_in_to_guest_last;
					row14.vm_id = aggregated_row_tAggregateRow_8.vm_id;

					if (aggregated_row_tAggregateRow_8.session_time_in_minutes_sum != null) {
						row14.session_time_in_minutes = aggregated_row_tAggregateRow_8.session_time_in_minutes_sum
								.doubleValue();

					} else {

						row14.session_time_in_minutes = 0;

					}

					if (aggregated_row_tAggregateRow_8.cpu_usage_percent_count > 0) {

						double row14_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_8.cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_8.cpu_usage_percent_count;

						row14.cpu_usage_percent = (short) row14_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row14.cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row14.max_cpu_usage = aggregated_row_tAggregateRow_8.max_cpu_usage_max;
					if (aggregated_row_tAggregateRow_8.memory_usage_percent_count > 0) {

						double row14_memory_usage_percent_temp = (double) aggregated_row_tAggregateRow_8.memory_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_8.memory_usage_percent_count;

						row14.memory_usage_percent = (short) row14_memory_usage_percent_temp;

					} else {
						String count = "0";

						row14.memory_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row14.max_memory_usage = aggregated_row_tAggregateRow_8.max_memory_usage_max;
					if (aggregated_row_tAggregateRow_8.user_cpu_usage_percent_count > 0) {

						double row14_user_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_8.user_cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_8.user_cpu_usage_percent_count;

						row14.user_cpu_usage_percent = (short) row14_user_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row14.user_cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row14.max_user_cpu_usage_percent = aggregated_row_tAggregateRow_8.max_user_cpu_usage_percent_max;
					if (aggregated_row_tAggregateRow_8.system_cpu_usage_percent_count > 0) {

						double row14_system_cpu_usage_percent_temp = (double) aggregated_row_tAggregateRow_8.system_cpu_usage_percent_sum
								/ (double) aggregated_row_tAggregateRow_8.system_cpu_usage_percent_count;

						row14.system_cpu_usage_percent = (short) row14_system_cpu_usage_percent_temp;

					} else {
						String count = "0";

						row14.system_cpu_usage_percent = ParserUtils
								.parseTo_Short(count);

					}
					row14.max_system_cpu_usage_percent = aggregated_row_tAggregateRow_8.max_system_cpu_usage_percent_max;
					row14.vm_ip = aggregated_row_tAggregateRow_8.vm_ip_last;
					row14.vm_client_ip = aggregated_row_tAggregateRow_8.vm_client_ip_last;
					row14.currently_running_on_host = aggregated_row_tAggregateRow_8.currently_running_on_host_last;
					row14.vm_configuration_version = aggregated_row_tAggregateRow_8.vm_configuration_version_last;
					row14.current_host_configuration_version = aggregated_row_tAggregateRow_8.current_host_configuration_version_last;

					tos_count_tAggregateRow_8_AGGIN++;

					/**
					 * [tAggregateRow_8_AGGIN main ] stop
					 */

					/**
					 * [tMap_12 main ] start
					 */

					currentComponent = "tMap_12";

					boolean hasCasePrimitiveKeyWithNull_tMap_12 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_12 = false;
					boolean mainRowRejected_tMap_12 = false;

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_12__Struct Var = Var__tMap_12;// ###############################
						// ###############################
						// # Output tables

						complete_aggregate_users = null;

						// # Output table : 'complete_aggregate_users'
						complete_aggregate_users_tmp.history_datetime = row14.history_datetime;
						complete_aggregate_users_tmp.user_id = row14.user_id;
						complete_aggregate_users_tmp.user_name = row14.user_name;
						complete_aggregate_users_tmp.user_logged_in_to_guest = row14.user_logged_in_to_guest != null ? row14.user_logged_in_to_guest > 0
								: null;
						complete_aggregate_users_tmp.vm_id = row14.vm_id;
						complete_aggregate_users_tmp.session_time_in_minutes = row14.session_time_in_minutes;
						complete_aggregate_users_tmp.cpu_usage_percent = row14.cpu_usage_percent;
						complete_aggregate_users_tmp.max_cpu_usage = row14.max_cpu_usage;
						complete_aggregate_users_tmp.memory_usage_percent = row14.memory_usage_percent;
						complete_aggregate_users_tmp.max_memory_usage = row14.max_memory_usage;
						complete_aggregate_users_tmp.user_cpu_usage_percent = row14.user_cpu_usage_percent;
						complete_aggregate_users_tmp.max_user_cpu_usage_percent = row14.max_user_cpu_usage_percent;
						complete_aggregate_users_tmp.system_cpu_usage_percent = row14.system_cpu_usage_percent;
						complete_aggregate_users_tmp.max_system_cpu_usage_percent = row14.max_system_cpu_usage_percent;
						complete_aggregate_users_tmp.vm_ip = row14.vm_ip;
						complete_aggregate_users_tmp.vm_client_ip = row14.vm_client_ip;
						complete_aggregate_users_tmp.currently_running_on_host = row14.currently_running_on_host;
						complete_aggregate_users_tmp.vm_configuration_version = row14.vm_configuration_version;
						complete_aggregate_users_tmp.current_host_configuration_version = row14.current_host_configuration_version;
						complete_aggregate_users = complete_aggregate_users_tmp;
						// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_12 = false;

					tos_count_tMap_12++;

					/**
					 * [tMap_12 main ] stop
					 */
					// Start of branch "complete_aggregate_users"
					if (complete_aggregate_users != null) {

						/**
						 * [tJDBCOutput_10 main ] start
						 */

						currentComponent = "tJDBCOutput_10";

						whetherReject_tJDBCOutput_10 = false;
						if (complete_aggregate_users.history_datetime != null) {
							pstmt_tJDBCOutput_10
									.setTimestamp(
											1,
											new java.sql.Timestamp(
													complete_aggregate_users.history_datetime
															.getTime()));
						} else {
							pstmt_tJDBCOutput_10
									.setNull(1, java.sql.Types.DATE);
						}

						if (complete_aggregate_users.user_id == null) {
							pstmt_tJDBCOutput_10.setNull(2,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_10.setObject(2,
									complete_aggregate_users.user_id);
						}

						if (complete_aggregate_users.user_name == null) {
							pstmt_tJDBCOutput_10.setNull(3,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_10.setString(3,
									complete_aggregate_users.user_name);
						}

						if (complete_aggregate_users.user_logged_in_to_guest == null) {
							pstmt_tJDBCOutput_10.setNull(4,
									java.sql.Types.BOOLEAN);
						} else {
							pstmt_tJDBCOutput_10
									.setBoolean(
											4,
											complete_aggregate_users.user_logged_in_to_guest);
						}

						if (complete_aggregate_users.vm_id == null) {
							pstmt_tJDBCOutput_10.setNull(5,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_10.setObject(5,
									complete_aggregate_users.vm_id);
						}

						pstmt_tJDBCOutput_10
								.setDouble(
										6,
										complete_aggregate_users.session_time_in_minutes);

						if (complete_aggregate_users.cpu_usage_percent == null) {
							pstmt_tJDBCOutput_10.setNull(7,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10.setShort(7,
									complete_aggregate_users.cpu_usage_percent);
						}

						if (complete_aggregate_users.max_cpu_usage == null) {
							pstmt_tJDBCOutput_10.setNull(8,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10.setShort(8,
									complete_aggregate_users.max_cpu_usage);
						}

						if (complete_aggregate_users.memory_usage_percent == null) {
							pstmt_tJDBCOutput_10.setNull(9,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10
									.setShort(
											9,
											complete_aggregate_users.memory_usage_percent);
						}

						if (complete_aggregate_users.max_memory_usage == null) {
							pstmt_tJDBCOutput_10.setNull(10,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10.setShort(10,
									complete_aggregate_users.max_memory_usage);
						}

						if (complete_aggregate_users.user_cpu_usage_percent == null) {
							pstmt_tJDBCOutput_10.setNull(11,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10
									.setShort(
											11,
											complete_aggregate_users.user_cpu_usage_percent);
						}

						if (complete_aggregate_users.max_user_cpu_usage_percent == null) {
							pstmt_tJDBCOutput_10.setNull(12,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10
									.setShort(
											12,
											complete_aggregate_users.max_user_cpu_usage_percent);
						}

						if (complete_aggregate_users.system_cpu_usage_percent == null) {
							pstmt_tJDBCOutput_10.setNull(13,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10
									.setShort(
											13,
											complete_aggregate_users.system_cpu_usage_percent);
						}

						if (complete_aggregate_users.max_system_cpu_usage_percent == null) {
							pstmt_tJDBCOutput_10.setNull(14,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10
									.setShort(
											14,
											complete_aggregate_users.max_system_cpu_usage_percent);
						}

						if (complete_aggregate_users.vm_ip == null) {
							pstmt_tJDBCOutput_10.setNull(15,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_10.setString(15,
									complete_aggregate_users.vm_ip);
						}

						if (complete_aggregate_users.vm_client_ip == null) {
							pstmt_tJDBCOutput_10.setNull(16,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_10.setString(16,
									complete_aggregate_users.vm_client_ip);
						}

						if (complete_aggregate_users.currently_running_on_host == null) {
							pstmt_tJDBCOutput_10.setNull(17,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_10
									.setObject(
											17,
											complete_aggregate_users.currently_running_on_host);
						}

						if (complete_aggregate_users.vm_configuration_version == null) {
							pstmt_tJDBCOutput_10.setNull(18,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10
									.setInt(18,
											complete_aggregate_users.vm_configuration_version);
						}

						if (complete_aggregate_users.current_host_configuration_version == null) {
							pstmt_tJDBCOutput_10.setNull(19,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_10
									.setInt(19,
											complete_aggregate_users.current_host_configuration_version);
						}

						try {
							insertedCount_tJDBCOutput_10 = insertedCount_tJDBCOutput_10
									+ pstmt_tJDBCOutput_10.executeUpdate();
							nb_line_tJDBCOutput_10++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_10 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_10++;

						/**
						 * [tJDBCOutput_10 main ] stop
						 */

					} // End of branch "complete_aggregate_users"

					/**
					 * [tAggregateRow_8_AGGIN end ] start
					 */

					currentVirtualComponent = "tAggregateRow_8";

					currentComponent = "tAggregateRow_8_AGGIN";

				} // G_AggR_600

				ok_Hash.put("tAggregateRow_8_AGGIN", true);
				end_Hash.put("tAggregateRow_8_AGGIN",
						System.currentTimeMillis());

				/**
				 * [tAggregateRow_8_AGGIN end ] stop
				 */

				/**
				 * [tMap_12 end ] start
				 */

				currentComponent = "tMap_12";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_12", true);
				end_Hash.put("tMap_12", System.currentTimeMillis());

				/**
				 * [tMap_12 end ] stop
				 */

				/**
				 * [tJDBCOutput_10 end ] start
				 */

				currentComponent = "tJDBCOutput_10";

				if (pstmt_tJDBCOutput_10 != null) {

					pstmt_tJDBCOutput_10.close();

				}

				nb_line_deleted_tJDBCOutput_10 = nb_line_deleted_tJDBCOutput_10
						+ deletedCount_tJDBCOutput_10;
				nb_line_update_tJDBCOutput_10 = nb_line_update_tJDBCOutput_10
						+ updatedCount_tJDBCOutput_10;
				nb_line_inserted_tJDBCOutput_10 = nb_line_inserted_tJDBCOutput_10
						+ insertedCount_tJDBCOutput_10;
				nb_line_rejected_tJDBCOutput_10 = nb_line_rejected_tJDBCOutput_10
						+ rejectedCount_tJDBCOutput_10;

				globalMap.put("tJDBCOutput_10_NB_LINE", nb_line_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_10);

				ok_Hash.put("tJDBCOutput_10", true);
				end_Hash.put("tJDBCOutput_10", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_10 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tAggregateRow_8_AGGIN"
			globalMap.remove("tAggregateRow_8");

			try {

				/**
				 * [tJDBCInput_10 finally ] start
				 */

				currentComponent = "tJDBCInput_10";

				/**
				 * [tJDBCInput_10 finally ] stop
				 */

				/**
				 * [tMap_10 finally ] start
				 */

				currentComponent = "tMap_10";

				/**
				 * [tMap_10 finally ] stop
				 */

				/**
				 * [tAggregateRow_8_AGGOUT finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_8";

				currentComponent = "tAggregateRow_8_AGGOUT";

				/**
				 * [tAggregateRow_8_AGGOUT finally ] stop
				 */

				/**
				 * [tAggregateRow_8_AGGIN finally ] start
				 */

				currentVirtualComponent = "tAggregateRow_8";

				currentComponent = "tAggregateRow_8_AGGIN";

				/**
				 * [tAggregateRow_8_AGGIN finally ] stop
				 */

				/**
				 * [tMap_12 finally ] start
				 */

				currentComponent = "tMap_12";

				/**
				 * [tMap_12 finally ] stop
				 */

				/**
				 * [tJDBCOutput_10 finally ] start
				 */

				currentComponent = "tJDBCOutput_10";

				/**
				 * [tJDBCOutput_10 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_AggregationToDaily, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_AggregationToDaily) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */

					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}
					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private SyncInt runningThreadCount = new SyncInt();

	private class SyncInt {
		private int count = 0;

		public synchronized void add(int i) {
			count += i;
		}

		public synchronized int getCount() {
			return count;
		}
	}

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final AggregationToDaily AggregationToDailyClass = new AggregationToDaily();

		int exitCode = AggregationToDailyClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public boolean hastBufferOutputComponent() {
		boolean hastBufferOutput = false;

		return hastBufferOutput;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = AggregationToDaily.class
					.getClassLoader().getResourceAsStream(
							"ovirt_engine_dwh/aggregationtodaily_4_2/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			String pwd_ovirtEngineHistoryDbPassword_value = context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbPassword = null;
			if (pwd_ovirtEngineHistoryDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineHistoryDbPassword")) {// no
																				// need
																				// to
																				// decrypt
																				// if
																				// it
																				// come
																				// from
																				// program
																				// argument
																				// or
																				// parent
																				// job
																				// runtime
					context.ovirtEngineHistoryDbPassword = pwd_ovirtEngineHistoryDbPassword_value;
				} else if (!pwd_ovirtEngineHistoryDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineHistoryDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineHistoryDbPassword_value);
						context.put("ovirtEngineHistoryDbPassword",
								context.ovirtEngineHistoryDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
			try {
				String context_lastDayAggr_value = context
						.getProperty("lastDayAggr");
				if (context_lastDayAggr_value == null) {
					context_lastDayAggr_value = "";
				}
				int context_lastDayAggr_pos = context_lastDayAggr_value
						.indexOf(";");
				String context_lastDayAggr_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastDayAggr_pos > -1) {
					context_lastDayAggr_pattern = context_lastDayAggr_value
							.substring(0, context_lastDayAggr_pos);
					context_lastDayAggr_value = context_lastDayAggr_value
							.substring(context_lastDayAggr_pos + 1);
				}

				context.lastDayAggr = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastDayAggr_pattern)
						.parse(context_lastDayAggr_value));

			} catch (ParseException e) {
				context.lastDayAggr = null;
			}
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
			if (parentContextMap.containsKey("lastDayAggr")) {
				context.lastDayAggr = (java.util.Date) parentContextMap
						.get("lastDayAggr");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		List<String> parametersToEncrypt = new java.util.ArrayList<String>();
		parametersToEncrypt.add("ovirtEngineHistoryDbPassword");
		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "",
				resumeUtil.convertToJsonText(context, parametersToEncrypt));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		try {
			errorCode = null;
			tPrejob_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPrejob_1) {
			globalMap.put("tPrejob_1_SUBPROCESS_STATE", -1);

			e_tPrejob_1.printStackTrace();

		}

		this.globalResumeTicket = false;// to run others jobs

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_2Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_2) {
					globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", -1);

					e_tJDBCInput_2.printStackTrace();

				} catch (Error e_tJDBCInput_2) {
					globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", -1);

					e_tJDBCInput_2.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_3Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_3) {
					globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", -1);

					e_tJDBCInput_3.printStackTrace();

				} catch (Error e_tJDBCInput_3) {
					globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", -1);

					e_tJDBCInput_3.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_4Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_4) {
					globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", -1);

					e_tJDBCInput_4.printStackTrace();

				} catch (Error e_tJDBCInput_4) {
					globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", -1);

					e_tJDBCInput_4.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_5Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_5) {
					globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", -1);

					e_tJDBCInput_5.printStackTrace();

				} catch (Error e_tJDBCInput_5) {
					globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", -1);

					e_tJDBCInput_5.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_11Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_11) {
					globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", -1);

					e_tJDBCInput_11.printStackTrace();

				} catch (Error e_tJDBCInput_11) {
					globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", -1);

					e_tJDBCInput_11.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_13Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_13) {
					globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", -1);

					e_tJDBCInput_13.printStackTrace();

				} catch (Error e_tJDBCInput_13) {
					globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", -1);

					e_tJDBCInput_13.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_9Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_9) {
					globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", -1);

					e_tJDBCInput_9.printStackTrace();

				} catch (Error e_tJDBCInput_9) {
					globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", -1);

					e_tJDBCInput_9.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_10Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_10) {
					globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", -1);

					e_tJDBCInput_10.printStackTrace();

				} catch (Error e_tJDBCInput_10) {
					globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", -1);

					e_tJDBCInput_10.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		while (runningThreadCount.getCount() > 0) {
			try {
				Thread.sleep(10);
			} catch (java.lang.Exception e) {
				e.printStackTrace();
			}
		}

		this.globalResumeTicket = true;// to run tPostJob

		try {
			errorCode = null;
			tPostjob_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPostjob_1) {
			globalMap.put("tPostjob_1_SUBPROCESS_STATE", -1);

			e_tPostjob_1.printStackTrace();

		}

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out
					.println((endUsedMemory - startUsedMemory)
							+ " bytes memory increase when running : AggregationToDaily");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	// only for OSGi env
	public void destroy() {
		closeSqlDbConnections();

	}

	private void closeSqlDbConnections() {
		try {
			Object obj_conn;
			obj_conn = globalMap.remove("conn_tJDBCConnection_1");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
		} catch (java.lang.Exception e) {
		}
	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		connections.put("conn_tJDBCConnection_1",
				globalMap.get("conn_tJDBCConnection_1"));

		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\\\", "\\" }, { "\\n", "\n" },
			{ "\\'", "\'" }, { "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" },
			{ "\\t", "\t" } };

	private String replaceEscapeChars(String keyValue) {

		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}

		StringBuilder result = new StringBuilder();
		int currIndex = 0;
		while (currIndex < keyValue.length()) {
			int index = -1;
			// judege if the left string includes escape chars
			for (String[] strArray : escapeChars) {
				index = keyValue.indexOf(strArray[0], currIndex);
				if (index >= 0) {

					result.append(keyValue.substring(currIndex,
							index + strArray[0].length()).replace(strArray[0],
							strArray[1]));
					currIndex = index + strArray[0].length();
					break;
				}
			}
			// if the left string doesn't include escape chars, append the left
			// into the result
			if (index < 0) {
				result.append(keyValue.substring(currIndex));
				currIndex = currIndex + keyValue.length();
			}
		}

		return result.toString();
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 718023 characters generated by Talend Open Studio for Data Integration on the
 * May 16, 2018 3:26:07 PM IDT
 ************************************************************************************************/
