/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.OpenStackImageProvider;
import org.ovirt.engine.sdk.decorators.OpenStackImageProviderOpenStackImage;
import org.ovirt.engine.sdk.entities.OpenStackImage;
import org.ovirt.engine.sdk.entities.OpenStackImages;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class OpenStackImageProviderOpenStackImages
extends CollectionDecorator<OpenStackImage, OpenStackImages, OpenStackImageProviderOpenStackImage> {
    private OpenStackImageProvider parent;

    public OpenStackImageProviderOpenStackImages(HttpProxyBroker proxy, OpenStackImageProvider parent) {
        super(proxy, "images");
        this.parent = parent;
    }

    @Override
    public List<OpenStackImageProviderOpenStackImage> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, OpenStackImages.class, OpenStackImageProviderOpenStackImage.class);
    }

    @Override
    public OpenStackImageProviderOpenStackImage get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, OpenStackImage.class, OpenStackImageProviderOpenStackImage.class);
    }

    @Override
    public OpenStackImageProviderOpenStackImage getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, OpenStackImage.class, OpenStackImageProviderOpenStackImage.class);
    }

    public List<OpenStackImageProviderOpenStackImage> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, OpenStackImages.class, OpenStackImageProviderOpenStackImage.class, headers);
    }
}

