/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Host;
import org.ovirt.engine.sdk.decorators.HostStorageConnectionExtension;
import org.ovirt.engine.sdk.entities.StorageConnectionExtension;
import org.ovirt.engine.sdk.entities.StorageConnectionExtensions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class HostStorageConnectionExtensions
extends CollectionDecorator<StorageConnectionExtension, StorageConnectionExtensions, HostStorageConnectionExtension> {
    private Host parent;

    public HostStorageConnectionExtensions(HttpProxyBroker proxy, Host parent) {
        super(proxy, "storageconnectionextensions");
        this.parent = parent;
    }

    @Override
    public List<HostStorageConnectionExtension> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, StorageConnectionExtensions.class, HostStorageConnectionExtension.class);
    }

    @Override
    public HostStorageConnectionExtension get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, StorageConnectionExtension.class, HostStorageConnectionExtension.class);
    }

    @Override
    public HostStorageConnectionExtension getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, StorageConnectionExtension.class, HostStorageConnectionExtension.class);
    }

    public HostStorageConnectionExtension add(StorageConnectionExtension storageconnectionextension) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, storageconnectionextension, StorageConnectionExtension.class, HostStorageConnectionExtension.class, headers);
    }

    public HostStorageConnectionExtension add(StorageConnectionExtension storageconnectionextension, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, storageconnectionextension, StorageConnectionExtension.class, HostStorageConnectionExtension.class, headers);
    }

    public HostStorageConnectionExtension add(StorageConnectionExtension storageconnectionextension, String correlationId, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, storageconnectionextension, StorageConnectionExtension.class, HostStorageConnectionExtension.class, headers);
    }

    public List<HostStorageConnectionExtension> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, StorageConnectionExtensions.class, HostStorageConnectionExtension.class, headers);
    }
}

