
#
# CUSTOMIZATION-BEGIN
#
# ovirt_build_extra_flags
# ovirt_build_ut
%if 0%{?ovirt_build_quick}
%global _ovirt_build_ut 0
%global ovirt_build_gwt 0
%endif
%if 0%{?ovirt_build_minimal}
%global _ovirt_build_ut 0
%global ovirt_build_all_user_agents 0
%global ovirt_build_locales 0
%global _ovirt_build_extra_flags -D gwt.userAgent=gecko1_8
%endif
%if 0%{?ovirt_build_draft}
%global _ovirt_build_ut 0
%global ovirt_build_all_user_agents 0
%global ovirt_build_locales 0
%global _ovirt_build_extra_flags -D gwt.userAgent=gecko1_8 -P gwtdraft
%endif
%if 0%{!?ovirt_build_ut:1}
%if 0%{?_ovirt_build_ut:1}
%global ovirt_build_ut %{_ovirt_build_ut}
%else
%global ovirt_build_ut 1
%endif
%endif
%if 0%{!?ovirt_build_gwt:1}
%global ovirt_build_gwt 1
%endif
%if 0%{!?ovirt_build_locales:1}
%global ovirt_build_locales 1
%endif
%if 0%{!?ovirt_build_all_user_agents:1}
%global ovirt_build_all_user_agents 1
%endif
#
# CUSTOMIZATION-END
#

# Do not repack .jar files, as it takes a long time and doesn't have a
# real benefit:
%global __jar_repack 0

#
# rpm does not support override
# nor modify of variables
#
%if %{?_ovirt_build_extra_flags:1}%{?ovirt_build_extra_flags:1}0
%global EXTRA_BUILD_FLAGS %{?_ovirt_build_extra_flags:%{_ovirt_build_extra_flags}}%{?ovirt_build_extra_flags: %{ovirt_build_extra_flags}}
%endif

#
# Supported distributions:
# Fedora >= 24
# EL >= 7
#

%global ovirt_install_poms 1
%global ovirt_provides_jboss 1
%global jboss ovirt-engine-wildfly
%global ovirt_wildfly_overlay 1
%global ovirt_with_docker 1
%global require_jboss 1

%global ovirt_product_name oVirt Engine
%global ovirt_product_name_short oVirt Engine
%global ovirt_product_group Virtualization/Management
%global ovirt_user_description oVirt Manager

# semanage moved in fedora 23 to policycoreutils-python-utils
%if 0%{?fedora} >= 23
%global policycoreutils_python_utils policycoreutils-python-utils
%else
%global policycoreutils_python_utils policycoreutils-python
%endif

%global engine_cache %{_localstatedir}/cache/%{engine_name}
%global engine_data %{_datadir}/%{engine_name}
%global engine_doc %{_docdir}/%{engine_name}
%global engine_ear %{engine_data}/engine.ear
%global engine_etc %{_sysconfdir}/%{engine_name}
%global engine_java %{_javadir}/%{engine_name}
%global engine_jboss_modules %{engine_data}/modules
%global engine_log %{_localstatedir}/log/%{engine_name}
%global engine_name ovirt-engine
%global engine_pki %{_sysconfdir}/pki/%{engine_name}
%global engine_restapi_war %{engine_data}/restapi.war
%global engine_apidoc_war %{engine_data}/apidoc.war
%global engine_run %{_localstatedir}/run/%{engine_name}
%global engine_state %{_localstatedir}/lib/%{engine_name}
%global engine_tmp %{_localstatedir}/tmp/%{engine_name}

%global engine_gid 108
%global engine_group ovirt
%global engine_uid 108
%global engine_user ovirt
%global vdsm_description Node Virtualization Manager
%global vdsm_gid 36
%global vdsm_group kvm
%global vdsm_uid 36
%global vdsm_user vdsm

%global openstack_java_version 3.1.2
%global patternfly patternfly1

# Macro to create an user:
#
# %1 user name
# %2 user id
# %3 primary group name
# %4 primary group id
# %5 description
# %6 home directory
#
%global _ovirt_create_user() \
getent group %3 >/dev/null || groupadd -r -g %4 %3; \
getent passwd %1 >/dev/null || useradd -r -u %2 -g %3 -c %5 -s /sbin/nologin -d %6 %1

%global ovirt_create_user_engine \
%_ovirt_create_user %{engine_user} %{engine_uid} %{engine_group} %{engine_gid} "%{ovirt_user_description}" %{engine_state}

%global ovirt_create_user_vdsm \
%_ovirt_create_user %{vdsm_user} %{vdsm_uid} %{vdsm_group} %{vdsm_gid} "%{vdsm_description}" /var/lib/vdsm

%if %{ovirt_wildfly_overlay}
%global wildfly_overlay_modules "/usr/share/ovirt-engine-wildfly-overlay/modules"
%else
%global wildfly_overlay_modules ""
%endif

%if 0%{?fedora} && 0%{?fedora} >= 23
%global with_python3 1
%endif

%global make_common_opts \\\
	-j1 \\\
	BUILD_GWT=%{ovirt_build_gwt} \\\
	BUILD_ALL_USER_AGENTS=%{ovirt_build_all_user_agents} \\\
	BUILD_LOCALES=%{ovirt_build_locales} \\\
	BUILD_UT=%{ovirt_build_ut} \\\
	BUILD_VALIDATION=0 \\\
	PACKAGE_NAME=%{name} \\\
	RPM_VERSION=%{version} \\\
	RPM_RELEASE=%{release} \\\
	DISPLAY_VERSION=%{version}-%{release} \\\
	ENGINE_NAME=%{engine_name} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	BIN_DIR=%{_bindir} \\\
	PID_DIR=%{_localstatedir}/run \\\
	DATAROOT_DIR=%{_datadir} \\\
	MAN_DIR=%{_mandir} \\\
	DOC_DIR=%{_docdir} \\\
	PYTHON=%{__python2} \\\
	PYTHON_DIR=%{python2_sitelib} \\\
	%{?with_python3: PYTHON3=%{__python3}} \\\
	%{?with_python3: PYTHON3_DIR=%{python3_sitelib}} \\\
	JAVA_DIR=%{_javadir} \\\
	MAVENPOM_DIR=%{_mavenpomdir} \\\
	PKG_SYSCONF_DIR=%{engine_etc} \\\
	PKG_DOC_DIR=%{engine_doc} \\\
	PKG_EAR_DIR=%{engine_ear} \\\
	PKG_PKI_DIR=%{engine_pki} \\\
	PKG_JBOSS_MODULES=%{engine_jboss_modules} \\\
	PKG_CACHE_DIR=%{engine_cache} \\\
	PKG_LOG_DIR=%{engine_log} \\\
	PKG_TMP_DIR=%{engine_tmp} \\\
	PKG_STATE_DIR=%{engine_state} \\\
	PKG_USER=%{engine_user} \\\
	PKG_GROUP=%{engine_group} \\\
	WILDFLY_OVERLAY_MODULES=%{wildfly_overlay_modules} \\\
	%{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name:		ovirt-engine
Version:	4.1.5.1
Release:	1%{?release_suffix}%{?dist}
Summary:	Management server for Open Virtualization
Group:		%{ovirt_product_group}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-4.1/src/ovirt-engine/ovirt-engine-4.1.5.1.tar.gz

BuildArch:	noarch

BuildRequires:	assertj-core >= 2.2.0
BuildRequires:	hystrix-core
BuildRequires:	hystrix-metrics-event-stream
BuildRequires:	java-1.8.0-openjdk-devel >= 1:1.8.0
BuildRequires:	jpackage-utils
BuildRequires:	make
BuildRequires:	maven
BuildRequires:	python
BuildRequires:	python2-devel
%if 0%{?with_python3}
BuildRequires:	python3-devel
%endif
BuildRequires:	systemd
BuildRequires:	unzip

Requires(pre):	shadow-utils

%if %{require_jboss}
Requires:	%{jboss} >= 10.1.0
Conflicts:	%{jboss} >= 11.0.0
%endif
%if %{ovirt_wildfly_overlay}
Requires:	ovirt-engine-wildfly-overlay >= 10.0.0
Conflicts:	ovirt-engine-wildfly-overlay >= 11.0.0
%endif

#
# End of jboss stuff
#

Requires:	%{name}-backend = %{version}-%{release}
Requires:	%{name}-cli >= 3.6.2.0
Requires:	%{name}-dbscripts = %{version}-%{release}
Requires:	%{name}-restapi = %{version}-%{release}
Requires:	%{name}-tools = %{version}-%{release}
Requires:	%{name}-userportal = %{version}-%{release}
Requires:	%{name}-webadmin-portal = %{version}-%{release}
Requires:	%{name}-websocket-proxy >= %{version}-%{release}
Requires:	%{name}-vmconsole-proxy-helper >= %{version}-%{release}
Requires:	%{name}-dashboard >= 1.0.0
Requires:	apache-commons-compress
Requires:	apache-commons-configuration
Requires:	apache-commons-jxpath
Requires:	hystrix-core
Requires:	hystrix-metrics-event-stream
Requires:	jakarta-commons-httpclient
Requires:	java-openjdk >= 1:1.8.0
Requires:	jpackage-utils
Requires:	objectweb-asm
Requires:	ovirt-iso-uploader >= 4.0.0
Requires:	%{patternfly}
Requires:	postgresql-server >= 9.2.15
Requires:	slf4j >= 1.7.0
Requires:	ws-commons-util
Requires:	xmlrpc-client
Requires:	ovirt-imageio-proxy
Requires:	ovirt-web-ui

# Metrics stuff
Requires:	collectd
Requires:	collectd-postgresql
Requires:	collectd-disk
Requires:	collectd-write_http
Requires:	fluentd
Requires:	rubygem-fluent-plugin-rewrite-tag-filter
Requires:	rubygem-fluent-plugin-secure-forward
Requires:	rubygem-fluent-plugin-collectd-nest
Requires:	rubygem-fluent-plugin-viaq_data_model

%if 0%{?rhel}
# JDBC drivers newer than 9.2 break engine DAL, so we cannot depend on it
# until fixed
Requires:	postgresql-jdbc >= 9.2.1002
Conflicts:	postgresql-jdbc >= 9.3

Requires:	yum-plugin-versionlock
%endif

%if 0%{?fedora}
Requires:	(yum-plugin-versionlock if yum)
Requires:	apache-sshd
Requires:	openstack-java-cinder-client >= %{openstack_java_version}
Requires:	openstack-java-cinder-model >= %{openstack_java_version}
Requires:	openstack-java-client >= %{openstack_java_version}
Requires:	openstack-java-glance-client >= %{openstack_java_version}
Requires:	openstack-java-glance-model >= %{openstack_java_version}
Requires:	openstack-java-keystone-client >= %{openstack_java_version}
Requires:	openstack-java-keystone-model >= %{openstack_java_version}
Requires:	openstack-java-quantum-client >= %{openstack_java_version}
Requires:	openstack-java-quantum-model >= %{openstack_java_version}
Requires:	openstack-java-resteasy-connector >= %{openstack_java_version}
Requires:	python-dnf-plugins-extras-versionlock
Requires:	python3-dnf-plugins-extras-versionlock
Requires:	quartz
# On Fedora slf4j package is split and we need also jdk14 and jcl-over-slf4j
# parts
Requires:	slf4j-jdk14 >= 1.7.0
Requires:	jcl-over-slf4j >= 1.7.0
Requires:	snmp4j >= 2.4.1
%endif

# We can't require exactly the same version and release of the
# setup package because it needs to be updated independently as part
# of the update process implemented in the engine-upgrade script:
Requires:	%{name}-setup >= %{version}-%{release}

# We can drop these conflicts when
# we drop Requires: mod_ssl
Conflicts:	freeipa-server
Conflicts:	ipa-server

%description
%{ovirt_product_name} is a feature-rich server virtualization management
system that provides advanced capabilities for managing the Open
virtualization infrastructure for Servers and Desktops.

%package extensions-api-impl
Summary:	%{ovirt_product_name_short} extensions api
Group:		%{ovirt_product_group}
Provides:	ovirt-engine-extensions-api = 0

%description extensions-api-impl
%{ovirt_product_name_short} extensions api

%package extensions-api-impl-javadoc
Summary:	%{ovirt_product_name_short} extensions api documentation
Group:		%{ovirt_product_group}
Provides:	ovirt-engine-extensions-api-javadoc = 0

%description extensions-api-impl-javadoc
%{ovirt_product_name_short} extensions api documentation

%package lib
Summary:	%{ovirt_product_name_short} library
Group:		%{ovirt_product_group}
Requires:	m2crypto
Requires:	python-dateutil
Requires:	python-daemon
Conflicts:	python-daemon = 2.1.0

%description lib
%{ovirt_product_name_short} library

%package backend
Summary:	Engine core of %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
License:	ASL 2.0 and LGPLv3 and GPLv3
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-extensions-api-impl >= %{version}-%{release}
Requires:	%{name}-lib >= %{version}-%{release}
Requires:	aopalliance >= 1.0
Requires:	ebay-cors-filter
Requires:	httpd
Requires:	java
Requires:	logrotate
Requires:	mailcap
Requires:	mod_ssl
Requires:	novnc
Requires:	openssh
Requires:	vdsm-jsonrpc-java >= 1.3.13
Requires:	openssl
Requires:	ovirt-engine-extension-aaa-jdbc
Requires:	ovirt-host-deploy-java >= 1.6.3
Requires:	python-jinja2
Requires:	spice-html5

Requires(pre):	shadow-utils
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd

%pre backend
%ovirt_create_user_engine

%post backend
%systemd_post ovirt-engine.service

%preun backend
%systemd_preun ovirt-engine.service

%postun backend
%systemd_postun ovirt-engine.service

%description backend
The backend engine of %{ovirt_product_name_short}

%package restapi
Summary:	RESTful API for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}

%description restapi
The RESTful API for %{ovirt_product_name_short}

%package setup-base
Summary:	%{ovirt_product_name_short} suite base setup components.
Group:		%{ovirt_product_group}
Requires:	%{name}-lib >= %{version}-%{release}
Requires:	ovirt-setup-lib >= 1.1.1
Requires:	bind-utils
Requires:	iproute
Requires:	libxml2-python
Requires:	logrotate
Requires:	otopi >= 1.6.0
Requires:	python-paramiko
Requires(pre):	shadow-utils
Conflicts:	%{name}-dwh < 3.6.0
Conflicts:	%{name}-reports < 3.6.0
Conflicts:	%{name}-dwh-setup < 4.0.0
Conflicts:	%{name}-reports-setup < 4.0.0

%description setup-base
%{ovirt_product_name_short} suite base setup components.


%pre setup-base
%ovirt_create_user_engine

%package setup
Summary:	Setup and upgrade scripts for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-plugin-ovirt-engine = %{version}-%{release}

%description setup
Setup and upgrade scripts for %{ovirt_product_name_short}

%package setup-plugin-ovirt-engine
Summary:	Setup and upgrade specific plugins for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} >= 3.6.0
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	%{name}-setup-plugin-vmconsole-proxy-helper = %{version}-%{release}
Requires:	%{name}-dwh-setup >= 4.0
Requires:	ovirt-engine-extension-aaa-jdbc
Requires:	ovirt-imageio-proxy-setup
Requires:	openssh
Conflicts:	%{name} < 3.6.0

%description setup-plugin-ovirt-engine
Setup and upgrade specific plugins for %{ovirt_product_name_short}

%pre setup-plugin-ovirt-engine
%ovirt_create_user_vdsm

%package setup-plugin-ovirt-engine-common
Summary:	Setup and upgrade common plugins for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-base = %{version}-%{release}
Requires:	cracklib-python
Requires:	libselinux-python
Requires:	m2crypto
Requires:	nfs-utils
Requires:	%{policycoreutils_python_utils}
Requires:	python-psycopg2
Requires(pre):	shadow-utils
Requires:	java-openjdk >= 1:1.8.0

%if 0%{?fedora}
Requires:	python2-dnf
%if 0%{?with_python3}
Requires:	python3-dnf
%endif
%else
Requires:	yum
%endif

# We can drop these conflicts when
# we drop Requires: mod_ssl
# conflict here so we can avoid upgrade
# of setup at this environment, this
# will produce early error.
Conflicts:	ipa-server
Conflicts:	freeipa-server

%description setup-plugin-ovirt-engine-common
Setup and upgrade common plugins for %{ovirt_product_name_short}

%package dbscripts
Summary:	Database scripts for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}

%description dbscripts
Database scripts for %{ovirt_product_name_short}

%package userportal
Summary:	User Portal of %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}

%description userportal
The user portal interface to %{ovirt_product_name_short}

%package webadmin-portal
Summary:	Web Admin Portal of %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}
License:	ASL 2.0 and GPLv2+ with exceptions


%description webadmin-portal
The web administration interface to %{ovirt_product_name_short}

%package tools
Summary:	%{ovirt_product_name_short} Tools
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-lib >= %{version}-%{release}
Requires:	%{name}-tools-backup = %{version}-%{release}
Requires:	ovirt-engine-metrics
Requires:	java
Requires:	logrotate
Requires:	python-dateutil
Requires:	python-psycopg2
Requires(pre):		shadow-utils
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd

%description tools
%{ovirt_product_name_short} Tools

%pre tools
%ovirt_create_user_engine

%post tools
%systemd_post ovirt-engine-notifier.service
%systemd_post ovirt-fence-kdump-listener.service

%postun tools
%systemd_postun ovirt-engine-notifier.service
%systemd_postun ovirt-fence-kdump-listener.service

%preun tools
%systemd_preun ovirt-engine-notifier.service
%systemd_preun ovirt-fence-kdump-listener.service

%package tools-backup
Summary:	%{ovirt_product_name_short} Tools (engine-backup)
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-plugin-ovirt-engine-common >= %{version}-%{release}
Requires:	tar
Requires:	bzip2
Requires:	xz
Requires:	otopi >= 1.5.0
Requires:	postgresql >= 9.2.15

%description tools-backup
%{ovirt_product_name_short} Tools (engine-backup)

%package websocket-proxy
Summary:	%{ovirt_product_name_short} Websocket Proxy
Group:		%{ovirt_product_group}
Requires:	%{name}-lib >= %{version}-%{release}
Requires:	numpy
Requires:	python-dateutil
Requires:	python-websockify >= 0.6.0
Requires:	%{name}-setup-plugin-websocket-proxy >= %{version}-%{release}
Requires(pre):		shadow-utils
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd

%description websocket-proxy
%{ovirt_product_name_short} Websocket Proxy

%pre websocket-proxy
%ovirt_create_user_engine

%post websocket-proxy
%systemd_post ovirt-websocket-proxy.service

%postun websocket-proxy
%systemd_postun ovirt-websocket-proxy.service

%preun websocket-proxy
%systemd_preun ovirt-websocket-proxy.service

%package setup-plugin-websocket-proxy
Summary:	Setup and upgrade specific plugins for websocket-proxy
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	python-six

%description setup-plugin-websocket-proxy
Setup and upgrade specific plugins for websocket-proxy

%package vmconsole-proxy-helper
Summary:	%{ovirt_product_name_short} VMconsole Proxy Helper
Group:		%{ovirt_product_group}
Requires:	%{name}-lib >= %{version}-%{release}
Requires:	%{name}-setup-plugin-vmconsole-proxy-helper >= %{version}-%{release}
Requires:	ovirt-vmconsole-proxy

%description vmconsole-proxy-helper
%{ovirt_product_name_short} VMconsole Proxy helper, to integrate
with ovirt-vmconsole-proxy package

%package setup-plugin-vmconsole-proxy-helper
Summary:	Setup and upgrade specific plugins for vmconsole-proxy-helper
Requires:	%{name}-setup-plugin-ovirt-engine = %{version}-%{release}
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	openssh

%description setup-plugin-vmconsole-proxy-helper
Setup and upgrade specific plugins for vmconsole-proxy-helper

%if %{ovirt_with_docker}
%package setup-plugin-dockerc
Summary:	Docker container plugin for %{ovirt_product_name_short}'s setup
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	%{name}-setup-plugin-ovirt-engine = %{version}-%{release}
Requires:	docker
Requires:	python-docker-py

%description setup-plugin-dockerc
Docker container plugin for %{ovirt_product_name_short}'s setup
%endif

%prep
%setup -c -q

%build

# Set the location of the JDK that will be used for compilation:
export JAVA_HOME="${JAVA_HOME:=/usr/lib/jvm/java-1.8.0}"

make %{make_common_opts}

%install
rm -fr "%{buildroot}"
make %{make_common_opts} install DESTDIR="%{buildroot}"

# Remove files that relies on unavailable dependencies on python3
# FIXME: port these files to python3! they rely on python2-only modules right now.
%if 0%{?with_python3}
rm -f "%{buildroot}%{python3_sitelib}"/ovirt_engine/{service,ticket}.py
%endif

# Compile python files
%{__python2} -m compileall -f -q -d "%{python2_sitelib}" "%{buildroot}%{python2_sitelib}"
%{__python2} -O -m compileall -f -q -d "%{python2_sitelib}" "%{buildroot}%{python2_sitelib}"
%if 0%{?with_python3}
%{__python3} -m compileall -f -q -d "%{python3_sitelib}" "%{buildroot}%{python3_sitelib}"
%{__python3} -O -m compileall -f -q -d "%{python3_sitelib}" "%{buildroot}%{python3_sitelib}"
%endif

#
# /var creation
#
install -dm 755 "%{buildroot}/%{engine_state}"/{content,setup/answers}
install -dm 755 "%{buildroot}/%{engine_log}"/{host-deploy,setup,notifier,dump}
install -dm 755 "%{buildroot}/%{engine_cache}"
install -dm 755 "%{buildroot}/%{engine_run}/notifier"

#
# Force TLS/SSL for selected applications.
#
for war in \
	"%{buildroot}%{engine_ear}"/{userportal,webadmin,enginesso,welcome}.war \
	"%{buildroot}%{engine_restapi_war}" \
	; do
	sed -i \
		-e 's#<transport-guarantee>NONE</transport-guarantee>#<transport-guarantee>CONFIDENTIAL</transport-guarantee>#' \
		-e 's#<secure>false</secure>#<secure>true</secure>#' \
		"${war}/WEB-INF/web.xml"
done

#
# Move jars to destribution location
#
install -dm 755 "%{buildroot}%{engine_java}"
while read lib_path; do
	java_path="%{engine_java}/$(basename "${lib_path}")"
	if ! [ -e "%{buildroot}/${java_path}" ] && [ -f "%{buildroot}/${lib_path}" ]; then
		cp "%{buildroot}/${lib_path}" "%{buildroot}/${java_path}"
	fi
	rm -f "%{buildroot}/${lib_path}"
	ln -s "${java_path}" "%{buildroot}${lib_path}"
done << __EOF__
%{engine_data}/logutils/logutils.jar
%{engine_ear}/bll.jar
%{engine_ear}/lib/vdsbroker.jar
%{engine_ear}/lib/scheduler.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/interface-common-jaxrs/main/interface-common-jaxrs.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/ovirt-engine-extensions-api/main/ovirt-engine-extensions-api.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/restapi-definition/main/restapi-definition.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/restapi-jaxrs/main/restapi-jaxrs.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/restapi-types/main/restapi-types.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/aaa/main/aaa.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/branding/main/branding.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/common/main/common.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/compat/main/compat.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/dal/main/dal.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/extensions-tool/main/extensions-tool.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/extensions-manager/main/extensions-manager.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/searchbackend/main/searchbackend.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/tools/main/tools.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/utils/main/utils.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/uutils/main/uutils.jar
%{engine_jboss_modules}/common/org/ovirt/engine/extensions/builtin/main/builtin.jar
%{engine_ear}/docs.war/WEB-INF/lib/branding.jar
%{engine_ear}/enginesso.war/WEB-INF/lib/branding.jar
%{engine_ear}/userportal.war/WEB-INF/lib/branding.jar
%{engine_ear}/webadmin.war/WEB-INF/lib/branding.jar
%{engine_ear}/welcome.war/WEB-INF/lib/branding.jar
__EOF__

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{engine_name}"
ln -s "%{engine_name}" "%{buildroot}%{engine_java}/../%{name}"
%endif

#
# Register poms
#
while read package pom; do
	pomdir="$(dirname "%{_mavenpomdir}/${pom}")"
	pom="$(basename "${pom}")"
	jpppom="JPP.${pom}"
	mv "%{buildroot}${pomdir}/${pom}" "%{buildroot}${pomdir}/${jpppom}"
	artifact_id="$(echo "${pom}" | sed -e 's/^%{name}-//' -e 's/\.pom//')"
	if [ -f "%{buildroot}%{engine_java}/${artifact_id}.jar" ]; then
		%add_maven_depmap -f "${package}" "${jpppom}" "%{name}/${artifact_id}.jar"
	else
		%add_maven_depmap -f "${package}" "${jpppom}"
	fi
done << __EOF__
backend %{name}-aaa.pom
backend %{name}-backend.pom
backend %{name}-bll.pom
backend %{name}-builtin.pom
backend %{name}-dal.pom
backend %{name}-manager-modules.pom
backend %{name}-manager.pom
backend %{name}-scheduler.pom
backend %{name}-searchbackend.pom
backend %{name}-vdsbroker.pom
base %{name}-branding.pom
base %{name}-common.pom
base %{name}-compat.pom
base %{name}-extensions-manager.pom
base %{name}-logutils.pom
base %{name}-root.pom
base %{name}-utils.pom
base %{name}-uutils.pom
extensions-api %{name}-ovirt-engine-extensions-api-root.pom
extensions-api %{name}-ovirt-engine-extensions-api.pom
restapi %{name}-interface-common-jaxrs.pom
restapi %{name}-restapi-definition.pom
restapi %{name}-restapi-jaxrs.pom
restapi %{name}-restapi-parent.pom
restapi %{name}-restapi-types.pom
tools %{name}-extensions-tool.pom
tools %{name}-tools.pom
__EOF__

%if "%{name}" != "%{engine_name}"
sed -i 's#%{_javadir}/%{name}#%{engine_java}#' .mfiles*
%endif

%if !%{ovirt_install_poms}
rm -fr "%{buildroot}%{_mavenpomdir}"
%endif

#
# Link dependencies to system provided
#
while read dst src; do
	[ -z "${dst}" ] && continue
	[ -z "${src}" ] && src="$(basename "${dst}")"

	dst="%{engine_jboss_modules}/${dst}"
	src="%{_javadir}/${src}"
	rm -f "%{buildroot}${dst}"
	ln -s "${src}" "%{buildroot}${dst}"
done << __EOF__
common/org/aopalliance/main/aopalliance.jar
common/org/apache/commons/compress/main/commons-compress.jar
common/org/apache/commons/configuration/main/commons-configuration.jar
common/org/apache/commons/httpclient/main/commons-httpclient.jar
common/org/apache/commons/jxpath/main/commons-jxpath.jar
common/org/apache/ws/commons/main/ws-commons-util.jar
common/org/apache/xmlrpc/main/xmlrpc-client.jar
common/org/apache/xmlrpc/main/xmlrpc-common.jar
common/org/ebaysf/web/cors-filter/main/cors-filter.jar ebay-cors-filter/cors-filter.jar
common/org/ovirt/otopi/main/otopi.jar otopi/otopi.jar
common/org/ovirt/ovirt-host-deploy/main/ovirt-host-deploy.jar ovirt-host-deploy/ovirt-host-deploy.jar
common/org/ovirt/vdsm-jsonrpc-java/main/vdsm-jsonrpc-java-client.jar vdsm-jsonrpc-java/vdsm-jsonrpc-java-client.jar
tools/org/slf4j/main/slf4j-api.jar slf4j/slf4j-api.jar
tools/org/slf4j/main/slf4j-jdk14.jar slf4j/slf4j-jdk14.jar
tools/org/slf4j/jcl-over-slf4j/main/jcl-over-slf4j.jar slf4j/jcl-over-slf4j.jar

%if 0%{?rhel}
# JDBC drivers newer than 9.2 break engine DAL, so we cannot depend on it
# until fixed
common/org/postgresql/main/postgresql.jar postgresql-jdbc.jar
%endif

%if 0%{?fedora}
common/com/mchange/c3p0/main/c3p0.jar c3p0/c3p0.jar
common/com/woorea/openstack/sdk/main/cinder-client.jar openstack-java-sdk/cinder-client.jar
common/com/woorea/openstack/sdk/main/cinder-model.jar openstack-java-sdk/cinder-model.jar
common/com/woorea/openstack/sdk/main/glance-client.jar openstack-java-sdk/glance-client.jar
common/com/woorea/openstack/sdk/main/glance-model.jar openstack-java-sdk/glance-model.jar
common/com/woorea/openstack/sdk/main/keystone-client.jar openstack-java-sdk/keystone-client.jar
common/com/woorea/openstack/sdk/main/keystone-model.jar openstack-java-sdk/keystone-model.jar
common/com/woorea/openstack/sdk/main/openstack-client.jar openstack-java-sdk/openstack-client.jar
common/com/woorea/openstack/sdk/main/quantum-client.jar openstack-java-sdk/quantum-client.jar
common/com/woorea/openstack/sdk/main/quantum-model.jar openstack-java-sdk/quantum-model.jar
common/com/woorea/openstack/sdk/main/resteasy-connector.jar openstack-java-sdk/resteasy-connector.jar
common/org/apache/sshd/main/sshd-core.jar apache-sshd/sshd-core.jar
common/org/quartz/main/quartz.jar
common/org/snmp4j/main/snmp4j.jar snmp4j.jar
%endif
__EOF__

#
# Register services
#
install -dm 755 "%{buildroot}%{_unitdir}"
for service in ovirt-engine ovirt-engine-notifier ovirt-fence-kdump-listener ovirt-websocket-proxy; do
	cp "%{buildroot}%{engine_data}/services/${service}/${service}.systemd" "%{buildroot}%{_unitdir}/${service}.service"
done

#
# Package customization
#
install -d "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d"
cat > "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging.conf" << __EOF__
[environment:default]
OVESETUP_APACHE/configureRootRedirectionDefault=bool:True
__EOF__

%if ! %{ovirt_with_docker}
rm -rf "%{buildroot}%{engine_data}/firewalld/dockerc"
rm -rf "%{buildroot}%{engine_data}/setup/ovirt_engine_setup/dockerc"
rm -rf "%{buildroot}%{engine_data}/setup/plugins/ovirt-engine-common/dockerc"
rm -rf "%{buildroot}%{engine_data}/setup/plugins/ovirt-engine-remove/dockerc"
rm -rf "%{buildroot}%{engine_data}/setup/plugins/ovirt-engine-setup/dockerc"
%endif

%if %{ovirt_provides_jboss}
%if %{ovirt_wildfly_overlay}
OVIRT_JBOSS_PACKAGES=ovirt-engine-wildfly,ovirt-engine-wildfly-overlay
%else
OVIRT_JBOSS_PACKAGES=ovirt-engine-wildfly
%endif
cat > "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging-jboss.conf" << __EOF__
[environment:default]
OVESETUP_CONFIG/jbossHome=str:/usr/share/ovirt-engine-wildfly
OVESETUP_RPMDISTRO/jbossPackages=str:${OVIRT_JBOSS_PACKAGES}
__EOF__
%endif


%preun
if [ "$1" -eq 0 ]; then
	#
	# backup pki dir into the backup dir with current date
	#
	if [ -d "%{engine_pki}" ]; then
		dest="%{engine_pki}/../%{engine_name}-backups/%{engine_name}-$(date +"%%Y%%m%%d%%H%%M%%S")"
		mkdir -p "${dest}"
		cp -pR "%{engine_pki}" "${dest}"
	fi
fi

%postun
if [ "$1" -eq 0 ]; then
	rm -rf "%{engine_cache}"
	rm -rf "%{engine_pki}"

	if [ -f "%{_sysconfdir}/yum/pluginconf.d/versionlock.list" ]; then
		sed -i '/%{name}/d' "%{_sysconfdir}/yum/pluginconf.d/versionlock.list"
	fi

	if [ -f "%{_sysconfdir}/dnf/plugins/versionlock.list" ]; then
		sed -i '/%{name}/d' "%{_sysconfdir}/dnf/plugins/versionlock.list"
	fi
fi

%pre
%ovirt_create_user_engine

%files -f .mfiles-base
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_cache}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}/dump
%dir %{engine_data}
%dir %{engine_data}/bin
%dir %{engine_data}/branding
%dir %{engine_data}/conf
%dir %{engine_data}/engine.ear
%dir %{engine_data}/extensions.d
%dir %{engine_data}/services
%dir %{engine_etc}
%dir %{engine_etc}/branding
%dir %{engine_etc}/extensions.d
%dir %{engine_java}
%license LICENSE
%{engine_data}/branding/ovirt.brand/
%{engine_etc}/branding/00-ovirt.brand
%{engine_etc}/engine.conf.d/

#
# ATTENTION:
# Needed for compatibility if package is different
# than the directory structure
#
%if "%{name}" != "%{engine_name}"
%{_javadir}/%{name}
%endif

%files extensions-api-impl -f .mfiles-extensions-api
%license LICENSE

%files extensions-api-impl-javadoc
%{engine_doc}/ovirt-engine-extensions-api/
%license LICENSE

%files lib
%license LICENSE
%{engine_data}/bin/java-home
%{python2_sitelib}/ovirt_engine/
%if 0%{?with_python3}
%{python3_sitelib}/ovirt_engine/
%endif

%files backend -f .mfiles-backend
%license LICENSE
%license backend/manager/modules/services/src/main/webapp/gpl-3.0.txt
%license backend/manager/modules/services/src/main/webapp/lgpl-3.0.txt
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/host-deploy
%attr(-, %{engine_user}, %{engine_group}) %{engine_state}/content
%config %{_sysconfdir}/logrotate.d/ovirt-engine
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_state}
%dir %{engine_data}/bin
%dir %{engine_data}/gwt-symbols
%dir %{engine_data}/ui-plugins
%dir %{engine_ear}
%{engine_data}/conf/osinfo-defaults.properties
%{engine_data}/conf/sysprep/
%{engine_data}/files/
%{engine_data}/icons/
%{engine_data}/logutils/
%{engine_doc}/AuditLogMessages.properties
%{engine_doc}/mibs/
%{engine_ear}/META-INF
%{engine_ear}/bll.jar
%{engine_ear}/docs.war/
%{engine_ear}/enginesso.war/
%{engine_ear}/lib
%{engine_ear}/root.war/
%{engine_ear}/services.war/
%{engine_ear}/welcome.war/
%{engine_etc}/osinfo.conf.d/
%{engine_jboss_modules}/

%{engine_data}/services/ovirt-engine
%{_unitdir}/ovirt-engine.service

#
# PKI
#
# Most directories are owned by the engine user because
# it needs to create files inside
#
%config(noreplace) %{engine_pki}/cacert.template.in
%config(noreplace) %{engine_pki}/cert.template.in
%config(noreplace) %{engine_pki}/openssl.conf
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/certs
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/private
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/requests
%dir %{engine_pki}/keys
%{engine_data}/bin/pki-common.sh
%{engine_data}/bin/pki-create-ca.sh
%{engine_data}/bin/pki-enroll-openssh-cert.sh
%{engine_data}/bin/pki-enroll-pkcs12.sh
%{engine_data}/bin/pki-enroll-request.sh
%{engine_data}/bin/pki-pkcs12-extract.sh

#
# engine-host-update.py tool
#
%{engine_data}/bin/engine-host-update.py

%files setup-base
%license LICENSE
%config %{_sysconfdir}/logrotate.d/ovirt-engine-setup
%dir %{engine_data}/firewalld
%dir %{engine_data}/setup
%dir %{engine_data}/setup/bin/
%dir %{engine_data}/setup/ovirt_engine_setup
%dir %{engine_data}/setup/plugins
%dir %{engine_data}/setup/plugins/ovirt-engine-common
%dir %{engine_data}/setup/plugins/ovirt-engine-remove
%dir %{engine_data}/setup/plugins/ovirt-engine-setup
%dir %{engine_log}/setup
%{_bindir}/engine-cleanup
%{_bindir}/engine-setup
%{_mandir}/man8/engine-cleanup.*
%{_mandir}/man8/engine-setup.*
%{_mandir}/man8/engine-upgrade-check.*
%{engine_data}/conf/iptables.default.in
%{engine_data}/setup/bin/ovirt-engine-remove
%{engine_data}/setup/bin/ovirt-engine-rename
%{engine_data}/setup/bin/ovirt-engine-setup
%{engine_data}/setup/bin/ovirt-engine-setup.env
%{engine_data}/setup/ovirt_engine_setup/*.py*
%{engine_data}/setup/plugins/*/base/
%{engine_state}/backups/
%{engine_state}/setup/

%files setup
%license LICENSE


%files setup-plugin-ovirt-engine
%license LICENSE
%config %{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging.conf
%{_bindir}/engine-upgrade-check
%{engine_data}/conf/ovirt-engine-proxy.conf.v2.in
%{engine_data}/conf/ovirt-engine-root-redirect.conf.in
%{engine_data}/firewalld/ovirt-engine/
%{engine_data}/setup/bin/ovirt-engine-upgrade-check
%{engine_data}/setup/dbutils/
%{engine_data}/setup/plugins/*/ovirt-engine/

%files setup-plugin-ovirt-engine-common
%license LICENSE
%{engine_data}/setup/bin/ovirt-engine-provisiondb
%{engine_data}/setup/ovirt_engine_setup/engine_common/
%{engine_data}/setup/ovirt_engine_setup/provisiondb/
%{engine_data}/setup/plugins/*/ovirt-engine-common/
%{engine_data}/firewalld/ovirt-common/
%{engine_data}/setup/ovirt_engine_setup/engine/


%if %{ovirt_provides_jboss}
%config %{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging-jboss.conf
%endif

%if %{ovirt_wildfly_overlay}
%config %{engine_etc}/engine.conf.d/20-setup-jboss-overlay.conf
%endif

%files setup-plugin-websocket-proxy
%license LICENSE
%{engine_data}/firewalld/websocket-proxy/
%{engine_data}/setup/ovirt_engine_setup/websocket_proxy/
%{engine_data}/setup/plugins/*/websocket_proxy/

%files setup-plugin-vmconsole-proxy-helper
%license LICENSE
%{engine_data}/conf/ovirt-vmconsole-proxy.conf
%{engine_data}/firewalld/vmconsole-proxy/
%{engine_data}/setup/ovirt_engine_setup/vmconsole_proxy_helper/
%{engine_data}/setup/plugins/*/vmconsole_proxy_helper/

%if %{ovirt_with_docker}
%files setup-plugin-dockerc
%license LICENSE
%{engine_data}/firewalld/dockerc/
%{engine_data}/setup/ovirt_engine_setup/dockerc/
%{engine_data}/setup/plugins/*/dockerc/
%endif

%files dbscripts
%license LICENSE
%{engine_data}/dbscripts/

%files restapi -f .mfiles-restapi
%license LICENSE
%{engine_restapi_war}/
%{engine_apidoc_war}/

%files userportal
%license LICENSE
%config %{engine_etc}/usbfilter.txt
%{engine_ear}/userportal.war
%{engine_data}/gwt-symbols/userportal/

%files webadmin-portal
%license LICENSE
%license frontend/webadmin/modules/gwt-extension/src/main/java/org/ovirt/engine/ui/uioverrides/java/util/LICENSE
%{engine_ear}/webadmin.war
%{engine_data}/gwt-symbols/webadmin/

%files websocket-proxy
%license LICENSE
%{engine_data}/services/ovirt-websocket-proxy
%{engine_etc}/ovirt-websocket-proxy.conf.d/

%{_unitdir}/ovirt-websocket-proxy.service

%files vmconsole-proxy-helper
%license LICENSE
%{_libexecdir}/ovirt-vmconsole-proxy-helper/
%{engine_data}/conf/ovirt-vmconsole-proxy-helper.conf
%{engine_etc}/ovirt-vmconsole-proxy-helper.conf.d/

%files tools -f .mfiles-tools
%license LICENSE
%config %{_sysconfdir}/logrotate.d/ovirt-engine-notifier
%config(noreplace) %{engine_etc}/engine-config/engine-config.conf
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}/notifier
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_run}/notifier
%dir %{engine_etc}/engine-config
%dir %{engine_etc}/notifier
%{_bindir}/engine-config
%{_bindir}/ovirt-engine-extensions-tool
%{_bindir}/engine-vacuum
%{_mandir}/man8/engine-config.*
%{engine_data}/bin/engine-config.sh
%{engine_data}/bin/engine-prolog.sh
%{engine_data}/bin/engine-vacuum.sh
%{engine_data}/bin/generate-pgpass.sh
%{engine_data}/bin/ovirt-engine-extensions-tool.sh
%{engine_data}/bin/ovirt-engine-crypto-tool.sh
%{engine_data}/bin/ovirt-engine-role.sh
%{engine_data}/conf/extensions-tool-logging.properties
%{engine_data}/conf/jaas.conf
%{engine_data}/conf/notifier-logging.properties
%{engine_data}/conf/tools-logging.properties
%{engine_data}/services/ovirt-engine-notifier
%{engine_data}/services/ovirt-fence-kdump-listener/
%{engine_etc}/engine-config/engine-config.*properties
%{engine_etc}/notifier/notifier.conf.d/
%{engine_etc}/ovirt-fence-kdump-listener.conf.d/

%{_unitdir}/ovirt-engine-notifier.service
%{_unitdir}/ovirt-fence-kdump-listener.service

%files tools-backup
%license LICENSE
%{_bindir}/engine-backup
%{_mandir}/man8/engine-backup.*
%{engine_data}/bin/engine-backup.sh
%{engine_data}/bin/engine-migrate-he.py

%changelog
* Tue Aug 01 2017 Lev Veyde <lveyde@redhat.com> - 4.1.5.1-1
- Bump version to 4.1.5.1

* Thu Jul 27 2017 Lev Veyde <lveyde@redhat.com> - 4.1.5-1
- Bump version to 4.1.5

* Tue Jul 11 2017 Lev Veyde <lveyde@redhat.com> - 4.1.4.1-1
- Bump version to 4.1.4.1

* Tue Jul 04 2017 Lev Veyde <lveyde@redhat.com> - 4.1.4-1
- Bump version to 4.1.4

* Tue Jun 20 2017 Lev Veyde <lveyde@redhat.com> - 4.1.3.5-1
- Bump version to 4.1.3.5

* Thu Jun 15 2017 Lev Veyde <lveyde@redhat.com> - 4.1.3.4-1
- Bump version to 4.1.3.4

* Wed Jun 14 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.3.3-1
- Bump version to 4.1.3.3

* Tue Jun 06 2017 Lev Veyde <lveyde@redhat.com> - 4.1.3.2-1
- Bump version to 4.1.3.2

* Tue May 30 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.3.1-1
- Bump version to 4.1.3.1

* Wed May 24 2017 Lev Veyde <lveyde@redhat.com> - 4.1.3-1
- Bump version to 4.1.3

* Thu May 11 2017 Lev Veyde <lveyde@redhat.com> - 4.1.2.2-1
- Bump version to 4.1.2.2

* Wed May 03 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.2.1-1
- Bump version to 4.1.2.1

* Sun Apr 23 2017 Lev Veyde <lveyde@redhat.com> - 4.1.2-1
- Bump version to 4.1.2

* Wed Feb 15 2017 Lev Veyde <lveyde@redhat.com> - 4.1.1.2-1
- Bump version to 4.1.1.2

* Tue Feb 14 2017 Lev Veyde <lveyde@redhat.com> - 4.1.1.1-1
- Bump version to 4.1.1.1

* Wed Jan 25 2017 Lev Veyde <lveyde@redhat.com> - 4.1.1-1
- Bump version to 4.1.1

* Fri Jan 20 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0.2-1
- Bump version to 4.1.0.2

* Thu Jan 19 2017 Lev Veyde <lveyde@redhat.com> - 4.1.0.2_master
- Bump version to 4.1.0.2_master

* Thu Jan 12 2017 Lev Veyde <lveyde@redhat.com> - 4.1.0.1
- Bump version to 4.1.0.1

* Wed May 25 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0
- Add dependency for ovirt-engine-dashboard.
- Bump version to 4.1.0

* Wed Aug  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0
- Bump version to 4.0.0
- Dropped Fedora < 22 and EL < 7 support

* Thu Jul 10 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.0
- Update dependencies and removed legacy provides / requires

* Thu Jan 17 2013 Juan Hernandez <juan.hernandez@redhat.com> - 3.3.0-1
- Bump version to 3.3.0

* Fri Nov 02 2012 Juan Hernandez <juan.hernandez@redhat.com> - 3.2.0-1
- Bump version to 3.2.0

* Mon May 07 2012 Keith Robertson <kroberts@redhat.com> - 3.1.0-3
- Removed image uploader, iso uploader, and log collector from this
  git repo.  The are now in their own respective ovirt.org git
  repos. BZ#803240.

* Wed Apr 04 2012 Stephen Gordon <sgordon@redhat.com> - 3.1.0-2
- The ovirt-engine spec file did not previously contain a BuildRequires
  statement for the maven package. As a result in mock environments the
  build failed with an error when attempting to call the 'mvn' binary -
  BZ#807761.

* Wed Jan 04 2012 Ronen Angluste <ranglust@redhat.com> - 3.1.0-1
- Adjust code for Jboss AS 7.1

* Sun Dec 11 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Moved all hard coded paths to macros

* Wed Oct 26 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Initial build
- Cloned from RHEVM spec file
