/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.adapters;

import static org.ovirt.engine.api.v3.adapters.V3InAdapters.adaptIn;

import org.ovirt.engine.api.model.OpenStackVolumeTypes;
import org.ovirt.engine.api.v3.V3Adapter;
import org.ovirt.engine.api.v3.types.V3OpenStackVolumeTypes;

public class V3OpenStackVolumeTypesInAdapter implements V3Adapter<V3OpenStackVolumeTypes, OpenStackVolumeTypes> {
    @Override
    public OpenStackVolumeTypes adapt(V3OpenStackVolumeTypes from) {
        OpenStackVolumeTypes to = new OpenStackVolumeTypes();
        if (from.isSetActions()) {
            to.setActions(adaptIn(from.getActions()));
        }
        if (from.isSetActive()) {
            to.setActive(from.getActive());
        }
        if (from.isSetSize()) {
            to.setSize(from.getSize());
        }
        if (from.isSetTotal()) {
            to.setTotal(from.getTotal());
        }
        to.getOpenStackVolumeTypes().addAll(adaptIn(from.getOpenStackVolumeTypes()));
        return to;
    }
}
