#
# ovirt-host-deploy -- ovirt host deployer
# Copyright (C) 2012-2018 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.8.0_master
%global		package_maven_version 1.8.0-master
%global		ovirt_host_deploy_root %{_datadir}/%{name}/interface-3

%global _use_maven 1
%global _use_repolib 0
%global maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy
%global _configure ../configure

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%global src_java_dir py3/src/java
%else
%global with_python3 0
%endif

%if 0%{?rhel} >= 8
%global with_python2 0
%else
%global with_python2 1
%global src_java_dir py2/src/java
%endif

Summary:	oVirt host deploy tool
Name:		ovirt-host-deploy
Version:	1.8.0
Release:	0.0.master%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Applications/System

BuildArch:	noarch

BuildRequires:	java-devel
BuildRequires:	gettext >= 0.18.2

%if 0%{with_python2}
BuildRequires:	python2-otopi-devtools
BuildRequires:	python2-devel
Requires:		python2-%{name}
%endif

%if 0%{?with_python3}
BuildRequires:	python%{python3_pkgversion}-otopi-devtools
BuildRequires:	python%{python3_pkgversion}-devel
%if 0%{!?with_python2}
Requires:		python%{python3_pkgversion}-%{name}
%endif
%endif

%if %{_use_maven}
BuildRequires:	javapackages-tools
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-source-plugin
BuildRequires:	maven-local
BuildRequires:	sonatype-oss-parent
%endif

%description
Host deployment tool for oVirt project.

%if 0%{?with_python2}
%package -n python2-%{name}
Summary:	%{summary}
%{?python_provide:%python_provide python2-%{name}}
Requires:	python
Requires:	%{name}-common = %{version}-%{release}
Requires:	python2-otopi >= 1.8.0
Provides:	%{name} = %{version}-%{release}
Obsoletes:	%{name} < %{version}-%{release}

%description -n python2-%{name}
%{summary}.

Python 2 version.
%endif # with_python2

%if 0%{?with_python3}
%package -n python%{python3_pkgversion}-%{name}
Summary:	%{summary}
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
Requires:	python%{python3_pkgversion}
Requires:	%{name}-common = %{version}-%{release}
Requires:	python%{python3_pkgversion}-otopi >= 1.8.0

%description -n python%{python3_pkgversion}-%{name}
%{summary}.

Python %{python3_pkgversion} version.
%endif # with_python3

%package common
Summary:	Commong files for %{name}

%description common
%{summary}

%package java
Summary:	%{name} java support
%if 0%{?with_python2}
Requires:	python2-%{name} = %{version}-%{release}
%endif
%if 0%{?with_python3}
Requires:	python%{python3_pkgversion}-%{name} = %{version}-%{release}
%endif
Requires:	java-headless
Requires:	otopi-java

%description java
java libraries.

%if %{_use_maven}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.
%endif

%if %{_use_repolib}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}
%pom_remove_plugin :maven-javadoc-plugin src/java/pom.xml.in
mkdir py2 py3

%build
%if %{_use_maven}
%global conf --disable-java-sdk-compile
%endif

%if 0%{with_python2}
pushd py2
%configure PYTHON="%{__python2}" \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	--enable-java-sdk \
	--with-local-version="%{name}-%{version}-%{release}" \
	%{?conf}
make %{?_smp_mflags}
popd
%endif # with_python2

%if 0%{?with_python3}
pushd py3
%configure PYTHON="%{__python3}" \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	--enable-java-sdk \
	--with-local-version="%{name}-%{version}-%{release}" \
	%{?conf}
make %{?_smp_mflags}
popd
%endif # with_python3

%if %{_use_maven}
pushd %{src_java_dir}
%mvn_build
popd
%endif

%install
%if 0%{?with_python2}
make -C py2 %{?_smp_mflags} install DESTDIR="%{buildroot}"
%endif # with_python2

%if 0%{?with_python3}
make -C py3 %{?_smp_mflags} install DESTDIR="%{buildroot}"
%endif # with_python3

%if %{_use_maven}
pushd %{src_java_dir}
%mvn_install
popd
%else
install -d "%{buildroot}%{_javadir}/%{name}"
install target/%{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}
ln -s %{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}/%{name}.jar
cat > %{src_java_dir}/.mfiles << __EOF__
%{_javadir}/%{name}/
__EOF__
%endif

%if %{_use_repolib}
install -d "%{buildroot}%{maven2brewrepodir}"
cp "%{buildroot}%{_javadir}/%{name}/%{name}.jar" "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.jar"
cp %{src_java_dir}/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.pom"
%endif

install -d -m 755 "%{buildroot}%{_sysconfdir}/%{name}.conf.d"
%find_lang %{name}

%if 0%{?with_python2}
%files -n python2-%{name}

%doc AUTHORS
%license COPYING
%doc README
%doc README.environment
%doc README.localization
%{python2_sitelib}/ovirt_host_deploy/
%{python2_sitelib}/ovirt_host_mgmt/
%endif # with_python2

%if 0%{?with_python3}
%files -n python%{python3_pkgversion}-%{name}

%doc AUTHORS
%license COPYING
%doc README
%doc README.environment
%doc README.localization
%{python3_sitelib}/ovirt_host_deploy/
%{python3_sitelib}/ovirt_host_mgmt/
%endif # with_python3

%files common -f %{name}.lang
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/plugins
%dir %{_sysconfdir}/%{name}.conf.d
%dir %{ovirt_host_deploy_root}
%dir %{ovirt_host_deploy_root}/pythonlib
%{_sbindir}/ovirt-host-deploy
%{_sbindir}/ovirt-host-mgmt
%{_datadir}/%{name}/plugins/ovirt-host-common/
%{_datadir}/%{name}/plugins/ovirt-host-deploy/
%{_datadir}/%{name}/plugins/ovirt-host-mgmt/
%{_datadir}/otopi/plugins/ovirt-host-common
%{_datadir}/otopi/plugins/ovirt-host-deploy
%{_datadir}/otopi/plugins/ovirt-host-mgmt
%{ovirt_host_deploy_root}/setup
%{ovirt_host_deploy_root}/.bundled
%{ovirt_host_deploy_root}/otopi
%{ovirt_host_deploy_root}/otopi-functions
%{ovirt_host_deploy_root}/otopi-plugins
%{ovirt_host_deploy_root}/ovirt-host-deploy
%{ovirt_host_deploy_root}/ovirt-host-mgmt
%{ovirt_host_deploy_root}/pythonlib/otopi
%{ovirt_host_deploy_root}/pythonlib/ovirt_host_deploy
%{ovirt_host_deploy_root}/pythonlib/ovirt_host_mgmt

%files java -f %{src_java_dir}/.mfiles

%if %{_use_maven}
%files javadoc -f %{src_java_dir}/.mfiles-javadoc
%endif

%if %{_use_repolib}
%files repolib
%{maven2brewrepodir}/
%endif

%changelog
* Mon Jan 22 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 1.7.1-1
- Release.

* Tue Nov 28 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.7.0-1
- Release.

* Wed Oct 18 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.6.7-1
- Release.

* Wed Jun  7 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.6.6-1
- Release.

* Thu May 11 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.5-1
- Release.

* Wed May  3 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.4-1
- Release.

* Tue Mar  7 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.6.3-1
- Release.

* Thu Mar  2 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.2-1
- Release.

* Tue Feb 21 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.1-1
- Release.

* Fri Jan 13 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.6.0-1
- Release.

* Wed Sep 28 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.3-1
- Release.

* Tue Aug 30 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.2-1
- Release.

* Tue Jul 12 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.1-1
- Release.

* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.0-1
- Release.

* Thu Oct 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.4.0-1
- Release.

* Thu Jan 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.3.1-1
- Release.

* Mon Oct 6 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.3.0-1
- Release.

* Fri May 2 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.1-1
- Release.

* Tue Mar 18 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-1
- Release.

* Mon Jan 20 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.1.beta
- Beta.

* Mon Aug 26 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.0-1
- Release.

* Thu Feb 14 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-1
- Release.

* Sat Oct 13 2012 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-0.1_beta
- Initial add.
