#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%global		package_version 3.5.2
%global		package_name ovirt-iso-uploader
# Required users and groups
%global		vdsm_user vdsm
%global		vdsm_group kvm

Summary:	ISO Uploader for oVirt Engine
Name:		%{package_name}
Version:	3.5.2
Release:	1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/ovirt-3.5/src/%{package_name}/%{package_name}-%{package_version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch
Requires:	python
Requires(pre):	shadow-utils
Requires:	ovirt-engine-sdk-python >= 3.5.2.1
Requires:	logrotate
BuildRequires:	gettext
BuildRequires:	python2-devel

%description
ISO Uploader tool for oVirt Engine

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check

make %{?_smp_mflags}

%pre
getent group %{vdsm_group} >/dev/null || \
	LC_ALL=C groupadd -g 36 -r %{vdsm_group}
getent passwd %{vdsm_user} >/dev/null || \
	LC_ALL=C useradd -r -u 36 -g %{vdsm_group} -d / \
		-s /sbin/nologin -c "Node Virtualization Manager" %{vdsm_user}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc AUTHORS
%doc COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/isouploader.conf.d
%attr(0640, -, -) %config(noreplace) %{_sysconfdir}/ovirt-engine/isouploader.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{python_sitelib}/ovirt_iso_uploader/*.py*
%{_bindir}/ovirt-iso-uploader
%{_bindir}/engine-iso-uploader
%{_mandir}/man8/*

%changelog
* Mon Apr 13 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.2-1
- 3.5.2-1

* Mon Jan 19 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.2-0.0.master
- 3.5.2-0.0.master

* Mon Jan 19 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.1-1
- 3.5.1-1

* Fri Sep 19 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.1-0.0.master
- 3.5.1-0.0.master

* Fri Sep 19 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.0-1
- 3.5.0-1

* Fri Jul 11 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.0-0.1.master
- 3.5.0-0.1.master

* Fri Jan 17 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.0-0.0.master
- 3.5.0-0.0.master
