# Copyright 2011-2019 Red Hat, Inc. and/or its affiliates.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

%global		package_version 4.3.0
%global		package_name ovirt-iso-uploader
# Required users and groups
%global		vdsm_user vdsm
%global		vdsm_group kvm

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%global required_python python%{python3_pkgversion}
%global required_python_interpreter %{__python3}
%global required_python_sitelib %{python3_sitelib}
%define required_python_lib(l:r:) python%{python3_pkgversion}-%{*}
%else
%global with_python3 0
%global required_python python
%global required_python_interpreter %{__python2}
%global required_python_sitelib %{python2_sitelib}
%define required_python_lib(l:r:) %{-l*}%{*}%{-r*}
%endif

%if 0%{?rhel} >= 8
%global with_python2 0
%else
%global with_python2 1
%endif

%global required_python_lib_devel %{required_python_lib -l python2- devel}
%global required_python_lib_ovirt_engine_sdk4 %{required_python_lib -l python- ovirt-engine-sdk4 >= 4.0.0}

Summary:	ISO Uploader for oVirt Engine
Name:		%{package_name}
Version:	4.3.0
Release:	1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/src/%{package_name}/%{package_name}-%{package_version}.tar.gz

BuildArch:	noarch
Requires(pre):	shadow-utils
BuildRequires:	gettext
BuildRequires:	%{required_python_lib_devel}

Requires:	%{required_python}
Requires:	%{required_python_lib_ovirt_engine_sdk4}
Requires:	logrotate
Requires:	nfs-utils
Requires:	glusterfs-api

%description
ISO Uploader tool for oVirt Engine

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure PYTHON="%{required_python_interpreter}" \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check
make %{?_smp_mflags}

%check
make check

%pre
getent group %{vdsm_group} >/dev/null || \
	LC_ALL=C groupadd -g 36 -r %{vdsm_group}
getent passwd %{vdsm_user} >/dev/null || \
	LC_ALL=C useradd -r -u 36 -g %{vdsm_group} -d / \
		-s /sbin/nologin -c "Node Virtualization Manager" %{vdsm_user}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files

%doc AUTHORS
%license COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/isouploader.conf.d
%attr(0640, -, -) %config(noreplace) %{_sysconfdir}/ovirt-engine/isouploader.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{required_python_sitelib}/ovirt_iso_uploader/
%{_bindir}/ovirt-iso-uploader
%{_bindir}/engine-iso-uploader
%{_mandir}/man8/*

%changelog
* Tue Jan 08 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.0-1
- 4.3.0-1

* Tue Nov 28 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-1
- 4.1.0-1

* Thu Aug  4 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.0.master
- 4.1.0-0.0.master

* Tue May 31 2016 Rafael Martins <rmartins@redhat.com> - 4.0.0-1
- 4.0.0-1

* Wed Aug  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.0.master
- 4.0.0-0.0.master
