# Copyright 2018-2020 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import six.moves.configparser

_LABELER_CONFIG_FILE = '/etc/ovirt-lldp-labeler/conf.d/ovirt-lldp-labeler.conf'
_CREDENTIALS_CONFIG_FILE = '/etc/ovirt-lldp-labeler/conf.d/ovirt-lldp-credentials.conf'

_CREDENTIALS_SECTION = 'credentials'
_LABELER_SECTION = 'labeler'

_CLUSTER_CONFIG = 'clusters'
_API_URL_CONFIG = 'api_url'
_CA_FILE_CONFIG = 'ca_file'
_AUTO_BONDING_CONFIG = 'auto_bonding'
_AUTO_LABELING_CONFIG = 'auto_labeling'

_API_USERNAME = 'username'
_API_PASSWORD = 'password'

_COMMA_SEPARATOR = ','

_CONFIG_TRUE = 'true'

_config = six.moves.configparser.ConfigParser()
_config.read(_LABELER_CONFIG_FILE)
_config.read(_CREDENTIALS_CONFIG_FILE)


def get_clusters_from_config():
    return _split_by_separator(
        _config.get(_LABELER_SECTION, _CLUSTER_CONFIG), _COMMA_SEPARATOR)


def get_api_url():
    return _config.get(_LABELER_SECTION, _API_URL_CONFIG)


def get_api_username():
    return _config.get(_CREDENTIALS_SECTION, _API_USERNAME)


def get_api_password():
    return _config.get(_CREDENTIALS_SECTION, _API_PASSWORD)


def get_ca_file():
    return _config.get(_LABELER_SECTION, _CA_FILE_CONFIG)


def get_auto_bonding():
    return _config.getboolean(_LABELER_SECTION, _AUTO_BONDING_CONFIG)


def get_auto_labeling():
    return _config.getboolean(_LABELER_SECTION, _AUTO_LABELING_CONFIG)


def _split_by_separator(value, separator):
    splited = value.split(separator)
    return [val.strip() for val in splited]
