#!/usr/bin/python2
# Copyright 2018 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#
import errno
import grp
import os
import sys
import time


TIMEOUT = 120


def main():
    vhostuser_path = sys.argv[1]

    now = time.time()
    while time.time() - now <= TIMEOUT:
        time.sleep(0.5)
        try:
            gid = grp.getgrnam('hugetlbfs').gr_gid
            os.chown(vhostuser_path, -1, gid)
            return
        except OSError as e:
            if e.errno == errno.ENOENT:
                continue
            raise


if __name__ == '__main__':
    main()
