# Copyright 2016 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license

%define        __spec_install_post %{nil}
%define          debug_package %{nil}
%define        __os_install_post %{_dbpath}/brp-compress

# define the python package prefix based on distribution version
# this is needed to require a correct python-openvswitch package:
# python-openvswitch or python3-openvswitch for fedora >=28 or
# el >= 8
%if 0%{?fedora} >= 30 || 0%{?rhel} >= 8
%global required_python python%{python3_pkgversion}
%global required_python_interpreter %{__python3}
%define required_python_lib(l:) python%{python3_pkgversion}-%{*}
%global required_python_sitelib %{python3_sitelib}
%else
%global required_python python
%global required_python_interpreter %{__python2}
%global required_python_sitelib %{python2_sitelib}
%define required_python_lib(l:) %{-l*}%{*}
%endif

%global required_ovs_lib %{required_python_lib -l python- openvswitch}
%global required_six_lib %{required_python_lib -l python- six}
%global required_ovsdbapp_lib %{required_python_lib -l python- ovsdbapp}
%global required_requests_lib %{required_python_lib -l python- requests}
%global required_netaddr_lib %{required_python_lib -l python- netaddr}
%global required_python_devel %{required_python_lib -l python- devel}
%global required_python_setup_tools %{required_python_lib -l python- setuptools}

Name:           ovirt-provider-ovn
Version:        1.2.32
Release:        1%{?dist}
Summary:        The oVirt external network provider for OVN
License:        GPLv2+
BuildArch:      noarch
URL:            https://gerrit.ovirt.org/#/admin/projects/ovirt-provider-ovn
Source0:        %{name}-%{version}.tar.gz

Requires: firewalld-filesystem
Requires: kernel >= 3.10.0-512

Requires: openvswitch >= 0:2.7
Requires: openvswitch-ovn-central >= 0:2.7
Requires: openvswitch-ovn-common >= 0:2.7
Requires: %{required_ovs_lib} >= 0:2.7

Conflicts: openvswitch = 1:2.6.1
Conflicts: openvswitch-ovn-central = 1:2.6.1
Conflicts: openvswitch-ovn-common = 1:2.6.1
Conflicts: %{required_ovs_lib} = 1:2.6.1

Requires: %{required_requests_lib}
Requires: %{required_netaddr_lib}
Requires: %{required_ovsdbapp_lib}
Requires: %{required_six_lib}

BuildRequires: %{required_python}
BuildRequires: %{required_python_devel}
BuildRequires: %{required_python_setup_tools}
BuildRequires: systemd

%prep
%setup -q

%build

%install
rm -rf $RPM_BUILD_ROOT
%make_install PYTHON="%{required_python_interpreter}"


%description
The oVirt external network provider for OVN allows to integrate oVirt with the
Open vSwitch Open Virtual Network (OVN) solution. OVN is a Software Defined
Networking extension to Open vSwitch. OVN is integrated into oVirt using the
external network API. The oVirt provider for OVN serves as a proxy between
oVirt engine and OVN Northbound DB.

%post
%systemd_post ovirt-provider-ovn.service


%preun
%systemd_preun ovirt-provider-ovn.service


%postun
%systemd_postun_with_restart ovirt-provider-ovn.service


%package driver
Summary: The virtual interface driver for oVirt external network provider for OVN
License: GPLv2+
BuildArch: noarch
Requires: firewalld-filesystem
Requires: kernel >= 3.10.0-512

Requires: openvswitch >= 0:2.7
Requires: openvswitch-ovn-host >= 0:2.7
Requires: openvswitch-ovn-common >= 0:2.7
Requires: %{required_ovs_lib} >= 0:2.7

Conflicts: openvswitch = 1:2.6.1
Conflicts: openvswitch-ovn-host = 1:2.6.1
Conflicts: openvswitch-ovn-common = 1:2.6.1
Conflicts: %{required_ovs_lib} = 1:2.6.1

Requires: vdsm
Requires(post): firewalld-filesystem

BuildRequires: %{required_python}
BuildRequires: %{required_python_devel}
BuildRequires: %{required_python_setup_tools}
BuildRequires: systemd

%description driver
The virtual interface driver for oVirt external network provider for OVN.
The driver handles the connection of virtual NICs provisioned on oVirt hosts
to OVN.


%files
%config(noreplace) %{_sysconfdir}/logrotate.d/ovirt-provider-ovn
%config(noreplace) %{_sysconfdir}/ovirt-provider-ovn/logger.conf
%{_sysconfdir}/ovirt-provider-ovn/ovirt-provider-ovn.conf
%{_sysconfdir}/ovirt-provider-ovn/conf.d/
%{_datadir}/ovirt-provider-ovn
%{_unitdir}/ovirt-provider-ovn.service
/usr/lib/firewalld/services/ovirt-provider-ovn.xml
%doc /usr/share/doc/ovirt-provider-ovn/README.adoc
%license LICENSE

%files driver
%{_libexecdir}/vdsm/hooks/before_nic_hotplug/
%{_libexecdir}/vdsm/hooks/before_device_create/
%{_libexecdir}/vdsm/hooks/after_get_caps/
%{_libexecdir}/vdsm/hooks/after_vm_destroy/
%{_libexecdir}/vdsm/vhostuser_permissions_setter
%{_libexecdir}/ovirt-provider-ovn
%{required_python_sitelib}/vdsm/tool/
%{_sysconfdir}/sudoers.d/50_vdsm_hook_ovirt_provider_ovn_hook
%license LICENSE


%changelog
* Mon Sep 28 2020 Dominik Holler <dholler@redhat.com> - 1.2.32
- configure for scaling scenarios - bz#1871819

* Tue Aug 25 2020 Dominik Holler <dholler@redhat.com> - 1.2.31
- improve scaling of port listing - bz#1835550

* Tue Mar 24 2020 Dominik Holler <dholler@redhat.com> - 1.2.30
- ovirt-provider-ovn.conf is no config file - bz#1701121
- clear the port dhcp_options in tx scope - bz#1795236

* Mon Dec 16 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.29
- hardening against cross-site scripting vulnerabilities - bz#1757077

* Mon Nov 25 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.28
- el8 and fc30 builds added

* Wed Oct 09 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.27
- fix security groups remote group id for groups other than default
- fix ovirt-provider-ovn str-byte fix on json dump
- add plugin_type check to vhostuser_hook

* Thu Aug 22 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.26
- fix security groups issues on groups other than default - bz#1744235

* Wed Jul 24 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.25
- update BuildRequires section with python-devel packages

* Wed Jul 10 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.24
- allow correct deployment of ovirt node on fedora29 hosts

* Wed Jun 26 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.23
- create/update/remove logical ports within a single transaction object
- create/update/remove security groups within a single transaction object
- create/remove security group rules within a single transaction object
- package the ovirt-provider-ovn-driver for python3 - on fedora / el8
- logical routers can now be disabled - bz#1723800

* Thu May 09 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.22
- fix error handling on python3
- fix error where ipv6 subnets could not be removed from routers
- implement default keystone route

* Thu Apr 11 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.21
- stateless dhcpv6 on ipv6 subnets
- package the provider for python3 - on fedora / el8
- fix IPv6 subnet gateway
- bail out of driver after_get_caps hooks when ovs is not available

* Mon Feb 18 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.20
- fix dhcpv6 options
- default security group rule ethertype to IPv4

* Tue Jan 22 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.19
- subnet ipv6 support
- fix disabling port security on logical ports

* Mon Jan 14 2019 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.18
- configurable TLS ciphers
- comply with networking API on network updates
- comply with networking API on port creation

* Thu Nov 15 2018 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.17
- comply with the networking api for security group rule GET requests
- implement the remote group prefix parameter for security groups
- implement the acls in the correct OVS pipeline stage
- support unicode characters on security group names
- support unicode characters on network names

* Wed Oct 03 2018 Miguel Duarte Barroso <mdbarroso@redhat.com> - 1.2.16
- add security group support on the provider

* Mon Mar 13 2017 Dominik Holler <dholler@redhat.com> - 1.1
- add dependecy python-requests

* Fri Aug  26 2016 Marcin Mirecki
-
