/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.StringArrayReader;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaRecognizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TreeWalker
extends AbstractFileSetCheck {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final Map mTokenToChecks = new HashMap();
    private final Set mAllChecks = new HashSet();
    private int mTabWidth = 8;
    private PropertyCacheFile mCache = new PropertyCacheFile(null, null);
    private ClassLoader mClassLoader;
    private Context mChildContext;
    private ModuleFactory mModuleFactory;
    private final boolean mRecursive;
    private static final Log LOG = LogFactory.getLog((String)"com.puppycrawl.tools.checkstyle.TreeWalker");

    public TreeWalker() {
        this.setFileExtensions(new String[]{"java"});
        String recursive = System.getProperty("checkstyle.use.recursive.algorithm", "false");
        this.mRecursive = "true".equals(recursive);
        if (this.mRecursive) {
            LOG.debug((Object)"TreeWalker uses recursive algorithm");
        } else {
            LOG.debug((Object)"TreeWalker uses iterative algorithm");
        }
    }

    public void setTabWidth(int aTabWidth) {
        this.mTabWidth = aTabWidth;
    }

    public void setCacheFile(String aFileName) {
        Configuration configuration = this.getConfiguration();
        this.mCache = new PropertyCacheFile(configuration, aFileName);
    }

    public void setClassLoader(ClassLoader aClassLoader) {
        this.mClassLoader = aClassLoader;
    }

    public void setModuleFactory(ModuleFactory aModuleFactory) {
        this.mModuleFactory = aModuleFactory;
    }

    public void finishLocalSetup() {
        DefaultContext checkContext = new DefaultContext();
        checkContext.add("classLoader", this.mClassLoader);
        checkContext.add("messages", this.getMessageCollector());
        checkContext.add("severity", this.getSeverity());
        checkContext.add("tabWidth", String.valueOf(this.mTabWidth));
        this.mChildContext = checkContext;
    }

    public void setupChild(Configuration aChildConf) throws CheckstyleException {
        String name = aChildConf.getName();
        Object module = this.mModuleFactory.createModule(name);
        if (!(module instanceof Check)) {
            throw new CheckstyleException("TreeWalker is not allowed as a parent of " + name);
        }
        Check c = (Check)module;
        c.contextualize(this.mChildContext);
        c.configure(aChildConf);
        c.init();
        this.registerCheck(c);
    }

    private void process(File aFile) {
        long timestamp;
        String fileName = aFile.getPath();
        if (this.mCache.alreadyChecked(fileName, timestamp = aFile.lastModified())) {
            return;
        }
        try {
            this.getMessageDispatcher().fireFileStarted(fileName);
            String[] lines = Utils.getLines(fileName, this.getCharset());
            FileContents contents = new FileContents(fileName, lines);
            DetailAST rootAST = TreeWalker.parse(contents);
            this.walk(rootAST, contents);
        }
        catch (FileNotFoundException fnfe) {
            Utils.getExceptionLogger().debug((Object)"FileNotFoundException occured.", (Throwable)fnfe);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.fileNotFound", null, this.getId(), this.getClass()));
        }
        catch (IOException ioe) {
            Utils.getExceptionLogger().debug((Object)"IOException occured.", (Throwable)ioe);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{ioe.getMessage()}, this.getId(), this.getClass()));
        }
        catch (RecognitionException re) {
            Utils.getExceptionLogger().debug((Object)"RecognitionException occured.", (Throwable)re);
            this.getMessageCollector().add(new LocalizedMessage(re.getLine(), re.getColumn(), "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{re.getMessage()}, this.getId(), this.getClass()));
        }
        catch (TokenStreamRecognitionException tre) {
            Utils.getExceptionLogger().debug((Object)"TokenStreamRecognitionException occured.", (Throwable)tre);
            RecognitionException re = tre.recog;
            if (re != null) {
                this.getMessageCollector().add(new LocalizedMessage(re.getLine(), re.getColumn(), "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{re.getMessage()}, this.getId(), this.getClass()));
            } else {
                this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{"TokenStreamRecognitionException occured."}, this.getId(), this.getClass()));
            }
        }
        catch (TokenStreamException te) {
            Utils.getExceptionLogger().debug((Object)"TokenStreamException occured.", (Throwable)te);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{te.getMessage()}, this.getId(), this.getClass()));
        }
        catch (Throwable err) {
            Utils.getExceptionLogger().debug((Object)"Throwable occured.", err);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{"" + err}, this.getId(), this.getClass()));
        }
        if (this.getMessageCollector().size() == 0) {
            this.mCache.checkedOk(fileName, timestamp);
        } else {
            this.fireErrors(fileName);
        }
        this.getMessageDispatcher().fireFileFinished(fileName);
    }

    private void registerCheck(Check aCheck) throws CheckstyleException {
        int[] tokens = new int[]{};
        Set checkTokens = aCheck.getTokenNames();
        if (!checkTokens.isEmpty()) {
            tokens = aCheck.getRequiredTokens();
            int[] acceptableTokens = aCheck.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            Iterator it = checkTokens.iterator();
            while (it.hasNext()) {
                String token = (String)it.next();
                try {
                    int tokenId = TokenTypes.getTokenId(token);
                    if (Arrays.binarySearch(acceptableTokens, tokenId) < 0) continue;
                    this.registerCheck(token, aCheck);
                }
                catch (IllegalArgumentException ex) {
                    throw new CheckstyleException("illegal token \"" + token + "\" in check " + aCheck, ex);
                }
            }
        } else {
            tokens = aCheck.getDefaultTokens();
        }
        for (int i = 0; i < tokens.length; ++i) {
            this.registerCheck(tokens[i], aCheck);
        }
        this.mAllChecks.add(aCheck);
    }

    private void registerCheck(int aTokenID, Check aCheck) {
        this.registerCheck(TokenTypes.getTokenName(aTokenID), aCheck);
    }

    private void registerCheck(String aToken, Check aCheck) {
        ArrayList<Check> visitors = (ArrayList<Check>)this.mTokenToChecks.get(aToken);
        if (visitors == null) {
            visitors = new ArrayList<Check>();
            this.mTokenToChecks.put(aToken, visitors);
        }
        visitors.add(aCheck);
    }

    private void walk(DetailAST aAST, FileContents aContents) {
        this.getMessageCollector().reset();
        this.notifyBegin(aAST, aContents);
        if (aAST != null) {
            if (this.useRecursiveAlgorithm()) {
                this.processRec(aAST);
            } else {
                this.processIter(aAST);
            }
        }
        this.notifyEnd(aAST);
    }

    private void notifyBegin(DetailAST aRootAST, FileContents aContents) {
        Iterator it = this.mAllChecks.iterator();
        while (it.hasNext()) {
            Check check = (Check)it.next();
            check.setFileContents(aContents);
            check.beginTree(aRootAST);
        }
    }

    private void notifyEnd(DetailAST aRootAST) {
        Iterator it = this.mAllChecks.iterator();
        while (it.hasNext()) {
            Check check = (Check)it.next();
            check.finishTree(aRootAST);
        }
    }

    private void processRec(DetailAST aAST) {
        if (aAST == null) {
            return;
        }
        this.notifyVisit(aAST);
        DetailAST child = (DetailAST)aAST.getFirstChild();
        if (child != null) {
            this.processRec(child);
        }
        this.notifyLeave(aAST);
        DetailAST sibling = (DetailAST)aAST.getNextSibling();
        if (sibling != null) {
            this.processRec(sibling);
        }
    }

    private void notifyVisit(DetailAST aAST) {
        ArrayList visitors = (ArrayList)this.mTokenToChecks.get(TokenTypes.getTokenName(aAST.getType()));
        if (visitors != null) {
            for (int i = 0; i < visitors.size(); ++i) {
                Check check = (Check)visitors.get(i);
                check.visitToken(aAST);
            }
        }
    }

    private void notifyLeave(DetailAST aAST) {
        ArrayList visitors = (ArrayList)this.mTokenToChecks.get(TokenTypes.getTokenName(aAST.getType()));
        if (visitors != null) {
            for (int i = 0; i < visitors.size(); ++i) {
                Check check = (Check)visitors.get(i);
                check.leaveToken(aAST);
            }
        }
    }

    public static DetailAST parse(FileContents aContents) throws RecognitionException, TokenStreamException {
        DetailAST rootAST = null;
        try {
            rootAST = TreeWalker.parse(aContents, true, true, true);
        }
        catch (RecognitionException exception) {
            try {
                rootAST = TreeWalker.parse(aContents, true, true, false);
            }
            catch (RecognitionException exception2) {
                rootAST = TreeWalker.parse(aContents, false, false, false);
            }
        }
        return rootAST;
    }

    private static DetailAST parse(FileContents aContents, boolean aSilentlyConsumeErrors, boolean aTreatAssertAsKeyword, boolean aTreatEnumAsKeyword) throws RecognitionException, TokenStreamException {
        StringArrayReader sar = new StringArrayReader(aContents.getLines());
        GeneratedJavaLexer lexer = new GeneratedJavaLexer(sar);
        lexer.setFilename(aContents.getFilename());
        lexer.setCommentListener(aContents);
        lexer.setTreatAssertAsKeyword(aTreatAssertAsKeyword);
        lexer.setTreatEnumAsKeyword(aTreatEnumAsKeyword);
        GeneratedJavaRecognizer parser = aSilentlyConsumeErrors ? new SilentJavaRecognizer(lexer) : new GeneratedJavaRecognizer(lexer);
        parser.setFilename(aContents.getFilename());
        parser.setASTNodeClass(DetailAST.class.getName());
        parser.compilationUnit();
        return (DetailAST)parser.getAST();
    }

    public void process(File[] aFiles) {
        File[] javaFiles = this.filter(aFiles);
        for (int i = 0; i < javaFiles.length; ++i) {
            this.process(javaFiles[i]);
        }
    }

    public void destroy() {
        Iterator it = this.mAllChecks.iterator();
        while (it.hasNext()) {
            Check c = (Check)it.next();
            c.destroy();
        }
        this.mCache.destroy();
        super.destroy();
    }

    private boolean useRecursiveAlgorithm() {
        return this.mRecursive;
    }

    private void processIter(DetailAST aRoot) {
        DetailAST curNode = aRoot;
        while (curNode != null) {
            this.notifyVisit(curNode);
            DetailAST toVisit = (DetailAST)curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.notifyLeave(curNode);
                toVisit = (DetailAST)curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static final class SilentJavaRecognizer
    extends GeneratedJavaRecognizer {
        public SilentJavaRecognizer(TokenStream aLexer) {
            super(aLexer);
        }

        public void reportError(RecognitionException aRex) {
        }

        public void reportError(String aMsg) {
        }

        public void reportWarning(String aMsg) {
        }
    }
}

