#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Mon Aug 27 11:32:06 2012 by generateDS.py version 2.7b.
#

import sys
import getopt
import re as re_

# Begin NOT_GENERATED
from ovirtsdk.utils.reflectionhelper import ReflectionHelper
from ovirtsdk.utils.comperator import Comparator
# End NOT_GENERATED

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        # Begin NOT_GENERATED
        def __setattr__(self, item, value):
            if (value is not None and
                not isinstance(value, list) and
                ReflectionHelper.isModuleMember(
                    sys.modules['ovirtsdk.infrastructure.brokers'],
                    type(value)) and
                not ReflectionHelper.isModuleMember(sys.modules[__name__],
                    type(value)) and
                value.__dict__.has_key('superclass') and
                value.superclass is not None and
                value.superclass != BaseResource):
                if (ReflectionHelper.isModuleMember(
                        sys.modules['ovirtsdk.infrastructure.brokers'],
                        type(self)) and
                   self.__dict__.has_key('superclass') and
                   self.superclass is not None):
                    object.__setattr__(self.superclass, item, value.superclass)
                else:
                    object.__setattr__(self, item, value.superclass)
            elif (not isinstance(value, list) and
                 ReflectionHelper.isModuleMember(
                         sys.modules['ovirtsdk.infrastructure.brokers'],
                         type(self)) and
                 self.__dict__.has_key('superclass') and
                 self.superclass is not None and
                 not ReflectionHelper.isModuleMember(
                         sys.modules['ovirtsdk.infrastructure.brokers'],
                         type(value)) and
                 item is not 'superclass' and
                 item is not 'parentclass'):
                object.__setattr__(self.superclass, item, value)
            elif isinstance(value, list):
                parsed_list = []
                for obj in value:
                    if (ReflectionHelper.isModuleMember(
                            sys.modules['ovirtsdk.infrastructure.brokers'],
                            type(obj)) and
                       obj.__dict__.has_key('superclass') and
                       obj.superclass is not None and
                       item is not 'superclass' and
                       item is not 'parentclass'):
                        parsed_list.append(obj.superclass)
                    else:
                        parsed_list.append(obj)
                object.__setattr__(self, item, parsed_list)
            else:
                object.__setattr__(self, item, value)

        def __eq__(self, other):
            return Comparator.compare(self, other)

        def __ne__(self, other):
            return not self.__eq__(other)
        # End NOT_GENERATED


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'UTF-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class KeyValuePair(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if KeyValuePair.subclass:
            return KeyValuePair.subclass(*args_, **kwargs_)
        else:
            return KeyValuePair(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def export(self, outfile, level, namespace_='', name_='KeyValuePair', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KeyValuePair')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='KeyValuePair'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='KeyValuePair', fromsubclass_=False):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('<%skey>%s</%skey>\n' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='KeyValuePair'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class KeyValuePair


class LinkCapabilities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, searchable=None):
        self.searchable = searchable
    def factory(*args_, **kwargs_):
        if LinkCapabilities.subclass:
            return LinkCapabilities.subclass(*args_, **kwargs_)
        else:
            return LinkCapabilities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_searchable(self): return self.searchable
    def set_searchable(self, searchable): self.searchable = searchable
    def export(self, outfile, level, namespace_='', name_='LinkCapabilities', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkCapabilities')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinkCapabilities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LinkCapabilities', fromsubclass_=False):
        if self.searchable is not None:
            showIndent(outfile, level)
            outfile.write('<%ssearchable>%s</%ssearchable>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.searchable)), input_name='searchable'), namespace_))
    def hasContent_(self):
        if (
            self.searchable is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LinkCapabilities'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.searchable is not None:
            showIndent(outfile, level)
            outfile.write('searchable=%s,\n' % self.searchable)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'searchable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'searchable')
            self.searchable = ival_
# end class LinkCapabilities


class DetailedLinks(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, link=None):
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if DetailedLinks.subclass:
            return DetailedLinks.subclass(*args_, **kwargs_)
        else:
            return DetailedLinks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def export(self, outfile, level, namespace_='', name_='DetailedLinks', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DetailedLinks')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DetailedLinks'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DetailedLinks', fromsubclass_=False):
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link')
    def hasContent_(self):
        if (
            self.link
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DetailedLinks'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.DetailedLink(\n')
            link_.exportLiteral(outfile, level, name_='DetailedLink')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            obj_ = DetailedLink.factory()
            obj_.build(child_)
            self.link.append(obj_)
# end class DetailedLinks


class Link(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, href=None, rel=None, extensiontype_=None):
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Link.subclass:
            return Link.subclass(*args_, **kwargs_)
        else:
            return Link(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='Link', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Link')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Link'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Link', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Link'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            showIndent(outfile, level)
            outfile.write('href = "%s",\n' % (self.href,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            showIndent(outfile, level)
            outfile.write('rel = "%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.append('href')
            self.href = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            self.rel = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Link


class ApiSummary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vms=None, hosts=None, users=None, storage_domains=None):
        self.vms = vms
        self.hosts = hosts
        self.users = users
        self.storage_domains = storage_domains
    def factory(*args_, **kwargs_):
        if ApiSummary.subclass:
            return ApiSummary.subclass(*args_, **kwargs_)
        else:
            return ApiSummary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vms(self): return self.vms
    def set_vms(self, vms): self.vms = vms
    def get_hosts(self): return self.hosts
    def set_hosts(self, hosts): self.hosts = hosts
    def get_users(self): return self.users
    def set_users(self, users): self.users = users
    def get_storage_domains(self): return self.storage_domains
    def set_storage_domains(self, storage_domains): self.storage_domains = storage_domains
    def export(self, outfile, level, namespace_='', name_='ApiSummary', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ApiSummary')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ApiSummary'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ApiSummary', fromsubclass_=False):
        if self.vms is not None:
            self.vms.export(outfile, level, namespace_, name_='vms')
        if self.hosts is not None:
            self.hosts.export(outfile, level, namespace_, name_='hosts')
        if self.users is not None:
            self.users.export(outfile, level, namespace_, name_='users')
        if self.storage_domains is not None:
            self.storage_domains.export(outfile, level, namespace_, name_='storage_domains')
    def hasContent_(self):
        if (
            self.vms is not None or
            self.hosts is not None or
            self.users is not None or
            self.storage_domains is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ApiSummary'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.vms is not None:
            showIndent(outfile, level)
            outfile.write('vms=model_.vms(\n')
            self.vms.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hosts is not None:
            showIndent(outfile, level)
            outfile.write('hosts=model_.hosts(\n')
            self.hosts.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.users is not None:
            showIndent(outfile, level)
            outfile.write('users=model_.users(\n')
            self.users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domains is not None:
            showIndent(outfile, level)
            outfile.write('storage_domains=model_.storage_domains(\n')
            self.storage_domains.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vms':
            obj_ = VMs.factory()
            obj_.build(child_)
            self.set_vms(obj_)
        elif nodeName_ == 'hosts':
            obj_ = Hosts.factory()
            obj_.build(child_)
            self.set_hosts(obj_)
        elif nodeName_ == 'users':
            obj_ = Users.factory()
            obj_.build(child_)
            self.set_users(obj_)
        elif nodeName_ == 'storage_domains':
            obj_ = StorageDomains.factory()
            obj_.build(child_)
            self.set_storage_domains(obj_)
# end class ApiSummary


class Fault(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, reason=None, detail=None):
        self.reason = reason
        self.detail = detail
    def factory(*args_, **kwargs_):
        if Fault.subclass:
            return Fault.subclass(*args_, **kwargs_)
        else:
            return Fault(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reason(self): return self.reason
    def set_reason(self, reason): self.reason = reason
    def get_detail(self): return self.detail
    def set_detail(self, detail): self.detail = detail
    def export(self, outfile, level, namespace_='', name_='Fault', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Fault')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Fault'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Fault', fromsubclass_=False):
        if self.reason is not None:
            showIndent(outfile, level)
            outfile.write('<%sreason>%s</%sreason>\n' % (namespace_, self.gds_format_string(quote_xml(self.reason).encode(ExternalEncoding), input_name='reason'), namespace_))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('<%sdetail>%s</%sdetail>\n' % (namespace_, self.gds_format_string(quote_xml(self.detail).encode(ExternalEncoding), input_name='detail'), namespace_))
    def hasContent_(self):
        if (
            self.reason is not None or
            self.detail is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Fault'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.reason is not None:
            showIndent(outfile, level)
            outfile.write('reason=%s,\n' % quote_python(self.reason).encode(ExternalEncoding))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('detail=%s,\n' % quote_python(self.detail).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reason':
            reason_ = child_.text
            reason_ = self.gds_validate_string(reason_, node, 'reason')
            self.reason = reason_
        elif nodeName_ == 'detail':
            detail_ = child_.text
            detail_ = self.gds_validate_string(detail_, node, 'detail')
            self.detail = detail_
# end class Fault


class GracePeriod(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, expiry=None):
        self.expiry = expiry
    def factory(*args_, **kwargs_):
        if GracePeriod.subclass:
            return GracePeriod.subclass(*args_, **kwargs_)
        else:
            return GracePeriod(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_expiry(self): return self.expiry
    def set_expiry(self, expiry): self.expiry = expiry
    def export(self, outfile, level, namespace_='', name_='GracePeriod', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GracePeriod')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GracePeriod'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GracePeriod', fromsubclass_=False):
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('<%sexpiry>%s</%sexpiry>\n' % (namespace_, self.gds_format_integer(self.expiry, input_name='expiry'), namespace_))
    def hasContent_(self):
        if (
            self.expiry is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GracePeriod'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('expiry=%d,\n' % self.expiry)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expiry':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'expiry')
            self.expiry = ival_
# end class GracePeriod


class IscsiDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, initiator=None, address=None, port=None, target=None, username=None, password=None, serial=None, vendor_id=None, product_id=None, lun_mapping=None, portal=None, size=None, paths=None, status=None, volume_group_id=None, storage_domain_id=None, disk_id=None):
        self.initiator = initiator
        self.address = address
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.serial = serial
        self.vendor_id = vendor_id
        self.product_id = product_id
        self.lun_mapping = lun_mapping
        self.portal = portal
        self.size = size
        self.paths = paths
        self.status = status
        self.volume_group_id = volume_group_id
        self.storage_domain_id = storage_domain_id
        self.disk_id = disk_id
    def factory(*args_, **kwargs_):
        if IscsiDetails.subclass:
            return IscsiDetails.subclass(*args_, **kwargs_)
        else:
            return IscsiDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_initiator(self): return self.initiator
    def set_initiator(self, initiator): self.initiator = initiator
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_serial(self): return self.serial
    def set_serial(self, serial): self.serial = serial
    def get_vendor_id(self): return self.vendor_id
    def set_vendor_id(self, vendor_id): self.vendor_id = vendor_id
    def get_product_id(self): return self.product_id
    def set_product_id(self, product_id): self.product_id = product_id
    def get_lun_mapping(self): return self.lun_mapping
    def set_lun_mapping(self, lun_mapping): self.lun_mapping = lun_mapping
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_paths(self): return self.paths
    def set_paths(self, paths): self.paths = paths
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_volume_group_id(self): return self.volume_group_id
    def set_volume_group_id(self, volume_group_id): self.volume_group_id = volume_group_id
    def get_storage_domain_id(self): return self.storage_domain_id
    def set_storage_domain_id(self, storage_domain_id): self.storage_domain_id = storage_domain_id
    def get_disk_id(self): return self.disk_id
    def set_disk_id(self, disk_id): self.disk_id = disk_id
    def export(self, outfile, level, namespace_='', name_='IscsiDetails', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IscsiDetails')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IscsiDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='IscsiDetails', fromsubclass_=False):
        if self.initiator is not None:
            showIndent(outfile, level)
            outfile.write('<%sinitiator>%s</%sinitiator>\n' % (namespace_, self.gds_format_string(quote_xml(self.initiator).encode(ExternalEncoding), input_name='initiator'), namespace_))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('<%saddress>%s</%saddress>\n' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('<%sport>%s</%sport>\n' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_))
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('<%starget>%s</%starget>\n' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('<%susername>%s</%susername>\n' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('<%spassword>%s</%spassword>\n' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('<%sserial>%s</%sserial>\n' % (namespace_, self.gds_format_string(quote_xml(self.serial).encode(ExternalEncoding), input_name='serial'), namespace_))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('<%svendor_id>%s</%svendor_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.vendor_id).encode(ExternalEncoding), input_name='vendor_id'), namespace_))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('<%sproduct_id>%s</%sproduct_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.product_id).encode(ExternalEncoding), input_name='product_id'), namespace_))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('<%slun_mapping>%s</%slun_mapping>\n' % (namespace_, self.gds_format_integer(self.lun_mapping, input_name='lun_mapping'), namespace_))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('<%sportal>%s</%sportal>\n' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('<%ssize>%s</%ssize>\n' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_))
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('<%spaths>%s</%spaths>\n' % (namespace_, self.gds_format_integer(self.paths, input_name='paths'), namespace_))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('<%sstatus>%s</%sstatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('<%svolume_group_id>%s</%svolume_group_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.volume_group_id).encode(ExternalEncoding), input_name='volume_group_id'), namespace_))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('<%sstorage_domain_id>%s</%sstorage_domain_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.storage_domain_id).encode(ExternalEncoding), input_name='storage_domain_id'), namespace_))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('<%sdisk_id>%s</%sdisk_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.disk_id).encode(ExternalEncoding), input_name='disk_id'), namespace_))
    def hasContent_(self):
        if (
            self.initiator is not None or
            self.address is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.serial is not None or
            self.vendor_id is not None or
            self.product_id is not None or
            self.lun_mapping is not None or
            self.portal is not None or
            self.size is not None or
            self.paths is not None or
            self.status is not None or
            self.volume_group_id is not None or
            self.storage_domain_id is not None or
            self.disk_id is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IscsiDetails'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.initiator is not None:
            showIndent(outfile, level)
            outfile.write('initiator=%s,\n' % quote_python(self.initiator).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('serial=%s,\n' % quote_python(self.serial).encode(ExternalEncoding))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('vendor_id=%s,\n' % quote_python(self.vendor_id).encode(ExternalEncoding))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('product_id=%s,\n' % quote_python(self.product_id).encode(ExternalEncoding))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('lun_mapping=%d,\n' % self.lun_mapping)
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('paths=%d,\n' % self.paths)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_group_id=%s,\n' % quote_python(self.volume_group_id).encode(ExternalEncoding))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_id=%s,\n' % quote_python(self.storage_domain_id).encode(ExternalEncoding))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('disk_id=%s,\n' % quote_python(self.disk_id).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'initiator':
            initiator_ = child_.text
            initiator_ = self.gds_validate_string(initiator_, node, 'initiator')
            self.initiator = initiator_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'serial':
            serial_ = child_.text
            serial_ = self.gds_validate_string(serial_, node, 'serial')
            self.serial = serial_
        elif nodeName_ == 'vendor_id':
            vendor_id_ = child_.text
            vendor_id_ = self.gds_validate_string(vendor_id_, node, 'vendor_id')
            self.vendor_id = vendor_id_
        elif nodeName_ == 'product_id':
            product_id_ = child_.text
            product_id_ = self.gds_validate_string(product_id_, node, 'product_id')
            self.product_id = product_id_
        elif nodeName_ == 'lun_mapping':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'lun_mapping')
            self.lun_mapping = ival_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'paths':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'paths')
            self.paths = ival_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'volume_group_id':
            volume_group_id_ = child_.text
            volume_group_id_ = self.gds_validate_string(volume_group_id_, node, 'volume_group_id')
            self.volume_group_id = volume_group_id_
        elif nodeName_ == 'storage_domain_id':
            storage_domain_id_ = child_.text
            storage_domain_id_ = self.gds_validate_string(storage_domain_id_, node, 'storage_domain_id')
            self.storage_domain_id = storage_domain_id_
        elif nodeName_ == 'disk_id':
            disk_id_ = child_.text
            disk_id_ = self.gds_validate_string(disk_id_, node, 'disk_id')
            self.disk_id = disk_id_
# end class IscsiDetails


class Actions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, link=None):
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if Actions.subclass:
            return Actions.subclass(*args_, **kwargs_)
        else:
            return Actions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def export(self, outfile, level, namespace_='', name_='Actions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Actions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Actions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Actions', fromsubclass_=False):
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link')
    def hasContent_(self):
        if (
            self.link
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Actions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, Link)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
# end class Actions


class Status(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, state=None, detail=None):
        self.state = state
        self.detail = detail
    def factory(*args_, **kwargs_):
        if Status.subclass:
            return Status.subclass(*args_, **kwargs_)
        else:
            return Status(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_detail(self): return self.detail
    def set_detail(self, detail): self.detail = detail
    def export(self, outfile, level, namespace_='', name_='Status', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Status')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Status'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Status', fromsubclass_=False):
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('<%sstate>%s</%sstate>\n' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('<%sdetail>%s</%sdetail>\n' % (namespace_, self.gds_format_string(quote_xml(self.detail).encode(ExternalEncoding), input_name='detail'), namespace_))
    def hasContent_(self):
        if (
            self.state is not None or
            self.detail is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Status'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('detail=%s,\n' % quote_python(self.detail).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
        elif nodeName_ == 'detail':
            detail_ = child_.text
            detail_ = self.gds_validate_string(detail_, node, 'detail')
            self.detail = detail_
# end class Status


class Usages(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, usage=None):
        if usage is None:
            self.usage = []
        else:
            self.usage = usage
    def factory(*args_, **kwargs_):
        if Usages.subclass:
            return Usages.subclass(*args_, **kwargs_)
        else:
            return Usages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_usage(self): return self.usage
    def set_usage(self, usage): self.usage = usage
    def add_usage(self, value): self.usage.append(value)
    def insert_usage(self, index, value): self.usage[index] = value
    def export(self, outfile, level, namespace_='', name_='Usages', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Usages')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Usages'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Usages', fromsubclass_=False):
        for usage_ in self.usage:
            showIndent(outfile, level)
            outfile.write('<%susage>%s</%susage>\n' % (namespace_, self.gds_format_string(quote_xml(usage_).encode(ExternalEncoding), input_name='usage'), namespace_))
    def hasContent_(self):
        if (
            self.usage
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Usages'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('usage=[\n')
        level += 1
        for usage_ in self.usage:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(usage_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'usage':
            usage_ = child_.text
            usage_ = self.gds_validate_string(usage_, node, 'usage')
            self.usage.append(usage_)
# end class Usages


class CreationStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, creation_state=None):
        if creation_state is None:
            self.creation_state = []
        else:
            self.creation_state = creation_state
    def factory(*args_, **kwargs_):
        if CreationStates.subclass:
            return CreationStates.subclass(*args_, **kwargs_)
        else:
            return CreationStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_creation_state(self): return self.creation_state
    def set_creation_state(self, creation_state): self.creation_state = creation_state
    def add_creation_state(self, value): self.creation_state.append(value)
    def insert_creation_state(self, index, value): self.creation_state[index] = value
    def export(self, outfile, level, namespace_='', name_='CreationStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CreationStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CreationStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CreationStates', fromsubclass_=False):
        for creation_state_ in self.creation_state:
            showIndent(outfile, level)
            outfile.write('<%screation_state>%s</%screation_state>\n' % (namespace_, self.gds_format_string(quote_xml(creation_state_).encode(ExternalEncoding), input_name='creation_state'), namespace_))
    def hasContent_(self):
        if (
            self.creation_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CreationStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('creation_state=[\n')
        level += 1
        for creation_state_ in self.creation_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(creation_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'creation_state':
            creation_state_ = child_.text
            creation_state_ = self.gds_validate_string(creation_state_, node, 'creation_state')
            self.creation_state.append(creation_state_)
# end class CreationStates


class Value(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, datum=None):
        self.datum = datum
    def factory(*args_, **kwargs_):
        if Value.subclass:
            return Value.subclass(*args_, **kwargs_)
        else:
            return Value(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datum(self): return self.datum
    def set_datum(self, datum): self.datum = datum
    def export(self, outfile, level, namespace_='', name_='Value', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Value')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Value'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Value', fromsubclass_=False):
        if self.datum is not None:
            showIndent(outfile, level)
            outfile.write('<%sdatum>%s</%sdatum>\n' % (namespace_, self.gds_format_float(self.datum, input_name='datum'), namespace_))
    def hasContent_(self):
        if (
            self.datum is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Value'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.datum is not None:
            showIndent(outfile, level)
            outfile.write('datum=%f,\n' % self.datum)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'datum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'datum')
            self.datum = fval_
# end class Value


class Values(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, value=None):
        self.type_ = _cast(None, type_)
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if Values.subclass:
            return Values.subclass(*args_, **kwargs_)
        else:
            return Values(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_ValueType(self, value):
        # Validate type ValueType, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='', name_='Values', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Values')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Values'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Values', fromsubclass_=False):
        for value_ in self.value:
            value_.export(outfile, level, namespace_, name_='value')
    def hasContent_(self):
        if (
            self.value
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Values'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('model_.value(\n')
            value_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.validate_ValueType(self.type_)    # validate type ValueType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            obj_ = Value.factory()
            obj_.build(child_)
            self.value.append(obj_)
# end class Values


class CpuTopology(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cores=None, sockets=None):
        self.cores = _cast(int, cores)
        self.sockets = _cast(int, sockets)
        pass
    def factory(*args_, **kwargs_):
        if CpuTopology.subclass:
            return CpuTopology.subclass(*args_, **kwargs_)
        else:
            return CpuTopology(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cores(self): return self.cores
    def set_cores(self, cores): self.cores = cores
    def get_sockets(self): return self.sockets
    def set_sockets(self, sockets): self.sockets = sockets
    def export(self, outfile, level, namespace_='', name_='CpuTopology', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuTopology')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuTopology'):
        if self.cores is not None and 'cores' not in already_processed:
            already_processed.append('cores')
            outfile.write(' cores="%s"' % self.gds_format_integer(self.cores, input_name='cores'))
        if self.sockets is not None and 'sockets' not in already_processed:
            already_processed.append('sockets')
            outfile.write(' sockets="%s"' % self.gds_format_integer(self.sockets, input_name='sockets'))
    def exportChildren(self, outfile, level, namespace_='', name_='CpuTopology', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CpuTopology'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.cores is not None and 'cores' not in already_processed:
            already_processed.append('cores')
            showIndent(outfile, level)
            outfile.write('cores = %d,\n' % (self.cores,))
        if self.sockets is not None and 'sockets' not in already_processed:
            already_processed.append('sockets')
            showIndent(outfile, level)
            outfile.write('sockets = %d,\n' % (self.sockets,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cores', node)
        if value is not None and 'cores' not in already_processed:
            already_processed.append('cores')
            try:
                self.cores = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('sockets', node)
        if value is not None and 'sockets' not in already_processed:
            already_processed.append('sockets')
            try:
                self.sockets = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CpuTopology


class VCpuPin(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vcpu=None, cpu_set=None):
        self.vcpu = _cast(int, vcpu)
        self.cpu_set = _cast(None, cpu_set)
        pass
    def factory(*args_, **kwargs_):
        if VCpuPin.subclass:
            return VCpuPin.subclass(*args_, **kwargs_)
        else:
            return VCpuPin(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vcpu(self): return self.vcpu
    def set_vcpu(self, vcpu): self.vcpu = vcpu
    def get_cpu_set(self): return self.cpu_set
    def set_cpu_set(self, cpu_set): self.cpu_set = cpu_set
    def export(self, outfile, level, namespace_='', name_='VCpuPin', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCpuPin')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCpuPin'):
        if self.vcpu is not None and 'vcpu' not in already_processed:
            already_processed.append('vcpu')
            outfile.write(' vcpu="%s"' % self.gds_format_integer(self.vcpu, input_name='vcpu'))
        if self.cpu_set is not None and 'cpu_set' not in already_processed:
            already_processed.append('cpu_set')
            outfile.write(' cpu_set=%s' % (self.gds_format_string(quote_attrib(self.cpu_set).encode(ExternalEncoding), input_name='cpu_set'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VCpuPin', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VCpuPin'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vcpu is not None and 'vcpu' not in already_processed:
            already_processed.append('vcpu')
            showIndent(outfile, level)
            outfile.write('vcpu = %d,\n' % (self.vcpu,))
        if self.cpu_set is not None and 'cpu_set' not in already_processed:
            already_processed.append('cpu_set')
            showIndent(outfile, level)
            outfile.write('cpu_set = "%s",\n' % (self.cpu_set,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vcpu', node)
        if value is not None and 'vcpu' not in already_processed:
            already_processed.append('vcpu')
            try:
                self.vcpu = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpu_set', node)
        if value is not None and 'cpu_set' not in already_processed:
            already_processed.append('cpu_set')
            self.cpu_set = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VCpuPin


class CpuTune(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vcpu_pin=None):
        if vcpu_pin is None:
            self.vcpu_pin = []
        else:
            self.vcpu_pin = vcpu_pin
    def factory(*args_, **kwargs_):
        if CpuTune.subclass:
            return CpuTune.subclass(*args_, **kwargs_)
        else:
            return CpuTune(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vcpu_pin(self): return self.vcpu_pin
    def set_vcpu_pin(self, vcpu_pin): self.vcpu_pin = vcpu_pin
    def add_vcpu_pin(self, value): self.vcpu_pin.append(value)
    def insert_vcpu_pin(self, index, value): self.vcpu_pin[index] = value
    def export(self, outfile, level, namespace_='', name_='CpuTune', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuTune')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuTune'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CpuTune', fromsubclass_=False):
        for vcpu_pin_ in self.vcpu_pin:
            vcpu_pin_.export(outfile, level, namespace_, name_='vcpu_pin')
    def hasContent_(self):
        if (
            self.vcpu_pin
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CpuTune'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vcpu_pin=[\n')
        level += 1
        for vcpu_pin_ in self.vcpu_pin:
            showIndent(outfile, level)
            outfile.write('model_.VCpuPin(\n')
            vcpu_pin_.exportLiteral(outfile, level, name_='VCpuPin')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vcpu_pin':
            obj_ = VCpuPin.factory()
            obj_.build(child_)
            self.vcpu_pin.append(obj_)
# end class CpuTune


class CPU(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, topology=None, level=None, name=None, speed=None, cpu_tune=None):
        self.id = _cast(None, id)
        self.topology = topology
        self.level = level
        self.name = name
        self.speed = speed
        self.cpu_tune = cpu_tune
    def factory(*args_, **kwargs_):
        if CPU.subclass:
            return CPU.subclass(*args_, **kwargs_)
        else:
            return CPU(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_topology(self): return self.topology
    def set_topology(self, topology): self.topology = topology
    def get_level(self): return self.level
    def set_level(self, level): self.level = level
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_speed(self): return self.speed
    def set_speed(self, speed): self.speed = speed
    def get_cpu_tune(self): return self.cpu_tune
    def set_cpu_tune(self, cpu_tune): self.cpu_tune = cpu_tune
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='CPU', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPU')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CPU'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CPU', fromsubclass_=False):
        if self.topology is not None:
            self.topology.export(outfile, level, namespace_, name_='topology')
        if self.level is not None:
            showIndent(outfile, level)
            outfile.write('<%slevel>%s</%slevel>\n' % (namespace_, self.gds_format_integer(self.level, input_name='level'), namespace_))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.speed is not None:
            showIndent(outfile, level)
            outfile.write('<%sspeed>%s</%sspeed>\n' % (namespace_, self.gds_format_float(self.speed, input_name='speed'), namespace_))
        if self.cpu_tune is not None:
            self.cpu_tune.export(outfile, level, namespace_, name_='cpu_tune')
    def hasContent_(self):
        if (
            self.topology is not None or
            self.level is not None or
            self.name is not None or
            self.speed is not None or
            self.cpu_tune is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CPU'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.topology is not None:
            showIndent(outfile, level)
            outfile.write('topology=model_.CpuTopology(\n')
            self.topology.exportLiteral(outfile, level, name_='topology')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.level is not None:
            showIndent(outfile, level)
            outfile.write('level=%d,\n' % self.level)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.speed is not None:
            showIndent(outfile, level)
            outfile.write('speed=%f,\n' % self.speed)
        if self.cpu_tune is not None:
            showIndent(outfile, level)
            outfile.write('cpu_tune=model_.CpuTune(\n')
            self.cpu_tune.exportLiteral(outfile, level, name_='cpu_tune')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'topology':
            obj_ = CpuTopology.factory()
            obj_.build(child_)
            self.set_topology(obj_)
        elif nodeName_ == 'level':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'level')
            self.level = ival_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'speed':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'speed')
            self.speed = fval_
        elif nodeName_ == 'cpu_tune':
            obj_ = CpuTune.factory()
            obj_.build(child_)
            self.set_cpu_tune(obj_)
# end class CPU


class CPUs(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cpu=None):
        if cpu is None:
            self.cpu = []
        else:
            self.cpu = cpu
    def factory(*args_, **kwargs_):
        if CPUs.subclass:
            return CPUs.subclass(*args_, **kwargs_)
        else:
            return CPUs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def add_cpu(self, value): self.cpu.append(value)
    def insert_cpu(self, index, value): self.cpu[index] = value
    def export(self, outfile, level, namespace_='', name_='CPUs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPUs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CPUs'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CPUs', fromsubclass_=False):
        for cpu_ in self.cpu:
            cpu_.export(outfile, level, namespace_, name_='cpu')
    def hasContent_(self):
        if (
            self.cpu
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CPUs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('cpu=[\n')
        level += 1
        for cpu_ in self.cpu:
            showIndent(outfile, level)
            outfile.write('model_.cpu(\n')
            cpu_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.cpu.append(obj_)
# end class CPUs


class SupportedVersions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, version=None):
        if version is None:
            self.version = []
        else:
            self.version = version
    def factory(*args_, **kwargs_):
        if SupportedVersions.subclass:
            return SupportedVersions.subclass(*args_, **kwargs_)
        else:
            return SupportedVersions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def add_version(self, value): self.version.append(value)
    def insert_version(self, index, value): self.version[index] = value
    def export(self, outfile, level, namespace_='', name_='SupportedVersions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SupportedVersions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SupportedVersions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SupportedVersions', fromsubclass_=False):
        for version_ in self.version:
            version_.export(outfile, level, namespace_, name_='version')
    def hasContent_(self):
        if (
            self.version
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SupportedVersions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('version=[\n')
        level += 1
        for version_ in self.version:
            showIndent(outfile, level)
            outfile.write('model_.Version(\n')
            version_.exportLiteral(outfile, level, name_='Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.version.append(obj_)
# end class SupportedVersions


class ErrorHandling(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, on_error=None):
        self.on_error = on_error
    def factory(*args_, **kwargs_):
        if ErrorHandling.subclass:
            return ErrorHandling.subclass(*args_, **kwargs_)
        else:
            return ErrorHandling(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_on_error(self): return self.on_error
    def set_on_error(self, on_error): self.on_error = on_error
    def export(self, outfile, level, namespace_='', name_='ErrorHandling', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorHandling')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorHandling'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorHandling', fromsubclass_=False):
        if self.on_error is not None:
            showIndent(outfile, level)
            outfile.write('<%son_error>%s</%son_error>\n' % (namespace_, self.gds_format_string(quote_xml(self.on_error).encode(ExternalEncoding), input_name='on_error'), namespace_))
    def hasContent_(self):
        if (
            self.on_error is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ErrorHandling'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.on_error is not None:
            showIndent(outfile, level)
            outfile.write('on_error=%s,\n' % quote_python(self.on_error).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'on_error':
            on_error_ = child_.text
            on_error_ = self.gds_validate_string(on_error_, node, 'on_error')
            self.on_error = on_error_
# end class ErrorHandling


class Capabilities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, version=None, permits=None, scheduling_policies=None):
        if version is None:
            self.version = []
        else:
            self.version = version
        self.permits = permits
        self.scheduling_policies = scheduling_policies
    def factory(*args_, **kwargs_):
        if Capabilities.subclass:
            return Capabilities.subclass(*args_, **kwargs_)
        else:
            return Capabilities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def add_version(self, value): self.version.append(value)
    def insert_version(self, index, value): self.version[index] = value
    def get_permits(self): return self.permits
    def set_permits(self, permits): self.permits = permits
    def get_scheduling_policies(self): return self.scheduling_policies
    def set_scheduling_policies(self, scheduling_policies): self.scheduling_policies = scheduling_policies
    def export(self, outfile, level, namespace_='', name_='Capabilities', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Capabilities')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Capabilities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Capabilities', fromsubclass_=False):
        for version_ in self.version:
            version_.export(outfile, level, namespace_, name_='version')
        if self.permits is not None:
            self.permits.export(outfile, level, namespace_, name_='permits')
        if self.scheduling_policies is not None:
            self.scheduling_policies.export(outfile, level, namespace_, name_='scheduling_policies')
    def hasContent_(self):
        if (
            self.version or
            self.permits is not None or
            self.scheduling_policies is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Capabilities'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('version=[\n')
        level += 1
        for version_ in self.version:
            showIndent(outfile, level)
            outfile.write('model_.VersionCaps(\n')
            version_.exportLiteral(outfile, level, name_='VersionCaps')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.permits is not None:
            showIndent(outfile, level)
            outfile.write('permits=model_.Permits(\n')
            self.permits.exportLiteral(outfile, level, name_='permits')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scheduling_policies is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policies=model_.SchedulingPolicies(\n')
            self.scheduling_policies.exportLiteral(outfile, level, name_='scheduling_policies')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'version':
            obj_ = VersionCaps.factory()
            obj_.build(child_)
            self.version.append(obj_)
        elif nodeName_ == 'permits':
            obj_ = Permits.factory()
            obj_.build(child_)
            self.set_permits(obj_)
        elif nodeName_ == 'scheduling_policies':
            obj_ = SchedulingPolicies.factory()
            obj_.build(child_)
            self.set_scheduling_policies(obj_)
# end class Capabilities


class SchedulingPolicies(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, policy=None):
        if policy is None:
            self.policy = []
        else:
            self.policy = policy
    def factory(*args_, **kwargs_):
        if SchedulingPolicies.subclass:
            return SchedulingPolicies.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicies(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_policy(self): return self.policy
    def set_policy(self, policy): self.policy = policy
    def add_policy(self, value): self.policy.append(value)
    def insert_policy(self, index, value): self.policy[index] = value
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicies', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicies')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicies'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicies', fromsubclass_=False):
        for policy_ in self.policy:
            showIndent(outfile, level)
            outfile.write('<%spolicy>%s</%spolicy>\n' % (namespace_, self.gds_format_string(quote_xml(policy_).encode(ExternalEncoding), input_name='policy'), namespace_))
    def hasContent_(self):
        if (
            self.policy
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SchedulingPolicies'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('policy=[\n')
        level += 1
        for policy_ in self.policy:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(policy_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'policy':
            policy_ = child_.text
            policy_ = self.gds_validate_string(policy_, node, 'policy')
            self.policy.append(policy_)
# end class SchedulingPolicies


class Features(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, transparent_hugepages=None):
        self.transparent_hugepages = transparent_hugepages
    def factory(*args_, **kwargs_):
        if Features.subclass:
            return Features.subclass(*args_, **kwargs_)
        else:
            return Features(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_transparent_hugepages(self): return self.transparent_hugepages
    def set_transparent_hugepages(self, transparent_hugepages): self.transparent_hugepages = transparent_hugepages
    def export(self, outfile, level, namespace_='', name_='Features', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Features')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Features'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Features', fromsubclass_=False):
        if self.transparent_hugepages is not None:
            self.transparent_hugepages.export(outfile, level, namespace_, name_='transparent_hugepages')
    def hasContent_(self):
        if (
            self.transparent_hugepages is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Features'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.transparent_hugepages is not None:
            showIndent(outfile, level)
            outfile.write('transparent_hugepages=model_.transparent_hugepages(\n')
            self.transparent_hugepages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'transparent_hugepages':
            obj_ = TransparentHugePages.factory()
            obj_.build(child_)
            self.set_transparent_hugepages(obj_)
# end class Features


class FenceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, fence_type=None):
        if fence_type is None:
            self.fence_type = []
        else:
            self.fence_type = fence_type
    def factory(*args_, **kwargs_):
        if FenceTypes.subclass:
            return FenceTypes.subclass(*args_, **kwargs_)
        else:
            return FenceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fence_type(self): return self.fence_type
    def set_fence_type(self, fence_type): self.fence_type = fence_type
    def add_fence_type(self, value): self.fence_type.append(value)
    def insert_fence_type(self, index, value): self.fence_type[index] = value
    def export(self, outfile, level, namespace_='', name_='FenceTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FenceTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FenceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='FenceTypes', fromsubclass_=False):
        for fence_type_ in self.fence_type:
            showIndent(outfile, level)
            outfile.write('<%sfence_type>%s</%sfence_type>\n' % (namespace_, self.gds_format_string(quote_xml(fence_type_).encode(ExternalEncoding), input_name='fence_type'), namespace_))
    def hasContent_(self):
        if (
            self.fence_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FenceTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('fence_type=[\n')
        level += 1
        for fence_type_ in self.fence_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(fence_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fence_type':
            fence_type_ = child_.text
            fence_type_ = self.gds_validate_string(fence_type_, node, 'fence_type')
            self.fence_type.append(fence_type_)
# end class FenceTypes


class StorageTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_type=None):
        if storage_type is None:
            self.storage_type = []
        else:
            self.storage_type = storage_type
    def factory(*args_, **kwargs_):
        if StorageTypes.subclass:
            return StorageTypes.subclass(*args_, **kwargs_)
        else:
            return StorageTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_type(self): return self.storage_type
    def set_storage_type(self, storage_type): self.storage_type = storage_type
    def add_storage_type(self, value): self.storage_type.append(value)
    def insert_storage_type(self, index, value): self.storage_type[index] = value
    def export(self, outfile, level, namespace_='', name_='StorageTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageTypes', fromsubclass_=False):
        for storage_type_ in self.storage_type:
            showIndent(outfile, level)
            outfile.write('<%sstorage_type>%s</%sstorage_type>\n' % (namespace_, self.gds_format_string(quote_xml(storage_type_).encode(ExternalEncoding), input_name='storage_type'), namespace_))
    def hasContent_(self):
        if (
            self.storage_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StorageTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_type=[\n')
        level += 1
        for storage_type_ in self.storage_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_type':
            storage_type_ = child_.text
            storage_type_ = self.gds_validate_string(storage_type_, node, 'storage_type')
            self.storage_type.append(storage_type_)
# end class StorageTypes


class StorageDomainTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_domain_type=None):
        if storage_domain_type is None:
            self.storage_domain_type = []
        else:
            self.storage_domain_type = storage_domain_type
    def factory(*args_, **kwargs_):
        if StorageDomainTypes.subclass:
            return StorageDomainTypes.subclass(*args_, **kwargs_)
        else:
            return StorageDomainTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain_type(self): return self.storage_domain_type
    def set_storage_domain_type(self, storage_domain_type): self.storage_domain_type = storage_domain_type
    def add_storage_domain_type(self, value): self.storage_domain_type.append(value)
    def insert_storage_domain_type(self, index, value): self.storage_domain_type[index] = value
    def export(self, outfile, level, namespace_='', name_='StorageDomainTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomainTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomainTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomainTypes', fromsubclass_=False):
        for storage_domain_type_ in self.storage_domain_type:
            showIndent(outfile, level)
            outfile.write('<%sstorage_domain_type>%s</%sstorage_domain_type>\n' % (namespace_, self.gds_format_string(quote_xml(storage_domain_type_).encode(ExternalEncoding), input_name='storage_domain_type'), namespace_))
    def hasContent_(self):
        if (
            self.storage_domain_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StorageDomainTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_domain_type=[\n')
        level += 1
        for storage_domain_type_ in self.storage_domain_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_domain_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain_type':
            storage_domain_type_ = child_.text
            storage_domain_type_ = self.gds_validate_string(storage_domain_type_, node, 'storage_domain_type')
            self.storage_domain_type.append(storage_domain_type_)
# end class StorageDomainTypes


class VmTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_type=None):
        if vm_type is None:
            self.vm_type = []
        else:
            self.vm_type = vm_type
    def factory(*args_, **kwargs_):
        if VmTypes.subclass:
            return VmTypes.subclass(*args_, **kwargs_)
        else:
            return VmTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_type(self): return self.vm_type
    def set_vm_type(self, vm_type): self.vm_type = vm_type
    def add_vm_type(self, value): self.vm_type.append(value)
    def insert_vm_type(self, index, value): self.vm_type[index] = value
    def export(self, outfile, level, namespace_='', name_='VmTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmTypes', fromsubclass_=False):
        for vm_type_ in self.vm_type:
            showIndent(outfile, level)
            outfile.write('<%svm_type>%s</%svm_type>\n' % (namespace_, self.gds_format_string(quote_xml(vm_type_).encode(ExternalEncoding), input_name='vm_type'), namespace_))
    def hasContent_(self):
        if (
            self.vm_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_type=[\n')
        level += 1
        for vm_type_ in self.vm_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_type':
            vm_type_ = child_.text
            vm_type_ = self.gds_validate_string(vm_type_, node, 'vm_type')
            self.vm_type.append(vm_type_)
# end class VmTypes


class BootDevices(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, boot_device=None):
        if boot_device is None:
            self.boot_device = []
        else:
            self.boot_device = boot_device
    def factory(*args_, **kwargs_):
        if BootDevices.subclass:
            return BootDevices.subclass(*args_, **kwargs_)
        else:
            return BootDevices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot_device(self): return self.boot_device
    def set_boot_device(self, boot_device): self.boot_device = boot_device
    def add_boot_device(self, value): self.boot_device.append(value)
    def insert_boot_device(self, index, value): self.boot_device[index] = value
    def export(self, outfile, level, namespace_='', name_='BootDevices', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BootDevices')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BootDevices'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BootDevices', fromsubclass_=False):
        for boot_device_ in self.boot_device:
            showIndent(outfile, level)
            outfile.write('<%sboot_device>%s</%sboot_device>\n' % (namespace_, self.gds_format_string(quote_xml(boot_device_).encode(ExternalEncoding), input_name='boot_device'), namespace_))
    def hasContent_(self):
        if (
            self.boot_device
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BootDevices'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot_device=[\n')
        level += 1
        for boot_device_ in self.boot_device:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(boot_device_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot_device':
            boot_device_ = child_.text
            boot_device_ = self.gds_validate_string(boot_device_, node, 'boot_device')
            self.boot_device.append(boot_device_)
# end class BootDevices


class DisplayTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, display_type=None):
        if display_type is None:
            self.display_type = []
        else:
            self.display_type = display_type
    def factory(*args_, **kwargs_):
        if DisplayTypes.subclass:
            return DisplayTypes.subclass(*args_, **kwargs_)
        else:
            return DisplayTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_display_type(self): return self.display_type
    def set_display_type(self, display_type): self.display_type = display_type
    def add_display_type(self, value): self.display_type.append(value)
    def insert_display_type(self, index, value): self.display_type[index] = value
    def export(self, outfile, level, namespace_='', name_='DisplayTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DisplayTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DisplayTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DisplayTypes', fromsubclass_=False):
        for display_type_ in self.display_type:
            showIndent(outfile, level)
            outfile.write('<%sdisplay_type>%s</%sdisplay_type>\n' % (namespace_, self.gds_format_string(quote_xml(display_type_).encode(ExternalEncoding), input_name='display_type'), namespace_))
    def hasContent_(self):
        if (
            self.display_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DisplayTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('display_type=[\n')
        level += 1
        for display_type_ in self.display_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(display_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'display_type':
            display_type_ = child_.text
            display_type_ = self.gds_validate_string(display_type_, node, 'display_type')
            self.display_type.append(display_type_)
# end class DisplayTypes


class NicInterfaces(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nic_interface=None):
        if nic_interface is None:
            self.nic_interface = []
        else:
            self.nic_interface = nic_interface
    def factory(*args_, **kwargs_):
        if NicInterfaces.subclass:
            return NicInterfaces.subclass(*args_, **kwargs_)
        else:
            return NicInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nic_interface(self): return self.nic_interface
    def set_nic_interface(self, nic_interface): self.nic_interface = nic_interface
    def add_nic_interface(self, value): self.nic_interface.append(value)
    def insert_nic_interface(self, index, value): self.nic_interface[index] = value
    def export(self, outfile, level, namespace_='', name_='NicInterfaces', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NicInterfaces')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NicInterfaces'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NicInterfaces', fromsubclass_=False):
        for nic_interface_ in self.nic_interface:
            showIndent(outfile, level)
            outfile.write('<%snic_interface>%s</%snic_interface>\n' % (namespace_, self.gds_format_string(quote_xml(nic_interface_).encode(ExternalEncoding), input_name='nic_interface'), namespace_))
    def hasContent_(self):
        if (
            self.nic_interface
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NicInterfaces'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('nic_interface=[\n')
        level += 1
        for nic_interface_ in self.nic_interface:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(nic_interface_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nic_interface':
            nic_interface_ = child_.text
            nic_interface_ = self.gds_validate_string(nic_interface_, node, 'nic_interface')
            self.nic_interface.append(nic_interface_)
# end class NicInterfaces


class OsTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, os_type=None):
        if os_type is None:
            self.os_type = []
        else:
            self.os_type = os_type
    def factory(*args_, **kwargs_):
        if OsTypes.subclass:
            return OsTypes.subclass(*args_, **kwargs_)
        else:
            return OsTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_os_type(self): return self.os_type
    def set_os_type(self, os_type): self.os_type = os_type
    def add_os_type(self, value): self.os_type.append(value)
    def insert_os_type(self, index, value): self.os_type[index] = value
    def export(self, outfile, level, namespace_='', name_='OsTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OsTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OsTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OsTypes', fromsubclass_=False):
        for os_type_ in self.os_type:
            showIndent(outfile, level)
            outfile.write('<%sos_type>%s</%sos_type>\n' % (namespace_, self.gds_format_string(quote_xml(os_type_).encode(ExternalEncoding), input_name='os_type'), namespace_))
    def hasContent_(self):
        if (
            self.os_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='OsTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('os_type=[\n')
        level += 1
        for os_type_ in self.os_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(os_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'os_type':
            os_type_ = child_.text
            os_type_ = self.gds_validate_string(os_type_, node, 'os_type')
            self.os_type.append(os_type_)
# end class OsTypes


class DiskFormats(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_format=None):
        if disk_format is None:
            self.disk_format = []
        else:
            self.disk_format = disk_format
    def factory(*args_, **kwargs_):
        if DiskFormats.subclass:
            return DiskFormats.subclass(*args_, **kwargs_)
        else:
            return DiskFormats(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_format(self): return self.disk_format
    def set_disk_format(self, disk_format): self.disk_format = disk_format
    def add_disk_format(self, value): self.disk_format.append(value)
    def insert_disk_format(self, index, value): self.disk_format[index] = value
    def export(self, outfile, level, namespace_='', name_='DiskFormats', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskFormats')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskFormats'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskFormats', fromsubclass_=False):
        for disk_format_ in self.disk_format:
            showIndent(outfile, level)
            outfile.write('<%sdisk_format>%s</%sdisk_format>\n' % (namespace_, self.gds_format_string(quote_xml(disk_format_).encode(ExternalEncoding), input_name='disk_format'), namespace_))
    def hasContent_(self):
        if (
            self.disk_format
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DiskFormats'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_format=[\n')
        level += 1
        for disk_format_ in self.disk_format:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_format_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_format':
            disk_format_ = child_.text
            disk_format_ = self.gds_validate_string(disk_format_, node, 'disk_format')
            self.disk_format.append(disk_format_)
# end class DiskFormats


class DiskInterfaces(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_interface=None):
        if disk_interface is None:
            self.disk_interface = []
        else:
            self.disk_interface = disk_interface
    def factory(*args_, **kwargs_):
        if DiskInterfaces.subclass:
            return DiskInterfaces.subclass(*args_, **kwargs_)
        else:
            return DiskInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_interface(self): return self.disk_interface
    def set_disk_interface(self, disk_interface): self.disk_interface = disk_interface
    def add_disk_interface(self, value): self.disk_interface.append(value)
    def insert_disk_interface(self, index, value): self.disk_interface[index] = value
    def export(self, outfile, level, namespace_='', name_='DiskInterfaces', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskInterfaces')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskInterfaces'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskInterfaces', fromsubclass_=False):
        for disk_interface_ in self.disk_interface:
            showIndent(outfile, level)
            outfile.write('<%sdisk_interface>%s</%sdisk_interface>\n' % (namespace_, self.gds_format_string(quote_xml(disk_interface_).encode(ExternalEncoding), input_name='disk_interface'), namespace_))
    def hasContent_(self):
        if (
            self.disk_interface
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DiskInterfaces'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_interface=[\n')
        level += 1
        for disk_interface_ in self.disk_interface:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_interface_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_interface':
            disk_interface_ = child_.text
            disk_interface_ = self.gds_validate_string(disk_interface_, node, 'disk_interface')
            self.disk_interface.append(disk_interface_)
# end class DiskInterfaces


class VmAffinities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, affinity=None):
        if affinity is None:
            self.affinity = []
        else:
            self.affinity = affinity
    def factory(*args_, **kwargs_):
        if VmAffinities.subclass:
            return VmAffinities.subclass(*args_, **kwargs_)
        else:
            return VmAffinities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_affinity(self): return self.affinity
    def set_affinity(self, affinity): self.affinity = affinity
    def add_affinity(self, value): self.affinity.append(value)
    def insert_affinity(self, index, value): self.affinity[index] = value
    def export(self, outfile, level, namespace_='', name_='VmAffinities', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmAffinities')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmAffinities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmAffinities', fromsubclass_=False):
        for affinity_ in self.affinity:
            showIndent(outfile, level)
            outfile.write('<%saffinity>%s</%saffinity>\n' % (namespace_, self.gds_format_string(quote_xml(affinity_).encode(ExternalEncoding), input_name='affinity'), namespace_))
    def hasContent_(self):
        if (
            self.affinity
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmAffinities'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('affinity=[\n')
        level += 1
        for affinity_ in self.affinity:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(affinity_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'affinity':
            affinity_ = child_.text
            affinity_ = self.gds_validate_string(affinity_, node, 'affinity')
            self.affinity.append(affinity_)
# end class VmAffinities


class BootProtocols(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, boot_protocol=None):
        if boot_protocol is None:
            self.boot_protocol = []
        else:
            self.boot_protocol = boot_protocol
    def factory(*args_, **kwargs_):
        if BootProtocols.subclass:
            return BootProtocols.subclass(*args_, **kwargs_)
        else:
            return BootProtocols(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot_protocol(self): return self.boot_protocol
    def set_boot_protocol(self, boot_protocol): self.boot_protocol = boot_protocol
    def add_boot_protocol(self, value): self.boot_protocol.append(value)
    def insert_boot_protocol(self, index, value): self.boot_protocol[index] = value
    def export(self, outfile, level, namespace_='', name_='BootProtocols', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BootProtocols')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BootProtocols'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BootProtocols', fromsubclass_=False):
        for boot_protocol_ in self.boot_protocol:
            showIndent(outfile, level)
            outfile.write('<%sboot_protocol>%s</%sboot_protocol>\n' % (namespace_, self.gds_format_string(quote_xml(boot_protocol_).encode(ExternalEncoding), input_name='boot_protocol'), namespace_))
    def hasContent_(self):
        if (
            self.boot_protocol
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BootProtocols'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot_protocol=[\n')
        level += 1
        for boot_protocol_ in self.boot_protocol:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(boot_protocol_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot_protocol':
            boot_protocol_ = child_.text
            boot_protocol_ = self.gds_validate_string(boot_protocol_, node, 'boot_protocol')
            self.boot_protocol.append(boot_protocol_)
# end class BootProtocols


class ErrorHandlingOptions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, on_error=None):
        if on_error is None:
            self.on_error = []
        else:
            self.on_error = on_error
    def factory(*args_, **kwargs_):
        if ErrorHandlingOptions.subclass:
            return ErrorHandlingOptions.subclass(*args_, **kwargs_)
        else:
            return ErrorHandlingOptions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_on_error(self): return self.on_error
    def set_on_error(self, on_error): self.on_error = on_error
    def add_on_error(self, value): self.on_error.append(value)
    def insert_on_error(self, index, value): self.on_error[index] = value
    def export(self, outfile, level, namespace_='', name_='ErrorHandlingOptions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorHandlingOptions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorHandlingOptions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorHandlingOptions', fromsubclass_=False):
        for on_error_ in self.on_error:
            showIndent(outfile, level)
            outfile.write('<%son_error>%s</%son_error>\n' % (namespace_, self.gds_format_string(quote_xml(on_error_).encode(ExternalEncoding), input_name='on_error'), namespace_))
    def hasContent_(self):
        if (
            self.on_error
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ErrorHandlingOptions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('on_error=[\n')
        level += 1
        for on_error_ in self.on_error:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(on_error_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'on_error':
            on_error_ = child_.text
            on_error_ = self.gds_validate_string(on_error_, node, 'on_error')
            self.on_error.append(on_error_)
# end class ErrorHandlingOptions


class StorageFormats(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, format=None):
        if format is None:
            self.format = []
        else:
            self.format = format
    def factory(*args_, **kwargs_):
        if StorageFormats.subclass:
            return StorageFormats.subclass(*args_, **kwargs_)
        else:
            return StorageFormats(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def add_format(self, value): self.format.append(value)
    def insert_format(self, index, value): self.format[index] = value
    def export(self, outfile, level, namespace_='', name_='StorageFormats', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageFormats')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageFormats'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageFormats', fromsubclass_=False):
        for format_ in self.format:
            showIndent(outfile, level)
            outfile.write('<%sformat>%s</%sformat>\n' % (namespace_, self.gds_format_string(quote_xml(format_).encode(ExternalEncoding), input_name='format'), namespace_))
    def hasContent_(self):
        if (
            self.format
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StorageFormats'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('format=[\n')
        level += 1
        for format_ in self.format:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(format_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'format':
            format_ = child_.text
            format_ = self.gds_validate_string(format_, node, 'format')
            self.format.append(format_)
# end class StorageFormats


class ActionableResource(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, actions=None, extensiontype_=None):
        self.actions = actions
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ActionableResource.subclass:
            return ActionableResource.subclass(*args_, **kwargs_)
        else:
            return ActionableResource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_actions(self): return self.actions
    def set_actions(self, actions): self.actions = actions
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='ActionableResource', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionableResource')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ActionableResource'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ActionableResource', fromsubclass_=False):
        if self.actions is not None:
            self.actions.export(outfile, level, namespace_, name_='actions')
    def hasContent_(self):
        if (
            self.actions is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionableResource'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.actions is not None:
            showIndent(outfile, level)
            outfile.write('actions=model_.Actions(\n')
            self.actions.exportLiteral(outfile, level, name_='actions')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'actions':
            obj_ = Actions.factory()
            obj_.build(child_)
            self.set_actions(obj_)
# end class ActionableResource


class BaseResource(ActionableResource):
    subclass = None
    superclass = ActionableResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, extensiontype_=None):
        super(BaseResource, self).__init__(actions, extensiontype_, )
        self.href = _cast(None, href)
        self.id = _cast(None, id)
        self.name = name
        self.description = description
        self.creation_status = creation_status
        if link is None:
            self.link = []
        else:
            self.link = link
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseResource.subclass:
            return BaseResource.subclass(*args_, **kwargs_)
        else:
            return BaseResource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_creation_status(self): return self.creation_status
    def set_creation_status(self, creation_status): self.creation_status = creation_status
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='BaseResource', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResource')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseResource'):
        super(BaseResource, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResource')
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseResource', fromsubclass_=False):
        super(BaseResource, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        if self.creation_status is not None:
            self.creation_status.export(outfile, level, namespace_, name_='creation_status')
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link')
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            self.creation_status is not None or
            self.link or
            super(BaseResource, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BaseResource'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            showIndent(outfile, level)
            outfile.write('href = "%s",\n' % (self.href,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(BaseResource, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseResource, self).exportLiteralChildren(outfile, level, name_)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.creation_status is not None:
            showIndent(outfile, level)
            outfile.write('creation_status=model_.Status(\n')
            self.creation_status.exportLiteral(outfile, level, name_='creation_status')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.append('href')
            self.href = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(BaseResource, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'creation_status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_creation_status(obj_)
        elif nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, Link)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
        super(BaseResource, self).buildChildren(child_, node, nodeName_, True)
# end class BaseResource


class BaseResources(ActionableResource):
    subclass = None
    superclass = ActionableResource
    def __init__(self, actions=None, total=None, active=None, extensiontype_=None):
        super(BaseResources, self).__init__(actions, extensiontype_, )
        self.total = total
        self.active = active
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseResources.subclass:
            return BaseResources.subclass(*args_, **kwargs_)
        else:
            return BaseResources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='BaseResources', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResources')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseResources'):
        super(BaseResources, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResources')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseResources', fromsubclass_=False):
        super(BaseResources, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('<%stotal>%s</%stotal>\n' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_))
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('<%sactive>%s</%sactive>\n' % (namespace_, self.gds_format_integer(self.active, input_name='active'), namespace_))
    def hasContent_(self):
        if (
            self.total is not None or
            self.active is not None or
            super(BaseResources, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BaseResources'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseResources, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseResources, self).exportLiteralChildren(outfile, level, name_)
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%d,\n' % self.active)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(BaseResources, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
        elif nodeName_ == 'active':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'active')
            self.active = ival_
        super(BaseResources, self).buildChildren(child_, node, nodeName_, True)
# end class BaseResources


class Option(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, name=None, value=None):
        self.type_ = _cast(None, type_)
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if Option.subclass:
            return Option.subclass(*args_, **kwargs_)
        else:
            return Option(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def export(self, outfile, level, namespace_='', name_='Option', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Option')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Option'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.append('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Option', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Option'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.append('value')
            showIndent(outfile, level)
            outfile.write('value = "%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.append('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Option


class Options(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, option=None):
        if option is None:
            self.option = []
        else:
            self.option = option
    def factory(*args_, **kwargs_):
        if Options.subclass:
            return Options.subclass(*args_, **kwargs_)
        else:
            return Options(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_option(self): return self.option
    def set_option(self, option): self.option = option
    def add_option(self, value): self.option.append(value)
    def insert_option(self, index, value): self.option[index] = value
    def export(self, outfile, level, namespace_='', name_='Options', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Options')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Options'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Options', fromsubclass_=False):
        for option_ in self.option:
            option_.export(outfile, level, namespace_, name_='option')
    def hasContent_(self):
        if (
            self.option
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Options'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('option=[\n')
        level += 1
        for option_ in self.option:
            showIndent(outfile, level)
            outfile.write('model_.Option(\n')
            option_.exportLiteral(outfile, level, name_='Option')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'option':
            obj_ = Option.factory()
            obj_.build(child_)
            self.option.append(obj_)
# end class Options


class DataCenter(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, storage_type=None, storage_format=None, version=None, supported_versions=None, status=None):
        super(DataCenter, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.storage_type = storage_type
        self.storage_format = storage_format
        self.version = version
        self.supported_versions = supported_versions
        self.status = status
    def factory(*args_, **kwargs_):
        if DataCenter.subclass:
            return DataCenter.subclass(*args_, **kwargs_)
        else:
            return DataCenter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_type(self): return self.storage_type
    def set_storage_type(self, storage_type): self.storage_type = storage_type
    def get_storage_format(self): return self.storage_format
    def set_storage_format(self, storage_format): self.storage_format = storage_format
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_supported_versions(self): return self.supported_versions
    def set_supported_versions(self, supported_versions): self.supported_versions = supported_versions
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def export(self, outfile, level, namespace_='', name_='DataCenter', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenter')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenter'):
        super(DataCenter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenter')
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenter', fromsubclass_=False):
        super(DataCenter, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.storage_type is not None:
            showIndent(outfile, level)
            outfile.write('<%sstorage_type>%s</%sstorage_type>\n' % (namespace_, self.gds_format_string(quote_xml(self.storage_type).encode(ExternalEncoding), input_name='storage_type'), namespace_))
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('<%sstorage_format>%s</%sstorage_format>\n' % (namespace_, self.gds_format_string(quote_xml(self.storage_format).encode(ExternalEncoding), input_name='storage_format'), namespace_))
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version')
        if self.supported_versions is not None:
            self.supported_versions.export(outfile, level, namespace_, name_='supported_versions')
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
    def hasContent_(self):
        if (
            self.storage_type is not None or
            self.storage_format is not None or
            self.version is not None or
            self.supported_versions is not None or
            self.status is not None or
            super(DataCenter, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataCenter'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DataCenter, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DataCenter, self).exportLiteralChildren(outfile, level, name_)
        if self.storage_type is not None:
            showIndent(outfile, level)
            outfile.write('storage_type=%s,\n' % quote_python(self.storage_type).encode(ExternalEncoding))
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('storage_format=%s,\n' % quote_python(self.storage_format).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.supported_versions is not None:
            showIndent(outfile, level)
            outfile.write('supported_versions=model_.SupportedVersions(\n')
            self.supported_versions.exportLiteral(outfile, level, name_='supported_versions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DataCenter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_type':
            storage_type_ = child_.text
            storage_type_ = self.gds_validate_string(storage_type_, node, 'storage_type')
            self.storage_type = storage_type_
        elif nodeName_ == 'storage_format':
            storage_format_ = child_.text
            storage_format_ = self.gds_validate_string(storage_format_, node, 'storage_format')
            self.storage_format = storage_format_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        elif nodeName_ == 'supported_versions':
            obj_ = SupportedVersions.factory()
            obj_.build(child_)
            self.set_supported_versions(obj_)
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        super(DataCenter, self).buildChildren(child_, node, nodeName_, True)
# end class DataCenter


class DataCenters(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, data_center=None):
        super(DataCenters, self).__init__(actions, total, active, )
        if data_center is None:
            self.data_center = []
        else:
            self.data_center = data_center
    def factory(*args_, **kwargs_):
        if DataCenters.subclass:
            return DataCenters.subclass(*args_, **kwargs_)
        else:
            return DataCenters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def add_data_center(self, value): self.data_center.append(value)
    def insert_data_center(self, index, value): self.data_center[index] = value
    def export(self, outfile, level, namespace_='', name_='DataCenters', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenters')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenters'):
        super(DataCenters, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenters')
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenters', fromsubclass_=False):
        super(DataCenters, self).exportChildren(outfile, level, namespace_, name_, True)
        for data_center_ in self.data_center:
            data_center_.export(outfile, level, namespace_, name_='data_center')
    def hasContent_(self):
        if (
            self.data_center or
            super(DataCenters, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataCenters'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DataCenters, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DataCenters, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('data_center=[\n')
        level += 1
        for data_center_ in self.data_center:
            showIndent(outfile, level)
            outfile.write('model_.data_center(\n')
            data_center_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DataCenters, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center.append(obj_)
        super(DataCenters, self).buildChildren(child_, node, nodeName_, True)
# end class DataCenters


class DataCenterStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, data_center_state=None):
        if data_center_state is None:
            self.data_center_state = []
        else:
            self.data_center_state = data_center_state
    def factory(*args_, **kwargs_):
        if DataCenterStates.subclass:
            return DataCenterStates.subclass(*args_, **kwargs_)
        else:
            return DataCenterStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center_state(self): return self.data_center_state
    def set_data_center_state(self, data_center_state): self.data_center_state = data_center_state
    def add_data_center_state(self, value): self.data_center_state.append(value)
    def insert_data_center_state(self, index, value): self.data_center_state[index] = value
    def export(self, outfile, level, namespace_='', name_='DataCenterStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenterStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenterStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenterStates', fromsubclass_=False):
        for data_center_state_ in self.data_center_state:
            showIndent(outfile, level)
            outfile.write('<%sdata_center_state>%s</%sdata_center_state>\n' % (namespace_, self.gds_format_string(quote_xml(data_center_state_).encode(ExternalEncoding), input_name='data_center_state'), namespace_))
    def hasContent_(self):
        if (
            self.data_center_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataCenterStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('data_center_state=[\n')
        level += 1
        for data_center_state_ in self.data_center_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(data_center_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center_state':
            data_center_state_ = child_.text
            data_center_state_ = self.gds_validate_string(data_center_state_, node, 'data_center_state')
            self.data_center_state.append(data_center_state_)
# end class DataCenterStates


class MemoryOverCommit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, percent=None):
        self.percent = _cast(int, percent)
        pass
    def factory(*args_, **kwargs_):
        if MemoryOverCommit.subclass:
            return MemoryOverCommit.subclass(*args_, **kwargs_)
        else:
            return MemoryOverCommit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_percent(self): return self.percent
    def set_percent(self, percent): self.percent = percent
    def export(self, outfile, level, namespace_='', name_='MemoryOverCommit', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemoryOverCommit')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MemoryOverCommit'):
        if self.percent is not None and 'percent' not in already_processed:
            already_processed.append('percent')
            outfile.write(' percent="%s"' % self.gds_format_integer(self.percent, input_name='percent'))
    def exportChildren(self, outfile, level, namespace_='', name_='MemoryOverCommit', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MemoryOverCommit'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.percent is not None and 'percent' not in already_processed:
            already_processed.append('percent')
            showIndent(outfile, level)
            outfile.write('percent = %d,\n' % (self.percent,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('percent', node)
        if value is not None and 'percent' not in already_processed:
            already_processed.append('percent')
            try:
                self.percent = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MemoryOverCommit


class MemoryPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, guaranteed=None, ballooning=None, overcommit=None, transparent_hugepages=None):
        self.guaranteed = guaranteed
        self.ballooning = ballooning
        self.overcommit = overcommit
        self.transparent_hugepages = transparent_hugepages
    def factory(*args_, **kwargs_):
        if MemoryPolicy.subclass:
            return MemoryPolicy.subclass(*args_, **kwargs_)
        else:
            return MemoryPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_guaranteed(self): return self.guaranteed
    def set_guaranteed(self, guaranteed): self.guaranteed = guaranteed
    def get_ballooning(self): return self.ballooning
    def set_ballooning(self, ballooning): self.ballooning = ballooning
    def get_overcommit(self): return self.overcommit
    def set_overcommit(self, overcommit): self.overcommit = overcommit
    def get_transparent_hugepages(self): return self.transparent_hugepages
    def set_transparent_hugepages(self, transparent_hugepages): self.transparent_hugepages = transparent_hugepages
    def export(self, outfile, level, namespace_='', name_='MemoryPolicy', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemoryPolicy')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MemoryPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MemoryPolicy', fromsubclass_=False):
        if self.guaranteed is not None:
            showIndent(outfile, level)
            outfile.write('<%sguaranteed>%s</%sguaranteed>\n' % (namespace_, self.gds_format_integer(self.guaranteed, input_name='guaranteed'), namespace_))
        if self.ballooning is not None:
            showIndent(outfile, level)
            outfile.write('<%sballooning>%s</%sballooning>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.ballooning)), input_name='ballooning'), namespace_))
        if self.overcommit is not None:
            self.overcommit.export(outfile, level, namespace_, name_='overcommit')
        if self.transparent_hugepages is not None:
            self.transparent_hugepages.export(outfile, level, namespace_, name_='transparent_hugepages')
    def hasContent_(self):
        if (
            self.guaranteed is not None or
            self.ballooning is not None or
            self.overcommit is not None or
            self.transparent_hugepages is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MemoryPolicy'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.guaranteed is not None:
            showIndent(outfile, level)
            outfile.write('guaranteed=%d,\n' % self.guaranteed)
        if self.ballooning is not None:
            showIndent(outfile, level)
            outfile.write('ballooning=%s,\n' % self.ballooning)
        if self.overcommit is not None:
            showIndent(outfile, level)
            outfile.write('overcommit=model_.MemoryOverCommit(\n')
            self.overcommit.exportLiteral(outfile, level, name_='overcommit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.transparent_hugepages is not None:
            showIndent(outfile, level)
            outfile.write('transparent_hugepages=model_.transparent_hugepages(\n')
            self.transparent_hugepages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'guaranteed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'guaranteed')
            self.guaranteed = ival_
        elif nodeName_ == 'ballooning':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ballooning')
            self.ballooning = ival_
        elif nodeName_ == 'overcommit':
            obj_ = MemoryOverCommit.factory()
            obj_.build(child_)
            self.set_overcommit(obj_)
        elif nodeName_ == 'transparent_hugepages':
            obj_ = TransparentHugePages.factory()
            obj_.build(child_)
            self.set_transparent_hugepages(obj_)
# end class MemoryPolicy


class SchedulingPolicyThresholds(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, high=None, duration=None, low=None):
        self.high = _cast(int, high)
        self.duration = _cast(int, duration)
        self.low = _cast(int, low)
        pass
    def factory(*args_, **kwargs_):
        if SchedulingPolicyThresholds.subclass:
            return SchedulingPolicyThresholds.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicyThresholds(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_high(self): return self.high
    def set_high(self, high): self.high = high
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_low(self): return self.low
    def set_low(self, low): self.low = low
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicyThresholds', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyThresholds')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicyThresholds'):
        if self.high is not None and 'high' not in already_processed:
            already_processed.append('high')
            outfile.write(' high="%s"' % self.gds_format_integer(self.high, input_name='high'))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.append('duration')
            outfile.write(' duration="%s"' % self.gds_format_integer(self.duration, input_name='duration'))
        if self.low is not None and 'low' not in already_processed:
            already_processed.append('low')
            outfile.write(' low="%s"' % self.gds_format_integer(self.low, input_name='low'))
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicyThresholds', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SchedulingPolicyThresholds'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.high is not None and 'high' not in already_processed:
            already_processed.append('high')
            showIndent(outfile, level)
            outfile.write('high = %d,\n' % (self.high,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.append('duration')
            showIndent(outfile, level)
            outfile.write('duration = %d,\n' % (self.duration,))
        if self.low is not None and 'low' not in already_processed:
            already_processed.append('low')
            showIndent(outfile, level)
            outfile.write('low = %d,\n' % (self.low,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('high', node)
        if value is not None and 'high' not in already_processed:
            already_processed.append('high')
            try:
                self.high = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.append('duration')
            try:
                self.duration = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('low', node)
        if value is not None and 'low' not in already_processed:
            already_processed.append('low')
            try:
                self.low = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SchedulingPolicyThresholds


class SchedulingPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, policy=None, thresholds=None):
        self.policy = policy
        self.thresholds = thresholds
    def factory(*args_, **kwargs_):
        if SchedulingPolicy.subclass:
            return SchedulingPolicy.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_policy(self): return self.policy
    def set_policy(self, policy): self.policy = policy
    def get_thresholds(self): return self.thresholds
    def set_thresholds(self, thresholds): self.thresholds = thresholds
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicy', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicy')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicy', fromsubclass_=False):
        if self.policy is not None:
            showIndent(outfile, level)
            outfile.write('<%spolicy>%s</%spolicy>\n' % (namespace_, self.gds_format_string(quote_xml(self.policy).encode(ExternalEncoding), input_name='policy'), namespace_))
        if self.thresholds is not None:
            self.thresholds.export(outfile, level, namespace_, name_='thresholds')
    def hasContent_(self):
        if (
            self.policy is not None or
            self.thresholds is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SchedulingPolicy'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.policy is not None:
            showIndent(outfile, level)
            outfile.write('policy=%s,\n' % quote_python(self.policy).encode(ExternalEncoding))
        if self.thresholds is not None:
            showIndent(outfile, level)
            outfile.write('thresholds=model_.SchedulingPolicyThresholds(\n')
            self.thresholds.exportLiteral(outfile, level, name_='thresholds')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'policy':
            policy_ = child_.text
            policy_ = self.gds_validate_string(policy_, node, 'policy')
            self.policy = policy_
        elif nodeName_ == 'thresholds':
            obj_ = SchedulingPolicyThresholds.factory()
            obj_.build(child_)
            self.set_thresholds(obj_)
# end class SchedulingPolicy


class Cluster(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, cpu=None, data_center=None, memory_policy=None, scheduling_policy=None, version=None, supported_versions=None, error_handling=None, virt_service=None, gluster_service=None):
        super(Cluster, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.cpu = cpu
        self.data_center = data_center
        self.memory_policy = memory_policy
        self.scheduling_policy = scheduling_policy
        self.version = version
        self.supported_versions = supported_versions
        self.error_handling = error_handling
        self.virt_service = virt_service
        self.gluster_service = gluster_service
    def factory(*args_, **kwargs_):
        if Cluster.subclass:
            return Cluster.subclass(*args_, **kwargs_)
        else:
            return Cluster(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_memory_policy(self): return self.memory_policy
    def set_memory_policy(self, memory_policy): self.memory_policy = memory_policy
    def get_scheduling_policy(self): return self.scheduling_policy
    def set_scheduling_policy(self, scheduling_policy): self.scheduling_policy = scheduling_policy
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_supported_versions(self): return self.supported_versions
    def set_supported_versions(self, supported_versions): self.supported_versions = supported_versions
    def get_error_handling(self): return self.error_handling
    def set_error_handling(self, error_handling): self.error_handling = error_handling
    def get_virt_service(self): return self.virt_service
    def set_virt_service(self, virt_service): self.virt_service = virt_service
    def get_gluster_service(self): return self.gluster_service
    def set_gluster_service(self, gluster_service): self.gluster_service = gluster_service
    def export(self, outfile, level, namespace_='', name_='Cluster', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Cluster')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Cluster'):
        super(Cluster, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Cluster')
    def exportChildren(self, outfile, level, namespace_='', name_='Cluster', fromsubclass_=False):
        super(Cluster, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu')
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center')
        if self.memory_policy is not None:
            self.memory_policy.export(outfile, level, namespace_, name_='memory_policy')
        if self.scheduling_policy is not None:
            self.scheduling_policy.export(outfile, level, namespace_, name_='scheduling_policy')
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version')
        if self.supported_versions is not None:
            self.supported_versions.export(outfile, level, namespace_, name_='supported_versions')
        if self.error_handling is not None:
            self.error_handling.export(outfile, level, namespace_, name_='error_handling')
        if self.virt_service is not None:
            showIndent(outfile, level)
            outfile.write('<%svirt_service>%s</%svirt_service>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.virt_service)), input_name='virt_service'), namespace_))
        if self.gluster_service is not None:
            showIndent(outfile, level)
            outfile.write('<%sgluster_service>%s</%sgluster_service>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.gluster_service)), input_name='gluster_service'), namespace_))
    def hasContent_(self):
        if (
            self.cpu is not None or
            self.data_center is not None or
            self.memory_policy is not None or
            self.scheduling_policy is not None or
            self.version is not None or
            self.supported_versions is not None or
            self.error_handling is not None or
            self.virt_service is not None or
            self.gluster_service is not None or
            super(Cluster, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Cluster'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Cluster, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Cluster, self).exportLiteralChildren(outfile, level, name_)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.cpu(\n')
            self.cpu.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory_policy is not None:
            showIndent(outfile, level)
            outfile.write('memory_policy=model_.MemoryPolicy(\n')
            self.memory_policy.exportLiteral(outfile, level, name_='memory_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scheduling_policy is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy=model_.SchedulingPolicy(\n')
            self.scheduling_policy.exportLiteral(outfile, level, name_='scheduling_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.supported_versions is not None:
            showIndent(outfile, level)
            outfile.write('supported_versions=model_.SupportedVersions(\n')
            self.supported_versions.exportLiteral(outfile, level, name_='supported_versions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.error_handling is not None:
            showIndent(outfile, level)
            outfile.write('error_handling=model_.ErrorHandling(\n')
            self.error_handling.exportLiteral(outfile, level, name_='error_handling')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.virt_service is not None:
            showIndent(outfile, level)
            outfile.write('virt_service=%s,\n' % self.virt_service)
        if self.gluster_service is not None:
            showIndent(outfile, level)
            outfile.write('gluster_service=%s,\n' % self.gluster_service)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Cluster, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'memory_policy':
            obj_ = MemoryPolicy.factory()
            obj_.build(child_)
            self.set_memory_policy(obj_)
        elif nodeName_ == 'scheduling_policy':
            obj_ = SchedulingPolicy.factory()
            obj_.build(child_)
            self.set_scheduling_policy(obj_)
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        elif nodeName_ == 'supported_versions':
            obj_ = SupportedVersions.factory()
            obj_.build(child_)
            self.set_supported_versions(obj_)
        elif nodeName_ == 'error_handling':
            obj_ = ErrorHandling.factory()
            obj_.build(child_)
            self.set_error_handling(obj_)
        elif nodeName_ == 'virt_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'virt_service')
            self.virt_service = ival_
        elif nodeName_ == 'gluster_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'gluster_service')
            self.gluster_service = ival_
        super(Cluster, self).buildChildren(child_, node, nodeName_, True)
# end class Cluster


class Clusters(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, cluster=None):
        super(Clusters, self).__init__(actions, total, active, )
        if cluster is None:
            self.cluster = []
        else:
            self.cluster = cluster
    def factory(*args_, **kwargs_):
        if Clusters.subclass:
            return Clusters.subclass(*args_, **kwargs_)
        else:
            return Clusters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def add_cluster(self, value): self.cluster.append(value)
    def insert_cluster(self, index, value): self.cluster[index] = value
    def export(self, outfile, level, namespace_='', name_='Clusters', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Clusters')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Clusters'):
        super(Clusters, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Clusters')
    def exportChildren(self, outfile, level, namespace_='', name_='Clusters', fromsubclass_=False):
        super(Clusters, self).exportChildren(outfile, level, namespace_, name_, True)
        for cluster_ in self.cluster:
            cluster_.export(outfile, level, namespace_, name_='cluster')
    def hasContent_(self):
        if (
            self.cluster or
            super(Clusters, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Clusters'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Clusters, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Clusters, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('cluster=[\n')
        level += 1
        for cluster_ in self.cluster:
            showIndent(outfile, level)
            outfile.write('model_.cluster(\n')
            cluster_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Clusters, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster.append(obj_)
        super(Clusters, self).buildChildren(child_, node, nodeName_, True)
# end class Clusters


class PowerManagement(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, enabled=None, address=None, username=None, password=None, options=None, status=None):
        self.type_ = _cast(None, type_)
        self.enabled = enabled
        self.address = address
        self.username = username
        self.password = password
        self.options = options
        self.status = status
    def factory(*args_, **kwargs_):
        if PowerManagement.subclass:
            return PowerManagement.subclass(*args_, **kwargs_)
        else:
            return PowerManagement(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='', name_='PowerManagement', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagement')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagement'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagement', fromsubclass_=False):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('<%senabled>%s</%senabled>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.enabled)), input_name='enabled'), namespace_))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('<%saddress>%s</%saddress>\n' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('<%susername>%s</%susername>\n' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('<%spassword>%s</%spassword>\n' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_))
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options')
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.address is not None or
            self.username is not None or
            self.password is not None or
            self.options is not None or
            self.status is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PowerManagement'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.Options(\n')
            self.options.exportLiteral(outfile, level, name_='options')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.set_options(obj_)
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
# end class PowerManagement


class PowerManagementStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, power_management_state=None):
        if power_management_state is None:
            self.power_management_state = []
        else:
            self.power_management_state = power_management_state
    def factory(*args_, **kwargs_):
        if PowerManagementStates.subclass:
            return PowerManagementStates.subclass(*args_, **kwargs_)
        else:
            return PowerManagementStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_power_management_state(self): return self.power_management_state
    def set_power_management_state(self, power_management_state): self.power_management_state = power_management_state
    def add_power_management_state(self, value): self.power_management_state.append(value)
    def insert_power_management_state(self, index, value): self.power_management_state[index] = value
    def export(self, outfile, level, namespace_='', name_='PowerManagementStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagementStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagementStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagementStates', fromsubclass_=False):
        for power_management_state_ in self.power_management_state:
            showIndent(outfile, level)
            outfile.write('<%spower_management_state>%s</%spower_management_state>\n' % (namespace_, self.gds_format_string(quote_xml(power_management_state_).encode(ExternalEncoding), input_name='power_management_state'), namespace_))
    def hasContent_(self):
        if (
            self.power_management_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PowerManagementStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('power_management_state=[\n')
        level += 1
        for power_management_state_ in self.power_management_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(power_management_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'power_management_state':
            power_management_state_ = child_.text
            power_management_state_ = self.gds_validate_string(power_management_state_, node, 'power_management_state')
            self.power_management_state.append(power_management_state_)
# end class PowerManagementStates


class PowerManagers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, power_management=None):
        if power_management is None:
            self.power_management = []
        else:
            self.power_management = power_management
    def factory(*args_, **kwargs_):
        if PowerManagers.subclass:
            return PowerManagers.subclass(*args_, **kwargs_)
        else:
            return PowerManagers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_power_management(self): return self.power_management
    def set_power_management(self, power_management): self.power_management = power_management
    def add_power_management(self, value): self.power_management.append(value)
    def insert_power_management(self, index, value): self.power_management[index] = value
    def export(self, outfile, level, namespace_='', name_='PowerManagers', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagers')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagers'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagers', fromsubclass_=False):
        for power_management_ in self.power_management:
            power_management_.export(outfile, level, namespace_, name_='power_management')
    def hasContent_(self):
        if (
            self.power_management
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PowerManagers'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('power_management=[\n')
        level += 1
        for power_management_ in self.power_management:
            showIndent(outfile, level)
            outfile.write('model_.power_management(\n')
            power_management_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'power_management':
            obj_ = PowerManagement.factory()
            obj_.build(child_)
            self.power_management.append(obj_)
# end class PowerManagers


class KSM(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = enabled
    def factory(*args_, **kwargs_):
        if KSM.subclass:
            return KSM.subclass(*args_, **kwargs_)
        else:
            return KSM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def export(self, outfile, level, namespace_='', name_='KSM', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KSM')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='KSM'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='KSM', fromsubclass_=False):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('<%senabled>%s</%senabled>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.enabled)), input_name='enabled'), namespace_))
    def hasContent_(self):
        if (
            self.enabled is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='KSM'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
# end class KSM


class TransparentHugePages(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = enabled
    def factory(*args_, **kwargs_):
        if TransparentHugePages.subclass:
            return TransparentHugePages.subclass(*args_, **kwargs_)
        else:
            return TransparentHugePages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def export(self, outfile, level, namespace_='', name_='TransparentHugePages', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TransparentHugePages')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TransparentHugePages'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TransparentHugePages', fromsubclass_=False):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('<%senabled>%s</%senabled>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.enabled)), input_name='enabled'), namespace_))
    def hasContent_(self):
        if (
            self.enabled is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TransparentHugePages'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
# end class TransparentHugePages


class Certificate(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, organization=None, subject=None):
        self.organization = organization
        self.subject = subject
    def factory(*args_, **kwargs_):
        if Certificate.subclass:
            return Certificate.subclass(*args_, **kwargs_)
        else:
            return Certificate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organization(self): return self.organization
    def set_organization(self, organization): self.organization = organization
    def get_subject(self): return self.subject
    def set_subject(self, subject): self.subject = subject
    def export(self, outfile, level, namespace_='', name_='Certificate', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Certificate')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Certificate'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Certificate', fromsubclass_=False):
        if self.organization is not None:
            showIndent(outfile, level)
            outfile.write('<%sorganization>%s</%sorganization>\n' % (namespace_, self.gds_format_string(quote_xml(self.organization).encode(ExternalEncoding), input_name='organization'), namespace_))
        if self.subject is not None:
            showIndent(outfile, level)
            outfile.write('<%ssubject>%s</%ssubject>\n' % (namespace_, self.gds_format_string(quote_xml(self.subject).encode(ExternalEncoding), input_name='subject'), namespace_))
    def hasContent_(self):
        if (
            self.organization is not None or
            self.subject is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Certificate'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.organization is not None:
            showIndent(outfile, level)
            outfile.write('organization=%s,\n' % quote_python(self.organization).encode(ExternalEncoding))
        if self.subject is not None:
            showIndent(outfile, level)
            outfile.write('subject=%s,\n' % quote_python(self.subject).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organization':
            organization_ = child_.text
            organization_ = self.gds_validate_string(organization_, node, 'organization')
            self.organization = organization_
        elif nodeName_ == 'subject':
            subject_ = child_.text
            subject_ = self.gds_validate_string(subject_, node, 'subject')
            self.subject = subject_
# end class Certificate


class Host(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, address=None, certificate=None, status=None, cluster=None, port=None, type_=None, storage_manager=None, version=None, power_management=None, ksm=None, transparent_hugepages=None, iscsi=None, root_password=None, statistics=None, cpu=None, memory=None, summary=None, override_iptables=None, reboot_after_installation=None):
        super(Host, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.address = address
        self.certificate = certificate
        self.status = status
        self.cluster = cluster
        self.port = port
        self.type_ = type_
        self.storage_manager = storage_manager
        self.version = version
        self.power_management = power_management
        self.ksm = ksm
        self.transparent_hugepages = transparent_hugepages
        self.iscsi = iscsi
        self.root_password = root_password
        self.statistics = statistics
        self.cpu = cpu
        self.memory = memory
        self.summary = summary
        self.override_iptables = override_iptables
        self.reboot_after_installation = reboot_after_installation
    def factory(*args_, **kwargs_):
        if Host.subclass:
            return Host.subclass(*args_, **kwargs_)
        else:
            return Host(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_certificate(self): return self.certificate
    def set_certificate(self, certificate): self.certificate = certificate
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_storage_manager(self): return self.storage_manager
    def set_storage_manager(self, storage_manager): self.storage_manager = storage_manager
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_power_management(self): return self.power_management
    def set_power_management(self, power_management): self.power_management = power_management
    def get_ksm(self): return self.ksm
    def set_ksm(self, ksm): self.ksm = ksm
    def get_transparent_hugepages(self): return self.transparent_hugepages
    def set_transparent_hugepages(self, transparent_hugepages): self.transparent_hugepages = transparent_hugepages
    def get_iscsi(self): return self.iscsi
    def set_iscsi(self, iscsi): self.iscsi = iscsi
    def get_root_password(self): return self.root_password
    def set_root_password(self, root_password): self.root_password = root_password
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_override_iptables(self): return self.override_iptables
    def set_override_iptables(self, override_iptables): self.override_iptables = override_iptables
    def get_reboot_after_installation(self): return self.reboot_after_installation
    def set_reboot_after_installation(self, reboot_after_installation): self.reboot_after_installation = reboot_after_installation
    def export(self, outfile, level, namespace_='', name_='Host', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Host')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Host'):
        super(Host, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Host')
    def exportChildren(self, outfile, level, namespace_='', name_='Host', fromsubclass_=False):
        super(Host, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('<%saddress>%s</%saddress>\n' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_))
        if self.certificate is not None:
            self.certificate.export(outfile, level, namespace_, name_='certificate')
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('<%sport>%s</%sport>\n' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.storage_manager is not None:
            self.storage_manager.export(outfile, level, namespace_, name_='storage_manager')
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version')
        if self.power_management is not None:
            self.power_management.export(outfile, level, namespace_, name_='power_management')
        if self.ksm is not None:
            self.ksm.export(outfile, level, namespace_, name_='ksm')
        if self.transparent_hugepages is not None:
            self.transparent_hugepages.export(outfile, level, namespace_, name_='transparent_hugepages')
        if self.iscsi is not None:
            self.iscsi.export(outfile, level, namespace_, name_='iscsi')
        if self.root_password is not None:
            showIndent(outfile, level)
            outfile.write('<%sroot_password>%s</%sroot_password>\n' % (namespace_, self.gds_format_string(quote_xml(self.root_password).encode(ExternalEncoding), input_name='root_password'), namespace_))
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics')
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('<%smemory>%s</%smemory>\n' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_))
        if self.summary is not None:
            self.summary.export(outfile, level, namespace_, name_='summary')
        if self.override_iptables is not None:
            showIndent(outfile, level)
            outfile.write('<%soverride_iptables>%s</%soverride_iptables>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.override_iptables)), input_name='override_iptables'), namespace_))
        if self.reboot_after_installation is not None:
            showIndent(outfile, level)
            outfile.write('<%sreboot_after_installation>%s</%sreboot_after_installation>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.reboot_after_installation)), input_name='reboot_after_installation'), namespace_))
    def hasContent_(self):
        if (
            self.address is not None or
            self.certificate is not None or
            self.status is not None or
            self.cluster is not None or
            self.port is not None or
            self.type_ is not None or
            self.storage_manager is not None or
            self.version is not None or
            self.power_management is not None or
            self.ksm is not None or
            self.transparent_hugepages is not None or
            self.iscsi is not None or
            self.root_password is not None or
            self.statistics is not None or
            self.cpu is not None or
            self.memory is not None or
            self.summary is not None or
            self.override_iptables is not None or
            self.reboot_after_installation is not None or
            super(Host, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Host'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Host, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Host, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.certificate is not None:
            showIndent(outfile, level)
            outfile.write('certificate=model_.certificate(\n')
            self.certificate.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.Cluster(\n')
            self.cluster.exportLiteral(outfile, level, name_='cluster')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.storage_manager is not None:
            showIndent(outfile, level)
            outfile.write('storage_manager=model_.StorageManager(\n')
            self.storage_manager.exportLiteral(outfile, level, name_='storage_manager')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.power_management is not None:
            showIndent(outfile, level)
            outfile.write('power_management=model_.power_management(\n')
            self.power_management.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ksm is not None:
            showIndent(outfile, level)
            outfile.write('ksm=model_.ksm(\n')
            self.ksm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.transparent_hugepages is not None:
            showIndent(outfile, level)
            outfile.write('transparent_hugepages=model_.transparent_hugepages(\n')
            self.transparent_hugepages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.iscsi is not None:
            showIndent(outfile, level)
            outfile.write('iscsi=model_.IscsiDetails(\n')
            self.iscsi.exportLiteral(outfile, level, name_='iscsi')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.root_password is not None:
            showIndent(outfile, level)
            outfile.write('root_password=%s,\n' % quote_python(self.root_password).encode(ExternalEncoding))
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.cpu(\n')
            self.cpu.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=model_.VmSummary(\n')
            self.summary.exportLiteral(outfile, level, name_='summary')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.override_iptables is not None:
            showIndent(outfile, level)
            outfile.write('override_iptables=%s,\n' % self.override_iptables)
        if self.reboot_after_installation is not None:
            showIndent(outfile, level)
            outfile.write('reboot_after_installation=%s,\n' % self.reboot_after_installation)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Host, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'certificate':
            obj_ = Certificate.factory()
            obj_.build(child_)
            self.set_certificate(obj_)
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'storage_manager':
            obj_ = StorageManager.factory()
            obj_.build(child_)
            self.set_storage_manager(obj_)
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        elif nodeName_ == 'power_management':
            obj_ = PowerManagement.factory()
            obj_.build(child_)
            self.set_power_management(obj_)
        elif nodeName_ == 'ksm':
            obj_ = KSM.factory()
            obj_.build(child_)
            self.set_ksm(obj_)
        elif nodeName_ == 'transparent_hugepages':
            obj_ = TransparentHugePages.factory()
            obj_.build(child_)
            self.set_transparent_hugepages(obj_)
        elif nodeName_ == 'iscsi':
            obj_ = IscsiDetails.factory()
            obj_.build(child_)
            self.set_iscsi(obj_)
        elif nodeName_ == 'root_password':
            root_password_ = child_.text
            root_password_ = self.gds_validate_string(root_password_, node, 'root_password')
            self.root_password = root_password_
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'summary':
            obj_ = VmSummary.factory()
            obj_.build(child_)
            self.set_summary(obj_)
        elif nodeName_ == 'override_iptables':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_iptables')
            self.override_iptables = ival_
        elif nodeName_ == 'reboot_after_installation':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'reboot_after_installation')
            self.reboot_after_installation = ival_
        super(Host, self).buildChildren(child_, node, nodeName_, True)
# end class Host


class StorageManager(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, priority=None, valueOf_=None):
        self.priority = _cast(int, priority)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if StorageManager.subclass:
            return StorageManager.subclass(*args_, **kwargs_)
        else:
            return StorageManager(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='StorageManager', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageManager')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageManager'):
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.append('priority')
            outfile.write(' priority="%s"' % self.gds_format_integer(self.priority, input_name='priority'))
    def exportChildren(self, outfile, level, namespace_='', name_='StorageManager', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StorageManager'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.append('priority')
            showIndent(outfile, level)
            outfile.write('priority = %d,\n' % (self.priority,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('priority', node)
        if value is not None and 'priority' not in already_processed:
            already_processed.append('priority')
            try:
                self.priority = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class StorageManager


class HostStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_state=None):
        if host_state is None:
            self.host_state = []
        else:
            self.host_state = host_state
    def factory(*args_, **kwargs_):
        if HostStates.subclass:
            return HostStates.subclass(*args_, **kwargs_)
        else:
            return HostStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_state(self): return self.host_state
    def set_host_state(self, host_state): self.host_state = host_state
    def add_host_state(self, value): self.host_state.append(value)
    def insert_host_state(self, index, value): self.host_state[index] = value
    def export(self, outfile, level, namespace_='', name_='HostStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostStates', fromsubclass_=False):
        for host_state_ in self.host_state:
            showIndent(outfile, level)
            outfile.write('<%shost_state>%s</%shost_state>\n' % (namespace_, self.gds_format_string(quote_xml(host_state_).encode(ExternalEncoding), input_name='host_state'), namespace_))
    def hasContent_(self):
        if (
            self.host_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HostStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_state=[\n')
        level += 1
        for host_state_ in self.host_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_state':
            host_state_ = child_.text
            host_state_ = self.gds_validate_string(host_state_, node, 'host_state')
            self.host_state.append(host_state_)
# end class HostStates


class HostNonOperationalDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_non_operational_detail=None):
        if host_non_operational_detail is None:
            self.host_non_operational_detail = []
        else:
            self.host_non_operational_detail = host_non_operational_detail
    def factory(*args_, **kwargs_):
        if HostNonOperationalDetails.subclass:
            return HostNonOperationalDetails.subclass(*args_, **kwargs_)
        else:
            return HostNonOperationalDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_non_operational_detail(self): return self.host_non_operational_detail
    def set_host_non_operational_detail(self, host_non_operational_detail): self.host_non_operational_detail = host_non_operational_detail
    def add_host_non_operational_detail(self, value): self.host_non_operational_detail.append(value)
    def insert_host_non_operational_detail(self, index, value): self.host_non_operational_detail[index] = value
    def export(self, outfile, level, namespace_='', name_='HostNonOperationalDetails', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNonOperationalDetails')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNonOperationalDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostNonOperationalDetails', fromsubclass_=False):
        for host_non_operational_detail_ in self.host_non_operational_detail:
            showIndent(outfile, level)
            outfile.write('<%shost_non_operational_detail>%s</%shost_non_operational_detail>\n' % (namespace_, self.gds_format_string(quote_xml(host_non_operational_detail_).encode(ExternalEncoding), input_name='host_non_operational_detail'), namespace_))
    def hasContent_(self):
        if (
            self.host_non_operational_detail
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HostNonOperationalDetails'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_non_operational_detail=[\n')
        level += 1
        for host_non_operational_detail_ in self.host_non_operational_detail:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_non_operational_detail_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_non_operational_detail':
            host_non_operational_detail_ = child_.text
            host_non_operational_detail_ = self.gds_validate_string(host_non_operational_detail_, node, 'host_non_operational_detail')
            self.host_non_operational_detail.append(host_non_operational_detail_)
# end class HostNonOperationalDetails


class VmSummary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, active=None, migrating=None, total=None):
        self.active = active
        self.migrating = migrating
        self.total = total
    def factory(*args_, **kwargs_):
        if VmSummary.subclass:
            return VmSummary.subclass(*args_, **kwargs_)
        else:
            return VmSummary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_migrating(self): return self.migrating
    def set_migrating(self, migrating): self.migrating = migrating
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def export(self, outfile, level, namespace_='', name_='VmSummary', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmSummary')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmSummary'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmSummary', fromsubclass_=False):
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('<%sactive>%s</%sactive>\n' % (namespace_, self.gds_format_integer(self.active, input_name='active'), namespace_))
        if self.migrating is not None:
            showIndent(outfile, level)
            outfile.write('<%smigrating>%s</%smigrating>\n' % (namespace_, self.gds_format_integer(self.migrating, input_name='migrating'), namespace_))
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('<%stotal>%s</%stotal>\n' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_))
    def hasContent_(self):
        if (
            self.active is not None or
            self.migrating is not None or
            self.total is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmSummary'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%d,\n' % self.active)
        if self.migrating is not None:
            showIndent(outfile, level)
            outfile.write('migrating=%d,\n' % self.migrating)
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'active':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'migrating':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'migrating')
            self.migrating = ival_
        elif nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
# end class VmSummary


class Hosts(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, host=None):
        super(Hosts, self).__init__(actions, total, active, )
        if host is None:
            self.host = []
        else:
            self.host = host
    def factory(*args_, **kwargs_):
        if Hosts.subclass:
            return Hosts.subclass(*args_, **kwargs_)
        else:
            return Hosts(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def add_host(self, value): self.host.append(value)
    def insert_host(self, index, value): self.host[index] = value
    def export(self, outfile, level, namespace_='', name_='Hosts', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Hosts')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Hosts'):
        super(Hosts, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Hosts')
    def exportChildren(self, outfile, level, namespace_='', name_='Hosts', fromsubclass_=False):
        super(Hosts, self).exportChildren(outfile, level, namespace_, name_, True)
        for host_ in self.host:
            host_.export(outfile, level, namespace_, name_='host')
    def hasContent_(self):
        if (
            self.host or
            super(Hosts, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Hosts'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Hosts, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Hosts, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('host=[\n')
        level += 1
        for host_ in self.host:
            showIndent(outfile, level)
            outfile.write('model_.host(\n')
            host_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Hosts, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host.append(obj_)
        super(Hosts, self).buildChildren(child_, node, nodeName_, True)
# end class Hosts


class Permit(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, administrative=None, role=None):
        super(Permit, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.administrative = administrative
        self.role = role
    def factory(*args_, **kwargs_):
        if Permit.subclass:
            return Permit.subclass(*args_, **kwargs_)
        else:
            return Permit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_administrative(self): return self.administrative
    def set_administrative(self, administrative): self.administrative = administrative
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def export(self, outfile, level, namespace_='', name_='Permit', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permit')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permit'):
        super(Permit, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permit')
    def exportChildren(self, outfile, level, namespace_='', name_='Permit', fromsubclass_=False):
        super(Permit, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('<%sadministrative>%s</%sadministrative>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.administrative)), input_name='administrative'), namespace_))
        if self.role is not None:
            self.role.export(outfile, level, namespace_, name_='role')
    def hasContent_(self):
        if (
            self.administrative is not None or
            self.role is not None or
            super(Permit, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Permit'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permit, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permit, self).exportLiteralChildren(outfile, level, name_)
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('administrative=%s,\n' % self.administrative)
        if self.role is not None:
            showIndent(outfile, level)
            outfile.write('role=model_.Role(\n')
            self.role.exportLiteral(outfile, level, name_='role')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Permit, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'administrative':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'administrative')
            self.administrative = ival_
        elif nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.set_role(obj_)
        super(Permit, self).buildChildren(child_, node, nodeName_, True)
# end class Permit


class Permits(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, permit=None):
        if permit is None:
            self.permit = []
        else:
            self.permit = permit
    def factory(*args_, **kwargs_):
        if Permits.subclass:
            return Permits.subclass(*args_, **kwargs_)
        else:
            return Permits(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_permit(self): return self.permit
    def set_permit(self, permit): self.permit = permit
    def add_permit(self, value): self.permit.append(value)
    def insert_permit(self, index, value): self.permit[index] = value
    def export(self, outfile, level, namespace_='', name_='Permits', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permits')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permits'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Permits', fromsubclass_=False):
        for permit_ in self.permit:
            permit_.export(outfile, level, namespace_, name_='permit')
    def hasContent_(self):
        if (
            self.permit
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Permits'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('permit=[\n')
        level += 1
        for permit_ in self.permit:
            showIndent(outfile, level)
            outfile.write('model_.Permit(\n')
            permit_.exportLiteral(outfile, level, name_='Permit')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'permit':
            obj_ = Permit.factory()
            obj_.build(child_)
            self.permit.append(obj_)
# end class Permits


class Role(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, mutable=None, administrative=None, user=None, permits=None):
        super(Role, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.mutable = mutable
        self.administrative = administrative
        self.user = user
        self.permits = permits
    def factory(*args_, **kwargs_):
        if Role.subclass:
            return Role.subclass(*args_, **kwargs_)
        else:
            return Role(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mutable(self): return self.mutable
    def set_mutable(self, mutable): self.mutable = mutable
    def get_administrative(self): return self.administrative
    def set_administrative(self, administrative): self.administrative = administrative
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_permits(self): return self.permits
    def set_permits(self, permits): self.permits = permits
    def export(self, outfile, level, namespace_='', name_='Role', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Role')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Role'):
        super(Role, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Role')
    def exportChildren(self, outfile, level, namespace_='', name_='Role', fromsubclass_=False):
        super(Role, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.mutable is not None:
            showIndent(outfile, level)
            outfile.write('<%smutable>%s</%smutable>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.mutable)), input_name='mutable'), namespace_))
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('<%sadministrative>%s</%sadministrative>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.administrative)), input_name='administrative'), namespace_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user')
        if self.permits is not None:
            self.permits.export(outfile, level, namespace_, name_='permits')
    def hasContent_(self):
        if (
            self.mutable is not None or
            self.administrative is not None or
            self.user is not None or
            self.permits is not None or
            super(Role, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Role'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Role, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Role, self).exportLiteralChildren(outfile, level, name_)
        if self.mutable is not None:
            showIndent(outfile, level)
            outfile.write('mutable=%s,\n' % self.mutable)
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('administrative=%s,\n' % self.administrative)
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.permits is not None:
            showIndent(outfile, level)
            outfile.write('permits=model_.Permits(\n')
            self.permits.exportLiteral(outfile, level, name_='permits')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Role, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'mutable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'mutable')
            self.mutable = ival_
        elif nodeName_ == 'administrative':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'administrative')
            self.administrative = ival_
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'permits':
            obj_ = Permits.factory()
            obj_.build(child_)
            self.set_permits(obj_)
        super(Role, self).buildChildren(child_, node, nodeName_, True)
# end class Role


class Roles(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, role=None):
        super(Roles, self).__init__(actions, total, active, )
        if role is None:
            self.role = []
        else:
            self.role = role
    def factory(*args_, **kwargs_):
        if Roles.subclass:
            return Roles.subclass(*args_, **kwargs_)
        else:
            return Roles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def add_role(self, value): self.role.append(value)
    def insert_role(self, index, value): self.role[index] = value
    def export(self, outfile, level, namespace_='', name_='Roles', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Roles')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Roles'):
        super(Roles, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Roles')
    def exportChildren(self, outfile, level, namespace_='', name_='Roles', fromsubclass_=False):
        super(Roles, self).exportChildren(outfile, level, namespace_, name_, True)
        for role_ in self.role:
            role_.export(outfile, level, namespace_, name_='role')
    def hasContent_(self):
        if (
            self.role or
            super(Roles, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Roles'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Roles, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Roles, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('role=[\n')
        level += 1
        for role_ in self.role:
            showIndent(outfile, level)
            outfile.write('model_.role(\n')
            role_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Roles, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.role.append(obj_)
        super(Roles, self).buildChildren(child_, node, nodeName_, True)
# end class Roles


class User(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, domain=None, department=None, logged_in=None, last_name=None, user_name=None, password=None, email=None, roles=None, groups=None):
        super(User, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.domain = domain
        self.department = department
        self.logged_in = logged_in
        self.last_name = last_name
        self.user_name = user_name
        self.password = password
        self.email = email
        self.roles = roles
        self.groups = groups
    def factory(*args_, **kwargs_):
        if User.subclass:
            return User.subclass(*args_, **kwargs_)
        else:
            return User(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_department(self): return self.department
    def set_department(self, department): self.department = department
    def get_logged_in(self): return self.logged_in
    def set_logged_in(self, logged_in): self.logged_in = logged_in
    def get_last_name(self): return self.last_name
    def set_last_name(self, last_name): self.last_name = last_name
    def get_user_name(self): return self.user_name
    def set_user_name(self, user_name): self.user_name = user_name
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def get_groups(self): return self.groups
    def set_groups(self, groups): self.groups = groups
    def export(self, outfile, level, namespace_='', name_='User', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='User')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='User'):
        super(User, self).exportAttributes(outfile, level, already_processed, namespace_, name_='User')
    def exportChildren(self, outfile, level, namespace_='', name_='User', fromsubclass_=False):
        super(User, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain')
        if self.department is not None:
            showIndent(outfile, level)
            outfile.write('<%sdepartment>%s</%sdepartment>\n' % (namespace_, self.gds_format_string(quote_xml(self.department).encode(ExternalEncoding), input_name='department'), namespace_))
        if self.logged_in is not None:
            showIndent(outfile, level)
            outfile.write('<%slogged_in>%s</%slogged_in>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.logged_in)), input_name='logged_in'), namespace_))
        if self.last_name is not None:
            showIndent(outfile, level)
            outfile.write('<%slast_name>%s</%slast_name>\n' % (namespace_, self.gds_format_string(quote_xml(self.last_name).encode(ExternalEncoding), input_name='last_name'), namespace_))
        if self.user_name is not None:
            showIndent(outfile, level)
            outfile.write('<%suser_name>%s</%suser_name>\n' % (namespace_, self.gds_format_string(quote_xml(self.user_name).encode(ExternalEncoding), input_name='user_name'), namespace_))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('<%spassword>%s</%spassword>\n' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('<%semail>%s</%semail>\n' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_))
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_, name_='roles')
        if self.groups is not None:
            self.groups.export(outfile, level, namespace_, name_='groups')
    def hasContent_(self):
        if (
            self.domain is not None or
            self.department is not None or
            self.logged_in is not None or
            self.last_name is not None or
            self.user_name is not None or
            self.password is not None or
            self.email is not None or
            self.roles is not None or
            self.groups is not None or
            super(User, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='User'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(User, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(User, self).exportLiteralChildren(outfile, level, name_)
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.department is not None:
            showIndent(outfile, level)
            outfile.write('department=%s,\n' % quote_python(self.department).encode(ExternalEncoding))
        if self.logged_in is not None:
            showIndent(outfile, level)
            outfile.write('logged_in=%s,\n' % self.logged_in)
        if self.last_name is not None:
            showIndent(outfile, level)
            outfile.write('last_name=%s,\n' % quote_python(self.last_name).encode(ExternalEncoding))
        if self.user_name is not None:
            showIndent(outfile, level)
            outfile.write('user_name=%s,\n' % quote_python(self.user_name).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.Roles(\n')
            self.roles.exportLiteral(outfile, level, name_='roles')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.groups is not None:
            showIndent(outfile, level)
            outfile.write('groups=model_.groups(\n')
            self.groups.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(User, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'department':
            department_ = child_.text
            department_ = self.gds_validate_string(department_, node, 'department')
            self.department = department_
        elif nodeName_ == 'logged_in':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'logged_in')
            self.logged_in = ival_
        elif nodeName_ == 'last_name':
            last_name_ = child_.text
            last_name_ = self.gds_validate_string(last_name_, node, 'last_name')
            self.last_name = last_name_
        elif nodeName_ == 'user_name':
            user_name_ = child_.text
            user_name_ = self.gds_validate_string(user_name_, node, 'user_name')
            self.user_name = user_name_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'roles':
            obj_ = Roles.factory()
            obj_.build(child_)
            self.set_roles(obj_)
        elif nodeName_ == 'groups':
            obj_ = Groups.factory()
            obj_.build(child_)
            self.set_groups(obj_)
        super(User, self).buildChildren(child_, node, nodeName_, True)
# end class User


class Users(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, user=None):
        super(Users, self).__init__(actions, total, active, )
        if user is None:
            self.user = []
        else:
            self.user = user
    def factory(*args_, **kwargs_):
        if Users.subclass:
            return Users.subclass(*args_, **kwargs_)
        else:
            return Users(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def add_user(self, value): self.user.append(value)
    def insert_user(self, index, value): self.user[index] = value
    def export(self, outfile, level, namespace_='', name_='Users', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Users')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Users'):
        super(Users, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Users')
    def exportChildren(self, outfile, level, namespace_='', name_='Users', fromsubclass_=False):
        super(Users, self).exportChildren(outfile, level, namespace_, name_, True)
        for user_ in self.user:
            user_.export(outfile, level, namespace_, name_='user')
    def hasContent_(self):
        if (
            self.user or
            super(Users, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Users'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Users, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Users, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('user=[\n')
        level += 1
        for user_ in self.user:
            showIndent(outfile, level)
            outfile.write('model_.user(\n')
            user_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Users, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.user.append(obj_)
        super(Users, self).buildChildren(child_, node, nodeName_, True)
# end class Users


class Group(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, domain=None, roles=None):
        super(Group, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.domain = domain
        self.roles = roles
    def factory(*args_, **kwargs_):
        if Group.subclass:
            return Group.subclass(*args_, **kwargs_)
        else:
            return Group(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def export(self, outfile, level, namespace_='', name_='Group', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Group')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Group'):
        super(Group, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Group')
    def exportChildren(self, outfile, level, namespace_='', name_='Group', fromsubclass_=False):
        super(Group, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain')
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_, name_='roles')
    def hasContent_(self):
        if (
            self.domain is not None or
            self.roles is not None or
            super(Group, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Group'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Group, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Group, self).exportLiteralChildren(outfile, level, name_)
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.Roles(\n')
            self.roles.exportLiteral(outfile, level, name_='roles')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Group, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'roles':
            obj_ = Roles.factory()
            obj_.build(child_)
            self.set_roles(obj_)
        super(Group, self).buildChildren(child_, node, nodeName_, True)
# end class Group


class Groups(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, group=None):
        super(Groups, self).__init__(actions, total, active, )
        if group is None:
            self.group = []
        else:
            self.group = group
    def factory(*args_, **kwargs_):
        if Groups.subclass:
            return Groups.subclass(*args_, **kwargs_)
        else:
            return Groups(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def add_group(self, value): self.group.append(value)
    def insert_group(self, index, value): self.group[index] = value
    def export(self, outfile, level, namespace_='', name_='Groups', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Groups')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Groups'):
        super(Groups, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Groups')
    def exportChildren(self, outfile, level, namespace_='', name_='Groups', fromsubclass_=False):
        super(Groups, self).exportChildren(outfile, level, namespace_, name_, True)
        for group_ in self.group:
            group_.export(outfile, level, namespace_, name_='group')
    def hasContent_(self):
        if (
            self.group or
            super(Groups, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Groups'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Groups, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Groups, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('group=[\n')
        level += 1
        for group_ in self.group:
            showIndent(outfile, level)
            outfile.write('model_.group(\n')
            group_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Groups, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.group.append(obj_)
        super(Groups, self).buildChildren(child_, node, nodeName_, True)
# end class Groups


class Permission(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, role=None, user=None, group=None, data_center=None, cluster=None, host=None, storage_domain=None, vm=None, vmpool=None, template=None):
        super(Permission, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.role = role
        self.user = user
        self.group = group
        self.data_center = data_center
        self.cluster = cluster
        self.host = host
        self.storage_domain = storage_domain
        self.vm = vm
        self.vmpool = vmpool
        self.template = template
    def factory(*args_, **kwargs_):
        if Permission.subclass:
            return Permission.subclass(*args_, **kwargs_)
        else:
            return Permission(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_vmpool(self): return self.vmpool
    def set_vmpool(self, vmpool): self.vmpool = vmpool
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def export(self, outfile, level, namespace_='', name_='Permission', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permission')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permission'):
        super(Permission, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permission')
    def exportChildren(self, outfile, level, namespace_='', name_='Permission', fromsubclass_=False):
        super(Permission, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.role is not None:
            self.role.export(outfile, level, namespace_, name_='role')
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user')
        if self.group is not None:
            self.group.export(outfile, level, namespace_, name_='group')
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center')
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain')
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
        if self.vmpool is not None:
            self.vmpool.export(outfile, level, namespace_, name_='vmpool')
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template')
    def hasContent_(self):
        if (
            self.role is not None or
            self.user is not None or
            self.group is not None or
            self.data_center is not None or
            self.cluster is not None or
            self.host is not None or
            self.storage_domain is not None or
            self.vm is not None or
            self.vmpool is not None or
            self.template is not None or
            super(Permission, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Permission'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permission, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permission, self).exportLiteralChildren(outfile, level, name_)
        if self.role is not None:
            showIndent(outfile, level)
            outfile.write('role=model_.Role(\n')
            self.role.exportLiteral(outfile, level, name_='role')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.group is not None:
            showIndent(outfile, level)
            outfile.write('group=model_.Group(\n')
            self.group.exportLiteral(outfile, level, name_='group')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vmpool is not None:
            showIndent(outfile, level)
            outfile.write('vmpool=model_.vmpool(\n')
            self.vmpool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Permission, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.set_role(obj_)
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.set_group(obj_)
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'vmpool':
            obj_ = VmPool.factory()
            obj_.build(child_)
            self.set_vmpool(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        super(Permission, self).buildChildren(child_, node, nodeName_, True)
# end class Permission


class Permissions(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, permission=None):
        super(Permissions, self).__init__(actions, total, active, )
        if permission is None:
            self.permission = []
        else:
            self.permission = permission
    def factory(*args_, **kwargs_):
        if Permissions.subclass:
            return Permissions.subclass(*args_, **kwargs_)
        else:
            return Permissions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_permission(self): return self.permission
    def set_permission(self, permission): self.permission = permission
    def add_permission(self, value): self.permission.append(value)
    def insert_permission(self, index, value): self.permission[index] = value
    def export(self, outfile, level, namespace_='', name_='Permissions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permissions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permissions'):
        super(Permissions, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permissions')
    def exportChildren(self, outfile, level, namespace_='', name_='Permissions', fromsubclass_=False):
        super(Permissions, self).exportChildren(outfile, level, namespace_, name_, True)
        for permission_ in self.permission:
            permission_.export(outfile, level, namespace_, name_='permission')
    def hasContent_(self):
        if (
            self.permission or
            super(Permissions, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Permissions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permissions, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permissions, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('permission=[\n')
        level += 1
        for permission_ in self.permission:
            showIndent(outfile, level)
            outfile.write('model_.permission(\n')
            permission_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Permissions, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'permission':
            obj_ = Permission.factory()
            obj_.build(child_)
            self.permission.append(obj_)
        super(Permissions, self).buildChildren(child_, node, nodeName_, True)
# end class Permissions


class Domain(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, user=None):
        super(Domain, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.user = user
    def factory(*args_, **kwargs_):
        if Domain.subclass:
            return Domain.subclass(*args_, **kwargs_)
        else:
            return Domain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def export(self, outfile, level, namespace_='', name_='Domain', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Domain')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Domain'):
        super(Domain, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Domain')
    def exportChildren(self, outfile, level, namespace_='', name_='Domain', fromsubclass_=False):
        super(Domain, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user')
    def hasContent_(self):
        if (
            self.user is not None or
            super(Domain, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Domain'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Domain, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Domain, self).exportLiteralChildren(outfile, level, name_)
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Domain, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        super(Domain, self).buildChildren(child_, node, nodeName_, True)
# end class Domain


class Domains(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, domain=None):
        super(Domains, self).__init__(actions, total, active, )
        if domain is None:
            self.domain = []
        else:
            self.domain = domain
    def factory(*args_, **kwargs_):
        if Domains.subclass:
            return Domains.subclass(*args_, **kwargs_)
        else:
            return Domains(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def add_domain(self, value): self.domain.append(value)
    def insert_domain(self, index, value): self.domain[index] = value
    def export(self, outfile, level, namespace_='', name_='Domains', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Domains')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Domains'):
        super(Domains, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Domains')
    def exportChildren(self, outfile, level, namespace_='', name_='Domains', fromsubclass_=False):
        super(Domains, self).exportChildren(outfile, level, namespace_, name_, True)
        for domain_ in self.domain:
            domain_.export(outfile, level, namespace_, name_='domain')
    def hasContent_(self):
        if (
            self.domain or
            super(Domains, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Domains'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Domains, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Domains, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('domain=[\n')
        level += 1
        for domain_ in self.domain:
            showIndent(outfile, level)
            outfile.write('model_.domain(\n')
            domain_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Domains, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.domain.append(obj_)
        super(Domains, self).buildChildren(child_, node, nodeName_, True)
# end class Domains


class Event(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, code=None, severity=None, time=None, correlation_id=None, user=None, vm=None, storage_domain=None, host=None, template=None, cluster=None, data_center=None):
        super(Event, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.code = code
        self.severity = severity
        self.time = time
        self.correlation_id = correlation_id
        self.user = user
        self.vm = vm
        self.storage_domain = storage_domain
        self.host = host
        self.template = template
        self.cluster = cluster
        self.data_center = data_center
    def factory(*args_, **kwargs_):
        if Event.subclass:
            return Event.subclass(*args_, **kwargs_)
        else:
            return Event(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def get_correlation_id(self): return self.correlation_id
    def set_correlation_id(self, correlation_id): self.correlation_id = correlation_id
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def export(self, outfile, level, namespace_='', name_='Event', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Event')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Event'):
        super(Event, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Event')
    def exportChildren(self, outfile, level, namespace_='', name_='Event', fromsubclass_=False):
        super(Event, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('<%scode>%s</%scode>\n' % (namespace_, self.gds_format_integer(self.code, input_name='code'), namespace_))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('<%sseverity>%s</%sseverity>\n' % (namespace_, self.gds_format_string(quote_xml(self.severity).encode(ExternalEncoding), input_name='severity'), namespace_))
        if self.time is not None:
            showIndent(outfile, level)
            outfile.write('<%stime>%s</%stime>\n' % (namespace_, self.gds_format_string(quote_xml(self.time).encode(ExternalEncoding), input_name='time'), namespace_))
        if self.correlation_id is not None:
            showIndent(outfile, level)
            outfile.write('<%scorrelation_id>%s</%scorrelation_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.correlation_id).encode(ExternalEncoding), input_name='correlation_id'), namespace_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user')
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain')
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template')
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center')
    def hasContent_(self):
        if (
            self.code is not None or
            self.severity is not None or
            self.time is not None or
            self.correlation_id is not None or
            self.user is not None or
            self.vm is not None or
            self.storage_domain is not None or
            self.host is not None or
            self.template is not None or
            self.cluster is not None or
            self.data_center is not None or
            super(Event, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Event'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Event, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Event, self).exportLiteralChildren(outfile, level, name_)
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('code=%d,\n' % self.code)
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity=%s,\n' % quote_python(self.severity).encode(ExternalEncoding))
        if self.time is not None:
            showIndent(outfile, level)
            outfile.write('time=%s,\n' % quote_python(self.time).encode(ExternalEncoding))
        if self.correlation_id is not None:
            showIndent(outfile, level)
            outfile.write('correlation_id=%s,\n' % quote_python(self.correlation_id).encode(ExternalEncoding))
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Event, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'code':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'code')
            self.code = ival_
        elif nodeName_ == 'severity':
            severity_ = child_.text
            severity_ = self.gds_validate_string(severity_, node, 'severity')
            self.severity = severity_
        elif nodeName_ == 'time':
            time_ = child_.text
            time_ = self.gds_validate_string(time_, node, 'time')
            self.time = time_
        elif nodeName_ == 'correlation_id':
            correlation_id_ = child_.text
            correlation_id_ = self.gds_validate_string(correlation_id_, node, 'correlation_id')
            self.correlation_id = correlation_id_
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        super(Event, self).buildChildren(child_, node, nodeName_, True)
# end class Event


class Events(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, event=None):
        super(Events, self).__init__(actions, total, active, )
        if event is None:
            self.event = []
        else:
            self.event = event
    def factory(*args_, **kwargs_):
        if Events.subclass:
            return Events.subclass(*args_, **kwargs_)
        else:
            return Events(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_event(self): return self.event
    def set_event(self, event): self.event = event
    def add_event(self, value): self.event.append(value)
    def insert_event(self, index, value): self.event[index] = value
    def export(self, outfile, level, namespace_='', name_='Events', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Events')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Events'):
        super(Events, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Events')
    def exportChildren(self, outfile, level, namespace_='', name_='Events', fromsubclass_=False):
        super(Events, self).exportChildren(outfile, level, namespace_, name_, True)
        for event_ in self.event:
            event_.export(outfile, level, namespace_, name_='event')
    def hasContent_(self):
        if (
            self.event or
            super(Events, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Events'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Events, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Events, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('event=[\n')
        level += 1
        for event_ in self.event:
            showIndent(outfile, level)
            outfile.write('model_.event(\n')
            event_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Events, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'event':
            obj_ = Event.factory()
            obj_.build(child_)
            self.event.append(obj_)
        super(Events, self).buildChildren(child_, node, nodeName_, True)
# end class Events


class File(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, type_=None, storage_domain=None):
        super(File, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.type_ = type_
        self.storage_domain = storage_domain
    def factory(*args_, **kwargs_):
        if File.subclass:
            return File.subclass(*args_, **kwargs_)
        else:
            return File(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def export(self, outfile, level, namespace_='', name_='File', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='File'):
        super(File, self).exportAttributes(outfile, level, already_processed, namespace_, name_='File')
    def exportChildren(self, outfile, level, namespace_='', name_='File', fromsubclass_=False):
        super(File, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain')
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.storage_domain is not None or
            super(File, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(File, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(File, self).exportLiteralChildren(outfile, level, name_)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(File, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        super(File, self).buildChildren(child_, node, nodeName_, True)
# end class File


class Files(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, file=None):
        super(Files, self).__init__(actions, total, active, )
        if file is None:
            self.file = []
        else:
            self.file = file
    def factory(*args_, **kwargs_):
        if Files.subclass:
            return Files.subclass(*args_, **kwargs_)
        else:
            return Files(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def add_file(self, value): self.file.append(value)
    def insert_file(self, index, value): self.file[index] = value
    def export(self, outfile, level, namespace_='', name_='Files', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Files')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Files'):
        super(Files, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Files')
    def exportChildren(self, outfile, level, namespace_='', name_='Files', fromsubclass_=False):
        super(Files, self).exportChildren(outfile, level, namespace_, name_, True)
        for file_ in self.file:
            file_.export(outfile, level, namespace_, name_='file')
    def hasContent_(self):
        if (
            self.file or
            super(Files, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Files'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Files, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Files, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('file=[\n')
        level += 1
        for file_ in self.file:
            showIndent(outfile, level)
            outfile.write('model_.file(\n')
            file_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Files, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = File.factory()
            obj_.build(child_)
            self.file.append(obj_)
        super(Files, self).buildChildren(child_, node, nodeName_, True)
# end class Files


class IP(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, netmask=None, gateway=None, address=None):
        self.netmask = _cast(None, netmask)
        self.gateway = _cast(None, gateway)
        self.address = _cast(None, address)
        pass
    def factory(*args_, **kwargs_):
        if IP.subclass:
            return IP.subclass(*args_, **kwargs_)
        else:
            return IP(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def export(self, outfile, level, namespace_='', name_='IP', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IP')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IP'):
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.append('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.append('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.address is not None and 'address' not in already_processed:
            already_processed.append('address')
            outfile.write(' address=%s' % (self.gds_format_string(quote_attrib(self.address).encode(ExternalEncoding), input_name='address'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IP', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IP'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.append('netmask')
            showIndent(outfile, level)
            outfile.write('netmask = "%s",\n' % (self.netmask,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.append('gateway')
            showIndent(outfile, level)
            outfile.write('gateway = "%s",\n' % (self.gateway,))
        if self.address is not None and 'address' not in already_processed:
            already_processed.append('address')
            showIndent(outfile, level)
            outfile.write('address = "%s",\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.append('netmask')
            self.netmask = value
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.append('gateway')
            self.gateway = value
        value = find_attr_value_('address', node)
        if value is not None and 'address' not in already_processed:
            already_processed.append('address')
            self.address = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class IP


class IPs(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, ip=None):
        super(IPs, self).__init__(actions, total, active, )
        if ip is None:
            self.ip = []
        else:
            self.ip = ip
    def factory(*args_, **kwargs_):
        if IPs.subclass:
            return IPs.subclass(*args_, **kwargs_)
        else:
            return IPs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def add_ip(self, value): self.ip.append(value)
    def insert_ip(self, index, value): self.ip[index] = value
    def export(self, outfile, level, namespace_='', name_='IPs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IPs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IPs'):
        super(IPs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IPs')
    def exportChildren(self, outfile, level, namespace_='', name_='IPs', fromsubclass_=False):
        super(IPs, self).exportChildren(outfile, level, namespace_, name_, True)
        for ip_ in self.ip:
            ip_.export(outfile, level, namespace_, name_='ip')
    def hasContent_(self):
        if (
            self.ip or
            super(IPs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IPs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IPs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IPs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('ip=[\n')
        level += 1
        for ip_ in self.ip:
            showIndent(outfile, level)
            outfile.write('model_.ip(\n')
            ip_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IPs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.ip.append(obj_)
        super(IPs, self).buildChildren(child_, node, nodeName_, True)
# end class IPs


class MAC(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, address=None):
        self.address = _cast(None, address)
        pass
    def factory(*args_, **kwargs_):
        if MAC.subclass:
            return MAC.subclass(*args_, **kwargs_)
        else:
            return MAC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def export(self, outfile, level, namespace_='', name_='MAC', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MAC')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MAC'):
        if self.address is not None and 'address' not in already_processed:
            already_processed.append('address')
            outfile.write(' address=%s' % (self.gds_format_string(quote_attrib(self.address).encode(ExternalEncoding), input_name='address'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MAC', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MAC'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.address is not None and 'address' not in already_processed:
            already_processed.append('address')
            showIndent(outfile, level)
            outfile.write('address = "%s",\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('address', node)
        if value is not None and 'address' not in already_processed:
            already_processed.append('address')
            self.address = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MAC


class VLAN(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None):
        self.id = _cast(int, id)
        pass
    def factory(*args_, **kwargs_):
        if VLAN.subclass:
            return VLAN.subclass(*args_, **kwargs_)
        else:
            return VLAN(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='VLAN', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VLAN')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VLAN'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='VLAN', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VLAN'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %d,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VLAN


class Network(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, data_center=None, cluster=None, ip=None, vlan=None, stp=None, status=None, display=None, mtu=None, usages=None, required=None):
        super(Network, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.data_center = data_center
        self.cluster = cluster
        self.ip = ip
        self.vlan = vlan
        self.stp = stp
        self.status = status
        self.display = display
        self.mtu = mtu
        self.usages = usages
        self.required = required
    def factory(*args_, **kwargs_):
        if Network.subclass:
            return Network.subclass(*args_, **kwargs_)
        else:
            return Network(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def get_vlan(self): return self.vlan
    def set_vlan(self, vlan): self.vlan = vlan
    def get_stp(self): return self.stp
    def set_stp(self, stp): self.stp = stp
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_mtu(self): return self.mtu
    def set_mtu(self, mtu): self.mtu = mtu
    def get_usages(self): return self.usages
    def set_usages(self, usages): self.usages = usages
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def export(self, outfile, level, namespace_='', name_='Network', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Network'):
        super(Network, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
    def exportChildren(self, outfile, level, namespace_='', name_='Network', fromsubclass_=False):
        super(Network, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center')
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.ip is not None:
            self.ip.export(outfile, level, namespace_, name_='ip')
        if self.vlan is not None:
            self.vlan.export(outfile, level, namespace_, name_='vlan')
        if self.stp is not None:
            showIndent(outfile, level)
            outfile.write('<%sstp>%s</%sstp>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.stp)), input_name='stp'), namespace_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('<%sdisplay>%s</%sdisplay>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.display)), input_name='display'), namespace_))
        if self.mtu is not None:
            showIndent(outfile, level)
            outfile.write('<%smtu>%s</%smtu>\n' % (namespace_, self.gds_format_integer(self.mtu, input_name='mtu'), namespace_))
        if self.usages is not None:
            self.usages.export(outfile, level, namespace_, name_='usages')
        if self.required is not None:
            showIndent(outfile, level)
            outfile.write('<%srequired>%s</%srequired>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.required)), input_name='required'), namespace_))
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.cluster is not None or
            self.ip is not None or
            self.vlan is not None or
            self.stp is not None or
            self.status is not None or
            self.display is not None or
            self.mtu is not None or
            self.usages is not None or
            self.required is not None or
            super(Network, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Network'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Network, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Network, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ip is not None:
            showIndent(outfile, level)
            outfile.write('ip=model_.ip(\n')
            self.ip.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vlan is not None:
            showIndent(outfile, level)
            outfile.write('vlan=model_.vlan(\n')
            self.vlan.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.stp is not None:
            showIndent(outfile, level)
            outfile.write('stp=%s,\n' % self.stp)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=%s,\n' % self.display)
        if self.mtu is not None:
            showIndent(outfile, level)
            outfile.write('mtu=%d,\n' % self.mtu)
        if self.usages is not None:
            showIndent(outfile, level)
            outfile.write('usages=model_.usages(\n')
            self.usages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.required is not None:
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % self.required)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Network, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.set_ip(obj_)
        elif nodeName_ == 'vlan':
            obj_ = VLAN.factory()
            obj_.build(child_)
            self.set_vlan(obj_)
        elif nodeName_ == 'stp':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stp')
            self.stp = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'display':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'display')
            self.display = ival_
        elif nodeName_ == 'mtu':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'mtu')
            self.mtu = ival_
        elif nodeName_ == 'usages':
            obj_ = Usages.factory()
            obj_.build(child_)
            self.set_usages(obj_)
        elif nodeName_ == 'required':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'required')
            self.required = ival_
        super(Network, self).buildChildren(child_, node, nodeName_, True)
# end class Network


class NetworkStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, network_state=None):
        if network_state is None:
            self.network_state = []
        else:
            self.network_state = network_state
    def factory(*args_, **kwargs_):
        if NetworkStates.subclass:
            return NetworkStates.subclass(*args_, **kwargs_)
        else:
            return NetworkStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network_state(self): return self.network_state
    def set_network_state(self, network_state): self.network_state = network_state
    def add_network_state(self, value): self.network_state.append(value)
    def insert_network_state(self, index, value): self.network_state[index] = value
    def export(self, outfile, level, namespace_='', name_='NetworkStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkStates', fromsubclass_=False):
        for network_state_ in self.network_state:
            showIndent(outfile, level)
            outfile.write('<%snetwork_state>%s</%snetwork_state>\n' % (namespace_, self.gds_format_string(quote_xml(network_state_).encode(ExternalEncoding), input_name='network_state'), namespace_))
    def hasContent_(self):
        if (
            self.network_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NetworkStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('network_state=[\n')
        level += 1
        for network_state_ in self.network_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(network_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network_state':
            network_state_ = child_.text
            network_state_ = self.gds_validate_string(network_state_, node, 'network_state')
            self.network_state.append(network_state_)
# end class NetworkStates


class Networks(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, network=None):
        super(Networks, self).__init__(actions, total, active, )
        if network is None:
            self.network = []
        else:
            self.network = network
    def factory(*args_, **kwargs_):
        if Networks.subclass:
            return Networks.subclass(*args_, **kwargs_)
        else:
            return Networks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def add_network(self, value): self.network.append(value)
    def insert_network(self, index, value): self.network[index] = value
    def export(self, outfile, level, namespace_='', name_='Networks', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Networks')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Networks'):
        super(Networks, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Networks')
    def exportChildren(self, outfile, level, namespace_='', name_='Networks', fromsubclass_=False):
        super(Networks, self).exportChildren(outfile, level, namespace_, name_, True)
        for network_ in self.network:
            network_.export(outfile, level, namespace_, name_='network')
    def hasContent_(self):
        if (
            self.network or
            super(Networks, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Networks'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Networks, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Networks, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('network=[\n')
        level += 1
        for network_ in self.network:
            showIndent(outfile, level)
            outfile.write('model_.network(\n')
            network_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Networks, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.network.append(obj_)
        super(Networks, self).buildChildren(child_, node, nodeName_, True)
# end class Networks


class LogicalUnit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, address=None, port=None, target=None, username=None, password=None, serial=None, vendor_id=None, product_id=None, lun_mapping=None, portal=None, size=None, paths=None, status=None, volume_group_id=None, storage_domain_id=None, disk_id=None):
        self.id = _cast(None, id)
        self.address = address
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.serial = serial
        self.vendor_id = vendor_id
        self.product_id = product_id
        self.lun_mapping = lun_mapping
        self.portal = portal
        self.size = size
        self.paths = paths
        self.status = status
        self.volume_group_id = volume_group_id
        self.storage_domain_id = storage_domain_id
        self.disk_id = disk_id
    def factory(*args_, **kwargs_):
        if LogicalUnit.subclass:
            return LogicalUnit.subclass(*args_, **kwargs_)
        else:
            return LogicalUnit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_serial(self): return self.serial
    def set_serial(self, serial): self.serial = serial
    def get_vendor_id(self): return self.vendor_id
    def set_vendor_id(self, vendor_id): self.vendor_id = vendor_id
    def get_product_id(self): return self.product_id
    def set_product_id(self, product_id): self.product_id = product_id
    def get_lun_mapping(self): return self.lun_mapping
    def set_lun_mapping(self, lun_mapping): self.lun_mapping = lun_mapping
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_paths(self): return self.paths
    def set_paths(self, paths): self.paths = paths
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_volume_group_id(self): return self.volume_group_id
    def set_volume_group_id(self, volume_group_id): self.volume_group_id = volume_group_id
    def get_storage_domain_id(self): return self.storage_domain_id
    def set_storage_domain_id(self, storage_domain_id): self.storage_domain_id = storage_domain_id
    def get_disk_id(self): return self.disk_id
    def set_disk_id(self, disk_id): self.disk_id = disk_id
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='LogicalUnit', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LogicalUnit')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LogicalUnit'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LogicalUnit', fromsubclass_=False):
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('<%saddress>%s</%saddress>\n' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('<%sport>%s</%sport>\n' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_))
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('<%starget>%s</%starget>\n' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('<%susername>%s</%susername>\n' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('<%spassword>%s</%spassword>\n' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('<%sserial>%s</%sserial>\n' % (namespace_, self.gds_format_string(quote_xml(self.serial).encode(ExternalEncoding), input_name='serial'), namespace_))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('<%svendor_id>%s</%svendor_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.vendor_id).encode(ExternalEncoding), input_name='vendor_id'), namespace_))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('<%sproduct_id>%s</%sproduct_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.product_id).encode(ExternalEncoding), input_name='product_id'), namespace_))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('<%slun_mapping>%s</%slun_mapping>\n' % (namespace_, self.gds_format_integer(self.lun_mapping, input_name='lun_mapping'), namespace_))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('<%sportal>%s</%sportal>\n' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('<%ssize>%s</%ssize>\n' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_))
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('<%spaths>%s</%spaths>\n' % (namespace_, self.gds_format_integer(self.paths, input_name='paths'), namespace_))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('<%sstatus>%s</%sstatus>\n' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('<%svolume_group_id>%s</%svolume_group_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.volume_group_id).encode(ExternalEncoding), input_name='volume_group_id'), namespace_))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('<%sstorage_domain_id>%s</%sstorage_domain_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.storage_domain_id).encode(ExternalEncoding), input_name='storage_domain_id'), namespace_))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('<%sdisk_id>%s</%sdisk_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.disk_id).encode(ExternalEncoding), input_name='disk_id'), namespace_))
    def hasContent_(self):
        if (
            self.address is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.serial is not None or
            self.vendor_id is not None or
            self.product_id is not None or
            self.lun_mapping is not None or
            self.portal is not None or
            self.size is not None or
            self.paths is not None or
            self.status is not None or
            self.volume_group_id is not None or
            self.storage_domain_id is not None or
            self.disk_id is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LogicalUnit'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('serial=%s,\n' % quote_python(self.serial).encode(ExternalEncoding))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('vendor_id=%s,\n' % quote_python(self.vendor_id).encode(ExternalEncoding))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('product_id=%s,\n' % quote_python(self.product_id).encode(ExternalEncoding))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('lun_mapping=%d,\n' % self.lun_mapping)
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('paths=%d,\n' % self.paths)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_group_id=%s,\n' % quote_python(self.volume_group_id).encode(ExternalEncoding))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_id=%s,\n' % quote_python(self.storage_domain_id).encode(ExternalEncoding))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('disk_id=%s,\n' % quote_python(self.disk_id).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'serial':
            serial_ = child_.text
            serial_ = self.gds_validate_string(serial_, node, 'serial')
            self.serial = serial_
        elif nodeName_ == 'vendor_id':
            vendor_id_ = child_.text
            vendor_id_ = self.gds_validate_string(vendor_id_, node, 'vendor_id')
            self.vendor_id = vendor_id_
        elif nodeName_ == 'product_id':
            product_id_ = child_.text
            product_id_ = self.gds_validate_string(product_id_, node, 'product_id')
            self.product_id = product_id_
        elif nodeName_ == 'lun_mapping':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'lun_mapping')
            self.lun_mapping = ival_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'paths':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'paths')
            self.paths = ival_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'volume_group_id':
            volume_group_id_ = child_.text
            volume_group_id_ = self.gds_validate_string(volume_group_id_, node, 'volume_group_id')
            self.volume_group_id = volume_group_id_
        elif nodeName_ == 'storage_domain_id':
            storage_domain_id_ = child_.text
            storage_domain_id_ = self.gds_validate_string(storage_domain_id_, node, 'storage_domain_id')
            self.storage_domain_id = storage_domain_id_
        elif nodeName_ == 'disk_id':
            disk_id_ = child_.text
            disk_id_ = self.gds_validate_string(disk_id_, node, 'disk_id')
            self.disk_id = disk_id_
# end class LogicalUnit


class VolumeGroup(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, logical_unit=None):
        self.id = _cast(None, id)
        self.name = name
        if logical_unit is None:
            self.logical_unit = []
        else:
            self.logical_unit = logical_unit
    def factory(*args_, **kwargs_):
        if VolumeGroup.subclass:
            return VolumeGroup.subclass(*args_, **kwargs_)
        else:
            return VolumeGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_logical_unit(self): return self.logical_unit
    def set_logical_unit(self, logical_unit): self.logical_unit = logical_unit
    def add_logical_unit(self, value): self.logical_unit.append(value)
    def insert_logical_unit(self, index, value): self.logical_unit[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='VolumeGroup', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeGroup')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VolumeGroup'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VolumeGroup', fromsubclass_=False):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        for logical_unit_ in self.logical_unit:
            logical_unit_.export(outfile, level, namespace_, name_='logical_unit')
    def hasContent_(self):
        if (
            self.name is not None or
            self.logical_unit
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VolumeGroup'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('logical_unit=[\n')
        level += 1
        for logical_unit_ in self.logical_unit:
            showIndent(outfile, level)
            outfile.write('model_.logical_unit(\n')
            logical_unit_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'logical_unit':
            obj_ = LogicalUnit.factory()
            obj_.build(child_)
            self.logical_unit.append(obj_)
# end class VolumeGroup


class Storage(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, type_=None, address=None, path=None, mount_options=None, vfs_type=None, nfs_version=None, nfs_timeo=None, nfs_retrans=None, logical_unit=None, volume_group=None, override_luns=None, host=None):
        super(Storage, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.type_ = type_
        self.address = address
        self.path = path
        self.mount_options = mount_options
        self.vfs_type = vfs_type
        self.nfs_version = nfs_version
        self.nfs_timeo = nfs_timeo
        self.nfs_retrans = nfs_retrans
        if logical_unit is None:
            self.logical_unit = []
        else:
            self.logical_unit = logical_unit
        self.volume_group = volume_group
        self.override_luns = override_luns
        self.host = host
    def factory(*args_, **kwargs_):
        if Storage.subclass:
            return Storage.subclass(*args_, **kwargs_)
        else:
            return Storage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_path(self): return self.path
    def set_path(self, path): self.path = path
    def get_mount_options(self): return self.mount_options
    def set_mount_options(self, mount_options): self.mount_options = mount_options
    def get_vfs_type(self): return self.vfs_type
    def set_vfs_type(self, vfs_type): self.vfs_type = vfs_type
    def get_nfs_version(self): return self.nfs_version
    def set_nfs_version(self, nfs_version): self.nfs_version = nfs_version
    def get_nfs_timeo(self): return self.nfs_timeo
    def set_nfs_timeo(self, nfs_timeo): self.nfs_timeo = nfs_timeo
    def get_nfs_retrans(self): return self.nfs_retrans
    def set_nfs_retrans(self, nfs_retrans): self.nfs_retrans = nfs_retrans
    def get_logical_unit(self): return self.logical_unit
    def set_logical_unit(self, logical_unit): self.logical_unit = logical_unit
    def add_logical_unit(self, value): self.logical_unit.append(value)
    def insert_logical_unit(self, index, value): self.logical_unit[index] = value
    def get_volume_group(self): return self.volume_group
    def set_volume_group(self, volume_group): self.volume_group = volume_group
    def get_override_luns(self): return self.override_luns
    def set_override_luns(self, override_luns): self.override_luns = override_luns
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def export(self, outfile, level, namespace_='', name_='Storage', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Storage')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Storage'):
        super(Storage, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Storage')
    def exportChildren(self, outfile, level, namespace_='', name_='Storage', fromsubclass_=False):
        super(Storage, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('<%saddress>%s</%saddress>\n' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_))
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('<%spath>%s</%spath>\n' % (namespace_, self.gds_format_string(quote_xml(self.path).encode(ExternalEncoding), input_name='path'), namespace_))
        if self.mount_options is not None:
            showIndent(outfile, level)
            outfile.write('<%smount_options>%s</%smount_options>\n' % (namespace_, self.gds_format_string(quote_xml(self.mount_options).encode(ExternalEncoding), input_name='mount_options'), namespace_))
        if self.vfs_type is not None:
            showIndent(outfile, level)
            outfile.write('<%svfs_type>%s</%svfs_type>\n' % (namespace_, self.gds_format_string(quote_xml(self.vfs_type).encode(ExternalEncoding), input_name='vfs_type'), namespace_))
        if self.nfs_version is not None:
            showIndent(outfile, level)
            outfile.write('<%snfs_version>%s</%snfs_version>\n' % (namespace_, self.gds_format_integer(self.nfs_version, input_name='nfs_version'), namespace_))
        if self.nfs_timeo is not None:
            showIndent(outfile, level)
            outfile.write('<%snfs_timeo>%s</%snfs_timeo>\n' % (namespace_, self.gds_format_integer(self.nfs_timeo, input_name='nfs_timeo'), namespace_))
        if self.nfs_retrans is not None:
            showIndent(outfile, level)
            outfile.write('<%snfs_retrans>%s</%snfs_retrans>\n' % (namespace_, self.gds_format_integer(self.nfs_retrans, input_name='nfs_retrans'), namespace_))
        for logical_unit_ in self.logical_unit:
            logical_unit_.export(outfile, level, namespace_, name_='logical_unit')
        if self.volume_group is not None:
            self.volume_group.export(outfile, level, namespace_, name_='volume_group')
        if self.override_luns is not None:
            showIndent(outfile, level)
            outfile.write('<%soverride_luns>%s</%soverride_luns>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.override_luns)), input_name='override_luns'), namespace_))
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.address is not None or
            self.path is not None or
            self.mount_options is not None or
            self.vfs_type is not None or
            self.nfs_version is not None or
            self.nfs_timeo is not None or
            self.nfs_retrans is not None or
            self.logical_unit or
            self.volume_group is not None or
            self.override_luns is not None or
            self.host is not None or
            super(Storage, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Storage'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Storage, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Storage, self).exportLiteralChildren(outfile, level, name_)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('path=%s,\n' % quote_python(self.path).encode(ExternalEncoding))
        if self.mount_options is not None:
            showIndent(outfile, level)
            outfile.write('mount_options=%s,\n' % quote_python(self.mount_options).encode(ExternalEncoding))
        if self.vfs_type is not None:
            showIndent(outfile, level)
            outfile.write('vfs_type=%s,\n' % quote_python(self.vfs_type).encode(ExternalEncoding))
        if self.nfs_version is not None:
            showIndent(outfile, level)
            outfile.write('nfs_version=%d,\n' % self.nfs_version)
        if self.nfs_timeo is not None:
            showIndent(outfile, level)
            outfile.write('nfs_timeo=%d,\n' % self.nfs_timeo)
        if self.nfs_retrans is not None:
            showIndent(outfile, level)
            outfile.write('nfs_retrans=%d,\n' % self.nfs_retrans)
        showIndent(outfile, level)
        outfile.write('logical_unit=[\n')
        level += 1
        for logical_unit_ in self.logical_unit:
            showIndent(outfile, level)
            outfile.write('model_.logical_unit(\n')
            logical_unit_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.volume_group is not None:
            showIndent(outfile, level)
            outfile.write('volume_group=model_.volume_group(\n')
            self.volume_group.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.override_luns is not None:
            showIndent(outfile, level)
            outfile.write('override_luns=%s,\n' % self.override_luns)
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Storage, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'path':
            path_ = child_.text
            path_ = self.gds_validate_string(path_, node, 'path')
            self.path = path_
        elif nodeName_ == 'mount_options':
            mount_options_ = child_.text
            mount_options_ = self.gds_validate_string(mount_options_, node, 'mount_options')
            self.mount_options = mount_options_
        elif nodeName_ == 'vfs_type':
            vfs_type_ = child_.text
            vfs_type_ = self.gds_validate_string(vfs_type_, node, 'vfs_type')
            self.vfs_type = vfs_type_
        elif nodeName_ == 'nfs_version':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_version')
            self.nfs_version = ival_
        elif nodeName_ == 'nfs_timeo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_timeo')
            self.nfs_timeo = ival_
        elif nodeName_ == 'nfs_retrans':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_retrans')
            self.nfs_retrans = ival_
        elif nodeName_ == 'logical_unit':
            obj_ = LogicalUnit.factory()
            obj_.build(child_)
            self.logical_unit.append(obj_)
        elif nodeName_ == 'volume_group':
            obj_ = VolumeGroup.factory()
            obj_.build(child_)
            self.set_volume_group(obj_)
        elif nodeName_ == 'override_luns':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_luns')
            self.override_luns = ival_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        super(Storage, self).buildChildren(child_, node, nodeName_, True)
# end class Storage


class StorageDomain(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, data_center=None, type_=None, status=None, master=None, storage=None, host=None, format=None, destroy=None, available=None, used=None, committed=None, storage_format=None):
        super(StorageDomain, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.data_center = data_center
        self.type_ = type_
        self.status = status
        self.master = master
        self.storage = storage
        self.host = host
        self.format = format
        self.destroy = destroy
        self.available = available
        self.used = used
        self.committed = committed
        self.storage_format = storage_format
    def factory(*args_, **kwargs_):
        if StorageDomain.subclass:
            return StorageDomain.subclass(*args_, **kwargs_)
        else:
            return StorageDomain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_master(self): return self.master
    def set_master(self, master): self.master = master
    def get_storage(self): return self.storage
    def set_storage(self, storage): self.storage = storage
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_destroy(self): return self.destroy
    def set_destroy(self, destroy): self.destroy = destroy
    def get_available(self): return self.available
    def set_available(self, available): self.available = available
    def get_used(self): return self.used
    def set_used(self, used): self.used = used
    def get_committed(self): return self.committed
    def set_committed(self, committed): self.committed = committed
    def get_storage_format(self): return self.storage_format
    def set_storage_format(self, storage_format): self.storage_format = storage_format
    def export(self, outfile, level, namespace_='', name_='StorageDomain', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomain')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomain'):
        super(StorageDomain, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomain')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomain', fromsubclass_=False):
        super(StorageDomain, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.master is not None:
            showIndent(outfile, level)
            outfile.write('<%smaster>%s</%smaster>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.master)), input_name='master'), namespace_))
        if self.storage is not None:
            self.storage.export(outfile, level, namespace_, name_='storage')
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('<%sformat>%s</%sformat>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.format)), input_name='format'), namespace_))
        if self.destroy is not None:
            showIndent(outfile, level)
            outfile.write('<%sdestroy>%s</%sdestroy>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.destroy)), input_name='destroy'), namespace_))
        if self.available is not None:
            showIndent(outfile, level)
            outfile.write('<%savailable>%s</%savailable>\n' % (namespace_, self.gds_format_integer(self.available, input_name='available'), namespace_))
        if self.used is not None:
            showIndent(outfile, level)
            outfile.write('<%sused>%s</%sused>\n' % (namespace_, self.gds_format_integer(self.used, input_name='used'), namespace_))
        if self.committed is not None:
            showIndent(outfile, level)
            outfile.write('<%scommitted>%s</%scommitted>\n' % (namespace_, self.gds_format_integer(self.committed, input_name='committed'), namespace_))
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('<%sstorage_format>%s</%sstorage_format>\n' % (namespace_, self.gds_format_string(quote_xml(self.storage_format).encode(ExternalEncoding), input_name='storage_format'), namespace_))
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.type_ is not None or
            self.status is not None or
            self.master is not None or
            self.storage is not None or
            self.host is not None or
            self.format is not None or
            self.destroy is not None or
            self.available is not None or
            self.used is not None or
            self.committed is not None or
            self.storage_format is not None or
            super(StorageDomain, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StorageDomain'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageDomain, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageDomain, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.master is not None:
            showIndent(outfile, level)
            outfile.write('master=%s,\n' % self.master)
        if self.storage is not None:
            showIndent(outfile, level)
            outfile.write('storage=model_.storage(\n')
            self.storage.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=%s,\n' % self.format)
        if self.destroy is not None:
            showIndent(outfile, level)
            outfile.write('destroy=%s,\n' % self.destroy)
        if self.available is not None:
            showIndent(outfile, level)
            outfile.write('available=%d,\n' % self.available)
        if self.used is not None:
            showIndent(outfile, level)
            outfile.write('used=%d,\n' % self.used)
        if self.committed is not None:
            showIndent(outfile, level)
            outfile.write('committed=%d,\n' % self.committed)
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('storage_format=%s,\n' % quote_python(self.storage_format).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageDomain, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'master':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'master')
            self.master = ival_
        elif nodeName_ == 'storage':
            obj_ = Storage.factory()
            obj_.build(child_)
            self.set_storage(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'format':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'format')
            self.format = ival_
        elif nodeName_ == 'destroy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'destroy')
            self.destroy = ival_
        elif nodeName_ == 'available':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'available')
            self.available = ival_
        elif nodeName_ == 'used':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'used')
            self.used = ival_
        elif nodeName_ == 'committed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'committed')
            self.committed = ival_
        elif nodeName_ == 'storage_format':
            storage_format_ = child_.text
            storage_format_ = self.gds_validate_string(storage_format_, node, 'storage_format')
            self.storage_format = storage_format_
        super(StorageDomain, self).buildChildren(child_, node, nodeName_, True)
# end class StorageDomain


class StorageDomainStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_domain_state=None):
        if storage_domain_state is None:
            self.storage_domain_state = []
        else:
            self.storage_domain_state = storage_domain_state
    def factory(*args_, **kwargs_):
        if StorageDomainStates.subclass:
            return StorageDomainStates.subclass(*args_, **kwargs_)
        else:
            return StorageDomainStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain_state(self): return self.storage_domain_state
    def set_storage_domain_state(self, storage_domain_state): self.storage_domain_state = storage_domain_state
    def add_storage_domain_state(self, value): self.storage_domain_state.append(value)
    def insert_storage_domain_state(self, index, value): self.storage_domain_state[index] = value
    def export(self, outfile, level, namespace_='', name_='StorageDomainStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomainStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomainStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomainStates', fromsubclass_=False):
        for storage_domain_state_ in self.storage_domain_state:
            showIndent(outfile, level)
            outfile.write('<%sstorage_domain_state>%s</%sstorage_domain_state>\n' % (namespace_, self.gds_format_string(quote_xml(storage_domain_state_).encode(ExternalEncoding), input_name='storage_domain_state'), namespace_))
    def hasContent_(self):
        if (
            self.storage_domain_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StorageDomainStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_domain_state=[\n')
        level += 1
        for storage_domain_state_ in self.storage_domain_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_domain_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain_state':
            storage_domain_state_ = child_.text
            storage_domain_state_ = self.gds_validate_string(storage_domain_state_, node, 'storage_domain_state')
            self.storage_domain_state.append(storage_domain_state_)
# end class StorageDomainStates


class StorageDomains(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, storage_domain=None):
        super(StorageDomains, self).__init__(actions, total, active, )
        if storage_domain is None:
            self.storage_domain = []
        else:
            self.storage_domain = storage_domain
    def factory(*args_, **kwargs_):
        if StorageDomains.subclass:
            return StorageDomains.subclass(*args_, **kwargs_)
        else:
            return StorageDomains(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def add_storage_domain(self, value): self.storage_domain.append(value)
    def insert_storage_domain(self, index, value): self.storage_domain[index] = value
    def export(self, outfile, level, namespace_='', name_='StorageDomains', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomains')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomains'):
        super(StorageDomains, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomains')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomains', fromsubclass_=False):
        super(StorageDomains, self).exportChildren(outfile, level, namespace_, name_, True)
        for storage_domain_ in self.storage_domain:
            storage_domain_.export(outfile, level, namespace_, name_='storage_domain')
    def hasContent_(self):
        if (
            self.storage_domain or
            super(StorageDomains, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StorageDomains'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageDomains, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageDomains, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('storage_domain=[\n')
        level += 1
        for storage_domain_ in self.storage_domain:
            showIndent(outfile, level)
            outfile.write('model_.storage_domain(\n')
            storage_domain_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageDomains, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain.append(obj_)
        super(StorageDomains, self).buildChildren(child_, node, nodeName_, True)
# end class StorageDomains


class Template(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, vm=None, type_=None, status=None, memory=None, cpu=None, os=None, cluster=None, storage_domain=None, creation_time=None, origin=None, high_availability=None, display=None, stateless=None, timezone=None, domain=None, usb=None):
        super(Template, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.vm = vm
        self.type_ = type_
        self.status = status
        self.memory = memory
        self.cpu = cpu
        self.os = os
        self.cluster = cluster
        self.storage_domain = storage_domain
        self.creation_time = creation_time
        self.origin = origin
        self.high_availability = high_availability
        self.display = display
        self.stateless = stateless
        self.timezone = timezone
        self.domain = domain
        self.usb = usb
    def factory(*args_, **kwargs_):
        if Template.subclass:
            return Template.subclass(*args_, **kwargs_)
        else:
            return Template(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_creation_time(self): return self.creation_time
    def set_creation_time(self, creation_time): self.creation_time = creation_time
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_high_availability(self): return self.high_availability
    def set_high_availability(self, high_availability): self.high_availability = high_availability
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_stateless(self): return self.stateless
    def set_stateless(self, stateless): self.stateless = stateless
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_usb(self): return self.usb
    def set_usb(self, usb): self.usb = usb
    def export(self, outfile, level, namespace_='', name_='Template', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Template')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Template'):
        super(Template, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Template')
    def exportChildren(self, outfile, level, namespace_='', name_='Template', fromsubclass_=False):
        super(Template, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('<%smemory>%s</%smemory>\n' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_))
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu')
        if self.os is not None:
            self.os.export(outfile, level, namespace_, name_='os')
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain')
        if self.creation_time is not None:
            showIndent(outfile, level)
            outfile.write('<%screation_time>%s</%screation_time>\n' % (namespace_, self.gds_format_string(quote_xml(self.creation_time).encode(ExternalEncoding), input_name='creation_time'), namespace_))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('<%sorigin>%s</%sorigin>\n' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_))
        if self.high_availability is not None:
            self.high_availability.export(outfile, level, namespace_, name_='high_availability')
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display')
        if self.stateless is not None:
            showIndent(outfile, level)
            outfile.write('<%sstateless>%s</%sstateless>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.stateless)), input_name='stateless'), namespace_))
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('<%stimezone>%s</%stimezone>\n' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_))
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain')
        if self.usb is not None:
            self.usb.export(outfile, level, namespace_, name_='usb')
    def hasContent_(self):
        if (
            self.vm is not None or
            self.type_ is not None or
            self.status is not None or
            self.memory is not None or
            self.cpu is not None or
            self.os is not None or
            self.cluster is not None or
            self.storage_domain is not None or
            self.creation_time is not None or
            self.origin is not None or
            self.high_availability is not None or
            self.display is not None or
            self.stateless is not None or
            self.timezone is not None or
            self.domain is not None or
            self.usb is not None or
            super(Template, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Template'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Template, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Template, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.CPU(\n')
            self.cpu.exportLiteral(outfile, level, name_='cpu')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.os is not None:
            showIndent(outfile, level)
            outfile.write('os=model_.OperatingSystem(\n')
            self.os.exportLiteral(outfile, level, name_='os')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.creation_time is not None:
            showIndent(outfile, level)
            outfile.write('creation_time=%s,\n' % quote_python(self.creation_time).encode(ExternalEncoding))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.high_availability is not None:
            showIndent(outfile, level)
            outfile.write('high_availability=model_.HighAvailability(\n')
            self.high_availability.exportLiteral(outfile, level, name_='high_availability')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.Display(\n')
            self.display.exportLiteral(outfile, level, name_='display')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.stateless is not None:
            showIndent(outfile, level)
            outfile.write('stateless=%s,\n' % self.stateless)
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.usb is not None:
            showIndent(outfile, level)
            outfile.write('usb=model_.usb(\n')
            self.usb.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Template, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'os':
            obj_ = OperatingSystem.factory()
            obj_.build(child_)
            self.set_os(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'creation_time':
            creation_time_ = child_.text
            creation_time_ = self.gds_validate_string(creation_time_, node, 'creation_time')
            self.creation_time = creation_time_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'high_availability':
            obj_ = HighAvailability.factory()
            obj_.build(child_)
            self.set_high_availability(obj_)
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.set_display(obj_)
        elif nodeName_ == 'stateless':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stateless')
            self.stateless = ival_
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'usb':
            obj_ = Usb.factory()
            obj_.build(child_)
            self.set_usb(obj_)
        super(Template, self).buildChildren(child_, node, nodeName_, True)
# end class Template


class Templates(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, template=None):
        super(Templates, self).__init__(actions, total, active, )
        if template is None:
            self.template = []
        else:
            self.template = template
    def factory(*args_, **kwargs_):
        if Templates.subclass:
            return Templates.subclass(*args_, **kwargs_)
        else:
            return Templates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def add_template(self, value): self.template.append(value)
    def insert_template(self, index, value): self.template[index] = value
    def export(self, outfile, level, namespace_='', name_='Templates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Templates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Templates'):
        super(Templates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Templates')
    def exportChildren(self, outfile, level, namespace_='', name_='Templates', fromsubclass_=False):
        super(Templates, self).exportChildren(outfile, level, namespace_, name_, True)
        for template_ in self.template:
            template_.export(outfile, level, namespace_, name_='template')
    def hasContent_(self):
        if (
            self.template or
            super(Templates, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Templates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Templates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Templates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('template=[\n')
        level += 1
        for template_ in self.template:
            showIndent(outfile, level)
            outfile.write('model_.template(\n')
            template_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Templates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.template.append(obj_)
        super(Templates, self).buildChildren(child_, node, nodeName_, True)
# end class Templates


class TemplateStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, template_state=None):
        if template_state is None:
            self.template_state = []
        else:
            self.template_state = template_state
    def factory(*args_, **kwargs_):
        if TemplateStates.subclass:
            return TemplateStates.subclass(*args_, **kwargs_)
        else:
            return TemplateStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_template_state(self): return self.template_state
    def set_template_state(self, template_state): self.template_state = template_state
    def add_template_state(self, value): self.template_state.append(value)
    def insert_template_state(self, index, value): self.template_state[index] = value
    def export(self, outfile, level, namespace_='', name_='TemplateStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TemplateStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TemplateStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TemplateStates', fromsubclass_=False):
        for template_state_ in self.template_state:
            showIndent(outfile, level)
            outfile.write('<%stemplate_state>%s</%stemplate_state>\n' % (namespace_, self.gds_format_string(quote_xml(template_state_).encode(ExternalEncoding), input_name='template_state'), namespace_))
    def hasContent_(self):
        if (
            self.template_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TemplateStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('template_state=[\n')
        level += 1
        for template_state_ in self.template_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(template_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'template_state':
            template_state_ = child_.text
            template_state_ = self.gds_validate_string(template_state_, node, 'template_state')
            self.template_state.append(template_state_)
# end class TemplateStates


class Boot(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, dev=None):
        self.dev = _cast(None, dev)
        pass
    def factory(*args_, **kwargs_):
        if Boot.subclass:
            return Boot.subclass(*args_, **kwargs_)
        else:
            return Boot(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dev(self): return self.dev
    def set_dev(self, dev): self.dev = dev
    def export(self, outfile, level, namespace_='', name_='Boot', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Boot')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Boot'):
        if self.dev is not None and 'dev' not in already_processed:
            already_processed.append('dev')
            outfile.write(' dev=%s' % (self.gds_format_string(quote_attrib(self.dev).encode(ExternalEncoding), input_name='dev'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Boot', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Boot'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.dev is not None and 'dev' not in already_processed:
            already_processed.append('dev')
            showIndent(outfile, level)
            outfile.write('dev = "%s",\n' % (self.dev,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dev', node)
        if value is not None and 'dev' not in already_processed:
            already_processed.append('dev')
            self.dev = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Boot


class OperatingSystem(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, boot=None, kernel=None, initrd=None, cmdline=None):
        self.type_ = _cast(None, type_)
        if boot is None:
            self.boot = []
        else:
            self.boot = boot
        self.kernel = kernel
        self.initrd = initrd
        self.cmdline = cmdline
    def factory(*args_, **kwargs_):
        if OperatingSystem.subclass:
            return OperatingSystem.subclass(*args_, **kwargs_)
        else:
            return OperatingSystem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot(self): return self.boot
    def set_boot(self, boot): self.boot = boot
    def add_boot(self, value): self.boot.append(value)
    def insert_boot(self, index, value): self.boot[index] = value
    def get_kernel(self): return self.kernel
    def set_kernel(self, kernel): self.kernel = kernel
    def get_initrd(self): return self.initrd
    def set_initrd(self, initrd): self.initrd = initrd
    def get_cmdline(self): return self.cmdline
    def set_cmdline(self, cmdline): self.cmdline = cmdline
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='', name_='OperatingSystem', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OperatingSystem')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OperatingSystem'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='OperatingSystem', fromsubclass_=False):
        for boot_ in self.boot:
            boot_.export(outfile, level, namespace_, name_='boot')
        if self.kernel is not None:
            showIndent(outfile, level)
            outfile.write('<%skernel>%s</%skernel>\n' % (namespace_, self.gds_format_string(quote_xml(self.kernel).encode(ExternalEncoding), input_name='kernel'), namespace_))
        if self.initrd is not None:
            showIndent(outfile, level)
            outfile.write('<%sinitrd>%s</%sinitrd>\n' % (namespace_, self.gds_format_string(quote_xml(self.initrd).encode(ExternalEncoding), input_name='initrd'), namespace_))
        if self.cmdline is not None:
            showIndent(outfile, level)
            outfile.write('<%scmdline>%s</%scmdline>\n' % (namespace_, self.gds_format_string(quote_xml(self.cmdline).encode(ExternalEncoding), input_name='cmdline'), namespace_))
    def hasContent_(self):
        if (
            self.boot or
            self.kernel is not None or
            self.initrd is not None or
            self.cmdline is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='OperatingSystem'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot=[\n')
        level += 1
        for boot_ in self.boot:
            showIndent(outfile, level)
            outfile.write('model_.Boot(\n')
            boot_.exportLiteral(outfile, level, name_='Boot')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.kernel is not None:
            showIndent(outfile, level)
            outfile.write('kernel=%s,\n' % quote_python(self.kernel).encode(ExternalEncoding))
        if self.initrd is not None:
            showIndent(outfile, level)
            outfile.write('initrd=%s,\n' % quote_python(self.initrd).encode(ExternalEncoding))
        if self.cmdline is not None:
            showIndent(outfile, level)
            outfile.write('cmdline=%s,\n' % quote_python(self.cmdline).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot':
            obj_ = Boot.factory()
            obj_.build(child_)
            self.boot.append(obj_)
        elif nodeName_ == 'kernel':
            kernel_ = child_.text
            kernel_ = self.gds_validate_string(kernel_, node, 'kernel')
            self.kernel = kernel_
        elif nodeName_ == 'initrd':
            initrd_ = child_.text
            initrd_ = self.gds_validate_string(initrd_, node, 'initrd')
            self.initrd = initrd_
        elif nodeName_ == 'cmdline':
            cmdline_ = child_.text
            cmdline_ = self.gds_validate_string(cmdline_, node, 'cmdline')
            self.cmdline = cmdline_
# end class OperatingSystem


class HighAvailability(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None, priority=None):
        self.enabled = enabled
        self.priority = priority
    def factory(*args_, **kwargs_):
        if HighAvailability.subclass:
            return HighAvailability.subclass(*args_, **kwargs_)
        else:
            return HighAvailability(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def export(self, outfile, level, namespace_='', name_='HighAvailability', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HighAvailability')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HighAvailability'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HighAvailability', fromsubclass_=False):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('<%senabled>%s</%senabled>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.enabled)), input_name='enabled'), namespace_))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('<%spriority>%s</%spriority>\n' % (namespace_, self.gds_format_integer(self.priority, input_name='priority'), namespace_))
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.priority is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HighAvailability'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%d,\n' % self.priority)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'priority')
            self.priority = ival_
# end class HighAvailability


class Display(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, address=None, port=None, secure_port=None, monitors=None, allow_reconnect=None):
        self.type_ = type_
        self.address = address
        self.port = port
        self.secure_port = secure_port
        self.monitors = monitors
        self.allow_reconnect = allow_reconnect
    def factory(*args_, **kwargs_):
        if Display.subclass:
            return Display.subclass(*args_, **kwargs_)
        else:
            return Display(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_secure_port(self): return self.secure_port
    def set_secure_port(self, secure_port): self.secure_port = secure_port
    def get_monitors(self): return self.monitors
    def set_monitors(self, monitors): self.monitors = monitors
    def get_allow_reconnect(self): return self.allow_reconnect
    def set_allow_reconnect(self, allow_reconnect): self.allow_reconnect = allow_reconnect
    def export(self, outfile, level, namespace_='', name_='Display', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Display')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Display'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Display', fromsubclass_=False):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('<%saddress>%s</%saddress>\n' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('<%sport>%s</%sport>\n' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_))
        if self.secure_port is not None:
            showIndent(outfile, level)
            outfile.write('<%ssecure_port>%s</%ssecure_port>\n' % (namespace_, self.gds_format_integer(self.secure_port, input_name='secure_port'), namespace_))
        if self.monitors is not None:
            showIndent(outfile, level)
            outfile.write('<%smonitors>%s</%smonitors>\n' % (namespace_, self.gds_format_integer(self.monitors, input_name='monitors'), namespace_))
        if self.allow_reconnect is not None:
            showIndent(outfile, level)
            outfile.write('<%sallow_reconnect>%s</%sallow_reconnect>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.allow_reconnect)), input_name='allow_reconnect'), namespace_))
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.address is not None or
            self.port is not None or
            self.secure_port is not None or
            self.monitors is not None or
            self.allow_reconnect is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Display'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.secure_port is not None:
            showIndent(outfile, level)
            outfile.write('secure_port=%d,\n' % self.secure_port)
        if self.monitors is not None:
            showIndent(outfile, level)
            outfile.write('monitors=%d,\n' % self.monitors)
        if self.allow_reconnect is not None:
            showIndent(outfile, level)
            outfile.write('allow_reconnect=%s,\n' % self.allow_reconnect)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'secure_port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'secure_port')
            self.secure_port = ival_
        elif nodeName_ == 'monitors':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'monitors')
            self.monitors = ival_
        elif nodeName_ == 'allow_reconnect':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'allow_reconnect')
            self.allow_reconnect = ival_
# end class Display


class Ticket(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, value=None, expiry=None):
        self.value = value
        self.expiry = expiry
    def factory(*args_, **kwargs_):
        if Ticket.subclass:
            return Ticket.subclass(*args_, **kwargs_)
        else:
            return Ticket(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_expiry(self): return self.expiry
    def set_expiry(self, expiry): self.expiry = expiry
    def export(self, outfile, level, namespace_='', name_='Ticket', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Ticket')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Ticket'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Ticket', fromsubclass_=False):
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('<%sexpiry>%s</%sexpiry>\n' % (namespace_, self.gds_format_integer(self.expiry, input_name='expiry'), namespace_))
    def hasContent_(self):
        if (
            self.value is not None or
            self.expiry is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Ticket'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('expiry=%d,\n' % self.expiry)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'expiry':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'expiry')
            self.expiry = ival_
# end class Ticket


class CustomProperty(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, regexp=None, name=None, value=None):
        self.regexp = _cast(None, regexp)
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if CustomProperty.subclass:
            return CustomProperty.subclass(*args_, **kwargs_)
        else:
            return CustomProperty(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_regexp(self): return self.regexp
    def set_regexp(self, regexp): self.regexp = regexp
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def export(self, outfile, level, namespace_='', name_='CustomProperty', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CustomProperty')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CustomProperty'):
        if self.regexp is not None and 'regexp' not in already_processed:
            already_processed.append('regexp')
            outfile.write(' regexp=%s' % (self.gds_format_string(quote_attrib(self.regexp).encode(ExternalEncoding), input_name='regexp'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.append('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CustomProperty', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CustomProperty'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.regexp is not None and 'regexp' not in already_processed:
            already_processed.append('regexp')
            showIndent(outfile, level)
            outfile.write('regexp = "%s",\n' % (self.regexp,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.append('value')
            showIndent(outfile, level)
            outfile.write('value = "%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('regexp', node)
        if value is not None and 'regexp' not in already_processed:
            already_processed.append('regexp')
            self.regexp = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.append('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CustomProperty


class CustomProperties(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, custom_property=None):
        if custom_property is None:
            self.custom_property = []
        else:
            self.custom_property = custom_property
    def factory(*args_, **kwargs_):
        if CustomProperties.subclass:
            return CustomProperties.subclass(*args_, **kwargs_)
        else:
            return CustomProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_custom_property(self): return self.custom_property
    def set_custom_property(self, custom_property): self.custom_property = custom_property
    def add_custom_property(self, value): self.custom_property.append(value)
    def insert_custom_property(self, index, value): self.custom_property[index] = value
    def export(self, outfile, level, namespace_='', name_='CustomProperties', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CustomProperties')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CustomProperties'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CustomProperties', fromsubclass_=False):
        for custom_property_ in self.custom_property:
            custom_property_.export(outfile, level, namespace_, name_='custom_property')
    def hasContent_(self):
        if (
            self.custom_property
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CustomProperties'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('custom_property=[\n')
        level += 1
        for custom_property_ in self.custom_property:
            showIndent(outfile, level)
            outfile.write('model_.CustomProperty(\n')
            custom_property_.exportLiteral(outfile, level, name_='CustomProperty')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'custom_property':
            obj_ = CustomProperty.factory()
            obj_.build(child_)
            self.custom_property.append(obj_)
# end class CustomProperties


class Payloads(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, payload=None):
        if payload is None:
            self.payload = []
        else:
            self.payload = payload
    def factory(*args_, **kwargs_):
        if Payloads.subclass:
            return Payloads.subclass(*args_, **kwargs_)
        else:
            return Payloads(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_payload(self): return self.payload
    def set_payload(self, payload): self.payload = payload
    def add_payload(self, value): self.payload.append(value)
    def insert_payload(self, index, value): self.payload[index] = value
    def export(self, outfile, level, namespace_='', name_='Payloads', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Payloads')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Payloads'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Payloads', fromsubclass_=False):
        for payload_ in self.payload:
            payload_.export(outfile, level, namespace_, name_='payload')
    def hasContent_(self):
        if (
            self.payload
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Payloads'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('payload=[\n')
        level += 1
        for payload_ in self.payload:
            showIndent(outfile, level)
            outfile.write('model_.Payload(\n')
            payload_.exportLiteral(outfile, level, name_='Payload')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'payload':
            obj_ = Payload.factory()
            obj_.build(child_)
            self.payload.append(obj_)
# end class Payloads


class Payload(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, file=None):
        self.type_ = _cast(None, type_)
        self.file = file
    def factory(*args_, **kwargs_):
        if Payload.subclass:
            return Payload.subclass(*args_, **kwargs_)
        else:
            return Payload(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='', name_='Payload', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Payload')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Payload'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Payload', fromsubclass_=False):
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file', )
    def hasContent_(self):
        if (
            self.file is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Payload'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.file is not None:
            showIndent(outfile, level)
            outfile.write('file=model_.PayloadFile(\n')
            self.file.exportLiteral(outfile, level, name_='file')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = PayloadFile.factory()
            obj_.build(child_)
            self.set_file(obj_)
# end class Payload


class PayloadFile(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, content=None):
        self.name = _cast(None, name)
        self.content = content
    def factory(*args_, **kwargs_):
        if PayloadFile.subclass:
            return PayloadFile.subclass(*args_, **kwargs_)
        else:
            return PayloadFile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='', name_='PayloadFile', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PayloadFile')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PayloadFile'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PayloadFile', fromsubclass_=False):
        if self.content is not None:
            showIndent(outfile, level)
            outfile.write('<%scontent>%s</%scontent>\n' % (namespace_, self.gds_format_string(quote_xml(self.content).encode(ExternalEncoding), input_name='content'), namespace_))
    def hasContent_(self):
        if (
            self.content is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PayloadFile'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.content is not None:
            showIndent(outfile, level)
            outfile.write('content=%s,\n' % quote_python(self.content).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            content_ = child_.text
            content_ = self.gds_validate_string(content_, node, 'content')
            self.content = content_
# end class PayloadFile


class VmDeviceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_device_types=None):
        if vm_device_types is None:
            self.vm_device_types = []
        else:
            self.vm_device_types = vm_device_types
    def factory(*args_, **kwargs_):
        if VmDeviceTypes.subclass:
            return VmDeviceTypes.subclass(*args_, **kwargs_)
        else:
            return VmDeviceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_device_types(self): return self.vm_device_types
    def set_vm_device_types(self, vm_device_types): self.vm_device_types = vm_device_types
    def add_vm_device_types(self, value): self.vm_device_types.append(value)
    def insert_vm_device_types(self, index, value): self.vm_device_types[index] = value
    def export(self, outfile, level, namespace_='', name_='VmDeviceTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmDeviceTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmDeviceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmDeviceTypes', fromsubclass_=False):
        for vm_device_types_ in self.vm_device_types:
            showIndent(outfile, level)
            outfile.write('<%svm_device_types>%s</%svm_device_types>\n' % (namespace_, self.gds_format_string(quote_xml(vm_device_types_).encode(ExternalEncoding), input_name='vm_device_types'), namespace_))
    def hasContent_(self):
        if (
            self.vm_device_types
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmDeviceTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_device_types=[\n')
        level += 1
        for vm_device_types_ in self.vm_device_types:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_device_types_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_device_types':
            vm_device_types_ = child_.text
            vm_device_types_ = self.gds_validate_string(vm_device_types_, node, 'vm_device_types')
            self.vm_device_types.append(vm_device_types_)
# end class VmDeviceTypes


class VmPlacementPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host=None, affinity=None):
        self.host = host
        self.affinity = affinity
    def factory(*args_, **kwargs_):
        if VmPlacementPolicy.subclass:
            return VmPlacementPolicy.subclass(*args_, **kwargs_)
        else:
            return VmPlacementPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_affinity(self): return self.affinity
    def set_affinity(self, affinity): self.affinity = affinity
    def export(self, outfile, level, namespace_='', name_='VmPlacementPolicy', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPlacementPolicy')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPlacementPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmPlacementPolicy', fromsubclass_=False):
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.affinity is not None:
            showIndent(outfile, level)
            outfile.write('<%saffinity>%s</%saffinity>\n' % (namespace_, self.gds_format_string(quote_xml(self.affinity).encode(ExternalEncoding), input_name='affinity'), namespace_))
    def hasContent_(self):
        if (
            self.host is not None or
            self.affinity is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmPlacementPolicy'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.Host(\n')
            self.host.exportLiteral(outfile, level, name_='host')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.affinity is not None:
            showIndent(outfile, level)
            outfile.write('affinity=%s,\n' % quote_python(self.affinity).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'affinity':
            affinity_ = child_.text
            affinity_ = self.gds_validate_string(affinity_, node, 'affinity')
            self.affinity = affinity_
# end class VmPlacementPolicy


class GuestInfo(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ips=None):
        self.ips = ips
    def factory(*args_, **kwargs_):
        if GuestInfo.subclass:
            return GuestInfo.subclass(*args_, **kwargs_)
        else:
            return GuestInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ips(self): return self.ips
    def set_ips(self, ips): self.ips = ips
    def export(self, outfile, level, namespace_='', name_='GuestInfo', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GuestInfo')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GuestInfo'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GuestInfo', fromsubclass_=False):
        if self.ips is not None:
            self.ips.export(outfile, level, namespace_, name_='ips')
    def hasContent_(self):
        if (
            self.ips is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GuestInfo'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.ips is not None:
            showIndent(outfile, level)
            outfile.write('ips=model_.ips(\n')
            self.ips.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ips':
            obj_ = IPs.factory()
            obj_.build(child_)
            self.set_ips(obj_)
# end class GuestInfo


class VM(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, type_=None, status=None, memory=None, cpu=None, os=None, high_availability=None, display=None, host=None, cluster=None, template=None, storage_domain=None, start_time=None, creation_time=None, origin=None, stateless=None, timezone=None, domain=None, custom_properties=None, payloads=None, statistics=None, disks=None, nics=None, tags=None, snapshots=None, placement_policy=None, memory_policy=None, guest_info=None, quota=None, usb=None, vmpool=None, cdroms=None, floppies=None, extensiontype_=None):
        super(VM, self).__init__(actions, href, id, name, description, creation_status, link, extensiontype_, )
        self.type_ = type_
        self.status = status
        self.memory = memory
        self.cpu = cpu
        self.os = os
        self.high_availability = high_availability
        self.display = display
        self.host = host
        self.cluster = cluster
        self.template = template
        self.storage_domain = storage_domain
        self.start_time = start_time
        self.creation_time = creation_time
        self.origin = origin
        self.stateless = stateless
        self.timezone = timezone
        self.domain = domain
        self.custom_properties = custom_properties
        self.payloads = payloads
        self.statistics = statistics
        self.disks = disks
        self.nics = nics
        self.tags = tags
        self.snapshots = snapshots
        self.placement_policy = placement_policy
        self.memory_policy = memory_policy
        self.guest_info = guest_info
        self.quota = quota
        self.usb = usb
        self.vmpool = vmpool
        self.cdroms = cdroms
        self.floppies = floppies
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if VM.subclass:
            return VM.subclass(*args_, **kwargs_)
        else:
            return VM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_high_availability(self): return self.high_availability
    def set_high_availability(self, high_availability): self.high_availability = high_availability
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_start_time(self): return self.start_time
    def set_start_time(self, start_time): self.start_time = start_time
    def get_creation_time(self): return self.creation_time
    def set_creation_time(self, creation_time): self.creation_time = creation_time
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_stateless(self): return self.stateless
    def set_stateless(self, stateless): self.stateless = stateless
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_custom_properties(self): return self.custom_properties
    def set_custom_properties(self, custom_properties): self.custom_properties = custom_properties
    def get_payloads(self): return self.payloads
    def set_payloads(self, payloads): self.payloads = payloads
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_disks(self): return self.disks
    def set_disks(self, disks): self.disks = disks
    def get_nics(self): return self.nics
    def set_nics(self, nics): self.nics = nics
    def get_tags(self): return self.tags
    def set_tags(self, tags): self.tags = tags
    def get_snapshots(self): return self.snapshots
    def set_snapshots(self, snapshots): self.snapshots = snapshots
    def get_placement_policy(self): return self.placement_policy
    def set_placement_policy(self, placement_policy): self.placement_policy = placement_policy
    def get_memory_policy(self): return self.memory_policy
    def set_memory_policy(self, memory_policy): self.memory_policy = memory_policy
    def get_guest_info(self): return self.guest_info
    def set_guest_info(self, guest_info): self.guest_info = guest_info
    def get_quota(self): return self.quota
    def set_quota(self, quota): self.quota = quota
    def get_usb(self): return self.usb
    def set_usb(self, usb): self.usb = usb
    def get_vmpool(self): return self.vmpool
    def set_vmpool(self, vmpool): self.vmpool = vmpool
    def get_cdroms(self): return self.cdroms
    def set_cdroms(self, cdroms): self.cdroms = cdroms
    def get_floppies(self): return self.floppies
    def set_floppies(self, floppies): self.floppies = floppies
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='VM', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VM')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VM'):
        super(VM, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VM')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='VM', fromsubclass_=False):
        super(VM, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('<%smemory>%s</%smemory>\n' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_))
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu')
        if self.os is not None:
            self.os.export(outfile, level, namespace_, name_='os')
        if self.high_availability is not None:
            self.high_availability.export(outfile, level, namespace_, name_='high_availability')
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display')
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template')
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain')
        if self.start_time is not None:
            showIndent(outfile, level)
            outfile.write('<%sstart_time>%s</%sstart_time>\n' % (namespace_, self.gds_format_string(quote_xml(self.start_time).encode(ExternalEncoding), input_name='start_time'), namespace_))
        if self.creation_time is not None:
            showIndent(outfile, level)
            outfile.write('<%screation_time>%s</%screation_time>\n' % (namespace_, self.gds_format_string(quote_xml(self.creation_time).encode(ExternalEncoding), input_name='creation_time'), namespace_))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('<%sorigin>%s</%sorigin>\n' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_))
        if self.stateless is not None:
            showIndent(outfile, level)
            outfile.write('<%sstateless>%s</%sstateless>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.stateless)), input_name='stateless'), namespace_))
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('<%stimezone>%s</%stimezone>\n' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_))
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain')
        if self.custom_properties is not None:
            self.custom_properties.export(outfile, level, namespace_, name_='custom_properties')
        if self.payloads is not None:
            self.payloads.export(outfile, level, namespace_, name_='payloads')
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics')
        if self.disks is not None:
            self.disks.export(outfile, level, namespace_, name_='disks')
        if self.nics is not None:
            self.nics.export(outfile, level, namespace_, name_='nics')
        if self.tags is not None:
            self.tags.export(outfile, level, namespace_, name_='tags')
        if self.snapshots is not None:
            self.snapshots.export(outfile, level, namespace_, name_='snapshots')
        if self.placement_policy is not None:
            self.placement_policy.export(outfile, level, namespace_, name_='placement_policy')
        if self.memory_policy is not None:
            self.memory_policy.export(outfile, level, namespace_, name_='memory_policy')
        if self.guest_info is not None:
            self.guest_info.export(outfile, level, namespace_, name_='guest_info')
        if self.quota is not None:
            self.quota.export(outfile, level, namespace_, name_='quota')
        if self.usb is not None:
            self.usb.export(outfile, level, namespace_, name_='usb')
        if self.vmpool is not None:
            self.vmpool.export(outfile, level, namespace_, name_='vmpool')
        if self.cdroms is not None:
            self.cdroms.export(outfile, level, namespace_, name_='cdroms')
        if self.floppies is not None:
            self.floppies.export(outfile, level, namespace_, name_='floppies')
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.status is not None or
            self.memory is not None or
            self.cpu is not None or
            self.os is not None or
            self.high_availability is not None or
            self.display is not None or
            self.host is not None or
            self.cluster is not None or
            self.template is not None or
            self.storage_domain is not None or
            self.start_time is not None or
            self.creation_time is not None or
            self.origin is not None or
            self.stateless is not None or
            self.timezone is not None or
            self.domain is not None or
            self.custom_properties is not None or
            self.payloads is not None or
            self.statistics is not None or
            self.disks is not None or
            self.nics is not None or
            self.tags is not None or
            self.snapshots is not None or
            self.placement_policy is not None or
            self.memory_policy is not None or
            self.guest_info is not None or
            self.quota is not None or
            self.usb is not None or
            self.vmpool is not None or
            self.cdroms is not None or
            self.floppies is not None or
            super(VM, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VM'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VM, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VM, self).exportLiteralChildren(outfile, level, name_)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.CPU(\n')
            self.cpu.exportLiteral(outfile, level, name_='cpu')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.os is not None:
            showIndent(outfile, level)
            outfile.write('os=model_.OperatingSystem(\n')
            self.os.exportLiteral(outfile, level, name_='os')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.high_availability is not None:
            showIndent(outfile, level)
            outfile.write('high_availability=model_.HighAvailability(\n')
            self.high_availability.exportLiteral(outfile, level, name_='high_availability')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.Display(\n')
            self.display.exportLiteral(outfile, level, name_='display')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.start_time is not None:
            showIndent(outfile, level)
            outfile.write('start_time=%s,\n' % quote_python(self.start_time).encode(ExternalEncoding))
        if self.creation_time is not None:
            showIndent(outfile, level)
            outfile.write('creation_time=%s,\n' % quote_python(self.creation_time).encode(ExternalEncoding))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.stateless is not None:
            showIndent(outfile, level)
            outfile.write('stateless=%s,\n' % self.stateless)
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.custom_properties is not None:
            showIndent(outfile, level)
            outfile.write('custom_properties=model_.CustomProperties(\n')
            self.custom_properties.exportLiteral(outfile, level, name_='custom_properties')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.payloads is not None:
            showIndent(outfile, level)
            outfile.write('payloads=model_.Payloads(\n')
            self.payloads.exportLiteral(outfile, level, name_='payloads')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disks is not None:
            showIndent(outfile, level)
            outfile.write('disks=model_.Disks(\n')
            self.disks.exportLiteral(outfile, level, name_='disks')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.nics is not None:
            showIndent(outfile, level)
            outfile.write('nics=model_.Nics(\n')
            self.nics.exportLiteral(outfile, level, name_='nics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.tags is not None:
            showIndent(outfile, level)
            outfile.write('tags=model_.Tags(\n')
            self.tags.exportLiteral(outfile, level, name_='tags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.snapshots is not None:
            showIndent(outfile, level)
            outfile.write('snapshots=model_.Snapshots(\n')
            self.snapshots.exportLiteral(outfile, level, name_='snapshots')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.placement_policy is not None:
            showIndent(outfile, level)
            outfile.write('placement_policy=model_.VmPlacementPolicy(\n')
            self.placement_policy.exportLiteral(outfile, level, name_='placement_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory_policy is not None:
            showIndent(outfile, level)
            outfile.write('memory_policy=model_.MemoryPolicy(\n')
            self.memory_policy.exportLiteral(outfile, level, name_='memory_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.guest_info is not None:
            showIndent(outfile, level)
            outfile.write('guest_info=model_.GuestInfo(\n')
            self.guest_info.exportLiteral(outfile, level, name_='guest_info')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.quota is not None:
            showIndent(outfile, level)
            outfile.write('quota=model_.quota(\n')
            self.quota.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.usb is not None:
            showIndent(outfile, level)
            outfile.write('usb=model_.usb(\n')
            self.usb.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vmpool is not None:
            showIndent(outfile, level)
            outfile.write('vmpool=model_.vmpool(\n')
            self.vmpool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cdroms is not None:
            showIndent(outfile, level)
            outfile.write('cdroms=model_.cdroms(\n')
            self.cdroms.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.floppies is not None:
            showIndent(outfile, level)
            outfile.write('floppies=model_.floppies(\n')
            self.floppies.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(VM, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'os':
            obj_ = OperatingSystem.factory()
            obj_.build(child_)
            self.set_os(obj_)
        elif nodeName_ == 'high_availability':
            obj_ = HighAvailability.factory()
            obj_.build(child_)
            self.set_high_availability(obj_)
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.set_display(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'start_time':
            start_time_ = child_.text
            start_time_ = self.gds_validate_string(start_time_, node, 'start_time')
            self.start_time = start_time_
        elif nodeName_ == 'creation_time':
            creation_time_ = child_.text
            creation_time_ = self.gds_validate_string(creation_time_, node, 'creation_time')
            self.creation_time = creation_time_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'stateless':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stateless')
            self.stateless = ival_
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'custom_properties':
            obj_ = CustomProperties.factory()
            obj_.build(child_)
            self.set_custom_properties(obj_)
        elif nodeName_ == 'payloads':
            obj_ = Payloads.factory()
            obj_.build(child_)
            self.set_payloads(obj_)
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'disks':
            obj_ = Disks.factory()
            obj_.build(child_)
            self.set_disks(obj_)
        elif nodeName_ == 'nics':
            obj_ = Nics.factory()
            obj_.build(child_)
            self.set_nics(obj_)
        elif nodeName_ == 'tags':
            obj_ = Tags.factory()
            obj_.build(child_)
            self.set_tags(obj_)
        elif nodeName_ == 'snapshots':
            obj_ = Snapshots.factory()
            obj_.build(child_)
            self.set_snapshots(obj_)
        elif nodeName_ == 'placement_policy':
            obj_ = VmPlacementPolicy.factory()
            obj_.build(child_)
            self.set_placement_policy(obj_)
        elif nodeName_ == 'memory_policy':
            obj_ = MemoryPolicy.factory()
            obj_.build(child_)
            self.set_memory_policy(obj_)
        elif nodeName_ == 'guest_info':
            obj_ = GuestInfo.factory()
            obj_.build(child_)
            self.set_guest_info(obj_)
        elif nodeName_ == 'quota':
            obj_ = Quota.factory()
            obj_.build(child_)
            self.set_quota(obj_)
        elif nodeName_ == 'usb':
            obj_ = Usb.factory()
            obj_.build(child_)
            self.set_usb(obj_)
        elif nodeName_ == 'vmpool':
            obj_ = VmPool.factory()
            obj_.build(child_)
            self.set_vmpool(obj_)
        elif nodeName_ == 'cdroms':
            obj_ = CdRoms.factory()
            obj_.build(child_)
            self.set_cdroms(obj_)
        elif nodeName_ == 'floppies':
            obj_ = Floppies.factory()
            obj_.build(child_)
            self.set_floppies(obj_)
        super(VM, self).buildChildren(child_, node, nodeName_, True)
# end class VM


class VMs(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, vm=None):
        super(VMs, self).__init__(actions, total, active, )
        if vm is None:
            self.vm = []
        else:
            self.vm = vm
    def factory(*args_, **kwargs_):
        if VMs.subclass:
            return VMs.subclass(*args_, **kwargs_)
        else:
            return VMs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def add_vm(self, value): self.vm.append(value)
    def insert_vm(self, index, value): self.vm[index] = value
    def export(self, outfile, level, namespace_='', name_='VMs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VMs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VMs'):
        super(VMs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VMs')
    def exportChildren(self, outfile, level, namespace_='', name_='VMs', fromsubclass_=False):
        super(VMs, self).exportChildren(outfile, level, namespace_, name_, True)
        for vm_ in self.vm:
            vm_.export(outfile, level, namespace_, name_='vm')
    def hasContent_(self):
        if (
            self.vm or
            super(VMs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VMs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VMs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VMs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('vm=[\n')
        level += 1
        for vm_ in self.vm:
            showIndent(outfile, level)
            outfile.write('model_.vm(\n')
            vm_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VMs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.vm.append(obj_)
        super(VMs, self).buildChildren(child_, node, nodeName_, True)
# end class VMs


class PreviewVMs(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, preview_vm=None):
        super(PreviewVMs, self).__init__(actions, total, active, )
        if preview_vm is None:
            self.preview_vm = []
        else:
            self.preview_vm = preview_vm
    def factory(*args_, **kwargs_):
        if PreviewVMs.subclass:
            return PreviewVMs.subclass(*args_, **kwargs_)
        else:
            return PreviewVMs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_preview_vm(self): return self.preview_vm
    def set_preview_vm(self, preview_vm): self.preview_vm = preview_vm
    def add_preview_vm(self, value): self.preview_vm.append(value)
    def insert_preview_vm(self, index, value): self.preview_vm[index] = value
    def export(self, outfile, level, namespace_='', name_='PreviewVMs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PreviewVMs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PreviewVMs'):
        super(PreviewVMs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PreviewVMs')
    def exportChildren(self, outfile, level, namespace_='', name_='PreviewVMs', fromsubclass_=False):
        super(PreviewVMs, self).exportChildren(outfile, level, namespace_, name_, True)
        for preview_vm_ in self.preview_vm:
            preview_vm_.export(outfile, level, namespace_, name_='preview_vm')
    def hasContent_(self):
        if (
            self.preview_vm or
            super(PreviewVMs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PreviewVMs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(PreviewVMs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PreviewVMs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('preview_vm=[\n')
        level += 1
        for preview_vm_ in self.preview_vm:
            showIndent(outfile, level)
            outfile.write('model_.VM(\n')
            preview_vm_.exportLiteral(outfile, level, name_='VM')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(PreviewVMs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'preview_vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.preview_vm.append(obj_)
        super(PreviewVMs, self).buildChildren(child_, node, nodeName_, True)
# end class PreviewVMs


class VmStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_state=None):
        if vm_state is None:
            self.vm_state = []
        else:
            self.vm_state = vm_state
    def factory(*args_, **kwargs_):
        if VmStates.subclass:
            return VmStates.subclass(*args_, **kwargs_)
        else:
            return VmStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_state(self): return self.vm_state
    def set_vm_state(self, vm_state): self.vm_state = vm_state
    def add_vm_state(self, value): self.vm_state.append(value)
    def insert_vm_state(self, index, value): self.vm_state[index] = value
    def export(self, outfile, level, namespace_='', name_='VmStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmStates', fromsubclass_=False):
        for vm_state_ in self.vm_state:
            showIndent(outfile, level)
            outfile.write('<%svm_state>%s</%svm_state>\n' % (namespace_, self.gds_format_string(quote_xml(vm_state_).encode(ExternalEncoding), input_name='vm_state'), namespace_))
    def hasContent_(self):
        if (
            self.vm_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_state=[\n')
        level += 1
        for vm_state_ in self.vm_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_state':
            vm_state_ = child_.text
            vm_state_ = self.gds_validate_string(vm_state_, node, 'vm_state')
            self.vm_state.append(vm_state_)
# end class VmStates


class VmPauseDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_pause_detail=None):
        if vm_pause_detail is None:
            self.vm_pause_detail = []
        else:
            self.vm_pause_detail = vm_pause_detail
    def factory(*args_, **kwargs_):
        if VmPauseDetails.subclass:
            return VmPauseDetails.subclass(*args_, **kwargs_)
        else:
            return VmPauseDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_pause_detail(self): return self.vm_pause_detail
    def set_vm_pause_detail(self, vm_pause_detail): self.vm_pause_detail = vm_pause_detail
    def add_vm_pause_detail(self, value): self.vm_pause_detail.append(value)
    def insert_vm_pause_detail(self, index, value): self.vm_pause_detail[index] = value
    def export(self, outfile, level, namespace_='', name_='VmPauseDetails', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPauseDetails')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPauseDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmPauseDetails', fromsubclass_=False):
        for vm_pause_detail_ in self.vm_pause_detail:
            showIndent(outfile, level)
            outfile.write('<%svm_pause_detail>%s</%svm_pause_detail>\n' % (namespace_, self.gds_format_string(quote_xml(vm_pause_detail_).encode(ExternalEncoding), input_name='vm_pause_detail'), namespace_))
    def hasContent_(self):
        if (
            self.vm_pause_detail
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmPauseDetails'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_pause_detail=[\n')
        level += 1
        for vm_pause_detail_ in self.vm_pause_detail:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_pause_detail_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_pause_detail':
            vm_pause_detail_ = child_.text
            vm_pause_detail_ = self.gds_validate_string(vm_pause_detail_, node, 'vm_pause_detail')
            self.vm_pause_detail.append(vm_pause_detail_)
# end class VmPauseDetails


class VmPool(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, size=None, cluster=None, template=None, prestarted_vms=None):
        super(VmPool, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.size = size
        self.cluster = cluster
        self.template = template
        self.prestarted_vms = prestarted_vms
    def factory(*args_, **kwargs_):
        if VmPool.subclass:
            return VmPool.subclass(*args_, **kwargs_)
        else:
            return VmPool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_prestarted_vms(self): return self.prestarted_vms
    def set_prestarted_vms(self, prestarted_vms): self.prestarted_vms = prestarted_vms
    def export(self, outfile, level, namespace_='', name_='VmPool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPool'):
        super(VmPool, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VmPool')
    def exportChildren(self, outfile, level, namespace_='', name_='VmPool', fromsubclass_=False):
        super(VmPool, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('<%ssize>%s</%ssize>\n' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_))
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template')
        if self.prestarted_vms is not None:
            showIndent(outfile, level)
            outfile.write('<%sprestarted_vms>%s</%sprestarted_vms>\n' % (namespace_, self.gds_format_integer(self.prestarted_vms, input_name='prestarted_vms'), namespace_))
    def hasContent_(self):
        if (
            self.size is not None or
            self.cluster is not None or
            self.template is not None or
            self.prestarted_vms is not None or
            super(VmPool, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmPool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VmPool, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VmPool, self).exportLiteralChildren(outfile, level, name_)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.prestarted_vms is not None:
            showIndent(outfile, level)
            outfile.write('prestarted_vms=%d,\n' % self.prestarted_vms)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VmPool, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'prestarted_vms':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'prestarted_vms')
            self.prestarted_vms = ival_
        super(VmPool, self).buildChildren(child_, node, nodeName_, True)
# end class VmPool


class VmPools(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, vmpool=None):
        super(VmPools, self).__init__(actions, total, active, )
        if vmpool is None:
            self.vmpool = []
        else:
            self.vmpool = vmpool
    def factory(*args_, **kwargs_):
        if VmPools.subclass:
            return VmPools.subclass(*args_, **kwargs_)
        else:
            return VmPools(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vmpool(self): return self.vmpool
    def set_vmpool(self, vmpool): self.vmpool = vmpool
    def add_vmpool(self, value): self.vmpool.append(value)
    def insert_vmpool(self, index, value): self.vmpool[index] = value
    def export(self, outfile, level, namespace_='', name_='VmPools', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPools')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPools'):
        super(VmPools, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VmPools')
    def exportChildren(self, outfile, level, namespace_='', name_='VmPools', fromsubclass_=False):
        super(VmPools, self).exportChildren(outfile, level, namespace_, name_, True)
        for vmpool_ in self.vmpool:
            vmpool_.export(outfile, level, namespace_, name_='vmpool')
    def hasContent_(self):
        if (
            self.vmpool or
            super(VmPools, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VmPools'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VmPools, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VmPools, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('vmpool=[\n')
        level += 1
        for vmpool_ in self.vmpool:
            showIndent(outfile, level)
            outfile.write('model_.vmpool(\n')
            vmpool_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VmPools, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vmpool':
            obj_ = VmPool.factory()
            obj_.build(child_)
            self.vmpool.append(obj_)
        super(VmPools, self).buildChildren(child_, node, nodeName_, True)
# end class VmPools


class BaseDevice(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, vm=None, template=None, extensiontype_=None):
        super(BaseDevice, self).__init__(actions, href, id, name, description, creation_status, link, extensiontype_, )
        self.vm = vm
        self.template = template
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseDevice.subclass:
            return BaseDevice.subclass(*args_, **kwargs_)
        else:
            return BaseDevice(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='BaseDevice', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevice')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseDevice'):
        super(BaseDevice, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevice')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseDevice', fromsubclass_=False):
        super(BaseDevice, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template')
    def hasContent_(self):
        if (
            self.vm is not None or
            self.template is not None or
            super(BaseDevice, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BaseDevice'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseDevice, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseDevice, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(BaseDevice, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        super(BaseDevice, self).buildChildren(child_, node, nodeName_, True)
# end class BaseDevice


class BaseDevices(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, extensiontype_=None):
        super(BaseDevices, self).__init__(actions, total, active, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseDevices.subclass:
            return BaseDevices.subclass(*args_, **kwargs_)
        else:
            return BaseDevices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='BaseDevices', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevices')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseDevices'):
        super(BaseDevices, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevices')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseDevices', fromsubclass_=False):
        super(BaseDevices, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(BaseDevices, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BaseDevices'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseDevices, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseDevices, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(BaseDevices, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseDevices, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseDevices


class CdRom(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, vm=None, template=None, file=None):
        super(CdRom, self).__init__(actions, href, id, name, description, creation_status, link, vm, template, )
        self.file = file
    def factory(*args_, **kwargs_):
        if CdRom.subclass:
            return CdRom.subclass(*args_, **kwargs_)
        else:
            return CdRom(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def export(self, outfile, level, namespace_='', name_='CdRom', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CdRom')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CdRom'):
        super(CdRom, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CdRom')
    def exportChildren(self, outfile, level, namespace_='', name_='CdRom', fromsubclass_=False):
        super(CdRom, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file')
    def hasContent_(self):
        if (
            self.file is not None or
            super(CdRom, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CdRom'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CdRom, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CdRom, self).exportLiteralChildren(outfile, level, name_)
        if self.file is not None:
            showIndent(outfile, level)
            outfile.write('file=model_.file(\n')
            self.file.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(CdRom, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = File.factory()
            obj_.build(child_)
            self.set_file(obj_)
        super(CdRom, self).buildChildren(child_, node, nodeName_, True)
# end class CdRom


class CdRoms(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, cdrom=None):
        super(CdRoms, self).__init__(actions, total, active, )
        if cdrom is None:
            self.cdrom = []
        else:
            self.cdrom = cdrom
    def factory(*args_, **kwargs_):
        if CdRoms.subclass:
            return CdRoms.subclass(*args_, **kwargs_)
        else:
            return CdRoms(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cdrom(self): return self.cdrom
    def set_cdrom(self, cdrom): self.cdrom = cdrom
    def add_cdrom(self, value): self.cdrom.append(value)
    def insert_cdrom(self, index, value): self.cdrom[index] = value
    def export(self, outfile, level, namespace_='', name_='CdRoms', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CdRoms')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CdRoms'):
        super(CdRoms, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CdRoms')
    def exportChildren(self, outfile, level, namespace_='', name_='CdRoms', fromsubclass_=False):
        super(CdRoms, self).exportChildren(outfile, level, namespace_, name_, True)
        for cdrom_ in self.cdrom:
            cdrom_.export(outfile, level, namespace_, name_='cdrom')
    def hasContent_(self):
        if (
            self.cdrom or
            super(CdRoms, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CdRoms'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CdRoms, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CdRoms, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('cdrom=[\n')
        level += 1
        for cdrom_ in self.cdrom:
            showIndent(outfile, level)
            outfile.write('model_.cdrom(\n')
            cdrom_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(CdRoms, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cdrom':
            obj_ = CdRom.factory()
            obj_.build(child_)
            self.cdrom.append(obj_)
        super(CdRoms, self).buildChildren(child_, node, nodeName_, True)
# end class CdRoms


class Floppy(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, vm=None, template=None, file=None):
        super(Floppy, self).__init__(actions, href, id, name, description, creation_status, link, vm, template, )
        self.file = file
    def factory(*args_, **kwargs_):
        if Floppy.subclass:
            return Floppy.subclass(*args_, **kwargs_)
        else:
            return Floppy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def export(self, outfile, level, namespace_='', name_='Floppy', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Floppy')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Floppy'):
        super(Floppy, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Floppy')
    def exportChildren(self, outfile, level, namespace_='', name_='Floppy', fromsubclass_=False):
        super(Floppy, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file', )
    def hasContent_(self):
        if (
            self.file is not None or
            super(Floppy, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Floppy'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Floppy, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Floppy, self).exportLiteralChildren(outfile, level, name_)
        if self.file is not None:
            showIndent(outfile, level)
            outfile.write('file=model_.file(\n')
            self.file.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Floppy, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = File.factory()
            obj_.build(child_)
            self.set_file(obj_)
        super(Floppy, self).buildChildren(child_, node, nodeName_, True)
# end class Floppy


class Floppies(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, floppy=None):
        super(Floppies, self).__init__(actions, total, active, )
        if floppy is None:
            self.floppy = []
        else:
            self.floppy = floppy
    def factory(*args_, **kwargs_):
        if Floppies.subclass:
            return Floppies.subclass(*args_, **kwargs_)
        else:
            return Floppies(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_floppy(self): return self.floppy
    def set_floppy(self, floppy): self.floppy = floppy
    def add_floppy(self, value): self.floppy.append(value)
    def insert_floppy(self, index, value): self.floppy[index] = value
    def export(self, outfile, level, namespace_='', name_='Floppies', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Floppies')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Floppies'):
        super(Floppies, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Floppies')
    def exportChildren(self, outfile, level, namespace_='', name_='Floppies', fromsubclass_=False):
        super(Floppies, self).exportChildren(outfile, level, namespace_, name_, True)
        for floppy_ in self.floppy:
            floppy_.export(outfile, level, namespace_, name_='floppy')
    def hasContent_(self):
        if (
            self.floppy or
            super(Floppies, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Floppies'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Floppies, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Floppies, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('floppy=[\n')
        level += 1
        for floppy_ in self.floppy:
            showIndent(outfile, level)
            outfile.write('model_.floppy(\n')
            floppy_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Floppies, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'floppy':
            obj_ = Floppy.factory()
            obj_.build(child_)
            self.floppy.append(obj_)
        super(Floppies, self).buildChildren(child_, node, nodeName_, True)
# end class Floppies


class Disk(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, vm=None, template=None, image_id=None, storage_domains=None, size=None, provisioned_size=None, actual_size=None, status=None, interface=None, format=None, sparse=None, bootable=None, shareable=None, wipe_after_delete=None, propagate_errors=None, statistics=None, active=None, quota=None, lunStorage=None):
        super(Disk, self).__init__(actions, href, id, name, description, creation_status, link, vm, template, )
        self.image_id = image_id
        self.storage_domains = storage_domains
        self.size = size
        self.provisioned_size = provisioned_size
        self.actual_size = actual_size
        self.status = status
        self.interface = interface
        self.format = format
        self.sparse = sparse
        self.bootable = bootable
        self.shareable = shareable
        self.wipe_after_delete = wipe_after_delete
        self.propagate_errors = propagate_errors
        self.statistics = statistics
        self.active = active
        self.quota = quota
        self.lunStorage = lunStorage
    def factory(*args_, **kwargs_):
        if Disk.subclass:
            return Disk.subclass(*args_, **kwargs_)
        else:
            return Disk(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_image_id(self): return self.image_id
    def set_image_id(self, image_id): self.image_id = image_id
    def get_storage_domains(self): return self.storage_domains
    def set_storage_domains(self, storage_domains): self.storage_domains = storage_domains
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_provisioned_size(self): return self.provisioned_size
    def set_provisioned_size(self, provisioned_size): self.provisioned_size = provisioned_size
    def get_actual_size(self): return self.actual_size
    def set_actual_size(self, actual_size): self.actual_size = actual_size
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_interface(self): return self.interface
    def set_interface(self, interface): self.interface = interface
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_sparse(self): return self.sparse
    def set_sparse(self, sparse): self.sparse = sparse
    def get_bootable(self): return self.bootable
    def set_bootable(self, bootable): self.bootable = bootable
    def get_shareable(self): return self.shareable
    def set_shareable(self, shareable): self.shareable = shareable
    def get_wipe_after_delete(self): return self.wipe_after_delete
    def set_wipe_after_delete(self, wipe_after_delete): self.wipe_after_delete = wipe_after_delete
    def get_propagate_errors(self): return self.propagate_errors
    def set_propagate_errors(self, propagate_errors): self.propagate_errors = propagate_errors
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_quota(self): return self.quota
    def set_quota(self, quota): self.quota = quota
    def get_lunStorage(self): return self.lunStorage
    def set_lunStorage(self, lunStorage): self.lunStorage = lunStorage
    def export(self, outfile, level, namespace_='', name_='Disk', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Disk')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Disk'):
        super(Disk, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Disk')
    def exportChildren(self, outfile, level, namespace_='', name_='Disk', fromsubclass_=False):
        super(Disk, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.image_id is not None:
            showIndent(outfile, level)
            outfile.write('<%simage_id>%s</%simage_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.image_id).encode(ExternalEncoding), input_name='image_id'), namespace_))
        if self.storage_domains is not None:
            self.storage_domains.export(outfile, level, namespace_, name_='storage_domains')
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('<%ssize>%s</%ssize>\n' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_))
        if self.provisioned_size is not None:
            showIndent(outfile, level)
            outfile.write('<%sprovisioned_size>%s</%sprovisioned_size>\n' % (namespace_, self.gds_format_integer(self.provisioned_size, input_name='provisioned_size'), namespace_))
        if self.actual_size is not None:
            showIndent(outfile, level)
            outfile.write('<%sactual_size>%s</%sactual_size>\n' % (namespace_, self.gds_format_integer(self.actual_size, input_name='actual_size'), namespace_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.interface is not None:
            showIndent(outfile, level)
            outfile.write('<%sinterface>%s</%sinterface>\n' % (namespace_, self.gds_format_string(quote_xml(self.interface).encode(ExternalEncoding), input_name='interface'), namespace_))
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('<%sformat>%s</%sformat>\n' % (namespace_, self.gds_format_string(quote_xml(self.format).encode(ExternalEncoding), input_name='format'), namespace_))
        if self.sparse is not None:
            showIndent(outfile, level)
            outfile.write('<%ssparse>%s</%ssparse>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.sparse)), input_name='sparse'), namespace_))
        if self.bootable is not None:
            showIndent(outfile, level)
            outfile.write('<%sbootable>%s</%sbootable>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.bootable)), input_name='bootable'), namespace_))
        if self.shareable is not None:
            showIndent(outfile, level)
            outfile.write('<%sshareable>%s</%sshareable>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.shareable)), input_name='shareable'), namespace_))
        if self.wipe_after_delete is not None:
            showIndent(outfile, level)
            outfile.write('<%swipe_after_delete>%s</%swipe_after_delete>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.wipe_after_delete)), input_name='wipe_after_delete'), namespace_))
        if self.propagate_errors is not None:
            showIndent(outfile, level)
            outfile.write('<%spropagate_errors>%s</%spropagate_errors>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.propagate_errors)), input_name='propagate_errors'), namespace_))
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics')
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('<%sactive>%s</%sactive>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.active)), input_name='active'), namespace_))
        if self.quota is not None:
            self.quota.export(outfile, level, namespace_, name_='quota')
        if self.lunStorage is not None:
            self.lunStorage.export(outfile, level, namespace_, name_='lunStorage')
    def hasContent_(self):
        if (
            self.image_id is not None or
            self.storage_domains is not None or
            self.size is not None or
            self.provisioned_size is not None or
            self.actual_size is not None or
            self.status is not None or
            self.interface is not None or
            self.format is not None or
            self.sparse is not None or
            self.bootable is not None or
            self.shareable is not None or
            self.wipe_after_delete is not None or
            self.propagate_errors is not None or
            self.statistics is not None or
            self.active is not None or
            self.quota is not None or
            self.lunStorage is not None or
            super(Disk, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Disk'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Disk, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Disk, self).exportLiteralChildren(outfile, level, name_)
        if self.image_id is not None:
            showIndent(outfile, level)
            outfile.write('image_id=%s,\n' % quote_python(self.image_id).encode(ExternalEncoding))
        if self.storage_domains is not None:
            showIndent(outfile, level)
            outfile.write('storage_domains=model_.storage_domains(\n')
            self.storage_domains.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.provisioned_size is not None:
            showIndent(outfile, level)
            outfile.write('provisioned_size=%d,\n' % self.provisioned_size)
        if self.actual_size is not None:
            showIndent(outfile, level)
            outfile.write('actual_size=%d,\n' % self.actual_size)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.interface is not None:
            showIndent(outfile, level)
            outfile.write('interface=%s,\n' % quote_python(self.interface).encode(ExternalEncoding))
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=%s,\n' % quote_python(self.format).encode(ExternalEncoding))
        if self.sparse is not None:
            showIndent(outfile, level)
            outfile.write('sparse=%s,\n' % self.sparse)
        if self.bootable is not None:
            showIndent(outfile, level)
            outfile.write('bootable=%s,\n' % self.bootable)
        if self.shareable is not None:
            showIndent(outfile, level)
            outfile.write('shareable=%s,\n' % self.shareable)
        if self.wipe_after_delete is not None:
            showIndent(outfile, level)
            outfile.write('wipe_after_delete=%s,\n' % self.wipe_after_delete)
        if self.propagate_errors is not None:
            showIndent(outfile, level)
            outfile.write('propagate_errors=%s,\n' % self.propagate_errors)
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.quota is not None:
            showIndent(outfile, level)
            outfile.write('quota=model_.quota(\n')
            self.quota.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.lunStorage is not None:
            showIndent(outfile, level)
            outfile.write('lunStorage=model_.Storage(\n')
            self.lunStorage.exportLiteral(outfile, level, name_='lunStorage')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Disk, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'image_id':
            image_id_ = child_.text
            image_id_ = self.gds_validate_string(image_id_, node, 'image_id')
            self.image_id = image_id_
        elif nodeName_ == 'storage_domains':
            obj_ = StorageDomains.factory()
            obj_.build(child_)
            self.set_storage_domains(obj_)
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'provisioned_size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'provisioned_size')
            self.provisioned_size = ival_
        elif nodeName_ == 'actual_size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'actual_size')
            self.actual_size = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'interface':
            interface_ = child_.text
            interface_ = self.gds_validate_string(interface_, node, 'interface')
            self.interface = interface_
        elif nodeName_ == 'format':
            format_ = child_.text
            format_ = self.gds_validate_string(format_, node, 'format')
            self.format = format_
        elif nodeName_ == 'sparse':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'sparse')
            self.sparse = ival_
        elif nodeName_ == 'bootable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'bootable')
            self.bootable = ival_
        elif nodeName_ == 'shareable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'shareable')
            self.shareable = ival_
        elif nodeName_ == 'wipe_after_delete':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'wipe_after_delete')
            self.wipe_after_delete = ival_
        elif nodeName_ == 'propagate_errors':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'propagate_errors')
            self.propagate_errors = ival_
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'quota':
            obj_ = Quota.factory()
            obj_.build(child_)
            self.set_quota(obj_)
        elif nodeName_ == 'lunStorage':
            obj_ = Storage.factory()
            obj_.build(child_)
            self.set_lunStorage(obj_)
        super(Disk, self).buildChildren(child_, node, nodeName_, True)
# end class Disk


class Disks(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, disk=None, clone=None):
        super(Disks, self).__init__(actions, total, active, )
        if disk is None:
            self.disk = []
        else:
            self.disk = disk
        self.clone = clone
    def factory(*args_, **kwargs_):
        if Disks.subclass:
            return Disks.subclass(*args_, **kwargs_)
        else:
            return Disks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def add_disk(self, value): self.disk.append(value)
    def insert_disk(self, index, value): self.disk[index] = value
    def get_clone(self): return self.clone
    def set_clone(self, clone): self.clone = clone
    def export(self, outfile, level, namespace_='', name_='Disks', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Disks')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Disks'):
        super(Disks, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Disks')
    def exportChildren(self, outfile, level, namespace_='', name_='Disks', fromsubclass_=False):
        super(Disks, self).exportChildren(outfile, level, namespace_, name_, True)
        for disk_ in self.disk:
            disk_.export(outfile, level, namespace_, name_='disk')
        if self.clone is not None:
            showIndent(outfile, level)
            outfile.write('<%sclone>%s</%sclone>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.clone)), input_name='clone'), namespace_))
    def hasContent_(self):
        if (
            self.disk or
            self.clone is not None or
            super(Disks, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Disks'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Disks, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Disks, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('disk=[\n')
        level += 1
        for disk_ in self.disk:
            showIndent(outfile, level)
            outfile.write('model_.disk(\n')
            disk_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.clone is not None:
            showIndent(outfile, level)
            outfile.write('clone=%s,\n' % self.clone)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Disks, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk':
            obj_ = Disk.factory()
            obj_.build(child_)
            self.disk.append(obj_)
        elif nodeName_ == 'clone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'clone')
            self.clone = ival_
        super(Disks, self).buildChildren(child_, node, nodeName_, True)
# end class Disks


class DiskStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_state=None):
        if disk_state is None:
            self.disk_state = []
        else:
            self.disk_state = disk_state
    def factory(*args_, **kwargs_):
        if DiskStates.subclass:
            return DiskStates.subclass(*args_, **kwargs_)
        else:
            return DiskStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_state(self): return self.disk_state
    def set_disk_state(self, disk_state): self.disk_state = disk_state
    def add_disk_state(self, value): self.disk_state.append(value)
    def insert_disk_state(self, index, value): self.disk_state[index] = value
    def export(self, outfile, level, namespace_='', name_='DiskStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskStates', fromsubclass_=False):
        for disk_state_ in self.disk_state:
            showIndent(outfile, level)
            outfile.write('<%sdisk_state>%s</%sdisk_state>\n' % (namespace_, self.gds_format_string(quote_xml(disk_state_).encode(ExternalEncoding), input_name='disk_state'), namespace_))
    def hasContent_(self):
        if (
            self.disk_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DiskStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_state=[\n')
        level += 1
        for disk_state_ in self.disk_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_state':
            disk_state_ = child_.text
            disk_state_ = self.gds_validate_string(disk_state_, node, 'disk_state')
            self.disk_state.append(disk_state_)
# end class DiskStates


class PortMirroring(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, networks=None):
        self.networks = networks
    def factory(*args_, **kwargs_):
        if PortMirroring.subclass:
            return PortMirroring.subclass(*args_, **kwargs_)
        else:
            return PortMirroring(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_networks(self): return self.networks
    def set_networks(self, networks): self.networks = networks
    def export(self, outfile, level, namespace_='', name_='PortMirroring', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PortMirroring')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PortMirroring'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PortMirroring', fromsubclass_=False):
        if self.networks is not None:
            self.networks.export(outfile, level, namespace_, name_='networks')
    def hasContent_(self):
        if (
            self.networks is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PortMirroring'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.networks is not None:
            showIndent(outfile, level)
            outfile.write('networks=model_.networks(\n')
            self.networks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'networks':
            obj_ = Networks.factory()
            obj_.build(child_)
            self.set_networks(obj_)
# end class PortMirroring


class NIC(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, vm=None, template=None, network=None, interface=None, mac=None, statistics=None, active=None, port_mirroring=None):
        super(NIC, self).__init__(actions, href, id, name, description, creation_status, link, vm, template, )
        self.network = network
        self.interface = interface
        self.mac = mac
        self.statistics = statistics
        self.active = active
        self.port_mirroring = port_mirroring
    def factory(*args_, **kwargs_):
        if NIC.subclass:
            return NIC.subclass(*args_, **kwargs_)
        else:
            return NIC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_interface(self): return self.interface
    def set_interface(self, interface): self.interface = interface
    def get_mac(self): return self.mac
    def set_mac(self, mac): self.mac = mac
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_port_mirroring(self): return self.port_mirroring
    def set_port_mirroring(self, port_mirroring): self.port_mirroring = port_mirroring
    def export(self, outfile, level, namespace_='', name_='NIC', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NIC')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NIC'):
        super(NIC, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NIC')
    def exportChildren(self, outfile, level, namespace_='', name_='NIC', fromsubclass_=False):
        super(NIC, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network')
        if self.interface is not None:
            showIndent(outfile, level)
            outfile.write('<%sinterface>%s</%sinterface>\n' % (namespace_, self.gds_format_string(quote_xml(self.interface).encode(ExternalEncoding), input_name='interface'), namespace_))
        if self.mac is not None:
            self.mac.export(outfile, level, namespace_, name_='mac')
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics')
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('<%sactive>%s</%sactive>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.active)), input_name='active'), namespace_))
        if self.port_mirroring is not None:
            self.port_mirroring.export(outfile, level, namespace_, name_='port_mirroring')
    def hasContent_(self):
        if (
            self.network is not None or
            self.interface is not None or
            self.mac is not None or
            self.statistics is not None or
            self.active is not None or
            self.port_mirroring is not None or
            super(NIC, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NIC'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NIC, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NIC, self).exportLiteralChildren(outfile, level, name_)
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.network(\n')
            self.network.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.interface is not None:
            showIndent(outfile, level)
            outfile.write('interface=%s,\n' % quote_python(self.interface).encode(ExternalEncoding))
        if self.mac is not None:
            showIndent(outfile, level)
            outfile.write('mac=model_.mac(\n')
            self.mac.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.port_mirroring is not None:
            showIndent(outfile, level)
            outfile.write('port_mirroring=model_.port_mirroring(\n')
            self.port_mirroring.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(NIC, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.set_network(obj_)
        elif nodeName_ == 'interface':
            interface_ = child_.text
            interface_ = self.gds_validate_string(interface_, node, 'interface')
            self.interface = interface_
        elif nodeName_ == 'mac':
            obj_ = MAC.factory()
            obj_.build(child_)
            self.set_mac(obj_)
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'port_mirroring':
            obj_ = PortMirroring.factory()
            obj_.build(child_)
            self.set_port_mirroring(obj_)
        super(NIC, self).buildChildren(child_, node, nodeName_, True)
# end class NIC


class Nics(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, nic=None):
        super(Nics, self).__init__(actions, total, active, )
        if nic is None:
            self.nic = []
        else:
            self.nic = nic
    def factory(*args_, **kwargs_):
        if Nics.subclass:
            return Nics.subclass(*args_, **kwargs_)
        else:
            return Nics(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nic(self): return self.nic
    def set_nic(self, nic): self.nic = nic
    def add_nic(self, value): self.nic.append(value)
    def insert_nic(self, index, value): self.nic[index] = value
    def export(self, outfile, level, namespace_='', name_='Nics', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Nics')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Nics'):
        super(Nics, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Nics')
    def exportChildren(self, outfile, level, namespace_='', name_='Nics', fromsubclass_=False):
        super(Nics, self).exportChildren(outfile, level, namespace_, name_, True)
        for nic_ in self.nic:
            nic_.export(outfile, level, namespace_, name_='nic')
    def hasContent_(self):
        if (
            self.nic or
            super(Nics, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Nics'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Nics, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Nics, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('nic=[\n')
        level += 1
        for nic_ in self.nic:
            showIndent(outfile, level)
            outfile.write('model_.nic(\n')
            nic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Nics, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nic':
            obj_ = NIC.factory()
            obj_.build(child_)
            self.nic.append(obj_)
        super(Nics, self).buildChildren(child_, node, nodeName_, True)
# end class Nics


class Snapshot(VM):
    subclass = None
    superclass = VM
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, type_=None, status=None, memory=None, cpu=None, os=None, high_availability=None, display=None, host=None, cluster=None, template=None, storage_domain=None, start_time=None, creation_time=None, origin=None, stateless=None, timezone=None, domain=None, custom_properties=None, payloads=None, statistics=None, disks=None, nics=None, tags=None, snapshots=None, placement_policy=None, memory_policy=None, guest_info=None, quota=None, usb=None, vmpool=None, cdroms=None, floppies=None, vm=None, date=None, snapshot_status=None):
        super(Snapshot, self).__init__(actions, href, id, name, description, creation_status, link, type_, status, memory, cpu, os, high_availability, display, host, cluster, template, storage_domain, start_time, creation_time, origin, stateless, timezone, domain, custom_properties, payloads, statistics, disks, nics, tags, snapshots, placement_policy, memory_policy, guest_info, quota, usb, vmpool, cdroms, floppies, )
        self.vm = vm
        self.date = date
        self.snapshot_status = snapshot_status
    def factory(*args_, **kwargs_):
        if Snapshot.subclass:
            return Snapshot.subclass(*args_, **kwargs_)
        else:
            return Snapshot(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_snapshot_status(self): return self.snapshot_status
    def set_snapshot_status(self, snapshot_status): self.snapshot_status = snapshot_status
    def export(self, outfile, level, namespace_='', name_='Snapshot', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshot')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Snapshot'):
        super(Snapshot, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshot')
    def exportChildren(self, outfile, level, namespace_='', name_='Snapshot', fromsubclass_=False):
        super(Snapshot, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('<%sdate>%s</%sdate>\n' % (namespace_, self.gds_format_string(quote_xml(self.date).encode(ExternalEncoding), input_name='date'), namespace_))
        if self.snapshot_status is not None:
            showIndent(outfile, level)
            outfile.write('<%ssnapshot_status>%s</%ssnapshot_status>\n' % (namespace_, self.gds_format_string(quote_xml(self.snapshot_status).encode(ExternalEncoding), input_name='snapshot_status'), namespace_))
    def hasContent_(self):
        if (
            self.vm is not None or
            self.date is not None or
            self.snapshot_status is not None or
            super(Snapshot, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Snapshot'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Snapshot, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Snapshot, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('date=%s,\n' % quote_python(self.date).encode(ExternalEncoding))
        if self.snapshot_status is not None:
            showIndent(outfile, level)
            outfile.write('snapshot_status=%s,\n' % quote_python(self.snapshot_status).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Snapshot, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'date':
            date_ = child_.text
            date_ = self.gds_validate_string(date_, node, 'date')
            self.date = date_
        elif nodeName_ == 'snapshot_status':
            snapshot_status_ = child_.text
            snapshot_status_ = self.gds_validate_string(snapshot_status_, node, 'snapshot_status')
            self.snapshot_status = snapshot_status_
        super(Snapshot, self).buildChildren(child_, node, nodeName_, True)
# end class Snapshot


class Snapshots(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, snapshot=None, collapse_snapshots=None):
        super(Snapshots, self).__init__(actions, total, active, )
        if snapshot is None:
            self.snapshot = []
        else:
            self.snapshot = snapshot
        self.collapse_snapshots = collapse_snapshots
    def factory(*args_, **kwargs_):
        if Snapshots.subclass:
            return Snapshots.subclass(*args_, **kwargs_)
        else:
            return Snapshots(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_snapshot(self): return self.snapshot
    def set_snapshot(self, snapshot): self.snapshot = snapshot
    def add_snapshot(self, value): self.snapshot.append(value)
    def insert_snapshot(self, index, value): self.snapshot[index] = value
    def get_collapse_snapshots(self): return self.collapse_snapshots
    def set_collapse_snapshots(self, collapse_snapshots): self.collapse_snapshots = collapse_snapshots
    def export(self, outfile, level, namespace_='', name_='Snapshots', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshots')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Snapshots'):
        super(Snapshots, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshots')
    def exportChildren(self, outfile, level, namespace_='', name_='Snapshots', fromsubclass_=False):
        super(Snapshots, self).exportChildren(outfile, level, namespace_, name_, True)
        for snapshot_ in self.snapshot:
            snapshot_.export(outfile, level, namespace_, name_='snapshot')
        if self.collapse_snapshots is not None:
            showIndent(outfile, level)
            outfile.write('<%scollapse_snapshots>%s</%scollapse_snapshots>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.collapse_snapshots)), input_name='collapse_snapshots'), namespace_))
    def hasContent_(self):
        if (
            self.snapshot or
            self.collapse_snapshots is not None or
            super(Snapshots, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Snapshots'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Snapshots, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Snapshots, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('snapshot=[\n')
        level += 1
        for snapshot_ in self.snapshot:
            showIndent(outfile, level)
            outfile.write('model_.snapshot(\n')
            snapshot_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.collapse_snapshots is not None:
            showIndent(outfile, level)
            outfile.write('collapse_snapshots=%s,\n' % self.collapse_snapshots)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Snapshots, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'snapshot':
            obj_ = Snapshot.factory()
            obj_.build(child_)
            self.snapshot.append(obj_)
        elif nodeName_ == 'collapse_snapshots':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'collapse_snapshots')
            self.collapse_snapshots = ival_
        super(Snapshots, self).buildChildren(child_, node, nodeName_, True)
# end class Snapshots


class HostNIC(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, host=None, network=None, mac=None, ip=None, vlan=None, bonding=None, boot_protocol=None, statistics=None, check_connectivity=None, speed=None, status=None, mtu=None, bridged=None, custom_configuration=None, override_configuration=None):
        super(HostNIC, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.host = host
        self.network = network
        self.mac = mac
        self.ip = ip
        self.vlan = vlan
        self.bonding = bonding
        self.boot_protocol = boot_protocol
        self.statistics = statistics
        self.check_connectivity = check_connectivity
        self.speed = speed
        self.status = status
        self.mtu = mtu
        self.bridged = bridged
        self.custom_configuration = custom_configuration
        self.override_configuration = override_configuration
    def factory(*args_, **kwargs_):
        if HostNIC.subclass:
            return HostNIC.subclass(*args_, **kwargs_)
        else:
            return HostNIC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_mac(self): return self.mac
    def set_mac(self, mac): self.mac = mac
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def get_vlan(self): return self.vlan
    def set_vlan(self, vlan): self.vlan = vlan
    def get_bonding(self): return self.bonding
    def set_bonding(self, bonding): self.bonding = bonding
    def get_boot_protocol(self): return self.boot_protocol
    def set_boot_protocol(self, boot_protocol): self.boot_protocol = boot_protocol
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_check_connectivity(self): return self.check_connectivity
    def set_check_connectivity(self, check_connectivity): self.check_connectivity = check_connectivity
    def get_speed(self): return self.speed
    def set_speed(self, speed): self.speed = speed
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_mtu(self): return self.mtu
    def set_mtu(self, mtu): self.mtu = mtu
    def get_bridged(self): return self.bridged
    def set_bridged(self, bridged): self.bridged = bridged
    def get_custom_configuration(self): return self.custom_configuration
    def set_custom_configuration(self, custom_configuration): self.custom_configuration = custom_configuration
    def get_override_configuration(self): return self.override_configuration
    def set_override_configuration(self, override_configuration): self.override_configuration = override_configuration
    def export(self, outfile, level, namespace_='', name_='HostNIC', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNIC')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNIC'):
        super(HostNIC, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HostNIC')
    def exportChildren(self, outfile, level, namespace_='', name_='HostNIC', fromsubclass_=False):
        super(HostNIC, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network')
        if self.mac is not None:
            self.mac.export(outfile, level, namespace_, name_='mac')
        if self.ip is not None:
            self.ip.export(outfile, level, namespace_, name_='ip')
        if self.vlan is not None:
            self.vlan.export(outfile, level, namespace_, name_='vlan')
        if self.bonding is not None:
            self.bonding.export(outfile, level, namespace_, name_='bonding')
        if self.boot_protocol is not None:
            showIndent(outfile, level)
            outfile.write('<%sboot_protocol>%s</%sboot_protocol>\n' % (namespace_, self.gds_format_string(quote_xml(self.boot_protocol).encode(ExternalEncoding), input_name='boot_protocol'), namespace_))
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics')
        if self.check_connectivity is not None:
            showIndent(outfile, level)
            outfile.write('<%scheck_connectivity>%s</%scheck_connectivity>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.check_connectivity)), input_name='check_connectivity'), namespace_))
        if self.speed is not None:
            showIndent(outfile, level)
            outfile.write('<%sspeed>%s</%sspeed>\n' % (namespace_, self.gds_format_integer(self.speed, input_name='speed'), namespace_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.mtu is not None:
            showIndent(outfile, level)
            outfile.write('<%smtu>%s</%smtu>\n' % (namespace_, self.gds_format_integer(self.mtu, input_name='mtu'), namespace_))
        if self.bridged is not None:
            showIndent(outfile, level)
            outfile.write('<%sbridged>%s</%sbridged>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.bridged)), input_name='bridged'), namespace_))
        if self.custom_configuration is not None:
            showIndent(outfile, level)
            outfile.write('<%scustom_configuration>%s</%scustom_configuration>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.custom_configuration)), input_name='custom_configuration'), namespace_))
        if self.override_configuration is not None:
            showIndent(outfile, level)
            outfile.write('<%soverride_configuration>%s</%soverride_configuration>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.override_configuration)), input_name='override_configuration'), namespace_))
    def hasContent_(self):
        if (
            self.host is not None or
            self.network is not None or
            self.mac is not None or
            self.ip is not None or
            self.vlan is not None or
            self.bonding is not None or
            self.boot_protocol is not None or
            self.statistics is not None or
            self.check_connectivity is not None or
            self.speed is not None or
            self.status is not None or
            self.mtu is not None or
            self.bridged is not None or
            self.custom_configuration is not None or
            self.override_configuration is not None or
            super(HostNIC, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HostNIC'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(HostNIC, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HostNIC, self).exportLiteralChildren(outfile, level, name_)
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.network(\n')
            self.network.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.mac is not None:
            showIndent(outfile, level)
            outfile.write('mac=model_.mac(\n')
            self.mac.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ip is not None:
            showIndent(outfile, level)
            outfile.write('ip=model_.ip(\n')
            self.ip.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vlan is not None:
            showIndent(outfile, level)
            outfile.write('vlan=model_.vlan(\n')
            self.vlan.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.bonding is not None:
            showIndent(outfile, level)
            outfile.write('bonding=model_.bonding(\n')
            self.bonding.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.boot_protocol is not None:
            showIndent(outfile, level)
            outfile.write('boot_protocol=%s,\n' % quote_python(self.boot_protocol).encode(ExternalEncoding))
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.check_connectivity is not None:
            showIndent(outfile, level)
            outfile.write('check_connectivity=%s,\n' % self.check_connectivity)
        if self.speed is not None:
            showIndent(outfile, level)
            outfile.write('speed=%d,\n' % self.speed)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.mtu is not None:
            showIndent(outfile, level)
            outfile.write('mtu=%d,\n' % self.mtu)
        if self.bridged is not None:
            showIndent(outfile, level)
            outfile.write('bridged=%s,\n' % self.bridged)
        if self.custom_configuration is not None:
            showIndent(outfile, level)
            outfile.write('custom_configuration=%s,\n' % self.custom_configuration)
        if self.override_configuration is not None:
            showIndent(outfile, level)
            outfile.write('override_configuration=%s,\n' % self.override_configuration)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(HostNIC, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.set_network(obj_)
        elif nodeName_ == 'mac':
            obj_ = MAC.factory()
            obj_.build(child_)
            self.set_mac(obj_)
        elif nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.set_ip(obj_)
        elif nodeName_ == 'vlan':
            obj_ = VLAN.factory()
            obj_.build(child_)
            self.set_vlan(obj_)
        elif nodeName_ == 'bonding':
            obj_ = Bonding.factory()
            obj_.build(child_)
            self.set_bonding(obj_)
        elif nodeName_ == 'boot_protocol':
            boot_protocol_ = child_.text
            boot_protocol_ = self.gds_validate_string(boot_protocol_, node, 'boot_protocol')
            self.boot_protocol = boot_protocol_
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'check_connectivity':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'check_connectivity')
            self.check_connectivity = ival_
        elif nodeName_ == 'speed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'speed')
            self.speed = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'mtu':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'mtu')
            self.mtu = ival_
        elif nodeName_ == 'bridged':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'bridged')
            self.bridged = ival_
        elif nodeName_ == 'custom_configuration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'custom_configuration')
            self.custom_configuration = ival_
        elif nodeName_ == 'override_configuration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_configuration')
            self.override_configuration = ival_
        super(HostNIC, self).buildChildren(child_, node, nodeName_, True)
# end class HostNIC


class HostNics(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, host_nic=None):
        super(HostNics, self).__init__(actions, total, active, )
        if host_nic is None:
            self.host_nic = []
        else:
            self.host_nic = host_nic
    def factory(*args_, **kwargs_):
        if HostNics.subclass:
            return HostNics.subclass(*args_, **kwargs_)
        else:
            return HostNics(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_nic(self): return self.host_nic
    def set_host_nic(self, host_nic): self.host_nic = host_nic
    def add_host_nic(self, value): self.host_nic.append(value)
    def insert_host_nic(self, index, value): self.host_nic[index] = value
    def export(self, outfile, level, namespace_='', name_='HostNics', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNics')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNics'):
        super(HostNics, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HostNics')
    def exportChildren(self, outfile, level, namespace_='', name_='HostNics', fromsubclass_=False):
        super(HostNics, self).exportChildren(outfile, level, namespace_, name_, True)
        for host_nic_ in self.host_nic:
            host_nic_.export(outfile, level, namespace_, name_='host_nic')
    def hasContent_(self):
        if (
            self.host_nic or
            super(HostNics, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HostNics'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(HostNics, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HostNics, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('host_nic=[\n')
        level += 1
        for host_nic_ in self.host_nic:
            showIndent(outfile, level)
            outfile.write('model_.host_nic(\n')
            host_nic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(HostNics, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_nic':
            obj_ = HostNIC.factory()
            obj_.build(child_)
            self.host_nic.append(obj_)
        super(HostNics, self).buildChildren(child_, node, nodeName_, True)
# end class HostNics


class HostNICStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_nic_state=None):
        if host_nic_state is None:
            self.host_nic_state = []
        else:
            self.host_nic_state = host_nic_state
    def factory(*args_, **kwargs_):
        if HostNICStates.subclass:
            return HostNICStates.subclass(*args_, **kwargs_)
        else:
            return HostNICStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_nic_state(self): return self.host_nic_state
    def set_host_nic_state(self, host_nic_state): self.host_nic_state = host_nic_state
    def add_host_nic_state(self, value): self.host_nic_state.append(value)
    def insert_host_nic_state(self, index, value): self.host_nic_state[index] = value
    def export(self, outfile, level, namespace_='', name_='HostNICStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNICStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNICStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostNICStates', fromsubclass_=False):
        for host_nic_state_ in self.host_nic_state:
            showIndent(outfile, level)
            outfile.write('<%shost_nic_state>%s</%shost_nic_state>\n' % (namespace_, self.gds_format_string(quote_xml(host_nic_state_).encode(ExternalEncoding), input_name='host_nic_state'), namespace_))
    def hasContent_(self):
        if (
            self.host_nic_state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HostNICStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_nic_state=[\n')
        level += 1
        for host_nic_state_ in self.host_nic_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_nic_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_nic_state':
            host_nic_state_ = child_.text
            host_nic_state_ = self.gds_validate_string(host_nic_state_, node, 'host_nic_state')
            self.host_nic_state.append(host_nic_state_)
# end class HostNICStates


class Slaves(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_nic=None):
        if host_nic is None:
            self.host_nic = []
        else:
            self.host_nic = host_nic
    def factory(*args_, **kwargs_):
        if Slaves.subclass:
            return Slaves.subclass(*args_, **kwargs_)
        else:
            return Slaves(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_nic(self): return self.host_nic
    def set_host_nic(self, host_nic): self.host_nic = host_nic
    def add_host_nic(self, value): self.host_nic.append(value)
    def insert_host_nic(self, index, value): self.host_nic[index] = value
    def export(self, outfile, level, namespace_='', name_='Slaves', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Slaves')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Slaves'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Slaves', fromsubclass_=False):
        for host_nic_ in self.host_nic:
            host_nic_.export(outfile, level, namespace_, name_='host_nic')
    def hasContent_(self):
        if (
            self.host_nic
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Slaves'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_nic=[\n')
        level += 1
        for host_nic_ in self.host_nic:
            showIndent(outfile, level)
            outfile.write('model_.host_nic(\n')
            host_nic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_nic':
            obj_ = HostNIC.factory()
            obj_.build(child_)
            self.host_nic.append(obj_)
# end class Slaves


class Bonding(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, options=None, slaves=None):
        self.options = options
        self.slaves = slaves
    def factory(*args_, **kwargs_):
        if Bonding.subclass:
            return Bonding.subclass(*args_, **kwargs_)
        else:
            return Bonding(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_slaves(self): return self.slaves
    def set_slaves(self, slaves): self.slaves = slaves
    def export(self, outfile, level, namespace_='', name_='Bonding', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Bonding')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Bonding'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Bonding', fromsubclass_=False):
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options')
        if self.slaves is not None:
            self.slaves.export(outfile, level, namespace_, name_='slaves')
    def hasContent_(self):
        if (
            self.options is not None or
            self.slaves is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Bonding'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.options(\n')
            self.options.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.slaves is not None:
            showIndent(outfile, level)
            outfile.write('slaves=model_.slaves(\n')
            self.slaves.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.set_options(obj_)
        elif nodeName_ == 'slaves':
            obj_ = Slaves.factory()
            obj_.build(child_)
            self.set_slaves(obj_)
# end class Bonding


class HostStorage(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, storage=None):
        super(HostStorage, self).__init__(actions, total, active, )
        if storage is None:
            self.storage = []
        else:
            self.storage = storage
    def factory(*args_, **kwargs_):
        if HostStorage.subclass:
            return HostStorage.subclass(*args_, **kwargs_)
        else:
            return HostStorage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage(self): return self.storage
    def set_storage(self, storage): self.storage = storage
    def add_storage(self, value): self.storage.append(value)
    def insert_storage(self, index, value): self.storage[index] = value
    def export(self, outfile, level, namespace_='', name_='HostStorage', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostStorage')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostStorage'):
        super(HostStorage, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HostStorage')
    def exportChildren(self, outfile, level, namespace_='', name_='HostStorage', fromsubclass_=False):
        super(HostStorage, self).exportChildren(outfile, level, namespace_, name_, True)
        for storage_ in self.storage:
            storage_.export(outfile, level, namespace_, name_='storage')
    def hasContent_(self):
        if (
            self.storage or
            super(HostStorage, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HostStorage'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(HostStorage, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HostStorage, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('storage=[\n')
        level += 1
        for storage_ in self.storage:
            showIndent(outfile, level)
            outfile.write('model_.storage(\n')
            storage_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(HostStorage, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage':
            obj_ = Storage.factory()
            obj_.build(child_)
            self.storage.append(obj_)
        super(HostStorage, self).buildChildren(child_, node, nodeName_, True)
# end class HostStorage


class TagParent(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, tag=None):
        self.tag = tag
    def factory(*args_, **kwargs_):
        if TagParent.subclass:
            return TagParent.subclass(*args_, **kwargs_)
        else:
            return TagParent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def export(self, outfile, level, namespace_='', name_='TagParent', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TagParent')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TagParent'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TagParent', fromsubclass_=False):
        if self.tag is not None:
            self.tag.export(outfile, level, namespace_, name_='tag')
    def hasContent_(self):
        if (
            self.tag is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TagParent'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.tag is not None:
            showIndent(outfile, level)
            outfile.write('tag=model_.tag(\n')
            self.tag.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tag':
            obj_ = Tag.factory()
            obj_.build(child_)
            self.set_tag(obj_)
# end class TagParent


class Tag(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, host=None, vm=None, user=None, group=None, parent=None):
        super(Tag, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.host = host
        self.vm = vm
        self.user = user
        self.group = group
        self.parent = parent
    def factory(*args_, **kwargs_):
        if Tag.subclass:
            return Tag.subclass(*args_, **kwargs_)
        else:
            return Tag(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def get_parent(self): return self.parent
    def set_parent(self, parent): self.parent = parent
    def export(self, outfile, level, namespace_='', name_='Tag', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Tag')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Tag'):
        super(Tag, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Tag')
    def exportChildren(self, outfile, level, namespace_='', name_='Tag', fromsubclass_=False):
        super(Tag, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user')
        if self.group is not None:
            self.group.export(outfile, level, namespace_, name_='group')
        if self.parent is not None:
            self.parent.export(outfile, level, namespace_, name_='parent')
    def hasContent_(self):
        if (
            self.host is not None or
            self.vm is not None or
            self.user is not None or
            self.group is not None or
            self.parent is not None or
            super(Tag, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Tag'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Tag, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Tag, self).exportLiteralChildren(outfile, level, name_)
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.group is not None:
            showIndent(outfile, level)
            outfile.write('group=model_.group(\n')
            self.group.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.parent is not None:
            showIndent(outfile, level)
            outfile.write('parent=model_.TagParent(\n')
            self.parent.exportLiteral(outfile, level, name_='parent')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Tag, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.set_group(obj_)
        elif nodeName_ == 'parent':
            obj_ = TagParent.factory()
            obj_.build(child_)
            self.set_parent(obj_)
        super(Tag, self).buildChildren(child_, node, nodeName_, True)
# end class Tag


class Tags(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, tag=None):
        super(Tags, self).__init__(actions, total, active, )
        if tag is None:
            self.tag = []
        else:
            self.tag = tag
    def factory(*args_, **kwargs_):
        if Tags.subclass:
            return Tags.subclass(*args_, **kwargs_)
        else:
            return Tags(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def add_tag(self, value): self.tag.append(value)
    def insert_tag(self, index, value): self.tag[index] = value
    def export(self, outfile, level, namespace_='', name_='Tags', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Tags')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Tags'):
        super(Tags, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Tags')
    def exportChildren(self, outfile, level, namespace_='', name_='Tags', fromsubclass_=False):
        super(Tags, self).exportChildren(outfile, level, namespace_, name_, True)
        for tag_ in self.tag:
            tag_.export(outfile, level, namespace_, name_='tag')
    def hasContent_(self):
        if (
            self.tag or
            super(Tags, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Tags'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Tags, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Tags, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('tag=[\n')
        level += 1
        for tag_ in self.tag:
            showIndent(outfile, level)
            outfile.write('model_.tag(\n')
            tag_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Tags, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tag':
            obj_ = Tag.factory()
            obj_.build(child_)
            self.tag.append(obj_)
        super(Tags, self).buildChildren(child_, node, nodeName_, True)
# end class Tags


class Usb(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None, type_=None):
        self.enabled = enabled
        self.type_ = type_
    def factory(*args_, **kwargs_):
        if Usb.subclass:
            return Usb.subclass(*args_, **kwargs_)
        else:
            return Usb(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='', name_='Usb', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Usb')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Usb'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Usb', fromsubclass_=False):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('<%senabled>%s</%senabled>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.enabled)), input_name='enabled'), namespace_))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.type_ is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Usb'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
# end class Usb


class Quota(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, data_center=None, vms=None, disks=None, users=None):
        super(Quota, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.data_center = data_center
        self.vms = vms
        self.disks = disks
        self.users = users
    def factory(*args_, **kwargs_):
        if Quota.subclass:
            return Quota.subclass(*args_, **kwargs_)
        else:
            return Quota(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_vms(self): return self.vms
    def set_vms(self, vms): self.vms = vms
    def get_disks(self): return self.disks
    def set_disks(self, disks): self.disks = disks
    def get_users(self): return self.users
    def set_users(self, users): self.users = users
    def export(self, outfile, level, namespace_='', name_='Quota', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Quota')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Quota'):
        super(Quota, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Quota')
    def exportChildren(self, outfile, level, namespace_='', name_='Quota', fromsubclass_=False):
        super(Quota, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center')
        if self.vms is not None:
            self.vms.export(outfile, level, namespace_, name_='vms')
        if self.disks is not None:
            self.disks.export(outfile, level, namespace_, name_='disks')
        if self.users is not None:
            self.users.export(outfile, level, namespace_, name_='users')
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.vms is not None or
            self.disks is not None or
            self.users is not None or
            super(Quota, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Quota'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Quota, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Quota, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vms is not None:
            showIndent(outfile, level)
            outfile.write('vms=model_.vms(\n')
            self.vms.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disks is not None:
            showIndent(outfile, level)
            outfile.write('disks=model_.disks(\n')
            self.disks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.users is not None:
            showIndent(outfile, level)
            outfile.write('users=model_.users(\n')
            self.users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Quota, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'vms':
            obj_ = VMs.factory()
            obj_.build(child_)
            self.set_vms(obj_)
        elif nodeName_ == 'disks':
            obj_ = Disks.factory()
            obj_.build(child_)
            self.set_disks(obj_)
        elif nodeName_ == 'users':
            obj_ = Users.factory()
            obj_.build(child_)
            self.set_users(obj_)
        super(Quota, self).buildChildren(child_, node, nodeName_, True)
# end class Quota


class Quotas(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, quota=None):
        super(Quotas, self).__init__(actions, total, active, )
        if quota is None:
            self.quota = []
        else:
            self.quota = quota
    def factory(*args_, **kwargs_):
        if Quotas.subclass:
            return Quotas.subclass(*args_, **kwargs_)
        else:
            return Quotas(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_quota(self): return self.quota
    def set_quota(self, quota): self.quota = quota
    def add_quota(self, value): self.quota.append(value)
    def insert_quota(self, index, value): self.quota[index] = value
    def export(self, outfile, level, namespace_='', name_='Quotas', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Quotas')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Quotas'):
        super(Quotas, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Quotas')
    def exportChildren(self, outfile, level, namespace_='', name_='Quotas', fromsubclass_=False):
        super(Quotas, self).exportChildren(outfile, level, namespace_, name_, True)
        for quota_ in self.quota:
            quota_.export(outfile, level, namespace_, name_='quota')
    def hasContent_(self):
        if (
            self.quota or
            super(Quotas, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Quotas'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Quotas, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Quotas, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('quota=[\n')
        level += 1
        for quota_ in self.quota:
            showIndent(outfile, level)
            outfile.write('model_.quota(\n')
            quota_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Quotas, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'quota':
            obj_ = Quota.factory()
            obj_.build(child_)
            self.quota.append(obj_)
        super(Quotas, self).buildChildren(child_, node, nodeName_, True)
# end class Quotas


class Url(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, parameters_set=None):
        if parameters_set is None:
            self.parameters_set = []
        else:
            self.parameters_set = parameters_set
    def factory(*args_, **kwargs_):
        if Url.subclass:
            return Url.subclass(*args_, **kwargs_)
        else:
            return Url(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_parameters_set(self): return self.parameters_set
    def set_parameters_set(self, parameters_set): self.parameters_set = parameters_set
    def add_parameters_set(self, value): self.parameters_set.append(value)
    def insert_parameters_set(self, index, value): self.parameters_set[index] = value
    def export(self, outfile, level, namespace_='', name_='Url', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Url')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Url'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Url', fromsubclass_=False):
        for parameters_set_ in self.parameters_set:
            parameters_set_.export(outfile, level, namespace_, name_='parameters_set')
    def hasContent_(self):
        if (
            self.parameters_set
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Url'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('parameters_set=[\n')
        level += 1
        for parameters_set_ in self.parameters_set:
            showIndent(outfile, level)
            outfile.write('model_.parameters_set(\n')
            parameters_set_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parameters_set':
            obj_ = ParametersSet.factory()
            obj_.build(child_)
            self.parameters_set.append(obj_)
# end class Url


class Body(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, required=None, type_=None, parameters_set=None):
        self.required = _cast(bool, required)
        self.type_ = type_
        if parameters_set is None:
            self.parameters_set = []
        else:
            self.parameters_set = parameters_set
    def factory(*args_, **kwargs_):
        if Body.subclass:
            return Body.subclass(*args_, **kwargs_)
        else:
            return Body(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_parameters_set(self): return self.parameters_set
    def set_parameters_set(self, parameters_set): self.parameters_set = parameters_set
    def add_parameters_set(self, value): self.parameters_set.append(value)
    def insert_parameters_set(self, index, value): self.parameters_set[index] = value
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def export(self, outfile, level, namespace_='', name_='Body', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Body')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Body'):
        if self.required is not None and 'required' not in already_processed:
            already_processed.append('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.required)), input_name='required'))
    def exportChildren(self, outfile, level, namespace_='', name_='Body', fromsubclass_=False):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        for parameters_set_ in self.parameters_set:
            parameters_set_.export(outfile, level, namespace_, name_='parameters_set')
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.parameters_set
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Body'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.append('required')
            showIndent(outfile, level)
            outfile.write('required = %s,\n' % (self.required,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('parameters_set=[\n')
        level += 1
        for parameters_set_ in self.parameters_set:
            showIndent(outfile, level)
            outfile.write('model_.parameters_set(\n')
            parameters_set_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.append('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'parameters_set':
            obj_ = ParametersSet.factory()
            obj_.build(child_)
            self.parameters_set.append(obj_)
# end class Body


class Request(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, http_method=None, headers=None, url=None, body=None):
        self.http_method = http_method
        self.headers = headers
        self.url = url
        self.body = body
    def factory(*args_, **kwargs_):
        if Request.subclass:
            return Request.subclass(*args_, **kwargs_)
        else:
            return Request(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_http_method(self): return self.http_method
    def set_http_method(self, http_method): self.http_method = http_method
    def validate_HttpMethod(self, value):
        # Validate type HttpMethod, a restriction on xs:string.
        pass
    def get_headers(self): return self.headers
    def set_headers(self, headers): self.headers = headers
    def get_url(self): return self.url
    def set_url(self, url): self.url = url
    def get_body(self): return self.body
    def set_body(self, body): self.body = body
    def export(self, outfile, level, namespace_='', name_='Request', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Request')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Request'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Request', fromsubclass_=False):
        if self.http_method is not None:
            showIndent(outfile, level)
            outfile.write('<%shttp_method>%s</%shttp_method>\n' % (namespace_, self.gds_format_string(quote_xml(self.http_method).encode(ExternalEncoding), input_name='http_method'), namespace_))
        if self.headers is not None:
            self.headers.export(outfile, level, namespace_, name_='headers')
        if self.url is not None:
            self.url.export(outfile, level, namespace_, name_='url')
        if self.body is not None:
            self.body.export(outfile, level, namespace_, name_='body')
    def hasContent_(self):
        if (
            self.http_method is not None or
            self.headers is not None or
            self.url is not None or
            self.body is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Request'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.http_method is not None:
            showIndent(outfile, level)
            outfile.write('http_method=%s,\n' % quote_python(self.http_method).encode(ExternalEncoding))
        if self.headers is not None:
            showIndent(outfile, level)
            outfile.write('headers=model_.headers(\n')
            self.headers.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.url is not None:
            showIndent(outfile, level)
            outfile.write('url=model_.url(\n')
            self.url.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.body is not None:
            showIndent(outfile, level)
            outfile.write('body=model_.body(\n')
            self.body.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'http_method':
            http_method_ = child_.text
            http_method_ = self.gds_validate_string(http_method_, node, 'http_method')
            self.http_method = http_method_
            self.validate_HttpMethod(self.http_method)    # validate type HttpMethod
        elif nodeName_ == 'headers':
            obj_ = Headers.factory()
            obj_.build(child_)
            self.set_headers(obj_)
        elif nodeName_ == 'url':
            obj_ = Url.factory()
            obj_.build(child_)
            self.set_url(obj_)
        elif nodeName_ == 'body':
            obj_ = Body.factory()
            obj_.build(child_)
            self.set_body(obj_)
# end class Request


class Response(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None):
        self.type_ = type_
    def factory(*args_, **kwargs_):
        if Response.subclass:
            return Response.subclass(*args_, **kwargs_)
        else:
            return Response(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='', name_='Response', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Response')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Response'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Response', fromsubclass_=False):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
    def hasContent_(self):
        if (
            self.type_ is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Response'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
# end class Response


class Parameter(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, required=None, type_=None, context=None, value=None, parameters_set=None):
        super(Parameter, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.required = _cast(bool, required)
        self.type_ = _cast(None, type_)
        self.context = _cast(None, context)
        self.value = value
        self.parameters_set = parameters_set
    def factory(*args_, **kwargs_):
        if Parameter.subclass:
            return Parameter.subclass(*args_, **kwargs_)
        else:
            return Parameter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_parameters_set(self): return self.parameters_set
    def set_parameters_set(self, parameters_set): self.parameters_set = parameters_set
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_context(self): return self.context
    def set_context(self, context): self.context = context
    def export(self, outfile, level, namespace_='', name_='Parameter', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Parameter')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Parameter'):
        super(Parameter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Parameter')
        if self.required is not None and 'required' not in already_processed:
            already_processed.append('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.required)), input_name='required'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.context is not None and 'context' not in already_processed:
            already_processed.append('context')
            outfile.write(' context=%s' % (self.gds_format_string(quote_attrib(self.context).encode(ExternalEncoding), input_name='context'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Parameter', fromsubclass_=False):
        super(Parameter, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
        if self.parameters_set is not None:
            self.parameters_set.export(outfile, level, namespace_, name_='parameters_set')
    def hasContent_(self):
        if (
            self.value is not None or
            self.parameters_set is not None or
            super(Parameter, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Parameter'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.append('required')
            showIndent(outfile, level)
            outfile.write('required = %s,\n' % (self.required,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.context is not None and 'context' not in already_processed:
            already_processed.append('context')
            showIndent(outfile, level)
            outfile.write('context = "%s",\n' % (self.context,))
        super(Parameter, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Parameter, self).exportLiteralChildren(outfile, level, name_)
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
        if self.parameters_set is not None:
            showIndent(outfile, level)
            outfile.write('parameters_set=model_.parameters_set(\n')
            self.parameters_set.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.append('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('context', node)
        if value is not None and 'context' not in already_processed:
            already_processed.append('context')
            self.context = value
        super(Parameter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'parameters_set':
            obj_ = ParametersSet.factory()
            obj_.build(child_)
            self.set_parameters_set(obj_)
        super(Parameter, self).buildChildren(child_, node, nodeName_, True)
# end class Parameter


class Header(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, required=None, value=None):
        super(Header, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.required = _cast(bool, required)
        self.value = value
    def factory(*args_, **kwargs_):
        if Header.subclass:
            return Header.subclass(*args_, **kwargs_)
        else:
            return Header(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def export(self, outfile, level, namespace_='', name_='Header', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Header')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Header'):
        super(Header, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Header')
        if self.required is not None and 'required' not in already_processed:
            already_processed.append('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.required)), input_name='required'))
    def exportChildren(self, outfile, level, namespace_='', name_='Header', fromsubclass_=False):
        super(Header, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
    def hasContent_(self):
        if (
            self.value is not None or
            super(Header, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Header'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.append('required')
            showIndent(outfile, level)
            outfile.write('required = %s,\n' % (self.required,))
        super(Header, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Header, self).exportLiteralChildren(outfile, level, name_)
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.append('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(Header, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        super(Header, self).buildChildren(child_, node, nodeName_, True)
# end class Header


class Headers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, header=None):
        if header is None:
            self.header = []
        else:
            self.header = header
    def factory(*args_, **kwargs_):
        if Headers.subclass:
            return Headers.subclass(*args_, **kwargs_)
        else:
            return Headers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_header(self): return self.header
    def set_header(self, header): self.header = header
    def add_header(self, value): self.header.append(value)
    def insert_header(self, index, value): self.header[index] = value
    def export(self, outfile, level, namespace_='', name_='Headers', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Headers')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Headers'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Headers', fromsubclass_=False):
        for header_ in self.header:
            header_.export(outfile, level, namespace_, name_='header')
    def hasContent_(self):
        if (
            self.header
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Headers'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('header=[\n')
        level += 1
        for header_ in self.header:
            showIndent(outfile, level)
            outfile.write('model_.header(\n')
            header_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'header':
            obj_ = Header.factory()
            obj_.build(child_)
            self.header.append(obj_)
# end class Headers


class ParametersSet(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, parameter=None):
        if parameter is None:
            self.parameter = []
        else:
            self.parameter = parameter
    def factory(*args_, **kwargs_):
        if ParametersSet.subclass:
            return ParametersSet.subclass(*args_, **kwargs_)
        else:
            return ParametersSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_parameter(self): return self.parameter
    def set_parameter(self, parameter): self.parameter = parameter
    def add_parameter(self, value): self.parameter.append(value)
    def insert_parameter(self, index, value): self.parameter[index] = value
    def export(self, outfile, level, namespace_='', name_='ParametersSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ParametersSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ParametersSet'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ParametersSet', fromsubclass_=False):
        for parameter_ in self.parameter:
            parameter_.export(outfile, level, namespace_, name_='parameter')
    def hasContent_(self):
        if (
            self.parameter
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ParametersSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('parameter=[\n')
        level += 1
        for parameter_ in self.parameter:
            showIndent(outfile, level)
            outfile.write('model_.parameter(\n')
            parameter_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parameter':
            obj_ = Parameter.factory()
            obj_.build(child_)
            self.parameter.append(obj_)
# end class ParametersSet


class Schema(Link):
    subclass = None
    superclass = Link
    def __init__(self, href=None, rel=None, name=None, description=None):
        super(Schema, self).__init__(href, rel, )
        self.name = name
        self.description = description
    def factory(*args_, **kwargs_):
        if Schema.subclass:
            return Schema.subclass(*args_, **kwargs_)
        else:
            return Schema(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def export(self, outfile, level, namespace_='', name_='Schema', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Schema')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Schema'):
        super(Schema, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Schema')
    def exportChildren(self, outfile, level, namespace_='', name_='Schema', fromsubclass_=False):
        super(Schema, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            super(Schema, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Schema'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Schema, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Schema, self).exportLiteralChildren(outfile, level, name_)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Schema, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        super(Schema, self).buildChildren(child_, node, nodeName_, True)
# end class Schema


class RSDL(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, href=None, rel=None, description=None, version=None, schema=None, links=None):
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
        self.description = description
        self.version = version
        self.schema = schema
        self.links = links
    def factory(*args_, **kwargs_):
        if RSDL.subclass:
            return RSDL.subclass(*args_, **kwargs_)
        else:
            return RSDL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_schema(self): return self.schema
    def set_schema(self, schema): self.schema = schema
    def get_links(self): return self.links
    def set_links(self, links): self.links = links
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def export(self, outfile, level, namespace_='', name_='RSDL', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RSDL')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RSDL'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RSDL', fromsubclass_=False):
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version')
        if self.schema is not None:
            self.schema.export(outfile, level, namespace_, name_='schema')
        if self.links is not None:
            self.links.export(outfile, level, namespace_, name_='links')
    def hasContent_(self):
        if (
            self.description is not None or
            self.version is not None or
            self.schema is not None or
            self.links is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RSDL'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            showIndent(outfile, level)
            outfile.write('href = "%s",\n' % (self.href,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            showIndent(outfile, level)
            outfile.write('rel = "%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.schema is not None:
            showIndent(outfile, level)
            outfile.write('schema=model_.schema(\n')
            self.schema.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.links is not None:
            showIndent(outfile, level)
            outfile.write('links=model_.DetailedLinks(\n')
            self.links.exportLiteral(outfile, level, name_='links')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.append('href')
            self.href = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            self.rel = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        elif nodeName_ == 'schema':
            obj_ = Schema.factory()
            obj_.build(child_)
            self.set_schema(obj_)
        elif nodeName_ == 'links':
            obj_ = DetailedLinks.factory()
            obj_.build(child_)
            self.set_links(obj_)
# end class RSDL


class GlusterVolume(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, cluster=None, volume_type=None, transport_types=None, replica_count=None, stripe_count=None, bricks=None, access_protocols=None, access_control_list=None, options=None, state=None):
        super(GlusterVolume, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.cluster = cluster
        self.volume_type = volume_type
        self.transport_types = transport_types
        self.replica_count = replica_count
        self.stripe_count = stripe_count
        self.bricks = bricks
        self.access_protocols = access_protocols
        self.access_control_list = access_control_list
        self.options = options
        self.state = state
    def factory(*args_, **kwargs_):
        if GlusterVolume.subclass:
            return GlusterVolume.subclass(*args_, **kwargs_)
        else:
            return GlusterVolume(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_volume_type(self): return self.volume_type
    def set_volume_type(self, volume_type): self.volume_type = volume_type
    def get_transport_types(self): return self.transport_types
    def set_transport_types(self, transport_types): self.transport_types = transport_types
    def get_replica_count(self): return self.replica_count
    def set_replica_count(self, replica_count): self.replica_count = replica_count
    def get_stripe_count(self): return self.stripe_count
    def set_stripe_count(self, stripe_count): self.stripe_count = stripe_count
    def get_bricks(self): return self.bricks
    def set_bricks(self, bricks): self.bricks = bricks
    def get_access_protocols(self): return self.access_protocols
    def set_access_protocols(self, access_protocols): self.access_protocols = access_protocols
    def get_access_control_list(self): return self.access_control_list
    def set_access_control_list(self, access_control_list): self.access_control_list = access_control_list
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='GlusterVolume', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterVolume')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GlusterVolume'):
        super(GlusterVolume, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterVolume')
    def exportChildren(self, outfile, level, namespace_='', name_='GlusterVolume', fromsubclass_=False):
        super(GlusterVolume, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.volume_type is not None:
            showIndent(outfile, level)
            outfile.write('<%svolume_type>%s</%svolume_type>\n' % (namespace_, self.gds_format_string(quote_xml(self.volume_type).encode(ExternalEncoding), input_name='volume_type'), namespace_))
        if self.transport_types is not None:
            self.transport_types.export(outfile, level, namespace_, name_='transport_types')
        if self.replica_count is not None:
            showIndent(outfile, level)
            outfile.write('<%sreplica_count>%s</%sreplica_count>\n' % (namespace_, self.gds_format_integer(self.replica_count, input_name='replica_count'), namespace_))
        if self.stripe_count is not None:
            showIndent(outfile, level)
            outfile.write('<%sstripe_count>%s</%sstripe_count>\n' % (namespace_, self.gds_format_integer(self.stripe_count, input_name='stripe_count'), namespace_))
        if self.bricks is not None:
            self.bricks.export(outfile, level, namespace_, name_='bricks')
        if self.access_protocols is not None:
            self.access_protocols.export(outfile, level, namespace_, name_='access_protocols')
        if self.access_control_list is not None:
            self.access_control_list.export(outfile, level, namespace_, name_='access_control_list')
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options')
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('<%sstate>%s</%sstate>\n' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_))
    def hasContent_(self):
        if (
            self.cluster is not None or
            self.volume_type is not None or
            self.transport_types is not None or
            self.replica_count is not None or
            self.stripe_count is not None or
            self.bricks is not None or
            self.access_protocols is not None or
            self.access_control_list is not None or
            self.options is not None or
            self.state is not None or
            super(GlusterVolume, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GlusterVolume'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GlusterVolume, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GlusterVolume, self).exportLiteralChildren(outfile, level, name_)
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.volume_type is not None:
            showIndent(outfile, level)
            outfile.write('volume_type=%s,\n' % quote_python(self.volume_type).encode(ExternalEncoding))
        if self.transport_types is not None:
            showIndent(outfile, level)
            outfile.write('transport_types=model_.transport_types(\n')
            self.transport_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.replica_count is not None:
            showIndent(outfile, level)
            outfile.write('replica_count=%d,\n' % self.replica_count)
        if self.stripe_count is not None:
            showIndent(outfile, level)
            outfile.write('stripe_count=%d,\n' % self.stripe_count)
        if self.bricks is not None:
            showIndent(outfile, level)
            outfile.write('bricks=model_.bricks(\n')
            self.bricks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.access_protocols is not None:
            showIndent(outfile, level)
            outfile.write('access_protocols=model_.access_protocols(\n')
            self.access_protocols.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.access_control_list is not None:
            showIndent(outfile, level)
            outfile.write('access_control_list=model_.access_control_list(\n')
            self.access_control_list.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.options(\n')
            self.options.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(GlusterVolume, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'volume_type':
            volume_type_ = child_.text
            volume_type_ = self.gds_validate_string(volume_type_, node, 'volume_type')
            self.volume_type = volume_type_
        elif nodeName_ == 'transport_types':
            obj_ = TransportTypes.factory()
            obj_.build(child_)
            self.set_transport_types(obj_)
        elif nodeName_ == 'replica_count':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'replica_count')
            self.replica_count = ival_
        elif nodeName_ == 'stripe_count':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'stripe_count')
            self.stripe_count = ival_
        elif nodeName_ == 'bricks':
            obj_ = GlusterBricks.factory()
            obj_.build(child_)
            self.set_bricks(obj_)
        elif nodeName_ == 'access_protocols':
            obj_ = AccessProtocols.factory()
            obj_.build(child_)
            self.set_access_protocols(obj_)
        elif nodeName_ == 'access_control_list':
            obj_ = AccessControlList.factory()
            obj_.build(child_)
            self.set_access_control_list(obj_)
        elif nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.set_options(obj_)
        elif nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
        super(GlusterVolume, self).buildChildren(child_, node, nodeName_, True)
# end class GlusterVolume


class AccessControlList(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ip=None):
        if ip is None:
            self.ip = []
        else:
            self.ip = ip
    def factory(*args_, **kwargs_):
        if AccessControlList.subclass:
            return AccessControlList.subclass(*args_, **kwargs_)
        else:
            return AccessControlList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def add_ip(self, value): self.ip.append(value)
    def insert_ip(self, index, value): self.ip[index] = value
    def export(self, outfile, level, namespace_='', name_='AccessControlList', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessControlList')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessControlList'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='AccessControlList', fromsubclass_=False):
        for ip_ in self.ip:
            showIndent(outfile, level)
            outfile.write('<%sip>%s</%sip>\n' % (namespace_, self.gds_format_string(quote_xml(ip_).encode(ExternalEncoding), input_name='ip'), namespace_))
    def hasContent_(self):
        if (
            self.ip
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AccessControlList'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('ip=[\n')
        level += 1
        for ip_ in self.ip:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(ip_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ip':
            ip_ = child_.text
            ip_ = self.gds_validate_string(ip_, node, 'ip')
            self.ip.append(ip_)
# end class AccessControlList


class GlusterVolumeTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, gluster_volume_type=None):
        if gluster_volume_type is None:
            self.gluster_volume_type = []
        else:
            self.gluster_volume_type = gluster_volume_type
    def factory(*args_, **kwargs_):
        if GlusterVolumeTypes.subclass:
            return GlusterVolumeTypes.subclass(*args_, **kwargs_)
        else:
            return GlusterVolumeTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_gluster_volume_type(self): return self.gluster_volume_type
    def set_gluster_volume_type(self, gluster_volume_type): self.gluster_volume_type = gluster_volume_type
    def add_gluster_volume_type(self, value): self.gluster_volume_type.append(value)
    def insert_gluster_volume_type(self, index, value): self.gluster_volume_type[index] = value
    def export(self, outfile, level, namespace_='', name_='GlusterVolumeTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterVolumeTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GlusterVolumeTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GlusterVolumeTypes', fromsubclass_=False):
        for gluster_volume_type_ in self.gluster_volume_type:
            showIndent(outfile, level)
            outfile.write('<%sgluster_volume_type>%s</%sgluster_volume_type>\n' % (namespace_, self.gds_format_string(quote_xml(gluster_volume_type_).encode(ExternalEncoding), input_name='gluster_volume_type'), namespace_))
    def hasContent_(self):
        if (
            self.gluster_volume_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GlusterVolumeTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('gluster_volume_type=[\n')
        level += 1
        for gluster_volume_type_ in self.gluster_volume_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(gluster_volume_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gluster_volume_type':
            gluster_volume_type_ = child_.text
            gluster_volume_type_ = self.gds_validate_string(gluster_volume_type_, node, 'gluster_volume_type')
            self.gluster_volume_type.append(gluster_volume_type_)
# end class GlusterVolumeTypes


class AccessProtocols(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, access_protocol=None):
        if access_protocol is None:
            self.access_protocol = []
        else:
            self.access_protocol = access_protocol
    def factory(*args_, **kwargs_):
        if AccessProtocols.subclass:
            return AccessProtocols.subclass(*args_, **kwargs_)
        else:
            return AccessProtocols(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_access_protocol(self): return self.access_protocol
    def set_access_protocol(self, access_protocol): self.access_protocol = access_protocol
    def add_access_protocol(self, value): self.access_protocol.append(value)
    def insert_access_protocol(self, index, value): self.access_protocol[index] = value
    def export(self, outfile, level, namespace_='', name_='AccessProtocols', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessProtocols')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessProtocols'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='AccessProtocols', fromsubclass_=False):
        for access_protocol_ in self.access_protocol:
            showIndent(outfile, level)
            outfile.write('<%saccess_protocol>%s</%saccess_protocol>\n' % (namespace_, self.gds_format_string(quote_xml(access_protocol_).encode(ExternalEncoding), input_name='access_protocol'), namespace_))
    def hasContent_(self):
        if (
            self.access_protocol
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AccessProtocols'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('access_protocol=[\n')
        level += 1
        for access_protocol_ in self.access_protocol:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(access_protocol_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'access_protocol':
            access_protocol_ = child_.text
            access_protocol_ = self.gds_validate_string(access_protocol_, node, 'access_protocol')
            self.access_protocol.append(access_protocol_)
# end class AccessProtocols


class TransportTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, transport_type=None):
        if transport_type is None:
            self.transport_type = []
        else:
            self.transport_type = transport_type
    def factory(*args_, **kwargs_):
        if TransportTypes.subclass:
            return TransportTypes.subclass(*args_, **kwargs_)
        else:
            return TransportTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_transport_type(self): return self.transport_type
    def set_transport_type(self, transport_type): self.transport_type = transport_type
    def add_transport_type(self, value): self.transport_type.append(value)
    def insert_transport_type(self, index, value): self.transport_type[index] = value
    def export(self, outfile, level, namespace_='', name_='TransportTypes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TransportTypes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TransportTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TransportTypes', fromsubclass_=False):
        for transport_type_ in self.transport_type:
            showIndent(outfile, level)
            outfile.write('<%stransport_type>%s</%stransport_type>\n' % (namespace_, self.gds_format_string(quote_xml(transport_type_).encode(ExternalEncoding), input_name='transport_type'), namespace_))
    def hasContent_(self):
        if (
            self.transport_type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TransportTypes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('transport_type=[\n')
        level += 1
        for transport_type_ in self.transport_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(transport_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'transport_type':
            transport_type_ = child_.text
            transport_type_ = self.gds_validate_string(transport_type_, node, 'transport_type')
            self.transport_type.append(transport_type_)
# end class TransportTypes


class GlusterStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, state=None):
        if state is None:
            self.state = []
        else:
            self.state = state
    def factory(*args_, **kwargs_):
        if GlusterStates.subclass:
            return GlusterStates.subclass(*args_, **kwargs_)
        else:
            return GlusterStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def add_state(self, value): self.state.append(value)
    def insert_state(self, index, value): self.state[index] = value
    def export(self, outfile, level, namespace_='', name_='GlusterStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GlusterStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GlusterStates', fromsubclass_=False):
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('<%sstate>%s</%sstate>\n' % (namespace_, self.gds_format_string(quote_xml(state_).encode(ExternalEncoding), input_name='state'), namespace_))
    def hasContent_(self):
        if (
            self.state
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GlusterStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('state=[\n')
        level += 1
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state.append(state_)
# end class GlusterStates


class GlusterVolumes(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, gluster_volume=None):
        super(GlusterVolumes, self).__init__(actions, total, active, )
        if gluster_volume is None:
            self.gluster_volume = []
        else:
            self.gluster_volume = gluster_volume
    def factory(*args_, **kwargs_):
        if GlusterVolumes.subclass:
            return GlusterVolumes.subclass(*args_, **kwargs_)
        else:
            return GlusterVolumes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_gluster_volume(self): return self.gluster_volume
    def set_gluster_volume(self, gluster_volume): self.gluster_volume = gluster_volume
    def add_gluster_volume(self, value): self.gluster_volume.append(value)
    def insert_gluster_volume(self, index, value): self.gluster_volume[index] = value
    def export(self, outfile, level, namespace_='', name_='GlusterVolumes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterVolumes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GlusterVolumes'):
        super(GlusterVolumes, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterVolumes')
    def exportChildren(self, outfile, level, namespace_='', name_='GlusterVolumes', fromsubclass_=False):
        super(GlusterVolumes, self).exportChildren(outfile, level, namespace_, name_, True)
        for gluster_volume_ in self.gluster_volume:
            gluster_volume_.export(outfile, level, namespace_, name_='gluster_volume')
    def hasContent_(self):
        if (
            self.gluster_volume or
            super(GlusterVolumes, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GlusterVolumes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GlusterVolumes, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GlusterVolumes, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('gluster_volume=[\n')
        level += 1
        for gluster_volume_ in self.gluster_volume:
            showIndent(outfile, level)
            outfile.write('model_.gluster_volume(\n')
            gluster_volume_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(GlusterVolumes, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gluster_volume':
            obj_ = GlusterVolume.factory()
            obj_.build(child_)
            self.gluster_volume.append(obj_)
        super(GlusterVolumes, self).buildChildren(child_, node, nodeName_, True)
# end class GlusterVolumes


class GlusterBrick(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, gluster_volume=None, server_id=None, brick_dir=None, state=None):
        super(GlusterBrick, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.gluster_volume = gluster_volume
        self.server_id = server_id
        self.brick_dir = brick_dir
        self.state = state
    def factory(*args_, **kwargs_):
        if GlusterBrick.subclass:
            return GlusterBrick.subclass(*args_, **kwargs_)
        else:
            return GlusterBrick(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_gluster_volume(self): return self.gluster_volume
    def set_gluster_volume(self, gluster_volume): self.gluster_volume = gluster_volume
    def get_server_id(self): return self.server_id
    def set_server_id(self, server_id): self.server_id = server_id
    def get_brick_dir(self): return self.brick_dir
    def set_brick_dir(self, brick_dir): self.brick_dir = brick_dir
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='GlusterBrick', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterBrick')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GlusterBrick'):
        super(GlusterBrick, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterBrick')
    def exportChildren(self, outfile, level, namespace_='', name_='GlusterBrick', fromsubclass_=False):
        super(GlusterBrick, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.gluster_volume is not None:
            self.gluster_volume.export(outfile, level, namespace_, name_='gluster_volume')
        if self.server_id is not None:
            showIndent(outfile, level)
            outfile.write('<%sserver_id>%s</%sserver_id>\n' % (namespace_, self.gds_format_string(quote_xml(self.server_id).encode(ExternalEncoding), input_name='server_id'), namespace_))
        if self.brick_dir is not None:
            showIndent(outfile, level)
            outfile.write('<%sbrick_dir>%s</%sbrick_dir>\n' % (namespace_, self.gds_format_string(quote_xml(self.brick_dir).encode(ExternalEncoding), input_name='brick_dir'), namespace_))
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('<%sstate>%s</%sstate>\n' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_))
    def hasContent_(self):
        if (
            self.gluster_volume is not None or
            self.server_id is not None or
            self.brick_dir is not None or
            self.state is not None or
            super(GlusterBrick, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GlusterBrick'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GlusterBrick, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GlusterBrick, self).exportLiteralChildren(outfile, level, name_)
        if self.gluster_volume is not None:
            showIndent(outfile, level)
            outfile.write('gluster_volume=model_.gluster_volume(\n')
            self.gluster_volume.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.server_id is not None:
            showIndent(outfile, level)
            outfile.write('server_id=%s,\n' % quote_python(self.server_id).encode(ExternalEncoding))
        if self.brick_dir is not None:
            showIndent(outfile, level)
            outfile.write('brick_dir=%s,\n' % quote_python(self.brick_dir).encode(ExternalEncoding))
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(GlusterBrick, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gluster_volume':
            obj_ = GlusterVolume.factory()
            obj_.build(child_)
            self.set_gluster_volume(obj_)
        elif nodeName_ == 'server_id':
            server_id_ = child_.text
            server_id_ = self.gds_validate_string(server_id_, node, 'server_id')
            self.server_id = server_id_
        elif nodeName_ == 'brick_dir':
            brick_dir_ = child_.text
            brick_dir_ = self.gds_validate_string(brick_dir_, node, 'brick_dir')
            self.brick_dir = brick_dir_
        elif nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
        super(GlusterBrick, self).buildChildren(child_, node, nodeName_, True)
# end class GlusterBrick


class GlusterBricks(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, replica_count=None, stripe_count=None, brick=None):
        self.replica_count = replica_count
        self.stripe_count = stripe_count
        if brick is None:
            self.brick = []
        else:
            self.brick = brick
    def factory(*args_, **kwargs_):
        if GlusterBricks.subclass:
            return GlusterBricks.subclass(*args_, **kwargs_)
        else:
            return GlusterBricks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_replica_count(self): return self.replica_count
    def set_replica_count(self, replica_count): self.replica_count = replica_count
    def get_stripe_count(self): return self.stripe_count
    def set_stripe_count(self, stripe_count): self.stripe_count = stripe_count
    def get_brick(self): return self.brick
    def set_brick(self, brick): self.brick = brick
    def add_brick(self, value): self.brick.append(value)
    def insert_brick(self, index, value): self.brick[index] = value
    def export(self, outfile, level, namespace_='', name_='GlusterBricks', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GlusterBricks')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GlusterBricks'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GlusterBricks', fromsubclass_=False):
        if self.replica_count is not None:
            showIndent(outfile, level)
            outfile.write('<%sreplica_count>%s</%sreplica_count>\n' % (namespace_, self.gds_format_integer(self.replica_count, input_name='replica_count'), namespace_))
        if self.stripe_count is not None:
            showIndent(outfile, level)
            outfile.write('<%sstripe_count>%s</%sstripe_count>\n' % (namespace_, self.gds_format_integer(self.stripe_count, input_name='stripe_count'), namespace_))
        for brick_ in self.brick:
            brick_.export(outfile, level, namespace_, name_='brick')
    def hasContent_(self):
        if (
            self.replica_count is not None or
            self.stripe_count is not None or
            self.brick
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GlusterBricks'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.replica_count is not None:
            showIndent(outfile, level)
            outfile.write('replica_count=%d,\n' % self.replica_count)
        if self.stripe_count is not None:
            showIndent(outfile, level)
            outfile.write('stripe_count=%d,\n' % self.stripe_count)
        showIndent(outfile, level)
        outfile.write('brick=[\n')
        level += 1
        for brick_ in self.brick:
            showIndent(outfile, level)
            outfile.write('model_.brick(\n')
            brick_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'replica_count':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'replica_count')
            self.replica_count = ival_
        elif nodeName_ == 'stripe_count':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'stripe_count')
            self.stripe_count = ival_
        elif nodeName_ == 'brick':
            obj_ = GlusterBrick.factory()
            obj_.build(child_)
            self.brick.append(obj_)
# end class GlusterBricks


class ProductInfo(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, vendor=None, version=None):
        super(ProductInfo, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.vendor = vendor
        self.version = version
    def factory(*args_, **kwargs_):
        if ProductInfo.subclass:
            return ProductInfo.subclass(*args_, **kwargs_)
        else:
            return ProductInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vendor(self): return self.vendor
    def set_vendor(self, vendor): self.vendor = vendor
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def export(self, outfile, level, namespace_='', name_='ProductInfo', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProductInfo')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ProductInfo'):
        super(ProductInfo, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProductInfo')
    def exportChildren(self, outfile, level, namespace_='', name_='ProductInfo', fromsubclass_=False):
        super(ProductInfo, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.vendor is not None:
            showIndent(outfile, level)
            outfile.write('<%svendor>%s</%svendor>\n' % (namespace_, self.gds_format_string(quote_xml(self.vendor).encode(ExternalEncoding), input_name='vendor'), namespace_))
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version')
    def hasContent_(self):
        if (
            self.vendor is not None or
            self.version is not None or
            super(ProductInfo, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ProductInfo'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ProductInfo, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProductInfo, self).exportLiteralChildren(outfile, level, name_)
        if self.vendor is not None:
            showIndent(outfile, level)
            outfile.write('vendor=%s,\n' % quote_python(self.vendor).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ProductInfo, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vendor':
            vendor_ = child_.text
            vendor_ = self.gds_validate_string(vendor_, node, 'vendor')
            self.vendor = vendor_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        super(ProductInfo, self).buildChildren(child_, node, nodeName_, True)
# end class ProductInfo


class Version(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, major=None, full_version=None, build_=None, minor=None, revision=None, extensiontype_=None):
        super(Version, self).__init__(actions, href, id, name, description, creation_status, link, extensiontype_, )
        self.major = _cast(int, major)
        self.full_version = _cast(None, full_version)
        self.build_ = _cast(int, build_)
        self.minor = _cast(int, minor)
        self.revision = _cast(int, revision)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Version.subclass:
            return Version.subclass(*args_, **kwargs_)
        else:
            return Version(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_major(self): return self.major
    def set_major(self, major): self.major = major
    def get_full_version(self): return self.full_version
    def set_full_version(self, full_version): self.full_version = full_version
    def get_build(self): return self.build_
    def set_build(self, build_): self.build_ = build_
    def get_minor(self): return self.minor
    def set_minor(self, minor): self.minor = minor
    def get_revision(self): return self.revision
    def set_revision(self, revision): self.revision = revision
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def export(self, outfile, level, namespace_='', name_='Version', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Version')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Version'):
        super(Version, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Version')
        if self.major is not None and 'major' not in already_processed:
            already_processed.append('major')
            outfile.write(' major="%s"' % self.gds_format_integer(self.major, input_name='major'))
        if self.full_version is not None and 'full_version' not in already_processed:
            already_processed.append('full_version')
            outfile.write(' full_version=%s' % (self.gds_format_string(quote_attrib(self.full_version).encode(ExternalEncoding), input_name='full_version'), ))
        if self.build_ is not None and 'build_' not in already_processed:
            already_processed.append('build_')
            outfile.write(' build="%s"' % self.gds_format_integer(self.build_, input_name='build'))
        if self.minor is not None and 'minor' not in already_processed:
            already_processed.append('minor')
            outfile.write(' minor="%s"' % self.gds_format_integer(self.minor, input_name='minor'))
        if self.revision is not None and 'revision' not in already_processed:
            already_processed.append('revision')
            outfile.write(' revision="%s"' % self.gds_format_integer(self.revision, input_name='revision'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Version', fromsubclass_=False):
        super(Version, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(Version, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Version'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.major is not None and 'major' not in already_processed:
            already_processed.append('major')
            showIndent(outfile, level)
            outfile.write('major = %d,\n' % (self.major,))
        if self.full_version is not None and 'full_version' not in already_processed:
            already_processed.append('full_version')
            showIndent(outfile, level)
            outfile.write('full_version = "%s",\n' % (self.full_version,))
        if self.build_ is not None and 'build_' not in already_processed:
            already_processed.append('build_')
            showIndent(outfile, level)
            outfile.write('build_ = %d,\n' % (self.build_,))
        if self.minor is not None and 'minor' not in already_processed:
            already_processed.append('minor')
            showIndent(outfile, level)
            outfile.write('minor = %d,\n' % (self.minor,))
        if self.revision is not None and 'revision' not in already_processed:
            already_processed.append('revision')
            showIndent(outfile, level)
            outfile.write('revision = %d,\n' % (self.revision,))
        super(Version, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Version, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('major', node)
        if value is not None and 'major' not in already_processed:
            already_processed.append('major')
            try:
                self.major = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('full_version', node)
        if value is not None and 'full_version' not in already_processed:
            already_processed.append('full_version')
            self.full_version = value
        value = find_attr_value_('build', node)
        if value is not None and 'build' not in already_processed:
            already_processed.append('build')
            try:
                self.build_ = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('minor', node)
        if value is not None and 'minor' not in already_processed:
            already_processed.append('minor')
            try:
                self.minor = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('revision', node)
        if value is not None and 'revision' not in already_processed:
            already_processed.append('revision')
            try:
                self.revision = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value
        super(Version, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Version, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Version


class Statistics(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, statistic=None):
        super(Statistics, self).__init__(actions, total, active, )
        if statistic is None:
            self.statistic = []
        else:
            self.statistic = statistic
    def factory(*args_, **kwargs_):
        if Statistics.subclass:
            return Statistics.subclass(*args_, **kwargs_)
        else:
            return Statistics(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_statistic(self): return self.statistic
    def set_statistic(self, statistic): self.statistic = statistic
    def add_statistic(self, value): self.statistic.append(value)
    def insert_statistic(self, index, value): self.statistic[index] = value
    def export(self, outfile, level, namespace_='', name_='Statistics', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Statistics')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Statistics'):
        super(Statistics, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Statistics')
    def exportChildren(self, outfile, level, namespace_='', name_='Statistics', fromsubclass_=False):
        super(Statistics, self).exportChildren(outfile, level, namespace_, name_, True)
        for statistic_ in self.statistic:
            statistic_.export(outfile, level, namespace_, name_='statistic')
    def hasContent_(self):
        if (
            self.statistic or
            super(Statistics, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Statistics'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Statistics, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Statistics, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('statistic=[\n')
        level += 1
        for statistic_ in self.statistic:
            showIndent(outfile, level)
            outfile.write('model_.statistic(\n')
            statistic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Statistics, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'statistic':
            obj_ = Statistic.factory()
            obj_.build(child_)
            self.statistic.append(obj_)
        super(Statistics, self).buildChildren(child_, node, nodeName_, True)
# end class Statistics


class Statistic(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, values=None, type_=None, unit=None, disk=None, host=None, host_nic=None, nic=None, vm=None):
        super(Statistic, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.values = values
        self.type_ = type_
        self.unit = unit
        self.disk = disk
        self.host = host
        self.host_nic = host_nic
        self.nic = nic
        self.vm = vm
    def factory(*args_, **kwargs_):
        if Statistic.subclass:
            return Statistic.subclass(*args_, **kwargs_)
        else:
            return Statistic(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_values(self): return self.values
    def set_values(self, values): self.values = values
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_StatisticType(self, value):
        # Validate type StatisticType, a restriction on xs:string.
        pass
    def get_unit(self): return self.unit
    def set_unit(self, unit): self.unit = unit
    def validate_StatisticUnit(self, value):
        # Validate type StatisticUnit, a restriction on xs:string.
        pass
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_host_nic(self): return self.host_nic
    def set_host_nic(self, host_nic): self.host_nic = host_nic
    def get_nic(self): return self.nic
    def set_nic(self, nic): self.nic = nic
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def export(self, outfile, level, namespace_='', name_='Statistic', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Statistic')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Statistic'):
        super(Statistic, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Statistic')
    def exportChildren(self, outfile, level, namespace_='', name_='Statistic', fromsubclass_=False):
        super(Statistic, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.values is not None:
            self.values.export(outfile, level, namespace_, name_='values', )
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.unit is not None:
            showIndent(outfile, level)
            outfile.write('<%sunit>%s</%sunit>\n' % (namespace_, self.gds_format_string(quote_xml(self.unit).encode(ExternalEncoding), input_name='unit'), namespace_))
        if self.disk is not None:
            self.disk.export(outfile, level, namespace_, name_='disk')
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.host_nic is not None:
            self.host_nic.export(outfile, level, namespace_, name_='host_nic')
        if self.nic is not None:
            self.nic.export(outfile, level, namespace_, name_='nic')
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
    def hasContent_(self):
        if (
            self.values is not None or
            self.type_ is not None or
            self.unit is not None or
            self.disk is not None or
            self.host is not None or
            self.host_nic is not None or
            self.nic is not None or
            self.vm is not None or
            super(Statistic, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Statistic'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Statistic, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Statistic, self).exportLiteralChildren(outfile, level, name_)
        if self.values is not None:
            showIndent(outfile, level)
            outfile.write('values=model_.values(\n')
            self.values.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.unit is not None:
            showIndent(outfile, level)
            outfile.write('unit=%s,\n' % quote_python(self.unit).encode(ExternalEncoding))
        if self.disk is not None:
            showIndent(outfile, level)
            outfile.write('disk=model_.disk(\n')
            self.disk.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host_nic is not None:
            showIndent(outfile, level)
            outfile.write('host_nic=model_.host_nic(\n')
            self.host_nic.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.nic is not None:
            showIndent(outfile, level)
            outfile.write('nic=model_.nic(\n')
            self.nic.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Statistic, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'values':
            obj_ = Values.factory()
            obj_.build(child_)
            self.set_values(obj_)
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
            self.validate_StatisticType(self.type_)    # validate type StatisticType
        elif nodeName_ == 'unit':
            unit_ = child_.text
            unit_ = self.gds_validate_string(unit_, node, 'unit')
            self.unit = unit_
            self.validate_StatisticUnit(self.unit)    # validate type StatisticUnit
        elif nodeName_ == 'disk':
            obj_ = Disk.factory()
            obj_.build(child_)
            self.set_disk(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'host_nic':
            obj_ = HostNIC.factory()
            obj_.build(child_)
            self.set_host_nic(obj_)
        elif nodeName_ == 'nic':
            obj_ = NIC.factory()
            obj_.build(child_)
            self.set_nic(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        super(Statistic, self).buildChildren(child_, node, nodeName_, True)
# end class Statistic


class Creation(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, status=None, fault=None):
        super(Creation, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.status = status
        self.fault = fault
    def factory(*args_, **kwargs_):
        if Creation.subclass:
            return Creation.subclass(*args_, **kwargs_)
        else:
            return Creation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_fault(self): return self.fault
    def set_fault(self, fault): self.fault = fault
    def export(self, outfile, level, namespace_='', name_='Creation', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Creation')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Creation'):
        super(Creation, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Creation')
    def exportChildren(self, outfile, level, namespace_='', name_='Creation', fromsubclass_=False):
        super(Creation, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.fault is not None:
            self.fault.export(outfile, level, namespace_, name_='fault')
    def hasContent_(self):
        if (
            self.status is not None or
            self.fault is not None or
            super(Creation, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Creation'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Creation, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Creation, self).exportLiteralChildren(outfile, level, name_)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fault is not None:
            showIndent(outfile, level)
            outfile.write('fault=model_.fault(\n')
            self.fault.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Creation, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'fault':
            obj_ = Fault.factory()
            obj_.build(child_)
            self.set_fault(obj_)
        super(Creation, self).buildChildren(child_, node, nodeName_, True)
# end class Creation


class Action(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, async=None, grace_period=None, host=None, network=None, root_password=None, image=None, fence_type=None, ticket=None, iscsi=None, storage_domain=None, cluster=None, discard_snapshots=None, exclusive=None, vm=None, template=None, host_nics=None, check_connectivity=None, connectivity_timeout=None, pause=None, force=None, option=None, fix_layout=None, brick=None, detach=None, clone=None, status=None, fault=None, iscsi_target=None, power_management=None):
        super(Action, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.async = async
        self.grace_period = grace_period
        self.host = host
        self.network = network
        self.root_password = root_password
        self.image = image
        self.fence_type = fence_type
        self.ticket = ticket
        self.iscsi = iscsi
        self.storage_domain = storage_domain
        self.cluster = cluster
        self.discard_snapshots = discard_snapshots
        self.exclusive = exclusive
        self.vm = vm
        self.template = template
        self.host_nics = host_nics
        self.check_connectivity = check_connectivity
        self.connectivity_timeout = connectivity_timeout
        self.pause = pause
        self.force = force
        self.option = option
        self.fix_layout = fix_layout
        self.brick = brick
        self.detach = detach
        self.clone = clone
        self.status = status
        self.fault = fault
        if iscsi_target is None:
            self.iscsi_target = []
        else:
            self.iscsi_target = iscsi_target
        self.power_management = power_management
    def factory(*args_, **kwargs_):
        if Action.subclass:
            return Action.subclass(*args_, **kwargs_)
        else:
            return Action(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_async(self): return self.async
    def set_async(self, async): self.async = async
    def get_grace_period(self): return self.grace_period
    def set_grace_period(self, grace_period): self.grace_period = grace_period
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_root_password(self): return self.root_password
    def set_root_password(self, root_password): self.root_password = root_password
    def get_image(self): return self.image
    def set_image(self, image): self.image = image
    def get_fence_type(self): return self.fence_type
    def set_fence_type(self, fence_type): self.fence_type = fence_type
    def get_ticket(self): return self.ticket
    def set_ticket(self, ticket): self.ticket = ticket
    def get_iscsi(self): return self.iscsi
    def set_iscsi(self, iscsi): self.iscsi = iscsi
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_discard_snapshots(self): return self.discard_snapshots
    def set_discard_snapshots(self, discard_snapshots): self.discard_snapshots = discard_snapshots
    def get_exclusive(self): return self.exclusive
    def set_exclusive(self, exclusive): self.exclusive = exclusive
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_host_nics(self): return self.host_nics
    def set_host_nics(self, host_nics): self.host_nics = host_nics
    def get_check_connectivity(self): return self.check_connectivity
    def set_check_connectivity(self, check_connectivity): self.check_connectivity = check_connectivity
    def get_connectivity_timeout(self): return self.connectivity_timeout
    def set_connectivity_timeout(self, connectivity_timeout): self.connectivity_timeout = connectivity_timeout
    def get_pause(self): return self.pause
    def set_pause(self, pause): self.pause = pause
    def get_force(self): return self.force
    def set_force(self, force): self.force = force
    def get_option(self): return self.option
    def set_option(self, option): self.option = option
    def get_fix_layout(self): return self.fix_layout
    def set_fix_layout(self, fix_layout): self.fix_layout = fix_layout
    def get_brick(self): return self.brick
    def set_brick(self, brick): self.brick = brick
    def get_detach(self): return self.detach
    def set_detach(self, detach): self.detach = detach
    def get_clone(self): return self.clone
    def set_clone(self, clone): self.clone = clone
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_fault(self): return self.fault
    def set_fault(self, fault): self.fault = fault
    def get_iscsi_target(self): return self.iscsi_target
    def set_iscsi_target(self, iscsi_target): self.iscsi_target = iscsi_target
    def add_iscsi_target(self, value): self.iscsi_target.append(value)
    def insert_iscsi_target(self, index, value): self.iscsi_target[index] = value
    def get_power_management(self): return self.power_management
    def set_power_management(self, power_management): self.power_management = power_management
    def export(self, outfile, level, namespace_='', name_='Action', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Action')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Action'):
        super(Action, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Action')
    def exportChildren(self, outfile, level, namespace_='', name_='Action', fromsubclass_=False):
        super(Action, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.async is not None:
            showIndent(outfile, level)
            outfile.write('<%sasync>%s</%sasync>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.async)), input_name='async'), namespace_))
        if self.grace_period is not None:
            self.grace_period.export(outfile, level, namespace_, name_='grace_period')
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host')
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network')
        if self.root_password is not None:
            showIndent(outfile, level)
            outfile.write('<%sroot_password>%s</%sroot_password>\n' % (namespace_, self.gds_format_string(quote_xml(self.root_password).encode(ExternalEncoding), input_name='root_password'), namespace_))
        if self.image is not None:
            showIndent(outfile, level)
            outfile.write('<%simage>%s</%simage>\n' % (namespace_, self.gds_format_string(quote_xml(self.image).encode(ExternalEncoding), input_name='image'), namespace_))
        if self.fence_type is not None:
            showIndent(outfile, level)
            outfile.write('<%sfence_type>%s</%sfence_type>\n' % (namespace_, self.gds_format_string(quote_xml(self.fence_type).encode(ExternalEncoding), input_name='fence_type'), namespace_))
        if self.ticket is not None:
            self.ticket.export(outfile, level, namespace_, name_='ticket')
        if self.iscsi is not None:
            self.iscsi.export(outfile, level, namespace_, name_='iscsi')
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain')
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster')
        if self.discard_snapshots is not None:
            showIndent(outfile, level)
            outfile.write('<%sdiscard_snapshots>%s</%sdiscard_snapshots>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.discard_snapshots)), input_name='discard_snapshots'), namespace_))
        if self.exclusive is not None:
            showIndent(outfile, level)
            outfile.write('<%sexclusive>%s</%sexclusive>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.exclusive)), input_name='exclusive'), namespace_))
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm')
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template')
        if self.host_nics is not None:
            self.host_nics.export(outfile, level, namespace_, name_='host_nics')
        if self.check_connectivity is not None:
            showIndent(outfile, level)
            outfile.write('<%scheck_connectivity>%s</%scheck_connectivity>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.check_connectivity)), input_name='check_connectivity'), namespace_))
        if self.connectivity_timeout is not None:
            showIndent(outfile, level)
            outfile.write('<%sconnectivity_timeout>%s</%sconnectivity_timeout>\n' % (namespace_, self.gds_format_integer(self.connectivity_timeout, input_name='connectivity_timeout'), namespace_))
        if self.pause is not None:
            showIndent(outfile, level)
            outfile.write('<%spause>%s</%spause>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.pause)), input_name='pause'), namespace_))
        if self.force is not None:
            showIndent(outfile, level)
            outfile.write('<%sforce>%s</%sforce>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.force)), input_name='force'), namespace_))
        if self.option is not None:
            self.option.export(outfile, level, namespace_, name_='option')
        if self.fix_layout is not None:
            showIndent(outfile, level)
            outfile.write('<%sfix_layout>%s</%sfix_layout>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.fix_layout)), input_name='fix_layout'), namespace_))
        if self.brick is not None:
            self.brick.export(outfile, level, namespace_, name_='brick')
        if self.detach is not None:
            showIndent(outfile, level)
            outfile.write('<%sdetach>%s</%sdetach>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.detach)), input_name='detach'), namespace_))
        if self.clone is not None:
            showIndent(outfile, level)
            outfile.write('<%sclone>%s</%sclone>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.clone)), input_name='clone'), namespace_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status')
        if self.fault is not None:
            self.fault.export(outfile, level, namespace_, name_='fault')
        for iscsi_target_ in self.iscsi_target:
            showIndent(outfile, level)
            outfile.write('<%siscsi_target>%s</%siscsi_target>\n' % (namespace_, self.gds_format_string(quote_xml(iscsi_target_).encode(ExternalEncoding), input_name='iscsi_target'), namespace_))
        if self.power_management is not None:
            self.power_management.export(outfile, level, namespace_, name_='power_management')
    def hasContent_(self):
        if (
            self.async is not None or
            self.grace_period is not None or
            self.host is not None or
            self.network is not None or
            self.root_password is not None or
            self.image is not None or
            self.fence_type is not None or
            self.ticket is not None or
            self.iscsi is not None or
            self.storage_domain is not None or
            self.cluster is not None or
            self.discard_snapshots is not None or
            self.exclusive is not None or
            self.vm is not None or
            self.template is not None or
            self.host_nics is not None or
            self.check_connectivity is not None or
            self.connectivity_timeout is not None or
            self.pause is not None or
            self.force is not None or
            self.option is not None or
            self.fix_layout is not None or
            self.brick is not None or
            self.detach is not None or
            self.clone is not None or
            self.status is not None or
            self.fault is not None or
            self.iscsi_target or
            self.power_management is not None or
            super(Action, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Action'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Action, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Action, self).exportLiteralChildren(outfile, level, name_)
        if self.async is not None:
            showIndent(outfile, level)
            outfile.write('async=%s,\n' % self.async)
        if self.grace_period is not None:
            showIndent(outfile, level)
            outfile.write('grace_period=model_.GracePeriod(\n')
            self.grace_period.exportLiteral(outfile, level, name_='grace_period')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.Host(\n')
            self.host.exportLiteral(outfile, level, name_='host')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.Network(\n')
            self.network.exportLiteral(outfile, level, name_='network')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.root_password is not None:
            showIndent(outfile, level)
            outfile.write('root_password=%s,\n' % quote_python(self.root_password).encode(ExternalEncoding))
        if self.image is not None:
            showIndent(outfile, level)
            outfile.write('image=%s,\n' % quote_python(self.image).encode(ExternalEncoding))
        if self.fence_type is not None:
            showIndent(outfile, level)
            outfile.write('fence_type=%s,\n' % quote_python(self.fence_type).encode(ExternalEncoding))
        if self.ticket is not None:
            showIndent(outfile, level)
            outfile.write('ticket=model_.Ticket(\n')
            self.ticket.exportLiteral(outfile, level, name_='ticket')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.iscsi is not None:
            showIndent(outfile, level)
            outfile.write('iscsi=model_.IscsiDetails(\n')
            self.iscsi.exportLiteral(outfile, level, name_='iscsi')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.StorageDomain(\n')
            self.storage_domain.exportLiteral(outfile, level, name_='storage_domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.Cluster(\n')
            self.cluster.exportLiteral(outfile, level, name_='cluster')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.discard_snapshots is not None:
            showIndent(outfile, level)
            outfile.write('discard_snapshots=%s,\n' % self.discard_snapshots)
        if self.exclusive is not None:
            showIndent(outfile, level)
            outfile.write('exclusive=%s,\n' % self.exclusive)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host_nics is not None:
            showIndent(outfile, level)
            outfile.write('host_nics=model_.host_nics(\n')
            self.host_nics.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.check_connectivity is not None:
            showIndent(outfile, level)
            outfile.write('check_connectivity=%s,\n' % self.check_connectivity)
        if self.connectivity_timeout is not None:
            showIndent(outfile, level)
            outfile.write('connectivity_timeout=%d,\n' % self.connectivity_timeout)
        if self.pause is not None:
            showIndent(outfile, level)
            outfile.write('pause=%s,\n' % self.pause)
        if self.force is not None:
            showIndent(outfile, level)
            outfile.write('force=%s,\n' % self.force)
        if self.option is not None:
            showIndent(outfile, level)
            outfile.write('option=model_.Option(\n')
            self.option.exportLiteral(outfile, level, name_='option')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fix_layout is not None:
            showIndent(outfile, level)
            outfile.write('fix_layout=%s,\n' % self.fix_layout)
        if self.brick is not None:
            showIndent(outfile, level)
            outfile.write('brick=model_.GlusterBrick(\n')
            self.brick.exportLiteral(outfile, level, name_='brick')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.detach is not None:
            showIndent(outfile, level)
            outfile.write('detach=%s,\n' % self.detach)
        if self.clone is not None:
            showIndent(outfile, level)
            outfile.write('clone=%s,\n' % self.clone)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fault is not None:
            showIndent(outfile, level)
            outfile.write('fault=model_.fault(\n')
            self.fault.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('iscsi_target=[\n')
        level += 1
        for iscsi_target_ in self.iscsi_target:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(iscsi_target_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.power_management is not None:
            showIndent(outfile, level)
            outfile.write('power_management=model_.power_management(\n')
            self.power_management.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Action, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'async':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'async')
            self.async = ival_
        elif nodeName_ == 'grace_period':
            obj_ = GracePeriod.factory()
            obj_.build(child_)
            self.set_grace_period(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.set_network(obj_)
        elif nodeName_ == 'root_password':
            root_password_ = child_.text
            root_password_ = self.gds_validate_string(root_password_, node, 'root_password')
            self.root_password = root_password_
        elif nodeName_ == 'image':
            image_ = child_.text
            image_ = self.gds_validate_string(image_, node, 'image')
            self.image = image_
        elif nodeName_ == 'fence_type':
            fence_type_ = child_.text
            fence_type_ = self.gds_validate_string(fence_type_, node, 'fence_type')
            self.fence_type = fence_type_
        elif nodeName_ == 'ticket':
            obj_ = Ticket.factory()
            obj_.build(child_)
            self.set_ticket(obj_)
        elif nodeName_ == 'iscsi':
            obj_ = IscsiDetails.factory()
            obj_.build(child_)
            self.set_iscsi(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'discard_snapshots':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'discard_snapshots')
            self.discard_snapshots = ival_
        elif nodeName_ == 'exclusive':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'exclusive')
            self.exclusive = ival_
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'host_nics':
            obj_ = HostNics.factory()
            obj_.build(child_)
            self.set_host_nics(obj_)
        elif nodeName_ == 'check_connectivity':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'check_connectivity')
            self.check_connectivity = ival_
        elif nodeName_ == 'connectivity_timeout':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'connectivity_timeout')
            self.connectivity_timeout = ival_
        elif nodeName_ == 'pause':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'pause')
            self.pause = ival_
        elif nodeName_ == 'force':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'force')
            self.force = ival_
        elif nodeName_ == 'option':
            obj_ = Option.factory()
            obj_.build(child_)
            self.set_option(obj_)
        elif nodeName_ == 'fix_layout':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'fix_layout')
            self.fix_layout = ival_
        elif nodeName_ == 'brick':
            obj_ = GlusterBrick.factory()
            obj_.build(child_)
            self.set_brick(obj_)
        elif nodeName_ == 'detach':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'detach')
            self.detach = ival_
        elif nodeName_ == 'clone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'clone')
            self.clone = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'fault':
            obj_ = Fault.factory()
            obj_.build(child_)
            self.set_fault(obj_)
        elif nodeName_ == 'iscsi_target':
            iscsi_target_ = child_.text
            iscsi_target_ = self.gds_validate_string(iscsi_target_, node, 'iscsi_target')
            self.iscsi_target.append(iscsi_target_)
        elif nodeName_ == 'power_management':
            obj_ = PowerManagement.factory()
            obj_.build(child_)
            self.set_power_management(obj_)
        super(Action, self).buildChildren(child_, node, nodeName_, True)
# end class Action


class SpecialObjects(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None):
        super(SpecialObjects, self).__init__(actions, href, id, name, description, creation_status, link, )
        pass
    def factory(*args_, **kwargs_):
        if SpecialObjects.subclass:
            return SpecialObjects.subclass(*args_, **kwargs_)
        else:
            return SpecialObjects(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='SpecialObjects', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpecialObjects')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpecialObjects'):
        super(SpecialObjects, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpecialObjects')
    def exportChildren(self, outfile, level, namespace_='', name_='SpecialObjects', fromsubclass_=False):
        super(SpecialObjects, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(SpecialObjects, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SpecialObjects'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SpecialObjects, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SpecialObjects, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(SpecialObjects, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpecialObjects, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpecialObjects


class API(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, special_objects=None, product_info=None, summary=None, time=None):
        super(API, self).__init__(actions, href, id, name, description, creation_status, link, )
        self.special_objects = special_objects
        self.product_info = product_info
        self.summary = summary
        self.time = time
    def factory(*args_, **kwargs_):
        if API.subclass:
            return API.subclass(*args_, **kwargs_)
        else:
            return API(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_special_objects(self): return self.special_objects
    def set_special_objects(self, special_objects): self.special_objects = special_objects
    def get_product_info(self): return self.product_info
    def set_product_info(self, product_info): self.product_info = product_info
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def export(self, outfile, level, namespace_='', name_='API', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='API')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='API'):
        super(API, self).exportAttributes(outfile, level, already_processed, namespace_, name_='API')
    def exportChildren(self, outfile, level, namespace_='', name_='API', fromsubclass_=False):
        super(API, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.special_objects is not None:
            self.special_objects.export(outfile, level, namespace_, name_='special_objects', )
        if self.product_info is not None:
            self.product_info.export(outfile, level, namespace_, name_='product_info', )
        if self.summary is not None:
            self.summary.export(outfile, level, namespace_, name_='summary', )
        if self.time is not None:
            showIndent(outfile, level)
            outfile.write('<%stime>%s</%stime>\n' % (namespace_, self.gds_format_string(quote_xml(self.time).encode(ExternalEncoding), input_name='time'), namespace_))
    def hasContent_(self):
        if (
            self.special_objects is not None or
            self.product_info is not None or
            self.summary is not None or
            self.time is not None or
            super(API, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='API'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(API, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(API, self).exportLiteralChildren(outfile, level, name_)
        if self.special_objects is not None:
            showIndent(outfile, level)
            outfile.write('special_objects=model_.special_objects(\n')
            self.special_objects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.product_info is not None:
            showIndent(outfile, level)
            outfile.write('product_info=model_.product_info(\n')
            self.product_info.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=model_.summary(\n')
            self.summary.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.time is not None:
            showIndent(outfile, level)
            outfile.write('time=%s,\n' % quote_python(self.time).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(API, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'special_objects':
            obj_ = SpecialObjects.factory()
            obj_.build(child_)
            self.set_special_objects(obj_)
        elif nodeName_ == 'product_info':
            obj_ = ProductInfo.factory()
            obj_.build(child_)
            self.set_product_info(obj_)
        elif nodeName_ == 'summary':
            obj_ = ApiSummary.factory()
            obj_.build(child_)
            self.set_summary(obj_)
        elif nodeName_ == 'time':
            time_ = child_.text
            time_ = self.gds_validate_string(time_, node, 'time')
            self.time = time_
        super(API, self).buildChildren(child_, node, nodeName_, True)
# end class API


class DetailedLink(Link):
    subclass = None
    superclass = Link
    def __init__(self, href=None, rel=None, request=None, response=None, linkCapabilities=None):
        super(DetailedLink, self).__init__(href, rel, )
        self.request = request
        self.response = response
        self.linkCapabilities = linkCapabilities
    def factory(*args_, **kwargs_):
        if DetailedLink.subclass:
            return DetailedLink.subclass(*args_, **kwargs_)
        else:
            return DetailedLink(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_request(self): return self.request
    def set_request(self, request): self.request = request
    def get_response(self): return self.response
    def set_response(self, response): self.response = response
    def get_linkCapabilities(self): return self.linkCapabilities
    def set_linkCapabilities(self, linkCapabilities): self.linkCapabilities = linkCapabilities
    def export(self, outfile, level, namespace_='', name_='DetailedLink', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DetailedLink')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DetailedLink'):
        super(DetailedLink, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DetailedLink')
    def exportChildren(self, outfile, level, namespace_='', name_='DetailedLink', fromsubclass_=False):
        super(DetailedLink, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.request is not None:
            self.request.export(outfile, level, namespace_, name_='request')
        if self.response is not None:
            self.response.export(outfile, level, namespace_, name_='response')
        if self.linkCapabilities is not None:
            self.linkCapabilities.export(outfile, level, namespace_, name_='linkCapabilities')
    def hasContent_(self):
        if (
            self.request is not None or
            self.response is not None or
            self.linkCapabilities is not None or
            super(DetailedLink, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DetailedLink'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DetailedLink, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DetailedLink, self).exportLiteralChildren(outfile, level, name_)
        if self.request is not None:
            showIndent(outfile, level)
            outfile.write('request=model_.request(\n')
            self.request.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.response is not None:
            showIndent(outfile, level)
            outfile.write('response=model_.response(\n')
            self.response.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.linkCapabilities is not None:
            showIndent(outfile, level)
            outfile.write('linkCapabilities=model_.linkCapabilities(\n')
            self.linkCapabilities.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DetailedLink, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'request':
            obj_ = Request.factory()
            obj_.build(child_)
            self.set_request(obj_)
        elif nodeName_ == 'response':
            obj_ = Response.factory()
            obj_.build(child_)
            self.set_response(obj_)
        elif nodeName_ == 'linkCapabilities':
            obj_ = LinkCapabilities.factory()
            obj_.build(child_)
            self.set_linkCapabilities(obj_)
        super(DetailedLink, self).buildChildren(child_, node, nodeName_, True)
# end class DetailedLink


class VersionCaps(Version):
    subclass = None
    superclass = Version
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, creation_status=None, link=None, major=None, full_version=None, build_=None, minor=None, revision=None, current=None, features=None, cpus=None, power_managers=None, fence_types=None, storage_types=None, storage_domain_types=None, vm_types=None, boot_devices=None, display_types=None, nic_interfaces=None, os_types=None, disk_formats=None, disk_interfaces=None, vm_affinities=None, custom_properties=None, boot_protocols=None, error_handling=None, storage_formats=None, creation_states=None, power_management_states=None, host_states=None, host_non_operational_details=None, network_states=None, storage_domain_states=None, template_states=None, vm_states=None, vm_pause_details=None, disk_states=None, host_nic_states=None, data_center_states=None, vm_device_types=None, permits=None, scheduling_policies=None, usages=None, gluster_volume_types=None, transport_types=None, access_protocols=None, gluster_volume_states=None, brick_states=None):
        super(VersionCaps, self).__init__(actions, href, id, name, description, creation_status, link, major, full_version, build_, minor, revision, )
        self.current = current
        self.features = features
        self.cpus = cpus
        self.power_managers = power_managers
        self.fence_types = fence_types
        self.storage_types = storage_types
        self.storage_domain_types = storage_domain_types
        self.vm_types = vm_types
        self.boot_devices = boot_devices
        self.display_types = display_types
        self.nic_interfaces = nic_interfaces
        self.os_types = os_types
        self.disk_formats = disk_formats
        self.disk_interfaces = disk_interfaces
        self.vm_affinities = vm_affinities
        self.custom_properties = custom_properties
        self.boot_protocols = boot_protocols
        self.error_handling = error_handling
        self.storage_formats = storage_formats
        self.creation_states = creation_states
        self.power_management_states = power_management_states
        self.host_states = host_states
        self.host_non_operational_details = host_non_operational_details
        self.network_states = network_states
        self.storage_domain_states = storage_domain_states
        self.template_states = template_states
        self.vm_states = vm_states
        self.vm_pause_details = vm_pause_details
        self.disk_states = disk_states
        self.host_nic_states = host_nic_states
        self.data_center_states = data_center_states
        self.vm_device_types = vm_device_types
        self.permits = permits
        self.scheduling_policies = scheduling_policies
        self.usages = usages
        self.gluster_volume_types = gluster_volume_types
        self.transport_types = transport_types
        self.access_protocols = access_protocols
        self.gluster_volume_states = gluster_volume_states
        self.brick_states = brick_states
    def factory(*args_, **kwargs_):
        if VersionCaps.subclass:
            return VersionCaps.subclass(*args_, **kwargs_)
        else:
            return VersionCaps(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_current(self): return self.current
    def set_current(self, current): self.current = current
    def get_features(self): return self.features
    def set_features(self, features): self.features = features
    def get_cpus(self): return self.cpus
    def set_cpus(self, cpus): self.cpus = cpus
    def get_power_managers(self): return self.power_managers
    def set_power_managers(self, power_managers): self.power_managers = power_managers
    def get_fence_types(self): return self.fence_types
    def set_fence_types(self, fence_types): self.fence_types = fence_types
    def get_storage_types(self): return self.storage_types
    def set_storage_types(self, storage_types): self.storage_types = storage_types
    def get_storage_domain_types(self): return self.storage_domain_types
    def set_storage_domain_types(self, storage_domain_types): self.storage_domain_types = storage_domain_types
    def get_vm_types(self): return self.vm_types
    def set_vm_types(self, vm_types): self.vm_types = vm_types
    def get_boot_devices(self): return self.boot_devices
    def set_boot_devices(self, boot_devices): self.boot_devices = boot_devices
    def get_display_types(self): return self.display_types
    def set_display_types(self, display_types): self.display_types = display_types
    def get_nic_interfaces(self): return self.nic_interfaces
    def set_nic_interfaces(self, nic_interfaces): self.nic_interfaces = nic_interfaces
    def get_os_types(self): return self.os_types
    def set_os_types(self, os_types): self.os_types = os_types
    def get_disk_formats(self): return self.disk_formats
    def set_disk_formats(self, disk_formats): self.disk_formats = disk_formats
    def get_disk_interfaces(self): return self.disk_interfaces
    def set_disk_interfaces(self, disk_interfaces): self.disk_interfaces = disk_interfaces
    def get_vm_affinities(self): return self.vm_affinities
    def set_vm_affinities(self, vm_affinities): self.vm_affinities = vm_affinities
    def get_custom_properties(self): return self.custom_properties
    def set_custom_properties(self, custom_properties): self.custom_properties = custom_properties
    def get_boot_protocols(self): return self.boot_protocols
    def set_boot_protocols(self, boot_protocols): self.boot_protocols = boot_protocols
    def get_error_handling(self): return self.error_handling
    def set_error_handling(self, error_handling): self.error_handling = error_handling
    def get_storage_formats(self): return self.storage_formats
    def set_storage_formats(self, storage_formats): self.storage_formats = storage_formats
    def get_creation_states(self): return self.creation_states
    def set_creation_states(self, creation_states): self.creation_states = creation_states
    def get_power_management_states(self): return self.power_management_states
    def set_power_management_states(self, power_management_states): self.power_management_states = power_management_states
    def get_host_states(self): return self.host_states
    def set_host_states(self, host_states): self.host_states = host_states
    def get_host_non_operational_details(self): return self.host_non_operational_details
    def set_host_non_operational_details(self, host_non_operational_details): self.host_non_operational_details = host_non_operational_details
    def get_network_states(self): return self.network_states
    def set_network_states(self, network_states): self.network_states = network_states
    def get_storage_domain_states(self): return self.storage_domain_states
    def set_storage_domain_states(self, storage_domain_states): self.storage_domain_states = storage_domain_states
    def get_template_states(self): return self.template_states
    def set_template_states(self, template_states): self.template_states = template_states
    def get_vm_states(self): return self.vm_states
    def set_vm_states(self, vm_states): self.vm_states = vm_states
    def get_vm_pause_details(self): return self.vm_pause_details
    def set_vm_pause_details(self, vm_pause_details): self.vm_pause_details = vm_pause_details
    def get_disk_states(self): return self.disk_states
    def set_disk_states(self, disk_states): self.disk_states = disk_states
    def get_host_nic_states(self): return self.host_nic_states
    def set_host_nic_states(self, host_nic_states): self.host_nic_states = host_nic_states
    def get_data_center_states(self): return self.data_center_states
    def set_data_center_states(self, data_center_states): self.data_center_states = data_center_states
    def get_vm_device_types(self): return self.vm_device_types
    def set_vm_device_types(self, vm_device_types): self.vm_device_types = vm_device_types
    def get_permits(self): return self.permits
    def set_permits(self, permits): self.permits = permits
    def get_scheduling_policies(self): return self.scheduling_policies
    def set_scheduling_policies(self, scheduling_policies): self.scheduling_policies = scheduling_policies
    def get_usages(self): return self.usages
    def set_usages(self, usages): self.usages = usages
    def get_gluster_volume_types(self): return self.gluster_volume_types
    def set_gluster_volume_types(self, gluster_volume_types): self.gluster_volume_types = gluster_volume_types
    def get_transport_types(self): return self.transport_types
    def set_transport_types(self, transport_types): self.transport_types = transport_types
    def get_access_protocols(self): return self.access_protocols
    def set_access_protocols(self, access_protocols): self.access_protocols = access_protocols
    def get_gluster_volume_states(self): return self.gluster_volume_states
    def set_gluster_volume_states(self, gluster_volume_states): self.gluster_volume_states = gluster_volume_states
    def get_brick_states(self): return self.brick_states
    def set_brick_states(self, brick_states): self.brick_states = brick_states
    def export(self, outfile, level, namespace_='', name_='VersionCaps', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VersionCaps')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VersionCaps'):
        super(VersionCaps, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VersionCaps')
    def exportChildren(self, outfile, level, namespace_='', name_='VersionCaps', fromsubclass_=False):
        super(VersionCaps, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.current is not None:
            showIndent(outfile, level)
            outfile.write('<%scurrent>%s</%scurrent>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.current)), input_name='current'), namespace_))
        if self.features is not None:
            self.features.export(outfile, level, namespace_, name_='features')
        if self.cpus is not None:
            self.cpus.export(outfile, level, namespace_, name_='cpus')
        if self.power_managers is not None:
            self.power_managers.export(outfile, level, namespace_, name_='power_managers')
        if self.fence_types is not None:
            self.fence_types.export(outfile, level, namespace_, name_='fence_types')
        if self.storage_types is not None:
            self.storage_types.export(outfile, level, namespace_, name_='storage_types')
        if self.storage_domain_types is not None:
            self.storage_domain_types.export(outfile, level, namespace_, name_='storage_domain_types')
        if self.vm_types is not None:
            self.vm_types.export(outfile, level, namespace_, name_='vm_types')
        if self.boot_devices is not None:
            self.boot_devices.export(outfile, level, namespace_, name_='boot_devices')
        if self.display_types is not None:
            self.display_types.export(outfile, level, namespace_, name_='display_types')
        if self.nic_interfaces is not None:
            self.nic_interfaces.export(outfile, level, namespace_, name_='nic_interfaces')
        if self.os_types is not None:
            self.os_types.export(outfile, level, namespace_, name_='os_types')
        if self.disk_formats is not None:
            self.disk_formats.export(outfile, level, namespace_, name_='disk_formats')
        if self.disk_interfaces is not None:
            self.disk_interfaces.export(outfile, level, namespace_, name_='disk_interfaces')
        if self.vm_affinities is not None:
            self.vm_affinities.export(outfile, level, namespace_, name_='vm_affinities')
        if self.custom_properties is not None:
            self.custom_properties.export(outfile, level, namespace_, name_='custom_properties')
        if self.boot_protocols is not None:
            self.boot_protocols.export(outfile, level, namespace_, name_='boot_protocols')
        if self.error_handling is not None:
            self.error_handling.export(outfile, level, namespace_, name_='error_handling')
        if self.storage_formats is not None:
            self.storage_formats.export(outfile, level, namespace_, name_='storage_formats')
        if self.creation_states is not None:
            self.creation_states.export(outfile, level, namespace_, name_='creation_states')
        if self.power_management_states is not None:
            self.power_management_states.export(outfile, level, namespace_, name_='power_management_states')
        if self.host_states is not None:
            self.host_states.export(outfile, level, namespace_, name_='host_states')
        if self.host_non_operational_details is not None:
            self.host_non_operational_details.export(outfile, level, namespace_, name_='host_non_operational_details')
        if self.network_states is not None:
            self.network_states.export(outfile, level, namespace_, name_='network_states')
        if self.storage_domain_states is not None:
            self.storage_domain_states.export(outfile, level, namespace_, name_='storage_domain_states')
        if self.template_states is not None:
            self.template_states.export(outfile, level, namespace_, name_='template_states')
        if self.vm_states is not None:
            self.vm_states.export(outfile, level, namespace_, name_='vm_states')
        if self.vm_pause_details is not None:
            self.vm_pause_details.export(outfile, level, namespace_, name_='vm_pause_details')
        if self.disk_states is not None:
            self.disk_states.export(outfile, level, namespace_, name_='disk_states')
        if self.host_nic_states is not None:
            self.host_nic_states.export(outfile, level, namespace_, name_='host_nic_states')
        if self.data_center_states is not None:
            self.data_center_states.export(outfile, level, namespace_, name_='data_center_states')
        if self.vm_device_types is not None:
            self.vm_device_types.export(outfile, level, namespace_, name_='vm_device_types')
        if self.permits is not None:
            self.permits.export(outfile, level, namespace_, name_='permits')
        if self.scheduling_policies is not None:
            self.scheduling_policies.export(outfile, level, namespace_, name_='scheduling_policies')
        if self.usages is not None:
            self.usages.export(outfile, level, namespace_, name_='usages')
        if self.gluster_volume_types is not None:
            self.gluster_volume_types.export(outfile, level, namespace_, name_='gluster_volume_types')
        if self.transport_types is not None:
            self.transport_types.export(outfile, level, namespace_, name_='transport_types')
        if self.access_protocols is not None:
            self.access_protocols.export(outfile, level, namespace_, name_='access_protocols')
        if self.gluster_volume_states is not None:
            self.gluster_volume_states.export(outfile, level, namespace_, name_='gluster_volume_states')
        if self.brick_states is not None:
            self.brick_states.export(outfile, level, namespace_, name_='brick_states')
    def hasContent_(self):
        if (
            self.current is not None or
            self.features is not None or
            self.cpus is not None or
            self.power_managers is not None or
            self.fence_types is not None or
            self.storage_types is not None or
            self.storage_domain_types is not None or
            self.vm_types is not None or
            self.boot_devices is not None or
            self.display_types is not None or
            self.nic_interfaces is not None or
            self.os_types is not None or
            self.disk_formats is not None or
            self.disk_interfaces is not None or
            self.vm_affinities is not None or
            self.custom_properties is not None or
            self.boot_protocols is not None or
            self.error_handling is not None or
            self.storage_formats is not None or
            self.creation_states is not None or
            self.power_management_states is not None or
            self.host_states is not None or
            self.host_non_operational_details is not None or
            self.network_states is not None or
            self.storage_domain_states is not None or
            self.template_states is not None or
            self.vm_states is not None or
            self.vm_pause_details is not None or
            self.disk_states is not None or
            self.host_nic_states is not None or
            self.data_center_states is not None or
            self.vm_device_types is not None or
            self.permits is not None or
            self.scheduling_policies is not None or
            self.usages is not None or
            self.gluster_volume_types is not None or
            self.transport_types is not None or
            self.access_protocols is not None or
            self.gluster_volume_states is not None or
            self.brick_states is not None or
            super(VersionCaps, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='VersionCaps'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VersionCaps, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VersionCaps, self).exportLiteralChildren(outfile, level, name_)
        if self.current is not None:
            showIndent(outfile, level)
            outfile.write('current=%s,\n' % self.current)
        if self.features is not None:
            showIndent(outfile, level)
            outfile.write('features=model_.Features(\n')
            self.features.exportLiteral(outfile, level, name_='features')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpus is not None:
            showIndent(outfile, level)
            outfile.write('cpus=model_.cpus(\n')
            self.cpus.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.power_managers is not None:
            showIndent(outfile, level)
            outfile.write('power_managers=model_.power_managers(\n')
            self.power_managers.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fence_types is not None:
            showIndent(outfile, level)
            outfile.write('fence_types=model_.fence_types(\n')
            self.fence_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_types is not None:
            showIndent(outfile, level)
            outfile.write('storage_types=model_.storage_types(\n')
            self.storage_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain_types is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_types=model_.storage_domain_types(\n')
            self.storage_domain_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm_types is not None:
            showIndent(outfile, level)
            outfile.write('vm_types=model_.vm_types(\n')
            self.vm_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.boot_devices is not None:
            showIndent(outfile, level)
            outfile.write('boot_devices=model_.boot_devices(\n')
            self.boot_devices.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display_types is not None:
            showIndent(outfile, level)
            outfile.write('display_types=model_.display_types(\n')
            self.display_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.nic_interfaces is not None:
            showIndent(outfile, level)
            outfile.write('nic_interfaces=model_.nic_interfaces(\n')
            self.nic_interfaces.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.os_types is not None:
            showIndent(outfile, level)
            outfile.write('os_types=model_.os_types(\n')
            self.os_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disk_formats is not None:
            showIndent(outfile, level)
            outfile.write('disk_formats=model_.disk_formats(\n')
            self.disk_formats.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disk_interfaces is not None:
            showIndent(outfile, level)
            outfile.write('disk_interfaces=model_.disk_interfaces(\n')
            self.disk_interfaces.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm_affinities is not None:
            showIndent(outfile, level)
            outfile.write('vm_affinities=model_.vm_affinities(\n')
            self.vm_affinities.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.custom_properties is not None:
            showIndent(outfile, level)
            outfile.write('custom_properties=model_.custom_properties(\n')
            self.custom_properties.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.boot_protocols is not None:
            showIndent(outfile, level)
            outfile.write('boot_protocols=model_.boot_protocols(\n')
            self.boot_protocols.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.error_handling is not None:
            showIndent(outfile, level)
            outfile.write('error_handling=model_.error_handling(\n')
            self.error_handling.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_formats is not None:
            showIndent(outfile, level)
            outfile.write('storage_formats=model_.storage_formats(\n')
            self.storage_formats.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.creation_states is not None:
            showIndent(outfile, level)
            outfile.write('creation_states=model_.creation_states(\n')
            self.creation_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.power_management_states is not None:
            showIndent(outfile, level)
            outfile.write('power_management_states=model_.power_management_states(\n')
            self.power_management_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host_states is not None:
            showIndent(outfile, level)
            outfile.write('host_states=model_.host_states(\n')
            self.host_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host_non_operational_details is not None:
            showIndent(outfile, level)
            outfile.write('host_non_operational_details=model_.host_non_operational_details(\n')
            self.host_non_operational_details.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.network_states is not None:
            showIndent(outfile, level)
            outfile.write('network_states=model_.network_states(\n')
            self.network_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain_states is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_states=model_.storage_domain_states(\n')
            self.storage_domain_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template_states is not None:
            showIndent(outfile, level)
            outfile.write('template_states=model_.template_states(\n')
            self.template_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm_states is not None:
            showIndent(outfile, level)
            outfile.write('vm_states=model_.vm_states(\n')
            self.vm_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm_pause_details is not None:
            showIndent(outfile, level)
            outfile.write('vm_pause_details=model_.vm_pause_details(\n')
            self.vm_pause_details.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disk_states is not None:
            showIndent(outfile, level)
            outfile.write('disk_states=model_.disk_states(\n')
            self.disk_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host_nic_states is not None:
            showIndent(outfile, level)
            outfile.write('host_nic_states=model_.host_nic_states(\n')
            self.host_nic_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center_states is not None:
            showIndent(outfile, level)
            outfile.write('data_center_states=model_.data_center_states(\n')
            self.data_center_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm_device_types is not None:
            showIndent(outfile, level)
            outfile.write('vm_device_types=model_.vm_device_types(\n')
            self.vm_device_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.permits is not None:
            showIndent(outfile, level)
            outfile.write('permits=model_.permits(\n')
            self.permits.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scheduling_policies is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policies=model_.scheduling_policies(\n')
            self.scheduling_policies.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.usages is not None:
            showIndent(outfile, level)
            outfile.write('usages=model_.usages(\n')
            self.usages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.gluster_volume_types is not None:
            showIndent(outfile, level)
            outfile.write('gluster_volume_types=model_.gluster_volume_types(\n')
            self.gluster_volume_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.transport_types is not None:
            showIndent(outfile, level)
            outfile.write('transport_types=model_.transport_types(\n')
            self.transport_types.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.access_protocols is not None:
            showIndent(outfile, level)
            outfile.write('access_protocols=model_.access_protocols(\n')
            self.access_protocols.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.gluster_volume_states is not None:
            showIndent(outfile, level)
            outfile.write('gluster_volume_states=model_.gluster_volume_states(\n')
            self.gluster_volume_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.brick_states is not None:
            showIndent(outfile, level)
            outfile.write('brick_states=model_.brick_states(\n')
            self.brick_states.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VersionCaps, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'current':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'current')
            self.current = ival_
        elif nodeName_ == 'features':
            obj_ = Features.factory()
            obj_.build(child_)
            self.set_features(obj_)
        elif nodeName_ == 'cpus':
            obj_ = CPUs.factory()
            obj_.build(child_)
            self.set_cpus(obj_)
        elif nodeName_ == 'power_managers':
            obj_ = PowerManagers.factory()
            obj_.build(child_)
            self.set_power_managers(obj_)
        elif nodeName_ == 'fence_types':
            obj_ = FenceTypes.factory()
            obj_.build(child_)
            self.set_fence_types(obj_)
        elif nodeName_ == 'storage_types':
            obj_ = StorageTypes.factory()
            obj_.build(child_)
            self.set_storage_types(obj_)
        elif nodeName_ == 'storage_domain_types':
            obj_ = StorageDomainTypes.factory()
            obj_.build(child_)
            self.set_storage_domain_types(obj_)
        elif nodeName_ == 'vm_types':
            obj_ = VmTypes.factory()
            obj_.build(child_)
            self.set_vm_types(obj_)
        elif nodeName_ == 'boot_devices':
            obj_ = BootDevices.factory()
            obj_.build(child_)
            self.set_boot_devices(obj_)
        elif nodeName_ == 'display_types':
            obj_ = DisplayTypes.factory()
            obj_.build(child_)
            self.set_display_types(obj_)
        elif nodeName_ == 'nic_interfaces':
            obj_ = NicInterfaces.factory()
            obj_.build(child_)
            self.set_nic_interfaces(obj_)
        elif nodeName_ == 'os_types':
            obj_ = OsTypes.factory()
            obj_.build(child_)
            self.set_os_types(obj_)
        elif nodeName_ == 'disk_formats':
            obj_ = DiskFormats.factory()
            obj_.build(child_)
            self.set_disk_formats(obj_)
        elif nodeName_ == 'disk_interfaces':
            obj_ = DiskInterfaces.factory()
            obj_.build(child_)
            self.set_disk_interfaces(obj_)
        elif nodeName_ == 'vm_affinities':
            obj_ = VmAffinities.factory()
            obj_.build(child_)
            self.set_vm_affinities(obj_)
        elif nodeName_ == 'custom_properties':
            obj_ = CustomProperties.factory()
            obj_.build(child_)
            self.set_custom_properties(obj_)
        elif nodeName_ == 'boot_protocols':
            obj_ = BootProtocols.factory()
            obj_.build(child_)
            self.set_boot_protocols(obj_)
        elif nodeName_ == 'error_handling':
            obj_ = ErrorHandlingOptions.factory()
            obj_.build(child_)
            self.set_error_handling(obj_)
        elif nodeName_ == 'storage_formats':
            obj_ = StorageFormats.factory()
            obj_.build(child_)
            self.set_storage_formats(obj_)
        elif nodeName_ == 'creation_states':
            obj_ = CreationStates.factory()
            obj_.build(child_)
            self.set_creation_states(obj_)
        elif nodeName_ == 'power_management_states':
            obj_ = PowerManagementStates.factory()
            obj_.build(child_)
            self.set_power_management_states(obj_)
        elif nodeName_ == 'host_states':
            obj_ = HostStates.factory()
            obj_.build(child_)
            self.set_host_states(obj_)
        elif nodeName_ == 'host_non_operational_details':
            obj_ = HostNonOperationalDetails.factory()
            obj_.build(child_)
            self.set_host_non_operational_details(obj_)
        elif nodeName_ == 'network_states':
            obj_ = NetworkStates.factory()
            obj_.build(child_)
            self.set_network_states(obj_)
        elif nodeName_ == 'storage_domain_states':
            obj_ = StorageDomainStates.factory()
            obj_.build(child_)
            self.set_storage_domain_states(obj_)
        elif nodeName_ == 'template_states':
            obj_ = TemplateStates.factory()
            obj_.build(child_)
            self.set_template_states(obj_)
        elif nodeName_ == 'vm_states':
            obj_ = VmStates.factory()
            obj_.build(child_)
            self.set_vm_states(obj_)
        elif nodeName_ == 'vm_pause_details':
            obj_ = VmPauseDetails.factory()
            obj_.build(child_)
            self.set_vm_pause_details(obj_)
        elif nodeName_ == 'disk_states':
            obj_ = DiskStates.factory()
            obj_.build(child_)
            self.set_disk_states(obj_)
        elif nodeName_ == 'host_nic_states':
            obj_ = HostNICStates.factory()
            obj_.build(child_)
            self.set_host_nic_states(obj_)
        elif nodeName_ == 'data_center_states':
            obj_ = DataCenterStates.factory()
            obj_.build(child_)
            self.set_data_center_states(obj_)
        elif nodeName_ == 'vm_device_types':
            obj_ = VmDeviceTypes.factory()
            obj_.build(child_)
            self.set_vm_device_types(obj_)
        elif nodeName_ == 'permits':
            obj_ = Permits.factory()
            obj_.build(child_)
            self.set_permits(obj_)
        elif nodeName_ == 'scheduling_policies':
            obj_ = SchedulingPolicies.factory()
            obj_.build(child_)
            self.set_scheduling_policies(obj_)
        elif nodeName_ == 'usages':
            obj_ = Usages.factory()
            obj_.build(child_)
            self.set_usages(obj_)
        elif nodeName_ == 'gluster_volume_types':
            obj_ = GlusterVolumeTypes.factory()
            obj_.build(child_)
            self.set_gluster_volume_types(obj_)
        elif nodeName_ == 'transport_types':
            obj_ = TransportTypes.factory()
            obj_.build(child_)
            self.set_transport_types(obj_)
        elif nodeName_ == 'access_protocols':
            obj_ = AccessProtocols.factory()
            obj_.build(child_)
            self.set_access_protocols(obj_)
        elif nodeName_ == 'gluster_volume_states':
            obj_ = GlusterStates.factory()
            obj_.build(child_)
            self.set_gluster_volume_states(obj_)
        elif nodeName_ == 'brick_states':
            obj_ = GlusterStates.factory()
            obj_.build(child_)
            self.set_brick_states(obj_)
        super(VersionCaps, self).buildChildren(child_, node, nodeName_, True)
# end class VersionCaps


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    #rootClass = globals().get(tag)
    # Begin NOT_GENERATED
    # The api XSD does not define a single root tag.
    # We need to map the classes in this file to the possible
    # element roots in the XSD.
    # rootClass = globals().get(tag)
    rootClass = findRootClass(tag)
    # End NOT_GENERATED
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'keyValuePair'
        rootClass = KeyValuePair
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag, 
        namespacedef_='')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'link'
        rootClass = Link
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    # Begin NOT_GENERATED
    # Let's shut up the echoing of the received XML
    # to stdout.
    #sys.stdout.write('<?xml version="1.0" ?>\n')
    #rootObj.export(sys.stdout, 0, name_="link",
    #    namespacedef_='')
    # End NOT_GENERATED
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'keyValuePair'
        rootClass = KeyValuePair
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from params import *\n\n')
    sys.stdout.write('import params as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "API",
    "AccessControlList",
    "AccessProtocols",
    "Action",
    "ActionableResource",
    "Actions",
    "ApiSummary",
    "BaseDevice",
    "BaseDevices",
    "BaseResource",
    "BaseResources",
    "Body",
    "Bonding",
    "Boot",
    "BootDevices",
    "BootProtocols",
    "CPU",
    "CPUs",
    "Capabilities",
    "CdRom",
    "CdRoms",
    "Certificate",
    "Cluster",
    "Clusters",
    "CpuTopology",
    "CpuTune",
    "Creation",
    "CreationStates",
    "CustomProperties",
    "CustomProperty",
    "DataCenter",
    "DataCenterStates",
    "DataCenters",
    "DetailedLink",
    "DetailedLinks",
    "Disk",
    "DiskFormats",
    "DiskInterfaces",
    "DiskStates",
    "Disks",
    "Display",
    "DisplayTypes",
    "Domain",
    "Domains",
    "ErrorHandling",
    "ErrorHandlingOptions",
    "Event",
    "Events",
    "Fault",
    "Features",
    "FenceTypes",
    "File",
    "Files",
    "Floppies",
    "Floppy",
    "GlusterBrick",
    "GlusterBricks",
    "GlusterStates",
    "GlusterVolume",
    "GlusterVolumeTypes",
    "GlusterVolumes",
    "GracePeriod",
    "Group",
    "Groups",
    "GuestInfo",
    "Header",
    "Headers",
    "HighAvailability",
    "Host",
    "HostNIC",
    "HostNICStates",
    "HostNics",
    "HostNonOperationalDetails",
    "HostStates",
    "HostStorage",
    "Hosts",
    "IP",
    "IPs",
    "IscsiDetails",
    "KSM",
    "KeyValuePair",
    "Link",
    "LinkCapabilities",
    "LogicalUnit",
    "MAC",
    "MemoryOverCommit",
    "MemoryPolicy",
    "NIC",
    "Network",
    "NetworkStates",
    "Networks",
    "NicInterfaces",
    "Nics",
    "OperatingSystem",
    "Option",
    "Options",
    "OsTypes",
    "Parameter",
    "ParametersSet",
    "Payload",
    "PayloadFile",
    "Payloads",
    "Permission",
    "Permissions",
    "Permit",
    "Permits",
    "PortMirroring",
    "PowerManagement",
    "PowerManagementStates",
    "PowerManagers",
    "PreviewVMs",
    "ProductInfo",
    "Quota",
    "Quotas",
    "RSDL",
    "Request",
    "Response",
    "Role",
    "Roles",
    "SchedulingPolicies",
    "SchedulingPolicy",
    "SchedulingPolicyThresholds",
    "Schema",
    "Slaves",
    "Snapshot",
    "Snapshots",
    "SpecialObjects",
    "Statistic",
    "Statistics",
    "Status",
    "Storage",
    "StorageDomain",
    "StorageDomainStates",
    "StorageDomainTypes",
    "StorageDomains",
    "StorageFormats",
    "StorageManager",
    "StorageTypes",
    "SupportedVersions",
    "Tag",
    "TagParent",
    "Tags",
    "Template",
    "TemplateStates",
    "Templates",
    "Ticket",
    "TransparentHugePages",
    "TransportTypes",
    "Url",
    "Usages",
    "Usb",
    "User",
    "Users",
    "VCpuPin",
    "VLAN",
    "VM",
    "VMs",
    "Value",
    "Values",
    "Version",
    "VersionCaps",
    "VmAffinities",
    "VmDeviceTypes",
    "VmPauseDetails",
    "VmPlacementPolicy",
    "VmPool",
    "VmPools",
    "VmStates",
    "VmSummary",
    "VmTypes",
    "VolumeGroup"
    ]

# Begin NOT_GENERATED

_rootClassMap = {
                    "access_control_list"           : AccessControlList,
                    "access_protocols"              : AccessProtocols,
                    "action"                        : Action,
                    "actions"                       : Actions,
                    "api"                           : API,
                    "body"                          : Body,
                    "bonding"                       : Bonding,
                    "boot"                          : Boot,
                    "boot_devices"                  : BootDevices,
                    "boot_protocols"                : BootProtocols,
                    "brick"                         : GlusterBrick,
                    "brick_states"                  : GlusterStates,
                    "bricks"                        : GlusterBricks,
                    "capabilities"                  : Capabilities,
                    "cdrom"                         : CdRom,
                    "cdroms"                        : CdRoms,
                    "certificate"                   : Certificate,
                    "cluster"                       : Cluster,
                    "clusters"                      : Clusters,
                    "cpu"                           : CPU,
                    "cpu_tune"                      : CpuTune,
                    "cpus"                          : CPUs,
                    "creation"                      : Creation,
                    "creation_states"               : CreationStates,
                    "creation_status"               : Status,
                    "custom_properties"             : CustomProperties,
                    "custom_property"               : CustomProperty,
                    "data_center"                   : DataCenter,
                    "data_center_states"            : DataCenterStates,
                    "data_centers"                  : DataCenters,
                    "detailedLinks"                 : DetailedLinks,
                    "disk"                          : Disk,
                    "disk_formats"                  : DiskFormats,
                    "disk_interfaces"               : DiskInterfaces,
                    "disk_states"                   : DiskStates,
                    "disks"                         : Disks,
                    "display"                       : Display,
                    "display_types"                 : DisplayTypes,
                    "domain"                        : Domain,
                    "domains"                       : Domains,
                    "error_handling"                : ErrorHandling,
                    "event"                         : Event,
                    "events"                        : Events,
                    "fault"                         : Fault,
                    "features"                      : Features,
                    "fence_types"                   : FenceTypes,
                    "file"                          : File,
                    "files"                         : Files,
                    "floppies"                      : Floppies,
                    "floppy"                        : Floppy,
                    "gluster_volume"                : GlusterVolume,
                    "gluster_volume_states"         : GlusterStates,
                    "gluster_volume_types"          : GlusterVolumeTypes,
                    "gluster_volumes"               : GlusterVolumes,
                    "grace_period"                  : GracePeriod,
                    "group"                         : Group,
                    "groups"                        : Groups,
                    "guest_info"                    : GuestInfo,
                    "header"                        : Header,
                    "headers"                       : Headers,
                    "high_availability"             : HighAvailability,
                    "host"                          : Host,
                    "host_nic"                      : HostNIC,
                    "host_nic_states"               : HostNICStates,
                    "host_nics"                     : HostNics,
                    "host_non_operational_details"  : HostNonOperationalDetails,
                    "host_states"                   : HostStates,
                    "host_storage"                  : HostStorage,
                    "hosts"                         : Hosts,
                    "ip"                            : IP,
                    "ips"                           : IPs,
                    "iscsi"                         : IscsiDetails,
                    "keyValuePair"                  : KeyValuePair,
                    "ksm"                           : KSM,
                    "link"                          : Link,
                    "linkCapabilities"              : LinkCapabilities,
                    "links"                         : DetailedLinks,
                    "logical_unit"                  : LogicalUnit,
                    "lunStorage"                    : Storage,
                    "mac"                           : MAC,
                    "memory_policy"                 : MemoryPolicy,
                    "network"                       : Network,
                    "network_states"                : NetworkStates,
                    "networks"                      : Networks,
                    "nic"                           : NIC,
                    "nic_interfaces"                : NicInterfaces,
                    "nics"                          : Nics,
                    "option"                        : Option,
                    "options"                       : Options,
                    "os"                            : OperatingSystem,
                    "os_types"                      : OsTypes,
                    "overcommit"                    : MemoryOverCommit,
                    "parameter"                     : Parameter,
                    "parameters_set"                : ParametersSet,
                    "parent"                        : TagParent,
                    "payload"                       : Payload,
                    "payload_file"                  : PayloadFile,
                    "payloads"                      : Payloads,
                    "permission"                    : Permission,
                    "permissions"                   : Permissions,
                    "permit"                        : Permit,
                    "permits"                       : Permits,
                    "placement_policy"              : VmPlacementPolicy,
                    "port_mirroring"                : PortMirroring,
                    "power_management"              : PowerManagement,
                    "power_management_states"       : PowerManagementStates,
                    "power_managers"                : PowerManagers,
                    "preview_vm"                    : VM,
                    "preview_vms"                   : PreviewVMs,
                    "product_info"                  : ProductInfo,
                    "quota"                         : Quota,
                    "quotas"                        : Quotas,
                    "request"                       : Request,
                    "response"                      : Response,
                    "role"                          : Role,
                    "roles"                         : Roles,
                    "rsdl"                          : RSDL,
                    "scheduling_policies"           : SchedulingPolicies,
                    "scheduling_policy"             : SchedulingPolicy,
                    "schema"                        : Schema,
                    "slaves"                        : Slaves,
                    "snapshot"                      : Snapshot,
                    "snapshots"                     : Snapshots,
                    "special_objects"               : SpecialObjects,
                    "statistic"                     : Statistic,
                    "statistics"                    : Statistics,
                    "status"                        : Status,
                    "storage"                       : Storage,
                    "storage_domain"                : StorageDomain,
                    "storage_domain_states"         : StorageDomainStates,
                    "storage_domain_types"          : StorageDomainTypes,
                    "storage_domains"               : StorageDomains,
                    "storage_formats"               : StorageFormats,
                    "storage_manager"               : StorageManager,
                    "storage_types"                 : StorageTypes,
                    "summary"                       : ApiSummary,
                    "supported_versions"            : SupportedVersions,
                    "system_version"                : Version,
                    "tag"                           : Tag,
                    "tags"                          : Tags,
                    "template"                      : Template,
                    "template_states"               : TemplateStates,
                    "templates"                     : Templates,
                    "thresholds"                    : SchedulingPolicyThresholds,
                    "ticket"                        : Ticket,
                    "topology"                      : CpuTopology,
                    "transparent_hugepages"         : TransparentHugePages,
                    "transport_types"               : TransportTypes,
                    "url"                           : Url,
                    "usages"                        : Usages,
                    "usb"                           : Usb,
                    "user"                          : User,
                    "users"                         : Users,
                    "value"                         : Value,
                    "values"                        : Values,
                    "vcpu_pin"                      : VCpuPin,
                    "version"                       : VersionCaps,
                    "vlan"                          : VLAN,
                    "vm"                            : VM,
                    "vm_affinities"                 : VmAffinities,
                    "vm_device_types"               : VmDeviceTypes,
                    "vm_pause_details"              : VmPauseDetails,
                    "vm_states"                     : VmStates,
                    "vm_types"                      : VmTypes,
                    "vmpool"                        : VmPool,
                    "vmpools"                       : VmPools,
                    "vms"                           : VMs,
                    "volume_group"                  : VolumeGroup,
                }


def findRootClass(rootTag):
    """
    Helper function that enables the generated code to locate the
    root element.  The api does not explicitly list a root
    element; hence, the generated code has a hard time deducing
    which one it actually is.  This function will map the first
    tag in the XML (i.e. the root) to an internal class.
    """
    return _rootClassMap.get(rootTag)

# End NOT_GENERATED