#
# Copyright (c) 2010 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


from codegen.utils.typeutil import TypeUtil
from codegen.doc.documentation import Documentation
from codegen.utils.paramutils import ParamUtils
from codegen.utils.headerutils import HeaderUtils

#============================================================
#===========================RESOURCE=========================
#============================================================

class Resource(object):
    SUB_COLLECTIONS_FIXME = "        #SUB_COLLECTIONS"

    @staticmethod
    def resource(xml_entity, sub_collections=[], KNOWN_WRAPPER_TYPES={}):
        actual_xml_entity = TypeUtil.getValueByKeyOrNone(xml_entity.lower(), KNOWN_WRAPPER_TYPES)

        resource_template_values = {'xml_entity': actual_xml_entity if actual_xml_entity is not None else xml_entity,
                                    'xml_entity_lc':xml_entity.lower(),
                                    'sub_collections':sub_collections}

        resource_template = \
        (
        "class %(xml_entity)s(params.%(xml_entity)s, Base):\n" + \
        "    def __init__(self, %(xml_entity_lc)s, context):\n" + \
        "        Base.__init__(self, context)\n" + \
        "        self.superclass = %(xml_entity_lc)s\n\n" + \
        Resource.SUB_COLLECTIONS_FIXME + "\n" + \

        "    def __new__(cls, %(xml_entity_lc)s, context):\n" + \
        "        if %(xml_entity_lc)s is None: return None\n" + \
        "        obj = object.__new__(cls)\n" + \
        "        obj.__init__(%(xml_entity_lc)s, context)\n" + \
        "        return obj\n\n" + \

        "    def __getProxy(self):\n" + \
        "        proxy = context.manager[self.context].get('proxy')\n" + \
        "        if proxy:\n" + \
        "            return proxy\n" + \
        "        #This may happen only if sdk was explicitly disconnected\n" + \
        "        #using .disconnect() method, but resource instance ref. is\n" + \
        "        #still available at client's code.\n" + \
        "        raise DisconnectedError\n\n"
        ) % resource_template_values

        return resource_template

    @staticmethod
    def addSubCollectionInstances(parent, sub_collections={}):
        tmpl = "        self.%s = %s(%s, context)\n"

        new_tmpl = ''
        for k, v in sub_collections.items():
            new_tmpl += tmpl % (k.lower(), v, parent)

        return new_tmpl

    @staticmethod
    def action(url, body_type, link, action_name, resource_name_lc, method, action_params={}):
        resource_action_template_values = {'url':url,
                                           'body_type':body_type,
                                           'body_type_lc':body_type.lower(),
                                           'action_name':action_name.lower(),
                                           'method': method,
                                           'resource_name_lc':resource_name_lc.lower(),
                                           'method_params': Resource._addMethodParams(action_params.keys()),
                                           'action_params':Resource._addActionParams(action_params)}
        headers_method_params_str, headers_map_params_str = HeaderUtils.generate_method_params(link)
        headers_method_params_str = ', ' + headers_method_params_str if headers_method_params_str != '' else headers_method_params_str

        resource_action_template = \
        ("    def %(action_name)s(self%(method_params)s, %(body_type_lc)s=params.%(body_type)s()" + headers_method_params_str + "):\n" + \
         Documentation.document(link) +
        "        url = '%(url)s'\n\n" + \
        "        result = self.__getProxy().request(method='%(method)s',\n" + \
        "                                           url=UrlHelper.replace(url, {'{%(resource_name_lc)s:id}': self.get_id()}),\n" + \
        "                                           body=ParseHelper.toXml(%(body_type_lc)s),\n"
        "                                           headers=" + headers_map_params_str + ")\n" + \
        "        return result\n\n"
        ) % resource_action_template_values

        return resource_action_template

    @staticmethod
    def _addActionParams(kwargs={}):
        res = ''
        for k, v in kwargs.items():
            res += "        action." + k + "=" + v + "\n"
        return res

    @staticmethod
    def _addMethodParams(params=[]):
        res = ''
        for item in params:
            res += ', ' + item
        return res

    @staticmethod
    def delete(url, body_type, link, resource_name):
        resource_delete_template_values = {'url':url,
                                           'body_type':body_type,
                                           'body_type_lc':body_type.lower() if body_type is not None
                                                                            else None,
                                           'resource_name_lc':resource_name.lower()}

        prms_str, method_params, url_params = ParamUtils.getMethodParamsByUrlParamsMeta(link)
        headers_method_params_str, headers_map_params_str = HeaderUtils.generate_method_params(link)
        combined_method_params = prms_str + \
                         (', ' if prms_str != '' and headers_method_params_str != '' else '') + \
                         headers_method_params_str
        headers_map_params_str_with_no_ct = headers_map_params_str.replace('}',
                                                                          ',"Content-type":None}') \
                                                                 if headers_map_params_str != '{}' \
                                                                 else '{"Content-type":None}'
        body_instance = ParamUtils.getBodyInstance(link)
        body_instance_str = '=' + body_instance if body_instance else ''

        if prms_str != '' or headers_method_params_str != '':
            resource_delete_template = \
            ("    def delete(self, " + combined_method_params + "):\n" + \
             Documentation.document(link, {}, method_params) +
            "        url = UrlHelper.replace('%(url)s',\n" + \
            "                                {'{%(resource_name_lc)s:id}': self.get_id()})\n\n" + \
            "        return self.__getProxy().delete(url=SearchHelper.appendQuery(url, " +
            ParamUtils.toDictStr(url_params.keys(), method_params.copy().keys()) +
                                                                                "),\n" +
            "                                       headers=" + headers_map_params_str_with_no_ct + ")\n\n"
            ) % resource_delete_template_values


            body_resource_delete_template = \
            ("    def delete(self, %(body_type_lc)s" + body_instance_str + ", " + combined_method_params + "):\n" + \
             Documentation.document(link, {}, method_params) +
            "        url = UrlHelper.replace('%(url)s',\n" + \
            "                                {'{%(resource_name_lc)s:id}': self.get_id()})\n\n" + \
            "        return self.__getProxy().delete(url=SearchHelper.appendQuery(url, " + ParamUtils.toDictStr(url_params.keys(),
                                                                                                               method_params.copy().keys()) +
                                                                                "),\n" + \
            "                                        body=ParseHelper.toXml(%(body_type_lc)s),\n" +
            "                                        headers=" + headers_map_params_str + ")\n\n"
            ) % resource_delete_template_values
        else:
            resource_delete_template = \
            ("    def delete(self):\n" + \
             Documentation.document(link) +
            "        url = '%(url)s'\n\n" + \
            "        return self.__getProxy().delete(url=UrlHelper.replace(url, {'{%(resource_name_lc)s:id}': self.get_id()}),\n" +
            "                                        headers={'Content-type':None})\n\n"
            ) % resource_delete_template_values


            body_resource_delete_template = \
            ("    def delete(self, %(body_type_lc)s" + body_instance_str + "):\n" + \
             Documentation.document(link) +
            "        url = '%(url)s'\n\n" + \
            "        return self.__getProxy().delete(url=UrlHelper.replace(url, {'{%(resource_name_lc)s:id}': self.get_id()}),\n" + \
            "                                        body=ParseHelper.toXml(%(body_type_lc)s))\n\n"
            ) % resource_delete_template_values

        if not body_type:
            return resource_delete_template
        else:
            return body_resource_delete_template

    @staticmethod
    def update(url, resource_name, link, KNOWN_WRAPPER_TYPES={}):

        actual_xml_entity = TypeUtil.getValueByKeyOrNone(resource_name.lower(), KNOWN_WRAPPER_TYPES)

        resource_update_template_values = {'url':url,
                                           'resource_name_lc':resource_name.lower(),
                                           'actual_self_name':actual_xml_entity if actual_xml_entity is not None else resource_name}
        headers_method_params_str, headers_map_params_str = HeaderUtils.generate_method_params(link)
        headers_method_params_str = ', ' + headers_method_params_str if headers_method_params_str != '' else headers_method_params_str

        resource_update_template = \
        ("    def update(self" + headers_method_params_str + "):\n" + \
         Documentation.document(link) +
        "        url = '%(url)s'\n\n" + \
        "        result = self.__getProxy().update(url=UrlHelper.replace(url, {'{%(resource_name_lc)s:id}': self.get_id()}),\n" + \
        "                                          body=ParseHelper.toXml(self.superclass),\n" +
        "                                          headers=" + headers_map_params_str + ")\n" + \
        "        return %(actual_self_name)s(result, self.context)\n\n") % resource_update_template_values

        return resource_update_template
