#
# ovirt-host-deploy -- ovirt host deployer
# Copyright (C) 2012 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.0.0_beta
%global		package_maven_version 1.0.0-beta
%global		ovirt_host_deploy_root %{_datadir}/%{name}/interface-3

%if 0%{?rhel:1}
%global		maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy
%endif

Summary:	oVirt host deploy tool
Name:		ovirt-host-deploy
Version:	1.0.0
Release:	0.1.beta%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/releases/stable/3.2/%{name}-%{package_version}.tar.gz
Group:		Applications/System

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch

Requires:	python
Requires:	otopi
BuildRequires:	otopi-devel
BuildRequires:	python2-devel
BuildRequires:	gettext-devel

BuildRequires:	java-devel
BuildRequires:	jpackage-utils

%if 0%{?fedora:1}
BuildRequires:	maven
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-source-plugin
%endif

%description
Host deployment tool for oVirt project.

%package java
Summary:	%{name} java support
Requires:	%{name} = %{version}-%{release}
Requires:	java
Requires:	jpackage-utils
Requires:	otopi-java
%description java
java libraries.

%if 0%{?fedora:1}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation
Requires:	jpackage-utils

%description javadoc
This package contains the API documentation for %{name}.
%endif

%package offline
Summary:	ovirt-host-deploy offline dependencies
Requires:	dmidecode
Requires:	iproute
Requires:	libselinux-python
Requires:	m2crypto
Requires:	python
Requires:	tuned
Requires:	util-linux
Requires:	vdsm
Requires:	vdsm-cli
%description offline
meta package for offline setup

%if 0%{?rhel:1}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if 0%{?fedora:1}
%global conf --disable-java-sdk-compile
%endif
%configure \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	--enable-java-sdk \
	%{?conf}
make %{?_smp_mflags}

%if 0%{?fedora:1}
cd src/java
mvn-rpmbuild install javadoc:aggregate
cd ../..
%endif

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if 0%{?fedora:1}
install -d -m 755 "%{buildroot}%{_javadir}/%{name}"
install -d -m 755 "%{buildroot}%{_mavenpomdir}"
install -pm 644 src/java/target/%{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}
ln -s "%{name}-%{package_maven_version}.jar" "%{buildroot}%{_javadir}/%{name}/%{name}.jar"
install -pm 644 "src/java/pom.xml" "%{buildroot}%{_mavenpomdir}/JPP.%{name}-%{name}.pom"
%add_maven_depmap "JPP.%{name}-%{name}.pom" "%{name}/%{name}.jar"

mkdir -p "%{buildroot}%{_javadocdir}/%{name}"
cp -rp src/java/target/apidocs/*  "%{buildroot}%{_javadocdir}/%{name}"
%else
install -d "%{buildroot}%{_javadir}/%{name}"
install target/%{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}
ln -s %{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}/%{name}.jar
%endif

install -d -m 755 "%{buildroot}%{_sysconfdir}/%{name}.conf.d"
install -pm 644 conf.d/50-offline-packager.conf "%{buildroot}%{_sysconfdir}/%{name}.conf.d"

%if 0%{?rhel:1}
install -d "%{buildroot}%{maven2brewrepodir}"
cp "%{buildroot}%{_javadir}/%{name}/%{name}.jar" "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.jar"
cp src/java/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.pom"
%endif

%post java
%if 0%{?fedora:1}
%update_maven_depmap
%endif

%postun java
%if 0%{?fedora:1}
%update_maven_depmap
%endif

%files
%doc AUTHORS
%doc COPYING
%doc README
%doc README.environment
%{_sbindir}/%{name}
%dir %{python_sitelib}/ovirt_host_deploy
%{python_sitelib}/ovirt_host_deploy/*.py*
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/plugins/%{name}/*/*.py*
%{_datadir}/%{name}/plugins/%{name}/*/*.rules
%{_datadir}/%{name}/plugins/%{name}/*/*/.keep
%{_datadir}/otopi/plugins/%{name}
#%{_datadir}/locale/*/*/%{name}.mo
%{ovirt_host_deploy_root}/.bundled
%{ovirt_host_deploy_root}/setup
%{ovirt_host_deploy_root}/ovirt-host-deploy
%{ovirt_host_deploy_root}/otopi
%{ovirt_host_deploy_root}/pythonlib/otopi
%{ovirt_host_deploy_root}/pythonlib/ovirt_host_deploy
%{ovirt_host_deploy_root}/otopi-plugins
#%{ovirt_host_deploy_root}/locale/*/*/*.mo

%files java
%{_javadir}/%{name}/%{name}*.jar
%if 0%{?fedora:1}
%{_mavenpomdir}/JPP.%{name}-%{name}.pom
%{_mavendepmapfragdir}/%{name}
%endif

%if 0%{?fedora:1}
%files javadoc
%{_javadocdir}/%{name}
%endif

%files offline
%{_sysconfdir}/%{name}.conf.d/50-offline-packager.conf

%if 0%{?rhel:1}
%files repolib
%{maven2brewrepodir}/*
%endif

%changelog
* Tue Oct 13 2012 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-0.1_beta
- Initial add.
