#
# ovirt-hosted-engine-setup -- ovirt hosted engine setup
# Copyright (C) 2012-2014 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global         engine ovirt-engine
%global         package_version 1.0.0
%global         package_maven_version 1.0.0
%global         ovirt_hosted_engine_setup_templates %{_datadir}/%{name}/templates
%global         ovirt_hosted_engine_setup_scripts %{_datadir}/%{name}/scripts
%global         vdsmhooksdir %{_libexecdir}/vdsm/hooks


Summary:        oVirt hosted engine setup tool
Name:           ovirt-hosted-engine-setup
Version:        1.0.0
Release:        1%{?release_suffix}%{?dist}
License:        LGPLv2+
URL:            http://www.ovirt.org
Source:         http://resources.ovirt.org/releases/stable/src/%{name}-%{package_version}.tar.gz
Group:          Applications/System

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

Requires:       python
Requires:       python-ethtool >= 0.6-3
Requires:       otopi >= 1.1.0
Requires:       vdsm >= 4.12.2
Requires:       vdsm-cli >= 4.12.2
Requires:       vdsm-python >= 4.12.2
Requires:       ovirt-host-deploy >= 1.1.0
Requires:       openssh-server
Requires:       python-paramiko
Requires:       virt-viewer
Requires:       openssl
Requires:       sudo
Requires:       bind-utils
Requires:       ovirt-hosted-engine-ha >= 1.0.0
Requires:       sanlock >= 2.8
Requires:       sanlock-python >= 2.8
Requires:       lsof
Requires:       iptables
BuildRequires:  gettext
BuildRequires:  otopi-devel >= 1.1.0
BuildRequires:  python2-devel

Requires:       %{engine}-sdk-python >= 3.3.0.4
Requires:       qemu-img

%description
Hosted engine tool for oVirt project.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_docdir}/%{name}-%{version}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc COPYING
%doc README
%dir %{_sysconfdir}/ovirt-hosted-engine-setup.env.d
%dir %{_sysconfdir}/ovirt-hosted-engine
%dir %{_localstatedir}/log/ovirt-hosted-engine-setup
%{_sbindir}/hosted-engine
%{_sbindir}/%{name}
%{python_sitelib}/ovirt_hosted_engine_setup/
%{_datadir}/%{name}/
%{_mandir}/man8/*

#move to a separate package?
%{vdsmhooksdir}/before_vm_start/

%changelog
* Mon Mar 10 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-1
- 1.0.0-1

* Tue Dec 17 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.12.beta7:
- 1.0.0-0.12.beta7
- Resolves: BZ#1034777
- Resolves: BZ#1013666
- Resolves: BZ#1035484
- Resolves: BZ#1041203
- Resolves: BZ#1034821

* Tue Dec 10 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.11.beta6:
- 1.0.0-0.11.beta6
- Resolves: BZ#1034873
- Resolves: BZ#1034706
- Resolves: BZ#1038626
- Resolves: BZ#1034323

* Tue Dec  3 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.10.beta5:
- 1.0.0-0.10.beta5
- Resolves: BZ#1031993
- Resolves: BZ#1034802
- Resolves: BZ#1034786
- Resolves: BZ#1026344
- Resolves: BZ#1034850
- Resolves: BZ#1034646
- Resolves: BZ#1021902

* Tue Nov 19 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.9.beta4:
- 1.0.0-0.9.beta4
- Resolves: BZ#1030437
- Resolves: BZ#1031510
- Resolves: BZ#1028752
- Resolves: BZ#1029323
- Resolves: BZ#1032467

* Tue Nov  5 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.8.beta3:
- 1.0.0-0.8.beta3
- Resolves: BZ#1023963
- Resolves: BZ#1026351
- Resolves: BZ#1025350
- Resolves: BZ#1025259
- Resolves: BZ#1025253

* Tue Oct 29 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.7.beta2:
- 1.0.0-0.7.beta2
- Resolves: BZ#1020858
- Resolves: BZ#1023962
- Resolves: BZ#1010980

* Tue Oct 15 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.6.beta1:
- 1.0.0-0.6.beta1
- Resolves: BZ#1015136
- Resolves: BZ#1014616
- Resolves: BZ#1013662
- Resolves: BZ#1014004
- Resolves: BZ#1013557
- Resolves: BZ#1001706
- Resolves: BZ#1007422

* Fri Sep 27 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.5.beta1:
- 1.0.0-0.5.beta1
- Resolves: BZ#1007422
- Resolves: BZ#1012417
- Resolves: BZ#1010889
- Resolves: BZ#1011031
- Resolves: BZ#1010866
- Resolves: BZ#1008391
- Resolves: BZ#1008501

* Fri Sep 13 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.4.beta:
- 1.0.0-0.4.beta
- Resolves: BZ#1005767
- Resolves: BZ#1001726
- Resolves: BZ#1001706

* Tue Sep  3 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.3.beta
- 1.0.0-0.3.beta
- Resolves: BZ#1001161

* Wed Aug 14 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.2.beta
- 1.0.0-0.2.beta
- Resolves: BZ#999865
- Resolves: BZ#999577
- Resolves: BZ#999542

* Wed Aug 14 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.1.beta
- 1.0.0-0.1.beta

* Fri May 31 2013 Yedidyah Bar David <didi@redhat.com> - 0.0.0-0.0.master
- Initial add.
