/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlLinkLayerDiscoveryProtocolElementReader;
import org.ovirt.engine.sdk4.services.LinkLayerDiscoveryProtocolService;
import org.ovirt.engine.sdk4.types.LinkLayerDiscoveryProtocolElement;

public class LinkLayerDiscoveryProtocolServiceImpl
extends ServiceImpl
implements LinkLayerDiscoveryProtocolService {
    public LinkLayerDiscoveryProtocolServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public LinkLayerDiscoveryProtocolService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "LinkLayerDiscoveryProtocolService:" + this.getPath();
    }

    private class ListResponseImpl
    implements LinkLayerDiscoveryProtocolService.ListResponse {
        private List<LinkLayerDiscoveryProtocolElement> elements;

        private ListResponseImpl() {
        }

        public void elements(List<LinkLayerDiscoveryProtocolElement> elements) {
            this.elements = elements;
        }

        @Override
        public List<LinkLayerDiscoveryProtocolElement> elements() {
            return this.elements;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<LinkLayerDiscoveryProtocolService.ListRequest, LinkLayerDiscoveryProtocolService.ListResponse>
    implements LinkLayerDiscoveryProtocolService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public LinkLayerDiscoveryProtocolService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public LinkLayerDiscoveryProtocolService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(LinkLayerDiscoveryProtocolServiceImpl.this.getConnection().getUrl() + LinkLayerDiscoveryProtocolServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = LinkLayerDiscoveryProtocolServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.elements(XmlLinkLayerDiscoveryProtocolElementReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            LinkLayerDiscoveryProtocolServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

