/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.util.Collections;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.log4j.LevelMapping;

public final class ConvertedLoggingEvent
extends LoggingEvent {
    private static final long serialVersionUID = -2741722431458191906L;

    public ConvertedLoggingEvent(ExtLogRecord rec) {
        super(rec.getLoggerClassName(), (Category)new DummyCategory(rec.getLoggerName()), rec.getMillis(), LevelMapping.getPriorityFor(rec.getLevel()), (Object)rec.getMessage(), rec.getThreadName(), rec.getThrown() == null ? null : new ThrowableInformation(rec.getThrown()), rec.getNdc(), new LocationInfo(new Throwable(), rec.getLoggerClassName()), Collections.singletonMap("org.jboss.logmanager.record", rec));
    }

    public static ExtLogRecord getLogRecordFor(LoggingEvent event) {
        ExtLogRecord rec = (ExtLogRecord)event.getProperties().get("org.jboss.logmanager.record");
        if (rec != null) {
            return rec;
        }
        ExtLogRecord newRecord = new ExtLogRecord(LevelMapping.getLevelFor((Priority)event.getLevel()), (String)event.getMessage(), event.getFQNOfLoggerClass());
        newRecord.setLoggerName(event.getLoggerName());
        newRecord.setMillis(event.getTimeStamp());
        newRecord.setThreadName(event.getThreadName());
        newRecord.setThrown(event.getThrowableInformation().getThrowable());
        newRecord.setNdc(event.getNDC());
        if (event.locationInformationExists()) {
            LocationInfo locationInfo = event.getLocationInformation();
            newRecord.setSourceClassName(locationInfo.getClassName());
            newRecord.setSourceFileName(locationInfo.getFileName());
            newRecord.setSourceLineNumber(Integer.parseInt(locationInfo.getLineNumber()));
            newRecord.setSourceMethodName(locationInfo.getMethodName());
        }
        return newRecord;
    }

    private static final class DummyCategory
    extends Category {
        protected DummyCategory(String name) {
            super(name);
        }
    }
}

