/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.util.Properties;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class PropsKeyedObjectPoolFactory
extends GenericKeyedObjectPoolFactory {
    private static final Log log = LogFactory.getLog(PropsKeyedObjectPoolFactory.class);

    public PropsKeyedObjectPoolFactory(KeyedPoolableObjectFactory factory, Properties props) {
        super(factory);
        this._maxActive = this.intProp(props, "maxActive", -1);
        this._maxTotal = this.intProp(props, "maxTotal", -1);
        this._maxIdle = this.intProp(props, "maxIdle", -1);
        this._whenExhaustedAction = (byte)this.intProp(props, "whenExhaustedAction", 1);
        this._testOnBorrow = this.booleanProp(props, "testOnBorrow", false);
        this._testOnReturn = this.booleanProp(props, "testOnReturn", false);
        this._timeBetweenEvictionRunsMillis = this.intProp(props, "timeBetweenEvictionRunsMillis", 120000);
        this._minEvictableIdleTimeMillis = this.longProp(props, "minEvictableIdleTimeMillis", 300000L);
        this._numTestsPerEvictionRun = this.intProp(props, "numTestsPerEvictionRun", 3);
        this._testWhileIdle = this.booleanProp(props, "testWhileIdle", true);
        this._minIdle = this.intProp(props, "minIdle", 1);
        this._lifo = this.booleanProp(props, "lifo", true);
    }

    private int intProp(Properties p, String name, int defaultValue) {
        return (Integer)this.getValue(p, name, defaultValue);
    }

    private boolean booleanProp(Properties p, String name, Boolean defaultValue) {
        return (Boolean)this.getValue(p, name, defaultValue);
    }

    private long longProp(Properties p, String name, long defaultValue) {
        return (Long)this.getValue(p, name, defaultValue);
    }

    public Object getValue(Properties p, String name, Object defaultValue) {
        Object propValue = p.get(name);
        if (propValue == null) {
            log.tracef("%s property not specified, using default value (%s)", name, defaultValue);
            return defaultValue;
        }
        log.tracef("%s = %s", name, propValue);
        if (defaultValue instanceof Integer) {
            return Integer.parseInt(propValue.toString());
        }
        if (defaultValue instanceof Boolean) {
            return Boolean.parseBoolean(propValue.toString());
        }
        if (defaultValue instanceof Long) {
            return Long.parseLong(propValue.toString());
        }
        throw new IllegalStateException();
    }
}

