/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.custom;

import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.custom.PropertiesConfigurator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CustomHandlerWriteAttributeHandler
extends AbstractLogHandlerWriteAttributeHandler<Handler> {
    public static final CustomHandlerWriteAttributeHandler INSTANCE = new CustomHandlerWriteAttributeHandler();

    private CustomHandlerWriteAttributeHandler() {
        super(new AttributeDefinition[0]);
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, Handler handler) throws OperationFailedException {
        if ("properties".equals(attributeName)) {
            if (resolvedValue.getType() != ModelType.LIST) {
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidType("properties", ModelType.LIST, resolvedValue.getType())));
            }
            PropertiesConfigurator.setProperties(handler, resolvedValue.asPropertyList());
        }
        return false;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, Handler handler) throws OperationFailedException {
        if ("properties".equals(attributeName)) {
            if (valueToRestore.getType() != ModelType.LIST) {
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidType("properties", ModelType.LIST, valueToRestore.getType())));
            }
            PropertiesConfigurator.setProperties(handler, valueToRestore.asPropertyList());
        }
    }
}

