/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.as.logging.handlers.file.AbstractFileHandlerService;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Values;

public class FileHandlerService
extends AbstractFileHandlerService {
    private final InjectedValue<String> fileName = new InjectedValue();
    private Filter filter;
    private FormatterSpec formatterSpec;
    private Level level;
    private boolean autoflush;
    private String encoding;
    private boolean append;
    private FileHandler value;

    public synchronized void start(StartContext context) throws StartException {
        FileHandler handler;
        this.value = handler = new FileHandler();
        if (this.filter != null) {
            handler.setFilter(this.filter);
        }
        this.formatterSpec.apply((Handler)handler);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
        handler.setAutoFlush(this.autoflush);
        try {
            handler.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
        handler.setAppend(this.append);
        try {
            handler.setFileName((String)this.fileName.getValue());
        }
        catch (FileNotFoundException e) {
            throw new StartException((Throwable)e);
        }
        this.value = handler;
    }

    public synchronized void stop(StopContext context) {
        FileHandler handler = this.value;
        handler.close();
        this.value = null;
    }

    public synchronized FileHandler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    @Override
    public synchronized void setLevel(Level level) {
        this.level = level;
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public synchronized FormatterSpec getFormatterSpec() {
        return this.formatterSpec;
    }

    @Override
    public synchronized void setFormatterSpec(FormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        FileHandler handler = this.value;
        if (handler != null) {
            formatterSpec.apply((Handler)handler);
        }
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.filter = filter;
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setFilter(filter);
        }
    }

    public synchronized boolean isAutoflush() {
        return this.autoflush;
    }

    @Override
    public synchronized void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setAutoFlush(autoflush);
        }
    }

    public synchronized String getEncoding() {
        return this.encoding;
    }

    @Override
    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setEncoding(encoding);
        }
        this.encoding = encoding;
    }

    public synchronized boolean isAppend() {
        return this.append;
    }

    public synchronized void setAppend(boolean append) {
        this.append = append;
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setAppend(append);
        }
    }

    @Override
    public Injector<String> getFileNameInjector() {
        return this.fileName;
    }

    @Override
    public synchronized void setFile(String path) throws FileNotFoundException {
        this.fileName.setValue(Values.immediateValue((Object)path));
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setFileName(path);
        }
    }
}

