/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.Connection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.ws.scout.registry.IRegistryBase;
import org.apache.ws.scout.registry.RegistryImpl;
import org.apache.ws.scout.registry.RegistryServiceImpl;
import org.apache.ws.scout.registry.RegistryV3Impl;

public class ConnectionImpl
implements Connection,
Serializable {
    public static final String JUDDI_CLIENT_CONFIG_FILE = "scout.juddi.client.config.file";
    public static final String DEFAULT_JUDDI_CLIENT_CONFIG_FILE = "META-INF/jaxr-uddi.xml";
    public static final String DEFAULT_UDDI_VERSION = "2.0";
    private static final long serialVersionUID = 3542404895814764176L;
    private static Log log = LogFactory.getLog(ConnectionImpl.class);
    private boolean closed = false;
    private boolean synchronous = true;
    private Set credentials;
    private final IRegistryBase registry;
    private final String postalScheme;
    private final int maxRows;
    private String uddiVersion;
    UDDIClerkManager manager = null;

    public ConnectionImpl(Properties properties) throws InvalidRequestException {
        this.postalScheme = properties.getProperty("javax.xml.registry.postalAddressScheme");
        String val = properties.getProperty("javax.xml.registry.uddi.maxRows");
        this.maxRows = val == null ? -1 : Integer.valueOf(val);
        this.uddiVersion = properties.getProperty("scout.proxy.uddiVersion", DEFAULT_UDDI_VERSION);
        if (!properties.contains("scout.proxy.uddiVersion") && properties.contains("javax.xml.registry.lifeCycleManagerURL") && properties.getProperty("javax.xml.registry.lifeCycleManagerURL").contains("v3")) {
            properties.setProperty("scout.proxy.uddiVersion", "3.0");
            this.uddiVersion = "3.0";
            String securityManager = properties.getProperty("javax.xml.registry.lifeCycleManagerURL").replace("publish", "security");
            properties.setProperty("javax.xml.registry.securityManagerURL", securityManager);
        }
        String uddiConfigFile = properties.getProperty(JUDDI_CLIENT_CONFIG_FILE);
        if (this.isUDDIv3(this.uddiVersion)) {
            String nodeName = null;
            String managerName = null;
            if (this.manager == null && uddiConfigFile != null) {
                try {
                    this.manager = new UDDIClerkManager(uddiConfigFile, properties);
                    this.manager.start();
                }
                catch (ConfigurationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.manager != null) {
                try {
                    managerName = this.manager.getName();
                    nodeName = this.manager.getClientConfig().getHomeNode().getName();
                }
                catch (ConfigurationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.registry = new RegistryV3Impl(properties, nodeName, managerName);
        } else {
            this.registry = new RegistryImpl(properties);
        }
    }

    private boolean isUDDIv3(String version) {
        return version.startsWith("3");
    }

    public RegistryService getRegistryService() throws JAXRException {
        RegistryServiceImpl reg = new RegistryServiceImpl(this.registry, this.postalScheme, this.maxRows, this.uddiVersion);
        reg.setConnection(this);
        return reg;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Set getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

