/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wsse;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.AbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.ws.wss.secext.AttributedString;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;

public class WSSecurityParser
extends AbstractParser {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                String elementName = StaxParserUtil.getStartElementName(startElement);
                if (elementName.equalsIgnoreCase("UsernameToken")) {
                    startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                    UsernameTokenType userNameToken = new UsernameTokenType();
                    QName idQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    Attribute idAttribute = startElement.getAttributeByName(idQName);
                    if (idAttribute == null) {
                        throw new RuntimeException("PL00063: Parser: Required attribute missing: Id");
                    }
                    userNameToken.setId(StaxParserUtil.getAttributeValue(idAttribute));
                    startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:userName");
                    }
                    String userName = StaxParserUtil.getElementText(xmlEventReader);
                    AttributedString attributedString = new AttributedString();
                    attributedString.setValue(userName);
                    userNameToken.setUsername(attributedString);
                    EndElement onBehalfOfEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(onBehalfOfEndElement, "UsernameToken");
                    return userNameToken;
                }
                if (!elementName.equals("SecurityTokenReference")) continue;
                return this.parseSecurityTokenReference(xmlEventReader);
            }
            StaxParserUtil.getNextEvent(xmlEventReader);
        }
        throw new RuntimeException("PL00067: Parsing has failed:");
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nsURI);
    }

    private SecurityTokenReferenceType parseSecurityTokenReference(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "SecurityTokenReference");
        SecurityTokenReferenceType securityTokenRef = new SecurityTokenReferenceType();
        QName tokenType = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType");
        Attribute tokenTypeAttr = startElement.getAttributeByName(tokenType);
        if (tokenTypeAttr != null) {
            tokenType = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", tokenTypeAttr.getName().getPrefix());
            securityTokenRef.addOtherAttribute(tokenType, StaxParserUtil.getAttributeValue(tokenTypeAttr));
        }
        XMLEvent xmlEvent = null;
        EndElement endElement = null;
        String tag = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                endElement = (EndElement)xmlEvent;
                tag = StaxParserUtil.getEndElementName(endElement);
                if (tag.equals("SecurityTokenReference")) {
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName(startElement);
            if (!tag.equals("KeyIdentifier")) continue;
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            KeyIdentifierType keyIdentifierType = new KeyIdentifierType();
            Attribute valueTypeAttr = startElement.getAttributeByName(new QName("ValueType"));
            if (valueTypeAttr != null) {
                keyIdentifierType.setValueType(StaxParserUtil.getAttributeValue(valueTypeAttr));
            }
            keyIdentifierType.setValue(StaxParserUtil.getElementText(xmlEventReader));
            securityTokenRef.addAny(keyIdentifierType);
        }
        return securityTokenRef;
    }
}

