/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.logging.Logger;
import org.jboss.osgi.resolver.v2.XEnvironment;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.spi.AbstractWiring;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;
import org.osgi.framework.resource.Resource;
import org.osgi.framework.resource.Wire;
import org.osgi.framework.resource.Wiring;

public abstract class AbstractEnvironment
implements XEnvironment {
    private static Logger log = Logger.getLogger(AbstractEnvironment.class);
    private final List<XResource> resources = new ArrayList<XResource>();
    private final Map<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();

    protected abstract Comparator<Capability> getComparator();

    @Override
    public synchronized void installResources(Resource ... resarr) {
        for (Resource res : resarr) {
            if (this.resources.contains(res)) {
                throw new IllegalArgumentException("Resource already installed: " + res);
            }
            log.debugf("Install resource: %s", (Object)res);
            this.resources.add((XResource)res);
        }
    }

    @Override
    public synchronized void uninstallResources(Resource ... resarr) {
        for (Resource res : resarr) {
            log.debugf("Uninstall resource: %s", (Object)res);
            this.resources.remove(res);
            this.wirings.remove(res);
        }
    }

    @Override
    public void refreshResources(Resource ... resarr) {
        for (Resource res : resarr) {
            this.wirings.remove(res);
        }
    }

    @Override
    public long getResourceIndex(Resource resource) {
        return this.resources.indexOf(resource);
    }

    @Override
    public Collection<Resource> getResources(String identityType) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (XResource res : this.resources) {
            XIdentityCapability icap = res.getIdentityCapability();
            Object captype = icap.getAttribute("type");
            if (!identityType.equals(captype)) continue;
            result.add(res);
        }
        return result;
    }

    @Override
    public synchronized SortedSet<Capability> findProviders(Requirement req) {
        log.debugf("Find providers: %s", (Object)req);
        TreeSet<Capability> result = new TreeSet<Capability>(this.getComparator());
        for (XResource res : this.resources) {
            for (Capability cap : res.getCapabilities(req.getNamespace())) {
                if (!req.matches(cap)) continue;
                result.add(cap);
            }
        }
        log.debugf("Found providers: %s", result);
        return result;
    }

    @Override
    public synchronized Map<Resource, Wiring> applyResolverResults(Map<Resource, List<Wire>> wiremap) {
        Map<Resource, Wiring> wirings = this.getWiringMap(wiremap);
        this.applyWiringMap(wirings);
        return wirings;
    }

    @Override
    public Wiring createWiring(Resource res, List<Wire> wires) {
        return new AbstractWiring(res, wires);
    }

    @Override
    public Wiring applyWiring(Resource res, Wiring wiring) {
        return wiring;
    }

    @Override
    public boolean isEffective(Requirement req) {
        return true;
    }

    @Override
    public synchronized Wiring getWiring(Resource resource) {
        return this.wirings.get(resource);
    }

    @Override
    public synchronized Map<Resource, Wiring> getWirings() {
        return Collections.unmodifiableMap(this.wirings);
    }

    private Map<Resource, Wiring> getWiringMap(Map<Resource, List<Wire>> wiremap) {
        HashMap<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XResource res = (XResource)entry.getKey();
            List<Wire> wires = entry.getValue();
            AbstractWiring reqwiring = (AbstractWiring)wirings.get(res);
            if (reqwiring == null) {
                reqwiring = (AbstractWiring)this.createWiring(res, wires);
                wirings.put(res, reqwiring);
            }
            for (Wire wire : wires) {
                XResource provider = (XResource)wire.getProvider();
                AbstractWiring provwiring = (AbstractWiring)wirings.get(provider);
                if (provwiring == null) {
                    provwiring = (AbstractWiring)this.createWiring(provider, Collections.EMPTY_LIST);
                    wirings.put(provider, provwiring);
                }
                provwiring.addProvidedWire(wire);
            }
        }
        return wirings;
    }

    private void applyWiringMap(Map<Resource, Wiring> wirings) {
        for (Map.Entry<Resource, Wiring> entry : wirings.entrySet()) {
            XResource res = (XResource)entry.getKey();
            AbstractWiring deltaWiring = (AbstractWiring)entry.getValue();
            AbstractWiring wiring = (AbstractWiring)this.wirings.get(res);
            if (wiring == null) {
                this.wirings.put(res, deltaWiring);
                wiring = deltaWiring;
            } else {
                for (Wire wire : deltaWiring.getProvidedResourceWires(null)) {
                    wiring.addProvidedWire(wire);
                }
            }
            this.applyWiring(res, wiring);
        }
    }
}

