/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.impl.PacketImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterTopologyChangeMessage
extends PacketImpl {
    private static final Logger log = Logger.getLogger(ClusterTopologyChangeMessage.class);
    private boolean exit;
    private String nodeID;
    private Pair<TransportConfiguration, TransportConfiguration> pair;
    private boolean last;

    public ClusterTopologyChangeMessage(String nodeID, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        super((byte)110);
        this.nodeID = nodeID;
        this.pair = pair;
        this.last = last;
        this.exit = false;
    }

    public ClusterTopologyChangeMessage(String nodeID) {
        super((byte)110);
        this.exit = true;
        this.nodeID = nodeID;
    }

    public ClusterTopologyChangeMessage() {
        super((byte)110);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public Pair<TransportConfiguration, TransportConfiguration> getPair() {
        return this.pair;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isExit() {
        return this.exit;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeBoolean(this.exit);
        buffer.writeString(this.nodeID);
        if (!this.exit) {
            if (this.pair.getA() != null) {
                buffer.writeBoolean(true);
                this.pair.getA().encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            if (this.pair.getB() != null) {
                buffer.writeBoolean(true);
                this.pair.getB().encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(this.last);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.exit = buffer.readBoolean();
        this.nodeID = buffer.readString();
        if (!this.exit) {
            TransportConfiguration b;
            TransportConfiguration a;
            boolean hasLive = buffer.readBoolean();
            if (hasLive) {
                a = new TransportConfiguration();
                a.decode(buffer);
            } else {
                a = null;
            }
            boolean hasBackup = buffer.readBoolean();
            if (hasBackup) {
                b = new TransportConfiguration();
                b.decode(buffer);
            } else {
                b = null;
            }
            this.pair = new Pair<TransportConfiguration, TransportConfiguration>(a, b);
            this.last = buffer.readBoolean();
        }
    }
}

