/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeCreateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;

public class EntityBeanEjbCreateMethodInterceptorFactory
implements InterceptorFactory {
    public static final EntityBeanEjbCreateMethodInterceptorFactory INSTANCE = new EntityBeanEjbCreateMethodInterceptorFactory();

    protected EntityBeanEjbCreateMethodInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        final Object existing = context.getContextData().get(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
        final AtomicReference primaryKeyReference = new AtomicReference();
        context.getContextData().put(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, primaryKeyReference);
        final Method ejbCreate = (Method)context.getContextData().get(EntityBeanHomeCreateInterceptorFactory.EJB_CREATE_METHOD_KEY);
        final Method ejbPostCreate = (Method)context.getContextData().get(EntityBeanHomeCreateInterceptorFactory.EJB_POST_CREATE_METHOD_KEY);
        final Object[] params = (Object[])context.getContextData().get(EntityBeanHomeCreateInterceptorFactory.PARAMETERS_KEY);
        return new Interceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                if (existing != null) {
                    primaryKeyReference.set(existing);
                    return existing;
                }
                Component component = (Component)context.getPrivateData(Component.class);
                if (!(component instanceof EntityBeanComponent)) {
                    throw EjbMessages.MESSAGES.unexpectedComponent(component, EntityBeanComponent.class);
                }
                final EntityBeanComponent entityBeanComponent = (EntityBeanComponent)component;
                final EntityBeanComponentInstance instance = entityBeanComponent.acquireUnAssociatedInstance();
                Object primaryKey = EntityBeanEjbCreateMethodInterceptorFactory.this.invokeEjbCreate(context, ejbCreate, instance, params);
                instance.associate(primaryKey);
                primaryKeyReference.set(primaryKey);
                boolean synchronizationRegistered = false;
                boolean exception = false;
                entityBeanComponent.getCache().create(instance);
                try {
                    EntityBeanEjbCreateMethodInterceptorFactory.this.invokeEjbPostCreate(context, ejbPostCreate, instance, params);
                    TransactionSynchronizationRegistry transactionSynchronizationRegistry = entityBeanComponent.getTransactionSynchronizationRegistry();
                    if (transactionSynchronizationRegistry.getTransactionKey() != null) {
                        transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                            public void beforeCompletion() {
                            }

                            public void afterCompletion(int status) {
                                entityBeanComponent.getCache().release(instance, status == 3);
                            }
                        });
                        synchronizationRegistered = true;
                    }
                    Object object = context.proceed();
                    return object;
                }
                catch (Exception e) {
                    entityBeanComponent.getCache().release(instance, false);
                    exception = true;
                    throw e;
                }
                finally {
                    if (!synchronizationRegistered && !exception) {
                        entityBeanComponent.getCache().release(instance, true);
                    }
                }
            }
        };
    }

    protected void invokeEjbPostCreate(InterceptorContext context, Method ejbPostCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        try {
            ejbPostCreate.invoke((Object)instance.getInstance(), params);
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
    }

    protected Object invokeEjbCreate(InterceptorContext context, Method ejbCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        InvocationType invocationType = (InvocationType)context.getPrivateData(InvocationType.class);
        try {
            context.putPrivateData(InvocationType.class, (Object)InvocationType.ENTITY_EJB_CREATE);
            Object object = ejbCreate.invoke((Object)instance.getInstance(), params);
            return object;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
        finally {
            context.putPrivateData(InvocationType.class, (Object)invocationType);
        }
    }
}

