/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainModelUtil;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RemoteDomainControllerAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-remote-domain-controller";
    public static final SimpleAttributeDefinition PORT = new SimpleAttributeDefinitionBuilder("port", ModelType.INT, false).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, 65535, false, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).build();
    public static final SimpleAttributeDefinition HOST = new SimpleAttributeDefinitionBuilder("host", ModelType.STRING, false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).build();
    private final ManagementResourceRegistration rootRegistration;
    private final HostControllerConfigurationPersister overallConfigPersister;
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final ExtensionRegistry extensionRegistry;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;

    public RemoteDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, ContentRepository contentRepository, HostFileRepository fileRepository, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry) {
        this.rootRegistration = rootRegistration;
        this.overallConfigPersister = overallConfigPersister;
        this.contentRepository = contentRepository;
        this.fileRepository = fileRepository;
        this.hostControllerInfo = hostControllerInfo;
        this.extensionRegistry = extensionRegistry;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        ModelNode remoteDC = dc.get("remote");
        PORT.validateAndSet(operation, remoteDC);
        HOST.validateAndSet(operation, remoteDC);
        if (operation.has("security-realm")) {
            ModelNode securityRealm = operation.require("security-realm");
            dc.get(new String[]{"remote", "security-realm"}).set(securityRealm);
            this.hostControllerInfo.setRemoteDomainControllerSecurityRealm(securityRealm.resolve().asString());
        }
        if (dc.has("local")) {
            dc.remove("local");
        }
        this.initializeDomain(context, remoteDC);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void initializeDomain(OperationContext context, ModelNode remoteDC) throws OperationFailedException {
        this.hostControllerInfo.setMasterDomainController(false);
        this.hostControllerInfo.setRemoteDomainControllerHost(HOST.resolveModelAttribute(context, remoteDC).asString());
        this.hostControllerInfo.setRemoteDomainControllerPort(PORT.resolveModelAttribute(context, remoteDC).asInt());
        this.overallConfigPersister.initializeDomainConfigurationPersister(true);
        DomainModelUtil.initializeSlaveDomainRegistry(this.rootRegistration, this.overallConfigPersister.getDomainPersister(), this.contentRepository, this.fileRepository, this.hostControllerInfo, this.extensionRegistry, this.ignoredDomainResourceRegistry);
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getRemoteDomainControllerAdd(locale);
    }
}

