/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.CommonXml;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.host.controller.JvmType;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JvmXml {
    public static void parseJvm(XMLExtendedStreamReader reader, ModelNode parentAddress, Namespace expectedNs, List<ModelNode> updates, Set<String> jvmNames) throws XMLStreamException {
        JvmXml.parseJvm(reader, parentAddress, expectedNs, updates, jvmNames, false);
    }

    public static void parseJvm(XMLExtendedStreamReader reader, ModelNode parentAddress, Namespace expectedNs, List<ModelNode> updates, Set<String> jvmNames, boolean server) throws XMLStreamException {
        ArrayList<ModelNode> attrUpdates = new ArrayList<ModelNode>();
        String name = null;
        String type = null;
        String home = null;
        Boolean debugEnabled = null;
        String debugOptions = null;
        Boolean envClasspathIgnored = null;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    }
                    if (!jvmNames.add(value)) {
                        throw ControllerMessages.MESSAGES.duplicateDeclaration("JVM", value, reader.getLocation());
                    }
                    name = value;
                    continue block20;
                }
                case JAVA_HOME: {
                    if (home != null) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    }
                    home = value;
                    ModelNode update = Util.getWriteAttributeOperation(null, (String)"java-home", (String)home);
                    attrUpdates.add(update);
                    continue block20;
                }
                case TYPE: {
                    try {
                        Enum.valueOf(JvmType.class, value);
                        type = value;
                        continue block20;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case DEBUG_ENABLED: {
                    if (!server) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    if (debugEnabled != null) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    }
                    debugEnabled = Boolean.valueOf(value);
                    ModelNode update = Util.getWriteAttributeOperation(null, (String)"debug-enabled", (boolean)debugEnabled);
                    attrUpdates.add(update);
                    continue block20;
                }
                case DEBUG_OPTIONS: {
                    if (!server) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    if (debugOptions != null) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    }
                    debugOptions = value;
                    ModelNode update = Util.getWriteAttributeOperation(null, (String)"debug-options", (String)debugOptions);
                    attrUpdates.add(update);
                    continue block20;
                }
                case ENV_CLASSPATH_IGNORED: {
                    if (envClasspathIgnored != null) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    }
                    envClasspathIgnored = Boolean.valueOf(value);
                    ModelNode update = Util.getWriteAttributeOperation(null, (String)"env-classpath-ignored", (boolean)envClasspathIgnored);
                    attrUpdates.add(update);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (debugEnabled != null && debugOptions == null && debugEnabled.booleanValue()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEBUG_OPTIONS));
        }
        ModelNode address = parentAddress.clone();
        address.add("jvm", name);
        ModelNode addUpdate = Util.getEmptyOperation((String)"add", (ModelNode)address);
        if (type != null) {
            addUpdate.get("type").set(type);
        }
        updates.add(addUpdate);
        for (ModelNode attrUpdate : attrUpdates) {
            attrUpdate.get("address").set(address);
            updates.add(attrUpdate);
        }
        boolean hasJvmOptions = false;
        boolean hasEnvironmentVariables = false;
        block22: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HEAP: {
                    JvmXml.parseHeap(reader, address, updates);
                    continue block22;
                }
                case PERMGEN: {
                    JvmXml.parsePermgen(reader, address, updates);
                    continue block22;
                }
                case STACK: {
                    JvmXml.parseStack(reader, address, updates);
                    continue block22;
                }
                case AGENT_LIB: {
                    JvmXml.parseAgentLib(reader, address, updates);
                    continue block22;
                }
                case AGENT_PATH: {
                    JvmXml.parseAgentPath(reader, address, updates);
                    continue block22;
                }
                case JAVA_AGENT: {
                    JvmXml.parseJavaagent(reader, address, updates);
                    continue block22;
                }
                case ENVIRONMENT_VARIABLES: {
                    if (hasEnvironmentVariables) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    updates.add(Util.getWriteAttributeOperation((ModelNode)address, (String)"environment-variables", (ModelNode)CommonXml.parseProperties((XMLExtendedStreamReader)reader, (Namespace)expectedNs)));
                    hasEnvironmentVariables = true;
                    continue block22;
                }
                case JVM_OPTIONS: {
                    if (hasJvmOptions) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    JvmXml.parseJvmOptions(reader, address, expectedNs, updates);
                    hasJvmOptions = true;
                    continue block22;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseHeap(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String size = null;
        String maxSize = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block4;
                }
                case MAX_SIZE: {
                    maxSize = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (size != null) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"heap-size", size);
            updates.add(update);
        }
        if (maxSize != null) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"max-heap-size", maxSize);
            updates.add(update);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parsePermgen(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String size = null;
        String maxSize = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block4;
                }
                case MAX_SIZE: {
                    maxSize = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (size != null) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"permgen-size", size);
            updates.add(update);
        }
        if (maxSize != null) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"max-permgen-size", maxSize);
            updates.add(update);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseStack(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean sizeSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"stack-size", (String)value);
                    updates.add(update);
                    sizeSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!sizeSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SIZE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseAgentLib(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"agent-lib", (String)value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseAgentPath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"agent-path", (String)value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseJavaagent(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"java-agent", (String)value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseJvmOptions(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean optionSet = false;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (element == Element.OPTION) {
                String option = null;
                int count = reader.getAttributeCount();
                block4: for (int i = 0; i < count; ++i) {
                    String attrValue = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case VALUE: {
                            option = attrValue;
                            continue block4;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                if (option == null) {
                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                }
                ModelNode update = new ModelNode();
                update.get("address").set(address);
                update.get("operation").set("add-jvm-option");
                update.get("jvm-option").set(option);
                updates.add(update);
                optionSet = true;
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!optionSet) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.OPTION));
        }
    }

    public static void writeJVMElement(XMLExtendedStreamWriter writer, String jvmName, ModelNode jvmElement) throws XMLStreamException {
        writer.writeStartElement(Element.JVM.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), jvmName);
        if (jvmElement.hasDefined("type")) {
            writer.writeAttribute(Attribute.TYPE.getLocalName(), jvmElement.get("type").asString());
        }
        if (jvmElement.hasDefined("java-home")) {
            writer.writeAttribute(Attribute.JAVA_HOME.getLocalName(), jvmElement.get("java-home").asString());
        }
        if (jvmElement.hasDefined("debug-enabled")) {
            writer.writeAttribute(Attribute.DEBUG_ENABLED.getLocalName(), jvmElement.get("debug-enabled").asString());
        }
        if (jvmElement.hasDefined("debug-options")) {
            if (!jvmElement.hasDefined("debug-enabled")) {
                writer.writeAttribute(Attribute.DEBUG_ENABLED.getLocalName(), "false");
            }
            writer.writeAttribute(Attribute.DEBUG_OPTIONS.getLocalName(), jvmElement.get("debug-options").asString());
        }
        if (jvmElement.hasDefined("env-classpath-ignored")) {
            writer.writeAttribute(Attribute.ENV_CLASSPATH_IGNORED.getLocalName(), jvmElement.get("env-classpath-ignored").asString());
        }
        if (jvmElement.hasDefined("heap-size") || jvmElement.hasDefined("max-heap-size")) {
            writer.writeEmptyElement(Element.HEAP.getLocalName());
            if (jvmElement.hasDefined("heap-size")) {
                writer.writeAttribute(Attribute.SIZE.getLocalName(), jvmElement.get("heap-size").asString());
            }
            if (jvmElement.hasDefined("max-heap-size")) {
                writer.writeAttribute(Attribute.MAX_SIZE.getLocalName(), jvmElement.get("max-heap-size").asString());
            }
        }
        if (jvmElement.hasDefined("permgen-size") || jvmElement.hasDefined("max-permgen-size")) {
            writer.writeEmptyElement(Element.PERMGEN.getLocalName());
            if (jvmElement.hasDefined("permgen-size")) {
                writer.writeAttribute(Attribute.SIZE.getLocalName(), jvmElement.get("permgen-size").asString());
            }
            if (jvmElement.hasDefined("max-permgen-size")) {
                writer.writeAttribute(Attribute.MAX_SIZE.getLocalName(), jvmElement.get("max-permgen-size").asString());
            }
        }
        if (jvmElement.hasDefined("stack-size")) {
            writer.writeEmptyElement(Element.STACK.getLocalName());
            writer.writeAttribute(Attribute.SIZE.getLocalName(), jvmElement.get("stack-size").asString());
        }
        if (jvmElement.hasDefined("agent-lib")) {
            writer.writeEmptyElement(Element.AGENT_LIB.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("agent-lib").asString());
        }
        if (jvmElement.hasDefined("agent-path")) {
            writer.writeEmptyElement(Element.AGENT_PATH.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("agent-path").asString());
        }
        if (jvmElement.hasDefined("java-agent")) {
            writer.writeEmptyElement(Element.JAVA_AGENT.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("java-agent").asString());
        }
        if (jvmElement.hasDefined("jvm-options")) {
            writer.writeStartElement(Element.JVM_OPTIONS.getLocalName());
            for (ModelNode option : jvmElement.get("jvm-options").asList()) {
                writer.writeEmptyElement(Element.OPTION.getLocalName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), option.asString());
            }
            writer.writeEndElement();
        }
        if (jvmElement.hasDefined("environment-variables")) {
            writer.writeStartElement(Element.ENVIRONMENT_VARIABLES.getLocalName());
            for (Property variable : jvmElement.get("environment-variables").asPropertyList()) {
                writer.writeEmptyElement(Element.VARIABLE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), variable.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), variable.getValue().asString());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

