/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxrpc;

import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.metadata.umdm.OperationMetaData;

public class WSAddressingServerHandler
extends GenericHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSAddressingServerHandler.class);
    private static Logger log = Logger.getLogger(WSAddressingServerHandler.class);
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;
    private static QName[] HEADERS;

    public QName[] getHeaders() {
        return HEADERS;
    }

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
    }

    public boolean handleRequest(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleRequest");
        }
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        addrProps.readHeaders(soapMessage);
        msgContext.setProperty("javax.xml.ws.addressing.context.inbound", (Object)addrProps);
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleResponse");
        }
        this.handleResponseOrFault(msgContext, false);
        return true;
    }

    public boolean handleFault(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleFault");
        }
        this.handleResponseOrFault(msgContext, true);
        return true;
    }

    private void handleResponseOrFault(MessageContext msgContext, boolean isFault) {
        SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
        SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
        if (outProps == null) {
            outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
            msgContext.setProperty("javax.xml.ws.addressing.context.outbound", (Object)outProps);
        }
        outProps.initializeAsReply(inProps, isFault);
        try {
            OperationMetaData opMetaData = ((SOAPMessageContextJAXRPC)msgContext).getOperationMetaData();
            if (!isFault && !opMetaData.isOneWay()) {
                AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
                if (addrExt != null) {
                    outProps.setAction(ADDR_BUILDER.newURI(addrExt.getOutboundAction()));
                } else {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_RESOLVE_REPLYACTION", (Object[])new Object[]{opMetaData.getQName()}));
                }
            } else if (isFault) {
                outProps.setAction(ADDR_BUILDER.newURI(ADDR_CONSTANTS.getDefaultFaultAction()));
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_SETTING_RESPONSE_ACTION", (Object[])new Object[0]), (Throwable)e);
        }
        outProps.writeHeaders(soapMessage);
    }

    static {
        HEADERS = new QName[2];
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
        WSAddressingServerHandler.HEADERS[0] = ADDR_CONSTANTS.getActionQName();
        WSAddressingServerHandler.HEADERS[1] = ADDR_CONSTANTS.getToQName();
    }
}

